<?php

namespace SolidAffiliate\Views\AffiliatePortal;

use SolidAffiliate\Controllers\AffiliatesController;
use SolidAffiliate\Lib\Settings;
use SolidAffiliate\Lib\URLs;
use SolidAffiliate\Lib\Validators;


/**
 * @psalm-import-type EnumOptionsReturnType from \SolidAffiliate\Lib\VO\SchemaEntry
 */
class AffiliatePortalTabsView
{
    const AFFILIATE_PORTAL_TABS_FILTER = 'solid_affiliate/affiliate_portal/tabs';
    const AFFILIATE_PORTAL_TAB_ICON_FILTER = 'solid_affiliate/affiliate_portal/tab_icon';


    /**
     * Undocumented function
     * 
     * @param array<array{0:string, 1:string}> $tab_tuples - examples: [['settings', 'Admin Settings'], ['extra', 'Extra Settings']]
     * @param string|null $current_tab
     * @param string|null $add_element_id_to_tab_url
     * @param array{'is_admin_preview':bool, 'affiliate_id':int}|null $is_admin_preview_tuple
     * 
     * @return string
     */
    public static function render($tab_tuples, $current_tab, $add_element_id_to_tab_url = null, $is_admin_preview_tuple = null)
    {
        $tab_tuples = self::get_filtered_tab_tuples($tab_tuples);

        ////////////////////////////
        // remove any tabs that are hidden in the settings
        $tabs_to_hide = Validators::array_of_string(Settings::get(Settings::KEY_AFFILIATE_PORTAL_TABS_TO_HIDE));
        // $tab_tuples = array_filter($tab_tuples, function ($tuple) use ($tabs_to_hide) {
        //     $tab_key = $tuple[0];
        //     return !in_array($tab_key, $tabs_to_hide);
        // });
        ////////////////////////////


        $is_admin_preview = $is_admin_preview_tuple && $is_admin_preview_tuple['is_admin_preview'];

        ob_start();
?>
        <div class="sld-ap-nav">
            <ul class="sld-ap-nav_menu">
                <!-- Here are our tabs -->
                <?php
                // Just set the first tab as the default.
                // TODO make Default tab be active in the render (ajax)
                // $default_tab_key = $tab_tuples[0][0];

                foreach ($tab_tuples as $tuple) {
                    list($tab_key, $tab_display_value) = $tuple;
                    $icon = self::get_tab_icon($tab_key);
                    $href_url = "?tab={$tab_key}";
                    if ($is_admin_preview && $is_admin_preview_tuple['affiliate_id']) {
                        $href_url = $href_url . '&page=solid-affiliate-affiliates&action=' . AffiliatesController::ADMIN_PREVIEW_AFFILIATE_PORTAL_ACTION . '&id=' . $is_admin_preview_tuple['affiliate_id'];
                    }
                    if (URLs::get_permalink_format_setting() === 'plain' && !$is_admin_preview) {
                        $href_url = add_query_arg('tab', $tab_key, get_permalink());
                    }
                    // We do this so the browser doesn't jump back to the top with every tab click.
                    if (Settings::get(Settings::KEY_AFFILIATE_PORTAL_IS_ANCHOR_TAG_ENABLED) && !$is_admin_preview) {
                        $href_url = is_null($add_element_id_to_tab_url) ? $href_url : ($href_url . '#' . $add_element_id_to_tab_url);
                    }

                    // We need to add the "sld-hidden-tab" class to the li element if the tab is hidden.
                    // This is because the tab is still rendered, but we don't want it to be visible.
                    $is_tab_hidden = in_array($tab_key, $tabs_to_hide);
                    $li_class = $is_tab_hidden ? 'sld-hide-tab' : '';
                ?>
                    <li class="<?php echo ($li_class) ?>">
                        <a id="sld-ap-nav_menu-link_<?php echo $tab_key ?>" href="<?php echo $href_url; ?>" :class="{ 'active': current_tab === '<?php echo $tab_key ?>' }" @click.prevent="if (current_tab != '<?php echo $tab_key ?>') { current_tab = '<?php echo $tab_key ?>'; window.updateTabAndPageInURL('<?php echo $tab_key ?>')};">
                            <?php echo ($icon) ?>
                            <span class="sld-ap-nav_menu-title"><?php echo $tab_display_value ?></span>
                        </a>
                    </li>
                <?php
                }
                ?>
            </ul>
         </div>

<?php
        return ob_get_clean();
    }

    /**
     * Undocumented function
     * 
     * @param string $tab_key
     *
     * @return string
     */
    public static function get_tab_icon($tab_key)
    {
        switch ($tab_key) {
            case 'dashboard':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M2.16675 2.66663C2.16675 2.39048 2.39061 2.16663 2.66675 2.16663H6.66675C6.94289 2.16663 7.16675 2.39048 7.16675 2.66663V7.99996C7.16675 8.2761 6.94289 8.49996 6.66675 8.49996H2.66675C2.39061 8.49996 2.16675 8.2761 2.16675 7.99996V2.66663ZM3.16675 3.16663V7.49996H6.16675V3.16663H3.16675ZM8.83341 2.66663C8.83341 2.39048 9.05727 2.16663 9.33341 2.16663H13.3334C13.6096 2.16663 13.8334 2.39048 13.8334 2.66663V5.33329C13.8334 5.60944 13.6096 5.83329 13.3334 5.83329H9.33341C9.05727 5.83329 8.83341 5.60944 8.83341 5.33329V2.66663ZM9.83341 3.16663V4.83329H12.8334V3.16663H9.83341ZM8.83341 7.99996C8.83341 7.72382 9.05727 7.49996 9.33341 7.49996H13.3334C13.6096 7.49996 13.8334 7.72382 13.8334 7.99996V13.3333C13.8334 13.6094 13.6096 13.8333 13.3334 13.8333H9.33341C9.05727 13.8333 8.83341 13.6094 8.83341 13.3333V7.99996ZM9.83341 8.49996V12.8333H12.8334V8.49996H9.83341ZM2.16675 10.6666C2.16675 10.3905 2.39061 10.1666 2.66675 10.1666H6.66675C6.94289 10.1666 7.16675 10.3905 7.16675 10.6666V13.3333C7.16675 13.6094 6.94289 13.8333 6.66675 13.8333H2.66675C2.39061 13.8333 2.16675 13.6094 2.16675 13.3333V10.6666ZM3.16675 11.1666V12.8333H6.16675V11.1666H3.16675Z" fill="black"/>
                </svg>
                ';
            case 'referrals':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M2.16675 2C2.16675 1.72386 2.39061 1.5 2.66675 1.5H4.00008C4.27622 1.5 4.50008 1.72386 4.50008 2V2.86777L13.369 3.50127C13.5074 3.51116 13.6355 3.5781 13.7226 3.68609C13.8097 3.79408 13.848 3.93342 13.8284 4.07076L13.445 6.7521C13.406 7.02546 13.1527 7.21538 12.8793 7.1763C12.606 7.13722 12.416 6.88393 12.4551 6.61057L12.7625 4.46049L4.50008 3.87032V8.16667H9.66675C9.94289 8.16667 10.1667 8.39052 10.1667 8.66667C10.1667 8.94281 9.94289 9.16667 9.66675 9.16667H4.50008V10.8333H8.66675C8.94289 10.8333 9.16675 11.0572 9.16675 11.3333C9.16675 11.6095 8.94289 11.8333 8.66675 11.8333H5.63308C5.76355 12.089 5.83341 12.3742 5.83341 12.6667C5.83341 13.1529 5.64026 13.6192 5.29644 13.963C4.95263 14.3068 4.48631 14.5 4.00008 14.5C3.51385 14.5 3.04754 14.3068 2.70372 13.963C2.3599 13.6192 2.16675 13.1529 2.16675 12.6667C2.16675 12.1804 2.3599 11.7141 2.70372 11.3703C2.92691 11.1471 3.20171 10.9874 3.50008 10.9028V3.3385C3.50005 3.3354 3.50005 3.33231 3.50008 3.3292V2.5H2.66675C2.39061 2.5 2.16675 2.27614 2.16675 2ZM4.00008 11.8333C3.77907 11.8333 3.56711 11.9211 3.41083 12.0774C3.25455 12.2337 3.16675 12.4457 3.16675 12.6667C3.16675 12.8877 3.25455 13.0996 3.41083 13.2559C3.56711 13.4122 3.77907 13.5 4.00008 13.5C4.22109 13.5 4.43306 13.4122 4.58934 13.2559C4.74562 13.0996 4.83341 12.8877 4.83341 12.6667C4.83341 12.4457 4.74562 12.2337 4.58934 12.0774C4.43306 11.9211 4.22109 11.8333 4.00008 11.8333ZM12.6667 8.83333C12.9429 8.83333 13.1667 9.05719 13.1667 9.33333V9.5H14.0001C14.2762 9.5 14.5001 9.72386 14.5001 10C14.5001 10.2761 14.2762 10.5 14.0001 10.5H12.3334C12.2008 10.5 12.0736 10.5527 11.9799 10.6464C11.8861 10.7402 11.8334 10.8674 11.8334 11C11.8334 11.1326 11.8861 11.2598 11.9799 11.3536C12.0736 11.4473 12.2008 11.5 12.3334 11.5H13.0001C13.3979 11.5 13.7794 11.658 14.0607 11.9393C14.342 12.2206 14.5001 12.6022 14.5001 13C14.5001 13.3978 14.342 13.7794 14.0607 14.0607C13.819 14.3024 13.5033 14.4531 13.1667 14.4907V14.6667C13.1667 14.9428 12.9429 15.1667 12.6667 15.1667C12.3906 15.1667 12.1667 14.9428 12.1667 14.6667V14.5H11.3334C11.0573 14.5 10.8334 14.2761 10.8334 14C10.8334 13.7239 11.0573 13.5 11.3334 13.5H13.0001C13.1327 13.5 13.2599 13.4473 13.3536 13.3536C13.4474 13.2598 13.5001 13.1326 13.5001 13C13.5001 12.8674 13.4474 12.7402 13.3536 12.6464C13.2599 12.5527 13.1327 12.5 13.0001 12.5H12.3334C11.9356 12.5 11.5541 12.342 11.2728 12.0607C10.9915 11.7794 10.8334 11.3978 10.8334 11C10.8334 10.6022 10.9915 10.2206 11.2728 9.93934C11.5145 9.6976 11.8302 9.5469 12.1667 9.50928V9.33333C12.1667 9.05719 12.3906 8.83333 12.6667 8.83333Z" fill="black"/>
                </svg>
                ';
            case 'visits':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.00008 3.16663C3.77907 3.16663 3.56711 3.25442 3.41083 3.4107C3.25455 3.56698 3.16675 3.77895 3.16675 3.99996V5.33329C3.16675 5.60944 2.94289 5.83329 2.66675 5.83329C2.39061 5.83329 2.16675 5.60944 2.16675 5.33329V3.99996C2.16675 3.51373 2.3599 3.04741 2.70372 2.7036C3.04754 2.35978 3.51385 2.16663 4.00008 2.16663H5.33341C5.60956 2.16663 5.83341 2.39048 5.83341 2.66663C5.83341 2.94277 5.60956 3.16663 5.33341 3.16663H4.00008ZM10.1667 2.66663C10.1667 2.39048 10.3906 2.16663 10.6667 2.16663H12.0001C12.4863 2.16663 12.9526 2.35978 13.2964 2.7036C13.6403 3.04741 13.8334 3.51373 13.8334 3.99996V5.33329C13.8334 5.60944 13.6096 5.83329 13.3334 5.83329C13.0573 5.83329 12.8334 5.60944 12.8334 5.33329V3.99996C12.8334 3.77895 12.7456 3.56698 12.5893 3.4107C12.4331 3.25442 12.2211 3.16663 12.0001 3.16663H10.6667C10.3906 3.16663 10.1667 2.94277 10.1667 2.66663ZM6.70372 4.7036C7.04754 4.35978 7.51385 4.16663 8.00008 4.16663C8.48631 4.16663 8.95263 4.35978 9.29644 4.7036C9.64026 5.04741 9.83341 5.51373 9.83341 5.99996C9.83341 6.48619 9.64026 6.95251 9.29644 7.29632C8.95263 7.64014 8.48631 7.83329 8.00008 7.83329C7.51385 7.83329 7.04754 7.64014 6.70372 7.29632C6.3599 6.95251 6.16675 6.48619 6.16675 5.99996C6.16675 5.51373 6.3599 5.04741 6.70372 4.7036ZM8.00008 5.16663C7.77907 5.16663 7.56711 5.25442 7.41083 5.4107C7.25455 5.56698 7.16675 5.77895 7.16675 5.99996C7.16675 6.22097 7.25455 6.43293 7.41083 6.58921C7.56711 6.7455 7.77907 6.83329 8.00008 6.83329C8.22109 6.83329 8.43306 6.7455 8.58934 6.58921C8.74562 6.43293 8.83341 6.22097 8.83341 5.99996C8.83341 5.77895 8.74562 5.56698 8.58934 5.4107C8.43306 5.25442 8.2211 5.16663 8.00008 5.16663ZM6.66675 9.83329C6.44573 9.83329 6.23377 9.92109 6.07749 10.0774C5.92121 10.2337 5.83341 10.4456 5.83341 10.6666C5.83341 10.9428 5.60956 11.1666 5.33341 11.1666C5.05727 11.1666 4.83341 10.9428 4.83341 10.6666C4.83341 10.1804 5.02657 9.71408 5.37039 9.37026C5.7142 9.02645 6.18052 8.83329 6.66675 8.83329H9.33341C9.81965 8.83329 10.286 9.02645 10.6298 9.37026C10.9736 9.71408 11.1667 10.1804 11.1667 10.6666C11.1667 10.9428 10.9429 11.1666 10.6667 11.1666C10.3906 11.1666 10.1667 10.9428 10.1667 10.6666C10.1667 10.4456 10.079 10.2337 9.92267 10.0774C9.76639 9.92109 9.55443 9.83329 9.33341 9.83329H6.66675ZM2.66675 10.1666C2.94289 10.1666 3.16675 10.3905 3.16675 10.6666V12C3.16675 12.221 3.25455 12.4329 3.41083 12.5892C3.56711 12.7455 3.77907 12.8333 4.00008 12.8333H5.33341C5.60956 12.8333 5.83341 13.0572 5.83341 13.3333C5.83341 13.6094 5.60956 13.8333 5.33341 13.8333H4.00008C3.51385 13.8333 3.04754 13.6401 2.70372 13.2963C2.3599 12.9525 2.16675 12.4862 2.16675 12V10.6666C2.16675 10.3905 2.39061 10.1666 2.66675 10.1666ZM13.3334 10.1666C13.6096 10.1666 13.8334 10.3905 13.8334 10.6666V12C13.8334 12.4862 13.6403 12.9525 13.2964 13.2963C12.9526 13.6401 12.4863 13.8333 12.0001 13.8333H10.6667C10.3906 13.8333 10.1667 13.6094 10.1667 13.3333C10.1667 13.0572 10.3906 12.8333 10.6667 12.8333H12.0001C12.2211 12.8333 12.4331 12.7455 12.5893 12.5892C12.7456 12.4329 12.8334 12.221 12.8334 12V10.6666C12.8334 10.3905 13.0573 10.1666 13.3334 10.1666Z" fill="black"/>
                </svg>
                ';
            case 'payouts':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M2.03697 3.37034C2.38079 3.02653 2.8471 2.83337 3.33333 2.83337H10C10.4862 2.83337 10.9525 3.02653 11.2964 3.37034C11.6402 3.71416 11.8333 4.18048 11.8333 4.66671V5.50004H12.6667C13.1529 5.50004 13.6192 5.6932 13.963 6.03701C14.3068 6.38083 14.5 6.84714 14.5 7.33337V11.3334C14.5 11.8196 14.3068 12.2859 13.963 12.6297C13.6192 12.9736 13.1529 13.1667 12.6667 13.1667H6C5.51377 13.1667 5.04745 12.9736 4.70364 12.6297C4.35982 12.2859 4.16667 11.8196 4.16667 11.3334V10.5H3.33333C2.8471 10.5 2.38079 10.3069 2.03697 9.96307C1.69315 9.61925 1.5 9.15294 1.5 8.66671V4.66671C1.5 4.18048 1.69315 3.71416 2.03697 3.37034ZM5.16667 11.3334C5.16667 11.5544 5.25446 11.7663 5.41074 11.9226C5.56702 12.0789 5.77899 12.1667 6 12.1667H12.6667C12.8877 12.1667 13.0996 12.0789 13.2559 11.9226C13.4122 11.7663 13.5 11.5544 13.5 11.3334V7.33337C13.5 7.11236 13.4122 6.9004 13.2559 6.74412C13.0996 6.58784 12.8877 6.50004 12.6667 6.50004H6C5.77899 6.50004 5.56702 6.58784 5.41074 6.74412C5.25446 6.9004 5.16667 7.11236 5.16667 7.33337V11.3334ZM10.8333 5.50004H6C5.51377 5.50004 5.04745 5.6932 4.70364 6.03701C4.35982 6.38083 4.16667 6.84714 4.16667 7.33337V9.50004H3.33333C3.11232 9.50004 2.90036 9.41224 2.74408 9.25596C2.5878 9.09968 2.5 8.88772 2.5 8.66671V4.66671C2.5 4.44569 2.5878 4.23373 2.74408 4.07745C2.90036 3.92117 3.11232 3.83337 3.33333 3.83337H10C10.221 3.83337 10.433 3.92117 10.5893 4.07745C10.7455 4.23373 10.8333 4.44569 10.8333 4.66671V5.50004ZM8.03697 8.03701C8.38079 7.6932 8.8471 7.50004 9.33333 7.50004C9.81956 7.50004 10.2859 7.6932 10.6297 8.03701C10.9735 8.38083 11.1667 8.84714 11.1667 9.33337C11.1667 9.8196 10.9735 10.2859 10.6297 10.6297C10.2859 10.9736 9.81956 11.1667 9.33333 11.1667C8.8471 11.1667 8.38079 10.9736 8.03697 10.6297C7.69315 10.2859 7.5 9.8196 7.5 9.33337C7.5 8.84714 7.69315 8.38083 8.03697 8.03701ZM9.33333 8.50004C9.11232 8.50004 8.90036 8.58784 8.74408 8.74412C8.5878 8.9004 8.5 9.11236 8.5 9.33337C8.5 9.55439 8.5878 9.76635 8.74408 9.92263C8.90036 10.0789 9.11232 10.1667 9.33333 10.1667C9.55435 10.1667 9.76631 10.0789 9.92259 9.92263C10.0789 9.76635 10.1667 9.55439 10.1667 9.33337C10.1667 9.11236 10.0789 8.9004 9.92259 8.74412C9.76631 8.58784 9.55435 8.50004 9.33333 8.50004Z" fill="black"/>
                </svg>
                ';
            case 'coupons':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.33333 3.83337C3.11232 3.83337 2.90036 3.92117 2.74408 4.07745C2.5878 4.23373 2.5 4.44569 2.5 4.66671V6.2362C2.79837 6.32079 3.07317 6.48049 3.29636 6.70368C3.64018 7.04749 3.83333 7.51381 3.83333 8.00004C3.83333 8.48627 3.64018 8.95259 3.29636 9.2964C3.07317 9.51959 2.79837 9.67929 2.5 9.76388V11.3334C2.5 11.5544 2.5878 11.7663 2.74408 11.9226C2.90036 12.0789 3.11232 12.1667 3.33333 12.1667H9.5V11.3334C9.5 11.0572 9.72386 10.8334 10 10.8334C10.2761 10.8334 10.5 11.0572 10.5 11.3334V12.1667H12.6667C12.8877 12.1667 13.0996 12.0789 13.2559 11.9226C13.4122 11.7663 13.5 11.5544 13.5 11.3334V9.76388C13.2016 9.67929 12.9268 9.51959 12.7036 9.2964C12.3598 8.95259 12.1667 8.48627 12.1667 8.00004C12.1667 7.51381 12.3598 7.04749 12.7036 6.70368C12.9268 6.48049 13.2016 6.32079 13.5 6.2362V4.66671C13.5 4.44569 13.4122 4.23373 13.2559 4.07745C13.0996 3.92117 12.8877 3.83337 12.6667 3.83337H10.5V4.66671C10.5 4.94285 10.2761 5.16671 10 5.16671C9.72386 5.16671 9.5 4.94285 9.5 4.66671V3.83337H3.33333ZM3.33333 2.83337C2.8471 2.83337 2.38079 3.02653 2.03697 3.37034C1.69315 3.71416 1.5 4.18048 1.5 4.66671V6.66671C1.5 6.94285 1.72386 7.16671 2 7.16671C2.22101 7.16671 2.43298 7.2545 2.58926 7.41079C2.74554 7.56707 2.83333 7.77903 2.83333 8.00004C2.83333 8.22105 2.74554 8.43302 2.58926 8.5893C2.43298 8.74558 2.22101 8.83337 2 8.83337C1.72386 8.83337 1.5 9.05723 1.5 9.33337V11.3334C1.5 11.8196 1.69315 12.2859 2.03697 12.6297C2.38079 12.9736 2.8471 13.1667 3.33333 13.1667H12.6667C13.1529 13.1667 13.6192 12.9736 13.963 12.6297C14.3068 12.2859 14.5 11.8196 14.5 11.3334V9.33337C14.5 9.05723 14.2761 8.83337 14 8.83337C13.779 8.83337 13.567 8.74558 13.4107 8.5893C13.2545 8.43301 13.1667 8.22105 13.1667 8.00004C13.1667 7.77903 13.2545 7.56707 13.4107 7.41079C13.567 7.2545 13.779 7.16671 14 7.16671C14.2761 7.16671 14.5 6.94285 14.5 6.66671V4.66671C14.5 4.18048 14.3068 3.71416 13.963 3.37034C13.6192 3.02653 13.1529 2.83337 12.6667 2.83337H3.33333ZM10 6.83337C10.2761 6.83337 10.5 7.05723 10.5 7.33337V8.66671C10.5 8.94285 10.2761 9.16671 10 9.16671C9.72386 9.16671 9.5 8.94285 9.5 8.66671V7.33337C9.5 7.05723 9.72386 6.83337 10 6.83337Z" fill="black"/>
                </svg>
                ';
            case 'creatives':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.00008 3.16663C3.77907 3.16663 3.56711 3.25442 3.41083 3.4107C3.25455 3.56698 3.16675 3.77895 3.16675 3.99996V5.33329C3.16675 5.60944 2.94289 5.83329 2.66675 5.83329C2.39061 5.83329 2.16675 5.60944 2.16675 5.33329V3.99996C2.16675 3.51373 2.3599 3.04741 2.70372 2.7036C3.04754 2.35978 3.51385 2.16663 4.00008 2.16663H5.33341C5.60956 2.16663 5.83341 2.39048 5.83341 2.66663C5.83341 2.94277 5.60956 3.16663 5.33341 3.16663H4.00008ZM10.1667 2.66663C10.1667 2.39048 10.3906 2.16663 10.6667 2.16663H12.0001C12.4863 2.16663 12.9526 2.35978 13.2964 2.7036C13.6403 3.04741 13.8334 3.51373 13.8334 3.99996V5.33329C13.8334 5.60944 13.6096 5.83329 13.3334 5.83329C13.0573 5.83329 12.8334 5.60944 12.8334 5.33329V3.99996C12.8334 3.77895 12.7456 3.56698 12.5893 3.4107C12.4331 3.25442 12.2211 3.16663 12.0001 3.16663H10.6667C10.3906 3.16663 10.1667 2.94277 10.1667 2.66663ZM9.50008 5.33329C9.50008 5.05715 9.72394 4.83329 10.0001 4.83329H10.0067C10.2829 4.83329 10.5067 5.05715 10.5067 5.33329C10.5067 5.60944 10.2829 5.83329 10.0067 5.83329H10.0001C9.72394 5.83329 9.50008 5.60944 9.50008 5.33329ZM6.33341 7.16744C6.29312 7.16744 6.25322 7.17538 6.21599 7.19081C6.17877 7.20624 6.14495 7.22885 6.11647 7.25736L4.35363 9.02019C4.15837 9.21546 3.84179 9.21546 3.64653 9.02019C3.45127 8.82493 3.45127 8.50835 3.64653 8.31309L5.40903 6.55059C5.40908 6.55053 5.40897 6.55064 5.40903 6.55059C5.53035 6.4292 5.67455 6.33273 5.83309 6.26702C5.9917 6.20128 6.16172 6.16744 6.33341 6.16744C6.50511 6.16744 6.67513 6.20128 6.83374 6.26702C6.99228 6.33273 7.13632 6.42903 7.25763 6.55042C7.25769 6.55048 7.25758 6.55037 7.25763 6.55042L8.66675 7.95954L9.40903 7.21725C9.53038 7.09579 9.67448 6.99943 9.83309 6.93369C9.9917 6.86795 10.1617 6.83411 10.3334 6.83411C10.5051 6.83411 10.6751 6.86795 10.8337 6.93369C10.9923 6.9994 11.1363 7.0957 11.2576 7.21709C11.2577 7.21714 11.2576 7.21703 11.2576 7.21709L12.3536 8.31309C12.5489 8.50835 12.5489 8.82493 12.3536 9.0202C12.1584 9.21546 11.8418 9.21546 11.6465 9.02019L10.5505 7.92419C10.522 7.89569 10.4881 7.87291 10.4508 7.85748C10.4136 7.84205 10.3737 7.83411 10.3334 7.83411C10.2931 7.83411 10.2532 7.84205 10.216 7.85748C10.1788 7.87291 10.1449 7.89552 10.1165 7.92403L9.37385 8.66664L9.68697 8.97975C9.88223 9.17502 9.88223 9.4916 9.68697 9.68686C9.49171 9.88212 9.17512 9.88212 8.97986 9.68686L6.55053 7.25753C6.52205 7.22902 6.48806 7.20624 6.45084 7.19081C6.41361 7.17538 6.37371 7.16744 6.33341 7.16744ZM2.66675 10.1666C2.94289 10.1666 3.16675 10.3905 3.16675 10.6666V12C3.16675 12.221 3.25455 12.4329 3.41083 12.5892C3.56711 12.7455 3.77907 12.8333 4.00008 12.8333H5.33341C5.60956 12.8333 5.83341 13.0572 5.83341 13.3333C5.83341 13.6094 5.60956 13.8333 5.33341 13.8333H4.00008C3.51385 13.8333 3.04754 13.6401 2.70372 13.2963C2.3599 12.9525 2.16675 12.4862 2.16675 12V10.6666C2.16675 10.3905 2.39061 10.1666 2.66675 10.1666ZM13.3334 10.1666C13.6096 10.1666 13.8334 10.3905 13.8334 10.6666V12C13.8334 12.4862 13.6403 12.9525 13.2964 13.2963C12.9526 13.6401 12.4863 13.8333 12.0001 13.8333H10.6667C10.3906 13.8333 10.1667 13.6094 10.1667 13.3333C10.1667 13.0572 10.3906 12.8333 10.6667 12.8333H12.0001C12.2211 12.8333 12.4331 12.7455 12.5893 12.5892C12.7456 12.4329 12.8334 12.221 12.8334 12V10.6666C12.8334 10.3905 13.0573 10.1666 13.3334 10.1666Z" fill="black"/>
                </svg>
                ';
            case 'urls':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.76083 2.4275C6.35469 1.83363 7.16015 1.5 8 1.5C8.83985 1.5 9.64531 1.83363 10.2392 2.4275C10.833 3.02136 11.1667 3.82681 11.1667 4.66667C11.1667 5.50652 10.833 6.31197 10.2392 6.90584C9.64531 7.4997 8.83985 7.83333 8 7.83333C7.16015 7.83333 6.35469 7.4997 5.76083 6.90584C5.16696 6.31197 4.83333 5.50652 4.83333 4.66667C4.83333 3.82681 5.16696 3.02136 5.76083 2.4275ZM8 2.5C7.42536 2.5 6.87426 2.72827 6.46794 3.1346C6.06161 3.54093 5.83333 4.09203 5.83333 4.66667C5.83333 5.2413 6.06161 5.7924 6.46794 6.19873C6.87426 6.60506 7.42536 6.83333 8 6.83333C8.57464 6.83333 9.12574 6.60506 9.53207 6.19873C9.93839 5.7924 10.1667 5.2413 10.1667 4.66667C10.1667 4.09203 9.93839 3.54093 9.53207 3.1346C9.12574 2.72827 8.57464 2.5 8 2.5ZM6.66667 10.5C6.09203 10.5 5.54093 10.7283 5.1346 11.1346C4.72827 11.5409 4.5 12.092 4.5 12.6667V14C4.5 14.2761 4.27614 14.5 4 14.5C3.72386 14.5 3.5 14.2761 3.5 14V12.6667C3.5 11.8268 3.83363 11.0214 4.4275 10.4275C5.02136 9.83363 5.82681 9.5 6.66667 9.5H8.66667C8.94281 9.5 9.16667 9.72386 9.16667 10C9.16667 10.2761 8.94281 10.5 8.66667 10.5H6.66667ZM10.5 11.3333C10.5 11.0572 10.7239 10.8333 11 10.8333H14C14.2761 10.8333 14.5 11.0572 14.5 11.3333V14.3333C14.5 14.6095 14.2761 14.8333 14 14.8333C13.7239 14.8333 13.5 14.6095 13.5 14.3333V12.5404L11.0202 15.0202C10.825 15.2155 10.5084 15.2155 10.3131 15.0202C10.1179 14.825 10.1179 14.5084 10.3131 14.3131L12.7929 11.8333H11C10.7239 11.8333 10.5 11.6095 10.5 11.3333Z" fill="black"/>
                </svg>
                ';
            case 'settings':
                return '
                <svg class="sld-ap-nav_menu-icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M8.63076 2.99588C8.47036 2.33471 7.52964 2.33471 7.36924 2.99588L7.36918 2.99614C7.1052 4.08168 5.86457 4.59627 4.90891 4.01523L4.90866 4.01508C4.3269 3.6609 3.66169 4.32681 4.01567 4.90787C4.15079 5.12954 4.23168 5.37999 4.25175 5.63883C4.27182 5.89773 4.23048 6.15771 4.13109 6.39761C4.0317 6.63751 3.87706 6.85056 3.67977 7.0194C3.48252 7.18822 3.2482 7.30808 2.99588 7.36924C2.33471 7.52964 2.33471 8.47036 2.99588 8.63076L2.99615 8.63083C3.2483 8.69214 3.48242 8.81209 3.67949 8.98092C3.87655 9.14976 4.031 9.3627 4.13028 9.60246C4.22955 9.84222 4.27086 10.102 4.25083 10.3607C4.2308 10.6195 4.15001 10.8698 4.01502 11.0914C3.66097 11.6732 4.32684 12.3383 4.90787 11.9843C5.12954 11.8492 5.37999 11.7683 5.63883 11.7482C5.89773 11.7282 6.15771 11.7695 6.39761 11.8689C6.63751 11.9683 6.85056 12.1229 7.0194 12.3202C7.18822 12.5175 7.30808 12.7518 7.36924 13.0041C7.52964 13.6653 8.47036 13.6653 8.63076 13.0041L8.63083 13.0039C8.69214 12.7517 8.81209 12.5176 8.98092 12.3205C9.14976 12.1234 9.3627 11.969 9.60246 11.8697C9.84222 11.7704 10.102 11.7291 10.3607 11.7492C10.6195 11.7692 10.8698 11.85 11.0914 11.985C11.6732 12.339 12.3383 11.6732 11.9843 11.0921C11.8492 10.8705 11.7683 10.62 11.7482 10.3612C11.7282 10.1023 11.7695 9.84229 11.8689 9.60239C11.9683 9.36249 12.1229 9.14944 12.3202 8.9806C12.5175 8.81178 12.7518 8.69192 13.0041 8.63076C13.6653 8.47036 13.6653 7.52964 13.0041 7.36924L13.0039 7.36917C12.7517 7.30786 12.5176 7.18791 12.3205 7.01908C12.1234 6.85024 11.969 6.6373 11.8697 6.39754C11.7704 6.15778 11.7291 5.89799 11.7492 5.63926C11.7692 5.38054 11.85 5.13019 11.985 4.90857C12.339 4.32683 11.6732 3.66171 11.0921 4.01567C10.8705 4.15079 10.62 4.23168 10.3612 4.25175C10.1023 4.27182 9.84229 4.23048 9.60239 4.13109C9.36249 4.0317 9.14944 3.87706 8.9806 3.67977C8.81178 3.48252 8.69192 3.2482 8.63076 2.99588ZM6.39749 2.75986C6.80528 1.07996 9.19499 1.08005 9.60257 2.76012L9.60261 2.76026C9.62668 2.85962 9.67387 2.95189 9.74035 3.02956C9.80682 3.10723 9.8907 3.16811 9.98515 3.20724C10.0796 3.24637 10.1819 3.26264 10.2839 3.25474C10.3858 3.24684 10.4844 3.21498 10.5717 3.16176L10.5719 3.16166C12.0481 2.26231 13.7382 3.95176 12.8391 5.42868L12.839 5.42877C12.7859 5.51602 12.7541 5.61458 12.7462 5.71644C12.7383 5.81829 12.7546 5.92057 12.7936 6.01497C12.8327 6.10936 12.8935 6.19319 12.9711 6.25966C13.0486 6.32607 13.1407 6.37327 13.2399 6.39743C14.92 6.80503 14.92 9.19497 13.2399 9.60257L13.2397 9.60261C13.1404 9.62668 13.0481 9.67388 12.9704 9.74035C12.8928 9.80682 12.8319 9.8907 12.7928 9.98515C12.7536 10.0796 12.7374 10.1819 12.7453 10.2839C12.7532 10.3858 12.785 10.4844 12.8382 10.5717L12.8383 10.5719C13.7377 12.0481 12.0482 13.7382 10.5713 12.8391L10.5712 12.839C10.484 12.7859 10.3854 12.7541 10.2836 12.7462C10.1817 12.7383 10.0794 12.7546 9.98503 12.7936C9.89064 12.8327 9.80681 12.8935 9.74034 12.9711C9.67393 13.0486 9.62673 13.1407 9.60257 13.2399C9.19497 14.92 6.80503 14.92 6.39743 13.2399L6.39739 13.2397C6.37332 13.1404 6.32613 13.0481 6.25965 12.9704C6.19318 12.8928 6.1093 12.8319 6.01486 12.7928C5.92041 12.7536 5.81805 12.7374 5.71613 12.7453C5.6142 12.7532 5.51558 12.785 5.42829 12.8382L5.42813 12.8383C3.95185 13.7377 2.26177 12.0482 3.16092 10.5713L3.16098 10.5712C3.21412 10.484 3.24593 10.3854 3.25381 10.2836C3.2617 10.1817 3.24544 10.0794 3.20635 9.98503C3.16727 9.89064 3.10646 9.80681 3.02888 9.74034C2.95136 9.67393 2.85929 9.62673 2.76012 9.60257C1.07996 9.19497 1.07996 6.80503 2.76012 6.39743L2.76026 6.39739C2.85962 6.37332 2.95189 6.32613 3.02956 6.25965C3.10723 6.19318 3.16811 6.1093 3.20724 6.01486C3.24637 5.92041 3.26264 5.81805 3.25474 5.71613C3.24684 5.6142 3.21498 5.51558 3.16176 5.42829L3.16166 5.42813C2.26236 3.95194 3.95157 2.26196 5.42842 3.16077C5.80602 3.39035 6.29326 3.18773 6.39743 2.76012M6.23223 6.23223C6.70107 5.76339 7.33696 5.5 8 5.5C8.66304 5.5 9.29893 5.76339 9.76777 6.23223C10.2366 6.70107 10.5 7.33696 10.5 8C10.5 8.66304 10.2366 9.29893 9.76777 9.76777C9.29893 10.2366 8.66304 10.5 8 10.5C7.33696 10.5 6.70107 10.2366 6.23223 9.76777C5.76339 9.29893 5.5 8.66304 5.5 8C5.5 7.33696 5.76339 6.70107 6.23223 6.23223ZM8 6.5C7.60217 6.5 7.22064 6.65804 6.93934 6.93934C6.65804 7.22064 6.5 7.60217 6.5 8C6.5 8.39783 6.65804 8.77936 6.93934 9.06066C7.22064 9.34196 7.60217 9.5 8 9.5C8.39783 9.5 8.77936 9.34196 9.06066 9.06066C9.34196 8.77936 9.5 8.39783 9.5 8C9.5 7.60217 9.34196 7.22064 9.06066 6.93934C8.77936 6.65804 8.39783 6.5 8 6.5Z" fill="black"/>
                </svg>
                ';

            default:
                # code...
                break;
        }
        return Validators::str(apply_filters(self::AFFILIATE_PORTAL_TAB_ICON_FILTER, '[]', $tab_key));
    }

    /**
     * @param EnumOptionsReturnType $tab_tuples
     * 
     * @return EnumOptionsReturnType
     */
    public static function get_filtered_tab_tuples($tab_tuples)
    {
        return Validators::enum_options_array(apply_filters(self::AFFILIATE_PORTAL_TABS_FILTER, $tab_tuples));
    }
}
