<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH Product Description in Loop for WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'YITH_PDIL_Admin' ) ) {

	/**
	 * Class YITH_PDIL_Admin
	 */
	class YITH_PDIL_Admin {

		/**
		 * Single instance of the class
		 *
		 * @var \YITH_PDIL_Admin
		 * @since 1.0.0
		 */
		protected static $instance;

		/**
		 * Panel object
		 *
		 * @var     /Yit_Plugin_Panel object
		 * @since   1.0.0
		 * @see     plugin-fw/lib/yit-plugin-panel.php
		 */
		protected $_panel = null;


		/**
		 * YITH Product Description in Loop for WooCommerce panel page
		 *
		 * @var string $_panel_page
		 */
		protected $_panel_page = 'yith-product-description-in-loop';

		/**
		 * Returns single instance of the class
		 *
		 * @return \YITH_PDIL_Admin
		 * @since 1.0.0
		 */
		public static function get_instance() {
			return ! is_null( self::$instance ) ? self::$instance : self::$instance = new self();
		}

		/**
		 * Constructor
		 *
		 * @author Francesco Grasso - frangrasso@yithemes.com
		 * @since   1.0.0
		 * @return  void
		 */
		private function __construct() {

			add_filter(
				'plugin_action_links_' . plugin_basename( YITH_PDIL_DIR . '/' . basename( YITH_PDIL_FILE ) ),
				array(
					$this,
					'action_links',
				)
			);
			add_filter( 'yith_show_plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 5 );

			add_action( 'admin_menu', array( $this, 'add_menu_page' ), 5 );

			// register metabox.
			add_action( 'admin_init', array( $this, 'add_metabox' ), 1 );

			// admin css.
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_css' ), 10 );

		}

		/**
		 * Action Links
		 *
		 * Add the action links to plugin admin page
		 *
		 * @since   1.0.0
		 *
		 * @param   array $links | links plugin array.
		 *
		 * @return  array
		 */
		public function action_links( $links ) {

			$links = yith_add_action_links( $links, $this->_panel_page, true, YITH_PDIL_SLUG );

			return $links;

		}

		/**
		 * Plugin row meta
		 *
		 * Add the action links to plugin admin page
		 *
		 * @since   1.0.0
		 *
		 * @param   $new_row_meta_args
		 * @param   $plugin_meta
		 * @param   $plugin_file
		 * @param   $plugin_data
		 * @param   $status
		 * @param   $init_file
		 *
		 * @return  array
		 * @author  Andrea Grillo <andrea.grillo@yithemes.com>
		 * @use     plugin_row_meta
		 */
		public function plugin_row_meta( $new_row_meta_args, $plugin_meta, $plugin_file, $plugin_data, $status, $init_file = 'YITH_PDIL_INIT' ) {

			if ( defined( $init_file ) && constant( $init_file ) == $plugin_file ) {
				$new_row_meta_args['slug']       = YITH_PDIL_SLUG;
				$new_row_meta_args['is_premium'] = true;
			}

			return $new_row_meta_args;

		}

		/**
		 * Add a panel under YITH Plugins tab
		 *
		 * @since   1.0.0
		 * @return  void
		 * @use     /Yit_Plugin_Panel class
		 * @see     plugin-fw/lib/yit-plugin-panel.php
		 */
		public function add_menu_page() {

			if ( ! empty( $this->_panel ) ) {
				return;
			}

			$admin_tabs = array(
				'general' => esc_html_x( 'General Settings', 'general', 'yith-product-description-in-loop-for-woocommerce' ),
				'style'   => esc_html_x( 'Style Settings', 'style', 'yith-product-description-in-loop-for-woocommerce' ),
			);

			$args = array(
				'create_menu_page' => true,
				'parent_slug'      => '',
				'page_title'       => esc_html_x( 'Product Description in Loop', 'plugin name in admin page title', 'yith-product-description-in-loop-for-woocommerce' ),
				'menu_title'       => esc_html_x( 'Product Description in Loop', 'plugin menu title in admin page', 'yith-product-description-in-loop-for-woocommerce' ),
				'capability'       => 'manage_options',
				'parent'           => 'product_loop_description',
				'parent_page'      => 'yith_plugin_panel',
				'page'             => $this->_panel_page,
				'admin-tabs'       => $admin_tabs,
				'options-path'     => YITH_PDIL_DIR . 'plugin-options',
			);

			$this->_panel = new YIT_Plugin_Panel( $args );

		}

		/**
		 * Add metabox inside products
		 */
		public function add_metabox() {

			global $pagenow;
			$post = isset( $_REQUEST['post'] ) ? $_REQUEST['post'] : ( isset( $_REQUEST['post_ID'] ) ? $_REQUEST['post_ID'] : 0 );
			$post = get_post( $post );
			if ( ( $post && 'product' == $post->post_type ) || ( 'post-new.php' == $pagenow && isset( $_REQUEST['post_type'] ) && 'product' == $_REQUEST['post_type'] ) ) {
				$editor_type = YITH_PDIL_Settings()->yith_pdil_get_option( 'advanced_editor', 'no' );
				$editor_type = 'yes' == $editor_type ? 'textarea-editor' : 'textarea';
				$args        = array(
					'label'    => esc_html__( 'Product Description in Loop', 'yith-product-description-in-loop-for-woocommerce' ),
					'pages'    => 'product',
					'context'  => 'normal',
					'priority' => 'default',
					'tabs'     => array(
						'yith_pdil_settings' => array(
							'label'  => esc_html__( 'Loop Description', 'yith-product-description-in-loop-for-woocommerce' ),
							'fields' => apply_filters(
								'yith_pdil_metabox_fields',
								array(
									'yith_pdil_description' => array(
										'label'         => esc_html__( 'Description', 'yith-product-description-in-loop-for-woocommerce' ),
										'desc'          => esc_html__( 'Write here your loop specific product description. (no links allowed)', 'yith-product-description-in-loop-for-woocommerce' ),
										'type'          => $editor_type,
										'std'           => '',
										'media_buttons' => false,
										'teeny'         => true,
										'quicktags'     => false,
									),
								)
							),
						),
					),
				);
				if ( ! function_exists( 'YIT_Metabox' ) ) {
					require_once 'plugin-fw/yit-plugin.php';
				}
				$metabox = YIT_Metabox( 'yith_product_loop_description' );
				$metabox->init( $args );
			}

		}

		/**
		 * Load admin CSS
		 */
		public function admin_css() {
			if ( 'yes' == YITH_PDIL_Settings()->yith_pdil_get_option( 'advanced_editor', 'yes' ) ) {
				wp_enqueue_style( 'yith_pdil_admin', YITH_PDIL_ASSETS_URL . '/admin.css', array(), YITH_PDIL_VERSION );
			}
		}
	}

}

/**
 * Unique access to instance of YITH_PDIL_Admin class
 *
 * @return \YITH_PDIL_Admin
 * @since 1.0.0
 */
function YITH_PDIL_Admin() {
	return YITH_PDIL_Admin::get_instance();
}
