<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH Product Description in Loop for WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'YITH_PDIL_Settings' ) ) {

	/**
	 * Class YITH_PDIL_Settings
	 */
	class YITH_PDIL_Settings {

		/**
		 * Options array
		 *
		 * @var $_options array options array
		 */
		private $_options = array();

		/**
		 * Single instance of the class
		 *
		 * @var \YITH_PDIL_Settings
		 * @since 1.0.0
		 */
		protected static $instance;

		/**
		 * Returns single instance of the class
		 *
		 * @return \YITH_PDIL_Settings
		 * @since 1.0.0
		 */
		public static function get_instance() {
			return ! is_null( self::$instance ) ? self::$instance : self::$instance = new self();
		}

		/**
		 * Constructor
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		private function __construct() {
		}

		/**
		 * Load plugin options
		 *
		 * @since   1.0.0
		 *
		 * @param   $parent
		 *
		 * @return  array
		 */
		private function get_options( $parent ) {
			if ( ! isset( $this->_options[ $parent ] ) ) {
				$this->_options[ $parent ] = get_option( "yit_{$parent}_options" );
			}

			return $this->_options[ $parent ];
		}

		/**
		 * Get selected option
		 *
		 * @since   1.0.0
		 *
		 * @param   $parent
		 * @param   $key
		 * @param   $default
		 *
		 * @return  mixed
		 */
		public function get_option( $parent, $key, $default = false ) {
			$options = $this->get_options( $parent );

			return is_array( $options ) && array_key_exists( $key, $options ) ? $options[ $key ] : $default;
		}

		/**
		 * Get option.
		 *
		 * @param string $option Option name.
		 * @param mixed  $default Default option value.
		 *
		 * @return mixed
		 */
		public function yith_pdil_get_option( $option, $default = false ) {
			return $this->get_option( 'product_loop_description', $option, $default );
		}


	}

}

/**
 * Unique access to instance of YITH_PDIL_Settings class
 *
 * @return \YITH_PDIL_Settings
 * @since 1.0.0
 */
function YITH_PDIL_Settings() {
	return YITH_PDIL_Settings::get_instance();
}
