<?php
/**
 * Main class
 *
 * @author YITH
 * @package YITH Product Description in Loop for WooCommerce
 * @version 1.0.0
 */

if ( ! defined( 'YITH_PDIL' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'YITH_PDIL' ) ) {

	/**
	 * Class YITH_PDIL
	 */
	class YITH_PDIL {

		/**
		 * Single instance of the class
		 *
		 * @var \YITH_PDIL
		 * @since 1.0.0
		 */
		protected static $instance;

		/**
		 * Returns single instance of the class
		 *
		 * @return \YITH_PDIL
		 * @since 1.0.0
		 */
		public static function get_instance() {
			return ! is_null( self::$instance ) ? self::$instance : self::$instance = new self();
		}

		/**
		 * Constructor
		 *
		 * @since   1.0.0
		 * @return  void
		 * @author  Francesco Grasso - francgrasso@yithemes.com
		 */
		public function __construct() {

			// Load plugin framework.
			add_action( 'plugins_loaded', array( $this, 'plugin_fw_loader' ), 12 );

			// register plugin to licence/update system.
			add_action( 'wp_loaded', array( $this, 'register_plugin_for_activation' ), 99 );
			add_action( 'admin_init', array( $this, 'register_plugin_for_updates' ) );

			$this->includes();
		}

		/**
		 * Files inclusion
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		private function includes() {
			// both.
			include_once YITH_PDIL_DIR . 'includes/class-yith-pdil-settings.php';

			if ( is_admin() ) { // only in admin area.
				include_once YITH_PDIL_DIR . 'includes/class-yith-pdil-admin.php';
				YITH_PDIL_Admin();
			} else { // only in frontend area.
				include_once YITH_PDIL_DIR . 'includes/class-yith-pdil-frontend.php';
				YITH_PDIL_Frontend();
			}

		}

		/**
		 * YITH FRAMEWORK
		 */

		/**
		 * Load plugin framework
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		public function plugin_fw_loader() {

			if ( ! defined( 'YIT_CORE_PLUGIN' ) ) {

				global $plugin_fw_data;

				if ( ! empty( $plugin_fw_data ) ) {

					$plugin_fw_file = array_shift( $plugin_fw_data );
					require_once $plugin_fw_file;

				}
			}

		}

		/**
		 * Register plugins for activation tab
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		public function register_plugin_for_activation() {
			if ( ! class_exists( 'YIT_Plugin_Licence' ) ) {
				require_once 'plugin-fw/licence/lib/yit-licence.php';
				require_once 'plugin-fw/licence/lib/yit-plugin-licence.php';
			}
			YIT_Plugin_Licence()->register( YITH_PDIL_INIT, YITH_PDIL_SECRET_KEY, YITH_PDIL_SLUG );
		}

		/**
		 * Register plugins for update tab
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		public function register_plugin_for_updates() {
			if ( ! class_exists( 'YIT_Upgrade' ) ) {
				require_once 'plugin-fw/lib/yit-upgrade.php';
			}
			YIT_Upgrade()->register( YITH_PDIL_SLUG, YITH_PDIL_INIT );
		}

	}

}

/**
 * Unique access to instance of YITH_PDIL class
 *
 * @return \YITH_PDIL
 * @since 1.0.0
 */
function YITH_PDIL() {
	return YITH_PDIL::get_instance();
}
