<?php
/**
 * Plugin Name: YITH Product Description in Loop for WooCommerce
 * Plugin URI: https://yithemes.com
 * Description: The <code><strong>YITH Product Description in Loop for WooCommerce</strong></code> plugin allow you to display a specific description text in loop pages. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>.
 * Version: 1.0.16
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-product-description-in-loop-for-woocommerce
 * Domain Path: /languages/
 * WC requires at least: 3.8.0
 * WC tested up to: 5.0
 *
 * @author YITH
 * @package YITH Product Description in Loop for WooCommerce
 * @version 1.0.16
 */

/**
 * Copyright 2020  Your Inspiration Solutions  (email : plugins@yithemes.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

/**
 * Add admin notice if WooCommerce is not installed
 */
function yith_pdil_install_woocommerce_admin_notice() {
	?>
	<div class="error">
		<p><?php esc_html_e( 'YITH Product Description in Loop for WooCommerce is enabled but not effective. It requires WooCommerce in order to work.', 'yith-product-description-in-loop-for-woocommerce' ); ?></p>
	</div>
	<?php
}


if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}
register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );


if ( ! defined( 'YITH_PDIL_VERSION' ) ) {
	define( 'YITH_PDIL_VERSION', '1.0.16' );
}

if ( ! defined( 'YITH_PDIL_PREMIUM' ) ) {
	define( 'YITH_PDIL_PREMIUM', '1' );
}

if ( ! defined( 'YITH_PDIL' ) ) {
	define( 'YITH_PDIL', true );
}

if ( ! defined( 'YITH_PDIL_FILE' ) ) {
	define( 'YITH_PDIL_FILE', __FILE__ );
}

if ( ! defined( 'YITH_PDIL_URL' ) ) {
	define( 'YITH_PDIL_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'YITH_PDIL_DIR' ) ) {
	define( 'YITH_PDIL_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'YITH_PDIL_TEMPLATE_PATH' ) ) {
	define( 'YITH_PDIL_TEMPLATE_PATH', YITH_PDIL_DIR . 'templates' );
}

if ( ! defined( 'YITH_PDIL_ASSETS_URL' ) ) {
	define( 'YITH_PDIL_ASSETS_URL', YITH_PDIL_URL . 'assets' );
}

if ( ! defined( 'YITH_PDIL_INIT' ) ) {
	define( 'YITH_PDIL_INIT', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'YITH_PDIL_SLUG' ) ) {
	define( 'YITH_PDIL_SLUG', 'yith-product-description-in-loop-for-woocommerce' );
}

if ( ! defined( 'YITH_PDIL_SECRET_KEY' ) ) {
	define( 'YITH_PDIL_SECRET_KEY', 'qIg0MfaojNgs3M4cNCvT' );
}

/* Plugin Framework Version Check */
if ( ! function_exists( 'yit_maybe_plugin_fw_loader' ) && file_exists( YITH_PDIL_DIR . 'plugin-fw/init.php' ) ) {
	require_once YITH_PDIL_DIR . 'plugin-fw/init.php';
}
yit_maybe_plugin_fw_loader( YITH_PDIL_DIR );

/**
 * Check if the plugin may be enabled or not
 */
function yith_pdil_install() {

	if ( ! function_exists( 'WC' ) ) {
		add_action( 'admin_notices', 'yith_pdil_install_woocommerce_admin_notice' );
	} else {
		do_action( 'yith_pdil_init' );
	}
}

add_action( 'plugins_loaded', 'yith_pdil_install', 11 );

/**
 * Init the plugin
 *
 * @uses YITH_PDIL::$instance
 */
function yith_pdil_init() {

	load_plugin_textdomain( 'yith-product-description-in-loop-for-woocommerce', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

	// Load required classes and functions.
	require_once 'includes/class-yith-pdil.php';

	// Let's start the game!
	YITH_PDIL();
}

add_action( 'yith_pdil_init', 'yith_pdil_init' );
