<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH Product Description in Loop for WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


return array(
	'general' => array(

		'home'     => array(
			array(
				'name' => esc_html__( 'YITH Product Description in Loop for WooCommerce - General Settings', 'yith-product-description-in-loop-for-woocommerce' ),
				'type' => 'title',
			),
			array(
				'type' => 'close',
			),
		),

		'settings' => array(
			array(
				'name' => esc_html__( 'Enable description on every loop', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Enable this option to show the product description on every loop in your site', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'description_in_all_loops',
				'type' => 'on-off',
				'std'  => 'no',
			),
			array(
				'name' => esc_html__( 'Enable description on Shop page', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Enable this option to show the product description on the Shop page', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'description_in_shop_page',
				'type' => 'on-off',
				'std'  => 'yes',
				'deps' => array(
					'ids'    => 'description_in_all_loops',
					'values' => 'no',
				),
			),
			array(
				'name' => esc_html__( 'Enable description on category pages', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Enable this option to show the product description on the category pages', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'description_in_category_page',
				'type' => 'on-off',
				'std'  => 'no',
				'deps' => array(
					'ids'    => 'description_in_all_loops',
					'values' => 'no',
				),
			),
			array(
				'name' => esc_html__( 'Enable description on tag pages', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Enable this option to show the product description on the tag pages', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'description_in_tag_page',
				'type' => 'on-off',
				'std'  => 'no',
				'deps' => array(
					'ids'    => 'description_in_all_loops',
					'values' => 'no',
				),
			),
			array(
				'name' => esc_html__( 'Use enhanced text editor', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Enable this option to use the enhanced editor (with bold, underline and similar settings). If you disable this option you can limit the word count.', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'advanced_editor',
				'type' => 'on-off',
				'std'  => 'yes',
			),
			array(
				'name' => esc_html__( 'Limit words in description', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Set the maximum number of words to display in loop description. Default to 55 words. (Set "-1" to keep all the text)', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'limit_words',
				'type' => 'number',
				'std'  => '55',
				'deps' => array(
					'ids'    => 'advanced_editor',
					'values' => 'no',
				),
			),
			array(
				'name'    => esc_html__( 'Description position', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc'    => esc_html__( 'Specify where to show the description. Custom position available too.', 'yith-product-description-in-loop-for-woocommerce' ),
				'type'    => 'select',
				'id'      => 'description_position',
				'options' => array(
					'before_title'       => esc_html__( 'Before the product title', 'yith-product-description-in-loop-for-woocommerce' ),
					'after_title'        => esc_html__( 'After the product title', 'yith-product-description-in-loop-for-woocommerce' ),
					'before_price'       => esc_html__( 'Before the product price', 'yith-product-description-in-loop-for-woocommerce' ),
					'after_price'        => esc_html__( 'After the product price', 'yith-product-description-in-loop-for-woocommerce' ),
					'before_rating'      => esc_html__( 'Before the product rating', 'yith-product-description-in-loop-for-woocommerce' ),
					'after_rating'       => esc_html__( 'After the product rating', 'yith-product-description-in-loop-for-woocommerce' ),
					'before_add_to_cart' => esc_html__( 'Before the product "add to cart" button', 'yith-product-description-in-loop-for-woocommerce' ),
					'after_add_to_cart'  => esc_html__( 'After the product "add to cart" button', 'yith-product-description-in-loop-for-woocommerce' ),
					'custom'             => esc_html__( 'Custom position', 'yith-product-description-in-loop-for-woocommerce' ),
				),

			),
			array(
				'name' => esc_html__( 'Hook', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => sprintf( '%s <a href="https://docs.woocommerce.com/document/template-structure/">https://docs.woocommerce.com/document/template-structure/</a>', esc_html__( 'Write here your custom hook. WooCommerce official documentation available here: ', 'yith-product-description-in-loop-for-woocommerce' ) ),
				'id'   => 'custom_hook',
				'type' => 'text',
				'std'  => '',
				'deps' => array(
					'ids'    => 'description_position',
					'values' => 'custom',
				),
			),
			array(
				'name' => esc_html__( 'Priority', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => sprintf( '%s <a href="https://docs.woocommerce.com/document/template-structure/">https://docs.woocommerce.com/document/template-structure/</a>', esc_html__( 'Write here your custom priority. WooCommerce official documentation available here: ', 'yith-product-description-in-loop-for-woocommerce' ) ),
				'id'   => 'custom_priority',
				'type' => 'number',
				'std'  => '10',
				'deps' => array(
					'ids'    => 'description_position',
					'values' => 'custom',
				),
			),

		),
	),
);
