<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH Product Description in Loop for WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


return array(
	'style' => array(

		'home'     => array(
			array(
				'name' => esc_html__( 'YITH Product Description in Loop for WooCommerce - Style Options', 'yith-product-description-in-loop-for-woocommerce' ),
				'type' => 'title',
			),
			array(
				'type' => 'close',
			),
		),

		'settings' => array(
			array(
				'name' => esc_html__( 'Enable plugin style', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Enable this option to customize the appearance of descriptions', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'use_plugin_style',
				'type' => 'on-off',
				'std'  => 'no',
			),
			array(
				'name'    => esc_html__( 'Text alignment', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc'    => esc_html__( 'Choose the description text alignment', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'      => 'text_alignment',
				'type'    => 'radio',
				'options' => array(
					'left'   => esc_html__( 'Left', 'yith-product-description-in-loop-for-woocommerce' ),
					'right'  => esc_html__( 'Right', 'yith-product-description-in-loop-for-woocommerce' ),
					'center' => esc_html__( 'Center', 'yith-product-description-in-loop-for-woocommerce' ),
				),
				'std'     => 'left',
			),

			array(
				'name' => esc_html__( 'Font size', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Choose the font size. (Default: 16px)', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'font_size',
				'type' => 'slider',
				'std'  => '16',
			),

			array(
				'name' => esc_html__( 'Color', 'yith-product-description-in-loop-for-woocommerce' ),
				'desc' => esc_html__( 'Choose the color to use for descriptions.', 'yith-product-description-in-loop-for-woocommerce' ),
				'id'   => 'color',
				'type' => 'colorpicker',
				'std'  => '#7c7c7c',
			),

		),
	),
);
