<?php

// Get the Google Fonts list
// https://developers.google.com/fonts/docs/developer_api

$norebro_gf_list = '{
  "kind": "webfonts#webfontList",
  "items": [
    {
      "family": "ABeeZee",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/abeezee/v22/esDR31xSG-6AGleN6tKukbcHCpE.ttf",
        "italic": "https://fonts.gstatic.com/s/abeezee/v22/esDT31xSG-6AGleN2tCklZUCGpG-GQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/abeezee/v22/esDR31xSG-6AGleN2tOklQ.ttf"
    },
    {
      "family": "ADLaM Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "adlam",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/adlamdisplay/v1/KFOhCnGXkPOLlhx6jD8_b1ZECsHYkYBPY3o.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/adlamdisplay/v1/KFOhCnGXkPOLlhx6jD8_b1ZEOsDSlQ.ttf"
    },
    {
      "family": "AR One Sans",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v5",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aronesans/v5/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWn_9DW03no5mBF4.ttf",
        "500": "https://fonts.gstatic.com/s/aronesans/v5/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWk39DW03no5mBF4.ttf",
        "600": "https://fonts.gstatic.com/s/aronesans/v5/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWqH6DW03no5mBF4.ttf",
        "700": "https://fonts.gstatic.com/s/aronesans/v5/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWpj6DW03no5mBF4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aronesans/v5/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWn_9PWw9mg.ttf"
    },
    {
      "family": "Abel",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/abel/v18/MwQ5bhbm2POE6VhLPJp6qGI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/abel/v18/MwQ5bhbm2POE2VlBOA.ttf"
    },
    {
      "family": "Abhaya Libre",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "sinhala"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/abhayalibre/v17/e3tmeuGtX-Co5MNzeAOqinEge0PWovdU4w.ttf",
        "500": "https://fonts.gstatic.com/s/abhayalibre/v17/e3t5euGtX-Co5MNzeAOqinEYj2ryqtxI6oYtBA.ttf",
        "600": "https://fonts.gstatic.com/s/abhayalibre/v17/e3t5euGtX-Co5MNzeAOqinEYo23yqtxI6oYtBA.ttf",
        "700": "https://fonts.gstatic.com/s/abhayalibre/v17/e3t5euGtX-Co5MNzeAOqinEYx2zyqtxI6oYtBA.ttf",
        "800": "https://fonts.gstatic.com/s/abhayalibre/v17/e3t5euGtX-Co5MNzeAOqinEY22_yqtxI6oYtBA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/abhayalibre/v17/e3tmeuGtX-Co5MNzeAOqinEQeknS.ttf"
    },
    {
      "family": "Aboreto",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aboreto/v2/5DCXAKLhwDDQ4N8blKTeA2yuxSY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aboreto/v2/5DCXAKLhwDDQ4N8bpKXUBw.ttf"
    },
    {
      "family": "Abril Fatface",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/abrilfatface/v24/zOL64pLDlL1D99S8g8PtiKchm-BsjOLhZBY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/abrilfatface/v24/zOL64pLDlL1D99S8g8PtiKchq-FmiA.ttf"
    },
    {
      "family": "Abyssinica SIL",
      "variants": [
        "regular"
      ],
      "subsets": [
        "ethiopic",
        "latin",
        "latin-ext"
      ],
      "version": "v8",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/abyssinicasil/v8/oY1H8ezOqK7iI3rK_45WKoc8J6UZBFOVAXuI.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/abyssinicasil/v8/oY1H8ezOqK7iI3rK_45WKoc8J5UYDlc.ttf"
    },
    {
      "family": "Aclonica",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aclonica/v24/K2FyfZJVlfNNSEBXGb7TCI6oBjLz.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aclonica/v24/K2FyfZJVlfNNSEBXGY7SAoo.ttf"
    },
    {
      "family": "Acme",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/acme/v26/RrQfboBx-C5_bx3Lb23lzLk.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/acme/v26/RrQfboBx-C5_XxzBaw.ttf"
    },
    {
      "family": "Actor",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/actor/v17/wEOzEBbCkc5cO3ekXygtUMIO.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/actor/v17/wEOzEBbCkc5cO0elVSw.ttf"
    },
    {
      "family": "Adamina",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/adamina/v21/j8_r6-DH1bjoc-dwu-reETl4Bno.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/adamina/v21/j8_r6-DH1bjoc-dwi-vUFQ.ttf"
    },
    {
      "family": "Advent Pro",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyJPTJoonw1aBA.ttf",
        "200": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLwyNPTJoonw1aBA.ttf",
        "300": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLHSNPTJoonw1aBA.ttf",
        "regular": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyNPTJoonw1aBA.ttf",
        "500": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLcSNPTJoonw1aBA.ttf",
        "600": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLnSRPTJoonw1aBA.ttf",
        "700": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLpCRPTJoonw1aBA.ttf",
        "800": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLwyRPTJoonw1aBA.ttf",
        "900": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpL6iRPTJoonw1aBA.ttf",
        "100italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CnDpAsvQhKBH4C.ttf",
        "200italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AnD5AsvQhKBH4C.ttf",
        "300italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2D5D5AsvQhKBH4C.ttf",
        "italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CnD5AsvQhKBH4C.ttf",
        "500italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CVD5AsvQhKBH4C.ttf",
        "600italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2B5CJAsvQhKBH4C.ttf",
        "700italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2BACJAsvQhKBH4C.ttf",
        "800italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AnCJAsvQhKBH4C.ttf",
        "900italic": "https://fonts.gstatic.com/s/adventpro/v32/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AOCJAsvQhKBH4C.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/adventpro/v32/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyN_TZAs.ttf"
    },
    {
      "family": "Afacad",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "math",
        "symbols",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/afacad/v2/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfhXtWmA08mCgdfM.ttf",
        "500": "https://fonts.gstatic.com/s/afacad/v2/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfiftWmA08mCgdfM.ttf",
        "600": "https://fonts.gstatic.com/s/afacad/v2/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfsvqWmA08mCgdfM.ttf",
        "700": "https://fonts.gstatic.com/s/afacad/v2/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfvLqWmA08mCgdfM.ttf",
        "italic": "https://fonts.gstatic.com/s/afacad/v2/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92usiM-9kKlZfNfuw.ttf",
        "500italic": "https://fonts.gstatic.com/s/afacad/v2/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92ugCM-9kKlZfNfuw.ttf",
        "600italic": "https://fonts.gstatic.com/s/afacad/v2/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92ubCQ-9kKlZfNfuw.ttf",
        "700italic": "https://fonts.gstatic.com/s/afacad/v2/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92uVSQ-9kKlZfNfuw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/afacad/v2/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfhXtamE-9g.ttf"
    },
    {
      "family": "Afacad Flux",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsUwWZaRqQsJr67E.ttf",
        "200": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edscwXZaRqQsJr67E.ttf",
        "300": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsRIXZaRqQsJr67E.ttf",
        "regular": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsUwXZaRqQsJr67E.ttf",
        "500": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsX4XZaRqQsJr67E.ttf",
        "600": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsZIQZaRqQsJr67E.ttf",
        "700": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsasQZaRqQsJr67E.ttf",
        "800": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edscwQZaRqQsJr67E.ttf",
        "900": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edseUQZaRqQsJr67E.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/afacadflux/v3/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsUwXVaVgRg.ttf"
    },
    {
      "family": "Agbalumo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "ethiopic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/agbalumo/v6/55xvey5uMdT2N37KZcMFirl08KDJ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/agbalumo/v6/55xvey5uMdT2N37KZfMEgL0.ttf"
    },
    {
      "family": "Agdasima",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/agdasima/v5/PN_zRfyxp2f1fUCgAMg6rzjb_-Da.ttf",
        "700": "https://fonts.gstatic.com/s/agdasima/v5/PN_0Rfyxp2f1fUCgAPCGgBzT1PzTz2Mi.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/agdasima/v5/PN_zRfyxp2f1fUCgAPg7pTw.ttf"
    },
    {
      "family": "Agu Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/agudisplay/v2/iJWXBXKbbi6BeMC1_RX7qF_V5E7aciGRRWUwX4ftka9LM6y8Zg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/agudisplay/v2/iJWXBXKbbi6BeMC1_RX7qF_V5E7aciGRRWUwX4fdkKVP.ttf"
    },
    {
      "family": "Aguafina Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aguafinascript/v23/If2QXTv_ZzSxGIO30LemWEOmt1bHqs4pgicOrg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aguafinascript/v23/If2QXTv_ZzSxGIO30LemWEOmt1b3q8Qt.ttf"
    },
    {
      "family": "Akatab",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tifinagh"
      ],
      "version": "v8",
      "lastModified": "2025-05-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/akatab/v8/VuJwdNrK3Z7gqJEPWIz5NIh-YA.ttf",
        "500": "https://fonts.gstatic.com/s/akatab/v8/VuJzdNrK3Z7gqJE3rKXdPKNiaRpFvg.ttf",
        "600": "https://fonts.gstatic.com/s/akatab/v8/VuJzdNrK3Z7gqJE3gKLdPKNiaRpFvg.ttf",
        "700": "https://fonts.gstatic.com/s/akatab/v8/VuJzdNrK3Z7gqJE35KPdPKNiaRpFvg.ttf",
        "800": "https://fonts.gstatic.com/s/akatab/v8/VuJzdNrK3Z7gqJE3-KDdPKNiaRpFvg.ttf",
        "900": "https://fonts.gstatic.com/s/akatab/v8/VuJzdNrK3Z7gqJE33KHdPKNiaRpFvg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/akatab/v8/VuJwdNrK3Z7gqJE_WYb9.ttf"
    },
    {
      "family": "Akaya Kanadaka",
      "variants": [
        "regular"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/akayakanadaka/v17/N0bM2S5CPO5oOQqvazoRRb-8-PfRS5VBBSSF.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/akayakanadaka/v17/N0bM2S5CPO5oOQqvazoRRb-8-MfQQZE.ttf"
    },
    {
      "family": "Akaya Telivigala",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "telugu"
      ],
      "version": "v27",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/akayatelivigala/v27/lJwc-oo_iG9wXqU3rCTD395tp0uifdLdsIH0YH8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/akayatelivigala/v27/lJwc-oo_iG9wXqU3rCTD395tp0uiTdPXtA.ttf"
    },
    {
      "family": "Akronim",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/akronim/v23/fdN-9sqWtWZZlHRp-gBxkFYN-a8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/akronim/v23/fdN-9sqWtWZZlHRpygF7lA.ttf"
    },
    {
      "family": "Akshar",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/akshar/v16/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSSgFy9CY94XsnPc.ttf",
        "regular": "https://fonts.gstatic.com/s/akshar/v16/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSXYFy9CY94XsnPc.ttf",
        "500": "https://fonts.gstatic.com/s/akshar/v16/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSUQFy9CY94XsnPc.ttf",
        "600": "https://fonts.gstatic.com/s/akshar/v16/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSagCy9CY94XsnPc.ttf",
        "700": "https://fonts.gstatic.com/s/akshar/v16/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSZECy9CY94XsnPc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/akshar/v16/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSXYF-9GS8w.ttf"
    },
    {
      "family": "Aladin",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aladin/v25/ZgNSjPJFPrvJV5f16Sf4pGT2Ng.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aladin/v25/ZgNSjPJFPrvJV5fF6C38.ttf"
    },
    {
      "family": "Alata",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alata/v11/PbytFmztEwbIofe6xKcRQEOX.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alata/v11/PbytFmztEwbIoce7zqM.ttf"
    },
    {
      "family": "Alatsi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alatsi/v13/TK3iWkUJAxQ2nLNGHjUHte5fKg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alatsi/v13/TK3iWkUJAxQ2nLN2Hz8D.ttf"
    },
    {
      "family": "Albert Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5L_rI32TxAj1g.ttf",
        "200": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHK5P_rI32TxAj1g.ttf",
        "300": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSH9ZP_rI32TxAj1g.ttf",
        "regular": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5P_rI32TxAj1g.ttf",
        "500": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHmZP_rI32TxAj1g.ttf",
        "600": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHdZT_rI32TxAj1g.ttf",
        "700": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHTJT_rI32TxAj1g.ttf",
        "800": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHK5T_rI32TxAj1g.ttf",
        "900": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHApT_rI32TxAj1g.ttf",
        "100italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9AX7ofybRUz1r5t.ttf",
        "200italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9CX74fybRUz1r5t.ttf",
        "300italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9BJ74fybRUz1r5t.ttf",
        "italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9AX74fybRUz1r5t.ttf",
        "500italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9Al74fybRUz1r5t.ttf",
        "600italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9DJ6IfybRUz1r5t.ttf",
        "700italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9Dw6IfybRUz1r5t.ttf",
        "800italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9CX6IfybRUz1r5t.ttf",
        "900italic": "https://fonts.gstatic.com/s/albertsans/v3/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9C-6IfybRUz1r5t.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/albertsans/v3/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5PPrYfy.ttf"
    },
    {
      "family": "Aldrich",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aldrich/v22/MCoTzAn-1s3IGyJMZaAS3pP5H_E.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aldrich/v22/MCoTzAn-1s3IGyJMVaEY2g.ttf"
    },
    {
      "family": "Alef",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "hebrew",
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alef/v23/FeVfS0NQpLYgrjJbC5FxxbU.ttf",
        "700": "https://fonts.gstatic.com/s/alef/v23/FeVQS0NQpLYglo50L5la2bxii28.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alef/v23/FeVfS0NQpLYgnjNRDw.ttf"
    },
    {
      "family": "Alegreya",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v38",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNG9hUI_KCisSGVrw.ttf",
        "500": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGxBUI_KCisSGVrw.ttf",
        "600": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGKBII_KCisSGVrw.ttf",
        "700": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGERII_KCisSGVrw.ttf",
        "800": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGdhII_KCisSGVrw.ttf",
        "900": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGXxII_KCisSGVrw.ttf",
        "italic": "https://fonts.gstatic.com/s/alegreya/v38/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlbgv6qmkySFr9V9.ttf",
        "500italic": "https://fonts.gstatic.com/s/alegreya/v38/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlbSv6qmkySFr9V9.ttf",
        "600italic": "https://fonts.gstatic.com/s/alegreya/v38/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlY-uKqmkySFr9V9.ttf",
        "700italic": "https://fonts.gstatic.com/s/alegreya/v38/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlYHuKqmkySFr9V9.ttf",
        "800italic": "https://fonts.gstatic.com/s/alegreya/v38/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlZguKqmkySFr9V9.ttf",
        "900italic": "https://fonts.gstatic.com/s/alegreya/v38/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlZJuKqmkySFr9V9.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alegreya/v38/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNG9hU4_aqm.ttf"
    },
    {
      "family": "Alegreya SC",
      "variants": [
        "regular",
        "italic",
        "500",
        "500italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alegreyasc/v25/taiOGmRtCJ62-O0HhNEa-a6o05E5abe_.ttf",
        "italic": "https://fonts.gstatic.com/s/alegreyasc/v25/taiMGmRtCJ62-O0HhNEa-Z6q2ZUbbKe_DGs.ttf",
        "500": "https://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZZc-rUxQqu2FXKD.ttf",
        "500italic": "https://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4WEySK-UEGKDBz4.ttf",
        "700": "https://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZYU_LUxQqu2FXKD.ttf",
        "700italic": "https://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4Sk0SK-UEGKDBz4.ttf",
        "800": "https://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZYI_7UxQqu2FXKD.ttf",
        "800italic": "https://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4TU3SK-UEGKDBz4.ttf",
        "900": "https://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZYs_rUxQqu2FXKD.ttf",
        "900italic": "https://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4RE2SK-UEGKDBz4.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alegreyasc/v25/taiOGmRtCJ62-O0HhNEa-Z6p2ZU.ttf"
    },
    {
      "family": "Alegreya Sans",
      "variants": [
        "100",
        "100italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUt9_-1phKLFgshYDvh6Vwt5TltuGdShm5bsg.ttf",
        "100italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUv9_-1phKLFgshYDvh6Vwt7V9V3G1WpGtLsgu7.ttf",
        "300": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUu9_-1phKLFgshYDvh6Vwt5fFPmE18imdCqxI.ttf",
        "300italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUo9_-1phKLFgshYDvh6Vwt7V9VFE92jkVHuxKiBA.ttf",
        "regular": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUz9_-1phKLFgshYDvh6Vwt3V1nvEVXlm4.ttf",
        "italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUt9_-1phKLFgshYDvh6Vwt7V9tuGdShm5bsg.ttf",
        "500": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUu9_-1phKLFgshYDvh6Vwt5alOmE18imdCqxI.ttf",
        "500italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUo9_-1phKLFgshYDvh6Vwt7V9VTE52jkVHuxKiBA.ttf",
        "700": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUu9_-1phKLFgshYDvh6Vwt5eFImE18imdCqxI.ttf",
        "700italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUo9_-1phKLFgshYDvh6Vwt7V9VBEh2jkVHuxKiBA.ttf",
        "800": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUu9_-1phKLFgshYDvh6Vwt5f1LmE18imdCqxI.ttf",
        "800italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUo9_-1phKLFgshYDvh6Vwt7V9VGEt2jkVHuxKiBA.ttf",
        "900": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUu9_-1phKLFgshYDvh6Vwt5dlKmE18imdCqxI.ttf",
        "900italic": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUo9_-1phKLFgshYDvh6Vwt7V9VPEp2jkVHuxKiBA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alegreyasans/v25/5aUz9_-1phKLFgshYDvh6Vwt7VxtuA.ttf"
    },
    {
      "family": "Alegreya Sans SC",
      "variants": [
        "100",
        "100italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGn4-RGJqfMvt7P8FUr0Q1j-Hf1Dipl8g5FPYtmMg.ttf",
        "100italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGl4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdlgRBH452Mvds.ttf",
        "300": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DuJH0iRrMYJ_K-4.ttf",
        "300italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdXiZhNaB6O-51OA.ttf",
        "regular": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGh4-RGJqfMvt7P8FUr0Q1j-Hf1Nk5v9ixALYs.ttf",
        "italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGn4-RGJqfMvt7P8FUr0Q1j-Hf1Bkxl8g5FPYtmMg.ttf",
        "500": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DrpG0iRrMYJ_K-4.ttf",
        "500italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdBidhNaB6O-51OA.ttf",
        "700": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DvJA0iRrMYJ_K-4.ttf",
        "700italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdTiFhNaB6O-51OA.ttf",
        "800": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1Du5D0iRrMYJ_K-4.ttf",
        "800italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdUiJhNaB6O-51OA.ttf",
        "900": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DspC0iRrMYJ_K-4.ttf",
        "900italic": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxddiNhNaB6O-51OA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alegreyasanssc/v23/mtGh4-RGJqfMvt7P8FUr0Q1j-Hf1Bk9l8g.ttf"
    },
    {
      "family": "Aleo",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KJ3G2P9HI4qCBtJ.ttf",
        "200": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KL3GmP9HI4qCBtJ.ttf",
        "300": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KIpGmP9HI4qCBtJ.ttf",
        "regular": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KJ3GmP9HI4qCBtJ.ttf",
        "500": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KJFGmP9HI4qCBtJ.ttf",
        "600": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KKpHWP9HI4qCBtJ.ttf",
        "700": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KKQHWP9HI4qCBtJ.ttf",
        "800": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KL3HWP9HI4qCBtJ.ttf",
        "900": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KLeHWP9HI4qCBtJ.ttf",
        "100italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WYu_FooIDQtJbok.ttf",
        "200italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WQu-FooIDQtJbok.ttf",
        "300italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WdW-FooIDQtJbok.ttf",
        "italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WYu-FooIDQtJbok.ttf",
        "500italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_Wbm-FooIDQtJbok.ttf",
        "600italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WVW5FooIDQtJbok.ttf",
        "700italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WWy5FooIDQtJbok.ttf",
        "800italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WQu5FooIDQtJbok.ttf",
        "900italic": "https://fonts.gstatic.com/s/aleo/v15/c4m81nF8G8_swAjT3z2dShrG-7e_WSK5FooIDQtJbok.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aleo/v15/c4m61nF8G8_s6gHhIOX0IYBo_KJ3GlP8Foo.ttf"
    },
    {
      "family": "Alex Brush",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alexbrush/v22/SZc83FzrJKuqFbwMKk6EtUL57DtOmCc.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alexbrush/v22/SZc83FzrJKuqFbwMKk6EhUPz6A.ttf"
    },
    {
      "family": "Alexandria",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7T6bHHJ8BRq0b.ttf",
        "200": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9p7TqbHHJ8BRq0b.ttf",
        "300": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9qlTqbHHJ8BRq0b.ttf",
        "regular": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7TqbHHJ8BRq0b.ttf",
        "500": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9rJTqbHHJ8BRq0b.ttf",
        "600": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9olSabHHJ8BRq0b.ttf",
        "700": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9ocSabHHJ8BRq0b.ttf",
        "800": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9p7SabHHJ8BRq0b.ttf",
        "900": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9pSSabHHJ8BRq0b.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alexandria/v5/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7TpbGFps.ttf"
    },
    {
      "family": "Alfa Slab One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alfaslabone/v20/6NUQ8FmMKwSEKjnm5-4v-4Jh6dVretWvYmE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alfaslabone/v20/6NUQ8FmMKwSEKjnm5-4v-4Jh2dRhfg.ttf"
    },
    {
      "family": "Alice",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alice/v20/OpNCnoEEmtHa6FcJpA_chzJ0.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alice/v20/OpNCnoEEmtHa6GcIrgs.ttf"
    },
    {
      "family": "Alike",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alike/v21/HI_EiYEYI6BIoEjBSZXAQ4-d.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alike/v21/HI_EiYEYI6BIoHjAQ5E.ttf"
    },
    {
      "family": "Alike Angular",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alikeangular/v26/3qTrojWunjGQtEBlIcwMbSoI3kM6bB7FKjE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alikeangular/v26/3qTrojWunjGQtEBlIcwMbSoI7kIwaA.ttf"
    },
    {
      "family": "Alkalami",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alkalami/v7/zOL_4pfDmqRL95WXi5eLw8BMuvhH.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alkalami/v7/zOL_4pfDmqRL95WXi6eKycQ.ttf"
    },
    {
      "family": "Alkatra",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "bengali",
        "devanagari",
        "latin",
        "latin-ext",
        "oriya"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alkatra/v4/r05EGLZA5qhCYsyJbuChFuK48Medzngmu7cPrNDVemxE.ttf",
        "500": "https://fonts.gstatic.com/s/alkatra/v4/r05EGLZA5qhCYsyJbuChFuK48MedzngUu7cPrNDVemxE.ttf",
        "600": "https://fonts.gstatic.com/s/alkatra/v4/r05EGLZA5qhCYsyJbuChFuK48Medznj4vLcPrNDVemxE.ttf",
        "700": "https://fonts.gstatic.com/s/alkatra/v4/r05EGLZA5qhCYsyJbuChFuK48MedznjBvLcPrNDVemxE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alkatra/v4/r05EGLZA5qhCYsyJbuChFuK48Medzngmu4cOptQ.ttf"
    },
    {
      "family": "Allan",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/allan/v25/ea8XadU7WuTxEtb2P9SF8nZE.ttf",
        "700": "https://fonts.gstatic.com/s/allan/v25/ea8aadU7WuTxEu5KEPCN2WpNgEKU.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/allan/v25/ea8XadU7WuTxEub3NdA.ttf"
    },
    {
      "family": "Allerta",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/allerta/v18/TwMO-IAHRlkbx940UnEdSQqO5uY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/allerta/v18/TwMO-IAHRlkbx940YnAXTQ.ttf"
    },
    {
      "family": "Allerta Stencil",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/allertastencil/v23/HTx0L209KT-LmIE9N7OR6eiycOeF-zz313DuvQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/allertastencil/v23/HTx0L209KT-LmIE9N7OR6eiycOe1-jbz.ttf"
    },
    {
      "family": "Allison",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/allison/v12/X7nl4b88AP2nkbvZOCaQ4MTgAgk.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/allison/v12/X7nl4b88AP2nkbvZCCea5A.ttf"
    },
    {
      "family": "Allura",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/allura/v22/9oRPNYsQpS4zjuAPjAIXPtrrGA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/allura/v22/9oRPNYsQpS4zjuA_jQgT.ttf"
    },
    {
      "family": "Almarai",
      "variants": [
        "300",
        "regular",
        "700",
        "800"
      ],
      "subsets": [
        "arabic",
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/almarai/v18/tssoApxBaigK_hnnS_anhnicoq72sXg.ttf",
        "regular": "https://fonts.gstatic.com/s/almarai/v18/tsstApxBaigK_hnnc1qPonC3vqc.ttf",
        "700": "https://fonts.gstatic.com/s/almarai/v18/tssoApxBaigK_hnnS-aghnicoq72sXg.ttf",
        "800": "https://fonts.gstatic.com/s/almarai/v18/tssoApxBaigK_hnnS_qjhnicoq72sXg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/almarai/v18/tsstApxBaigK_hnnQ1uFpg.ttf"
    },
    {
      "family": "Almendra",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/almendra/v27/H4ckBXKAlMnTn0CskyY6wr-wg763.ttf",
        "italic": "https://fonts.gstatic.com/s/almendra/v27/H4ciBXKAlMnTn0CskxY4yLuShq63czE.ttf",
        "700": "https://fonts.gstatic.com/s/almendra/v27/H4cjBXKAlMnTn0Cskx6G7Zu4qKK-aihq.ttf",
        "700italic": "https://fonts.gstatic.com/s/almendra/v27/H4chBXKAlMnTn0CskxY48Ae9oqacbzhqDtg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/almendra/v27/H4ckBXKAlMnTn0CskxY7yLs.ttf"
    },
    {
      "family": "Almendra Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/almendradisplay/v32/0FlPVOGWl1Sb4O3tETtADHRRlZhzXS_eTyer338.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/almendradisplay/v32/0FlPVOGWl1Sb4O3tETtADHRRlZhzbS7USw.ttf"
    },
    {
      "family": "Almendra SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/almendrasc/v30/Iure6Yx284eebowr7hbyTZZJprVA4XQ0.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/almendrasc/v30/Iure6Yx284eebowr7hbyTaZIrLE.ttf"
    },
    {
      "family": "Alumni Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO5QqFsJ3C8qng.ttf",
        "200": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9uO9QqFsJ3C8qng.ttf",
        "300": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9Zu9QqFsJ3C8qng.ttf",
        "regular": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO9QqFsJ3C8qng.ttf",
        "500": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9Cu9QqFsJ3C8qng.ttf",
        "600": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd95uhQqFsJ3C8qng.ttf",
        "700": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd93-hQqFsJ3C8qng.ttf",
        "800": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9uOhQqFsJ3C8qng.ttf",
        "900": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9kehQqFsJ3C8qng.ttf",
        "100italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Ky46lEN_io6npfB.ttf",
        "200italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kw461EN_io6npfB.ttf",
        "300italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kzm61EN_io6npfB.ttf",
        "italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Ky461EN_io6npfB.ttf",
        "500italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8KyK61EN_io6npfB.ttf",
        "600italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kxm7FEN_io6npfB.ttf",
        "700italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kxf7FEN_io6npfB.ttf",
        "800italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kw47FEN_io6npfB.ttf",
        "900italic": "https://fonts.gstatic.com/s/alumnisans/v19/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8KwR7FEN_io6npfB.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alumnisans/v19/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO9gqVEN.ttf"
    },
    {
      "family": "Alumni Sans Collegiate One",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alumnisanscollegiateone/v6/MQpB-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhjdayDiPw2ta.ttf",
        "italic": "https://fonts.gstatic.com/s/alumnisanscollegiateone/v6/MQpD-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhgdYwjytxntaDFU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alumnisanscollegiateone/v6/MQpB-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhgdbwjw.ttf"
    },
    {
      "family": "Alumni Sans Inline One",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alumnisansinlineone/v6/RrQBbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpD3AZcr7xbYw.ttf",
        "italic": "https://fonts.gstatic.com/s/alumnisansinlineone/v6/RrQDbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpP3ITdpz0fYxcrQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alumnisansinlineone/v6/RrQBbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpP3ETdg.ttf"
    },
    {
      "family": "Alumni Sans Pinstripe",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/alumnisanspinstripe/v7/ZgNNjOFFPq_AUJD1umyS30W-Xub8zD1ObhezYrVIpcDA5w.ttf",
        "italic": "https://fonts.gstatic.com/s/alumnisanspinstripe/v7/ZgNDjOFFPq_AUJD1umyS30W-Xub8zD1ObheDYL9Mh8XQ5_cY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alumnisanspinstripe/v7/ZgNNjOFFPq_AUJD1umyS30W-Xub8zD1ObheDY79M.ttf"
    },
    {
      "family": "Alumni Sans SC",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteaLxWgMKfbBlLNQ.ttf",
        "200": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIte6L1WgMKfbBlLNQ.ttf",
        "300": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteNr1WgMKfbBlLNQ.ttf",
        "regular": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteaL1WgMKfbBlLNQ.ttf",
        "500": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteWr1WgMKfbBlLNQ.ttf",
        "600": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdItetrpWgMKfbBlLNQ.ttf",
        "700": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdItej7pWgMKfbBlLNQ.ttf",
        "800": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIte6LpWgMKfbBlLNQ.ttf",
        "900": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdItewbpWgMKfbBlLNQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP6-wsibThxbNRJQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP4-w8ibThxbNRJQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP7gw8ibThxbNRJQ.ttf",
        "italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP6-w8ibThxbNRJQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP6Mw8ibThxbNRJQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP5gxMibThxbNRJQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP5ZxMibThxbNRJQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP4-xMibThxbNRJQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP4XxMibThxbNRJQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/alumnisanssc/v2/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteaL1mgcib.ttf"
    },
    {
      "family": "Amarante",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amarante/v29/xMQXuF1KTa6EvGx9bq-3C3rAmD-b.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amarante/v29/xMQXuF1KTa6EvGx9bp-2AX4.ttf"
    },
    {
      "family": "Amaranth",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amaranth/v18/KtkuALODe433f0j1zPnCF9GqwnzW.ttf",
        "italic": "https://fonts.gstatic.com/s/amaranth/v18/KtkoALODe433f0j1zMnAHdWIx2zWD4I.ttf",
        "700": "https://fonts.gstatic.com/s/amaranth/v18/KtkpALODe433f0j1zMF-OPWi6WDfFpuc.ttf",
        "700italic": "https://fonts.gstatic.com/s/amaranth/v18/KtkrALODe433f0j1zMnAJWmn42T9E4ucRY8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amaranth/v18/KtkuALODe433f0j1zMnDHdU.ttf"
    },
    {
      "family": "Amatic SC",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amaticsc/v27/TUZyzwprpvBS1izr_vO0De6ecZQf1A.ttf",
        "700": "https://fonts.gstatic.com/s/amaticsc/v27/TUZ3zwprpvBS1izr_vOMscG6eb8D3WTy-A.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amaticsc/v27/TUZyzwprpvBS1izr_vOEDOSa.ttf"
    },
    {
      "family": "Amethysta",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amethysta/v16/rP2Fp2K15kgb_F3ibfWIGDWCBl0O8Q.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amethysta/v16/rP2Fp2K15kgb_F3ibfW4GT-G.ttf"
    },
    {
      "family": "Amiko",
      "variants": [
        "regular",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amiko/v14/WwkQxPq1DFK04tqlc17MMZgJ.ttf",
        "600": "https://fonts.gstatic.com/s/amiko/v14/WwkdxPq1DFK04uJ9XXrEGoQAUco5.ttf",
        "700": "https://fonts.gstatic.com/s/amiko/v14/WwkdxPq1DFK04uIZXHrEGoQAUco5.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amiko/v14/WwkQxPq1DFK04uqkeVo.ttf"
    },
    {
      "family": "Amiri",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amiri/v27/J7aRnpd8CGxBHqUpvrIw74NL.ttf",
        "italic": "https://fonts.gstatic.com/s/amiri/v27/J7afnpd8CGxBHpUrtLYS6pNLAjk.ttf",
        "700": "https://fonts.gstatic.com/s/amiri/v27/J7acnpd8CGxBHp2VkZY4xJ9CGyAa.ttf",
        "700italic": "https://fonts.gstatic.com/s/amiri/v27/J7aanpd8CGxBHpUrjAo9zptgHjAavCA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amiri/v27/J7aRnpd8CGxBHpUotLY.ttf"
    },
    {
      "family": "Amiri Quran",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amiriquran/v17/_Xmo-Hk0rD6DbUL4_vH8Zq5t7Cycsu-2.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amiriquran/v17/_Xmo-Hk0rD6DbUL4_vH8Zp5s5ig.ttf",
      "colorCapabilities": [
        "COLRv0",
        "SVG"
      ]
    },
    {
      "family": "Amita",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/amita/v19/HhyaU5si9Om7PQlvAfSKEZZL.ttf",
        "700": "https://fonts.gstatic.com/s/amita/v19/HhyXU5si9Om7PTHTLtCCOopCTKkI.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/amita/v19/HhyaU5si9Om7PTluC_A.ttf"
    },
    {
      "family": "Anaheim",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/anaheim/v16/8vIX7w042Wp87g4Gy0_24JbCiPrl-h5sLqrFIkJQb7zU.ttf",
        "500": "https://fonts.gstatic.com/s/anaheim/v16/8vIX7w042Wp87g4Gy0_24JbCiPrl-h5eLqrFIkJQb7zU.ttf",
        "600": "https://fonts.gstatic.com/s/anaheim/v16/8vIX7w042Wp87g4Gy0_24JbCiPrl-h6yKarFIkJQb7zU.ttf",
        "700": "https://fonts.gstatic.com/s/anaheim/v16/8vIX7w042Wp87g4Gy0_24JbCiPrl-h6LKarFIkJQb7zU.ttf",
        "800": "https://fonts.gstatic.com/s/anaheim/v16/8vIX7w042Wp87g4Gy0_24JbCiPrl-h7sKarFIkJQb7zU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anaheim/v16/8vIX7w042Wp87g4Gy0_24JbCiPrl-h5sLprEKEY.ttf"
    },
    {
      "family": "Ancizar Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "greek",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-06-25",
      "files": {
        "100": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMyzipBpIu30AZbUY.ttf",
        "200": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy7ioBpIu30AZbUY.ttf",
        "300": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy2aoBpIu30AZbUY.ttf",
        "regular": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMyzioBpIu30AZbUY.ttf",
        "500": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMywqoBpIu30AZbUY.ttf",
        "600": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy-avBpIu30AZbUY.ttf",
        "700": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy9-vBpIu30AZbUY.ttf",
        "800": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy7ivBpIu30AZbUY.ttf",
        "900": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy5GvBpIu30AZbUY.ttf",
        "100italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDr7tAk22IcfUZgBQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrbtEk22IcfUZgBQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrsNEk22IcfUZgBQ.ttf",
        "italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDr7tEk22IcfUZgBQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDr3NEk22IcfUZgBQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrMNYk22IcfUZgBQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrCdYk22IcfUZgBQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrbtYk22IcfUZgBQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/ancizarsans/v7/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrR9Yk22IcfUZgBQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ancizarsans/v7/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMyzioNpMk2w.ttf"
    },
    {
      "family": "Ancizar Serif",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "greek",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-06-25",
      "files": {
        "300": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN2H_fAQtYfaQ_ao.ttf",
        "regular": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN3Z_fAQtYfaQ_ao.ttf",
        "500": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN3r_fAQtYfaQ_ao.ttf",
        "600": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN0H-vAQtYfaQ_ao.ttf",
        "700": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN0--vAQtYfaQ_ao.ttf",
        "800": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN1Z-vAQtYfaQ_ao.ttf",
        "900": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN1w-vAQtYfaQ_ao.ttf",
        "300italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvkZTv4P4Ruao7Y0.ttf",
        "italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvhhTv4P4Ruao7Y0.ttf",
        "500italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvipTv4P4Ruao7Y0.ttf",
        "600italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvsZUv4P4Ruao7Y0.ttf",
        "700italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvv9Uv4P4Ruao7Y0.ttf",
        "800italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvphUv4P4Ruao7Y0.ttf",
        "900italic": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvrFUv4P4Ruao7Y0.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ancizarserif/v7/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN3Z_cARv4M.ttf"
    },
    {
      "family": "Andada Pro",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/andadapro/v23/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DPJBY8cFLzvIt2S.ttf",
        "500": "https://fonts.gstatic.com/s/andadapro/v23/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DP7BY8cFLzvIt2S.ttf",
        "600": "https://fonts.gstatic.com/s/andadapro/v23/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DMXAo8cFLzvIt2S.ttf",
        "700": "https://fonts.gstatic.com/s/andadapro/v23/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DMuAo8cFLzvIt2S.ttf",
        "800": "https://fonts.gstatic.com/s/andadapro/v23/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DNJAo8cFLzvIt2S.ttf",
        "italic": "https://fonts.gstatic.com/s/andadapro/v23/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRmdfHrjNJ82Stjw.ttf",
        "500italic": "https://fonts.gstatic.com/s/andadapro/v23/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRlVfHrjNJ82Stjw.ttf",
        "600italic": "https://fonts.gstatic.com/s/andadapro/v23/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRrlYHrjNJ82Stjw.ttf",
        "700italic": "https://fonts.gstatic.com/s/andadapro/v23/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRoBYHrjNJ82Stjw.ttf",
        "800italic": "https://fonts.gstatic.com/s/andadapro/v23/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRudYHrjNJ82Stjw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/andadapro/v23/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DPJBb8dHrg.ttf"
    },
    {
      "family": "Andika",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/andika/v26/mem_Ya6iyW-LwqgAbbwRWrwGVA.ttf",
        "italic": "https://fonts.gstatic.com/s/andika/v26/mem9Ya6iyW-Lwqgwb7YVeLkWVNBt.ttf",
        "700": "https://fonts.gstatic.com/s/andika/v26/mem8Ya6iyW-Lwqg40ZM1UpcaXcl0Aw.ttf",
        "700italic": "https://fonts.gstatic.com/s/andika/v26/mem6Ya6iyW-Lwqgwb46pV50ef8xkA76a.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/andika/v26/mem_Ya6iyW-LwqgwbLYV.ttf"
    },
    {
      "family": "Anek Bangla",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "bengali",
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9YIocg56yyvt0.ttf",
        "200": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofu9ZIocg56yyvt0.ttf",
        "300": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfjFZIocg56yyvt0.ttf",
        "regular": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9ZIocg56yyvt0.ttf",
        "500": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofl1ZIocg56yyvt0.ttf",
        "600": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfrFeIocg56yyvt0.ttf",
        "700": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfoheIocg56yyvt0.ttf",
        "800": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofu9eIocg56yyvt0.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekbangla/v15/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9ZEoYq4w.ttf"
    },
    {
      "family": "Anek Devanagari",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtk-9nFk0LjZ7E.ttf",
        "200": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLBtku9nFk0LjZ7E.ttf",
        "300": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLCzku9nFk0LjZ7E.ttf",
        "regular": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtku9nFk0LjZ7E.ttf",
        "500": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDfku9nFk0LjZ7E.ttf",
        "600": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLAzle9nFk0LjZ7E.ttf",
        "700": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLAKle9nFk0LjZ7E.ttf",
        "800": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLBtle9nFk0LjZ7E.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekdevanagari/v16/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtkt9mHEk.ttf"
    },
    {
      "family": "Anek Gujarati",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5G7w0KgB7Lm7g.ttf",
        "200": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0l5C7w0KgB7Lm7g.ttf",
        "300": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0SZC7w0KgB7Lm7g.ttf",
        "regular": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5C7w0KgB7Lm7g.ttf",
        "500": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0JZC7w0KgB7Lm7g.ttf",
        "600": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0yZe7w0KgB7Lm7g.ttf",
        "700": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-08Je7w0KgB7Lm7g.ttf",
        "800": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0l5e7w0KgB7Lm7g.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekgujarati/v16/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5CLwkik.ttf"
    },
    {
      "family": "Anek Gurmukhi",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5ppXK41H6DjbA.ttf",
        "200": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkb95tpXK41H6DjbA.ttf",
        "300": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbKZtpXK41H6DjbA.ttf",
        "regular": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5tpXK41H6DjbA.ttf",
        "500": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbRZtpXK41H6DjbA.ttf",
        "600": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbqZxpXK41H6DjbA.ttf",
        "700": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbkJxpXK41H6DjbA.ttf",
        "800": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkb95xpXK41H6DjbA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekgurmukhi/v12/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5tZXaQx.ttf"
    },
    {
      "family": "Anek Kannada",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDEAukVReA1oef.ttf",
        "200": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dHDEQukVReA1oef.ttf",
        "300": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dEdEQukVReA1oef.ttf",
        "regular": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDEQukVReA1oef.ttf",
        "500": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFxEQukVReA1oef.ttf",
        "600": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dGdFgukVReA1oef.ttf",
        "700": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dGkFgukVReA1oef.ttf",
        "800": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dHDFgukVReA1oef.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekkannada/v14/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDETulXxM.ttf"
    },
    {
      "family": "Anek Latin",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7EZKdClWL3kgw.ttf",
        "200": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3Pux7AZKdClWL3kgw.ttf",
        "300": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuGbAZKdClWL3kgw.ttf",
        "regular": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7AZKdClWL3kgw.ttf",
        "500": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PudbAZKdClWL3kgw.ttf",
        "600": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PumbcZKdClWL3kgw.ttf",
        "700": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuoLcZKdClWL3kgw.ttf",
        "800": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3Pux7cZKdClWL3kgw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aneklatin/v10/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7ApKNqh.ttf"
    },
    {
      "family": "Anek Malayalam",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "malayalam"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu_HMr5PDO71Qs.ttf",
        "200": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTURu-HMr5PDO71Qs.ttf",
        "300": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUcW-HMr5PDO71Qs.ttf",
        "regular": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu-HMr5PDO71Qs.ttf",
        "500": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUam-HMr5PDO71Qs.ttf",
        "600": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUUW5HMr5PDO71Qs.ttf",
        "700": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUXy5HMr5PDO71Qs.ttf",
        "800": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTURu5HMr5PDO71Qs.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekmalayalam/v17/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu-LMvzOA.ttf"
    },
    {
      "family": "Anek Odia",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "oriya"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZf63mXZAtm_es.ttf",
        "200": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnkZfq3mXZAtm_es.ttf",
        "300": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnnHfq3mXZAtm_es.ttf",
        "regular": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZfq3mXZAtm_es.ttf",
        "500": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmrfq3mXZAtm_es.ttf",
        "600": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnlHea3mXZAtm_es.ttf",
        "700": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnl-ea3mXZAtm_es.ttf",
        "800": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnkZea3mXZAtm_es.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anekodia/v16/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZfp3nV5Q.ttf"
    },
    {
      "family": "Anek Tamil",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQiZ6q4v4oegjOQ.ttf",
        "200": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNwid6q4v4oegjOQ.ttf",
        "300": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNHCd6q4v4oegjOQ.ttf",
        "regular": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQid6q4v4oegjOQ.ttf",
        "500": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNcCd6q4v4oegjOQ.ttf",
        "600": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNnCB6q4v4oegjOQ.ttf",
        "700": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNpSB6q4v4oegjOQ.ttf",
        "800": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNwiB6q4v4oegjOQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anektamil/v17/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQidKqoH8.ttf"
    },
    {
      "family": "Anek Telugu",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "telugu"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y-_oE2G2ep10_8.ttf",
        "200": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i136--oE2G2ep10_8.ttf",
        "300": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i133G-oE2G2ep10_8.ttf",
        "regular": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y--oE2G2ep10_8.ttf",
        "500": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13x2-oE2G2ep10_8.ttf",
        "600": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13_G5oE2G2ep10_8.ttf",
        "700": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i138i5oE2G2ep10_8.ttf",
        "800": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i136-5oE2G2ep10_8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anektelugu/v12/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y--kEyM3Q.ttf"
    },
    {
      "family": "Angkor",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v34",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/angkor/v34/H4cmBXyAlsPdnlb-8iw-4Lqggw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/angkor/v34/H4cmBXyAlsPdnlbO8yY6.ttf"
    },
    {
      "family": "Annapurna SIL",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/annapurnasil/v2/yYLv0hDY0f2iu9tPmRWtllid8NN9dZT_PZs.ttf",
        "700": "https://fonts.gstatic.com/s/annapurnasil/v2/yYLy0hDY0f2iu9tPmRWtllidyG9SUZzUIZJ008A.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/annapurnasil/v2/yYLv0hDY0f2iu9tPmRWtllidwNJ3cQ.ttf"
    },
    {
      "family": "Annie Use Your Telescope",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/annieuseyourtelescope/v19/daaLSS4tI2qYYl3Jq9s_Hu74xwktnlKxH6osGVGjlDfB3UUVZA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/annieuseyourtelescope/v19/daaLSS4tI2qYYl3Jq9s_Hu74xwktnlKxH6osGVGTlT3F.ttf"
    },
    {
      "family": "Anonymous Pro",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "greek",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/anonymouspro/v21/rP2Bp2a15UIB7Un-bOeISG3pLlw89CH98Ko.ttf",
        "italic": "https://fonts.gstatic.com/s/anonymouspro/v21/rP2fp2a15UIB7Un-bOeISG3pHl428AP44Kqr2Q.ttf",
        "700": "https://fonts.gstatic.com/s/anonymouspro/v21/rP2cp2a15UIB7Un-bOeISG3pFuAT0CnW7KOywKo.ttf",
        "700italic": "https://fonts.gstatic.com/s/anonymouspro/v21/rP2ap2a15UIB7Un-bOeISG3pHl4OTCzc6IG30KqB9Q.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anonymouspro/v21/rP2Bp2a15UIB7Un-bOeISG3pHl028A.ttf"
    },
    {
      "family": "Anta",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/anta/v1/gyBzhwQ3KsIyZFwxPFimIo0.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anta/v1/gyBzhwQ3KsIyVF07OA.ttf"
    },
    {
      "family": "Antic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/antic/v19/TuGfUVB8XY5DRaZLodgzydtk.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/antic/v19/TuGfUVB8XY5DRZZKq9w.ttf"
    },
    {
      "family": "Antic Didone",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/anticdidone/v16/RWmPoKKX6u8sp8fIWdnDKqDiqYsGBGBzCw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anticdidone/v16/RWmPoKKX6u8sp8fIWdnDKqDSqIEC.ttf"
    },
    {
      "family": "Antic Slab",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/anticslab/v16/bWt97fPFfRzkCa9Jlp6IWcJWXW5p5Qo.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anticslab/v16/bWt97fPFfRzkCa9Jlp6IacNcWQ.ttf"
    },
    {
      "family": "Anton",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/anton/v26/1Ptgg87LROyAm0K08i4gS7lu.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anton/v26/1Ptgg87LROyAm3K1-Co.ttf"
    },
    {
      "family": "Anton SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/antonsc/v1/4UaBrEBBsgltGn71sxLmzanB44N1.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/antonsc/v1/4UaBrEBBsgltGn71syLnx60.ttf"
    },
    {
      "family": "Antonio",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8BtIY2DwSXlM.ttf",
        "200": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVzx8RtIY2DwSXlM.ttf",
        "300": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVwv8RtIY2DwSXlM.ttf",
        "regular": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8RtIY2DwSXlM.ttf",
        "500": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxD8RtIY2DwSXlM.ttf",
        "600": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVyv9htIY2DwSXlM.ttf",
        "700": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVyW9htIY2DwSXlM.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/antonio/v21/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8StJaWQ.ttf"
    },
    {
      "family": "Anuphan",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkY9A4kGmW927Gu.ttf",
        "200": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCmY9Q4kGmW927Gu.ttf",
        "300": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZClG9Q4kGmW927Gu.ttf",
        "regular": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkY9Q4kGmW927Gu.ttf",
        "500": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkq9Q4kGmW927Gu.ttf",
        "600": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCnG8g4kGmW927Gu.ttf",
        "700": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCn_8g4kGmW927Gu.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anuphan/v5/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkY9T4lEGE.ttf"
    },
    {
      "family": "Anybody",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12HPrsXD_nBPpQ.ttf",
        "200": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JV2DPrsXD_nBPpQ.ttf",
        "300": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JiWDPrsXD_nBPpQ.ttf",
        "regular": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12DPrsXD_nBPpQ.ttf",
        "500": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J5WDPrsXD_nBPpQ.ttf",
        "600": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JCWfPrsXD_nBPpQ.ttf",
        "700": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JMGfPrsXD_nBPpQ.ttf",
        "800": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JV2fPrsXD_nBPpQ.ttf",
        "900": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JfmfPrsXD_nBPpQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMn7M_H3HVfpcHY.ttf",
        "200italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOn7c_H3HVfpcHY.ttf",
        "300italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyN57c_H3HVfpcHY.ttf",
        "italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMn7c_H3HVfpcHY.ttf",
        "500italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMV7c_H3HVfpcHY.ttf",
        "600italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyP56s_H3HVfpcHY.ttf",
        "700italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyPA6s_H3HVfpcHY.ttf",
        "800italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOn6s_H3HVfpcHY.ttf",
        "900italic": "https://fonts.gstatic.com/s/anybody/v12/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOO6s_H3HVfpcHY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/anybody/v12/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12D_r8_H.ttf"
    },
    {
      "family": "Aoboshi One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-06-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aoboshione/v12/Gg8xN5kXaAXtHQrFxwl10ysLBmZX_UEg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aoboshione/v12/Gg8xN5kXaAXtHQrFxwl10xsKDGI.ttf"
    },
    {
      "family": "Arapey",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arapey/v16/-W__XJn-UDDA2RC6Z9AcZkIzeg.ttf",
        "italic": "https://fonts.gstatic.com/s/arapey/v16/-W_9XJn-UDDA2RCKZdoYREcjeo0k.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arapey/v16/-W__XJn-UDDA2RCKZtoY.ttf"
    },
    {
      "family": "Arbutus",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arbutus/v29/NaPYcZ7dG_5J3poob9JtryO8fMU.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arbutus/v29/NaPYcZ7dG_5J3pooX9Nnqw.ttf"
    },
    {
      "family": "Arbutus Slab",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arbutusslab/v16/oY1Z8e7OuLXkJGbXtr5ba7ZVa68dJlaFAQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arbutusslab/v16/oY1Z8e7OuLXkJGbXtr5ba7ZlaqUZ.ttf"
    },
    {
      "family": "Architects Daughter",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/architectsdaughter/v19/KtkxAKiDZI_td1Lkx62xHZHDtgO_Y-bvfY5q4szgE-Q.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/architectsdaughter/v19/KtkxAKiDZI_td1Lkx62xHZHDtgO_Y-bvTY9g5g.ttf"
    },
    {
      "family": "Archivo",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDJp8B1oJ0vyVQ.ttf",
        "200": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTtDNp8B1oJ0vyVQ.ttf",
        "300": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTajNp8B1oJ0vyVQ.ttf",
        "regular": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDNp8B1oJ0vyVQ.ttf",
        "500": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTBjNp8B1oJ0vyVQ.ttf",
        "600": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTT6jRp8B1oJ0vyVQ.ttf",
        "700": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTT0zRp8B1oJ0vyVQ.ttf",
        "800": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTtDRp8B1oJ0vyVQ.ttf",
        "900": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTnTRp8B1oJ0vyVQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCBshdsBU7iVdxQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HABsxdsBU7iVdxQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HDfsxdsBU7iVdxQ.ttf",
        "italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCBsxdsBU7iVdxQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCzsxdsBU7iVdxQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HBftBdsBU7iVdxQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HBmtBdsBU7iVdxQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HABtBdsBU7iVdxQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/archivo/v24/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HAotBdsBU7iVdxQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/archivo/v24/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDNZ8Rds.ttf"
    },
    {
      "family": "Archivo Black",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/archivoblack/v22/HTxqL289NzCGg4MzN6KJ7eW6OYuP_x7yx3A.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/archivoblack/v22/HTxqL289NzCGg4MzN6KJ7eW6CYqF-w.ttf"
    },
    {
      "family": "Archivo Narrow",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v34",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/archivonarrow/v34/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvLFGKpHOtFCQ76Q.ttf",
        "500": "https://fonts.gstatic.com/s/archivonarrow/v34/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvHlGKpHOtFCQ76Q.ttf",
        "600": "https://fonts.gstatic.com/s/archivonarrow/v34/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhv8laKpHOtFCQ76Q.ttf",
        "700": "https://fonts.gstatic.com/s/archivonarrow/v34/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvy1aKpHOtFCQ76Q.ttf",
        "italic": "https://fonts.gstatic.com/s/archivonarrow/v34/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BJi53mpNiEr6T6Y.ttf",
        "500italic": "https://fonts.gstatic.com/s/archivonarrow/v34/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BJQ53mpNiEr6T6Y.ttf",
        "600italic": "https://fonts.gstatic.com/s/archivonarrow/v34/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BK84HmpNiEr6T6Y.ttf",
        "700italic": "https://fonts.gstatic.com/s/archivonarrow/v34/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BKF4HmpNiEr6T6Y.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/archivonarrow/v34/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvLFG6pXmp.ttf"
    },
    {
      "family": "Are You Serious",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/areyouserious/v13/ll8kK2GVSSr-PtjQ5nONVcNn4306hT9nCGRayg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/areyouserious/v13/ll8kK2GVSSr-PtjQ5nONVcNn430KhDVj.ttf"
    },
    {
      "family": "Aref Ruqaa",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arefruqaa/v25/WwkbxPW1E165rajQKDulEIAiVNo5xNY.ttf",
        "700": "https://fonts.gstatic.com/s/arefruqaa/v25/WwkYxPW1E165rajQKDulKDwNcNIS2N_7Bdk.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arefruqaa/v25/WwkbxPW1E165rajQKDulIIEoUA.ttf"
    },
    {
      "family": "Aref Ruqaa Ink",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arefruqaaink/v11/1q2fY5WOGUFlt84GTOkP6Kdx72ThVIGpgnxL.ttf",
        "700": "https://fonts.gstatic.com/s/arefruqaaink/v11/1q2cY5WOGUFlt84GTOkP6Kdx71xde6WhqWBCyxWn.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arefruqaaink/v11/1q2fY5WOGUFlt84GTOkP6Kdx71TgXoU.ttf",
      "colorCapabilities": [
        "COLRv1",
        "SVG"
      ]
    },
    {
      "family": "Arima",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "malayalam",
        "tamil",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTE-pQGOyYw2fw.ttf",
        "200": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX14TA-pQGOyYw2fw.ttf",
        "300": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1PzA-pQGOyYw2fw.ttf",
        "regular": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTA-pQGOyYw2fw.ttf",
        "500": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1UzA-pQGOyYw2fw.ttf",
        "600": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1vzc-pQGOyYw2fw.ttf",
        "700": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1hjc-pQGOyYw2fw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arima/v6/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTAOpAuK.ttf"
    },
    {
      "family": "Arimo",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v34",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arimo/v34/P5sfzZCDf9_T_3cV7NCUECyoxNk37cxsBxDAVQI4aA.ttf",
        "500": "https://fonts.gstatic.com/s/arimo/v34/P5sfzZCDf9_T_3cV7NCUECyoxNk338xsBxDAVQI4aA.ttf",
        "600": "https://fonts.gstatic.com/s/arimo/v34/P5sfzZCDf9_T_3cV7NCUECyoxNk3M8tsBxDAVQI4aA.ttf",
        "700": "https://fonts.gstatic.com/s/arimo/v34/P5sfzZCDf9_T_3cV7NCUECyoxNk3CstsBxDAVQI4aA.ttf",
        "italic": "https://fonts.gstatic.com/s/arimo/v34/P5sdzZCDf9_T_10c3i9MeUcyat4iJY-ERBrEdwcoaKww.ttf",
        "500italic": "https://fonts.gstatic.com/s/arimo/v34/P5sdzZCDf9_T_10c3i9MeUcyat4iJY-2RBrEdwcoaKww.ttf",
        "600italic": "https://fonts.gstatic.com/s/arimo/v34/P5sdzZCDf9_T_10c3i9MeUcyat4iJY9aQxrEdwcoaKww.ttf",
        "700italic": "https://fonts.gstatic.com/s/arimo/v34/P5sdzZCDf9_T_10c3i9MeUcyat4iJY9jQxrEdwcoaKww.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arimo/v34/P5sfzZCDf9_T_3cV7NCUECyoxNk37cxcBhrE.ttf"
    },
    {
      "family": "Arizonia",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arizonia/v22/neIIzCemt4A5qa7mv6WGHK06UY30.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arizonia/v22/neIIzCemt4A5qa7mv5WHFqk.ttf"
    },
    {
      "family": "Armata",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/armata/v20/gokvH63_HV5jQ-E9lD53Q2u_mQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/armata/v20/gokvH63_HV5jQ-ENlTRz.ttf"
    },
    {
      "family": "Arsenal",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arsenal/v12/wXKrE3kQtZQ4pF3D11_WAewrhXY.ttf",
        "italic": "https://fonts.gstatic.com/s/arsenal/v12/wXKpE3kQtZQ4pF3D513cBc4ulXYrtA.ttf",
        "700": "https://fonts.gstatic.com/s/arsenal/v12/wXKuE3kQtZQ4pF3D7-P5JeQAmX8yrdk.ttf",
        "700italic": "https://fonts.gstatic.com/s/arsenal/v12/wXKsE3kQtZQ4pF3D513kueEKnV03vdnKjw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arsenal/v12/wXKrE3kQtZQ4pF3D517cBQ.ttf"
    },
    {
      "family": "Arsenal SC",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arsenalsc/v1/x3dlckLHea6e5BEtsfxiXNossybsHQI.ttf",
        "italic": "https://fonts.gstatic.com/s/arsenalsc/v1/x3dnckLHea6e5BEtsfxibNgmtwTpDQIrGg.ttf",
        "700": "https://fonts.gstatic.com/s/arsenalsc/v1/x3dmckLHea6e5BEtsfxiZGYDly7HAQsyA2Y.ttf",
        "700italic": "https://fonts.gstatic.com/s/arsenalsc/v1/x3d4ckLHea6e5BEtsfxibNgeCyvNBSk3E2YljQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arsenalsc/v1/x3dlckLHea6e5BEtsfxibNsmtw.ttf"
    },
    {
      "family": "Artifika",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/artifika/v21/VEMyRoxzronptCuxu6Wt5jDtreOL.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/artifika/v21/VEMyRoxzronptCuxu5Ws7DQ.ttf"
    },
    {
      "family": "Arvo",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arvo/v23/tDbD2oWUg0MKmSAa7Lzr7vs.ttf",
        "italic": "https://fonts.gstatic.com/s/arvo/v23/tDbN2oWUg0MKqSIQ6J7u_vvijQ.ttf",
        "700": "https://fonts.gstatic.com/s/arvo/v23/tDbM2oWUg0MKoZw1yLTA8vL7lAE.ttf",
        "700italic": "https://fonts.gstatic.com/s/arvo/v23/tDbO2oWUg0MKqSIoVLHK9tD-hAHkGg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arvo/v23/tDbD2oWUg0MKqSEQ6A.ttf"
    },
    {
      "family": "Arya",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/arya/v20/ga6CawNG-HJd9Ub1-beqdFE.ttf",
        "700": "https://fonts.gstatic.com/s/arya/v20/ga6NawNG-HJdzfra3b-BaFg3dRE.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/arya/v20/ga6CawNG-HJdxUf__Q.ttf"
    },
    {
      "family": "Asap",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v33",
      "lastModified": "2025-06-25",
      "files": {
        "100": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqQsLmOXoA7Glw.ttf",
        "200": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYEqUsLmOXoA7Glw.ttf",
        "300": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYzKUsLmOXoA7Glw.ttf",
        "regular": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqUsLmOXoA7Glw.ttf",
        "500": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYoKUsLmOXoA7Glw.ttf",
        "600": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYTKIsLmOXoA7Glw.ttf",
        "700": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYdaIsLmOXoA7Glw.ttf",
        "800": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYEqIsLmOXoA7Glw.ttf",
        "900": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYO6IsLmOXoA7Glw.ttf",
        "100italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWubEbGmTggvWl0Qn.ttf",
        "200italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZEbWmTggvWl0Qn.ttf",
        "300italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuaabWmTggvWl0Qn.ttf",
        "italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWubEbWmTggvWl0Qn.ttf",
        "500italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWub2bWmTggvWl0Qn.ttf",
        "600italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuYaammTggvWl0Qn.ttf",
        "700italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuYjammTggvWl0Qn.ttf",
        "800italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZEammTggvWl0Qn.ttf",
        "900italic": "https://fonts.gstatic.com/s/asap/v33/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZtammTggvWl0Qn.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/asap/v33/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqUcL2mT.ttf"
    },
    {
      "family": "Asap Condensed",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO9DSWlEgGqgp-pO.ttf",
        "200italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUIFFim6CovpOkXA.ttf",
        "300": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO8nSmlEgGqgp-pO.ttf",
        "300italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUOVGim6CovpOkXA.ttf",
        "regular": "https://fonts.gstatic.com/s/asapcondensed/v17/pxidypY1o9NHyXh3WvSbGSggdNeLYk1Mq3ap.ttf",
        "italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxifypY1o9NHyXh3WvSbGSggdOeJaElurmapvvM.ttf",
        "500": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO9_S2lEgGqgp-pO.ttf",
        "500italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUL1Him6CovpOkXA.ttf",
        "600": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO9TTGlEgGqgp-pO.ttf",
        "600italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUJFAim6CovpOkXA.ttf",
        "700": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO83TWlEgGqgp-pO.ttf",
        "700italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUPVBim6CovpOkXA.ttf",
        "800": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO8rTmlEgGqgp-pO.ttf",
        "800italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUOlCim6CovpOkXA.ttf",
        "900": "https://fonts.gstatic.com/s/asapcondensed/v17/pxieypY1o9NHyXh3WvSbGSggdO8PT2lEgGqgp-pO.ttf",
        "900italic": "https://fonts.gstatic.com/s/asapcondensed/v17/pxiYypY1o9NHyXh3WvSbGSggdOeJUM1Dim6CovpOkXA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/asapcondensed/v17/pxidypY1o9NHyXh3WvSbGSggdOeKaEk.ttf"
    },
    {
      "family": "Asar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/asar/v23/sZlLdRyI6TBIXkYQDLlTW6E.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/asar/v23/sZlLdRyI6TBIbkcaCA.ttf"
    },
    {
      "family": "Asset",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v29",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/asset/v29/SLXGc1na-mM4cWImRJqExst1.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/asset/v29/SLXGc1na-mM4cVInTp4.ttf"
    },
    {
      "family": "Assistant",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtmZnEGGf3qGuvM4.ttf",
        "300": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtrhnEGGf3qGuvM4.ttf",
        "regular": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtuZnEGGf3qGuvM4.ttf",
        "500": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQttRnEGGf3qGuvM4.ttf",
        "600": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtjhgEGGf3qGuvM4.ttf",
        "700": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtgFgEGGf3qGuvM4.ttf",
        "800": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtmZgEGGf3qGuvM4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/assistant/v23/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtuZnIGCV2g.ttf"
    },
    {
      "family": "Asta Sans",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo6r_mVnvqYRoVr0.ttf",
        "regular": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo_T_mVnvqYRoVr0.ttf",
        "500": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo8b_mVnvqYRoVr0.ttf",
        "600": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveoyr4mVnvqYRoVr0.ttf",
        "700": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveoxP4mVnvqYRoVr0.ttf",
        "800": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo3T4mVnvqYRoVr0.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/astasans/v2/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo_T_qVjlrQ.ttf"
    },
    {
      "family": "Astloch",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/astloch/v26/TuGRUVJ8QI5GSeUjq9wRzMtkH1Q.ttf",
        "700": "https://fonts.gstatic.com/s/astloch/v26/TuGUUVJ8QI5GSeUjk2A-6MNPA10xLMQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/astloch/v26/TuGRUVJ8QI5GSeUjm90byA.ttf"
    },
    {
      "family": "Asul",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/asul/v22/VuJ-dNjKxYr46fMFXK78JIg.ttf",
        "700": "https://fonts.gstatic.com/s/asul/v22/VuJxdNjKxYr40U8qeKbXOIFneRo.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/asul/v22/VuJ-dNjKxYr42fIPWA.ttf"
    },
    {
      "family": "Athiti",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/athiti/v13/pe0sMISdLIZIv1wAxDNyAv2-C99ycg.ttf",
        "300": "https://fonts.gstatic.com/s/athiti/v13/pe0sMISdLIZIv1wAoDByAv2-C99ycg.ttf",
        "regular": "https://fonts.gstatic.com/s/athiti/v13/pe0vMISdLIZIv1w4DBhWCtaiAg.ttf",
        "500": "https://fonts.gstatic.com/s/athiti/v13/pe0sMISdLIZIv1wA-DFyAv2-C99ycg.ttf",
        "600": "https://fonts.gstatic.com/s/athiti/v13/pe0sMISdLIZIv1wA1DZyAv2-C99ycg.ttf",
        "700": "https://fonts.gstatic.com/s/athiti/v13/pe0sMISdLIZIv1wAsDdyAv2-C99ycg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/athiti/v13/pe0vMISdLIZIv1wIDRJS.ttf"
    },
    {
      "family": "Atkinson Hyperlegible",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/atkinsonhyperlegible/v11/9Bt23C1KxNDXMspQ1lPyU89-1h6ONRlW45GE5ZgpewSSbQ.ttf",
        "italic": "https://fonts.gstatic.com/s/atkinsonhyperlegible/v11/9Bt43C1KxNDXMspQ1lPyU89-1h6ONRlW45G055ItWQGCbUWn.ttf",
        "700": "https://fonts.gstatic.com/s/atkinsonhyperlegible/v11/9Bt73C1KxNDXMspQ1lPyU89-1h6ONRlW45G8WbcNcy-OZFy-FA.ttf",
        "700italic": "https://fonts.gstatic.com/s/atkinsonhyperlegible/v11/9Bt93C1KxNDXMspQ1lPyU89-1h6ONRlW45G056qRdiWKRlmuFH24.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/atkinsonhyperlegible/v11/9Bt23C1KxNDXMspQ1lPyU89-1h6ONRlW45G05JIt.ttf"
    },
    {
      "family": "Atkinson Hyperlegible Mono",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZnNeiDSkb2qzelw.ttf",
        "300": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZQteiDSkb2qzelw.ttf",
        "regular": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZHNeiDSkb2qzelw.ttf",
        "500": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZLteiDSkb2qzelw.ttf",
        "600": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZwtCiDSkb2qzelw.ttf",
        "700": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZ-9CiDSkb2qzelw.ttf",
        "800": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZnNCiDSkb2qzelw.ttf",
        "200italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JTKTiMf-KnOlxYs.ttf",
        "300italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JQUTiMf-KnOlxYs.ttf",
        "italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JRKTiMf-KnOlxYs.ttf",
        "500italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JR4TiMf-KnOlxYs.ttf",
        "600italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JSUSSMf-KnOlxYs.ttf",
        "700italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JStSSMf-KnOlxYs.ttf",
        "800italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JTKSSMf-KnOlxYs.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v7/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZHNeSDCMf.ttf"
    },
    {
      "family": "Atkinson Hyperlegible Next",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3bLQhtNl93TwPEQ.ttf",
        "300": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3srQhtNl93TwPEQ.ttf",
        "regular": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW37LQhtNl93TwPEQ.ttf",
        "500": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW33rQhtNl93TwPEQ.ttf",
        "600": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3MrMhtNl93TwPEQ.ttf",
        "700": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3C7MhtNl93TwPEQ.ttf",
        "800": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3bLMhtNl93TwPEQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPdJ99N5_zkfEYNP.ttf",
        "300italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPeX99N5_zkfEYNP.ttf",
        "italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPfJ99N5_zkfEYNP.ttf",
        "500italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPf799N5_zkfEYNP.ttf",
        "600italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPcX8NN5_zkfEYNP.ttf",
        "700italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPcu8NN5_zkfEYNP.ttf",
        "800italic": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPdJ8NN5_zkfEYNP.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v6/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW37LQRtdN5.ttf"
    },
    {
      "family": "Atma",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "bengali",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-04-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/atma/v18/uK_z4rqWc-Eoo8JzKjc9PvedRkM.ttf",
        "regular": "https://fonts.gstatic.com/s/atma/v18/uK_84rqWc-Eom25bDj8WIv4.ttf",
        "500": "https://fonts.gstatic.com/s/atma/v18/uK_z4rqWc-Eoo5pyKjc9PvedRkM.ttf",
        "600": "https://fonts.gstatic.com/s/atma/v18/uK_z4rqWc-Eoo7Z1Kjc9PvedRkM.ttf",
        "700": "https://fonts.gstatic.com/s/atma/v18/uK_z4rqWc-Eoo9J0Kjc9PvedRkM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/atma/v18/uK_84rqWc-Eoq29RCg.ttf"
    },
    {
      "family": "Atomic Age",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/atomicage/v28/f0Xz0eug6sdmRFkYZZGL58Ht9a8GYeA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/atomicage/v28/f0Xz0eug6sdmRFkYZZGL18Dn8Q.ttf"
    },
    {
      "family": "Aubrey",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v28",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/aubrey/v28/q5uGsou7NPBw-p7vugNsCxVEgA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/aubrey/v28/q5uGsou7NPBw-p7fuwlo.ttf"
    },
    {
      "family": "Audiowide",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/audiowide/v21/l7gdbjpo0cum0ckerWCtkQXPExpQBw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/audiowide/v21/l7gdbjpo0cum0ckerWCdkA_L.ttf"
    },
    {
      "family": "Autour One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/autourone/v24/UqyVK80cP25l3fJgbdfbk5lWVscxdKE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/autourone/v24/UqyVK80cP25l3fJgbdfbo5hcUg.ttf"
    },
    {
      "family": "Average",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/average/v18/fC1hPYBHe23MxA7rIeJwVWytTyk.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/average/v18/fC1hPYBHe23MxA7rEeN6UQ.ttf"
    },
    {
      "family": "Average Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/averagesans/v16/1Ptpg8fLXP2dlAXR-HlJJNJPBdqazVoK4A.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/averagesans/v16/1Ptpg8fLXP2dlAXR-HlJJNJ_BNCe.ttf"
    },
    {
      "family": "Averia Gruesa Libre",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/averiagruesalibre/v22/NGSov4nEGEktOaDRKsY-1dhh8eEtIx3ZUmmJw0SLRA8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/averiagruesalibre/v22/NGSov4nEGEktOaDRKsY-1dhh8eEtIx3ZYmiDxw.ttf"
    },
    {
      "family": "Averia Libre",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/averialibre/v16/2V0FKIcMGZEnV6xygz7eNjEarovtb07t-pQgTw.ttf",
        "300italic": "https://fonts.gstatic.com/s/averialibre/v16/2V0HKIcMGZEnV6xygz7eNjESAJFhbUTp2JEwT4Sk.ttf",
        "regular": "https://fonts.gstatic.com/s/averialibre/v16/2V0aKIcMGZEnV6xygz7eNjEiAqPJZ2Xx8w.ttf",
        "italic": "https://fonts.gstatic.com/s/averialibre/v16/2V0EKIcMGZEnV6xygz7eNjESAKnNRWDh8405.ttf",
        "700": "https://fonts.gstatic.com/s/averialibre/v16/2V0FKIcMGZEnV6xygz7eNjEavoztb07t-pQgTw.ttf",
        "700italic": "https://fonts.gstatic.com/s/averialibre/v16/2V0HKIcMGZEnV6xygz7eNjESAJFxakTp2JEwT4Sk.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/averialibre/v16/2V0aKIcMGZEnV6xygz7eNjESA6nN.ttf"
    },
    {
      "family": "Averia Sans Libre",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6SaxZG_G5OvCf_rt7FH3B6BHLMEd3lMKcQJZP1LmD9.ttf",
        "300italic": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6caxZG_G5OvCf_rt7FH3B6BHLMEdVLKisSL5fXK3D9qtg.ttf",
        "regular": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6XaxZG_G5OvCf_rt7FH3B6BHLMEeVJGIMYDo_8.ttf",
        "italic": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6RaxZG_G5OvCf_rt7FH3B6BHLMEdVLEoc6C5_8N3k.ttf",
        "700": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6SaxZG_G5OvCf_rt7FH3B6BHLMEd31N6cQJZP1LmD9.ttf",
        "700italic": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6caxZG_G5OvCf_rt7FH3B6BHLMEdVLKjsVL5fXK3D9qtg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/averiasanslibre/v20/ga6XaxZG_G5OvCf_rt7FH3B6BHLMEdVIEoc.ttf"
    },
    {
      "family": "Averia Serif Libre",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIVzD2ms4wxr6GvjeD0X88SHPyX2xYGCSmqwacqdrKvbQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIbzD2ms4wxr6GvjeD0X88SHPyX2xYOpzMmw60uVLe_bXHq.ttf",
        "regular": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIWzD2ms4wxr6GvjeD0X88SHPyX2xY-pQGOyYw2fw.ttf",
        "italic": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIUzD2ms4wxr6GvjeD0X88SHPyX2xYOpwuK64kmf6u2.ttf",
        "700": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIVzD2ms4wxr6GvjeD0X88SHPyX2xYGGS6qwacqdrKvbQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIbzD2ms4wxr6GvjeD0X88SHPyX2xYOpzM2xK0uVLe_bXHq.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/averiaseriflibre/v19/neIWzD2ms4wxr6GvjeD0X88SHPyX2xYOpAuK.ttf"
    },
    {
      "family": "Azeret Mono",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPRh0raa-5s3AA.ttf",
        "200": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfHPVh0raa-5s3AA.ttf",
        "300": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfwvVh0raa-5s3AA.ttf",
        "regular": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPVh0raa-5s3AA.ttf",
        "500": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfrvVh0raa-5s3AA.ttf",
        "600": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfQvJh0raa-5s3AA.ttf",
        "700": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfe_Jh0raa-5s3AA.ttf",
        "800": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfHPJh0raa-5s3AA.ttf",
        "900": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfNfJh0raa-5s3AA.ttf",
        "100italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLaJkLye2Z4nAN7J.ttf",
        "200italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYJkbye2Z4nAN7J.ttf",
        "300italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLbXkbye2Z4nAN7J.ttf",
        "italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLaJkbye2Z4nAN7J.ttf",
        "500italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLa7kbye2Z4nAN7J.ttf",
        "600italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLZXlrye2Z4nAN7J.ttf",
        "700italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLZulrye2Z4nAN7J.ttf",
        "800italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYJlrye2Z4nAN7J.ttf",
        "900italic": "https://fonts.gstatic.com/s/azeretmono/v20/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYglrye2Z4nAN7J.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/azeretmono/v20/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPVR07ye.ttf"
    },
    {
      "family": "B612",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/b612/v12/3JnySDDxiSz32jm4GDigUXw.ttf",
        "italic": "https://fonts.gstatic.com/s/b612/v12/3Jn8SDDxiSz36juyHBqlQXwdVw.ttf",
        "700": "https://fonts.gstatic.com/s/b612/v12/3Jn9SDDxiSz34oWXPDCLTXUETuE.ttf",
        "700italic": "https://fonts.gstatic.com/s/b612/v12/3Jn_SDDxiSz36juKoDWBSVcBXuFb0Q.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/b612/v12/3JnySDDxiSz36jiyHA.ttf"
    },
    {
      "family": "B612 Mono",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/b612mono/v15/kmK_Zq85QVWbN1eW6lJl1wTcquRTtg.ttf",
        "italic": "https://fonts.gstatic.com/s/b612mono/v15/kmK5Zq85QVWbN1eW6lJV1Q7YiOFDtqtf.ttf",
        "700": "https://fonts.gstatic.com/s/b612mono/v15/kmK6Zq85QVWbN1eW6lJdayv4os9Pv7JGSg.ttf",
        "700italic": "https://fonts.gstatic.com/s/b612mono/v15/kmKkZq85QVWbN1eW6lJV1TZkp8VLnbdWSg4x.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/b612mono/v15/kmK_Zq85QVWbN1eW6lJV1g7Y.ttf"
    },
    {
      "family": "BIZ UDGothic",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "greek-ext",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bizudgothic/v12/daafSTouBF7RUjnbt8p3LuKttQN98z_MbQ.ttf",
        "700": "https://fonts.gstatic.com/s/bizudgothic/v12/daaASTouBF7RUjnbt8p3LuKVCSxZ-xTQZMhbaA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bizudgothic/v12/daafSTouBF7RUjnbt8p3LuKdtAl5.ttf"
    },
    {
      "family": "BIZ UDMincho",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "greek-ext",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bizudmincho/v11/EJRRQgI6eOxFjBdKs38yhtW1dwT7rcpY8Q.ttf",
        "700": "https://fonts.gstatic.com/s/bizudmincho/v11/EJROQgI6eOxFjBdKs38yhtWNyyvfpeFE-IyCrw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bizudmincho/v11/EJRRQgI6eOxFjBdKs38yhtWFdg7_.ttf"
    },
    {
      "family": "BIZ UDPGothic",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "greek-ext",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bizudpgothic/v14/hES36X5pHAIBjmS84VL0Bue83nUMQWkMUAk.ttf",
        "700": "https://fonts.gstatic.com/s/bizudpgothic/v14/hESq6X5pHAIBjmS84VL0Bue85skjZWEnTABCSQo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bizudpgothic/v14/hES36X5pHAIBjmS84VL0Bue87nQGRQ.ttf"
    },
    {
      "family": "BIZ UDPMincho",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "greek-ext",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bizudpmincho/v11/ypvfbXOBrmYppy7oWWTg1_58nhhYtUb0gZk.ttf",
        "700": "https://fonts.gstatic.com/s/bizudpmincho/v11/ypvCbXOBrmYppy7oWWTg1_58pqR3kU7fnZAy57k.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bizudpmincho/v11/ypvfbXOBrmYppy7oWWTg1_58rhlSsQ.ttf"
    },
    {
      "family": "Babylonica",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/babylonica/v6/5aUw9_i2qxWVCAE2aHjTqDJ0-VVMoEw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/babylonica/v6/5aUw9_i2qxWVCAE2aHjTmDN-_Q.ttf"
    },
    {
      "family": "Bacasime Antique",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bacasimeantique/v1/tDbX2pGXkFYEykldjZSrmI6T_XWZOwStSUrV_BE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bacasimeantique/v1/tDbX2pGXkFYEykldjZSrmI6T_XWZCwWnTQ.ttf"
    },
    {
      "family": "Bad Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/badscript/v17/6NUT8F6PJgbFWQn47_x7lOwuzd1AZtw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/badscript/v17/6NUT8F6PJgbFWQn47_x7pO0kyQ.ttf"
    },
    {
      "family": "Badeen Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/badeendisplay/v1/pxidypY2sdZSjFU4cPmNBzckadeLYk1Mq3ap.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/badeendisplay/v1/pxidypY2sdZSjFU4cPmNBzckaeeKaEk.ttf"
    },
    {
      "family": "Bagel Fat One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bagelfatone/v2/hYkPPucsQOr5dy02WmQr5Zkd0B5mvv0dSbM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bagelfatone/v2/hYkPPucsQOr5dy02WmQr5Zkd4B9sug.ttf"
    },
    {
      "family": "Bahiana",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bahiana/v24/uU9PCBUV4YenPWJU7xPb3vyHmlI.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bahiana/v24/uU9PCBUV4YenPWJU3xLR2g.ttf"
    },
    {
      "family": "Bahianita",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bahianita/v22/yYLr0hTb3vuqqsBUgxWtxTvV2NJPcA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bahianita/v22/yYLr0hTb3vuqqsBUgxWdxDHR.ttf"
    },
    {
      "family": "Bai Jamjuree",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIqapSCOBt_aeQQ7ftydoa0kePuk5A1-yiSgA.ttf",
        "200italic": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIoapSCOBt_aeQQ7ftydoa8W_oGkpox2S2CgOva.ttf",
        "300": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIqapSCOBt_aeQQ7ftydoa09eDuk5A1-yiSgA.ttf",
        "300italic": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIoapSCOBt_aeQQ7ftydoa8W_pikZox2S2CgOva.ttf",
        "regular": "https://fonts.gstatic.com/s/baijamjuree/v12/LDI1apSCOBt_aeQQ7ftydoaMWcjKm7sp8g.ttf",
        "italic": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIrapSCOBt_aeQQ7ftydoa8W8LOub458jGL.ttf",
        "500": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIqapSCOBt_aeQQ7ftydoa0reHuk5A1-yiSgA.ttf",
        "500italic": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIoapSCOBt_aeQQ7ftydoa8W_o6kJox2S2CgOva.ttf",
        "600": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIqapSCOBt_aeQQ7ftydoa0gebuk5A1-yiSgA.ttf",
        "600italic": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIoapSCOBt_aeQQ7ftydoa8W_oWl5ox2S2CgOva.ttf",
        "700": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIqapSCOBt_aeQQ7ftydoa05efuk5A1-yiSgA.ttf",
        "700italic": "https://fonts.gstatic.com/s/baijamjuree/v12/LDIoapSCOBt_aeQQ7ftydoa8W_pylpox2S2CgOva.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baijamjuree/v12/LDI1apSCOBt_aeQQ7ftydoa8WMLO.ttf"
    },
    {
      "family": "Bakbak One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bakbakone/v10/zOL54pXAl6RI-p_ardnuycRuv-hHkOs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bakbakone/v10/zOL54pXAl6RI-p_ardnu-cVkuw.ttf"
    },
    {
      "family": "Ballet",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ballet/v29/QGYyz_MYZA-HM4NjuGOVnUEXme1I4Xi3C4G-EiAou6Y.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ballet/v29/QGYyz_MYZA-HM4NjuGOVnUEXme1I4Xi3O4C0Fg.ttf"
    },
    {
      "family": "Baloo 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloo2/v22/wXK0E3kTposypRydzVT08TS3JnAmtdgazapv9Fat7WcN.ttf",
        "500": "https://fonts.gstatic.com/s/baloo2/v22/wXK0E3kTposypRydzVT08TS3JnAmtdgozapv9Fat7WcN.ttf",
        "600": "https://fonts.gstatic.com/s/baloo2/v22/wXK0E3kTposypRydzVT08TS3JnAmtdjEyqpv9Fat7WcN.ttf",
        "700": "https://fonts.gstatic.com/s/baloo2/v22/wXK0E3kTposypRydzVT08TS3JnAmtdj9yqpv9Fat7WcN.ttf",
        "800": "https://fonts.gstatic.com/s/baloo2/v22/wXK0E3kTposypRydzVT08TS3JnAmtdiayqpv9Fat7WcN.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloo2/v22/wXK0E3kTposypRydzVT08TS3JnAmtdgazZpu_lI.ttf"
    },
    {
      "family": "Baloo Bhai 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloobhai2/v29/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNighMXeCo-jsZzo.ttf",
        "500": "https://fonts.gstatic.com/s/baloobhai2/v29/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNhohMXeCo-jsZzo.ttf",
        "600": "https://fonts.gstatic.com/s/baloobhai2/v29/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNvYmMXeCo-jsZzo.ttf",
        "700": "https://fonts.gstatic.com/s/baloobhai2/v29/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNs8mMXeCo-jsZzo.ttf",
        "800": "https://fonts.gstatic.com/s/baloobhai2/v29/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNqgmMXeCo-jsZzo.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloobhai2/v29/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNighAXaIpw.ttf"
    },
    {
      "family": "Baloo Bhaijaan 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloobhaijaan2/v20/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TyRSqP4L4ppfcyC.ttf",
        "500": "https://fonts.gstatic.com/s/baloobhaijaan2/v20/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TyjSqP4L4ppfcyC.ttf",
        "600": "https://fonts.gstatic.com/s/baloobhaijaan2/v20/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TxPTaP4L4ppfcyC.ttf",
        "700": "https://fonts.gstatic.com/s/baloobhaijaan2/v20/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8Tx2TaP4L4ppfcyC.ttf",
        "800": "https://fonts.gstatic.com/s/baloobhaijaan2/v20/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TwRTaP4L4ppfcyC.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloobhaijaan2/v20/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TyRSpP5JY4.ttf"
    },
    {
      "family": "Baloo Bhaina 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "oriya",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloobhaina2/v28/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEssPvRfRLYWmZSA.ttf",
        "500": "https://fonts.gstatic.com/s/baloobhaina2/v28/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEgMPvRfRLYWmZSA.ttf",
        "600": "https://fonts.gstatic.com/s/baloobhaina2/v28/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEbMTvRfRLYWmZSA.ttf",
        "700": "https://fonts.gstatic.com/s/baloobhaina2/v28/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEVcTvRfRLYWmZSA.ttf",
        "800": "https://fonts.gstatic.com/s/baloobhaina2/v28/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEMsTvRfRLYWmZSA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloobhaina2/v28/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEssPfRP5P.ttf"
    },
    {
      "family": "Baloo Chettan 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "malayalam",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloochettan2/v22/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CeKTO1oeH9xI2gc.ttf",
        "500": "https://fonts.gstatic.com/s/baloochettan2/v22/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CdCTO1oeH9xI2gc.ttf",
        "600": "https://fonts.gstatic.com/s/baloochettan2/v22/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CTyUO1oeH9xI2gc.ttf",
        "700": "https://fonts.gstatic.com/s/baloochettan2/v22/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CQWUO1oeH9xI2gc.ttf",
        "800": "https://fonts.gstatic.com/s/baloochettan2/v22/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CWKUO1oeH9xI2gc.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloochettan2/v22/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CeKTC1sUGw.ttf"
    },
    {
      "family": "Baloo Da 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "bengali",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/balooda2/v25/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjALsTNe55aRa7UE.ttf",
        "500": "https://fonts.gstatic.com/s/balooda2/v25/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjA5sTNe55aRa7UE.ttf",
        "600": "https://fonts.gstatic.com/s/balooda2/v25/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjDVtjNe55aRa7UE.ttf",
        "700": "https://fonts.gstatic.com/s/balooda2/v25/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjDstjNe55aRa7UE.ttf",
        "800": "https://fonts.gstatic.com/s/balooda2/v25/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjCLtjNe55aRa7UE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/balooda2/v25/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjALsQNf7ZI.ttf"
    },
    {
      "family": "Baloo Paaji 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloopaaji2/v28/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9AX74fybRUz1r5t.ttf",
        "500": "https://fonts.gstatic.com/s/baloopaaji2/v28/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9Al74fybRUz1r5t.ttf",
        "600": "https://fonts.gstatic.com/s/baloopaaji2/v28/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9DJ6IfybRUz1r5t.ttf",
        "700": "https://fonts.gstatic.com/s/baloopaaji2/v28/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9Dw6IfybRUz1r5t.ttf",
        "800": "https://fonts.gstatic.com/s/baloopaaji2/v28/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9CX6IfybRUz1r5t.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloopaaji2/v28/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9AX77fzZxE.ttf"
    },
    {
      "family": "Baloo Tamma 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/balootamma2/v19/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMscPp-0IF71SGC5.ttf",
        "500": "https://fonts.gstatic.com/s/balootamma2/v19/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMsuPp-0IF71SGC5.ttf",
        "600": "https://fonts.gstatic.com/s/balootamma2/v19/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMvCOZ-0IF71SGC5.ttf",
        "700": "https://fonts.gstatic.com/s/balootamma2/v19/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMv7OZ-0IF71SGC5.ttf",
        "800": "https://fonts.gstatic.com/s/balootamma2/v19/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMucOZ-0IF71SGC5.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/balootamma2/v19/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMscPq-1Klo.ttf"
    },
    {
      "family": "Baloo Tammudu 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "telugu",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/balootammudu2/v26/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_Jf8e4c6PZSlGmAA.ttf",
        "500": "https://fonts.gstatic.com/s/balootammudu2/v26/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_Jc0e4c6PZSlGmAA.ttf",
        "600": "https://fonts.gstatic.com/s/balootammudu2/v26/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_JSEZ4c6PZSlGmAA.ttf",
        "700": "https://fonts.gstatic.com/s/balootammudu2/v26/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_JRgZ4c6PZSlGmAA.ttf",
        "800": "https://fonts.gstatic.com/s/balootammudu2/v26/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_JX8Z4c6PZSlGmAA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/balootammudu2/v26/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_Jf8e0c-FYQ.ttf"
    },
    {
      "family": "Baloo Thambi 2",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil",
        "vietnamese"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baloothambi2/v21/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKzcIzaQRG_n4osQ.ttf",
        "500": "https://fonts.gstatic.com/s/baloothambi2/v21/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbK_8IzaQRG_n4osQ.ttf",
        "600": "https://fonts.gstatic.com/s/baloothambi2/v21/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKE8UzaQRG_n4osQ.ttf",
        "700": "https://fonts.gstatic.com/s/baloothambi2/v21/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKKsUzaQRG_n4osQ.ttf",
        "800": "https://fonts.gstatic.com/s/baloothambi2/v21/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKTcUzaQRG_n4osQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baloothambi2/v21/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKzcIDaA5C.ttf"
    },
    {
      "family": "Balsamiq Sans",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/balsamiqsans/v14/P5sEzZiAbNrN8SB3lQQX7Pnc8dkdIYdNHzs.ttf",
        "italic": "https://fonts.gstatic.com/s/balsamiqsans/v14/P5sazZiAbNrN8SB3lQQX7PncwdsXJaVIDzvcXA.ttf",
        "700": "https://fonts.gstatic.com/s/balsamiqsans/v14/P5sZzZiAbNrN8SB3lQQX7PncyWUyBY9mAzLFRQI.ttf",
        "700italic": "https://fonts.gstatic.com/s/balsamiqsans/v14/P5sfzZiAbNrN8SB3lQQX7PncwdsvmYpsBxDAVQI4aA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/balsamiqsans/v14/P5sEzZiAbNrN8SB3lQQX7PncwdgXJQ.ttf"
    },
    {
      "family": "Balthazar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/balthazar/v17/d6lKkaajS8Gm4CVQjFEvyRTo39l8hw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/balthazar/v17/d6lKkaajS8Gm4CVQjFEfyB7s.ttf"
    },
    {
      "family": "Bangers",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bangers/v24/FeVQS0BTqb0h60ACL5la2bxii28.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bangers/v24/FeVQS0BTqb0h60ACH5hQ3Q.ttf"
    },
    {
      "family": "Barlow",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/barlow/v12/7cHrv4kjgoGqM7E3b8s8yn4hnCci.ttf",
        "100italic": "https://fonts.gstatic.com/s/barlow/v12/7cHtv4kjgoGqM7E_CfNYwHoDmTcibrA.ttf",
        "200": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3w-oc4FAtlT47dw.ttf",
        "200italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfP04Voptzsrd6m9.ttf",
        "300": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3p-kc4FAtlT47dw.ttf",
        "300italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfOQ4loptzsrd6m9.ttf",
        "regular": "https://fonts.gstatic.com/s/barlow/v12/7cHpv4kjgoGqM7EPC8E46HsxnA.ttf",
        "italic": "https://fonts.gstatic.com/s/barlow/v12/7cHrv4kjgoGqM7E_Ccs8yn4hnCci.ttf",
        "500": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3_-gc4FAtlT47dw.ttf",
        "500italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfPI41optzsrd6m9.ttf",
        "600": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E30-8c4FAtlT47dw.ttf",
        "600italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfPk5Foptzsrd6m9.ttf",
        "700": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3t-4c4FAtlT47dw.ttf",
        "700italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfOA5Voptzsrd6m9.ttf",
        "800": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3q-0c4FAtlT47dw.ttf",
        "800italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfOc5loptzsrd6m9.ttf",
        "900": "https://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3j-wc4FAtlT47dw.ttf",
        "900italic": "https://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfO451optzsrd6m9.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/barlow/v12/7cHpv4kjgoGqM7E_Css8.ttf"
    },
    {
      "family": "Barlow Condensed",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxxL3I-JCGChYJ8VI-L6OO_au7B43LT31vytKgbaw.ttf",
        "100italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxzL3I-JCGChYJ8VI-L6OO_au7B6xTru1H2lq0La6JN.ttf",
        "200": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B497y_3HcuKECcrs.ttf",
        "200italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrF3DWvIMHYrtUxg.ttf",
        "300": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B47rx_3HcuKECcrs.ttf",
        "300italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrc3PWvIMHYrtUxg.ttf",
        "regular": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTx3L3I-JCGChYJ8VI-L6OO_au7B2xbZ23n3pKg.ttf",
        "italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxxL3I-JCGChYJ8VI-L6OO_au7B6xTT31vytKgbaw.ttf",
        "500": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B4-Lw_3HcuKECcrs.ttf",
        "500italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrK3LWvIMHYrtUxg.ttf",
        "600": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B4873_3HcuKECcrs.ttf",
        "600italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrB3XWvIMHYrtUxg.ttf",
        "700": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B46r2_3HcuKECcrs.ttf",
        "700italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrY3TWvIMHYrtUxg.ttf",
        "800": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B47b1_3HcuKECcrs.ttf",
        "800italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrf3fWvIMHYrtUxg.ttf",
        "900": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B45L0_3HcuKECcrs.ttf",
        "900italic": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrW3bWvIMHYrtUxg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/barlowcondensed/v12/HTx3L3I-JCGChYJ8VI-L6OO_au7B6xfT3w.ttf"
    },
    {
      "family": "Barlow Semi Condensed",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlphgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfG4qvKk8ogoSP.ttf",
        "100italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpjgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbLLIEsKh5SPZWs.ttf",
        "200": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRft6uPAGEki52WfA.ttf",
        "200italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbJnAWsgqZiGfHK5.ttf",
        "300": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRf06iPAGEki52WfA.ttf",
        "300italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbIDAmsgqZiGfHK5.ttf",
        "regular": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpvgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRnf4CrCEo4gg.ttf",
        "italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlphgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfYqvKk8ogoSP.ttf",
        "500": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfi6mPAGEki52WfA.ttf",
        "500italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbJbA2sgqZiGfHK5.ttf",
        "600": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfp66PAGEki52WfA.ttf",
        "600italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbJ3BGsgqZiGfHK5.ttf",
        "700": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfw6-PAGEki52WfA.ttf",
        "700italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbITBWsgqZiGfHK5.ttf",
        "800": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRf36yPAGEki52WfA.ttf",
        "800italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbIPBmsgqZiGfHK5.ttf",
        "900": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRf-62PAGEki52WfA.ttf",
        "900italic": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbIrB2sgqZiGfHK5.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/barlowsemicondensed/v15/wlpvgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfoqv.ttf"
    },
    {
      "family": "Barriecito",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/barriecito/v17/WWXXlj-CbBOSLY2QTuY_KdUiYwTO0MU.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/barriecito/v17/WWXXlj-CbBOSLY2QTuY_GdQoZw.ttf"
    },
    {
      "family": "Barrio",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/barrio/v19/wEO8EBXBk8hBIDiEdQYhWdsX1Q.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/barrio/v19/wEO8EBXBk8hBIDi0dAwl.ttf"
    },
    {
      "family": "Basic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/basic/v17/xfu_0WLxV2_XKQN34lDVyR7D.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/basic/v17/xfu_0WLxV2_XKTN26FQ.ttf"
    },
    {
      "family": "Baskervville",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baskervville/v19/YA9Br0yU4l_XOrogbkun3kQ6vLFYXmpq8sRsYuDrugOydR1FLkw.ttf",
        "500": "https://fonts.gstatic.com/s/baskervville/v19/YA9Br0yU4l_XOrogbkun3kQ6vLFYXmpq8sRsYtLrugOydR1FLkw.ttf",
        "600": "https://fonts.gstatic.com/s/baskervville/v19/YA9Br0yU4l_XOrogbkun3kQ6vLFYXmpq8sRsYj7sugOydR1FLkw.ttf",
        "700": "https://fonts.gstatic.com/s/baskervville/v19/YA9Br0yU4l_XOrogbkun3kQ6vLFYXmpq8sRsYgfsugOydR1FLkw.ttf",
        "italic": "https://fonts.gstatic.com/s/baskervville/v19/YA9Hr0yU4l_XOrogbkun3kQQtYOnhgMBaGprdyioUkC4cT9APkyagA.ttf",
        "500italic": "https://fonts.gstatic.com/s/baskervville/v19/YA9Hr0yU4l_XOrogbkun3kQQtYOnhgMBaGprdyioYEC4cT9APkyagA.ttf",
        "600italic": "https://fonts.gstatic.com/s/baskervville/v19/YA9Hr0yU4l_XOrogbkun3kQQtYOnhgMBaGprdyiojEe4cT9APkyagA.ttf",
        "700italic": "https://fonts.gstatic.com/s/baskervville/v19/YA9Hr0yU4l_XOrogbkun3kQQtYOnhgMBaGprdyiotUe4cT9APkyagA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baskervville/v19/YA9Br0yU4l_XOrogbkun3kQ6vLFYXmpq8sRsYuDrigK4cQ.ttf"
    },
    {
      "family": "Baskervville SC",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-06-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baskervvillesc/v3/X7ny4bc_DeKlh6bBbk_WiKnBSUvL5HaHbrgS1MXKHjziXM3kPWntDsg.ttf",
        "500": "https://fonts.gstatic.com/s/baskervvillesc/v3/X7ny4bc_DeKlh6bBbk_WiKnBSUvL5HaHbrgS1MXKHg7iXM3kPWntDsg.ttf",
        "600": "https://fonts.gstatic.com/s/baskervvillesc/v3/X7ny4bc_DeKlh6bBbk_WiKnBSUvL5HaHbrgS1MXKHuLlXM3kPWntDsg.ttf",
        "700": "https://fonts.gstatic.com/s/baskervvillesc/v3/X7ny4bc_DeKlh6bBbk_WiKnBSUvL5HaHbrgS1MXKHtvlXM3kPWntDsg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baskervvillesc/v3/X7ny4bc_DeKlh6bBbk_WiKnBSUvL5HaHbrgS1MXKHjzibMzuOQ.ttf"
    },
    {
      "family": "Battambang",
      "variants": [
        "100",
        "300",
        "regular",
        "700",
        "900"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/battambang/v25/uk-kEGe7raEw-HjkzZabNhGp5w50_o9T7Q.ttf",
        "300": "https://fonts.gstatic.com/s/battambang/v25/uk-lEGe7raEw-HjkzZabNtmLxyRa8oZK9I0.ttf",
        "regular": "https://fonts.gstatic.com/s/battambang/v25/uk-mEGe7raEw-HjkzZabDnWj4yxx7o8.ttf",
        "700": "https://fonts.gstatic.com/s/battambang/v25/uk-lEGe7raEw-HjkzZabNsmMxyRa8oZK9I0.ttf",
        "900": "https://fonts.gstatic.com/s/battambang/v25/uk-lEGe7raEw-HjkzZabNvGOxyRa8oZK9I0.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/battambang/v25/uk-mEGe7raEw-HjkzZabPnSp5w.ttf"
    },
    {
      "family": "Baumans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/baumans/v17/-W_-XJj9QyTd3QfpR_oyaksqY5Q.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/baumans/v17/-W_-XJj9QyTd3Qfpd_s4bg.ttf"
    },
    {
      "family": "Bayon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v35",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bayon/v35/9XUrlJNmn0LPFl-pOhYEd2NJ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bayon/v35/9XUrlJNmn0LPFm-oMBI.ttf"
    },
    {
      "family": "Be Vietnam Pro",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVNSTAyLFyeg_IDWvOJmVES_HRUBX8YYbAiah8.ttf",
        "100italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVLSTAyLFyeg_IDWvOJmVES_HwyPRsSZZIneh-waA.ttf",
        "200": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HT4JF8yT7wrcwap.ttf",
        "200italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPbczRbgJdhapcUU.ttf",
        "300": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HScJ18yT7wrcwap.ttf",
        "300italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPdMwRbgJdhapcUU.ttf",
        "regular": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVPSTAyLFyeg_IDWvOJmVES_EwwD3s6ZKAi.ttf",
        "italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVNSTAyLFyeg_IDWvOJmVES_HwyBX8YYbAiah8.ttf",
        "500": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HTEJl8yT7wrcwap.ttf",
        "500italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPYsxRbgJdhapcUU.ttf",
        "600": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HToIV8yT7wrcwap.ttf",
        "600italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPac2RbgJdhapcUU.ttf",
        "700": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HSMIF8yT7wrcwap.ttf",
        "700italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPcM3RbgJdhapcUU.ttf",
        "800": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HSQI18yT7wrcwap.ttf",
        "800italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPd80RbgJdhapcUU.ttf",
        "900": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVMSTAyLFyeg_IDWvOJmVES_HS0Il8yT7wrcwap.ttf",
        "900italic": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVKSTAyLFyeg_IDWvOJmVES_HwyPfs1RbgJdhapcUU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bevietnampro/v11/QdVPSTAyLFyeg_IDWvOJmVES_HwxBX8.ttf"
    },
    {
      "family": "Beau Rivage",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/beaurivage/v2/UcCi3FIgIG2bH4mMNWJUlmg3NZp8K2sL.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/beaurivage/v2/UcCi3FIgIG2bH4mMNWJUllg2P54.ttf"
    },
    {
      "family": "Bebas Neue",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bebasneue/v15/JTUSjIg69CK48gW7PXooxW5rygbi49c.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bebasneue/v15/JTUSjIg69CK48gW7PXoo9W9hzg.ttf"
    },
    {
      "family": "Beiruti",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9Y95wujgWg2SGdV.ttf",
        "300": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9bj5wujgWg2SGdV.ttf",
        "regular": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9a95wujgWg2SGdV.ttf",
        "500": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9aP5wujgWg2SGdV.ttf",
        "600": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9Zj4AujgWg2SGdV.ttf",
        "700": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9Za4AujgWg2SGdV.ttf",
        "800": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9Y94AujgWg2SGdV.ttf",
        "900": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9YU4AujgWg2SGdV.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/beiruti/v4/JTUIjIU69Cmr9FGcYgRFEb7cdQn2-9a95zuii2w.ttf"
    },
    {
      "family": "Belanosima",
      "variants": [
        "regular",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/belanosima/v4/3y9k6bI8ejDo_3MfCDSLxABbF3JBg54.ttf",
        "600": "https://fonts.gstatic.com/s/belanosima/v4/3y9n6bI8ejDo_3MfCDSL_Nh1M3pqn5cdJ-4.ttf",
        "700": "https://fonts.gstatic.com/s/belanosima/v4/3y9n6bI8ejDo_3MfCDSL_Lx0M3pqn5cdJ-4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/belanosima/v4/3y9k6bI8ejDo_3MfCDSL9AFREw.ttf"
    },
    {
      "family": "Belgrano",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/belgrano/v18/55xvey5tM9rwKWrJZcMFirl08KDJ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/belgrano/v18/55xvey5tM9rwKWrJZfMEgL0.ttf"
    },
    {
      "family": "Bellefair",
      "variants": [
        "regular"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bellefair/v14/kJExBuYY6AAuhiXUxG19__A2pOdvDA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bellefair/v14/kJExBuYY6AAuhiXUxG1N_voy.ttf"
    },
    {
      "family": "Belleza",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/belleza/v17/0nkoC9_pNeMfhX4BtcbyawzruP8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/belleza/v17/0nkoC9_pNeMfhX4Bhcf4bw.ttf"
    },
    {
      "family": "Bellota",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/bellota/v16/MwQzbhXl3_qEpiwAID55kGMViblPtXs.ttf",
        "300italic": "https://fonts.gstatic.com/s/bellota/v16/MwQxbhXl3_qEpiwAKJBjHGEfjZtKpXulTQ.ttf",
        "regular": "https://fonts.gstatic.com/s/bellota/v16/MwQ2bhXl3_qEpiwAGJJRtGs-lbA.ttf",
        "italic": "https://fonts.gstatic.com/s/bellota/v16/MwQ0bhXl3_qEpiwAKJBbsEk7hbBWrA.ttf",
        "700": "https://fonts.gstatic.com/s/bellota/v16/MwQzbhXl3_qEpiwAIC5-kGMViblPtXs.ttf",
        "700italic": "https://fonts.gstatic.com/s/bellota/v16/MwQxbhXl3_qEpiwAKJBjDGYfjZtKpXulTQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bellota/v16/MwQ2bhXl3_qEpiwAKJNbsA.ttf"
    },
    {
      "family": "Bellota Text",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/bellotatext/v19/0FlMVP2VnlWS4f3-UE9hHXM5VfsqfQXwQy6yxg.ttf",
        "300italic": "https://fonts.gstatic.com/s/bellotatext/v19/0FlOVP2VnlWS4f3-UE9hHXMx--Gmfw_0YSuixmYK.ttf",
        "regular": "https://fonts.gstatic.com/s/bellotatext/v19/0FlTVP2VnlWS4f3-UE9hHXMB-dMOdS7sSg.ttf",
        "italic": "https://fonts.gstatic.com/s/bellotatext/v19/0FlNVP2VnlWS4f3-UE9hHXMx-9kKVyv8Sjer.ttf",
        "700": "https://fonts.gstatic.com/s/bellotatext/v19/0FlMVP2VnlWS4f3-UE9hHXM5RfwqfQXwQy6yxg.ttf",
        "700italic": "https://fonts.gstatic.com/s/bellotatext/v19/0FlOVP2VnlWS4f3-UE9hHXMx--G2eA_0YSuixmYK.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bellotatext/v19/0FlTVP2VnlWS4f3-UE9hHXMx-NkK.ttf"
    },
    {
      "family": "BenchNine",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/benchnine/v16/ahcev8612zF4jxrwMosT--tRhWa8q0v8ag.ttf",
        "regular": "https://fonts.gstatic.com/s/benchnine/v16/ahcbv8612zF4jxrwMosrV8N1jU2gog.ttf",
        "700": "https://fonts.gstatic.com/s/benchnine/v16/ahcev8612zF4jxrwMosT6-xRhWa8q0v8ag.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/benchnine/v16/ahcbv8612zF4jxrwMosbVslx.ttf"
    },
    {
      "family": "Benne",
      "variants": [
        "regular"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/benne/v23/L0xzDFAhn18E6Vjxlt6qTDBN.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/benne/v23/L0xzDFAhn18E6WjwnNo.ttf"
    },
    {
      "family": "Bentham",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bentham/v19/VdGeAZQPEpYfmHglKWw7CJaK_y4.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bentham/v19/VdGeAZQPEpYfmHglGW0xDA.ttf"
    },
    {
      "family": "Berkshire Swash",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/berkshireswash/v21/ptRRTi-cavZOGqCvnNJDl5m5XmNPrcQybX4pQA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/berkshireswash/v21/ptRRTi-cavZOGqCvnNJDl5m5XmN_rM42.ttf"
    },
    {
      "family": "Besley",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fbbBSdRoFPOl8-E.ttf",
        "500": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fYTBSdRoFPOl8-E.ttf",
        "600": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fWjGSdRoFPOl8-E.ttf",
        "700": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fVHGSdRoFPOl8-E.ttf",
        "800": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fTbGSdRoFPOl8-E.ttf",
        "900": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fR_GSdRoFPOl8-E.ttf",
        "italic": "https://fonts.gstatic.com/s/besley/v21/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CoZdiENGg4-E04A.ttf",
        "500italic": "https://fonts.gstatic.com/s/besley/v21/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6Ck5diENGg4-E04A.ttf",
        "600italic": "https://fonts.gstatic.com/s/besley/v21/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6Cf5BiENGg4-E04A.ttf",
        "700italic": "https://fonts.gstatic.com/s/besley/v21/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CRpBiENGg4-E04A.ttf",
        "800italic": "https://fonts.gstatic.com/s/besley/v21/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CIZBiENGg4-E04A.ttf",
        "900italic": "https://fonts.gstatic.com/s/besley/v21/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CCJBiENGg4-E04A.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/besley/v21/PlIhFlO1MaNwaNGWUC92IOH_mtG4fbbBedViEA.ttf"
    },
    {
      "family": "Beth Ellen",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bethellen/v21/WwkbxPW2BE-3rb_JNT-qEIAiVNo5xNY.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bethellen/v21/WwkbxPW2BE-3rb_JNT-qIIEoUA.ttf"
    },
    {
      "family": "Bevan",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bevan/v25/4iCj6KZ0a9NXjF8aUir7tlSJ.ttf",
        "italic": "https://fonts.gstatic.com/s/bevan/v25/4iCt6KZ0a9NXjG8YWC7Zs0SJD4U.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bevan/v25/4iCj6KZ0a9NXjG8bWC4.ttf"
    },
    {
      "family": "BhuTuka Expanded One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext"
      ],
      "version": "v8",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bhutukaexpandedone/v8/SLXXc0jZ4WUJcClHTtv0t7IaDRsBsWRiJCyX8pg_RVH1.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bhutukaexpandedone/v8/SLXXc0jZ4WUJcClHTtv0t7IaDRsBsWRiJByW-Jw.ttf"
    },
    {
      "family": "Big Shoulders",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9SOL9ANM1LlZAtA.ttf",
        "200": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9yOP9ANM1LlZAtA.ttf",
        "300": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9FuP9ANM1LlZAtA.ttf",
        "regular": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9SOP9ANM1LlZAtA.ttf",
        "500": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9euP9ANM1LlZAtA.ttf",
        "600": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9luT9ANM1LlZAtA.ttf",
        "700": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9r-T9ANM1LlZAtA.ttf",
        "800": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9yOT9ANM1LlZAtA.ttf",
        "900": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko94eT9ANM1LlZAtA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bigshoulders/v3/qFdk35CPh40oITJ69S3GFqy5-BQAcbz7z7beObrv_PytqyTi33thrko9SOPNAdkx.ttf"
    },
    {
      "family": "Big Shoulders Inline",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1nHb-oUTA-kSKkM.ttf",
        "200": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1vHa-oUTA-kSKkM.ttf",
        "300": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1i_a-oUTA-kSKkM.ttf",
        "regular": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1nHa-oUTA-kSKkM.ttf",
        "500": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1kPa-oUTA-kSKkM.ttf",
        "600": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1q_d-oUTA-kSKkM.ttf",
        "700": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1pbd-oUTA-kSKkM.ttf",
        "800": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1vHd-oUTA-kSKkM.ttf",
        "900": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1tjd-oUTA-kSKkM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bigshouldersinline/v3/bx68NwSCkev-8u0YNXAF6gArLyznvspgMZDcnsTZieUyOqQzOiBfauOMaRhGeKwO1nHayoQZBw.ttf"
    },
    {
      "family": "Big Shoulders Stencil",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp2x5OZJnqtwIp4I.ttf",
        "200": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp0x5eZJnqtwIp4I.ttf",
        "300": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp3v5eZJnqtwIp4I.ttf",
        "regular": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp2x5eZJnqtwIp4I.ttf",
        "500": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp2D5eZJnqtwIp4I.ttf",
        "600": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp1v4uZJnqtwIp4I.ttf",
        "700": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp1W4uZJnqtwIp4I.ttf",
        "800": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp0x4uZJnqtwIp4I.ttf",
        "900": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp0Y4uZJnqtwIp4I.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bigshouldersstencil/v3/TwM2-JIEQ1Je5sI6Bx1TKHD83rT3u3NSCfbFxqa9oQbR_CiZMgOzPB7iSLKdsgE9Sp2x5dZIlK8.ttf"
    },
    {
      "family": "Bigelow Rules",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bigelowrules/v30/RrQWboly8iR_I3KWSzeRuN0zT4cCH8WAJVk.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bigelowrules/v30/RrQWboly8iR_I3KWSzeRuN0zf4YIGw.ttf"
    },
    {
      "family": "Bigshot One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bigshotone/v30/u-470qukhRkkO6BD_7cM_gxuUQJBXv_-.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bigshotone/v30/u-470qukhRkkO6BD_7cM_jxvWwY.ttf"
    },
    {
      "family": "Bilbo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bilbo/v20/o-0EIpgpwWwZ210hpIRz4wxE.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bilbo/v20/o-0EIpgpwWwZ220groA.ttf"
    },
    {
      "family": "Bilbo Swash Caps",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bilboswashcaps/v22/zrf-0GXbz-H3Wb4XBsGrTgq2PVmdqAPopiRfKp8.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bilboswashcaps/v22/zrf-0GXbz-H3Wb4XBsGrTgq2PVmdmALiog.ttf"
    },
    {
      "family": "BioRhyme",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4OrIimiaki-gkRDE.ttf",
        "300": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4Omwimiaki-gkRDE.ttf",
        "regular": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4OjIimiaki-gkRDE.ttf",
        "500": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4OgAimiaki-gkRDE.ttf",
        "600": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4Ouwlmiaki-gkRDE.ttf",
        "700": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4OtUlmiaki-gkRDE.ttf",
        "800": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4OrIlmiaki-gkRDE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/biorhyme/v20/1cXeaULHBpDMsHYW_GZNh7loEHurwOIGadI205trrbeBgQs4OjIiqieujw.ttf"
    },
    {
      "family": "BioRhyme Expanded",
      "variants": [
        "200",
        "300",
        "regular",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/biorhymeexpanded/v22/i7dVIE1zZzytGswgU577CDY9LjbffxxcblSHSdTXrb_z.ttf",
        "300": "https://fonts.gstatic.com/s/biorhymeexpanded/v22/i7dVIE1zZzytGswgU577CDY9Ljbffxw4bVSHSdTXrb_z.ttf",
        "regular": "https://fonts.gstatic.com/s/biorhymeexpanded/v22/i7dQIE1zZzytGswgU577CDY9LjbffySURXCPYsje.ttf",
        "700": "https://fonts.gstatic.com/s/biorhymeexpanded/v22/i7dVIE1zZzytGswgU577CDY9LjbffxwoalSHSdTXrb_z.ttf",
        "800": "https://fonts.gstatic.com/s/biorhymeexpanded/v22/i7dVIE1zZzytGswgU577CDY9Ljbffxw0aVSHSdTXrb_z.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/biorhymeexpanded/v22/i7dQIE1zZzytGswgU577CDY9LjbffxSVT3Q.ttf"
    },
    {
      "family": "Birthstone",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/birthstone/v15/8AtsGs2xO4yLRhy87sv_HLn5jRfZHzM.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/birthstone/v15/8AtsGs2xO4yLRhy87sv_LLjziQ.ttf"
    },
    {
      "family": "Birthstone Bounce",
      "variants": [
        "regular",
        "500"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/birthstonebounce/v12/ga6XaxZF43lIvTWrktHOTBJZGH7dEeVJGIMYDo_8.ttf",
        "500": "https://fonts.gstatic.com/s/birthstonebounce/v12/ga6SaxZF43lIvTWrktHOTBJZGH7dEd29MacQJZP1LmD9.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/birthstonebounce/v12/ga6XaxZF43lIvTWrktHOTBJZGH7dEdVIEoc.ttf"
    },
    {
      "family": "Biryani",
      "variants": [
        "200",
        "300",
        "regular",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/biryani/v14/hv-TlzNxIFoO84YddYQyGTBSU-J-RxQ.ttf",
        "300": "https://fonts.gstatic.com/s/biryani/v14/hv-TlzNxIFoO84YddeAxGTBSU-J-RxQ.ttf",
        "regular": "https://fonts.gstatic.com/s/biryani/v14/hv-WlzNxIFoO84YdTUwZPTh5T-s.ttf",
        "600": "https://fonts.gstatic.com/s/biryani/v14/hv-TlzNxIFoO84YddZQ3GTBSU-J-RxQ.ttf",
        "700": "https://fonts.gstatic.com/s/biryani/v14/hv-TlzNxIFoO84YddfA2GTBSU-J-RxQ.ttf",
        "800": "https://fonts.gstatic.com/s/biryani/v14/hv-TlzNxIFoO84Yddew1GTBSU-J-RxQ.ttf",
        "900": "https://fonts.gstatic.com/s/biryani/v14/hv-TlzNxIFoO84Yddcg0GTBSU-J-RxQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/biryani/v14/hv-WlzNxIFoO84YdfU0TOQ.ttf"
    },
    {
      "family": "Bitcount Grid Double",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-06-25",
      "files": {
        "100": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZDxleZEXi_Ul10k.ttf",
        "200": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZLxkeZEXi_Ul10k.ttf",
        "300": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZGJkeZEXi_Ul10k.ttf",
        "regular": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZDxkeZEXi_Ul10k.ttf",
        "500": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZA5keZEXi_Ul10k.ttf",
        "600": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZOJjeZEXi_Ul10k.ttf",
        "700": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZNtjeZEXi_Ul10k.ttf",
        "800": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZLxjeZEXi_Ul10k.ttf",
        "900": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZJVjeZEXi_Ul10k.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bitcountgriddouble/v1/WBK7rFjbakJVFOargiWSKQysDITG_S0VtG0x3HD2FYHVdlZI-rLlahmEAPp8wjYMvkPq48MVQo5RQf2svjnxa5Anx8-Y-pHdkVb0ByRHaxzbXaLbA9wfZDxkSZAdjw.ttf"
    },
    {
      "family": "Bitter",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v39",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8fbeCL_EXFh2reU.ttf",
        "200": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8XbfCL_EXFh2reU.ttf",
        "300": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8ajfCL_EXFh2reU.ttf",
        "regular": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8fbfCL_EXFh2reU.ttf",
        "500": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8cTfCL_EXFh2reU.ttf",
        "600": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8SjYCL_EXFh2reU.ttf",
        "700": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8RHYCL_EXFh2reU.ttf",
        "800": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8XbYCL_EXFh2reU.ttf",
        "900": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8V_YCL_EXFh2reU.ttf",
        "100italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6c4P3OWHpzveWxBw.ttf",
        "200italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cYPzOWHpzveWxBw.ttf",
        "300italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cvvzOWHpzveWxBw.ttf",
        "italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6c4PzOWHpzveWxBw.ttf",
        "500italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6c0vzOWHpzveWxBw.ttf",
        "600italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cPvvOWHpzveWxBw.ttf",
        "700italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cB_vOWHpzveWxBw.ttf",
        "800italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cYPvOWHpzveWxBw.ttf",
        "900italic": "https://fonts.gstatic.com/s/bitter/v39/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cSfvOWHpzveWxBw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bitter/v39/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8fbfOL7OWA.ttf"
    },
    {
      "family": "Black And White Picture",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/blackandwhitepicture/v29/TwMe-JAERlQd3ooUHBUXGmrmioKjjnRSFO-NqI5HbcMi-yWY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blackandwhitepicture/v29/TwMe-JAERlQd3ooUHBUXGmrmioKjjnRSFO-NqL5GZ8c.ttf"
    },
    {
      "family": "Black Han Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/blackhansans/v23/ea8Aad44WunzF9a-dL6toA8r8nqVIXSkH-Hc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blackhansans/v23/ea8Aad44WunzF9a-dL6toA8r8kqUK3A.ttf"
    },
    {
      "family": "Black Ops One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/blackopsone/v20/qWcsB6-ypo7xBdr6Xshe96H3WDzRtjkho4M.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blackopsone/v20/qWcsB6-ypo7xBdr6Xshe96H3aD3bsg.ttf"
    },
    {
      "family": "Blaka",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/blaka/v7/8vIG7w8722p_6kdr20D2FV5e.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blaka/v7/8vIG7w8722p_6ndq0UQ.ttf"
    },
    {
      "family": "Blaka Hollow",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/blakahollow/v7/MCoUzAL91sjRE2FsKsxUtezYB9oFyW_-oA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blakahollow/v7/MCoUzAL91sjRE2FsKsxUtezoBtAB.ttf"
    },
    {
      "family": "Blaka Ink",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/blakaink/v10/AlZy_zVVtpj22Znag2chdXf4XB0Tow.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blakaink/v10/AlZy_zVVtpj22Znag2cRdH38.ttf",
      "colorCapabilities": [
        "COLRv1",
        "SVG"
      ]
    },
    {
      "family": "Blinker",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/blinker/v13/cIf_MaFatEE-VTaP_E2hZEsCkIt9QQ.ttf",
        "200": "https://fonts.gstatic.com/s/blinker/v13/cIf4MaFatEE-VTaP_OGARGEsnIJkWL4.ttf",
        "300": "https://fonts.gstatic.com/s/blinker/v13/cIf4MaFatEE-VTaP_IWDRGEsnIJkWL4.ttf",
        "regular": "https://fonts.gstatic.com/s/blinker/v13/cIf9MaFatEE-VTaPxCmrYGkHgIs.ttf",
        "600": "https://fonts.gstatic.com/s/blinker/v13/cIf4MaFatEE-VTaP_PGFRGEsnIJkWL4.ttf",
        "700": "https://fonts.gstatic.com/s/blinker/v13/cIf4MaFatEE-VTaP_JWERGEsnIJkWL4.ttf",
        "800": "https://fonts.gstatic.com/s/blinker/v13/cIf4MaFatEE-VTaP_ImHRGEsnIJkWL4.ttf",
        "900": "https://fonts.gstatic.com/s/blinker/v13/cIf4MaFatEE-VTaP_K2GRGEsnIJkWL4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/blinker/v13/cIf9MaFatEE-VTaP9CihZA.ttf"
    },
    {
      "family": "Bodoni Moda",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oU7awIBytVjMYwE.ttf",
        "500": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oXzawIBytVjMYwE.ttf",
        "600": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oZDdwIBytVjMYwE.ttf",
        "700": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oandwIBytVjMYwE.ttf",
        "800": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oc7dwIBytVjMYwE.ttf",
        "900": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oefdwIBytVjMYwE.ttf",
        "italic": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZKMN4sXrJcwHqoQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZGsN4sXrJcwHqoQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZ9sR4sXrJcwHqoQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZz8R4sXrJcwHqoQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZqMR4sXrJcwHqoQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZgcR4sXrJcwHqoQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bodonimoda/v27/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oU7a8IF4sQ.ttf"
    },
    {
      "family": "Bodoni Moda SC",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbA7uXJyb9N7yr8E.ttf",
        "500": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbDzuXJyb9N7yr8E.ttf",
        "600": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbNDpXJyb9N7yr8E.ttf",
        "700": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbOnpXJyb9N7yr8E.ttf",
        "800": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbI7pXJyb9N7yr8E.ttf",
        "900": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbKfpXJyb9N7yr8E.ttf",
        "italic": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjndGTykkIgA8197UwkzHp8F8_dYp-6DdBNRF6RX6k1R5fi-Gf55IgAecattN-R8Pz3v8Etew.ttf",
        "500italic": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjndGTykkIgA8197UwkzHp8F8_dYp-6DdBNRF6RX6k1R5fi-Gf55IgAecatht-R8Pz3v8Etew.ttf",
        "600italic": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjndGTykkIgA8197UwkzHp8F8_dYp-6DdBNRF6RX6k1R5fi-Gf55IgAecatatiR8Pz3v8Etew.ttf",
        "700italic": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjndGTykkIgA8197UwkzHp8F8_dYp-6DdBNRF6RX6k1R5fi-Gf55IgAecatU9iR8Pz3v8Etew.ttf",
        "800italic": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjndGTykkIgA8197UwkzHp8F8_dYp-6DdBNRF6RX6k1R5fi-Gf55IgAecatNNiR8Pz3v8Etew.ttf",
        "900italic": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjndGTykkIgA8197UwkzHp8F8_dYp-6DdBNRF6RX6k1R5fi-Gf55IgAecatHdiR8Pz3v8Etew.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bodonimodasc/v2/LYjhdGTykkIgA8197UwkzHp8F-XUUG5UNs2KqliEb-g_DaUdIA6SfiYHbA7ubJ2R8A.ttf"
    },
    {
      "family": "Bokor",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v31",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bokor/v31/m8JcjfpeeaqTiR2WdInbcaxE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bokor/v31/m8JcjfpeeaqTiS2Xfo0.ttf"
    },
    {
      "family": "Boldonse",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/boldonse/v1/ZgNQjPxGPbbJUZemjC38hmHmNpCO.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/boldonse/v1/ZgNQjPxGPbbJUZemjB39jGU.ttf"
    },
    {
      "family": "Bona Nova",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bonanova/v11/B50NF7ZCpX7fcHfvIUBJi6hqHK-CLA.ttf",
        "italic": "https://fonts.gstatic.com/s/bonanova/v11/B50LF7ZCpX7fcHfvIUB5iaJuPqqSLJYf.ttf",
        "700": "https://fonts.gstatic.com/s/bonanova/v11/B50IF7ZCpX7fcHfvIUBxN4dOFISeJY8GgQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bonanova/v11/B50NF7ZCpX7fcHfvIUB5iqJu.ttf"
    },
    {
      "family": "Bona Nova SC",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bonanovasc/v1/mem5YaShyGWDiYdPG_c1Af4-VeJoCqeDjg.ttf",
        "italic": "https://fonts.gstatic.com/s/bonanovasc/v1/memnYaShyGWDiYdPG_c1Af4OV-hsKKKTjrPW.ttf",
        "700": "https://fonts.gstatic.com/s/bonanovasc/v1/memmYaShyGWDiYdPG_c1Af4G6c1MAoyfh6rPXA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bonanovasc/v1/mem5YaShyGWDiYdPG_c1Af4OVOhs.ttf"
    },
    {
      "family": "Bonbon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v31",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bonbon/v31/0FlVVPeVlFec4ee_cDEAbQY5-A.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bonbon/v31/0FlVVPeVlFec4eePcTsE.ttf"
    },
    {
      "family": "Bonheur Royale",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bonheurroyale/v14/c4m51nt_GMTrtX-b9GcG4-YRmYK_c0f1N5Ij.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bonheurroyale/v14/c4m51nt_GMTrtX-b9GcG4-YRmbK-eUM.ttf"
    },
    {
      "family": "Boogaloo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/boogaloo/v24/kmK-Zq45GAvOdnaW6x1F_SrQo_1K.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/boogaloo/v24/kmK-Zq45GAvOdnaW6y1E9y4.ttf"
    },
    {
      "family": "Borel",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/borel/v3/6qLOKZsftAPisgshYyMnOjwE.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/borel/v3/6qLOKZsftAPisjsgaSc.ttf"
    },
    {
      "family": "Bowlby One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bowlbyone/v24/taiPGmVuC4y96PFeqp8smo6C_Z0wcK4.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bowlbyone/v24/taiPGmVuC4y96PFeqp8sqo-I-Q.ttf"
    },
    {
      "family": "Bowlby One SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bowlbyonesc/v26/DtVlJxerQqQm37tzN3wMug9Pzgj8owhNjuE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bowlbyonesc/v26/DtVlJxerQqQm37tzN3wMug9P_gn2pw.ttf"
    },
    {
      "family": "Braah One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/braahone/v7/KFOlCnWUpt6LsxxxiylvAx05IsDqlA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/braahone/v7/KFOlCnWUpt6LsxxxiylfAhc9.ttf"
    },
    {
      "family": "Brawler",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/brawler/v19/xn7gYHE3xXewAscGsgC7S9XdZN8.ttf",
        "700": "https://fonts.gstatic.com/s/brawler/v19/xn7lYHE3xXewAscGiryUb932eNaPfk8.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/brawler/v19/xn7gYHE3xXewAscGggGxTw.ttf"
    },
    {
      "family": "Bree Serif",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/breeserif/v17/4UaHrEJCrhhnVA3DgluAx63j5pN1MwI.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/breeserif/v17/4UaHrEJCrhhnVA3DgluA96zp4g.ttf"
    },
    {
      "family": "Bricolage Grotesque",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvZviyM0vs-wJDtw.ttf",
        "300": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvUXiyM0vs-wJDtw.ttf",
        "regular": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvRviyM0vs-wJDtw.ttf",
        "500": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvSniyM0vs-wJDtw.ttf",
        "600": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvcXlyM0vs-wJDtw.ttf",
        "700": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvfzlyM0vs-wJDtw.ttf",
        "800": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvZvlyM0vs-wJDtw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bricolagegrotesque/v8/3y9U6as8bTXq_nANBjzKo3IeZx8z6up5BeSl5jBNz_19PpbpMXuECpwUxJBOm_OJWiaaD30YfKfjZZoLvRvi-Mwltw.ttf"
    },
    {
      "family": "Bruno Ace",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/brunoace/v6/WwkcxPa2E06x4trkOj_kMKoMWNMg3Q.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/brunoace/v6/WwkcxPa2E06x4trkOj_UMaAI.ttf"
    },
    {
      "family": "Bruno Ace SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/brunoacesc/v6/ptROTiycffFLBuiHjdJDl634LSFrpe8uZA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/brunoacesc/v6/ptROTiycffFLBuiHjdJDl63ILCtv.ttf"
    },
    {
      "family": "Brygada 1918",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/brygada1918/v26/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y2-f-V8Wu5O3gbo.ttf",
        "500": "https://fonts.gstatic.com/s/brygada1918/v26/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y12f-V8Wu5O3gbo.ttf",
        "600": "https://fonts.gstatic.com/s/brygada1918/v26/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y7GY-V8Wu5O3gbo.ttf",
        "700": "https://fonts.gstatic.com/s/brygada1918/v26/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y4iY-V8Wu5O3gbo.ttf",
        "italic": "https://fonts.gstatic.com/s/brygada1918/v26/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfcERwcv7GykboaLg.ttf",
        "500italic": "https://fonts.gstatic.com/s/brygada1918/v26/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfcIxwcv7GykboaLg.ttf",
        "600italic": "https://fonts.gstatic.com/s/brygada1918/v26/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfczxscv7GykboaLg.ttf",
        "700italic": "https://fonts.gstatic.com/s/brygada1918/v26/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfc9hscv7GykboaLg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/brygada1918/v26/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y2-fyV4cvw.ttf"
    },
    {
      "family": "Bubblegum Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bubblegumsans/v21/AYCSpXb_Z9EORv1M5QTjEzMEtdaHzoPPb7R4.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bubblegumsans/v21/AYCSpXb_Z9EORv1M5QTjEzMEteaGxIc.ttf"
    },
    {
      "family": "Bubbler One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bubblerone/v21/f0Xy0eqj68ppQV9KBLmAouHH26MPePkt.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bubblerone/v21/f0Xy0eqj68ppQV9KBLmAotHG0ac.ttf"
    },
    {
      "family": "Buda",
      "variants": [
        "300"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/buda/v30/GFDqWAN8mnyIJSSrG7UBr7pZKA0.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/buda/v30/GFDqWAN8mnyIJSSrK7QLqw.ttf"
    },
    {
      "family": "Buenard",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/buenard/v21/OD5cuM6Cyma8FnnsJTzfWLAhv7i92sqpK0_3iBYVfsc4.ttf",
        "500": "https://fonts.gstatic.com/s/buenard/v21/OD5cuM6Cyma8FnnsJTzfWLAhv7i92sqbK0_3iBYVfsc4.ttf",
        "600": "https://fonts.gstatic.com/s/buenard/v21/OD5cuM6Cyma8FnnsJTzfWLAhv7i92sp3LE_3iBYVfsc4.ttf",
        "700": "https://fonts.gstatic.com/s/buenard/v21/OD5cuM6Cyma8FnnsJTzfWLAhv7i92spOLE_3iBYVfsc4.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/buenard/v21/OD5cuM6Cyma8FnnsJTzfWLAhv7i92sqpK3_2ghI.ttf"
    },
    {
      "family": "Bungee",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungee/v16/N0bU2SZBIuF2PU_ECn50Kd_PmA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungee/v16/N0bU2SZBIuF2PU_0C3Rw.ttf"
    },
    {
      "family": "Bungee Hairline",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungeehairline/v25/snfys0G548t04270a_ljTLUVrv-7YB2dQ5ZPqQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungeehairline/v25/snfys0G548t04270a_ljTLUVrv-LYReZ.ttf"
    },
    {
      "family": "Bungee Inline",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungeeinline/v18/Gg8zN58UcgnlCweMrih332VuDGJ1-FEglsc.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungeeinline/v18/Gg8zN58UcgnlCweMrih332VuPGN__A.ttf"
    },
    {
      "family": "Bungee Outline",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungeeoutline/v23/_6_mEDvmVP24UvU2MyiGDslL3Qg3YhJqPXxo.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungeeoutline/v23/_6_mEDvmVP24UvU2MyiGDslL3Tg2aBY.ttf"
    },
    {
      "family": "Bungee Shade",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungeeshade/v16/DtVkJxarWL0t2KdzK3oI_jks7iLSrwFUlw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungeeshade/v16/DtVkJxarWL0t2KdzK3oI_jkc7yjW.ttf"
    },
    {
      "family": "Bungee Spice",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungeespice/v15/nwpTtK2nIhxE0q-IwgSpZBqCzyI-aMPF7Q.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungeespice/v15/nwpTtK2nIhxE0q-IwgSpZBqyzig6.ttf",
      "colorCapabilities": [
        "COLRv1",
        "SVG"
      ]
    },
    {
      "family": "Bungee Tint",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bungeetint/v3/J7abnpl_EGtUEuAJwN9WmrtKMDwTpTkB.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bungeetint/v3/J7abnpl_EGtUEuAJwN9WmotLOjg.ttf",
      "colorCapabilities": [
        "COLRv0"
      ]
    },
    {
      "family": "Butcherman",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/butcherman/v24/2EbiL-thF0loflXUBOdb1zWzq_5uT84.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/butcherman/v24/2EbiL-thF0loflXUBOdb5zS5rw.ttf"
    },
    {
      "family": "Butterfly Kids",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/butterflykids/v26/ll8lK2CWTjuqAsXDqlnIbMNs5S4arxFrAX1D.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/butterflykids/v26/ll8lK2CWTjuqAsXDqlnIbMNs5R4bpRU.ttf"
    },
    {
      "family": "Bytesized",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/bytesized/v1/goksH6L8FkdnROln8XBTS0CjkP1Yog.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/bytesized/v1/goksH6L8FkdnROln8XBjSkqn.ttf"
    },
    {
      "family": "Cabin",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v34",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cabin/v34/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkV2EL7Gvxm7rE_s.ttf",
        "500": "https://fonts.gstatic.com/s/cabin/v34/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkW-EL7Gvxm7rE_s.ttf",
        "600": "https://fonts.gstatic.com/s/cabin/v34/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkYODL7Gvxm7rE_s.ttf",
        "700": "https://fonts.gstatic.com/s/cabin/v34/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkbqDL7Gvxm7rE_s.ttf",
        "italic": "https://fonts.gstatic.com/s/cabin/v34/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXHx_KlwkzuA_u1Bg.ttf",
        "500italic": "https://fonts.gstatic.com/s/cabin/v34/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXH9fKlwkzuA_u1Bg.ttf",
        "600italic": "https://fonts.gstatic.com/s/cabin/v34/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXHGfWlwkzuA_u1Bg.ttf",
        "700italic": "https://fonts.gstatic.com/s/cabin/v34/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXHIPWlwkzuA_u1Bg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cabin/v34/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkV2EH7Clwg.ttf"
    },
    {
      "family": "Cabin Condensed",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cabincondensed/v20/nwpMtK6mNhBK2err_hqkYhHRqmwaYOjZ5HZl8Q.ttf",
        "500": "https://fonts.gstatic.com/s/cabincondensed/v20/nwpJtK6mNhBK2err_hqkYhHRqmwilMH97F15-K1oqQ.ttf",
        "600": "https://fonts.gstatic.com/s/cabincondensed/v20/nwpJtK6mNhBK2err_hqkYhHRqmwiuMb97F15-K1oqQ.ttf",
        "700": "https://fonts.gstatic.com/s/cabincondensed/v20/nwpJtK6mNhBK2err_hqkYhHRqmwi3Mf97F15-K1oqQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cabincondensed/v20/nwpMtK6mNhBK2err_hqkYhHRqmwqYeLd.ttf"
    },
    {
      "family": "Cabin Sketch",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cabinsketch/v22/QGYpz_kZZAGCONcK2A4bGOjMn9JM6fnuKg.ttf",
        "700": "https://fonts.gstatic.com/s/cabinsketch/v22/QGY2z_kZZAGCONcK2A4bGOj0I_1o4dLyI4CMFw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cabinsketch/v22/QGYpz_kZZAGCONcK2A4bGOj8nthI.ttf"
    },
    {
      "family": "Cactus Classical Serif",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-traditional",
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cactusclassicalserif/v12/sZlVdQ6K-zJOCzUaS90zMNN-Ep-OoC8dZr0JFuBIFX-pv-E.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cactusclassicalserif/v12/sZlVdQ6K-zJOCzUaS90zMNN-Ep-OoC8dZr0JJuFCEQ.ttf"
    },
    {
      "family": "Caesar Dressing",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caesardressing/v21/yYLx0hLa3vawqtwdswbotmK4vrR3cbb6LZttyg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caesardressing/v21/yYLx0hLa3vawqtwdswbotmK4vrRHcLz-.ttf"
    },
    {
      "family": "Cagliostro",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cagliostro/v21/ZgNWjP5HM73BV5amnX-TjGXEM4COoE4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cagliostro/v21/ZgNWjP5HM73BV5amnX-TvGTONw.ttf"
    },
    {
      "family": "Cairo",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hGA-W1ToLQ-HmkA.ttf",
        "300": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hL4-W1ToLQ-HmkA.ttf",
        "regular": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hOA-W1ToLQ-HmkA.ttf",
        "500": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hNI-W1ToLQ-HmkA.ttf",
        "600": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hD45W1ToLQ-HmkA.ttf",
        "700": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hAc5W1ToLQ-HmkA.ttf",
        "800": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hGA5W1ToLQ-HmkA.ttf",
        "900": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hEk5W1ToLQ-HmkA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cairo/v30/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hOA-a1XiKQ.ttf"
    },
    {
      "family": "Cairo Play",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1EnYq9yXa8GvzaA.ttf",
        "300": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1zHYq9yXa8GvzaA.ttf",
        "regular": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1knYq9yXa8GvzaA.ttf",
        "500": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1oHYq9yXa8GvzaA.ttf",
        "600": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1THEq9yXa8GvzaA.ttf",
        "700": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1dXEq9yXa8GvzaA.ttf",
        "800": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1EnEq9yXa8GvzaA.ttf",
        "900": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1O3Eq9yXa8GvzaA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cairoplay/v12/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1knYa9i_e.ttf",
      "colorCapabilities": [
        "COLRv0"
      ]
    },
    {
      "family": "Cal Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-06-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/calsans/v2/fdN99sWUv3gWqXxqqSBbvloE4LZx.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/calsans/v2/fdN99sWUv3gWqXxqqRBatF4.ttf"
    },
    {
      "family": "Caladea",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caladea/v7/kJEzBugZ7AAjhybUjR93-9IztOc.ttf",
        "italic": "https://fonts.gstatic.com/s/caladea/v7/kJExBugZ7AAjhybUvR19__A2pOdvDA.ttf",
        "700": "https://fonts.gstatic.com/s/caladea/v7/kJE2BugZ7AAjhybUtaNY39oYqO52FZ0.ttf",
        "700italic": "https://fonts.gstatic.com/s/caladea/v7/kJE0BugZ7AAjhybUvR1FQ98SrMxzBZ2lDA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caladea/v7/kJEzBugZ7AAjhybUvR59_w.ttf"
    },
    {
      "family": "Calistoga",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/calistoga/v17/6NUU8F2OJg6MeR7l4e0vtMYAwdRZfw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/calistoga/v17/6NUU8F2OJg6MeR7l4e0ftcwE.ttf"
    },
    {
      "family": "Calligraffitti",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/calligraffitti/v19/46k2lbT3XjDVqJw3DCmCFjE0vnFZM5ZBpYN-.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/calligraffitti/v19/46k2lbT3XjDVqJw3DCmCFjE0vkFYOZI.ttf"
    },
    {
      "family": "Cambay",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cambay/v13/SLXJc1rY6H0_ZDsGbrSIz9JsaA.ttf",
        "italic": "https://fonts.gstatic.com/s/cambay/v13/SLXLc1rY6H0_ZDs2bL6M7dd8aGZk.ttf",
        "700": "https://fonts.gstatic.com/s/cambay/v13/SLXKc1rY6H0_ZDs-0pusx_lwYX99kA.ttf",
        "700italic": "https://fonts.gstatic.com/s/cambay/v13/SLXMc1rY6H0_ZDs2bIYwwvN0Q3ptkDMN.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cambay/v13/SLXJc1rY6H0_ZDs2b76M.ttf"
    },
    {
      "family": "Cambo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cambo/v18/IFSqHeNEk8FJk416ok7xkPm8.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cambo/v18/IFSqHeNEk8FJk717qEo.ttf"
    },
    {
      "family": "Candal",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/candal/v15/XoHn2YH6T7-t_8cNAR4Jt9Yxlw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/candal/v15/XoHn2YH6T7-t_8c9ABQN.ttf"
    },
    {
      "family": "Cantarell",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cantarell/v17/B50NF7ZDq37KMUvlO01Ji6hqHK-CLA.ttf",
        "italic": "https://fonts.gstatic.com/s/cantarell/v17/B50LF7ZDq37KMUvlO015iaJuPqqSLJYf.ttf",
        "700": "https://fonts.gstatic.com/s/cantarell/v17/B50IF7ZDq37KMUvlO01xN4dOFISeJY8GgQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/cantarell/v17/B50WF7ZDq37KMUvlO015iZrSEY6aB4oWgWHB.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cantarell/v17/B50NF7ZDq37KMUvlO015iqJu.ttf"
    },
    {
      "family": "Cantata One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cantataone/v15/PlI5Fl60Nb5obNzNe2jslVxEt8CwfGaD.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cantataone/v15/PlI5Fl60Nb5obNzNe2jslWxFvcQ.ttf"
    },
    {
      "family": "Cantora One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cantoraone/v19/gyB4hws1JdgnKy56GB_JX6zdZ4vZVbgZ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cantoraone/v19/gyB4hws1JdgnKy56GB_JX5zcbY8.ttf"
    },
    {
      "family": "Caprasimo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caprasimo/v6/esDT31JQOPuXIUGBp72klZUCGpG-GQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caprasimo/v6/esDT31JQOPuXIUGBp72UlJ8G.ttf"
    },
    {
      "family": "Capriola",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/capriola/v14/wXKoE3YSppcvo1PDln_8L-AinG8y.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/capriola/v14/wXKoE3YSppcvo1PDlk_9JeQ.ttf"
    },
    {
      "family": "Caramel",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caramel/v7/P5sCzZKBbMTf_ShyxCRuiZ-uydg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caramel/v7/P5sCzZKBbMTf_Shy9CVkjQ.ttf"
    },
    {
      "family": "Carattere",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/carattere/v7/4iCv6Kp1b9dXlgt_CkvTt2aMH4V_gg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/carattere/v7/4iCv6Kp1b9dXlgt_CkvjtmyI.ttf"
    },
    {
      "family": "Cardo",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "gothic",
        "greek",
        "greek-ext",
        "hebrew",
        "latin",
        "latin-ext",
        "old-italic",
        "runic"
      ],
      "version": "v20",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cardo/v20/wlp_gwjKBV1pqiv_1oAZ2H5O.ttf",
        "italic": "https://fonts.gstatic.com/s/cardo/v20/wlpxgwjKBV1pqhv93IQ73W5OcCk.ttf",
        "700": "https://fonts.gstatic.com/s/cardo/v20/wlpygwjKBV1pqhND-aQR82JHaTBX.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cardo/v20/wlp_gwjKBV1pqhv-3IQ.ttf"
    },
    {
      "family": "Carlito",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/carlito/v3/3Jn9SDPw3m-pk039PDCLTXUETuE.ttf",
        "italic": "https://fonts.gstatic.com/s/carlito/v3/3Jn_SDPw3m-pk039DDKBSVcBXuFb0Q.ttf",
        "700": "https://fonts.gstatic.com/s/carlito/v3/3Jn4SDPw3m-pk039BIykaX0vUuhCyOo.ttf",
        "700italic": "https://fonts.gstatic.com/s/carlito/v3/3Jn6SDPw3m-pk039DDK59XglVspH2OprMQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/carlito/v3/3Jn9SDPw3m-pk039DDGBSQ.ttf"
    },
    {
      "family": "Carme",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/carme/v16/ptRHTiWdbvZIDOjGxLNrxfbZ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/carme/v16/ptRHTiWdbvZIDNjHzrc.ttf"
    },
    {
      "family": "Carrois Gothic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/carroisgothic/v16/Z9XPDmFATg-N1PLtLOOxvIHl9ZmD3i7ajcJ-.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/carroisgothic/v16/Z9XPDmFATg-N1PLtLOOxvIHl9amC1Co.ttf"
    },
    {
      "family": "Carrois Gothic SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/carroisgothicsc/v15/ZgNJjOVHM6jfUZCmyUqT2A2HVKjc-28nNHabY4dN.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/carroisgothicsc/v15/ZgNJjOVHM6jfUZCmyUqT2A2HVKjc-18mPnI.ttf"
    },
    {
      "family": "Carter One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/carterone/v17/q5uCsoe5IOB2-pXv9UcNIxR2hYxREMs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/carterone/v17/q5uCsoe5IOB2-pXv9UcNExV8gQ.ttf"
    },
    {
      "family": "Cascadia Code",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "arabic",
        "braille",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "hebrew",
        "latin",
        "latin-ext",
        "symbols2",
        "vietnamese"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuWMOaDPb9pHaHCA.ttf",
        "300": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuVSOaDPb9pHaHCA.ttf",
        "regular": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuUMOaDPb9pHaHCA.ttf",
        "500": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuU-OaDPb9pHaHCA.ttf",
        "600": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuXSPqDPb9pHaHCA.ttf",
        "700": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuXrPqDPb9pHaHCA.ttf",
        "200italic": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc9B6-zq5zxD57cT5s916v3aD7BuTnUax-yWfDEesiMZd5lbWCAUXU.ttf",
        "300italic": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc9B6-zq5zxD57cT5s916v3aD7BuTnUax-yWfDEehaMZd5lbWCAUXU.ttf",
        "italic": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc9B6-zq5zxD57cT5s916v3aD7BuTnUax-yWfDEekiMZd5lbWCAUXU.ttf",
        "500italic": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc9B6-zq5zxD57cT5s916v3aD7BuTnUax-yWfDEenqMZd5lbWCAUXU.ttf",
        "600italic": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc9B6-zq5zxD57cT5s916v3aD7BuTnUax-yWfDEepaLZd5lbWCAUXU.ttf",
        "700italic": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc9B6-zq5zxD57cT5s916v3aD7BuTnUax-yWfDEeq-LZd5lbWCAUXU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cascadiacode/v4/qWc_B6-zq5zxD57cT5s916v3QjfzRuG9AIUcXuUMOZDOZd4.ttf"
    },
    {
      "family": "Cascadia Mono",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "arabic",
        "braille",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "hebrew",
        "latin",
        "latin-ext",
        "symbols2",
        "vietnamese"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTadsWVkNot27AYk.ttf",
        "300": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTZDsWVkNot27AYk.ttf",
        "regular": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTYdsWVkNot27AYk.ttf",
        "500": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTYvsWVkNot27AYk.ttf",
        "600": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTbDtmVkNot27AYk.ttf",
        "700": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTb6tmVkNot27AYk.ttf",
        "200italic": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZnzw5pquJF3iuizJDZYqr1aZc93m0eKfzCTiPV8g0nPI9U6RYkQrY.ttf",
        "300italic": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZnzw5pquJF3iuizJDZYqr1aZc93m0eKfzCTiPV8tMnPI9U6RYkQrY.ttf",
        "italic": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZnzw5pquJF3iuizJDZYqr1aZc93m0eKfzCTiPV8o0nPI9U6RYkQrY.ttf",
        "500italic": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZnzw5pquJF3iuizJDZYqr1aZc93m0eKfzCTiPV8r8nPI9U6RYkQrY.ttf",
        "600italic": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZnzw5pquJF3iuizJDZYqr1aZc93m0eKfzCTiPV8lMgPI9U6RYkQrY.ttf",
        "700italic": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZnzw5pquJF3iuizJDZYqr1aZc93m0eKfzCTiPV8mogPI9U6RYkQrY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cascadiamono/v4/TUZlzw5pquJF3iuizJDZYqr1Q54PIbV3QmZsSTYdsVVlPI8.ttf"
    },
    {
      "family": "Castoro",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/castoro/v19/1q2GY5yMCld3-O4cHYhEzOYenEU.ttf",
        "italic": "https://fonts.gstatic.com/s/castoro/v19/1q2EY5yMCld3-O4cLYpOyMQbjEX5fw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/castoro/v19/1q2GY5yMCld3-O4cLYlOyA.ttf"
    },
    {
      "family": "Castoro Titling",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v9",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/castorotitling/v9/buEupouwccj03leTfjUAhEZWlrNqYgckeo9RMw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/castorotitling/v9/buEupouwccj03leTfjUAhEZWlrNaYw0g.ttf"
    },
    {
      "family": "Catamaran",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil"
      ],
      "version": "v27",
      "lastModified": "2025-04-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPHjc1anXuluiLyw.ttf",
        "200": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPPjd1anXuluiLyw.ttf",
        "300": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPCbd1anXuluiLyw.ttf",
        "regular": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPHjd1anXuluiLyw.ttf",
        "500": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPErd1anXuluiLyw.ttf",
        "600": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPKba1anXuluiLyw.ttf",
        "700": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPJ_a1anXuluiLyw.ttf",
        "800": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPPja1anXuluiLyw.ttf",
        "900": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPNHa1anXuluiLyw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/catamaran/v27/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPHjd5ajdvg.ttf"
    },
    {
      "family": "Caudex",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "runic",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caudex/v18/esDQ311QOP6BJUrIyviAnb4eEw.ttf",
        "italic": "https://fonts.gstatic.com/s/caudex/v18/esDS311QOP6BJUr4yPKEv7sOE4in.ttf",
        "700": "https://fonts.gstatic.com/s/caudex/v18/esDT311QOP6BJUrwdteklZUCGpG-GQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/caudex/v18/esDV311QOP6BJUr4yMo4kJ8GOJSuGdLB.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caudex/v18/esDQ311QOP6BJUr4y_KE.ttf"
    },
    {
      "family": "Caveat",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caveat/v22/WnznHAc5bAfYB2QRah7pcpNvOx-pjfJ9SIKjYBxPigs.ttf",
        "500": "https://fonts.gstatic.com/s/caveat/v22/WnznHAc5bAfYB2QRah7pcpNvOx-pjcB9SIKjYBxPigs.ttf",
        "600": "https://fonts.gstatic.com/s/caveat/v22/WnznHAc5bAfYB2QRah7pcpNvOx-pjSx6SIKjYBxPigs.ttf",
        "700": "https://fonts.gstatic.com/s/caveat/v22/WnznHAc5bAfYB2QRah7pcpNvOx-pjRV6SIKjYBxPigs.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caveat/v22/WnznHAc5bAfYB2QRah7pcpNvOx-pjfJ9eIOpZA.ttf"
    },
    {
      "family": "Caveat Brush",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/caveatbrush/v11/EYq0maZfwr9S9-ETZc3fKXtMW7mT03pdQw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/caveatbrush/v11/EYq0maZfwr9S9-ETZc3fKXt8WrOX.ttf"
    },
    {
      "family": "Cedarville Cursive",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cedarvillecursive/v17/yYL00g_a2veiudhUmxjo5VKkoqA-B_neJbBxw8BeTg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cedarvillecursive/v17/yYL00g_a2veiudhUmxjo5VKkoqA-B_nuJLp1.ttf"
    },
    {
      "family": "Ceviche One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cevicheone/v16/gyB4hws1IcA6JzR-GB_JX6zdZ4vZVbgZ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cevicheone/v16/gyB4hws1IcA6JzR-GB_JX5zcbY8.ttf"
    },
    {
      "family": "Chakra Petch",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/chakrapetch/v12/cIflMapbsEk7TDLdtEz1BwkeNIhFQJXE3AY00g.ttf",
        "300italic": "https://fonts.gstatic.com/s/chakrapetch/v12/cIfnMapbsEk7TDLdtEz1BwkWmpLJQp_A_gMk0izH.ttf",
        "regular": "https://fonts.gstatic.com/s/chakrapetch/v12/cIf6MapbsEk7TDLdtEz1BwkmmKBhSL7Y1Q.ttf",
        "italic": "https://fonts.gstatic.com/s/chakrapetch/v12/cIfkMapbsEk7TDLdtEz1BwkWmqplarvI1R8t.ttf",
        "500": "https://fonts.gstatic.com/s/chakrapetch/v12/cIflMapbsEk7TDLdtEz1BwkebIlFQJXE3AY00g.ttf",
        "500italic": "https://fonts.gstatic.com/s/chakrapetch/v12/cIfnMapbsEk7TDLdtEz1BwkWmpKRQ5_A_gMk0izH.ttf",
        "600": "https://fonts.gstatic.com/s/chakrapetch/v12/cIflMapbsEk7TDLdtEz1BwkeQI5FQJXE3AY00g.ttf",
        "600italic": "https://fonts.gstatic.com/s/chakrapetch/v12/cIfnMapbsEk7TDLdtEz1BwkWmpK9RJ_A_gMk0izH.ttf",
        "700": "https://fonts.gstatic.com/s/chakrapetch/v12/cIflMapbsEk7TDLdtEz1BwkeJI9FQJXE3AY00g.ttf",
        "700italic": "https://fonts.gstatic.com/s/chakrapetch/v12/cIfnMapbsEk7TDLdtEz1BwkWmpLZRZ_A_gMk0izH.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chakrapetch/v12/cIf6MapbsEk7TDLdtEz1BwkWmapl.ttf"
    },
    {
      "family": "Changa",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZy2xQjDp9htf1ZM.ttf",
        "300": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZ_OxQjDp9htf1ZM.ttf",
        "regular": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZ62xQjDp9htf1ZM.ttf",
        "500": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZ5-xQjDp9htf1ZM.ttf",
        "600": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZ3O2QjDp9htf1ZM.ttf",
        "700": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZ0q2QjDp9htf1ZM.ttf",
        "800": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZy22QjDp9htf1ZM.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/changa/v28/2-c79JNi2YuVOUcOarRPgnNGooxCZ62xcjHj8g.ttf"
    },
    {
      "family": "Changa One",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/changaone/v21/xfu00W3wXn3QLUJXhzq46AbouLfbK64.ttf",
        "italic": "https://fonts.gstatic.com/s/changaone/v21/xfu20W3wXn3QLUJXhzq42ATivJXeO67ISw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/changaone/v21/xfu00W3wXn3QLUJXhzq42AfivA.ttf"
    },
    {
      "family": "Chango",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chango/v28/2V0cKI0OB5U7WaJyz324TFUaAw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chango/v28/2V0cKI0OB5U7WaJCzne8.ttf"
    },
    {
      "family": "Charis SIL",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/charissil/v2/oPWK_kV3l-s-Q8govXvKrPrmYjZ2Xn0.ttf",
        "italic": "https://fonts.gstatic.com/s/charissil/v2/oPWI_kV3l-s-Q8govXvKnPjsZhRzTn2Ozw.ttf",
        "700": "https://fonts.gstatic.com/s/charissil/v2/oPWJ_kV3l-s-Q8govXvKlEbJRj5dQnSX1ko.ttf",
        "700italic": "https://fonts.gstatic.com/s/charissil/v2/oPWX_kV3l-s-Q8govXvKnPjU2jtXRlaSxkrMCQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/charissil/v2/oPWK_kV3l-s-Q8govXvKnPvsZg.ttf"
    },
    {
      "family": "Charm",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/charm/v13/7cHmv4oii5K0MeYvIe804WIo.ttf",
        "700": "https://fonts.gstatic.com/s/charm/v13/7cHrv4oii5K0Md6TDss8yn4hnCci.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/charm/v13/7cHmv4oii5K0MdYuK-s.ttf"
    },
    {
      "family": "Charmonman",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/charmonman/v19/MjQDmiR3vP_nuxDv47jiWJGovLdh6OE.ttf",
        "700": "https://fonts.gstatic.com/s/charmonman/v19/MjQAmiR3vP_nuxDv47jiYC2HmL9K9OhmGnY.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/charmonman/v19/MjQDmiR3vP_nuxDv47jiaJCiuA.ttf"
    },
    {
      "family": "Chathura",
      "variants": [
        "100",
        "300",
        "regular",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "telugu"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/chathura/v21/_gP91R7-rzUuVjim42dEq0SbTvZyuDo.ttf",
        "300": "https://fonts.gstatic.com/s/chathura/v21/_gP81R7-rzUuVjim42eMiWSxYPp7oSNy.ttf",
        "regular": "https://fonts.gstatic.com/s/chathura/v21/_gP71R7-rzUuVjim418goUC5S-Zy.ttf",
        "700": "https://fonts.gstatic.com/s/chathura/v21/_gP81R7-rzUuVjim42ecjmSxYPp7oSNy.ttf",
        "800": "https://fonts.gstatic.com/s/chathura/v21/_gP81R7-rzUuVjim42eAjWSxYPp7oSNy.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chathura/v21/_gP71R7-rzUuVjim428hq0Q.ttf"
    },
    {
      "family": "Chau Philomene One",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chauphilomeneone/v15/55xxezRsPtfie1vPY49qzdgSlJiHRQFsnIx7QMISdQ.ttf",
        "italic": "https://fonts.gstatic.com/s/chauphilomeneone/v15/55xzezRsPtfie1vPY49qzdgSlJiHRQFcnoZ_YscCdXQB.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chauphilomeneone/v15/55xxezRsPtfie1vPY49qzdgSlJiHRQFcnYZ_.ttf"
    },
    {
      "family": "Chela One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chelaone/v21/6ae-4KC7Uqgdz_JZdPIy31vWNTMwoQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chelaone/v21/6ae-4KC7Uqgdz_JZdPIC3lHS.ttf"
    },
    {
      "family": "Chelsea Market",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chelseamarket/v13/BCawqZsHqfr89WNP_IApC8tzKBhlLA4uKkWk.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chelseamarket/v13/BCawqZsHqfr89WNP_IApC8tzKChkJgo.ttf"
    },
    {
      "family": "Chenla",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer"
      ],
      "version": "v25",
      "lastModified": "2022-09-22",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chenla/v25/SZc43FDpIKu8WZ9eXxfonUPL6Q.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chenla/v25/SZc43FDpIKu8WZ9uXh3s.ttf"
    },
    {
      "family": "Cherish",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cherish/v8/ll88K2mXUyqsDsTN5iDCI6IJjg8.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cherish/v8/ll88K2mXUyqsDsTN1iHIJw.ttf"
    },
    {
      "family": "Cherry Bomb One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cherrybombone/v10/y83DW4od1h6KlV3c6JJhRhGOdhrKDNpF41fr-w.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cherrybombone/v10/y83DW4od1h6KlV3c6JJhRhGOdhr6DdBB.ttf"
    },
    {
      "family": "Cherry Cream Soda",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cherrycreamsoda/v21/UMBIrOxBrW6w2FFyi9paG0fdVdRciTd6Cd47DJ7G.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cherrycreamsoda/v21/UMBIrOxBrW6w2FFyi9paG0fdVdRciQd7A9o.ttf"
    },
    {
      "family": "Cherry Swash",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cherryswash/v21/i7dNIFByZjaNAMxtZcnfAy58QHi-EwWMbg.ttf",
        "700": "https://fonts.gstatic.com/s/cherryswash/v21/i7dSIFByZjaNAMxtZcnfAy5E_FeaGy6QZ3WfYg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cherryswash/v21/i7dNIFByZjaNAMxtZcnfAy5MQXK6.ttf"
    },
    {
      "family": "Chewy",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chewy/v18/uK_94ruUb-k-wk5xIDMfO-ed.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chewy/v18/uK_94ruUb-k-wn5wKjc.ttf"
    },
    {
      "family": "Chicle",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chicle/v26/lJwG-pw9i2dqU-BDyWKuobYSxw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chicle/v26/lJwG-pw9i2dqU-BzyGiq.ttf"
    },
    {
      "family": "Chilanka",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "malayalam"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chilanka/v22/WWXRlj2DZQiMJYaYRrJQI9EAZhTO.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chilanka/v22/WWXRlj2DZQiMJYaYRoJRKdU.ttf"
    },
    {
      "family": "Chiron Hei HK",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "chinese-hongkong",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "symbols2",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-06-25",
      "files": {
        "200": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lLtr18MkTEyjPI0.ttf",
        "300": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lIzr18MkTEyjPI0.ttf",
        "regular": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lJtr18MkTEyjPI0.ttf",
        "500": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lJfr18MkTEyjPI0.ttf",
        "600": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lKzqF8MkTEyjPI0.ttf",
        "700": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lKKqF8MkTEyjPI0.ttf",
        "800": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lLtqF8MkTEyjPI0.ttf",
        "900": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lLEqF8MkTEyjPI0.ttf",
        "200italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7DdPmzUQieI0QjQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7OlPmzUQieI0QjQ.ttf",
        "italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7LdPmzUQieI0QjQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7IVPmzUQieI0QjQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7GlImzUQieI0QjQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7FBImzUQieI0QjQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7DdImzUQieI0QjQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/chironheihk/v1/wXK8E3MSr44vpVKPvzqVJaxhjXUJvtAmXhfU2Uel7B5ImzUQieI0QjQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chironheihk/v1/wXK-E3MSr44vpVKPvzqVJaxhp3w7QQhPNY163lJtr28NmzU.ttf"
    },
    {
      "family": "Chiron Sung HK",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "chinese-hongkong",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "symbols2",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-06-12",
      "files": {
        "200": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjdOSt_krURtf4_Q.ttf",
        "300": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjquSt_krURtf4_Q.ttf",
        "regular": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRj9OSt_krURtf4_Q.ttf",
        "500": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjxuSt_krURtf4_Q.ttf",
        "600": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjKuOt_krURtf4_Q.ttf",
        "700": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjE-Ot_krURtf4_Q.ttf",
        "800": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjdOOt_krURtf4_Q.ttf",
        "900": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRjXeOt_krURtf4_Q.ttf",
        "200italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKfFvUDQZNLo_U2r.ttf",
        "300italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKcbvUDQZNLo_U2r.ttf",
        "italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKdFvUDQZNLo_U2r.ttf",
        "500italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKd3vUDQZNLo_U2r.ttf",
        "600italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKebukDQZNLo_U2r.ttf",
        "700italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKeiukDQZNLo_U2r.ttf",
        "800italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKfFukDQZNLo_U2r.ttf",
        "900italic": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFvD_XLTZPpXIpS3-3dhGzHTQKsJzDwcbmjWBN2PKfsukDQZNLo_U2r.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chironsunghk/v1/nuFtD_XLTZPpXIpS3-3dhGzHTSilFc8oGNI59hRj9OSd_0DQ.ttf"
    },
    {
      "family": "Chivo",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_vB7ul2DSFXjQiQ.ttf",
        "200": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_PB_ul2DSFXjQiQ.ttf",
        "300": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_4h_ul2DSFXjQiQ.ttf",
        "regular": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_vB_ul2DSFXjQiQ.ttf",
        "500": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_jh_ul2DSFXjQiQ.ttf",
        "600": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_Yhjul2DSFXjQiQ.ttf",
        "700": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_Wxjul2DSFXjQiQ.ttf",
        "800": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_PBjul2DSFXjQiQ.ttf",
        "900": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_FRjul2DSFXjQiQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFwG1WrWN33AiasJ.ttf",
        "200italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFyG1GrWN33AiasJ.ttf",
        "300italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFxY1GrWN33AiasJ.ttf",
        "italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFwG1GrWN33AiasJ.ttf",
        "500italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFw01GrWN33AiasJ.ttf",
        "600italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFzY02rWN33AiasJ.ttf",
        "700italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFzh02rWN33AiasJ.ttf",
        "800italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFyG02rWN33AiasJ.ttf",
        "900italic": "https://fonts.gstatic.com/s/chivo/v20/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFyv02rWN33AiasJ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chivo/v20/va9b4kzIxd1KFppkaRKvDRPJVDf_vB_elmrW.ttf"
    },
    {
      "family": "Chivo Mono",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7hrqfVKphL03l4.ttf",
        "200": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D5hr6fVKphL03l4.ttf",
        "300": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D6_r6fVKphL03l4.ttf",
        "regular": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7hr6fVKphL03l4.ttf",
        "500": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7Tr6fVKphL03l4.ttf",
        "600": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D4_qKfVKphL03l4.ttf",
        "700": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D4GqKfVKphL03l4.ttf",
        "800": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D5hqKfVKphL03l4.ttf",
        "900": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D5IqKfVKphL03l4.ttf",
        "100italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7E-XIJxp1ml4imo.ttf",
        "200italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7M-WIJxp1ml4imo.ttf",
        "300italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7BGWIJxp1ml4imo.ttf",
        "italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7E-WIJxp1ml4imo.ttf",
        "500italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7H2WIJxp1ml4imo.ttf",
        "600italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7JGRIJxp1ml4imo.ttf",
        "700italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7KiRIJxp1ml4imo.ttf",
        "800italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7M-RIJxp1ml4imo.ttf",
        "900italic": "https://fonts.gstatic.com/s/chivomono/v10/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7OaRIJxp1ml4imo.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chivomono/v10/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7hr5fUIJw.ttf"
    },
    {
      "family": "Chocolate Classical Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-traditional",
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chocolateclassicalsans/v14/nuFqD-PLTZX4XIgT-P2ToCDudWHHflqUpTpfjWdDPI2J9mHITw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chocolateclassicalsans/v14/nuFqD-PLTZX4XIgT-P2ToCDudWHHflqUpTpfjWdzPYeN.ttf"
    },
    {
      "family": "Chokokutai",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-06-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chokokutai/v11/kmK4Zqw4HwvCeHGM8Fws9y7ypu1Kr7I.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chokokutai/v11/kmK4Zqw4HwvCeHGM8Fwsxy_4og.ttf"
    },
    {
      "family": "Chonburi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/chonburi/v13/8AtqGs-wOpGRTBq66IWaFr3biAfZ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/chonburi/v13/8AtqGs-wOpGRTBq66LWbHLk.ttf"
    },
    {
      "family": "Cinzel",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-tbnTYrvDE5ZdqU.ttf",
        "500": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-uTnTYrvDE5ZdqU.ttf",
        "600": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-gjgTYrvDE5ZdqU.ttf",
        "700": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-jHgTYrvDE5ZdqU.ttf",
        "800": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-lbgTYrvDE5ZdqU.ttf",
        "900": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-n_gTYrvDE5ZdqU.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cinzel/v25/8vIU7ww63mVu7gtR-kwKxNvkNOjw-tbnfYvlCA.ttf"
    },
    {
      "family": "Cinzel Decorative",
      "variants": [
        "regular",
        "700",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cinzeldecorative/v18/daaCSScvJGqLYhG8nNt8KPPswUAPnh7URs1LaCyC.ttf",
        "700": "https://fonts.gstatic.com/s/cinzeldecorative/v18/daaHSScvJGqLYhG8nNt8KPPswUAPniZoaelDQzCLlQXE.ttf",
        "900": "https://fonts.gstatic.com/s/cinzeldecorative/v18/daaHSScvJGqLYhG8nNt8KPPswUAPniZQa-lDQzCLlQXE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cinzeldecorative/v18/daaCSScvJGqLYhG8nNt8KPPswUAPni7VTMk.ttf"
    },
    {
      "family": "Clicker Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/clickerscript/v13/raxkHiKPvt8CMH6ZWP8PdlEq72rY2zqUKafv.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/clickerscript/v13/raxkHiKPvt8CMH6ZWP8PdlEq71rZ0T4.ttf"
    },
    {
      "family": "Climate Crisis",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/climatecrisis/v13/wEOpEB3AntNeKCPBVW9XOKlmp3AUgWFN1DvIvcM0gFp6jaUrGb7PsQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/climatecrisis/v13/wEOpEB3AntNeKCPBVW9XOKlmp3AUgWFN1DvIvcM0gFpKjK8v.ttf"
    },
    {
      "family": "Coda",
      "variants": [
        "regular",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/coda/v21/SLXHc1jY5nQ8JUIMapaN39I.ttf",
        "800": "https://fonts.gstatic.com/s/coda/v21/SLXIc1jY5nQ8HeIgTp6mw9t1cX8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/coda/v21/SLXHc1jY5nQ8FUMGbg.ttf"
    },
    {
      "family": "Codystar",
      "variants": [
        "300",
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/codystar/v18/FwZf7-Q1xVk-40qxOuYsyuyrj0e29bfC.ttf",
        "regular": "https://fonts.gstatic.com/s/codystar/v18/FwZY7-Q1xVk-40qxOt6A4sijpFu_.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/codystar/v18/FwZY7-Q1xVk-40qxOu6B6Mw.ttf"
    },
    {
      "family": "Coiny",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/coiny/v16/gyByhwU1K989PXwbElSvO5Tc.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/coiny/v16/gyByhwU1K989PUwaGFA.ttf"
    },
    {
      "family": "Combo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/combo/v21/BXRlvF3Jh_fIhg0iBu9y8Hf0.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/combo/v21/BXRlvF3Jh_fIhj0jDOs.ttf"
    },
    {
      "family": "Comfortaa",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v46",
      "lastModified": "2025-05-29",
      "files": {
        "300": "https://fonts.gstatic.com/s/comfortaa/v46/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4TbMPrQVIT9c2c8.ttf",
        "regular": "https://fonts.gstatic.com/s/comfortaa/v46/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4WjMPrQVIT9c2c8.ttf",
        "500": "https://fonts.gstatic.com/s/comfortaa/v46/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4VrMPrQVIT9c2c8.ttf",
        "600": "https://fonts.gstatic.com/s/comfortaa/v46/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4bbLPrQVIT9c2c8.ttf",
        "700": "https://fonts.gstatic.com/s/comfortaa/v46/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4Y_LPrQVIT9c2c8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comfortaa/v46/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4WjMDrUfJQ.ttf"
    },
    {
      "family": "Comforter",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/comforter/v8/H4clBXOCl8nQnlaql3Qa6JG8iqeuag.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comforter/v8/H4clBXOCl8nQnlaql3Qq6Zu4.ttf"
    },
    {
      "family": "Comforter Brush",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/comforterbrush/v8/Y4GTYa1xVSggrfzZI5WMjxRaOz0jwLL9Th8YYA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comforterbrush/v8/Y4GTYa1xVSggrfzZI5WMjxRaOz0Twbj5.ttf"
    },
    {
      "family": "Comic Neue",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v8",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/comicneue/v8/4UaErEJDsxBrF37olUeD_wHLwpteLwtHJlc.ttf",
        "300italic": "https://fonts.gstatic.com/s/comicneue/v8/4UaarEJDsxBrF37olUeD96_RTplUKylCNlcw_Q.ttf",
        "regular": "https://fonts.gstatic.com/s/comicneue/v8/4UaHrEJDsxBrF37olUeDx63j5pN1MwI.ttf",
        "italic": "https://fonts.gstatic.com/s/comicneue/v8/4UaFrEJDsxBrF37olUeD96_p4rFwIwJePw.ttf",
        "700": "https://fonts.gstatic.com/s/comicneue/v8/4UaErEJDsxBrF37olUeD_xHMwpteLwtHJlc.ttf",
        "700italic": "https://fonts.gstatic.com/s/comicneue/v8/4UaarEJDsxBrF37olUeD96_RXp5UKylCNlcw_Q.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comicneue/v8/4UaHrEJDsxBrF37olUeD96zp4g.ttf"
    },
    {
      "family": "Comic Relief",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "greek",
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/comicrelief/v2/BCauqZkHrvL55SZ8uaEhHMY2XBJhDgs-Kg.ttf",
        "700": "https://fonts.gstatic.com/s/comicrelief/v2/BCaxqZkHrvL55SZ8uaEhHMYO4D1FBiAiI1y92w.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comicrelief/v2/BCauqZkHrvL55SZ8uaEhHMYGXRhl.ttf"
    },
    {
      "family": "Coming Soon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/comingsoon/v19/qWcuB6mzpYL7AJ2VfdQR1u-SUjjzsykh.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comingsoon/v19/qWcuB6mzpYL7AJ2VfdQR1t-TWDw.ttf"
    },
    {
      "family": "Comme",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1z5cBr644fWsRO9w.ttf",
        "200": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1zZcFr644fWsRO9w.ttf",
        "300": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1zu8Fr644fWsRO9w.ttf",
        "regular": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1z5cFr644fWsRO9w.ttf",
        "500": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1z18Fr644fWsRO9w.ttf",
        "600": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1zO8Zr644fWsRO9w.ttf",
        "700": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1zAsZr644fWsRO9w.ttf",
        "800": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1zZcZr644fWsRO9w.ttf",
        "900": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1zTMZr644fWsRO9w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/comme/v3/8QIUdirKhMbn-uG1kHz0MgviDe1z5cFb6oQb.ttf"
    },
    {
      "family": "Commissioner",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTMNcGPe7Fu0jUdk.ttf",
        "200": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTENdGPe7Fu0jUdk.ttf",
        "300": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTJ1dGPe7Fu0jUdk.ttf",
        "regular": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTMNdGPe7Fu0jUdk.ttf",
        "500": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTPFdGPe7Fu0jUdk.ttf",
        "600": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTB1aGPe7Fu0jUdk.ttf",
        "700": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTCRaGPe7Fu0jUdk.ttf",
        "800": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTENaGPe7Fu0jUdk.ttf",
        "900": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTGpaGPe7Fu0jUdk.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/commissioner/v23/tDaH2o2WnlgI0FNDgduEk4jAhwgumbU1SVfU5BD8OuRL8OstC6KOhgvBYWSFJ-Mgdrgiju6fF8meZm0rk4eF-ZugTMNdKPaxEg.ttf"
    },
    {
      "family": "Concert One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/concertone/v23/VEM1Ro9xs5PjtzCu-srDqRTlhv-CuVAQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/concertone/v23/VEM1Ro9xs5PjtzCu-srDqSTkjPs.ttf"
    },
    {
      "family": "Condiment",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/condiment/v25/pONk1hggFNmwvXALyH6Sq4n4o1vyCQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/condiment/v25/pONk1hggFNmwvXALyH6iqoP8.ttf"
    },
    {
      "family": "Content",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "khmer"
      ],
      "version": "v27",
      "lastModified": "2024-12-04",
      "files": {
        "regular": "https://fonts.gstatic.com/s/content/v27/zrfl0HLayePhU_AwUaDyIiL0RCg.ttf",
        "700": "https://fonts.gstatic.com/s/content/v27/zrfg0HLayePhU_AwaRzdBirfWCHvkAI.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/content/v27/zrfl0HLayePhU_AwYaH4Jg.ttf"
    },
    {
      "family": "Contrail One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/contrailone/v20/eLGbP-j_JA-kG0_Zo51noafdZUvt_c092w.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/contrailone/v20/eLGbP-j_JA-kG0_Zo51noaftZEHp.ttf"
    },
    {
      "family": "Convergence",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/convergence/v15/rax5HiePvdgXPmmMHcIPYRhasU7Q8Cad.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/convergence/v15/rax5HiePvdgXPmmMHcIPYShbu0o.ttf"
    },
    {
      "family": "Cookie",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cookie/v22/syky-y18lb0tSbfNlQCT9tPdpw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cookie/v22/syky-y18lb0tSbf9lAqX.ttf"
    },
    {
      "family": "Copse",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/copse/v15/11hPGpDKz1rGb0djHkihUb-A.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/copse/v15/11hPGpDKz1rGb3diFEw.ttf"
    },
    {
      "family": "Coral Pixels",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/coralpixels/v1/qWctB66zpZ3zAtrlR8Mb1LyyeBb_ujA4ug.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/coralpixels/v1/qWctB66zpZ3zAtrlR8Mb1LyCeRz7.ttf",
      "colorCapabilities": [
        "COLRv0"
      ]
    },
    {
      "family": "Corben",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/corben/v22/LYjDdGzzklQtCMp9oAlEpVs3VQ.ttf",
        "700": "https://fonts.gstatic.com/s/corben/v22/LYjAdGzzklQtCMpFHCZgrXArXN7HWQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/corben/v22/LYjDdGzzklQtCMpNoQNA.ttf"
    },
    {
      "family": "Corinthia",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/corinthia/v12/wEO_EBrAnchaJyPMHE0FUfAL3EsHiA.ttf",
        "700": "https://fonts.gstatic.com/s/corinthia/v12/wEO6EBrAnchaJyPMHE097d8v1GAbgbLXQA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/corinthia/v12/wEO_EBrAnchaJyPMHE01UPoP.ttf"
    },
    {
      "family": "Cormorant",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/cormorant/v23/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFk9TQ7Rg7A2uwYs.ttf",
        "regular": "https://fonts.gstatic.com/s/cormorant/v23/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFhFTQ7Rg7A2uwYs.ttf",
        "500": "https://fonts.gstatic.com/s/cormorant/v23/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFiNTQ7Rg7A2uwYs.ttf",
        "600": "https://fonts.gstatic.com/s/cormorant/v23/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFs9UQ7Rg7A2uwYs.ttf",
        "700": "https://fonts.gstatic.com/s/cormorant/v23/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFvZUQ7Rg7A2uwYs.ttf",
        "300italic": "https://fonts.gstatic.com/s/cormorant/v23/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQ9fdq6C-r0YvxdA.ttf",
        "italic": "https://fonts.gstatic.com/s/cormorant/v23/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQq_dq6C-r0YvxdA.ttf",
        "500italic": "https://fonts.gstatic.com/s/cormorant/v23/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQmfdq6C-r0YvxdA.ttf",
        "600italic": "https://fonts.gstatic.com/s/cormorant/v23/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQdfBq6C-r0YvxdA.ttf",
        "700italic": "https://fonts.gstatic.com/s/cormorant/v23/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQTPBq6C-r0YvxdA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cormorant/v23/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFhFTc7Vq6A.ttf"
    },
    {
      "family": "Cormorant Garamond",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3umX5slCNuHLi8bLeY9MK7whWMhyjypVO7abI26QOD_qE6GnPEi_s4Mfs.ttf",
        "regular": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3umX5slCNuHLi8bLeY9MK7whWMhyjypVO7abI26QOD_v86GnPEi_s4Mfs.ttf",
        "500": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3umX5slCNuHLi8bLeY9MK7whWMhyjypVO7abI26QOD_s06GnPEi_s4Mfs.ttf",
        "600": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3umX5slCNuHLi8bLeY9MK7whWMhyjypVO7abI26QOD_iE9GnPEi_s4Mfs.ttf",
        "700": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3umX5slCNuHLi8bLeY9MK7whWMhyjypVO7abI26QOD_hg9GnPEi_s4Mfs.ttf",
        "300italic": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3smX5slCNuHLi8bLeY9MK7whWMhyjYrGFEsdtdc62E6zd5rDDOj9k9Ifu5UQ.ttf",
        "italic": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3smX5slCNuHLi8bLeY9MK7whWMhyjYrGFEsdtdc62E6zd58jDOj9k9Ifu5UQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3smX5slCNuHLi8bLeY9MK7whWMhyjYrGFEsdtdc62E6zd5wDDOj9k9Ifu5UQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3smX5slCNuHLi8bLeY9MK7whWMhyjYrGFEsdtdc62E6zd5LDfOj9k9Ifu5UQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3smX5slCNuHLi8bLeY9MK7whWMhyjYrGFEsdtdc62E6zd5FTfOj9k9Ifu5UQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cormorantgaramond/v20/co3umX5slCNuHLi8bLeY9MK7whWMhyjypVO7abI26QOD_v86KnLOjw.ttf"
    },
    {
      "family": "Cormorant Infant",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/cormorantinfant/v21/HhyCU44g9vKiM1sORYSiWeAsLN99xfs9KOOc_agJPrhxYOWThDlDkWSy.ttf",
        "regular": "https://fonts.gstatic.com/s/cormorantinfant/v21/HhyCU44g9vKiM1sORYSiWeAsLN99xfs9KOOc_agJPrgvYOWThDlDkWSy.ttf",
        "500": "https://fonts.gstatic.com/s/cormorantinfant/v21/HhyCU44g9vKiM1sORYSiWeAsLN99xfs9KOOc_agJPrgdYOWThDlDkWSy.ttf",
        "600": "https://fonts.gstatic.com/s/cormorantinfant/v21/HhyCU44g9vKiM1sORYSiWeAsLN99xfs9KOOc_agJPrjxZ-WThDlDkWSy.ttf",
        "700": "https://fonts.gstatic.com/s/cormorantinfant/v21/HhyCU44g9vKiM1sORYSiWeAsLN99xfs9KOOc_agJPrjIZ-WThDlDkWSy.ttf",
        "300italic": "https://fonts.gstatic.com/s/cormorantinfant/v21/Hhy8U44g9vKiM1sORYSiWeAsLN997_IP1zv1ljKnOa3nI1PQjj1hlHSyazs.ttf",
        "italic": "https://fonts.gstatic.com/s/cormorantinfant/v21/Hhy8U44g9vKiM1sORYSiWeAsLN997_IP1zv1ljKnOa3nIw3Qjj1hlHSyazs.ttf",
        "500italic": "https://fonts.gstatic.com/s/cormorantinfant/v21/Hhy8U44g9vKiM1sORYSiWeAsLN997_IP1zv1ljKnOa3nIz_Qjj1hlHSyazs.ttf",
        "600italic": "https://fonts.gstatic.com/s/cormorantinfant/v21/Hhy8U44g9vKiM1sORYSiWeAsLN997_IP1zv1ljKnOa3nI9PXjj1hlHSyazs.ttf",
        "700italic": "https://fonts.gstatic.com/s/cormorantinfant/v21/Hhy8U44g9vKiM1sORYSiWeAsLN997_IP1zv1ljKnOa3nI-rXjj1hlHSyazs.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cormorantinfant/v21/HhyCU44g9vKiM1sORYSiWeAsLN99xfs9KOOc_agJPrgvYNWSjj0.ttf"
    },
    {
      "family": "Cormorant SC",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/cormorantsc/v18/0ybmGD4kxqXBmOVLG30OGwsmABIU_R3y8DOWGA.ttf",
        "regular": "https://fonts.gstatic.com/s/cormorantsc/v18/0yb5GD4kxqXBmOVLG30OGwserDow9Tbu-Q.ttf",
        "500": "https://fonts.gstatic.com/s/cormorantsc/v18/0ybmGD4kxqXBmOVLG30OGwsmWBMU_R3y8DOWGA.ttf",
        "600": "https://fonts.gstatic.com/s/cormorantsc/v18/0ybmGD4kxqXBmOVLG30OGwsmdBQU_R3y8DOWGA.ttf",
        "700": "https://fonts.gstatic.com/s/cormorantsc/v18/0ybmGD4kxqXBmOVLG30OGwsmEBUU_R3y8DOWGA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cormorantsc/v18/0yb5GD4kxqXBmOVLG30OGwsurTA0.ttf"
    },
    {
      "family": "Cormorant Unicase",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9N_tucv7Gy0DRzS.ttf",
        "regular": "https://fonts.gstatic.com/s/cormorantunicase/v24/HI_QiZUaILtOqhqgDeXoF_n1_fTGX-vTnsMnx3C9.ttf",
        "500": "https://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9Mnt-cv7Gy0DRzS.ttf",
        "600": "https://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9MLsOcv7Gy0DRzS.ttf",
        "700": "https://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9Nvsecv7Gy0DRzS.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cormorantunicase/v24/HI_QiZUaILtOqhqgDeXoF_n1_fTGX9vSlMc.ttf"
    },
    {
      "family": "Cormorant Upright",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1N5phDsU9X6RPzQ.ttf",
        "regular": "https://fonts.gstatic.com/s/cormorantupright/v18/VuJrdM3I2Y35poFONtLdafkUCHw1y2vVjjTkeMnz.ttf",
        "500": "https://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1MhpxDsU9X6RPzQ.ttf",
        "600": "https://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1MNoBDsU9X6RPzQ.ttf",
        "700": "https://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1NpoRDsU9X6RPzQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cormorantupright/v18/VuJrdM3I2Y35poFONtLdafkUCHw1y1vUhDA.ttf"
    },
    {
      "family": "Courgette",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/courgette/v18/wEO_EBrAnc9BLjLQAUkFUfAL3EsHiA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/courgette/v18/wEO_EBrAnc9BLjLQAUk1UPoP.ttf"
    },
    {
      "family": "Courier Prime",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/courierprime/v10/u-450q2lgwslOqpF_6gQ8kELWwZjW-_-tvg.ttf",
        "italic": "https://fonts.gstatic.com/s/courierprime/v10/u-4n0q2lgwslOqpF_6gQ8kELawRpX837pvjxPA.ttf",
        "700": "https://fonts.gstatic.com/s/courierprime/v10/u-4k0q2lgwslOqpF_6gQ8kELY7pMf-fVqvHoJXw.ttf",
        "700italic": "https://fonts.gstatic.com/s/courierprime/v10/u-4i0q2lgwslOqpF_6gQ8kELawRR4-LfrtPtNXyeAg.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/courierprime/v10/u-450q2lgwslOqpF_6gQ8kELawdpXw.ttf"
    },
    {
      "family": "Cousine",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cousine/v28/d6lIkaiiRdih4SpPzSMlzTbtz9k.ttf",
        "italic": "https://fonts.gstatic.com/s/cousine/v28/d6lKkaiiRdih4SpP_SEvyRTo39l8hw.ttf",
        "700": "https://fonts.gstatic.com/s/cousine/v28/d6lNkaiiRdih4SpP9Z8K6T7G09BlnmQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/cousine/v28/d6lPkaiiRdih4SpP_SEXdTvM1_JgjmRpOA.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cousine/v28/d6lIkaiiRdih4SpP_SIvyQ.ttf"
    },
    {
      "family": "Coustard",
      "variants": [
        "regular",
        "900"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/coustard/v16/3XFpErgg3YsZ5fqUU9UPvWXuROTd.ttf",
        "900": "https://fonts.gstatic.com/s/coustard/v16/3XFuErgg3YsZ5fqUU-2LkEHmb_jU3eRL.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/coustard/v16/3XFpErgg3YsZ5fqUU-UOt2E.ttf"
    },
    {
      "family": "Covered By Your Grace",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/coveredbyyourgrace/v16/QGYwz-AZahWOJJI9kykWW9mD6opopoqXSOS0FgItq6bFIg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/coveredbyyourgrace/v16/QGYwz-AZahWOJJI9kykWW9mD6opopoqXSOSEFwgp.ttf"
    },
    {
      "family": "Crafty Girls",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/craftygirls/v16/va9B4kXI39VaDdlPJo8N_NvuQR37fF3Wlg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/craftygirls/v16/va9B4kXI39VaDdlPJo8N_NveQBf_.ttf"
    },
    {
      "family": "Creepster",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/creepster/v13/AlZy_zVUqJz4yMrniH4hdXf4XB0Tow.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/creepster/v13/AlZy_zVUqJz4yMrniH4RdH38.ttf"
    },
    {
      "family": "Crete Round",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/creteround/v15/55xoey1sJNPjPiv1ZZZrxJ1827zAKnxN.ttf",
        "italic": "https://fonts.gstatic.com/s/creteround/v15/55xqey1sJNPjPiv1ZZZrxK1-0bjiL2xNhKc.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/creteround/v15/55xoey1sJNPjPiv1ZZZrxK190bg.ttf"
    },
    {
      "family": "Crimson Pro",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZTm18OJE_VNWoyQ.ttf",
        "300": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZkG18OJE_VNWoyQ.ttf",
        "regular": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZzm18OJE_VNWoyQ.ttf",
        "500": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZ_G18OJE_VNWoyQ.ttf",
        "600": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZEGp8OJE_VNWoyQ.ttf",
        "700": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZKWp8OJE_VNWoyQ.ttf",
        "800": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZTmp8OJE_VNWoyQ.ttf",
        "900": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZZ2p8OJE_VNWoyQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi4Ue5s7dtC4yZNE.ttf",
        "300italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi7Ke5s7dtC4yZNE.ttf",
        "italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi6Ue5s7dtC4yZNE.ttf",
        "500italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi6me5s7dtC4yZNE.ttf",
        "600italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi5KfJs7dtC4yZNE.ttf",
        "700italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi5zfJs7dtC4yZNE.ttf",
        "800italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi4UfJs7dtC4yZNE.ttf",
        "900italic": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi49fJs7dtC4yZNE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/crimsonpro/v27/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZzm1MOZs7.ttf"
    },
    {
      "family": "Crimson Text",
      "variants": [
        "regular",
        "italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/crimsontext/v19/wlp2gwHKFkZgtmSR3NB0oRJvaAJSA_JN3Q.ttf",
        "italic": "https://fonts.gstatic.com/s/crimsontext/v19/wlpogwHKFkZgtmSR3NB0oRJfaghWIfdd3ahG.ttf",
        "600": "https://fonts.gstatic.com/s/crimsontext/v19/wlppgwHKFkZgtmSR3NB0oRJXsCx2C9lR1LFffg.ttf",
        "600italic": "https://fonts.gstatic.com/s/crimsontext/v19/wlprgwHKFkZgtmSR3NB0oRJfajCOD9NV9rRPfrKu.ttf",
        "700": "https://fonts.gstatic.com/s/crimsontext/v19/wlppgwHKFkZgtmSR3NB0oRJX1C12C9lR1LFffg.ttf",
        "700italic": "https://fonts.gstatic.com/s/crimsontext/v19/wlprgwHKFkZgtmSR3NB0oRJfajDqDtNV9rRPfrKu.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/crimsontext/v19/wlp2gwHKFkZgtmSR3NB0oRJfaQhW.ttf"
    },
    {
      "family": "Croissant One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/croissantone/v27/3y9n6bU9bTPg4m8NDy3Kq24UM3pqn5cdJ-4.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/croissantone/v27/3y9n6bU9bTPg4m8NDy3Kq24UA3tgmw.ttf"
    },
    {
      "family": "Crushed",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v31",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/crushed/v31/U9Mc6dym6WXImTlFT1kfuIqyLzA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/crushed/v31/U9Mc6dym6WXImTlFf1gVvA.ttf"
    },
    {
      "family": "Cuprum",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cuprum/v28/dg45_pLmvrkcOkBnKsOzXyGWTBcmg-X6ZjzSJjQjgnU.ttf",
        "500": "https://fonts.gstatic.com/s/cuprum/v28/dg45_pLmvrkcOkBnKsOzXyGWTBcmg9f6ZjzSJjQjgnU.ttf",
        "600": "https://fonts.gstatic.com/s/cuprum/v28/dg45_pLmvrkcOkBnKsOzXyGWTBcmgzv9ZjzSJjQjgnU.ttf",
        "700": "https://fonts.gstatic.com/s/cuprum/v28/dg45_pLmvrkcOkBnKsOzXyGWTBcmgwL9ZjzSJjQjgnU.ttf",
        "italic": "https://fonts.gstatic.com/s/cuprum/v28/dg47_pLmvrkcOkBNI_FMh0j91rkhli25jn_YIhYmknUPEA.ttf",
        "500italic": "https://fonts.gstatic.com/s/cuprum/v28/dg47_pLmvrkcOkBNI_FMh0j91rkhli25vH_YIhYmknUPEA.ttf",
        "600italic": "https://fonts.gstatic.com/s/cuprum/v28/dg47_pLmvrkcOkBNI_FMh0j91rkhli25UHjYIhYmknUPEA.ttf",
        "700italic": "https://fonts.gstatic.com/s/cuprum/v28/dg47_pLmvrkcOkBNI_FMh0j91rkhli25aXjYIhYmknUPEA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cuprum/v28/dg45_pLmvrkcOkBnKsOzXyGWTBcmg-X6Vj3YIg.ttf"
    },
    {
      "family": "Cute Font",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v27",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cutefont/v27/Noaw6Uny2oWPbSHMrY6vmJNVNC9hkw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cutefont/v27/Noaw6Uny2oWPbSHMrY6fmZlR.ttf"
    },
    {
      "family": "Cutive",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cutive/v23/NaPZcZ_fHOhV3Ip7T_hDoyqlZQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cutive/v23/NaPZcZ_fHOhV3IpLTvJH.ttf"
    },
    {
      "family": "Cutive Mono",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/cutivemono/v22/m8JWjfRfY7WVjVi2E-K9H5RFRG-K3Mud.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/cutivemono/v22/m8JWjfRfY7WVjVi2E-K9H6RETms.ttf"
    },
    {
      "family": "DM Mono",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/dmmono/v15/aFTR7PB1QTsUX8KYvrGyIYSnbKX9Rlk.ttf",
        "300italic": "https://fonts.gstatic.com/s/dmmono/v15/aFTT7PB1QTsUX8KYth-orYataIf4VllXuA.ttf",
        "regular": "https://fonts.gstatic.com/s/dmmono/v15/aFTU7PB1QTsUX8KYhh2aBYyMcKw.ttf",
        "italic": "https://fonts.gstatic.com/s/dmmono/v15/aFTW7PB1QTsUX8KYth-QAa6JYKzkXw.ttf",
        "500": "https://fonts.gstatic.com/s/dmmono/v15/aFTR7PB1QTsUX8KYvumzIYSnbKX9Rlk.ttf",
        "500italic": "https://fonts.gstatic.com/s/dmmono/v15/aFTT7PB1QTsUX8KYth-o9YetaIf4VllXuA.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dmmono/v15/aFTU7PB1QTsUX8KYthyQAQ.ttf"
    },
    {
      "family": "DM Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAop1hTmf3ZGMZpg.ttf",
        "200": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAIpxhTmf3ZGMZpg.ttf",
        "300": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwA_JxhTmf3ZGMZpg.ttf",
        "regular": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAopxhTmf3ZGMZpg.ttf",
        "500": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAkJxhTmf3ZGMZpg.ttf",
        "600": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAfJthTmf3ZGMZpg.ttf",
        "700": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwARZthTmf3ZGMZpg.ttf",
        "800": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAIpthTmf3ZGMZpg.ttf",
        "900": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAC5thTmf3ZGMZpg.ttf",
        "100italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat-JDG3zRmYJpso5.ttf",
        "200italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat8JDW3zRmYJpso5.ttf",
        "300italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat_XDW3zRmYJpso5.ttf",
        "italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat-JDW3zRmYJpso5.ttf",
        "500italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat-7DW3zRmYJpso5.ttf",
        "600italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat9XCm3zRmYJpso5.ttf",
        "700italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat9uCm3zRmYJpso5.ttf",
        "800italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat8JCm3zRmYJpso5.ttf",
        "900italic": "https://fonts.gstatic.com/s/dmsans/v16/rP2rp2ywxg089UriCZaSExd86J3t9jz86Mvy4qCRAL19DksVat8gCm3zRmYJpso5.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dmsans/v16/rP2tp2ywxg089UriI5-g4vlH9VoD8CmcqZG40F9JadbnoEwAopxRT23z.ttf"
    },
    {
      "family": "DM Serif Display",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dmserifdisplay/v16/-nFnOHM81r4j6k0gjAW3mujVU2B2K_d709jy92k.ttf",
        "italic": "https://fonts.gstatic.com/s/dmserifdisplay/v16/-nFhOHM81r4j6k0gjAW3mujVU2B2G_Vx1_r352np3Q.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dmserifdisplay/v16/-nFnOHM81r4j6k0gjAW3mujVU2B2G_Zx1w.ttf"
    },
    {
      "family": "DM Serif Text",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dmseriftext/v12/rnCu-xZa_krGokauCeNq1wWyafOPXHIJErY.ttf",
        "italic": "https://fonts.gstatic.com/s/dmseriftext/v12/rnCw-xZa_krGokauCeNq1wWyWfGFWFAMArZKqQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dmseriftext/v12/rnCu-xZa_krGokauCeNq1wWyWfKFWA.ttf"
    },
    {
      "family": "Dai Banna SIL",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "new-tai-lue"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/daibannasil/v2/lW-lwj0AJWmpwGyJ2uEoA4I7tYKoDsrKOgMX95A.ttf",
        "300italic": "https://fonts.gstatic.com/s/daibannasil/v2/lW-jwj0AJWmpwGyJ2uEoA4I7vSyygsjAPiES55D3Vg.ttf",
        "regular": "https://fonts.gstatic.com/s/daibannasil/v2/lW-4wj0AJWmpwGyJ2uEoA4I7jS6AKsLhJgo.ttf",
        "italic": "https://fonts.gstatic.com/s/daibannasil/v2/lW-mwj0AJWmpwGyJ2uEoA4I7vSyKLuDkNgoO7g.ttf",
        "500": "https://fonts.gstatic.com/s/daibannasil/v2/lW-lwj0AJWmpwGyJ2uEoA4I7tdqpDsrKOgMX95A.ttf",
        "500italic": "https://fonts.gstatic.com/s/daibannasil/v2/lW-jwj0AJWmpwGyJ2uEoA4I7vSyy2snAPiES55D3Vg.ttf",
        "600": "https://fonts.gstatic.com/s/daibannasil/v2/lW-lwj0AJWmpwGyJ2uEoA4I7tfauDsrKOgMX95A.ttf",
        "600italic": "https://fonts.gstatic.com/s/daibannasil/v2/lW-jwj0AJWmpwGyJ2uEoA4I7vSyy9s7APiES55D3Vg.ttf",
        "700": "https://fonts.gstatic.com/s/daibannasil/v2/lW-lwj0AJWmpwGyJ2uEoA4I7tZKvDsrKOgMX95A.ttf",
        "700italic": "https://fonts.gstatic.com/s/daibannasil/v2/lW-jwj0AJWmpwGyJ2uEoA4I7vSyyks_APiES55D3Vg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/daibannasil/v2/lW-4wj0AJWmpwGyJ2uEoA4I7vS-KLg.ttf"
    },
    {
      "family": "Damion",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/damion/v15/hv-XlzJ3KEUe_YZUbWY3MTFgVg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/damion/v15/hv-XlzJ3KEUe_YZkbGwz.ttf"
    },
    {
      "family": "Dancing Script",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dancingscript/v28/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSoHTeB9ptDqpw.ttf",
        "500": "https://fonts.gstatic.com/s/dancingscript/v28/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BAyoHTeB9ptDqpw.ttf",
        "600": "https://fonts.gstatic.com/s/dancingscript/v28/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7B7y0HTeB9ptDqpw.ttf",
        "700": "https://fonts.gstatic.com/s/dancingscript/v28/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7B1i0HTeB9ptDqpw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dancingscript/v28/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3TOp5.ttf"
    },
    {
      "family": "Danfo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/danfo/v4/snf3s0u_98t16THfK1Csj3N41ZqbYDe5S71ToPrNKQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/danfo/v4/snf3s0u_98t16THfK1Csj3N41ZqbYDeJSrdX.ttf"
    },
    {
      "family": "Dangrek",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dangrek/v32/LYjCdG30nEgoH8E2gCNqqVIuTN4.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dangrek/v32/LYjCdG30nEgoH8E2sCJgrQ.ttf"
    },
    {
      "family": "Darker Grotesque",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v9",
      "lastModified": "2025-05-29",
      "files": {
        "300": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXxpqn7y-XFyZFUB.ttf",
        "regular": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXw3qn7y-XFyZFUB.ttf",
        "500": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXwFqn7y-XFyZFUB.ttf",
        "600": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXzprX7y-XFyZFUB.ttf",
        "700": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXzQrX7y-XFyZFUB.ttf",
        "800": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXy3rX7y-XFyZFUB.ttf",
        "900": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXyerX7y-XFyZFUB.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/darkergrotesque/v9/U9MK6cuh-mLQlC4BKCtayOfARkSVgb381b-W8-QDqXw3qk7z83U.ttf"
    },
    {
      "family": "Darumadrop One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-06-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/darumadropone/v13/cY9cfjeIW11dpCKgRLi675a87IhHBJOxZQPp.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/darumadropone/v13/cY9cfjeIW11dpCKgRLi675a87LhGDpc.ttf"
    },
    {
      "family": "David Libre",
      "variants": [
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext",
        "math",
        "symbols",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/davidlibre/v16/snfus0W_99N64iuYSvp4W_l86p6TYS-Y.ttf",
        "500": "https://fonts.gstatic.com/s/davidlibre/v16/snfzs0W_99N64iuYSvp4W8GIw7qbSjORSo9W.ttf",
        "700": "https://fonts.gstatic.com/s/davidlibre/v16/snfzs0W_99N64iuYSvp4W8HAxbqbSjORSo9W.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/davidlibre/v16/snfus0W_99N64iuYSvp4W8l94Jo.ttf"
    },
    {
      "family": "Dawning of a New Day",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dawningofanewday/v21/t5t_IQMbOp2SEwuncwLRjMfIg1yYit_nAz8bhWJGNoBE.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dawningofanewday/v21/t5t_IQMbOp2SEwuncwLRjMfIg1yYit_nAw8aj2Y.ttf"
    },
    {
      "family": "Days One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/daysone/v19/mem9YaCnxnKRiYZOCLYVeLkWVNBt.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/daysone/v19/mem9YaCnxnKRiYZOCIYUcr0.ttf"
    },
    {
      "family": "Dekko",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dekko/v22/46khlb_wWjfSrttFR0vsfl1B.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dekko/v22/46khlb_wWjfSrutETU8.ttf"
    },
    {
      "family": "Dela Gothic One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "greek",
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/delagothicone/v18/hESp6XxvMDRA-2eD0lXpDa6QkBAGRUsJQAlbUA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/delagothicone/v18/hESp6XxvMDRA-2eD0lXpDa6QkBA2REEN.ttf"
    },
    {
      "family": "Delicious Handrawn",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v9",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/delicioushandrawn/v9/wlpsgx_NAUNkpmKQifcxkQchDFo3fJ113JpDd6u3AQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/delicioushandrawn/v9/wlpsgx_NAUNkpmKQifcxkQchDFo3fJ1F3ZBH.ttf"
    },
    {
      "family": "Delius",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/delius/v20/PN_xRfK0pW_9e1rtYcI-jT3L_w.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/delius/v20/PN_xRfK0pW_9e1rdYMg6.ttf"
    },
    {
      "family": "Delius Swash Caps",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/deliusswashcaps/v24/oY1E8fPLr7v4JWCExZpWebxVKORpXXedKmeBvEYs.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/deliusswashcaps/v24/oY1E8fPLr7v4JWCExZpWebxVKORpXUecIGM.ttf"
    },
    {
      "family": "Delius Unicase",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/deliusunicase/v29/845BNMEwEIOVT8BmgfSzIr_6mmLHd-73LXWs.ttf",
        "700": "https://fonts.gstatic.com/s/deliusunicase/v29/845CNMEwEIOVT8BmgfSzIr_6mlp7WMr_BmmlS5aw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/deliusunicase/v29/845BNMEwEIOVT8BmgfSzIr_6mlLGfeo.ttf"
    },
    {
      "family": "Della Respira",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dellarespira/v23/RLp5K5v44KaueWI6iEJQBiGPRfkSu6EuTHo.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dellarespira/v23/RLp5K5v44KaueWI6iEJQBiGPdfgYvw.ttf"
    },
    {
      "family": "Denk One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/denkone/v20/dg4m_pzhrqcFb2IzROtHpbglShon.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/denkone/v20/dg4m_pzhrqcFb2IzRNtGr7w.ttf"
    },
    {
      "family": "Devonshire",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/devonshire/v28/46kqlbDwWirWr4gtBD2BX0Vq01lYAZM.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/devonshire/v28/46kqlbDwWirWr4gtBD2Bb0Rg1w.ttf"
    },
    {
      "family": "Dhurjati",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "telugu"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dhurjati/v26/_6_8ED3gSeatXfFiFX3ySKQtuTA2.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dhurjati/v26/_6_8ED3gSeatXfFiFU3zQqA.ttf"
    },
    {
      "family": "Didact Gothic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/didactgothic/v20/ahcfv8qz1zt6hCC5G4F_P4ASpUySp0LlcyQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/didactgothic/v20/ahcfv8qz1zt6hCC5G4F_P4ASlU2Yow.ttf"
    },
    {
      "family": "Diphylleia",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/diphylleia/v2/DtVmJxCtRKMixK4_HXsIulwm6gDXvwE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/diphylleia/v2/DtVmJxCtRKMixK4_HXsIil0s7g.ttf"
    },
    {
      "family": "Diplomata",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/diplomata/v32/Cn-0JtiMXwhNwp-wKxyfYGxYrdM9Sg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/diplomata/v32/Cn-0JtiMXwhNwp-wKxyvYWZc.ttf"
    },
    {
      "family": "Diplomata SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/diplomatasc/v29/buExpoi3ecvs3kidKgBJo2kf-P5Oaiw4cw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/diplomatasc/v29/buExpoi3ecvs3kidKgBJo2kv-fRK.ttf"
    },
    {
      "family": "Do Hyeon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dohyeon/v20/TwMN-I8CRRU2zM86HFE3ZwaH__-C.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dohyeon/v20/TwMN-I8CRRU2zM86HGE2bQI.ttf"
    },
    {
      "family": "Dokdo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dokdo/v22/esDf315XNuCBLxLo4NaMlKcH.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dokdo/v22/esDf315XNuCBLyLp6tI.ttf"
    },
    {
      "family": "Domine",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/domine/v24/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X3LAI10VErGuW8Q.ttf",
        "500": "https://fonts.gstatic.com/s/domine/v24/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X0DAI10VErGuW8Q.ttf",
        "600": "https://fonts.gstatic.com/s/domine/v24/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X6zHI10VErGuW8Q.ttf",
        "700": "https://fonts.gstatic.com/s/domine/v24/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X5XHI10VErGuW8Q.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/domine/v24/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X3LAE1wfFg.ttf"
    },
    {
      "family": "Donegal One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/donegalone/v21/m8JWjfRYea-ZnFz6fsK9FZRFRG-K3Mud.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/donegalone/v21/m8JWjfRYea-ZnFz6fsK9FaRETms.ttf"
    },
    {
      "family": "Dongle",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/dongle/v15/sJoG3Ltdjt6VPkqeEcxrYjWNzXvVPA.ttf",
        "regular": "https://fonts.gstatic.com/s/dongle/v15/sJoF3Ltdjt6VPkqmveRPah6RxA.ttf",
        "700": "https://fonts.gstatic.com/s/dongle/v15/sJoG3Ltdjt6VPkqeActrYjWNzXvVPA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dongle/v15/sJoF3Ltdjt6VPkqWvO5L.ttf"
    },
    {
      "family": "Doppio One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/doppioone/v13/Gg8wN5gSaBfyBw2MqCh-lgshKGpe5Fg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/doppioone/v13/Gg8wN5gSaBfyBw2MqCh-pgorLA.ttf"
    },
    {
      "family": "Dorsa",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dorsa/v28/yYLn0hjd0OGwqo493XCFxAnQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dorsa/v28/yYLn0hjd0OGwqr4813Q.ttf"
    },
    {
      "family": "Dosis",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v33",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJt7MV3BkFTq4EPw.ttf",
        "300": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJabMV3BkFTq4EPw.ttf",
        "regular": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJN7MV3BkFTq4EPw.ttf",
        "500": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJBbMV3BkFTq4EPw.ttf",
        "600": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJ6bQV3BkFTq4EPw.ttf",
        "700": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJ0LQV3BkFTq4EPw.ttf",
        "800": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJt7QV3BkFTq4EPw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dosis/v33/HhyJU5sn9vOmLxNkIwRSjTVNWLEJN7Ml3RMB.ttf"
    },
    {
      "family": "DotGothic16",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dotgothic16/v20/v6-QGYjBJFKgyw5nSoDAGE7L435YPFrT.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dotgothic16/v20/v6-QGYjBJFKgyw5nSoDAGH7K6Xo.ttf"
    },
    {
      "family": "Doto",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFOOOez0WSvrlpgw.ttf",
        "200": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFuOKez0WSvrlpgw.ttf",
        "300": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFZuKez0WSvrlpgw.ttf",
        "regular": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFOOKez0WSvrlpgw.ttf",
        "500": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFCuKez0WSvrlpgw.ttf",
        "600": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphF5uWez0WSvrlpgw.ttf",
        "700": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphF3-Wez0WSvrlpgw.ttf",
        "800": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFuOWez0WSvrlpgw.ttf",
        "900": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFkeWez0WSvrlpgw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/doto/v2/t5tJIRMbNJ6TQG7Il_EKPqP9zTnvqqGNcuvLMt1JIphFOOKuzk-W.ttf"
    },
    {
      "family": "Dr Sugiyama",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/drsugiyama/v29/HTxoL2k4N3O9n5I1boGI7abRM4-t-g7y.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/drsugiyama/v29/HTxoL2k4N3O9n5I1boGI7ZbQOYs.ttf"
    },
    {
      "family": "Duru Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/durusans/v20/xn7iYH8xwmSyTvEV_HOxT_fYdN-WZw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/durusans/v20/xn7iYH8xwmSyTvEV_HOBTv3c.ttf"
    },
    {
      "family": "DynaPuff",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dynapuff/v8/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RSxYu6YjrSRs4wn8.ttf",
        "500": "https://fonts.gstatic.com/s/dynapuff/v8/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RSyQu6YjrSRs4wn8.ttf",
        "600": "https://fonts.gstatic.com/s/dynapuff/v8/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RS8gp6YjrSRs4wn8.ttf",
        "700": "https://fonts.gstatic.com/s/dynapuff/v8/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RS_Ep6YjrSRs4wn8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dynapuff/v8/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RSxYu2YnhTQ.ttf"
    },
    {
      "family": "Dynalight",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/dynalight/v23/1Ptsg8LOU_aOmQvTsF4ISotrDfGGxA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/dynalight/v23/1Ptsg8LOU_aOmQvTsF44S4Fv.ttf"
    },
    {
      "family": "EB Garamond",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v31",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-6_RUA4V-e6yHgQ.ttf",
        "500": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-2fRUA4V-e6yHgQ.ttf",
        "600": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-NfNUA4V-e6yHgQ.ttf",
        "700": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-DPNUA4V-e6yHgQ.ttf",
        "800": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-a_NUA4V-e6yHgQ.ttf",
        "italic": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7e8QI96WamXgXFI.ttf",
        "500italic": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7eOQI96WamXgXFI.ttf",
        "600italic": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7diR496WamXgXFI.ttf",
        "700italic": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7dbR496WamXgXFI.ttf",
        "800italic": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7c8R496WamXgXFI.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ebgaramond/v31/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-6_RkAo96.ttf"
    },
    {
      "family": "Eagle Lake",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eaglelake/v25/ptRMTiqbbuNJDOiKj9wG5O7yKQNute8.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eaglelake/v25/ptRMTiqbbuNJDOiKj9wG1O_4LQ.ttf"
    },
    {
      "family": "East Sea Dokdo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eastseadokdo/v25/xfuo0Wn2V2_KanASqXSZp22m05_aGavYS18y.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eastseadokdo/v25/xfuo0Wn2V2_KanASqXSZp22m06_bE68.ttf"
    },
    {
      "family": "Eater",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eater/v26/mtG04_FCK7bOvpu2u3FwsXsR.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eater/v26/mtG04_FCK7bOvqu3sXU.ttf"
    },
    {
      "family": "Economica",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/economica/v16/Qw3fZQZaHCLgIWa29ZBrMcgAAl1lfQ.ttf",
        "italic": "https://fonts.gstatic.com/s/economica/v16/Qw3ZZQZaHCLgIWa29ZBbM8IEIFh1fWUl.ttf",
        "700": "https://fonts.gstatic.com/s/economica/v16/Qw3aZQZaHCLgIWa29ZBTjeckCnZ5dHw8iw.ttf",
        "700italic": "https://fonts.gstatic.com/s/economica/v16/Qw3EZQZaHCLgIWa29ZBbM_q4D3x9Vnksi4M7.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/economica/v16/Qw3fZQZaHCLgIWa29ZBbMMIE.ttf"
    },
    {
      "family": "Eczar",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "devanagari",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eczar/v26/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXHd6WqTIVKWJKWg.ttf",
        "500": "https://fonts.gstatic.com/s/eczar/v26/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXL96WqTIVKWJKWg.ttf",
        "600": "https://fonts.gstatic.com/s/eczar/v26/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXw9mWqTIVKWJKWg.ttf",
        "700": "https://fonts.gstatic.com/s/eczar/v26/BXR2vF3Pi-DLmxcpJB-qbNTyTMDX-tmWqTIVKWJKWg.ttf",
        "800": "https://fonts.gstatic.com/s/eczar/v26/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXndmWqTIVKWJKWg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eczar/v26/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXHd6mqDgR.ttf"
    },
    {
      "family": "Edu AU VIC WA NT Arrows",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduauvicwantarrows/v3/z7N7dQTteSlUDJZJAmUB9MuVbLPBjsrTFZLUbdjnSmlATbEWXt5tAcvhTTk90n91Vw.ttf",
        "500": "https://fonts.gstatic.com/s/eduauvicwantarrows/v3/z7N7dQTteSlUDJZJAmUB9MuVbLPBjsrTFZLUbdjnSmlATbEWXt5tM8vhTTk90n91Vw.ttf",
        "600": "https://fonts.gstatic.com/s/eduauvicwantarrows/v3/z7N7dQTteSlUDJZJAmUB9MuVbLPBjsrTFZLUbdjnSmlATbEWXt5t38zhTTk90n91Vw.ttf",
        "700": "https://fonts.gstatic.com/s/eduauvicwantarrows/v3/z7N7dQTteSlUDJZJAmUB9MuVbLPBjsrTFZLUbdjnSmlATbEWXt5t5szhTTk90n91Vw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduauvicwantarrows/v3/z7N7dQTteSlUDJZJAmUB9MuVbLPBjsrTFZLUbdjnSmlATbEWXt5tAcvRTDM5.ttf"
    },
    {
      "family": "Edu AU VIC WA NT Dots",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduauvicwantdots/v3/S6uQw5FFVDKI3kwwDUbsPHCpzZNhzrA3or3_B4dZ6MmTX8QNLvtYEtmT2SB3_5U.ttf",
        "500": "https://fonts.gstatic.com/s/eduauvicwantdots/v3/S6uQw5FFVDKI3kwwDUbsPHCpzZNhzrA3or3_B4dZ6MmTX8QNLslYEtmT2SB3_5U.ttf",
        "600": "https://fonts.gstatic.com/s/eduauvicwantdots/v3/S6uQw5FFVDKI3kwwDUbsPHCpzZNhzrA3or3_B4dZ6MmTX8QNLiVfEtmT2SB3_5U.ttf",
        "700": "https://fonts.gstatic.com/s/eduauvicwantdots/v3/S6uQw5FFVDKI3kwwDUbsPHCpzZNhzrA3or3_B4dZ6MmTX8QNLhxfEtmT2SB3_5U.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduauvicwantdots/v3/S6uQw5FFVDKI3kwwDUbsPHCpzZNhzrA3or3_B4dZ6MmTX8QNLvtYItiZ3Q.ttf"
    },
    {
      "family": "Edu AU VIC WA NT Guides",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduauvicwantguides/v2/TuG-UUJ4V48KZ9Nr3ZV46JQkJxtkFIKnvy00LCZuAcLMeb8FnyPdK1ZazoF08FsYlA.ttf",
        "500": "https://fonts.gstatic.com/s/eduauvicwantguides/v2/TuG-UUJ4V48KZ9Nr3ZV46JQkJxtkFIKnvy00LCZuAcLMeb8FnyPdGVZazoF08FsYlA.ttf",
        "600": "https://fonts.gstatic.com/s/eduauvicwantguides/v2/TuG-UUJ4V48KZ9Nr3ZV46JQkJxtkFIKnvy00LCZuAcLMeb8FnyPd9VFazoF08FsYlA.ttf",
        "700": "https://fonts.gstatic.com/s/eduauvicwantguides/v2/TuG-UUJ4V48KZ9Nr3ZV46JQkJxtkFIKnvy00LCZuAcLMeb8FnyPdzFFazoF08FsYlA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduauvicwantguides/v2/TuG-UUJ4V48KZ9Nr3ZV46JQkJxtkFIKnvy00LCZuAcLMeb8FnyPdK1Zqz4tw.ttf"
    },
    {
      "family": "Edu AU VIC WA NT Hand",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduauvicwanthand/v2/C8cO4dY1tX2x0uuiUHFS4y7ERV-jfqJ6x063HfvcsxiYKifhtCJ1lKtFbYfTEUU.ttf",
        "500": "https://fonts.gstatic.com/s/eduauvicwanthand/v2/C8cO4dY1tX2x0uuiUHFS4y7ERV-jfqJ6x063HfvcsxiYKifhtBB1lKtFbYfTEUU.ttf",
        "600": "https://fonts.gstatic.com/s/eduauvicwanthand/v2/C8cO4dY1tX2x0uuiUHFS4y7ERV-jfqJ6x063HfvcsxiYKifhtPxylKtFbYfTEUU.ttf",
        "700": "https://fonts.gstatic.com/s/eduauvicwanthand/v2/C8cO4dY1tX2x0uuiUHFS4y7ERV-jfqJ6x063HfvcsxiYKifhtMVylKtFbYfTEUU.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduauvicwanthand/v2/C8cO4dY1tX2x0uuiUHFS4y7ERV-jfqJ6x063HfvcsxiYKifhtCJ1pKpPaQ.ttf"
    },
    {
      "family": "Edu AU VIC WA NT Pre",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduauvicwantpre/v2/f0Xc0fWk-t0rbG8Ycr-t55aG0elTWbFeXaYI98CnuNLeosIyJmkwr6MhKkg6nw.ttf",
        "500": "https://fonts.gstatic.com/s/eduauvicwantpre/v2/f0Xc0fWk-t0rbG8Ycr-t55aG0elTWbFeXaYI98CnuNLeosIyFGkwr6MhKkg6nw.ttf",
        "600": "https://fonts.gstatic.com/s/eduauvicwantpre/v2/f0Xc0fWk-t0rbG8Ycr-t55aG0elTWbFeXaYI98CnuNLeosIy-G4wr6MhKkg6nw.ttf",
        "700": "https://fonts.gstatic.com/s/eduauvicwantpre/v2/f0Xc0fWk-t0rbG8Ycr-t55aG0elTWbFeXaYI98CnuNLeosIywW4wr6MhKkg6nw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduauvicwantpre/v2/f0Xc0fWk-t0rbG8Ycr-t55aG0elTWbFeXaYI98CnuNLeosIyJmkArqkl.ttf"
    },
    {
      "family": "Edu NSW ACT Cursive",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/edunswactcursive/v2/xn7LYGUw02PnIPEjskHSG_2fCaz9DzhQbcTNLWxkwsHVCrd5giiVjXBs6BMb.ttf",
        "500": "https://fonts.gstatic.com/s/edunswactcursive/v2/xn7LYGUw02PnIPEjskHSG_2fCaz9DzhQbcTNLWxkwsHVCrdLgiiVjXBs6BMb.ttf",
        "600": "https://fonts.gstatic.com/s/edunswactcursive/v2/xn7LYGUw02PnIPEjskHSG_2fCaz9DzhQbcTNLWxkwsHVCrenhSiVjXBs6BMb.ttf",
        "700": "https://fonts.gstatic.com/s/edunswactcursive/v2/xn7LYGUw02PnIPEjskHSG_2fCaz9DzhQbcTNLWxkwsHVCreehSiVjXBs6BMb.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/edunswactcursive/v2/xn7LYGUw02PnIPEjskHSG_2fCaz9DzhQbcTNLWxkwsHVCrd5ghiUh3Q.ttf"
    },
    {
      "family": "Edu NSW ACT Foundation",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/edunswactfoundation/v4/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki9tovGLeC-sfguJ.ttf",
        "500": "https://fonts.gstatic.com/s/edunswactfoundation/v4/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki9fovGLeC-sfguJ.ttf",
        "600": "https://fonts.gstatic.com/s/edunswactfoundation/v4/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki-zpfGLeC-sfguJ.ttf",
        "700": "https://fonts.gstatic.com/s/edunswactfoundation/v4/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki-KpfGLeC-sfguJ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/edunswactfoundation/v4/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki9tosGKcis.ttf"
    },
    {
      "family": "Edu NSW ACT Hand Pre",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/edunswacthandpre/v2/kmKXZrI-ExGJWUmupHwGgw6Qw4svl-MsLiw7ATFEXwCkLE0ywWBqtsjedKEHuQ.ttf",
        "500": "https://fonts.gstatic.com/s/edunswacthandpre/v2/kmKXZrI-ExGJWUmupHwGgw6Qw4svl-MsLiw7ATFEXwCkLE0y82BqtsjedKEHuQ.ttf",
        "600": "https://fonts.gstatic.com/s/edunswacthandpre/v2/kmKXZrI-ExGJWUmupHwGgw6Qw4svl-MsLiw7ATFEXwCkLE0yH2dqtsjedKEHuQ.ttf",
        "700": "https://fonts.gstatic.com/s/edunswacthandpre/v2/kmKXZrI-ExGJWUmupHwGgw6Qw4svl-MsLiw7ATFEXwCkLE0yJmdqtsjedKEHuQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/edunswacthandpre/v2/kmKXZrI-ExGJWUmupHwGgw6Qw4svl-MsLiw7ATFEXwCkLE0ywWBat8La.ttf"
    },
    {
      "family": "Edu QLD Beginner",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v4",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduqldbeginner/v4/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE4E3oebi6vyVWCN.ttf",
        "500": "https://fonts.gstatic.com/s/eduqldbeginner/v4/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE423oebi6vyVWCN.ttf",
        "600": "https://fonts.gstatic.com/s/eduqldbeginner/v4/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE7a2Yebi6vyVWCN.ttf",
        "700": "https://fonts.gstatic.com/s/eduqldbeginner/v4/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE7j2Yebi6vyVWCN.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduqldbeginner/v4/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE4E3reaga8.ttf"
    },
    {
      "family": "Edu QLD Hand",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduqldhand/v2/d6lakaOkTtjy2QhuzWtup1rW3NCQVvjKPjPjngAUeRt5gGCzkrs.ttf",
        "500": "https://fonts.gstatic.com/s/eduqldhand/v2/d6lakaOkTtjy2QhuzWtup1rW3NCQVvjKPjPjnjIUeRt5gGCzkrs.ttf",
        "600": "https://fonts.gstatic.com/s/eduqldhand/v2/d6lakaOkTtjy2QhuzWtup1rW3NCQVvjKPjPjnt4TeRt5gGCzkrs.ttf",
        "700": "https://fonts.gstatic.com/s/eduqldhand/v2/d6lakaOkTtjy2QhuzWtup1rW3NCQVvjKPjPjnucTeRt5gGCzkrs.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduqldhand/v2/d6lakaOkTtjy2QhuzWtup1rW3NCQVvjKPjPjngAUSRpzhA.ttf"
    },
    {
      "family": "Edu SA Beginner",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/edusabeginner/v4/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9989fo1yBydUEDs.ttf",
        "500": "https://fonts.gstatic.com/s/edusabeginner/v4/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9-09fo1yBydUEDs.ttf",
        "600": "https://fonts.gstatic.com/s/edusabeginner/v4/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9wE6fo1yBydUEDs.ttf",
        "700": "https://fonts.gstatic.com/s/edusabeginner/v4/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9zg6fo1yBydUEDs.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/edusabeginner/v4/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9989Tox4Aw.ttf"
    },
    {
      "family": "Edu SA Hand",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/edusahand/v2/memtYaOmw37C-ogAJfd7NocVXTy8nx2cmqvXlWumvkSE55OZgw.ttf",
        "500": "https://fonts.gstatic.com/s/edusahand/v2/memtYaOmw37C-ogAJfd7NocVXTy8nx2cmqvXp2umvkSE55OZgw.ttf",
        "600": "https://fonts.gstatic.com/s/edusahand/v2/memtYaOmw37C-ogAJfd7NocVXTy8nx2cmqvXS2ymvkSE55OZgw.ttf",
        "700": "https://fonts.gstatic.com/s/edusahand/v2/memtYaOmw37C-ogAJfd7NocVXTy8nx2cmqvXcmymvkSE55OZgw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/edusahand/v2/memtYaOmw37C-ogAJfd7NocVXTy8nx2cmqvXlWuWv06A.ttf"
    },
    {
      "family": "Edu TAS Beginner",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/edutasbeginner/v4/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_HwemkrBWRhvk02.ttf",
        "500": "https://fonts.gstatic.com/s/edutasbeginner/v4/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_HCemkrBWRhvk02.ttf",
        "600": "https://fonts.gstatic.com/s/edutasbeginner/v4/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_EufWkrBWRhvk02.ttf",
        "700": "https://fonts.gstatic.com/s/edutasbeginner/v4/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_EXfWkrBWRhvk02.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/edutasbeginner/v4/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_HwelkqD2A.ttf"
    },
    {
      "family": "Edu VIC WA NT Beginner",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v5",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduvicwantbeginner/v5/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-OXlPmFXwnpkeGR.ttf",
        "500": "https://fonts.gstatic.com/s/eduvicwantbeginner/v5/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-OllPmFXwnpkeGR.ttf",
        "600": "https://fonts.gstatic.com/s/eduvicwantbeginner/v5/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-NJk_mFXwnpkeGR.ttf",
        "700": "https://fonts.gstatic.com/s/eduvicwantbeginner/v5/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-Nwk_mFXwnpkeGR.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduvicwantbeginner/v5/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-OXlMmEVQ0.ttf"
    },
    {
      "family": "Edu VIC WA NT Hand",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduvicwanthand/v2/UcCO3EsnIXnOaZKmY1Ry0wZjP9YVRBcw2boKoduKmMEVuLyfMZhrib2Bg-4.ttf",
        "500": "https://fonts.gstatic.com/s/eduvicwanthand/v2/UcCO3EsnIXnOaZKmY1Ry0wZjP9YVRBcw2boKoduKmMEVuI6fMZhrib2Bg-4.ttf",
        "600": "https://fonts.gstatic.com/s/eduvicwanthand/v2/UcCO3EsnIXnOaZKmY1Ry0wZjP9YVRBcw2boKoduKmMEVuGKYMZhrib2Bg-4.ttf",
        "700": "https://fonts.gstatic.com/s/eduvicwanthand/v2/UcCO3EsnIXnOaZKmY1Ry0wZjP9YVRBcw2boKoduKmMEVuFuYMZhrib2Bg-4.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduvicwanthand/v2/UcCO3EsnIXnOaZKmY1Ry0wZjP9YVRBcw2boKoduKmMEVuLyfAZlhjQ.ttf"
    },
    {
      "family": "Edu VIC WA NT Hand Pre",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/eduvicwanthandpre/v2/neInzDmioZxjkInM_tLHFudmcN2Uxxc-9Vnv-4YmimMq127-YLTo4dgUBS1Nzqn8.ttf",
        "500": "https://fonts.gstatic.com/s/eduvicwanthandpre/v2/neInzDmioZxjkInM_tLHFudmcN2Uxxc-9Vnv-4YmimMq127-YLTa4dgUBS1Nzqn8.ttf",
        "600": "https://fonts.gstatic.com/s/eduvicwanthandpre/v2/neInzDmioZxjkInM_tLHFudmcN2Uxxc-9Vnv-4YmimMq127-YLQ25tgUBS1Nzqn8.ttf",
        "700": "https://fonts.gstatic.com/s/eduvicwanthandpre/v2/neInzDmioZxjkInM_tLHFudmcN2Uxxc-9Vnv-4YmimMq127-YLQP5tgUBS1Nzqn8.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/eduvicwanthandpre/v2/neInzDmioZxjkInM_tLHFudmcN2Uxxc-9Vnv-4YmimMq127-YLTo4egVDyk.ttf"
    },
    {
      "family": "El Messiri",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/elmessiri/v24/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuXwe65ghj3OoapG.ttf",
        "500": "https://fonts.gstatic.com/s/elmessiri/v24/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuXCe65ghj3OoapG.ttf",
        "600": "https://fonts.gstatic.com/s/elmessiri/v24/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuUufK5ghj3OoapG.ttf",
        "700": "https://fonts.gstatic.com/s/elmessiri/v24/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuUXfK5ghj3OoapG.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/elmessiri/v24/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuXwe55hjDk.ttf"
    },
    {
      "family": "Electrolize",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/electrolize/v19/cIf5Ma1dtE0zSiGSiED7AUEGso5tQafB.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/electrolize/v19/cIf5Ma1dtE0zSiGSiED7AXEHuIo.ttf"
    },
    {
      "family": "Elsie",
      "variants": [
        "regular",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/elsie/v25/BCanqZABrez54yYu9slAeLgX.ttf",
        "900": "https://fonts.gstatic.com/s/elsie/v25/BCaqqZABrez54x6q2-1IU6QeXSBk.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/elsie/v25/BCanqZABrez54xYv_M0.ttf"
    },
    {
      "family": "Elsie Swash Caps",
      "variants": [
        "regular",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/elsieswashcaps/v24/845DNN8xGZyVX5MVo_upKf7KnjK0ferVKGWsUo8.ttf",
        "900": "https://fonts.gstatic.com/s/elsieswashcaps/v24/845ENN8xGZyVX5MVo_upKf7KnjK0RW74DG2HToawrdU.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/elsieswashcaps/v24/845DNN8xGZyVX5MVo_upKf7KnjK0TevfLA.ttf"
    },
    {
      "family": "Emblema One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/emblemaone/v21/nKKT-GQ0F5dSY8vzG0rOEIRBHl57G_f_.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/emblemaone/v21/nKKT-GQ0F5dSY8vzG0rOELRAFFo.ttf"
    },
    {
      "family": "Emilys Candy",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/emilyscandy/v20/2EbgL-1mD1Rnb0OGKudbk0y5r9xrX84JjA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/emilyscandy/v20/2EbgL-1mD1Rnb0OGKudbk0yJrtZv.ttf"
    },
    {
      "family": "Encode Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGGHiZtWP7FJCt2c.ttf",
        "200": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGOHjZtWP7FJCt2c.ttf",
        "300": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGD_jZtWP7FJCt2c.ttf",
        "regular": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGGHjZtWP7FJCt2c.ttf",
        "500": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGFPjZtWP7FJCt2c.ttf",
        "600": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGL_kZtWP7FJCt2c.ttf",
        "700": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGIbkZtWP7FJCt2c.ttf",
        "800": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGOHkZtWP7FJCt2c.ttf",
        "900": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGMjkZtWP7FJCt2c.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/encodesans/v22/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGGHjVtSF6A.ttf"
    },
    {
      "family": "Encode Sans Condensed",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_76_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-5a-JLQoFI2KR.ttf",
        "200": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-SY6pByQJKnuIFA.ttf",
        "300": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-LY2pByQJKnuIFA.ttf",
        "regular": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_16_LD37rqfuwxyIuaZhE6cRXOLtm2gfTGgaWNDw8VIw.ttf",
        "500": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-dYypByQJKnuIFA.ttf",
        "600": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-WYupByQJKnuIFA.ttf",
        "700": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-PYqpByQJKnuIFA.ttf",
        "800": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-IYmpByQJKnuIFA.ttf",
        "900": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-BYipByQJKnuIFA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/encodesanscondensed/v10/j8_16_LD37rqfuwxyIuaZhE6cRXOLtm2gfT2gK-J.ttf"
    },
    {
      "family": "Encode Sans Expanded",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mx1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpJGKQNicoAbJlw.ttf",
        "200": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpLqCCNIXIwSP0XD.ttf",
        "300": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKOCyNIXIwSP0XD.ttf",
        "regular": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4m_1mF4GcnstG_Jh1QH6ac4hNLeNyeYUqoiIwdAd5Ab.ttf",
        "500": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpLWCiNIXIwSP0XD.ttf",
        "600": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpL6DSNIXIwSP0XD.ttf",
        "700": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKeDCNIXIwSP0XD.ttf",
        "800": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKCDyNIXIwSP0XD.ttf",
        "900": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKmDiNIXIwSP0XD.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/encodesansexpanded/v11/c4m_1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpojKQM.ttf"
    },
    {
      "family": "Encode Sans SC",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HHhn8c9NOEEClIc.ttf",
        "200": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HPhm8c9NOEEClIc.ttf",
        "300": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HCZm8c9NOEEClIc.ttf",
        "regular": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HHhm8c9NOEEClIc.ttf",
        "500": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HEpm8c9NOEEClIc.ttf",
        "600": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HKZh8c9NOEEClIc.ttf",
        "700": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HJ9h8c9NOEEClIc.ttf",
        "800": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HPhh8c9NOEEClIc.ttf",
        "900": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HNFh8c9NOEEClIc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/encodesanssc/v13/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HHhmwc5HPA.ttf"
    },
    {
      "family": "Encode Sans Semi Condensed",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT6oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1T19MFtQ9jpVUA.ttf",
        "200": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1RZ1eFHbdTgTFmr.ttf",
        "300": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Q91uFHbdTgTFmr.ttf",
        "regular": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT4oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG2yR_sVPRsjp.ttf",
        "500": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Rl1-FHbdTgTFmr.ttf",
        "600": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1RJ0OFHbdTgTFmr.ttf",
        "700": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Qt0eFHbdTgTFmr.ttf",
        "800": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Qx0uFHbdTgTFmr.ttf",
        "900": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1QV0-FHbdTgTFmr.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT4oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1yQ9ME.ttf"
    },
    {
      "family": "Encode Sans Semi Expanded",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8xOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM-41KwrlKXeOEA.ttf",
        "200": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM0IUCyDLJX6XCWU.ttf",
        "300": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMyYXCyDLJX6XCWU.ttf",
        "regular": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke83OhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TC4o_LyjgOXc.ttf",
        "500": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM34WCyDLJX6XCWU.ttf",
        "600": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM1IRCyDLJX6XCWU.ttf",
        "700": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMzYQCyDLJX6XCWU.ttf",
        "800": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMyoTCyDLJX6XCWU.ttf",
        "900": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMw4SCyDLJX6XCWU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/encodesanssemiexpanded/v19/ke83OhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TO4s1Kw.ttf"
    },
    {
      "family": "Engagement",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/engagement/v28/x3dlckLDZbqa7RUs9MFVXNossybsHQI.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/engagement/v28/x3dlckLDZbqa7RUs9MFVbNsmtw.ttf"
    },
    {
      "family": "Englebert",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/englebert/v23/xn7iYH8w2XGrC8AR4HSxT_fYdN-WZw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/englebert/v23/xn7iYH8w2XGrC8AR4HSBTv3c.ttf"
    },
    {
      "family": "Enriqueta",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/enriqueta/v18/goksH6L7AUFrRvV44HVTS0CjkP1Yog.ttf",
        "500": "https://fonts.gstatic.com/s/enriqueta/v18/gokpH6L7AUFrRvV44HVrv2mHmNZEq6TTFw.ttf",
        "600": "https://fonts.gstatic.com/s/enriqueta/v18/gokpH6L7AUFrRvV44HVrk26HmNZEq6TTFw.ttf",
        "700": "https://fonts.gstatic.com/s/enriqueta/v18/gokpH6L7AUFrRvV44HVr92-HmNZEq6TTFw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/enriqueta/v18/goksH6L7AUFrRvV44HVjSkqn.ttf"
    },
    {
      "family": "Ephesis",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ephesis/v10/uU9PCBUS8IerL2VG7xPb3vyHmlI.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ephesis/v10/uU9PCBUS8IerL2VG3xLR2g.ttf"
    },
    {
      "family": "Epilogue",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXMDLiDJXVigHPVA.ttf",
        "200": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXsDPiDJXVigHPVA.ttf",
        "300": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXbjPiDJXVigHPVA.ttf",
        "regular": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXMDPiDJXVigHPVA.ttf",
        "500": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXAjPiDJXVigHPVA.ttf",
        "600": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OX7jTiDJXVigHPVA.ttf",
        "700": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OX1zTiDJXVigHPVA.ttf",
        "800": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXsDTiDJXVigHPVA.ttf",
        "900": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXmTTiDJXVigHPVA.ttf",
        "100italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HAKTp_RqATfVHNU.ttf",
        "200italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HCKT5_RqATfVHNU.ttf",
        "300italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HBUT5_RqATfVHNU.ttf",
        "italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HAKT5_RqATfVHNU.ttf",
        "500italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HA4T5_RqATfVHNU.ttf",
        "600italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HDUSJ_RqATfVHNU.ttf",
        "700italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HDtSJ_RqATfVHNU.ttf",
        "800italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HCKSJ_RqATfVHNU.ttf",
        "900italic": "https://fonts.gstatic.com/s/epilogue/v19/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HCjSJ_RqATfVHNU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/epilogue/v19/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXMDPSDZ_R.ttf"
    },
    {
      "family": "Erica One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ericaone/v28/WBLnrEXccV9VGrOKmGD1W0_MJMGxiQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ericaone/v28/WBLnrEXccV9VGrOKmGDFWkXI.ttf"
    },
    {
      "family": "Esteban",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/esteban/v15/r05bGLZE-bdGdN-GdOuD5jokU8E.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/esteban/v15/r05bGLZE-bdGdN-GROqJ4g.ttf"
    },
    {
      "family": "Estonia",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/estonia/v12/7Au_p_4ijSecA1yHCCL8zkwMIFg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/estonia/v12/7Au_p_4ijSecA1yHOCP2yg.ttf"
    },
    {
      "family": "Euphoria Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/euphoriascript/v21/mFTpWb0X2bLb_cx6To2B8GpKoD5ak_ZT1D8x7Q.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/euphoriascript/v21/mFTpWb0X2bLb_cx6To2B8GpKoD5qkvxX.ttf"
    },
    {
      "family": "Ewert",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ewert/v26/va9I4kzO2tFODYBvS-J3kbDP.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ewert/v26/va9I4kzO2tFODbBuQeY.ttf"
    },
    {
      "family": "Exile",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/exile/v1/pxiKyp0xqNtbjBsYHpT2dkNE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/exile/v1/pxiKyp0xqNtbjCsZFJA.ttf"
    },
    {
      "family": "Exo",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4lM2CwNsOl4p5Is.ttf",
        "200": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4tM3CwNsOl4p5Is.ttf",
        "300": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4g03CwNsOl4p5Is.ttf",
        "regular": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4lM3CwNsOl4p5Is.ttf",
        "500": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4mE3CwNsOl4p5Is.ttf",
        "600": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4o0wCwNsOl4p5Is.ttf",
        "700": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4rQwCwNsOl4p5Is.ttf",
        "800": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4tMwCwNsOl4p5Is.ttf",
        "900": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4vowCwNsOl4p5Is.ttf",
        "100italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t040FmPnws9Iu-uA.ttf",
        "200italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t0Y0BmPnws9Iu-uA.ttf",
        "300italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t0vUBmPnws9Iu-uA.ttf",
        "italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t040BmPnws9Iu-uA.ttf",
        "500italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t00UBmPnws9Iu-uA.ttf",
        "600italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t0PUdmPnws9Iu-uA.ttf",
        "700italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t0BEdmPnws9Iu-uA.ttf",
        "800italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t0Y0dmPnws9Iu-uA.ttf",
        "900italic": "https://fonts.gstatic.com/s/exo/v24/4UafrEtFpBISdmSt-MY2ehbO95t0SkdmPnws9Iu-uA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/exo/v24/4UaZrEtFpBI4f1ZSIK9d4LjJ4lM3OwJmPg.ttf"
    },
    {
      "family": "Exo 2",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jvvOcPtq-rpvLpQ.ttf",
        "200": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jPvKcPtq-rpvLpQ.ttf",
        "300": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8j4PKcPtq-rpvLpQ.ttf",
        "regular": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jvvKcPtq-rpvLpQ.ttf",
        "500": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jjPKcPtq-rpvLpQ.ttf",
        "600": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jYPWcPtq-rpvLpQ.ttf",
        "700": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jWfWcPtq-rpvLpQ.ttf",
        "800": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jPvWcPtq-rpvLpQ.ttf",
        "900": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jF_WcPtq-rpvLpQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drF0fNC6jJ7bpQBL.ttf",
        "200italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drH0fdC6jJ7bpQBL.ttf",
        "300italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drEqfdC6jJ7bpQBL.ttf",
        "italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drF0fdC6jJ7bpQBL.ttf",
        "500italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drFGfdC6jJ7bpQBL.ttf",
        "600italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drGqetC6jJ7bpQBL.ttf",
        "700italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drGTetC6jJ7bpQBL.ttf",
        "800italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drH0etC6jJ7bpQBL.ttf",
        "900italic": "https://fonts.gstatic.com/s/exo2/v25/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drHdetC6jJ7bpQBL.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/exo2/v25/7cH1v4okm5zmbvwkAx_sfcEuiD8jvvKsP9C6.ttf"
    },
    {
      "family": "Expletus Sans",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/expletussans/v30/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaSY2s1oFQTcXfMm.ttf",
        "500": "https://fonts.gstatic.com/s/expletussans/v30/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaSq2s1oFQTcXfMm.ttf",
        "600": "https://fonts.gstatic.com/s/expletussans/v30/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaRG3c1oFQTcXfMm.ttf",
        "700": "https://fonts.gstatic.com/s/expletussans/v30/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaR_3c1oFQTcXfMm.ttf",
        "italic": "https://fonts.gstatic.com/s/expletussans/v30/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmSUrHwD-WOMmKKY.ttf",
        "500italic": "https://fonts.gstatic.com/s/expletussans/v30/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmRcrHwD-WOMmKKY.ttf",
        "600italic": "https://fonts.gstatic.com/s/expletussans/v30/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmfssHwD-WOMmKKY.ttf",
        "700italic": "https://fonts.gstatic.com/s/expletussans/v30/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmcIsHwD-WOMmKKY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/expletussans/v30/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaSY2v1pHwA.ttf"
    },
    {
      "family": "Explora",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cherokee",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/explora/v10/tsstApxFfjUH4wrvc1qPonC3vqc.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/explora/v10/tsstApxFfjUH4wrvQ1uFpg.ttf"
    },
    {
      "family": "Faculty Glyphic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/facultyglyphic/v4/RrQIbot2-iBvI2mYSyKIrcgoBuQIG-eFNVmULg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/facultyglyphic/v4/RrQIbot2-iBvI2mYSyKIrcgoBuQ4Gu2B.ttf"
    },
    {
      "family": "Fahkwang",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/fahkwang/v17/Noa26Uj3zpmBOgbNpOJHmZlRFipxkwjx.ttf",
        "200italic": "https://fonts.gstatic.com/s/fahkwang/v17/Noa06Uj3zpmBOgbNpOqNgHFQHC5Tlhjxdw4.ttf",
        "300": "https://fonts.gstatic.com/s/fahkwang/v17/Noa26Uj3zpmBOgbNpOIjmplRFipxkwjx.ttf",
        "300italic": "https://fonts.gstatic.com/s/fahkwang/v17/Noa06Uj3zpmBOgbNpOqNgBVTHC5Tlhjxdw4.ttf",
        "regular": "https://fonts.gstatic.com/s/fahkwang/v17/Noax6Uj3zpmBOgbNpNqPsr1ZPTZ4.ttf",
        "italic": "https://fonts.gstatic.com/s/fahkwang/v17/Noa36Uj3zpmBOgbNpOqNuLl7OCZ4ihE.ttf",
        "500": "https://fonts.gstatic.com/s/fahkwang/v17/Noa26Uj3zpmBOgbNpOJ7m5lRFipxkwjx.ttf",
        "500italic": "https://fonts.gstatic.com/s/fahkwang/v17/Noa06Uj3zpmBOgbNpOqNgE1SHC5Tlhjxdw4.ttf",
        "600": "https://fonts.gstatic.com/s/fahkwang/v17/Noa26Uj3zpmBOgbNpOJXnJlRFipxkwjx.ttf",
        "600italic": "https://fonts.gstatic.com/s/fahkwang/v17/Noa06Uj3zpmBOgbNpOqNgGFVHC5Tlhjxdw4.ttf",
        "700": "https://fonts.gstatic.com/s/fahkwang/v17/Noa26Uj3zpmBOgbNpOIznZlRFipxkwjx.ttf",
        "700italic": "https://fonts.gstatic.com/s/fahkwang/v17/Noa06Uj3zpmBOgbNpOqNgAVUHC5Tlhjxdw4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fahkwang/v17/Noax6Uj3zpmBOgbNpOqOuLk.ttf"
    },
    {
      "family": "Familjen Grotesk",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMGJaSztc1jcEYq2.ttf",
        "500": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMG7aSztc1jcEYq2.ttf",
        "600": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMFXbiztc1jcEYq2.ttf",
        "700": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMFubiztc1jcEYq2.ttf",
        "italic": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKsSueVz-FJq2Rv4.ttf",
        "500italic": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKvaueVz-FJq2Rv4.ttf",
        "600italic": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKhqpeVz-FJq2Rv4.ttf",
        "700italic": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKiOpeVz-FJq2Rv4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/familjengrotesk/v10/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMGJaRzseVw.ttf"
    },
    {
      "family": "Fanwood Text",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fanwoodtext/v16/3XFtErwl05Ad_vSCF6Fq7xXGRdbY1P1Sbg.ttf",
        "italic": "https://fonts.gstatic.com/s/fanwoodtext/v16/3XFzErwl05Ad_vSCF6Fq7xX2R9zc9vhCblye.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fanwoodtext/v16/3XFtErwl05Ad_vSCF6Fq7xX2RNzc.ttf"
    },
    {
      "family": "Farro",
      "variants": [
        "300",
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/farro/v14/i7dJIFl3byGNHa3hNJ6-WkJUQUq7.ttf",
        "regular": "https://fonts.gstatic.com/s/farro/v14/i7dEIFl3byGNHZVNHLq2cV5d.ttf",
        "500": "https://fonts.gstatic.com/s/farro/v14/i7dJIFl3byGNHa25NZ6-WkJUQUq7.ttf",
        "700": "https://fonts.gstatic.com/s/farro/v14/i7dJIFl3byGNHa3xM56-WkJUQUq7.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/farro/v14/i7dEIFl3byGNHaVMFr4.ttf"
    },
    {
      "family": "Farsan",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/farsan/v23/VEMwRoJ0vY_zsyz62q-pxDX9rQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/farsan/v23/VEMwRoJ0vY_zsyzK26Wt.ttf"
    },
    {
      "family": "Fascinate",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fascinate/v22/z7NWdRrufC8XJK0IIEli1LbQRPyNrw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fascinate/v22/z7NWdRrufC8XJK0IIElS1bzU.ttf"
    },
    {
      "family": "Fascinate Inline",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fascinateinline/v23/jVyR7mzzB3zc-jp6QCAu60poNqIy1g3CfRXxWZQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fascinateinline/v23/jVyR7mzzB3zc-jp6QCAu60poNqIy5gzIeQ.ttf"
    },
    {
      "family": "Faster One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fasterone/v19/H4ciBXCHmdfClFb-vWhfyLuShq63czE.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fasterone/v19/H4ciBXCHmdfClFb-vWhf-LqYgg.ttf"
    },
    {
      "family": "Fasthand",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fasthand/v32/0yb9GDohyKTYn_ZEESkuYkw2rQg1.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fasthand/v32/0yb9GDohyKTYn_ZEERkvaEg.ttf"
    },
    {
      "family": "Fauna One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/faunaone/v15/wlpzgwTPBVpjpCuwkuEx2UxLYClOCg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/faunaone/v15/wlpzgwTPBVpjpCuwkuEB2EZP.ttf"
    },
    {
      "family": "Faustina",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHls3IEvGVWWe8tbEg.ttf",
        "regular": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsgoEvGVWWe8tbEg.ttf",
        "500": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlssIEvGVWWe8tbEg.ttf",
        "600": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsXIYvGVWWe8tbEg.ttf",
        "700": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsZYYvGVWWe8tbEg.ttf",
        "800": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsAoYvGVWWe8tbEg.ttf",
        "300italic": "https://fonts.gstatic.com/s/faustina/v22/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsKZWl-SWc5LEnoF.ttf",
        "italic": "https://fonts.gstatic.com/s/faustina/v22/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsLHWl-SWc5LEnoF.ttf",
        "500italic": "https://fonts.gstatic.com/s/faustina/v22/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsL1Wl-SWc5LEnoF.ttf",
        "600italic": "https://fonts.gstatic.com/s/faustina/v22/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsIZXV-SWc5LEnoF.ttf",
        "700italic": "https://fonts.gstatic.com/s/faustina/v22/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsIgXV-SWc5LEnoF.ttf",
        "800italic": "https://fonts.gstatic.com/s/faustina/v22/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsJHXV-SWc5LEnoF.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/faustina/v22/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsgoEfGF-S.ttf"
    },
    {
      "family": "Federant",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/federant/v30/2sDdZGNfip_eirT0_U0jRUG0AqUc.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/federant/v30/2sDdZGNfip_eirT0_X0iT0U.ttf"
    },
    {
      "family": "Federo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/federo/v19/iJWFBX-cbD_ETsbmjVOe2WTG7Q.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/federo/v19/iJWFBX-cbD_ETsbWjFma.ttf"
    },
    {
      "family": "Felipa",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/felipa/v26/FwZa7-owz1Eu4F_wSNSEwM2zpA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/felipa/v26/FwZa7-owz1Eu4F_ASd6A.ttf"
    },
    {
      "family": "Fenix",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fenix/v20/XoHo2YL_S7-g5ostKzAFvs8o.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fenix/v20/XoHo2YL_S7-g5rssITQ.ttf"
    },
    {
      "family": "Festive",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/festive/v10/cY9Ffj6KX1xcoDWhFtfgy9HTkak.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/festive/v10/cY9Ffj6KX1xcoDWhJtbqzw.ttf"
    },
    {
      "family": "Figtree",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v8",
      "lastModified": "2025-05-13",
      "files": {
        "300": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_chQF5ewkEU4HTy.ttf",
        "regular": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_d_QF5ewkEU4HTy.ttf",
        "500": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_dNQF5ewkEU4HTy.ttf",
        "600": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_ehR15ewkEU4HTy.ttf",
        "700": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_eYR15ewkEU4HTy.ttf",
        "800": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_f_R15ewkEU4HTy.ttf",
        "900": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_fWR15ewkEU4HTy.ttf",
        "300italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A-gdyEU25WTybO8.ttf",
        "italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A7YdyEU25WTybO8.ttf",
        "500italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A4QdyEU25WTybO8.ttf",
        "600italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A2gayEU25WTybO8.ttf",
        "700italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A1EayEU25WTybO8.ttf",
        "800italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3AzYayEU25WTybO8.ttf",
        "900italic": "https://fonts.gstatic.com/s/figtree/v8/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3Ax8ayEU25WTybO8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/figtree/v8/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_d_QG5fyEU.ttf"
    },
    {
      "family": "Finger Paint",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fingerpaint/v20/0QInMXVJ-o-oRn_7dron8YWO85bS8ANesw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fingerpaint/v20/0QInMXVJ-o-oRn_7dron8YW-8pzW.ttf"
    },
    {
      "family": "Finlandica",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v9",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/finlandica/v9/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19A7rEjx9i5ss3a3.ttf",
        "500": "https://fonts.gstatic.com/s/finlandica/v9/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19AJrEjx9i5ss3a3.ttf",
        "600": "https://fonts.gstatic.com/s/finlandica/v9/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19Dlq0jx9i5ss3a3.ttf",
        "700": "https://fonts.gstatic.com/s/finlandica/v9/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19Dcq0jx9i5ss3a3.ttf",
        "italic": "https://fonts.gstatic.com/s/finlandica/v9/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz76Cy_CpOtma3uNQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/finlandica/v9/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz75Ky_CpOtma3uNQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/finlandica/v9/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz7361_CpOtma3uNQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/finlandica/v9/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz70e1_CpOtma3uNQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/finlandica/v9/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19A7rHjw_Co.ttf"
    },
    {
      "family": "Fira Code",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "symbols2"
      ],
      "version": "v26",
      "lastModified": "2025-04-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/firacode/v26/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_GNsFVfxN87gsj0.ttf",
        "regular": "https://fonts.gstatic.com/s/firacode/v26/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_D1sFVfxN87gsj0.ttf",
        "500": "https://fonts.gstatic.com/s/firacode/v26/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_A9sFVfxN87gsj0.ttf",
        "600": "https://fonts.gstatic.com/s/firacode/v26/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_ONrFVfxN87gsj0.ttf",
        "700": "https://fonts.gstatic.com/s/firacode/v26/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_NprFVfxN87gsj0.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/firacode/v26/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_D1sJVb7Mw.ttf"
    },
    {
      "family": "Fira Mono",
      "variants": [
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "symbols2"
      ],
      "version": "v15",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/firamono/v15/N0bX2SlFPv1weGeLZDtQIfTTkdbJYA.ttf",
        "500": "https://fonts.gstatic.com/s/firamono/v15/N0bS2SlFPv1weGeLZDto1d33mf3VaZBRBQ.ttf",
        "700": "https://fonts.gstatic.com/s/firamono/v15/N0bS2SlFPv1weGeLZDtondv3mf3VaZBRBQ.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/firamono/v15/N0bX2SlFPv1weGeLZDtgIP7X.ttf"
    },
    {
      "family": "Fira Sans",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/firasans/v17/va9C4kDNxMZdWfMOD5Vn9IjOazP3dUTP.ttf",
        "100italic": "https://fonts.gstatic.com/s/firasans/v17/va9A4kDNxMZdWfMOD5VvkrCqYTfVcFTPj0s.ttf",
        "200": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnWKnuQR37fF3Wlg.ttf",
        "200italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrAGQBf_XljGllLX.ttf",
        "300": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnPKruQR37fF3Wlg.ttf",
        "300italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrBiQxf_XljGllLX.ttf",
        "regular": "https://fonts.gstatic.com/s/firasans/v17/va9E4kDNxMZdWfMOD5VfkILKSTbndQ.ttf",
        "italic": "https://fonts.gstatic.com/s/firasans/v17/va9C4kDNxMZdWfMOD5VvkojOazP3dUTP.ttf",
        "500": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnZKvuQR37fF3Wlg.ttf",
        "500italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrA6Qhf_XljGllLX.ttf",
        "600": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnSKzuQR37fF3Wlg.ttf",
        "600italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrAWRRf_XljGllLX.ttf",
        "700": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnLK3uQR37fF3Wlg.ttf",
        "700italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrByRBf_XljGllLX.ttf",
        "800": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnMK7uQR37fF3Wlg.ttf",
        "800italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrBuRxf_XljGllLX.ttf",
        "900": "https://fonts.gstatic.com/s/firasans/v17/va9B4kDNxMZdWfMOD5VnFK_uQR37fF3Wlg.ttf",
        "900italic": "https://fonts.gstatic.com/s/firasans/v17/va9f4kDNxMZdWfMOD5VvkrBKRhf_XljGllLX.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/firasans/v17/va9E4kDNxMZdWfMOD5VvkYjO.ttf"
    },
    {
      "family": "Fira Sans Condensed",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOjEADFm8hSaQTFG18FErVhsC9x-tarWZXtqOlQfx9CjA.ttf",
        "100italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOtEADFm8hSaQTFG18FErVhsC9x-tarUfPVzONUXRpSjJcu.ttf",
        "200": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWTnMiMN-cxZblY4.ttf",
        "200italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVYMJ0dzRehY43EA.ttf",
        "300": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWV3PiMN-cxZblY4.ttf",
        "300italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVBMF0dzRehY43EA.ttf",
        "regular": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOhEADFm8hSaQTFG18FErVhsC9x-tarYfHnrMtVbx8.ttf",
        "italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOjEADFm8hSaQTFG18FErVhsC9x-tarUfPtqOlQfx9CjA.ttf",
        "500": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWQXOiMN-cxZblY4.ttf",
        "500italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVXMB0dzRehY43EA.ttf",
        "600": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWSnJiMN-cxZblY4.ttf",
        "600italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVcMd0dzRehY43EA.ttf",
        "700": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWU3IiMN-cxZblY4.ttf",
        "700italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVFMZ0dzRehY43EA.ttf",
        "800": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWVHLiMN-cxZblY4.ttf",
        "800italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVCMV0dzRehY43EA.ttf",
        "900": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWXXKiMN-cxZblY4.ttf",
        "900italic": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVLMR0dzRehY43EA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/firasanscondensed/v10/wEOhEADFm8hSaQTFG18FErVhsC9x-tarUfDtqA.ttf"
    },
    {
      "family": "Fira Sans Extra Condensed",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPMcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3Zyuv1WarE9ncg.ttf",
        "100italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPOcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqW21-ejkp3cn22.ttf",
        "200": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3TCPn3-0oEZ-a2Q.ttf",
        "200italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWd36-pGR7e2SvJQ.ttf",
        "300": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3VSMn3-0oEZ-a2Q.ttf",
        "300italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWE32-pGR7e2SvJQ.ttf",
        "regular": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPKcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda5fiku3efvE8.ttf",
        "italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPMcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fquv1WarE9ncg.ttf",
        "500": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3QyNn3-0oEZ-a2Q.ttf",
        "500italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWS3y-pGR7e2SvJQ.ttf",
        "600": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3SCKn3-0oEZ-a2Q.ttf",
        "600italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWZ3u-pGR7e2SvJQ.ttf",
        "700": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3USLn3-0oEZ-a2Q.ttf",
        "700italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWA3q-pGR7e2SvJQ.ttf",
        "800": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3ViIn3-0oEZ-a2Q.ttf",
        "800italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWH3m-pGR7e2SvJQ.ttf",
        "900": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3XyJn3-0oEZ-a2Q.ttf",
        "900italic": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWO3i-pGR7e2SvJQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/firasansextracondensed/v10/NaPKcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fmuvw.ttf"
    },
    {
      "family": "Fjalla One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fjallaone/v15/Yq6R-LCAWCX3-6Ky7FAFnOZwkxgtUb8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fjallaone/v15/Yq6R-LCAWCX3-6Ky7FAFrOd6lw.ttf"
    },
    {
      "family": "Fjord One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fjordone/v21/zOL-4pbEnKBY_9S1jNKr6e5As-FeiQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fjordone/v21/zOL-4pbEnKBY_9S1jNKb6ORE.ttf"
    },
    {
      "family": "Flamenco",
      "variants": [
        "300",
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/flamenco/v18/neIPzCehqYguo67ssZ0qNIkyepH9qGsf.ttf",
        "regular": "https://fonts.gstatic.com/s/flamenco/v18/neIIzCehqYguo67ssaWGHK06UY30.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/flamenco/v18/neIIzCehqYguo67ssZWHFqk.ttf"
    },
    {
      "family": "Flavors",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/flavors/v27/FBV2dDrhxqmveJTpbkzlNqkG9UY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/flavors/v27/FBV2dDrhxqmveJTpXk3vMg.ttf"
    },
    {
      "family": "Fleur De Leah",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fleurdeleah/v10/AYCNpXX7ftYZWLhv9UmPJTMC5vat4I_Gdq0.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fleurdeleah/v10/AYCNpXX7ftYZWLhv9UmPJTMC1ven5A.ttf"
    },
    {
      "family": "Flow Block",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/flowblock/v13/wlp0gwfPCEB65UmTk-d6-WZlbCBXE_I.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/flowblock/v13/wlp0gwfPCEB65UmTk-d6yWdvaA.ttf"
    },
    {
      "family": "Flow Circular",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/flowcircular/v13/lJwB-pc4j2F-H8YKuyvfxdZ45ifpWdr2rIg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/flowcircular/v13/lJwB-pc4j2F-H8YKuyvfxdZ41ibjXQ.ttf"
    },
    {
      "family": "Flow Rounded",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/flowrounded/v13/-zki91mtwsU9qlLiGwD4oQX3oZX-Xup87g.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/flowrounded/v13/-zki91mtwsU9qlLiGwD4oQXHoJ_6.ttf"
    },
    {
      "family": "Foldit",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XpANmapUYLHkN80.ttf",
        "200": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XhAMmapUYLHkN80.ttf",
        "300": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8Xs4MmapUYLHkN80.ttf",
        "regular": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XpAMmapUYLHkN80.ttf",
        "500": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XqIMmapUYLHkN80.ttf",
        "600": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8Xk4LmapUYLHkN80.ttf",
        "700": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XncLmapUYLHkN80.ttf",
        "800": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XhALmapUYLHkN80.ttf",
        "900": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XjkLmapUYLHkN80.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/foldit/v7/aFTI7PF3Y3c9WdjNrRVE0Rk2b7j8XpAMqateZA.ttf",
      "colorCapabilities": [
        "COLRv1"
      ]
    },
    {
      "family": "Fondamento",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fondamento/v21/4UaHrEJGsxNmFTPDnkaJx63j5pN1MwI.ttf",
        "italic": "https://fonts.gstatic.com/s/fondamento/v21/4UaFrEJGsxNmFTPDnkaJ96_p4rFwIwJePw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fondamento/v21/4UaHrEJGsxNmFTPDnkaJ96zp4g.ttf"
    },
    {
      "family": "Fontdiner Swanky",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fontdinerswanky/v24/ijwOs4XgRNsiaI5-hcVb4hQgMvCD4uEfKiGvxts.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fontdinerswanky/v24/ijwOs4XgRNsiaI5-hcVb4hQgMvCD0uAVLg.ttf"
    },
    {
      "family": "Forum",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/forum/v18/6aey4Ky-Vb8Ew_IWMJMa3mnT.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/forum/v18/6aey4Ky-Vb8Ew8IXOpc.ttf"
    },
    {
      "family": "Fragment Mono",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fragmentmono/v5/4iCr6K5wfMRRjxp0DA6-2CLnN4RNh4UI_1U.ttf",
        "italic": "https://fonts.gstatic.com/s/fragmentmono/v5/4iC16K5wfMRRjxp0DA6-2CLnB4ZHg6cN71URtQ.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fragmentmono/v5/4iCr6K5wfMRRjxp0DA6-2CLnB4VHgw.ttf"
    },
    {
      "family": "Francois One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/francoisone/v21/_Xmr-H4zszafZw3A-KPSZutNxgKQu_avAg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/francoisone/v21/_Xmr-H4zszafZw3A-KPSZut9xwiU.ttf"
    },
    {
      "family": "Frank Ruhl Libre",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-04-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw6bYVqQPxR2EUR_.ttf",
        "regular": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw7FYVqQPxR2EUR_.ttf",
        "500": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw73YVqQPxR2EUR_.ttf",
        "600": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw4bZlqQPxR2EUR_.ttf",
        "700": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw4iZlqQPxR2EUR_.ttf",
        "800": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw5FZlqQPxR2EUR_.ttf",
        "900": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw5sZlqQPxR2EUR_.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/frankruhllibre/v22/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw7FYWqRNRA.ttf"
    },
    {
      "family": "Fraunces",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v37",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIctxqjDvTShUtWNg.ttf",
        "200": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcNxujDvTShUtWNg.ttf",
        "300": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIc6RujDvTShUtWNg.ttf",
        "regular": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIctxujDvTShUtWNg.ttf",
        "500": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIchRujDvTShUtWNg.ttf",
        "600": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcaRyjDvTShUtWNg.ttf",
        "700": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcUByjDvTShUtWNg.ttf",
        "800": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcNxyjDvTShUtWNg.ttf",
        "900": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcHhyjDvTShUtWNg.ttf",
        "100italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1hLTP7Wp05GNi3k.ttf",
        "200italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1jLTf7Wp05GNi3k.ttf",
        "300italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1gVTf7Wp05GNi3k.ttf",
        "italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1hLTf7Wp05GNi3k.ttf",
        "500italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1h5Tf7Wp05GNi3k.ttf",
        "600italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1iVSv7Wp05GNi3k.ttf",
        "700italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1isSv7Wp05GNi3k.ttf",
        "800italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1jLSv7Wp05GNi3k.ttf",
        "900italic": "https://fonts.gstatic.com/s/fraunces/v37/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1jiSv7Wp05GNi3k.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fraunces/v37/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIctxuTD_7W.ttf"
    },
    {
      "family": "Freckle Face",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/freckleface/v15/AMOWz4SXrmKHCvXTohxY-YI0U1K2w9lb4g.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/freckleface/v15/AMOWz4SXrmKHCvXTohxY-YIEUliy.ttf"
    },
    {
      "family": "Fredericka the Great",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/frederickathegreat/v22/9Bt33CxNwt7aOctW2xjbCstzwVKsIBVV-9Skz7Ylch2L.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/frederickathegreat/v22/9Bt33CxNwt7aOctW2xjbCstzwVKsIBVV--SlxbI.ttf"
    },
    {
      "family": "Fredoka",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/fredoka/v16/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OryLMFuOLlNldbw.ttf",
        "regular": "https://fonts.gstatic.com/s/fredoka/v16/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3O8SLMFuOLlNldbw.ttf",
        "500": "https://fonts.gstatic.com/s/fredoka/v16/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OwyLMFuOLlNldbw.ttf",
        "600": "https://fonts.gstatic.com/s/fredoka/v16/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OLyXMFuOLlNldbw.ttf",
        "700": "https://fonts.gstatic.com/s/fredoka/v16/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OFiXMFuOLlNldbw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fredoka/v16/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3O8SL8F-mP.ttf"
    },
    {
      "family": "Freehand",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v33",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/freehand/v33/cIf-Ma5eqk01VjKTgAmBTmUOmZJk.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/freehand/v33/cIf-Ma5eqk01VjKTgDmARGE.ttf"
    },
    {
      "family": "Freeman",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/freeman/v1/S6u9w4NGQiLN8nh-ew-FGC_p9dw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/freeman/v1/S6u9w4NGQiLN8nh-Sw6PHA.ttf"
    },
    {
      "family": "Fresca",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fresca/v23/6ae94K--SKgCzbM2Gr0W13DKPA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fresca/v23/6ae94K--SKgCzbMGG7cS.ttf"
    },
    {
      "family": "Frijole",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/frijole/v14/uU9PCBUR8oakM2BQ7xPb3vyHmlI.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/frijole/v14/uU9PCBUR8oakM2BQ3xLR2g.ttf"
    },
    {
      "family": "Fruktur",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v27",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fruktur/v27/SZc53FHsOru5QYsMfz3GkUrS8DI.ttf",
        "italic": "https://fonts.gstatic.com/s/fruktur/v27/SZc73FHsOru5QYsMTz_MlWjX4DJXgQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fruktur/v27/SZc53FHsOru5QYsMTzzMlQ.ttf"
    },
    {
      "family": "Fugaz One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fugazone/v20/rax_HiWKp9EAITukFslMBBJek0vA8A.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fugazone/v20/rax_HiWKp9EAITukFsl8BRha.ttf"
    },
    {
      "family": "Fuggles",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fuggles/v13/k3kQo8UEJOlD1hpOTd7iL0nAMaM.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fuggles/v13/k3kQo8UEJOlD1hpOfd_oKw.ttf"
    },
    {
      "family": "Funnel Display",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYxGPXWMVwIZDKFA.ttf",
        "regular": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYmmPXWMVwIZDKFA.ttf",
        "500": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYqGPXWMVwIZDKFA.ttf",
        "600": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYRGTXWMVwIZDKFA.ttf",
        "700": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYfWTXWMVwIZDKFA.ttf",
        "800": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYGmTXWMVwIZDKFA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/funneldisplay/v2/B50bF7FGv37QNVWgE0ga--4PbZSRJXrOHcLHLoAYmmPnWc90.ttf"
    },
    {
      "family": "Funnel Sans",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-29",
      "files": {
        "300": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAy3mEfm9NnDyL7w.ttf",
        "regular": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAlXmEfm9NnDyL7w.ttf",
        "500": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAp3mEfm9NnDyL7w.ttf",
        "600": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAS36Efm9NnDyL7w.ttf",
        "700": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAcn6Efm9NnDyL7w.ttf",
        "800": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAFX6Efm9NnDyL7w.ttf",
        "300italic": "https://fonts.gstatic.com/s/funnelsans/v2/OpNZno8Dg9bX6Bsp3Wq69Tp3ZBbKP5ZAjyZVXToyPWVJvjmb76XZ.ttf",
        "italic": "https://fonts.gstatic.com/s/funnelsans/v2/OpNZno8Dg9bX6Bsp3Wq69Tp3ZBbKP5ZAjyZVXTpsPWVJvjmb76XZ.ttf",
        "500italic": "https://fonts.gstatic.com/s/funnelsans/v2/OpNZno8Dg9bX6Bsp3Wq69Tp3ZBbKP5ZAjyZVXTpePWVJvjmb76XZ.ttf",
        "600italic": "https://fonts.gstatic.com/s/funnelsans/v2/OpNZno8Dg9bX6Bsp3Wq69Tp3ZBbKP5ZAjyZVXTqyOmVJvjmb76XZ.ttf",
        "700italic": "https://fonts.gstatic.com/s/funnelsans/v2/OpNZno8Dg9bX6Bsp3Wq69Tp3ZBbKP5ZAjyZVXTqLOmVJvjmb76XZ.ttf",
        "800italic": "https://fonts.gstatic.com/s/funnelsans/v2/OpNZno8Dg9bX6Bsp3Wq69Tp3ZBbKP5ZAjyZVXTrsOmVJvjmb76XZ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/funnelsans/v2/OpNfno8Dg9bX6Bsp3Wq69RB-VukSVv3aISFAlXm0f2VJ.ttf"
    },
    {
      "family": "Fustat",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCMQQRryztWo_3fk.ttf",
        "300": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCBoQRryztWo_3fk.ttf",
        "regular": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCEQQRryztWo_3fk.ttf",
        "500": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCHYQRryztWo_3fk.ttf",
        "600": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCJoXRryztWo_3fk.ttf",
        "700": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCKMXRryztWo_3fk.ttf",
        "800": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCMQXRryztWo_3fk.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fustat/v3/NaPEcZ_aHO9Iy5thRNqze7YGY9HGCEQQdr25sQ.ttf"
    },
    {
      "family": "Fuzzy Bubbles",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/fuzzybubbles/v8/6qLGKZMbrgv9pwtjPEVNV0F2NnP5Zxsreko.ttf",
        "700": "https://fonts.gstatic.com/s/fuzzybubbles/v8/6qLbKZMbrgv9pwtjPEVNV0F2Ds_WQxMAZkM1pn4.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/fuzzybubbles/v8/6qLGKZMbrgv9pwtjPEVNV0F2BnLzYw.ttf"
    },
    {
      "family": "GFS Didot",
      "variants": [
        "regular"
      ],
      "subsets": [
        "greek",
        "greek-ext",
        "latin",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gfsdidot/v17/Jqzh5TybZ9vZMWFssvwiF-fGFSCGAA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gfsdidot/v17/Jqzh5TybZ9vZMWFssvwSFu3C.ttf"
    },
    {
      "family": "GFS Neohellenic",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "greek",
        "greek-ext",
        "latin",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gfsneohellenic/v26/8QIRdiDOrfiq0b7R8O1Iw9WLcY5TLahP46UDUw.ttf",
        "italic": "https://fonts.gstatic.com/s/gfsneohellenic/v26/8QITdiDOrfiq0b7R8O1Iw9WLcY5jL6JLwaATU91X.ttf",
        "700": "https://fonts.gstatic.com/s/gfsneohellenic/v26/8QIUdiDOrfiq0b7R8O1Iw9WLcY5rkYdr644fWsRO9w.ttf",
        "700italic": "https://fonts.gstatic.com/s/gfsneohellenic/v26/8QIWdiDOrfiq0b7R8O1Iw9WLcY5jL5r37oQbeMFe985V.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gfsneohellenic/v26/8QIRdiDOrfiq0b7R8O1Iw9WLcY5jLKJL.ttf"
    },
    {
      "family": "Ga Maamli",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gamaamli/v3/uU9NCBsQ4c-DPW1Yo3rR2t6CilKOdQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gamaamli/v3/uU9NCBsQ4c-DPW1Yo3rh29SG.ttf"
    },
    {
      "family": "Gabarito",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj248K0FgItq6bFIg.ttf",
        "500": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj20cK0FgItq6bFIg.ttf",
        "600": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj2PcW0FgItq6bFIg.ttf",
        "700": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj2BMW0FgItq6bFIg.ttf",
        "800": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj2Y8W0FgItq6bFIg.ttf",
        "900": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj2SsW0FgItq6bFIg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gabarito/v8/QGYwz_0dZAGKJJ4t3FFkc3Q8AkNP9Pj248KEFwgp.ttf"
    },
    {
      "family": "Gabriela",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gabriela/v22/qkBWXvsO6sreR8E-b_m-zrpHmRzC.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gabriela/v22/qkBWXvsO6sreR8E-b8m_xL4.ttf"
    },
    {
      "family": "Gaegu",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/gaegu/v22/TuGSUVB6Up9NU57nifw74sdtBk0x.ttf",
        "regular": "https://fonts.gstatic.com/s/gaegu/v22/TuGfUVB6Up9NU6ZLodgzydtk.ttf",
        "700": "https://fonts.gstatic.com/s/gaegu/v22/TuGSUVB6Up9NU573jvw74sdtBk0x.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gaegu/v22/TuGfUVB6Up9NU5ZKq9w.ttf"
    },
    {
      "family": "Gafata",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gafata/v21/XRXV3I6Cn0VJKon4MuyAbsrVcA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gafata/v21/XRXV3I6Cn0VJKonIM-aE.ttf"
    },
    {
      "family": "Gajraj One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gajrajone/v6/1cX2aUDCDpXsuWVb1jIjr1GqhcitzeM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gajrajone/v6/1cX2aUDCDpXsuWVb1jIjn1CggQ.ttf"
    },
    {
      "family": "Galada",
      "variants": [
        "regular"
      ],
      "subsets": [
        "bengali",
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/galada/v20/H4cmBXyGmcjXlUX-8iw-4Lqggw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/galada/v20/H4cmBXyGmcjXlUXO8yY6.ttf"
    },
    {
      "family": "Galdeano",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/galdeano/v22/uU9MCBoQ4YOqOW1boDPx8PCOg0uX.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/galdeano/v22/uU9MCBoQ4YOqOW1boAPw-vQ.ttf"
    },
    {
      "family": "Galindo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/galindo/v25/HI_KiYMeLqVKqwyuQ5HiRp-dhpQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/galindo/v25/HI_KiYMeLqVKqwyuc5DoQg.ttf"
    },
    {
      "family": "Gamja Flower",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gamjaflower/v25/6NUR8FiKJg-Pa0rM6uN40Z4kyf9Fdty2ew.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gamjaflower/v25/6NUR8FiKJg-Pa0rM6uN40Z4UyPVB.ttf"
    },
    {
      "family": "Gantari",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0gOz3wa5GD2qnm.ttf",
        "200": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g2gOj3wa5GD2qnm.ttf",
        "300": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g1-Oj3wa5GD2qnm.ttf",
        "regular": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0gOj3wa5GD2qnm.ttf",
        "500": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0SOj3wa5GD2qnm.ttf",
        "600": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g3-PT3wa5GD2qnm.ttf",
        "700": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g3HPT3wa5GD2qnm.ttf",
        "800": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g2gPT3wa5GD2qnm.ttf",
        "900": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g2JPT3wa5GD2qnm.ttf",
        "100italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoedWyYZWh37nmpWc.ttf",
        "200italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeVWzYZWh37nmpWc.ttf",
        "300italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeYuzYZWh37nmpWc.ttf",
        "italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoedWzYZWh37nmpWc.ttf",
        "500italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeeezYZWh37nmpWc.ttf",
        "600italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeQu0YZWh37nmpWc.ttf",
        "700italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeTK0YZWh37nmpWc.ttf",
        "800italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeVW0YZWh37nmpWc.ttf",
        "900italic": "https://fonts.gstatic.com/s/gantari/v3/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeXy0YZWh37nmpWc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gantari/v3/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0gOg3xYZU.ttf"
    },
    {
      "family": "Gasoek One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gasoekone/v3/EJRTQgQ_UMUKvDgnlX80zrq_cyb-vco.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gasoekone/v3/EJRTQgQ_UMUKvDgnlX80_ru1dw.ttf"
    },
    {
      "family": "Gayathri",
      "variants": [
        "100",
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "malayalam"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/gayathri/v19/MCoWzAb429DbBilWLLhc-pvSA_gA2W8.ttf",
        "regular": "https://fonts.gstatic.com/s/gayathri/v19/MCoQzAb429DbBilWLIA48J_wBugA.ttf",
        "700": "https://fonts.gstatic.com/s/gayathri/v19/MCoXzAb429DbBilWLLiE37v4LfQJwHbn.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gayathri/v19/MCoQzAb429DbBilWLLA5-ps.ttf"
    },
    {
      "family": "Geist",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-04-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RnOI4nZPby1QNtA.ttf",
        "200": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RHOM4nZPby1QNtA.ttf",
        "300": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RwuM4nZPby1QNtA.ttf",
        "regular": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RnOM4nZPby1QNtA.ttf",
        "500": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RruM4nZPby1QNtA.ttf",
        "600": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RQuQ4nZPby1QNtA.ttf",
        "700": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_Re-Q4nZPby1QNtA.ttf",
        "800": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RHOQ4nZPby1QNtA.ttf",
        "900": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RNeQ4nZPby1QNtA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/geist/v3/gyBhhwUxId8gMGYQMKR3pzfaWI_RnOMInJnf.ttf"
    },
    {
      "family": "Geist Mono",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-04-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeE9KZ5T7ihaO_CS.ttf",
        "200": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeG9KJ5T7ihaO_CS.ttf",
        "300": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeFjKJ5T7ihaO_CS.ttf",
        "regular": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeE9KJ5T7ihaO_CS.ttf",
        "500": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeEPKJ5T7ihaO_CS.ttf",
        "600": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeHjL55T7ihaO_CS.ttf",
        "700": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeHaL55T7ihaO_CS.ttf",
        "800": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeG9L55T7ihaO_CS.ttf",
        "900": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeGUL55T7ihaO_CS.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/geistmono/v3/or3yQ6H-1_WfwkMZI_qYPLs1a-t7PU0AbeE9KK5S5Cw.ttf"
    },
    {
      "family": "Gelasio",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gelasio/v13/cIfiMaFfvUQxTTqS3iKJkLGbI41wQL8Ilycs-TDO8Aba.ttf",
        "500": "https://fonts.gstatic.com/s/gelasio/v13/cIfiMaFfvUQxTTqS3iKJkLGbI41wQL86lycs-TDO8Aba.ttf",
        "600": "https://fonts.gstatic.com/s/gelasio/v13/cIfiMaFfvUQxTTqS3iKJkLGbI41wQL_WkCcs-TDO8Aba.ttf",
        "700": "https://fonts.gstatic.com/s/gelasio/v13/cIfiMaFfvUQxTTqS3iKJkLGbI41wQL_vkCcs-TDO8Aba.ttf",
        "italic": "https://fonts.gstatic.com/s/gelasio/v13/cIfsMaFfvUQxTTqS9Cu7b2nySBfeR6rA1M9v8zTs9RbanYs.ttf",
        "500italic": "https://fonts.gstatic.com/s/gelasio/v13/cIfsMaFfvUQxTTqS9Cu7b2nySBfeR6rA1P1v8zTs9RbanYs.ttf",
        "600italic": "https://fonts.gstatic.com/s/gelasio/v13/cIfsMaFfvUQxTTqS9Cu7b2nySBfeR6rA1BFo8zTs9RbanYs.ttf",
        "700italic": "https://fonts.gstatic.com/s/gelasio/v13/cIfsMaFfvUQxTTqS9Cu7b2nySBfeR6rA1Cho8zTs9RbanYs.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gelasio/v13/cIfiMaFfvUQxTTqS3iKJkLGbI41wQL8Ilxct8zQ.ttf"
    },
    {
      "family": "Gemunu Libre",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "sinhala"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp05iJPvSLeMXPIWA.ttf",
        "300": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp00aJPvSLeMXPIWA.ttf",
        "regular": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0xiJPvSLeMXPIWA.ttf",
        "500": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0yqJPvSLeMXPIWA.ttf",
        "600": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp08aOPvSLeMXPIWA.ttf",
        "700": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0_-OPvSLeMXPIWA.ttf",
        "800": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp05iOPvSLeMXPIWA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gemunulibre/v17/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0xiJDvWBfA.ttf"
    },
    {
      "family": "Genos",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cherokee",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVqknorUK6K7ZsAg.ttf",
        "200": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVKkjorUK6K7ZsAg.ttf",
        "300": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwV9EjorUK6K7ZsAg.ttf",
        "regular": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVqkjorUK6K7ZsAg.ttf",
        "500": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVmEjorUK6K7ZsAg.ttf",
        "600": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVdE_orUK6K7ZsAg.ttf",
        "700": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVTU_orUK6K7ZsAg.ttf",
        "800": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVKk_orUK6K7ZsAg.ttf",
        "900": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVA0_orUK6K7ZsAg.ttf",
        "100italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgsA70i-CbN8Ard7.ttf",
        "200italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYguA7ki-CbN8Ard7.ttf",
        "300italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgte7ki-CbN8Ard7.ttf",
        "italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgsA7ki-CbN8Ard7.ttf",
        "500italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgsy7ki-CbN8Ard7.ttf",
        "600italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgve6Ui-CbN8Ard7.ttf",
        "700italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgvn6Ui-CbN8Ard7.ttf",
        "800italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYguA6Ui-CbN8Ard7.ttf",
        "900italic": "https://fonts.gstatic.com/s/genos/v15/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgup6Ui-CbN8Ard7.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/genos/v15/SlGNmQqPqpUOYTYjacb0Hc91fTwVqkjYrEi-.ttf"
    },
    {
      "family": "Gentium Book Plus",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gentiumbookplus/v1/vEFL2-RHBgUK5fbjKxRpbBtJPyRpofKfdbLOrdPV.ttf",
        "italic": "https://fonts.gstatic.com/s/gentiumbookplus/v1/vEFN2-RHBgUK5fbjKxRpbBtJPyRpocKdf7bsqMPVZb4.ttf",
        "700": "https://fonts.gstatic.com/s/gentiumbookplus/v1/vEFO2-RHBgUK5fbjKxRpbBtJPyRpocojWpbGhs_cfKe1.ttf",
        "700italic": "https://fonts.gstatic.com/s/gentiumbookplus/v1/vEFA2-RHBgUK5fbjKxRpbBtJPyRpocKdRwrDjMv-ebe1Els.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gentiumbookplus/v1/vEFL2-RHBgUK5fbjKxRpbBtJPyRpocKef7Y.ttf"
    },
    {
      "family": "Gentium Plus",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gentiumplus/v2/Iurd6Ytw-oSPaZ00r2bNe8VpjJtM6G0t9w.ttf",
        "italic": "https://fonts.gstatic.com/s/gentiumplus/v2/IurD6Ytw-oSPaZ00r2bNe8VZjpFIymg9957e.ttf",
        "700": "https://fonts.gstatic.com/s/gentiumplus/v2/IurC6Ytw-oSPaZ00r2bNe8VRMLRo4EYx_ofHsw.ttf",
        "700italic": "https://fonts.gstatic.com/s/gentiumplus/v2/IurA6Ytw-oSPaZ00r2bNe8VZjqn05Uw13ILXs-h6.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gentiumplus/v2/Iurd6Ytw-oSPaZ00r2bNe8VZjZFI.ttf"
    },
    {
      "family": "Geo",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/geo/v22/CSRz4zRZlufVL3BmQjlCbQ.ttf",
        "italic": "https://fonts.gstatic.com/s/geo/v22/CSRx4zRZluflLXpiYDxSbf8r.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/geo/v22/CSRz4zRZluflLnpi.ttf"
    },
    {
      "family": "Geologica",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqDx_qQ-MYAXWnqFs.ttf",
        "200": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqD5_rQ-MYAXWnqFs.ttf",
        "300": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqD0HrQ-MYAXWnqFs.ttf",
        "regular": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqDx_rQ-MYAXWnqFs.ttf",
        "500": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqDy3rQ-MYAXWnqFs.ttf",
        "600": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqD8HsQ-MYAXWnqFs.ttf",
        "700": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqD_jsQ-MYAXWnqFs.ttf",
        "800": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqD5_sQ-MYAXWnqFs.ttf",
        "900": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqD7bsQ-MYAXWnqFs.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/geologica/v4/oY1o8evIr7j9P3TN9YwNAdyjzUyDKkKdAGOJh1UlCDUIhAIdhCZOn1fLsig7jfvCCPHZckU8H3G11_z-_OZqDx_rc-ISBQ.ttf"
    },
    {
      "family": "Georama",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5GvktmQsL5_tgbg.ttf",
        "200": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5mvgtmQsL5_tgbg.ttf",
        "300": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5RPgtmQsL5_tgbg.ttf",
        "regular": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5GvgtmQsL5_tgbg.ttf",
        "500": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5KPgtmQsL5_tgbg.ttf",
        "600": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5xP8tmQsL5_tgbg.ttf",
        "700": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5_f8tmQsL5_tgbg.ttf",
        "800": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5mv8tmQsL5_tgbg.ttf",
        "900": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5s_8tmQsL5_tgbg.ttf",
        "100italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rvF2wEPxf5wbh3T.ttf",
        "200italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rtF2gEPxf5wbh3T.ttf",
        "300italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rub2gEPxf5wbh3T.ttf",
        "italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rvF2gEPxf5wbh3T.ttf",
        "500italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rv32gEPxf5wbh3T.ttf",
        "600italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rsb3QEPxf5wbh3T.ttf",
        "700italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rsi3QEPxf5wbh3T.ttf",
        "800italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rtF3QEPxf5wbh3T.ttf",
        "900italic": "https://fonts.gstatic.com/s/georama/v14/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rts3QEPxf5wbh3T.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/georama/v14/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5GvgdmAEP.ttf"
    },
    {
      "family": "Geostar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/geostar/v27/sykz-yx4n701VLOftSq9-trEvlQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/geostar/v27/sykz-yx4n701VLOfhSu3_g.ttf"
    },
    {
      "family": "Geostar Fill",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/geostarfill/v27/AMOWz4SWuWiXFfjEohxQ9os0U1K2w9lb4g.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/geostarfill/v27/AMOWz4SWuWiXFfjEohxQ9osEUliy.ttf"
    },
    {
      "family": "Germania One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/germaniaone/v20/Fh4yPjrqIyv2ucM2qzBjeS3ezAJONau6ew.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/germaniaone/v20/Fh4yPjrqIyv2ucM2qzBjeS3uzQhK.ttf"
    },
    {
      "family": "Gideon Roman",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gideonroman/v12/e3tmeuGrVOys8sxzZgWlmXoge0PWovdU4w.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gideonroman/v12/e3tmeuGrVOys8sxzZgWlmXoQeknS.ttf"
    },
    {
      "family": "Gidole",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gidole/v24/sZlFdR6O8zVVEiMaCJtWS6EPcA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gidole/v24/sZlFdR6O8zVVEiMqCZFS.ttf"
    },
    {
      "family": "Gidugu",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "telugu"
      ],
      "version": "v27",
      "lastModified": "2025-06-12",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gidugu/v27/L0x8DFMkk1Uf6w3RvPCmRSlUig.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gidugu/v27/L0x8DFMkk1Uf6w3hvfqi.ttf"
    },
    {
      "family": "Gilda Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gildadisplay/v19/t5tmIRoYMoaYG0WEOh7HwMeR7TnFrpOHYh4.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gildadisplay/v19/t5tmIRoYMoaYG0WEOh7HwMeR3TjPqg.ttf"
    },
    {
      "family": "Girassol",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/girassol/v23/JTUUjIo_-DK48laaNC9Nz2pJzxbi.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/girassol/v23/JTUUjIo_-DK48laaNB9MxW4.ttf"
    },
    {
      "family": "Give You Glory",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/giveyouglory/v16/8QIQdiHOgt3vv4LR7ahjw9-XYc1zB4ZD6rwa.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/giveyouglory/v16/8QIQdiHOgt3vv4LR7ahjw9-XYf1yDYI.ttf"
    },
    {
      "family": "Glass Antiqua",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/glassantiqua/v25/xfu30Wr0Wn3NOQM2piC0uXOjnL_wN6fRUkY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/glassantiqua/v25/xfu30Wr0Wn3NOQM2piC0uXOjrL76Mw.ttf"
    },
    {
      "family": "Glegoo",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/glegoo/v17/_Xmt-HQyrTKWaw2Ji6mZAI91xw.ttf",
        "700": "https://fonts.gstatic.com/s/glegoo/v17/_Xmu-HQyrTKWaw2xN4a9CKRpzimMsg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/glegoo/v17/_Xmt-HQyrTKWaw25iqOd.ttf"
    },
    {
      "family": "Gloock",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gloock/v7/Iurb6YFw84WUY4N5jxylBrdRjQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gloock/v7/Iurb6YFw84WUY4NJjhah.ttf"
    },
    {
      "family": "Gloria Hallelujah",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gloriahallelujah/v23/LYjYdHv3kUk9BMV96EIswT9DIbW-MLSy3TKEvkCF.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gloriahallelujah/v23/LYjYdHv3kUk9BMV96EIswT9DIbW-MISz1zY.ttf"
    },
    {
      "family": "Glory",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-06-25",
      "files": {
        "100": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQwIiDpn-dDi9EOQ.ttf",
        "200": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQQImDpn-dDi9EOQ.ttf",
        "300": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQnomDpn-dDi9EOQ.ttf",
        "regular": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQwImDpn-dDi9EOQ.ttf",
        "500": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQ8omDpn-dDi9EOQ.ttf",
        "600": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQHo6Dpn-dDi9EOQ.ttf",
        "700": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQJ46Dpn-dDi9EOQ.ttf",
        "800": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQQI6Dpn-dDi9EOQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMpr5HWZLCpUOaM6.ttf",
        "200italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMrr5XWZLCpUOaM6.ttf",
        "300italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMo15XWZLCpUOaM6.ttf",
        "italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMpr5XWZLCpUOaM6.ttf",
        "500italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMpZ5XWZLCpUOaM6.ttf",
        "600italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMq14nWZLCpUOaM6.ttf",
        "700italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMqM4nWZLCpUOaM6.ttf",
        "800italic": "https://fonts.gstatic.com/s/glory/v17/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMrr4nWZLCpUOaM6.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/glory/v17/q5uasoi9Lf1w5t3Est24nq9blIRQwImzp3WZ.ttf"
    },
    {
      "family": "Gluten",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vb7B1Luni7ciJh.ttf",
        "200": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Xb7R1Luni7ciJh.ttf",
        "300": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8UF7R1Luni7ciJh.ttf",
        "regular": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vb7R1Luni7ciJh.ttf",
        "500": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vp7R1Luni7ciJh.ttf",
        "600": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8WF6h1Luni7ciJh.ttf",
        "700": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8W86h1Luni7ciJh.ttf",
        "800": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Xb6h1Luni7ciJh.ttf",
        "900": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Xy6h1Luni7ciJh.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gluten/v17/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vb7S1KsHw.ttf"
    },
    {
      "family": "Goblin One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/goblinone/v27/CSR64z1ZnOqZRjRCBVY_TOcATNt_pOU.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/goblinone/v27/CSR64z1ZnOqZRjRCBVY_fOYKSA.ttf"
    },
    {
      "family": "Gochi Hand",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gochihand/v24/hES06XlsOjtJsgCkx1PkTo71-n0nXWA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gochihand/v24/hES06XlsOjtJsgCkx1Pkfo___g.ttf"
    },
    {
      "family": "Goldman",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/goldman/v20/pe0uMIWbN4JFplR2LDJ4Bt-7G98.ttf",
        "700": "https://fonts.gstatic.com/s/goldman/v20/pe0rMIWbN4JFplR2FI5XIteQB9Zra1U.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/goldman/v20/pe0uMIWbN4JFplR2HDNyAg.ttf"
    },
    {
      "family": "Golos Text",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plVRRQ5cEr8zXcyx.ttf",
        "500": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plVjRQ5cEr8zXcyx.ttf",
        "600": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plWPQg5cEr8zXcyx.ttf",
        "700": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plW2Qg5cEr8zXcyx.ttf",
        "800": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plXRQg5cEr8zXcyx.ttf",
        "900": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plX4Qg5cEr8zXcyx.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/golostext/v6/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plVRRT5dGLs.ttf"
    },
    {
      "family": "Gorditas",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gorditas/v23/ll8_K2aTVD26DsPEtQDoDa4AlxYb.ttf",
        "700": "https://fonts.gstatic.com/s/gorditas/v23/ll84K2aTVD26DsPEtThUIooIvAoShA1i.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gorditas/v23/ll8_K2aTVD26DsPEtTDpB6o.ttf"
    },
    {
      "family": "Gothic A1",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "korean",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/gothica1/v17/CSR74z5ZnPydRjlCCwlCCMcqYtd2vfwk.ttf",
        "200": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlCpOYKSPl6tOU9Eg.ttf",
        "300": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlCwOUKSPl6tOU9Eg.ttf",
        "regular": "https://fonts.gstatic.com/s/gothica1/v17/CSR94z5ZnPydRjlCCwl6bM0uQNJmvQ.ttf",
        "500": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlCmOQKSPl6tOU9Eg.ttf",
        "600": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlCtOMKSPl6tOU9Eg.ttf",
        "700": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlC0OIKSPl6tOU9Eg.ttf",
        "800": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlCzOEKSPl6tOU9Eg.ttf",
        "900": "https://fonts.gstatic.com/s/gothica1/v17/CSR44z5ZnPydRjlCCwlC6OAKSPl6tOU9Eg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gothica1/v17/CSR94z5ZnPydRjlCCwlKbccq.ttf"
    },
    {
      "family": "Gotu",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gotu/v17/o-0FIpksx3QOlH0Lioh6-hU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gotu/v17/o-0FIpksx3QOpHwBjg.ttf"
    },
    {
      "family": "Goudy Bookletter 1911",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/goudybookletter1911/v20/sykt-z54laciWfKv-kX8krex0jDiD2HbY6I5tRbXZ4IXAA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/goudybookletter1911/v20/sykt-z54laciWfKv-kX8krex0jDiD2HbY6IJtBzT.ttf"
    },
    {
      "family": "Gowun Batang",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gowunbatang/v11/ijwSs5nhRMIjYsdSgcMa3wRhXLH-yuAtLw.ttf",
        "700": "https://fonts.gstatic.com/s/gowunbatang/v11/ijwNs5nhRMIjYsdSgcMa3wRZ4J7awssxJii23w.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gowunbatang/v11/ijwSs5nhRMIjYsdSgcMa3wRRXbv6.ttf"
    },
    {
      "family": "Gowun Dodum",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gowundodum/v11/3Jn5SD_00GqwlBnWc1TUJF0FfORL0fNy.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gowundodum/v11/3Jn5SD_00GqwlBnWc1TUJG0EduA.ttf"
    },
    {
      "family": "Graduate",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/graduate/v18/C8cg4cs3o2n15t_2YxgR6X2NZAn2.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/graduate/v18/C8cg4cs3o2n15t_2YygQ43k.ttf"
    },
    {
      "family": "Grand Hotel",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/grandhotel/v20/7Au7p_IgjDKdCRWuR1azpmQNEl0O0kEx.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grandhotel/v20/7Au7p_IgjDKdCRWuR1azplQMGFk.ttf"
    },
    {
      "family": "Grandiflora One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/grandifloraone/v3/0ybmGD0g27bCk_5MGWZcKWhxwnUU_R3y8DOWGA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grandifloraone/v3/0ybmGD0g27bCk_5MGWZcKWhxwnUk_Bf2.ttf"
    },
    {
      "family": "Grandstander",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD1-_D3jWttFGmQk.ttf",
        "200": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD9--D3jWttFGmQk.ttf",
        "300": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQDwG-D3jWttFGmQk.ttf",
        "regular": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD1--D3jWttFGmQk.ttf",
        "500": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD22-D3jWttFGmQk.ttf",
        "600": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD4G5D3jWttFGmQk.ttf",
        "700": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD7i5D3jWttFGmQk.ttf",
        "800": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD9-5D3jWttFGmQk.ttf",
        "900": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD_a5D3jWttFGmQk.ttf",
        "100italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf95zrcsvNDiQlBYQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9ZzvcsvNDiQlBYQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9uTvcsvNDiQlBYQ.ttf",
        "italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf95zvcsvNDiQlBYQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf91TvcsvNDiQlBYQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9OTzcsvNDiQlBYQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9ADzcsvNDiQlBYQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9ZzzcsvNDiQlBYQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/grandstander/v19/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9TjzcsvNDiQlBYQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grandstander/v19/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD1--P3ncsg.ttf"
    },
    {
      "family": "Grape Nuts",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/grapenuts/v6/syk2-yF4iLM2RfKj4F7k3tLvol2RN1E.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grapenuts/v6/syk2-yF4iLM2RfKj4F7k7tPlpg.ttf"
    },
    {
      "family": "Gravitas One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gravitasone/v20/5h1diZ4hJ3cblKy3LWakKQmaDWRNr3DzbQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gravitasone/v20/5h1diZ4hJ3cblKy3LWakKQmqDG5J.ttf"
    },
    {
      "family": "Great Vibes",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/greatvibes/v20/RWmMoKWR9v4ksMfaWd_JN-XCg6UKDXlq.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/greatvibes/v20/RWmMoKWR9v4ksMfaWd_JN9XDiaE.ttf"
    },
    {
      "family": "Grechen Fuemen",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/grechenfuemen/v10/vEFI2_tHEQ4d5ObgKxBzZh0MAWgc-NaXXq7H.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grechenfuemen/v10/vEFI2_tHEQ4d5ObgKxBzZh0MAVgd8tI.ttf"
    },
    {
      "family": "Grenze",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/grenze/v15/O4ZRFGb7hR12BxqPm2IjuAkalnmd.ttf",
        "100italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZXFGb7hR12BxqH_VpHsg04k2md0kI.ttf",
        "200": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPN0MDkicWn2CEyw.ttf",
        "200italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_Vrrky0SvWWUy1uW.ttf",
        "300": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPU0ADkicWn2CEyw.ttf",
        "300italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_VqPkC0SvWWUy1uW.ttf",
        "regular": "https://fonts.gstatic.com/s/grenze/v15/O4ZTFGb7hR12Bxq3_2gnmgwKlg.ttf",
        "italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZRFGb7hR12BxqH_WIjuAkalnmd.ttf",
        "500": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPC0EDkicWn2CEyw.ttf",
        "500italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_VrXkS0SvWWUy1uW.ttf",
        "600": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPJ0YDkicWn2CEyw.ttf",
        "600italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_Vr7li0SvWWUy1uW.ttf",
        "700": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPQ0cDkicWn2CEyw.ttf",
        "700italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_Vqfly0SvWWUy1uW.ttf",
        "800": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPX0QDkicWn2CEyw.ttf",
        "800italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_VqDlC0SvWWUy1uW.ttf",
        "900": "https://fonts.gstatic.com/s/grenze/v15/O4ZQFGb7hR12BxqPe0UDkicWn2CEyw.ttf",
        "900italic": "https://fonts.gstatic.com/s/grenze/v15/O4ZWFGb7hR12BxqH_VqnlS0SvWWUy1uW.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grenze/v15/O4ZTFGb7hR12BxqH_mIj.ttf"
    },
    {
      "family": "Grenze Gotisch",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5Lz5UcICdYPSd_w.ttf",
        "200": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5rz9UcICdYPSd_w.ttf",
        "300": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5cT9UcICdYPSd_w.ttf",
        "regular": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5Lz9UcICdYPSd_w.ttf",
        "500": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5HT9UcICdYPSd_w.ttf",
        "600": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i58ThUcICdYPSd_w.ttf",
        "700": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5yDhUcICdYPSd_w.ttf",
        "800": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5rzhUcICdYPSd_w.ttf",
        "900": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5hjhUcICdYPSd_w.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/grenzegotisch/v19/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5Lz9kcYqZ.ttf"
    },
    {
      "family": "Grey Qo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/greyqo/v10/BXRrvF_Nmv_TyXxNDOtQ9Wf0QcE.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/greyqo/v10/BXRrvF_Nmv_TyXxNPOpa8Q.ttf"
    },
    {
      "family": "Griffy",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/griffy/v22/FwZa7-ox2FQh9kfwSNSEwM2zpA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/griffy/v22/FwZa7-ox2FQh9kfASd6A.ttf"
    },
    {
      "family": "Gruppo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gruppo/v22/WwkfxPmzE06v_ZWFWXDAOIEQUQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gruppo/v22/WwkfxPmzE06v_ZW1WHrE.ttf"
    },
    {
      "family": "Gudea",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gudea/v15/neIFzCqgsI0mp-CP9IGON7Ez.ttf",
        "italic": "https://fonts.gstatic.com/s/gudea/v15/neILzCqgsI0mp9CN_oWsMqEzSJQ.ttf",
        "700": "https://fonts.gstatic.com/s/gudea/v15/neIIzCqgsI0mp9gz26WGHK06UY30.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gudea/v15/neIFzCqgsI0mp9CO_oU.ttf"
    },
    {
      "family": "Gugi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gugi/v20/A2BVn5dXywshVA6A9DEfgqM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gugi/v20/A2BVn5dXywshZA-K8A.ttf"
    },
    {
      "family": "Gulzar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gulzar/v13/Wnz6HAc9eB3HB2ILYTwZqg_MPQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gulzar/v13/Wnz6HAc9eB3HB2I7YDYd.ttf"
    },
    {
      "family": "Gupter",
      "variants": [
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gupter/v17/2-cm9JNmxJqPO1QUYZa_Wu_lpA.ttf",
        "500": "https://fonts.gstatic.com/s/gupter/v17/2-cl9JNmxJqPO1Qslb-bUsT5rZhaZg.ttf",
        "700": "https://fonts.gstatic.com/s/gupter/v17/2-cl9JNmxJqPO1Qs3bmbUsT5rZhaZg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gupter/v17/2-cm9JNmxJqPO1QkYJy7.ttf"
    },
    {
      "family": "Gurajada",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "telugu"
      ],
      "version": "v22",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gurajada/v22/FwZY7-Qx308m-l-0Kd6A4sijpFu_.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gurajada/v22/FwZY7-Qx308m-l-0Ke6B6Mw.ttf"
    },
    {
      "family": "Gwendolyn",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/gwendolyn/v8/qkBXXvoO_M3CSss-d7ee5JRLkAXbMQ.ttf",
        "700": "https://fonts.gstatic.com/s/gwendolyn/v8/qkBSXvoO_M3CSss-d7emWLtvmC7HONiSFQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/gwendolyn/v8/qkBXXvoO_M3CSss-d7eu5Z5P.ttf"
    },
    {
      "family": "Habibi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/habibi/v21/CSR-4zFWkuqcTTNCShJeZOYySQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/habibi/v21/CSR-4zFWkuqcTTNySxha.ttf"
    },
    {
      "family": "Hachi Maru Pop",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hachimarupop/v22/HI_TiYoRLqpLrEiMAuO9Ysfz7rW1EM_btd8u.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hachimarupop/v22/HI_TiYoRLqpLrEiMAuO9Ysfz7oW0Gss.ttf"
    },
    {
      "family": "Hahmlet",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RhKOdjobsO-aVxn.ttf",
        "200": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RjKONjobsO-aVxn.ttf",
        "300": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RgUONjobsO-aVxn.ttf",
        "regular": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RhKONjobsO-aVxn.ttf",
        "500": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4Rh4ONjobsO-aVxn.ttf",
        "600": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RiUP9jobsO-aVxn.ttf",
        "700": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RitP9jobsO-aVxn.ttf",
        "800": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RjKP9jobsO-aVxn.ttf",
        "900": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RjjP9jobsO-aVxn.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hahmlet/v20/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RhKOOjpZMc.ttf"
    },
    {
      "family": "Halant",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/halant/v16/u-490qaujRI2Pbsvc_pCmwZqcwdRXg.ttf",
        "regular": "https://fonts.gstatic.com/s/halant/v16/u-4-0qaujRI2PbsX39Jmky12eg.ttf",
        "500": "https://fonts.gstatic.com/s/halant/v16/u-490qaujRI2PbsvK_tCmwZqcwdRXg.ttf",
        "600": "https://fonts.gstatic.com/s/halant/v16/u-490qaujRI2PbsvB_xCmwZqcwdRXg.ttf",
        "700": "https://fonts.gstatic.com/s/halant/v16/u-490qaujRI2PbsvY_1CmwZqcwdRXg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/halant/v16/u-4-0qaujRI2Pbsn3thi.ttf"
    },
    {
      "family": "Hammersmith One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hammersmithone/v17/qWcyB624q4L_C4jGQ9IK0O_dFlnbshsks4MRXw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hammersmithone/v17/qWcyB624q4L_C4jGQ9IK0O_dFlnrsxEg.ttf"
    },
    {
      "family": "Hanalei",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hanalei/v23/E21n_dD8iufIjBRHXzgmVydREus.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hanalei/v23/E21n_dD8iufIjBRHbzksUw.ttf"
    },
    {
      "family": "Hanalei Fill",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hanaleifill/v22/fC1mPYtObGbfyQznIaQzPQiMVwLBplm9aw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hanaleifill/v22/fC1mPYtObGbfyQznIaQzPQi8VgjF.ttf"
    },
    {
      "family": "Handjet",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "armenian",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHTmbUkUsEHFAH2A.ttf",
        "200": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHbmaUkUsEHFAH2A.ttf",
        "300": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHWeaUkUsEHFAH2A.ttf",
        "regular": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHTmaUkUsEHFAH2A.ttf",
        "500": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHQuaUkUsEHFAH2A.ttf",
        "600": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHeedUkUsEHFAH2A.ttf",
        "700": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHd6dUkUsEHFAH2A.ttf",
        "800": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHbmdUkUsEHFAH2A.ttf",
        "900": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHZCdUkUsEHFAH2A.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/handjet/v21/oY1n8eXHq7n1OnbQrOY_2FrEwYEMLlcdP1mCtZaLaTutCwcIhGZ0lGU0akFcO3XFHTmaYkQmFA.ttf"
    },
    {
      "family": "Handlee",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/handlee/v19/-F6xfjBsISg9aMakDmr6oilJ3ik.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/handlee/v19/-F6xfjBsISg9aMakPmvwpg.ttf"
    },
    {
      "family": "Hanken Grotesk",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Ncs2da4fpNzXhRKA.ttf",
        "200": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcM2Za4fpNzXhRKA.ttf",
        "300": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Nc7WZa4fpNzXhRKA.ttf",
        "regular": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Ncs2Za4fpNzXhRKA.ttf",
        "500": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcgWZa4fpNzXhRKA.ttf",
        "600": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcbWFa4fpNzXhRKA.ttf",
        "700": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcVGFa4fpNzXhRKA.ttf",
        "800": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcM2Fa4fpNzXhRKA.ttf",
        "900": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcGmFa4fpNzXhRKA.ttf",
        "100italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyWyo_BJ731BKMSK.ttf",
        "200italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyUyovBJ731BKMSK.ttf",
        "300italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyXsovBJ731BKMSK.ttf",
        "italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyWyovBJ731BKMSK.ttf",
        "500italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyWAovBJ731BKMSK.ttf",
        "600italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyVspfBJ731BKMSK.ttf",
        "700italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyVVpfBJ731BKMSK.ttf",
        "800italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyUypfBJ731BKMSK.ttf",
        "900italic": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyUbpfBJ731BKMSK.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hankengrotesk/v11/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Ncs2Zq4PBJ.ttf"
    },
    {
      "family": "Hanuman",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v24",
      "lastModified": "2025-06-12",
      "files": {
        "100": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0sd5hDsU9X6RPzQ.ttf",
        "200": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0ud5xDsU9X6RPzQ.ttf",
        "300": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0tD5xDsU9X6RPzQ.ttf",
        "regular": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0sd5xDsU9X6RPzQ.ttf",
        "500": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0sv5xDsU9X6RPzQ.ttf",
        "600": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0vD4BDsU9X6RPzQ.ttf",
        "700": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0v64BDsU9X6RPzQ.ttf",
        "800": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0ud4BDsU9X6RPzQ.ttf",
        "900": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0u04BDsU9X6RPzQ.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hanuman/v24/VuJudNvD15HhpJJBYq31yFn72hxIv0sd5yDtWdE.ttf"
    },
    {
      "family": "Happy Monkey",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/happymonkey/v14/K2F2fZZcl-9SXwl5F_C4R_OABwD2bWqVjw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/happymonkey/v14/K2F2fZZcl-9SXwl5F_C4R_OwBgry.ttf"
    },
    {
      "family": "Harmattan",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/harmattan/v21/goksH6L2DkFvVvRp9XpTS0CjkP1Yog.ttf",
        "500": "https://fonts.gstatic.com/s/harmattan/v21/gokpH6L2DkFvVvRp9Xprv2mHmNZEq6TTFw.ttf",
        "600": "https://fonts.gstatic.com/s/harmattan/v21/gokpH6L2DkFvVvRp9Xprk26HmNZEq6TTFw.ttf",
        "700": "https://fonts.gstatic.com/s/harmattan/v21/gokpH6L2DkFvVvRp9Xpr92-HmNZEq6TTFw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/harmattan/v21/goksH6L2DkFvVvRp9XpjSkqn.ttf"
    },
    {
      "family": "Headland One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/headlandone/v16/yYLu0hHR2vKnp89Tk1TCq3Tx0PlTeZ3mJA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/headlandone/v16/yYLu0hHR2vKnp89Tk1TCq3TB0fNX.ttf"
    },
    {
      "family": "Hedvig Letters Sans",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hedvigletterssans/v2/CHy_V_PfGVjobSBkihHWDT98RVp37w8jQJ1N3Twgi1w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hedvigletterssans/v2/CHy_V_PfGVjobSBkihHWDT98RVp37w8jcJxH2Q.ttf"
    },
    {
      "family": "Hedvig Letters Serif",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hedviglettersserif/v3/OD5puN2I2mekHmyoU1Kj2AXOd5_7v7gIDlX8quj7viQ_N1HixEAZf7fcvSGpZg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hedviglettersserif/v3/OD5puN2I2mekHmyoU1Kj2AXOd5_7v7gIDlX8quj7viQ_N1HixEApfr3Y.ttf"
    },
    {
      "family": "Heebo",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v27",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EiS2cckOnz02SXQ.ttf",
        "200": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1ECSycckOnz02SXQ.ttf",
        "300": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1E1yycckOnz02SXQ.ttf",
        "regular": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EiSycckOnz02SXQ.ttf",
        "500": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EuyycckOnz02SXQ.ttf",
        "600": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EVyucckOnz02SXQ.ttf",
        "700": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EbiucckOnz02SXQ.ttf",
        "800": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1ECSucckOnz02SXQ.ttf",
        "900": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EICucckOnz02SXQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/heebo/v27/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EiSysc0mj.ttf"
    },
    {
      "family": "Henny Penny",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hennypenny/v17/wXKvE3UZookzsxz_kjGSfMQqt3M7tMDT.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hennypenny/v17/wXKvE3UZookzsxz_kjGSfPQrvXc.ttf"
    },
    {
      "family": "Hepta Slab",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvkV5jfbY5B0NBkz.ttf",
        "200": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvmV5zfbY5B0NBkz.ttf",
        "300": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvlL5zfbY5B0NBkz.ttf",
        "regular": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvkV5zfbY5B0NBkz.ttf",
        "500": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5Hvkn5zfbY5B0NBkz.ttf",
        "600": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvnL4DfbY5B0NBkz.ttf",
        "700": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5Hvny4DfbY5B0NBkz.ttf",
        "800": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvmV4DfbY5B0NBkz.ttf",
        "900": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5Hvm84DfbY5B0NBkz.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/heptaslab/v24/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvkV5wfaaZQ.ttf"
    },
    {
      "family": "Herr Von Muellerhoff",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/herrvonmuellerhoff/v22/WBL6rFjRZkREW8WqmCWYLgCkQKXb4CAft3c6_qJY3QPQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/herrvonmuellerhoff/v22/WBL6rFjRZkREW8WqmCWYLgCkQKXb4CAft0c79KY.ttf"
    },
    {
      "family": "Hi Melody",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/himelody/v18/46ktlbP8Vnz0pJcqCTbEf29E31BBGA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/himelody/v18/46ktlbP8Vnz0pJcqCTb0fmVA.ttf"
    },
    {
      "family": "Hina Mincho",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hinamincho/v15/2sDaZGBRhpXa2Jjz5w5LAGW8KbkVZTHR.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hinamincho/v15/2sDaZGBRhpXa2Jjz5w5LAFW9I70.ttf"
    },
    {
      "family": "Hind",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/hind/v17/5aU19_a8oxmIfMJaIRuYjDpf5Vw.ttf",
        "regular": "https://fonts.gstatic.com/s/hind/v17/5aU69_a8oxmIRG5yBROzkDM.ttf",
        "500": "https://fonts.gstatic.com/s/hind/v17/5aU19_a8oxmIfJpbIRuYjDpf5Vw.ttf",
        "600": "https://fonts.gstatic.com/s/hind/v17/5aU19_a8oxmIfLZcIRuYjDpf5Vw.ttf",
        "700": "https://fonts.gstatic.com/s/hind/v17/5aU19_a8oxmIfNJdIRuYjDpf5Vw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hind/v17/5aU69_a8oxmIdG94AQ.ttf"
    },
    {
      "family": "Hind Guntur",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "telugu"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/hindguntur/v13/wXKyE3UZrok56nvamSuJd_yGn1czn9zaj5Ju.ttf",
        "regular": "https://fonts.gstatic.com/s/hindguntur/v13/wXKvE3UZrok56nvamSuJd8Qqt3M7tMDT.ttf",
        "500": "https://fonts.gstatic.com/s/hindguntur/v13/wXKyE3UZrok56nvamSuJd_zenlczn9zaj5Ju.ttf",
        "600": "https://fonts.gstatic.com/s/hindguntur/v13/wXKyE3UZrok56nvamSuJd_zymVczn9zaj5Ju.ttf",
        "700": "https://fonts.gstatic.com/s/hindguntur/v13/wXKyE3UZrok56nvamSuJd_yWmFczn9zaj5Ju.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hindguntur/v13/wXKvE3UZrok56nvamSuJd_QrvXc.ttf"
    },
    {
      "family": "Hind Madurai",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil"
      ],
      "version": "v12",
      "lastModified": "2025-05-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/hindmadurai/v12/f0Xu0e2p98ZvDXdZQIOcpqjfXaUnecsoMJ0b_g.ttf",
        "regular": "https://fonts.gstatic.com/s/hindmadurai/v12/f0Xx0e2p98ZvDXdZQIOcpqjn8Y0DceA0OQ.ttf",
        "500": "https://fonts.gstatic.com/s/hindmadurai/v12/f0Xu0e2p98ZvDXdZQIOcpqjfBaQnecsoMJ0b_g.ttf",
        "600": "https://fonts.gstatic.com/s/hindmadurai/v12/f0Xu0e2p98ZvDXdZQIOcpqjfKaMnecsoMJ0b_g.ttf",
        "700": "https://fonts.gstatic.com/s/hindmadurai/v12/f0Xu0e2p98ZvDXdZQIOcpqjfTaInecsoMJ0b_g.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hindmadurai/v12/f0Xx0e2p98ZvDXdZQIOcpqjX8IcH.ttf"
    },
    {
      "family": "Hind Mysuru",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/hindmysuru/v1/sykq-yB3k7wiAJ-U5l_li8pppHWQBVTqU4sY.ttf",
        "regular": "https://fonts.gstatic.com/s/hindmysuru/v1/syk3-yB3k7wiAJ-U5l_li_LFjFGYLkjj.ttf",
        "500": "https://fonts.gstatic.com/s/hindmysuru/v1/sykq-yB3k7wiAJ-U5l_li8oxpXWQBVTqU4sY.ttf",
        "600": "https://fonts.gstatic.com/s/hindmysuru/v1/sykq-yB3k7wiAJ-U5l_li8odonWQBVTqU4sY.ttf",
        "700": "https://fonts.gstatic.com/s/hindmysuru/v1/sykq-yB3k7wiAJ-U5l_li8p5o3WQBVTqU4sY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hindmysuru/v1/syk3-yB3k7wiAJ-U5l_li8LEhlU.ttf"
    },
    {
      "family": "Hind Siliguri",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "bengali",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/hindsiliguri/v13/ijwOs5juQtsyLLR5jN4cxBEoRDf44uEfKiGvxts.ttf",
        "regular": "https://fonts.gstatic.com/s/hindsiliguri/v13/ijwTs5juQtsyLLR5jN4cxBEofJvQxuk0Nig.ttf",
        "500": "https://fonts.gstatic.com/s/hindsiliguri/v13/ijwOs5juQtsyLLR5jN4cxBEoRG_54uEfKiGvxts.ttf",
        "600": "https://fonts.gstatic.com/s/hindsiliguri/v13/ijwOs5juQtsyLLR5jN4cxBEoREP-4uEfKiGvxts.ttf",
        "700": "https://fonts.gstatic.com/s/hindsiliguri/v13/ijwOs5juQtsyLLR5jN4cxBEoRCf_4uEfKiGvxts.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hindsiliguri/v13/ijwTs5juQtsyLLR5jN4cxBEoTJrawg.ttf"
    },
    {
      "family": "Hind Vadodara",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/hindvadodara/v15/neIQzCKvrIcn5pbuuuriV9tTSDn3iXM0oSOL2Yw.ttf",
        "regular": "https://fonts.gstatic.com/s/hindvadodara/v15/neINzCKvrIcn5pbuuuriV9tTcJXfrXsfvSo.ttf",
        "500": "https://fonts.gstatic.com/s/hindvadodara/v15/neIQzCKvrIcn5pbuuuriV9tTSGH2iXM0oSOL2Yw.ttf",
        "600": "https://fonts.gstatic.com/s/hindvadodara/v15/neIQzCKvrIcn5pbuuuriV9tTSE3xiXM0oSOL2Yw.ttf",
        "700": "https://fonts.gstatic.com/s/hindvadodara/v15/neIQzCKvrIcn5pbuuuriV9tTSCnwiXM0oSOL2Yw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hindvadodara/v15/neINzCKvrIcn5pbuuuriV9tTQJTVqQ.ttf"
    },
    {
      "family": "Holtwood One SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/holtwoodonesc/v22/yYLx0hLR0P-3vMFSk1TCq3Txg5B3cbb6LZttyg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/holtwoodonesc/v22/yYLx0hLR0P-3vMFSk1TCq3Txg5BHcLz-.ttf"
    },
    {
      "family": "Homemade Apple",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/homemadeapple/v23/Qw3EZQFXECDrI2q789EKQZJob3x9Vnksi4M7.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/homemadeapple/v23/Qw3EZQFXECDrI2q789EKQZJob0x8XH0.ttf"
    },
    {
      "family": "Homenaje",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/homenaje/v16/FwZY7-Q-xVAi_l-6Ld6A4sijpFu_.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/homenaje/v16/FwZY7-Q-xVAi_l-6Le6B6Mw.ttf"
    },
    {
      "family": "Honk",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols",
        "vietnamese"
      ],
      "version": "v5",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/honk/v5/m8J7jftUea-XwTaemClumrBQbmvynOmXBji9zFhHRr8WFgVLo7tNepQKvg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/honk/v5/m8J7jftUea-XwTaemClumrBQbmvynOmXBji9zFhHRr8WFgV7orFJ.ttf",
      "colorCapabilities": [
        "COLRv1"
      ]
    },
    {
      "family": "Host Grotesk",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PubnOzhap-j94InI.ttf",
        "regular": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PuefOzhap-j94InI.ttf",
        "500": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PudXOzhap-j94InI.ttf",
        "600": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PuTnJzhap-j94InI.ttf",
        "700": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PuQDJzhap-j94InI.ttf",
        "800": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PuWfJzhap-j94InI.ttf",
        "300italic": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3SmWBnlCJ3U42vbbfdwMjZoULo4bgYM-BIrC-NeFWj_h19MnL2jg.ttf",
        "italic": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3SmWBnlCJ3U42vbbfdwMjZoULo4bgYM-BIrC-NJlWj_h19MnL2jg.ttf",
        "500italic": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3SmWBnlCJ3U42vbbfdwMjZoULo4bgYM-BIrC-NFFWj_h19MnL2jg.ttf",
        "600italic": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3SmWBnlCJ3U42vbbfdwMjZoULo4bgYM-BIrC-N-FKj_h19MnL2jg.ttf",
        "700italic": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3SmWBnlCJ3U42vbbfdwMjZoULo4bgYM-BIrC-NwVKj_h19MnL2jg.ttf",
        "800italic": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3SmWBnlCJ3U42vbbfdwMjZoULo4bgYM-BIrC-NplKj_h19MnL2jg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hostgrotesk/v4/co3UmWBnlCJ3U42vbbfdwMjzqHAXOdFzqU5PuefO_hej_g.ttf"
    },
    {
      "family": "Hubballi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext"
      ],
      "version": "v9",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hubballi/v9/o-0JIpUj3WIZ1RFN56B7yBBNYuSF.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hubballi/v9/o-0JIpUj3WIZ1RFN55B6whQ.ttf"
    },
    {
      "family": "Hubot Sans",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsCZ7ZdgLDVwVqcXQ.ttf",
        "300": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsCubZdgLDVwVqcXQ.ttf",
        "regular": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsC57ZdgLDVwVqcXQ.ttf",
        "500": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsC1bZdgLDVwVqcXQ.ttf",
        "600": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsCObFdgLDVwVqcXQ.ttf",
        "700": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsCALFdgLDVwVqcXQ.ttf",
        "800": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsCZ7FdgLDVwVqcXQ.ttf",
        "900": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsCTrFdgLDVwVqcXQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_U1w7rR41-MXUss.ttf",
        "300italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_Xrw7rR41-MXUss.ttf",
        "italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_W1w7rR41-MXUss.ttf",
        "500italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_WHw7rR41-MXUss.ttf",
        "600italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_VrxLrR41-MXUss.ttf",
        "700italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_VSxLrR41-MXUss.ttf",
        "800italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_U1xLrR41-MXUss.ttf",
        "900italic": "https://fonts.gstatic.com/s/hubotsans/v4/pe0PMIiULYxOvxVLbVwhEtWACNaCm8WTUIR_y2-e41Q0S0srIrwXL_UcxLrR41-MXUss.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hubotsans/v4/pe0BMIiULYxOvxVLbVwhONyy6zb7yFM9V5G3iZ3X0avsIiCxjLsC57ZtgbrR.ttf"
    },
    {
      "family": "Huninn",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-traditional",
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-06-12",
      "files": {
        "regular": "https://fonts.gstatic.com/s/huninn/v2/OpNNnoINg9bQ4xkpjiHQjittXw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/huninn/v2/OpNNnoINg9bQ4xkZjyvU.ttf"
    },
    {
      "family": "Hurricane",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/hurricane/v8/pe0sMIuULZxTolZ5YldyAv2-C99ycg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/hurricane/v8/pe0sMIuULZxTolZ5YldCA_e6.ttf"
    },
    {
      "family": "IBM Plex Mono",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6pfjptAgt5VM-kVkqdyU8n3kwq0n1hj-sNFQ.ttf",
        "100italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6rfjptAgt5VM-kVkqdyU8n1ioStndlre4dFcFh.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6qfjptAgt5VM-kVkqdyU8n3uAL8ldPg-IUDNg.ttf",
        "200italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6sfjptAgt5VM-kVkqdyU8n1ioSGlZFh8ARHNh4zg.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6qfjptAgt5VM-kVkqdyU8n3oQI8ldPg-IUDNg.ttf",
        "300italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6sfjptAgt5VM-kVkqdyU8n1ioSflVFh8ARHNh4zg.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F63fjptAgt5VM-kVkqdyU8n5igg1l9kn-s.ttf",
        "italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6pfjptAgt5VM-kVkqdyU8n1ioq0n1hj-sNFQ.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6qfjptAgt5VM-kVkqdyU8n3twJ8ldPg-IUDNg.ttf",
        "500italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6sfjptAgt5VM-kVkqdyU8n1ioSJlRFh8ARHNh4zg.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6qfjptAgt5VM-kVkqdyU8n3vAO8ldPg-IUDNg.ttf",
        "600italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6sfjptAgt5VM-kVkqdyU8n1ioSClNFh8ARHNh4zg.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6qfjptAgt5VM-kVkqdyU8n3pQP8ldPg-IUDNg.ttf",
        "700italic": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F6sfjptAgt5VM-kVkqdyU8n1ioSblJFh8ARHNh4zg.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexmono/v19/-F63fjptAgt5VM-kVkqdyU8n1ikq0g.ttf"
    },
    {
      "family": "IBM Plex Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSD6lhzAKI5loa26g.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSDallzAKI5loa26g.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSDtFlzAKI5loa26g.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSD6llzAKI5loa26g.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSD2FlzAKI5loa26g.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSDNF5zAKI5loa26g.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSDDV5zAKI5loa26g.ttf",
        "100italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhqbQqg9tIOm6vje.ttf",
        "200italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhobQ6g9tIOm6vje.ttf",
        "300italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhrFQ6g9tIOm6vje.ttf",
        "italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhqbQ6g9tIOm6vje.ttf",
        "500italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhqpQ6g9tIOm6vje.ttf",
        "600italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhpFRKg9tIOm6vje.ttf",
        "700italic": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXEKVElMYYaJe8bpLHnCwDKhdTEG46kmUZQCX598fQbM4jw8V78x9OWIhp8RKg9tIOm6vje.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsans/v22/zYXGKVElMYYaJe8bpLHnCwDKr932-G7dytD-Dmu1swZSAXcomDVmadSD6llDAag9.ttf"
    },
    {
      "family": "IBM Plex Sans Arabic",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3MZRtWPQCuHme67tEYUIx3Kh0PHR9N6YNe3PC5eMlAMg0.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YPy_dCTVsVJKxTs.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YOW_tCTVsVJKxTs.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3CZRtWPQCuHme67tEYUIx3Kh0PHR9N6bs61vSbfdlA.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YPO_9CTVsVJKxTs.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YPi-NCTVsVJKxTs.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YOG-dCTVsVJKxTs.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsansarabic/v13/Qw3CZRtWPQCuHme67tEYUIx3Kh0PHR9N6Ys73PA.ttf"
    },
    {
      "family": "IBM Plex Sans Condensed",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8nN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY7KyKvBgYsMDhM.ttf",
        "100italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8hN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8M_LhakJHhOgBg.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY5m6Yvrr4cFFwq5.ttf",
        "200italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8GPqpYMnEhq5H1w.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY4C6ovrr4cFFwq5.ttf",
        "300italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8AfppYMnEhq5H1w.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8lN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHbauwq_jhJsM.ttf",
        "italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8nN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYasyKvBgYsMDhM.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY5a64vrr4cFFwq5.ttf",
        "500italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8F_opYMnEhq5H1w.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY527Ivrr4cFFwq5.ttf",
        "600italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8HPvpYMnEhq5H1w.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY4S7Yvrr4cFFwq5.ttf",
        "700italic": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8BfupYMnEhq5H1w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsanscondensed/v14/Gg8lN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYavyKs.ttf"
    },
    {
      "family": "IBM Plex Sans Devanagari",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic-ext",
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXB3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HMUjwUcjwCEQq.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HnWnQe-b8AV0z0w.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_H-WrQe-b8AV0z0w.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXH3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O__VUL0c83gCA.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HoWvQe-b8AV0z0w.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HjWzQe-b8AV0z0w.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_H6W3Qe-b8AV0z0w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsansdevanagari/v11/XRXH3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_PVEjw.ttf"
    },
    {
      "family": "IBM Plex Sans Hebrew",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic-ext",
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa4qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEXB-l0VqDaM7C4.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEVt230_hjqF9Tc2.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEUJ2H0_hjqF9Tc2.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa2qYENg9Kw1mpLpO0bGM5lfHAAZHhDXH2l8Fk3rSaM.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEVR2X0_hjqF9Tc2.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEV93n0_hjqF9Tc2.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEUZ330_hjqF9Tc2.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsanshebrew/v11/BCa2qYENg9Kw1mpLpO0bGM5lfHAAZHhDXE2k-l0.ttf"
    },
    {
      "family": "IBM Plex Sans JP",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XLDn9KbTDf6_f7dISNqYf_tvPT7E7yjPB7twdmHQ.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7OLTrNpVuw5_BAM.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7IbQrNpVuw5_BAM.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XNDn9KbTDf6_f7dISNqYf_tvPT1Cr4iNJ-pwc.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7N7RrNpVuw5_BAM.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7PLWrNpVuw5_BAM.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7JbXrNpVuw5_BAM.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsansjp/v6/Z9XNDn9KbTDf6_f7dISNqYf_tvPT5CvyjA.ttf"
    },
    {
      "family": "IBM Plex Sans KR",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFM2-VJISZe3O_rc3ZVYh4aTwNOyra_X5zCpMrMfA.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFN2-VJISZe3O_rc3ZVYh4aTwNOyhqef7bsqMPVZb4.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFN2-VJISZe3O_rc3ZVYh4aTwNOyn6df7bsqMPVZb4.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFK2-VJISZe3O_rc3ZVYh4aTwNO8tK1W77HtMo.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFN2-VJISZe3O_rc3ZVYh4aTwNOyiacf7bsqMPVZb4.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFN2-VJISZe3O_rc3ZVYh4aTwNOygqbf7bsqMPVZb4.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFN2-VJISZe3O_rc3ZVYh4aTwNOym6af7bsqMPVZb4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsanskr/v10/vEFK2-VJISZe3O_rc3ZVYh4aTwNOwtO_Xw.ttf"
    },
    {
      "family": "IBM Plex Sans Thai",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "thai"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JNje1VVIzcq1HzJq2AEdo2Tj_qvLqEatYlR8ZKUqcX.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqExvcFbehGW74OXw.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqEovQFbehGW74OXw.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JPje1VVIzcq1HzJq2AEdo2Tj_qvLq8DtwhZcNaUg.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqE-vUFbehGW74OXw.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqE1vIFbehGW74OXw.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqEsvMFbehGW74OXw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsansthai/v10/m8JPje1VVIzcq1HzJq2AEdo2Tj_qvLqMD9Yl.ttf"
    },
    {
      "family": "IBM Plex Sans Thai Looped",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "thai"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss5AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_HaKpHOtFCQ76Q.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_NqrhFmDGC0i8Cc.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_L6ohFmDGC0i8Cc.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss_AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30LxBKAoFGoBCQ.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_OaphFmDGC0i8Cc.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_MquhFmDGC0i8Cc.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_K6vhFmDGC0i8Cc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexsansthailooped/v11/tss_AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L9BOKpA.ttf"
    },
    {
      "family": "IBM Plex Serif",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizBREVNn1dOx-zrZ2X3pZvkTi182zIZj1bIkNo.ttf",
        "100italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizHREVNn1dOx-zrZ2X3pZvkTiUa41YTi3TNgNq55w.ttf",
        "200": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizAREVNn1dOx-zrZ2X3pZvkTi3Q-hIzoVrBicOg.ttf",
        "200italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizGREVNn1dOx-zrZ2X3pZvkTiUa4_oyq17jjNOg_oc.ttf",
        "300": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizAREVNn1dOx-zrZ2X3pZvkTi20-RIzoVrBicOg.ttf",
        "300italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizGREVNn1dOx-zrZ2X3pZvkTiUa454xq17jjNOg_oc.ttf",
        "regular": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizDREVNn1dOx-zrZ2X3pZvkThUY0TY7ikbI.ttf",
        "italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizBREVNn1dOx-zrZ2X3pZvkTiUa2zIZj1bIkNo.ttf",
        "500": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizAREVNn1dOx-zrZ2X3pZvkTi3s-BIzoVrBicOg.ttf",
        "500italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizGREVNn1dOx-zrZ2X3pZvkTiUa48Ywq17jjNOg_oc.ttf",
        "600": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizAREVNn1dOx-zrZ2X3pZvkTi3A_xIzoVrBicOg.ttf",
        "600italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizGREVNn1dOx-zrZ2X3pZvkTiUa4-o3q17jjNOg_oc.ttf",
        "700": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizAREVNn1dOx-zrZ2X3pZvkTi2k_hIzoVrBicOg.ttf",
        "700italic": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizGREVNn1dOx-zrZ2X3pZvkTiUa4442q17jjNOg_oc.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibmplexserif/v19/jizDREVNn1dOx-zrZ2X3pZvkTiUZ2zI.ttf"
    },
    {
      "family": "IM Fell DW Pica",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfelldwpica/v16/2sDGZGRQotv9nbn2qSl0TxXVYNw9ZAPUvi88MQ.ttf",
        "italic": "https://fonts.gstatic.com/s/imfelldwpica/v16/2sDEZGRQotv9nbn2qSl0TxXVYNwNZgnQnCosMXm0.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfelldwpica/v16/2sDGZGRQotv9nbn2qSl0TxXVYNwNZQnQ.ttf"
    },
    {
      "family": "IM Fell DW Pica SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfelldwpicasc/v21/0ybjGCAu5PfqkvtGVU15aBhXz3EUrnTW-BiKEUiBGA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfelldwpicasc/v21/0ybjGCAu5PfqkvtGVU15aBhXz3EUrnTm-RKO.ttf"
    },
    {
      "family": "IM Fell Double Pica",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfelldoublepica/v14/3XF2EqMq_94s9PeKF7Fg4gOKINyMtZ8rT0S1UL5Ayp0.ttf",
        "italic": "https://fonts.gstatic.com/s/imfelldoublepica/v14/3XF0EqMq_94s9PeKF7Fg4gOKINyMtZ8rf0a_VJxF2p2G8g.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfelldoublepica/v14/3XF2EqMq_94s9PeKF7Fg4gOKINyMtZ8rf0W_VA.ttf"
    },
    {
      "family": "IM Fell Double Pica SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfelldoublepicasc/v21/neIazDmuiMkFo6zj_sHpQ8teNbWlwBB_hXjJ4Y0Eeru2dGg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfelldoublepicasc/v21/neIazDmuiMkFo6zj_sHpQ8teNbWlwBB_hXjJ0YwOfg.ttf"
    },
    {
      "family": "IM Fell English",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfellenglish/v14/Ktk1ALSLW8zDe0rthJysWrnLsAz3F6mZVY9Y5w.ttf",
        "italic": "https://fonts.gstatic.com/s/imfellenglish/v14/Ktk3ALSLW8zDe0rthJysWrnLsAzHFaOdd4pI59zg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfellenglish/v14/Ktk1ALSLW8zDe0rthJysWrnLsAzHFqOd.ttf"
    },
    {
      "family": "IM Fell English SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfellenglishsc/v16/a8IENpD3CDX-4zrWfr1VY879qFF05pZLO4gOg0shzA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfellenglishsc/v16/a8IENpD3CDX-4zrWfr1VY879qFF05pZ7OoIK.ttf"
    },
    {
      "family": "IM Fell French Canon",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfellfrenchcanon/v21/-F6ufiNtDWYfYc-tDiyiw08rrghJszkK6coVPt1ozoPz.ttf",
        "italic": "https://fonts.gstatic.com/s/imfellfrenchcanon/v21/-F6gfiNtDWYfYc-tDiyiw08rrghJszkK6foXNNlKy5PzzrU.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfellfrenchcanon/v21/-F6ufiNtDWYfYc-tDiyiw08rrghJszkK6foUNNk.ttf"
    },
    {
      "family": "IM Fell French Canon SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfellfrenchcanonsc/v22/FBVmdCru5-ifcor2bgq9V89khWcmQghEURY7H3c0UBCVIVqH.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfellfrenchcanonsc/v22/FBVmdCru5-ifcor2bgq9V89khWcmQghEURY7H0c1WhQ.ttf"
    },
    {
      "family": "IM Fell Great Primer",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfellgreatprimer/v21/bx6aNwSJtayYxOkbYFsT6hMsLzX7u85rJorXvDo3SQY1.ttf",
        "italic": "https://fonts.gstatic.com/s/imfellgreatprimer/v21/bx6UNwSJtayYxOkbYFsT6hMsLzX7u85rJrrVtj4VTBY1N6U.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfellgreatprimer/v21/bx6aNwSJtayYxOkbYFsT6hMsLzX7u85rJrrWtj4.ttf"
    },
    {
      "family": "IM Fell Great Primer SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imfellgreatprimersc/v21/ga6daxBOxyt6sCqz3fjZCTFCTUDMHagsQKdDTLf9BXz0s8FG.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imfellgreatprimersc/v21/ga6daxBOxyt6sCqz3fjZCTFCTUDMHagsQKdDTIf8D3g.ttf"
    },
    {
      "family": "Iansui",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-traditional",
        "latin",
        "latin-ext",
        "symbols2"
      ],
      "version": "v7",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/iansui/v7/w8gbH2UoTuUp5bOajSGD1FcXoQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/iansui/v7/w8gbH2UoTuUp5bOqjCuH.ttf"
    },
    {
      "family": "Ibarra Real Nova",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXdg5MDtVT9TWIvS.ttf",
        "500": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXdS5MDtVT9TWIvS.ttf",
        "600": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXe-48DtVT9TWIvS.ttf",
        "700": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXeH48DtVT9TWIvS.ttf",
        "italic": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKopyiuXztxXZvSkTo.ttf",
        "500italic": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKopxquXztxXZvSkTo.ttf",
        "600italic": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKop_apXztxXZvSkTo.ttf",
        "700italic": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKop8-pXztxXZvSkTo.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ibarrarealnova/v29/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXdg5PDsXzs.ttf"
    },
    {
      "family": "Iceberg",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/iceberg/v25/8QIJdijAiM7o-qnZuIgOq7jkAOw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/iceberg/v25/8QIJdijAiM7o-qnZiIkErw.ttf"
    },
    {
      "family": "Iceland",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/iceland/v21/rax9HiuFsdMNOnWPWKxGADBbg0s.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/iceland/v21/rax9HiuFsdMNOnWPaK1MBA.ttf"
    },
    {
      "family": "Imbue",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP8iWfOsNNK-Q4xY.ttf",
        "200": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP0iXfOsNNK-Q4xY.ttf",
        "300": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP5aXfOsNNK-Q4xY.ttf",
        "regular": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP8iXfOsNNK-Q4xY.ttf",
        "500": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP_qXfOsNNK-Q4xY.ttf",
        "600": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoPxaQfOsNNK-Q4xY.ttf",
        "700": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoPy-QfOsNNK-Q4xY.ttf",
        "800": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP0iQfOsNNK-Q4xY.ttf",
        "900": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP2GQfOsNNK-Q4xY.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imbue/v28/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP8iXTOoHMA.ttf"
    },
    {
      "family": "Imperial Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imperialscript/v7/5DCPAKrpzy_H98IV2ISnZBbGrVNvPenlvttWNg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imperialscript/v7/5DCPAKrpzy_H98IV2ISnZBbGrVNfPOPh.ttf"
    },
    {
      "family": "Imprima",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/imprima/v18/VEMxRoN7sY3yuy-7-oWHyDzktPo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/imprima/v18/VEMxRoN7sY3yuy-7yoSNzA.ttf"
    },
    {
      "family": "Inclusive Sans",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk8C9biPuwflXcJ46P4PGWE08T-gfZusL0kQqtfLhtN7mxtc0bIsQ.ttf",
        "regular": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk8C9biPuwflXcJ46P4PGWE08T-gfZusL0kQqtfcBtN7mxtc0bIsQ.ttf",
        "500": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk8C9biPuwflXcJ46P4PGWE08T-gfZusL0kQqtfQhtN7mxtc0bIsQ.ttf",
        "600": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk8C9biPuwflXcJ46P4PGWE08T-gfZusL0kQqtfrhxN7mxtc0bIsQ.ttf",
        "700": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk8C9biPuwflXcJ46P4PGWE08T-gfZusL0kQqtflxxN7mxtc0bIsQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk-C9biPuwflXcJ46P4PGWE0-73swm22da-7KxKuFj7rWZpUUPYsTVx.ttf",
        "italic": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk-C9biPuwflXcJ46P4PGWE0-73swm22da-7KxKuFilrWZpUUPYsTVx.ttf",
        "500italic": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk-C9biPuwflXcJ46P4PGWE0-73swm22da-7KxKuFiXrWZpUUPYsTVx.ttf",
        "600italic": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk-C9biPuwflXcJ46P4PGWE0-73swm22da-7KxKuFh7qmZpUUPYsTVx.ttf",
        "700italic": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk-C9biPuwflXcJ46P4PGWE0-73swm22da-7KxKuFhCqmZpUUPYsTVx.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inclusivesans/v3/0nk8C9biPuwflXcJ46P4PGWE08T-gfZusL0kQqtfcBt972Zp.ttf"
    },
    {
      "family": "Inconsolata",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v36",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7LppwU8aRr8lleY2co.ttf",
        "300": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp9s8aRr8lleY2co.ttf",
        "regular": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp4U8aRr8lleY2co.ttf",
        "500": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp7c8aRr8lleY2co.ttf",
        "600": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp1s7aRr8lleY2co.ttf",
        "700": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp2I7aRr8lleY2co.ttf",
        "800": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7LppwU7aRr8lleY2co.ttf",
        "900": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lppyw7aRr8lleY2co.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inconsolata/v36/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp4U8WRv2kg.ttf"
    },
    {
      "family": "Inder",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/inder/v14/w8gUH2YoQe8_4vq6pw-P3U4O.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inder/v14/w8gUH2YoQe8_4sq7rQs.ttf"
    },
    {
      "family": "Indie Flower",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/indieflower/v23/m8JVjfNVeKWVnh3QMuKkFcZlbkGG1dKEDw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/indieflower/v23/m8JVjfNVeKWVnh3QMuKkFcZVb0uC.ttf"
    },
    {
      "family": "Ingrid Darling",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ingriddarling/v6/LDIrapaJNxUtSuFdw-9yf4rCPsLOub458jGL.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ingriddarling/v6/LDIrapaJNxUtSuFdw-9yf4rCPvLPs7o.ttf"
    },
    {
      "family": "Inika",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/inika/v21/rnCm-x5X3QP-phTHRcc2s2XH.ttf",
        "700": "https://fonts.gstatic.com/s/inika/v21/rnCr-x5X3QP-pix7auM-mHnOSOuk.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inika/v21/rnCm-x5X3QP-piTGT8M.ttf"
    },
    {
      "family": "Inknut Antiqua",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-04-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GRYax7VC4ot_qNB4nYpBdaKU2vwrj5bBoIYJNf.ttf",
        "regular": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GSYax7VC4ot_qNB4nYpBdaKXUD6pzxRwYB.ttf",
        "500": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GRYax7VC4ot_qNB4nYpBdaKU33w7j5bBoIYJNf.ttf",
        "600": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GRYax7VC4ot_qNB4nYpBdaKU3bxLj5bBoIYJNf.ttf",
        "700": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GRYax7VC4ot_qNB4nYpBdaKU2_xbj5bBoIYJNf.ttf",
        "800": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GRYax7VC4ot_qNB4nYpBdaKU2jxrj5bBoIYJNf.ttf",
        "900": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GRYax7VC4ot_qNB4nYpBdaKU2Hx7j5bBoIYJNf.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inknutantiqua/v15/Y4GSYax7VC4ot_qNB4nYpBdaKUUC4Jg.ttf"
    },
    {
      "family": "Inria Sans",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/inriasans/v14/ptRPTiqXYfZMCOiVj9kQ3ELaDQtFqeY3fX4.ttf",
        "300italic": "https://fonts.gstatic.com/s/inriasans/v14/ptRRTiqXYfZMCOiVj9kQ1OzAgQlPrcQybX4pQA.ttf",
        "regular": "https://fonts.gstatic.com/s/inriasans/v14/ptRMTiqXYfZMCOiVj9kQ5O7yKQNute8.ttf",
        "italic": "https://fonts.gstatic.com/s/inriasans/v14/ptROTiqXYfZMCOiVj9kQ1Oz4LSFrpe8uZA.ttf",
        "700": "https://fonts.gstatic.com/s/inriasans/v14/ptRPTiqXYfZMCOiVj9kQ3FLdDQtFqeY3fX4.ttf",
        "700italic": "https://fonts.gstatic.com/s/inriasans/v14/ptRRTiqXYfZMCOiVj9kQ1OzAkQ5PrcQybX4pQA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inriasans/v14/ptRMTiqXYfZMCOiVj9kQ1O_4LQ.ttf"
    },
    {
      "family": "Inria Serif",
      "variants": [
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/inriaserif/v17/fC14PYxPY3rXxEndZJAzN3wAVQjFhFyta3xN.ttf",
        "300italic": "https://fonts.gstatic.com/s/inriaserif/v17/fC16PYxPY3rXxEndZJAzN3SuT4THjliPbmxN0_E.ttf",
        "regular": "https://fonts.gstatic.com/s/inriaserif/v17/fC1lPYxPY3rXxEndZJAzN0SsfSzNr0Ck.ttf",
        "italic": "https://fonts.gstatic.com/s/inriaserif/v17/fC1nPYxPY3rXxEndZJAzN3SudyjvqlCkcmU.ttf",
        "700": "https://fonts.gstatic.com/s/inriaserif/v17/fC14PYxPY3rXxEndZJAzN3wQUgjFhFyta3xN.ttf",
        "700italic": "https://fonts.gstatic.com/s/inriaserif/v17/fC16PYxPY3rXxEndZJAzN3SuT5TAjliPbmxN0_E.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inriaserif/v17/fC1lPYxPY3rXxEndZJAzN3Stdyg.ttf"
    },
    {
      "family": "Inspiration",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/inspiration/v7/x3dkckPPZa6L4wIg5cZOEvoGnSrlBBsy.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inspiration/v7/x3dkckPPZa6L4wIg5cZOEsoHly4.ttf"
    },
    {
      "family": "Instrument Sans",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/instrumentsans/v3/pximypc9vsFDm051Uf6KVwgkfoSxQ0GsQv8ToedPibnr-yp2JGEJOH9npSTF-Qf1mS0v3_7Y.ttf",
        "500": "https://fonts.gstatic.com/s/instrumentsans/v3/pximypc9vsFDm051Uf6KVwgkfoSxQ0GsQv8ToedPibnr-yp2JGEJOH9npST3-Qf1mS0v3_7Y.ttf",
        "600": "https://fonts.gstatic.com/s/instrumentsans/v3/pximypc9vsFDm051Uf6KVwgkfoSxQ0GsQv8ToedPibnr-yp2JGEJOH9npSQb_gf1mS0v3_7Y.ttf",
        "700": "https://fonts.gstatic.com/s/instrumentsans/v3/pximypc9vsFDm051Uf6KVwgkfoSxQ0GsQv8ToedPibnr-yp2JGEJOH9npSQi_gf1mS0v3_7Y.ttf",
        "italic": "https://fonts.gstatic.com/s/instrumentsans/v3/pxigypc9vsFDm051Uf6KVwgkfoSbSnNPooZAN0lInHGpCWNE27lgU-XJojENuu-2kykN2u7YUwU.ttf",
        "500italic": "https://fonts.gstatic.com/s/instrumentsans/v3/pxigypc9vsFDm051Uf6KVwgkfoSbSnNPooZAN0lInHGpCWNE27lgU-XJojENut22kykN2u7YUwU.ttf",
        "600italic": "https://fonts.gstatic.com/s/instrumentsans/v3/pxigypc9vsFDm051Uf6KVwgkfoSbSnNPooZAN0lInHGpCWNE27lgU-XJojENujGxkykN2u7YUwU.ttf",
        "700italic": "https://fonts.gstatic.com/s/instrumentsans/v3/pxigypc9vsFDm051Uf6KVwgkfoSbSnNPooZAN0lInHGpCWNE27lgU-XJojENugixkykN2u7YUwU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/instrumentsans/v3/pximypc9vsFDm051Uf6KVwgkfoSxQ0GsQv8ToedPibnr-yp2JGEJOH9npSTF-Tf0kyk.ttf"
    },
    {
      "family": "Instrument Serif",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/instrumentserif/v4/jizBRFtNs2ka5fXjeivQ4LroWlx-2zIZj1bIkNo.ttf",
        "italic": "https://fonts.gstatic.com/s/instrumentserif/v4/jizHRFtNs2ka5fXjeivQ4LroWlx-6zATi3TNgNq55w.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/instrumentserif/v4/jizBRFtNs2ka5fXjeivQ4LroWlx-6zMTiw.ttf"
    },
    {
      "family": "Inter",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuLyeMZhrib2Bg-4.ttf",
        "200": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuDyfMZhrib2Bg-4.ttf",
        "300": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuOKfMZhrib2Bg-4.ttf",
        "regular": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuLyfMZhrib2Bg-4.ttf",
        "500": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuI6fMZhrib2Bg-4.ttf",
        "600": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuGKYMZhrib2Bg-4.ttf",
        "700": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuFuYMZhrib2Bg-4.ttf",
        "800": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuDyYMZhrib2Bg-4.ttf",
        "900": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuBWYMZhrib2Bg-4.ttf",
        "100italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTc2dphjZ-Ek-7MeA.ttf",
        "200italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTcWdthjZ-Ek-7MeA.ttf",
        "300italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTch9thjZ-Ek-7MeA.ttf",
        "italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTc2dthjZ-Ek-7MeA.ttf",
        "500italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTc69thjZ-Ek-7MeA.ttf",
        "600italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTcB9xhjZ-Ek-7MeA.ttf",
        "700italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTcPtxhjZ-Ek-7MeA.ttf",
        "800italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTcWdxhjZ-Ek-7MeA.ttf",
        "900italic": "https://fonts.gstatic.com/s/inter/v19/UcCM3FwrK3iLTcvneQg7Ca725JhhKnNqk4j1ebLhAm8SrXTccNxhjZ-Ek-7MeA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/inter/v19/UcCO3FwrK3iLTeHuS_nVMrMxCp50SjIw2boKoduKmMEVuLyfAZlhjQ.ttf"
    },
    {
      "family": "Inter Tight",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjDw6qXCRToK8EPg.ttf",
        "200": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjjw-qXCRToK8EPg.ttf",
        "300": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjUQ-qXCRToK8EPg.ttf",
        "regular": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjDw-qXCRToK8EPg.ttf",
        "500": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjPQ-qXCRToK8EPg.ttf",
        "600": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mj0QiqXCRToK8EPg.ttf",
        "700": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mj6AiqXCRToK8EPg.ttf",
        "800": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjjwiqXCRToK8EPg.ttf",
        "900": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjpgiqXCRToK8EPg.ttf",
        "100italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0xCHi5XgqoUPvi5.ttf",
        "200italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0zCHy5XgqoUPvi5.ttf",
        "300italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0wcHy5XgqoUPvi5.ttf",
        "italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0xCHy5XgqoUPvi5.ttf",
        "500italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0xwHy5XgqoUPvi5.ttf",
        "600italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0ycGC5XgqoUPvi5.ttf",
        "700italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0ylGC5XgqoUPvi5.ttf",
        "800italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0zCGC5XgqoUPvi5.ttf",
        "900italic": "https://fonts.gstatic.com/s/intertight/v8/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0zrGC5XgqoUPvi5.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/intertight/v8/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjDw-aXS5X.ttf"
    },
    {
      "family": "Irish Grover",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/irishgrover/v23/buExpoi6YtLz2QW7LA4flVgf-P5Oaiw4cw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/irishgrover/v23/buExpoi6YtLz2QW7LA4flVgv-fRK.ttf"
    },
    {
      "family": "Island Moments",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/islandmoments/v7/NaPBcZfVGvBdxIt7Ar0qzkXJF-TGIohbZ6SY.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/islandmoments/v7/NaPBcZfVGvBdxIt7Ar0qzkXJF9THKIw.ttf"
    },
    {
      "family": "Istok Web",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/istokweb/v25/3qTvojGmgSyUukBzKslZAWF-9kIIaQ.ttf",
        "italic": "https://fonts.gstatic.com/s/istokweb/v25/3qTpojGmgSyUukBzKslpA2t61EcYaQ7F.ttf",
        "700": "https://fonts.gstatic.com/s/istokweb/v25/3qTqojGmgSyUukBzKslhvU5a_mkUYBfcMw.ttf",
        "700italic": "https://fonts.gstatic.com/s/istokweb/v25/3qT0ojGmgSyUukBzKslpA1PG-2MQQhLMMygN.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/istokweb/v25/3qTvojGmgSyUukBzKslpAGt6.ttf"
    },
    {
      "family": "Italiana",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/italiana/v21/QldNNTtLsx4E__B0XTmRY31Wx7Vv.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/italiana/v21/QldNNTtLsx4E__B0XQmQaXk.ttf"
    },
    {
      "family": "Italianno",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/italianno/v17/dg4n_p3sv6gCJkwzT6Rnj5YpQwM-gg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/italianno/v17/dg4n_p3sv6gCJkwzT6RXjpwt.ttf"
    },
    {
      "family": "Itim",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/itim/v15/0nknC9ziJOYewARKkc7ZdwU.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/itim/v15/0nknC9ziJOYe8AVAlQ.ttf"
    },
    {
      "family": "Jacquard 12",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v7",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquard12/v7/vm8ydRLuXETEweL79J4rGc3JUnr34c9-.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquard12/v7/vm8ydRLuXETEweL79J4rGf3IWH4.ttf"
    },
    {
      "family": "Jacquard 12 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquard12charted/v3/i7dWIE97bzCOB9Q_Up6PQmYfKDPIb2HwT3StZ9jetKY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquard12charted/v3/i7dWIE97bzCOB9Q_Up6PQmYfKDPIb2Hwf3WnYw.ttf"
    },
    {
      "family": "Jacquard 24",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquard24/v3/jVyO7nf_B2zO5jVpUGU8lgQEdchf9xXp.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquard24/v3/jVyO7nf_B2zO5jVpUGU8ljQFf8w.ttf"
    },
    {
      "family": "Jacquard 24 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquard24charted/v4/mtGm4-dNK6HaudrE9VVKhENTsEXEYish0iRrMYJ_K-4.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquard24charted/v4/mtGm4-dNK6HaudrE9VVKhENTsEXEYish4iVhNQ.ttf"
    },
    {
      "family": "Jacquarda Bastarda 9",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v5",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquardabastarda9/v5/f0Xp0fWr_8t6WFtKQJfOhaC0hcZ1HYAMAbwD1TB_JHHY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquardabastarda9/v5/f0Xp0fWr_8t6WFtKQJfOhaC0hcZ1HYAMAYwC3zQ.ttf"
    },
    {
      "family": "Jacquarda Bastarda 9 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquardabastarda9charted/v3/Yq6D-KaMUyfq4qLgx19A_ocp43FeLd9m0vDxm-yf8JPuf0cPaL8pmQg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquardabastarda9charted/v3/Yq6D-KaMUyfq4qLgx19A_ocp43FeLd9m0vDxm-yf8JPuT0YFbA.ttf"
    },
    {
      "family": "Jacques Francois",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquesfrancois/v25/ZXu9e04ZvKeOOHIe1TMahbcIU2cgmcPqoeRWfbs.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquesfrancois/v25/ZXu9e04ZvKeOOHIe1TMahbcIU2cgqcLgpQ.ttf"
    },
    {
      "family": "Jacques Francois Shadow",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jacquesfrancoisshadow/v26/KR1FBtOz8PKTMk-kqdkLVrvR0ECFrB6Pin-2_q8VsHuV5ULS.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jacquesfrancoisshadow/v26/KR1FBtOz8PKTMk-kqdkLVrvR0ECFrB6Pin-2_p8Uun8.ttf"
    },
    {
      "family": "Jaini",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jaini/v1/fC1vPYJMbGHQzEmOK-ZSUHyt.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jaini/v1/fC1vPYJMbGHQzHmPIeI.ttf"
    },
    {
      "family": "Jaini Purva",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jainipurva/v1/CHynV-vdHVXwbWcUswbUGHoOHH4sj3lR.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jainipurva/v1/CHynV-vdHVXwbWcUswbUGEoPFno.ttf"
    },
    {
      "family": "Jaldi",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jaldi/v13/or3sQ67z0_CI30NUZpD_B6g8.ttf",
        "700": "https://fonts.gstatic.com/s/jaldi/v13/or3hQ67z0_CI33voSbT3LLQ1niPn.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jaldi/v13/or3sQ67z0_CI33NVbJQ.ttf"
    },
    {
      "family": "Jaro",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jaro/v7/ea8DadQwV_r_Rv3-7zZMCGhQgVr1SlCsNP3VpQ_a.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jaro/v7/ea8DadQwV_r_Rv3-7zZMCGhQgVr1SmCtPvk.ttf"
    },
    {
      "family": "Jersey 10",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey10/v3/GftH7vZKsggXMf9n_J5X-JLgy1wtSw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey10/v3/GftH7vZKsggXMf9n_J5n-Zjk.ttf"
    },
    {
      "family": "Jersey 10 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey10charted/v3/oY1E8fPFr6XiNWqEp90XSbwUGfF8SnedKmeBvEYs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey10charted/v3/oY1E8fPFr6XiNWqEp90XSbwUGfF8SkecIGM.ttf"
    },
    {
      "family": "Jersey 15",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey15/v3/_6_9EDzuROGsUuk2TWjSYoohsCkvSQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey15/v3/_6_9EDzuROGsUuk2TWjiY4Al.ttf"
    },
    {
      "family": "Jersey 15 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey15charted/v3/nuFjD-rCQIjoVp1Sva2ToCTudGbLeRv4r2024gxi.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey15charted/v3/nuFjD-rCQIjoVp1Sva2ToCTudGbLeSv5pWk.ttf"
    },
    {
      "family": "Jersey 20",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey20/v3/ZgNRjP1ON6jeW4D12z3crE_qP4mXuQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey20/v3/ZgNRjP1ON6jeW4D12z3srUXu.ttf"
    },
    {
      "family": "Jersey 20 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey20charted/v3/JTUNjJMy9DKq5FzVaj9tpgYgvHqGn_Z1ji-rqnQ_.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey20charted/v3/JTUNjJMy9DKq5FzVaj9tpgYgvHqGn8Z0hCs.ttf"
    },
    {
      "family": "Jersey 25",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey25/v3/ll8-K2eeXj2tAs6F9BXIJ4AMng8ChA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey25/v3/ll8-K2eeXj2tAs6F9BX4JooI.ttf"
    },
    {
      "family": "Jersey 25 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jersey25charted/v2/6NUM8EWHIhCWbxOqtLkv94Rlu6EkGv2uUGQW93Cg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jersey25charted/v2/6NUM8EWHIhCWbxOqtLkv94Rlu6EkGs2vWmA.ttf"
    },
    {
      "family": "JetBrains Mono",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8yK1jPVmUsaaDhw.ttf",
        "200": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8SKxjPVmUsaaDhw.ttf",
        "300": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8lqxjPVmUsaaDhw.ttf",
        "regular": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8yKxjPVmUsaaDhw.ttf",
        "500": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8-qxjPVmUsaaDhw.ttf",
        "600": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8FqtjPVmUsaaDhw.ttf",
        "700": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8L6tjPVmUsaaDhw.ttf",
        "800": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8SKtjPVmUsaaDhw.ttf",
        "100italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO-Lf1OQk6OThxPA.ttf",
        "200italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO8LflOQk6OThxPA.ttf",
        "300italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO_VflOQk6OThxPA.ttf",
        "italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO-LflOQk6OThxPA.ttf",
        "500italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO-5flOQk6OThxPA.ttf",
        "600italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO9VeVOQk6OThxPA.ttf",
        "700italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO9seVOQk6OThxPA.ttf",
        "800italic": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO8LeVOQk6OThxPA.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jetbrainsmono/v23/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8yKxTPFOQ.ttf"
    },
    {
      "family": "Jim Nightshade",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jimnightshade/v20/PlIkFlu9Pb08Q8HLM1PxmB0g-OS4V3qKaMxD.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jimnightshade/v20/PlIkFlu9Pb08Q8HLM1PxmB0g-NS5XX4.ttf"
    },
    {
      "family": "Joan",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/joan/v11/ZXupe1oZsqWRbRdH8X1p_Ng.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/joan/v11/ZXupe1oZsqWRXRZN9Q.ttf"
    },
    {
      "family": "Jockey One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jockeyone/v22/HTxpL2g2KjCFj4x8WI6ArIb7HYOk4xc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jockeyone/v22/HTxpL2g2KjCFj4x8WI6AnIfxGQ.ttf"
    },
    {
      "family": "Jolly Lodger",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jollylodger/v20/BXRsvFTAh_bGkA1uQ48dlB3VWerT3ZyuqA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jollylodger/v20/BXRsvFTAh_bGkA1uQ48dlB3lWODX.ttf"
    },
    {
      "family": "Jomhuria",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jomhuria/v22/Dxxp8j-TMXf-llKur2b1MOGbC3Dh.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jomhuria/v22/Dxxp8j-TMXf-llKur1b0OuU.ttf"
    },
    {
      "family": "Jomolhari",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "tibetan"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jomolhari/v20/EvONzA1M1Iw_CBd2hsQCF1IZKq5INg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jomolhari/v20/EvONzA1M1Iw_CBd2hsQyFlgd.ttf"
    },
    {
      "family": "Josefin Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v33",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_DjRXMFrLgTsQV0.ttf",
        "200": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_LjQXMFrLgTsQV0.ttf",
        "300": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_GbQXMFrLgTsQV0.ttf",
        "regular": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_DjQXMFrLgTsQV0.ttf",
        "500": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_ArQXMFrLgTsQV0.ttf",
        "600": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_ObXXMFrLgTsQV0.ttf",
        "700": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_N_XXMFrLgTsQV0.ttf",
        "100italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTtINhKibpUV3MEQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTNIJhKibpUV3MEQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCT6oJhKibpUV3MEQ.ttf",
        "italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTtIJhKibpUV3MEQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCThoJhKibpUV3MEQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTaoVhKibpUV3MEQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTU4VhKibpUV3MEQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/josefinsans/v33/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_DjQbMBhKg.ttf"
    },
    {
      "family": "Josefin Slab",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W71mtd3k3K6CcEyI.ttf",
        "200": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W79msd3k3K6CcEyI.ttf",
        "300": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W7wesd3k3K6CcEyI.ttf",
        "regular": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W71msd3k3K6CcEyI.ttf",
        "500": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W72usd3k3K6CcEyI.ttf",
        "600": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W74erd3k3K6CcEyI.ttf",
        "700": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W776rd3k3K6CcEyI.ttf",
        "100italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvnzs9L4KZAyK43w.ttf",
        "200italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvHzo9L4KZAyK43w.ttf",
        "300italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvwTo9L4KZAyK43w.ttf",
        "italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvnzo9L4KZAyK43w.ttf",
        "500italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvrTo9L4KZAyK43w.ttf",
        "600italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvQT09L4KZAyK43w.ttf",
        "700italic": "https://fonts.gstatic.com/s/josefinslab/v28/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHveD09L4KZAyK43w.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/josefinslab/v28/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W71msR3g9Lw.ttf"
    },
    {
      "family": "Jost",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7myjJAVGPokMmuHL.ttf",
        "200": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7mwjJQVGPokMmuHL.ttf",
        "300": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7mz9JQVGPokMmuHL.ttf",
        "regular": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7myjJQVGPokMmuHL.ttf",
        "500": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7myRJQVGPokMmuHL.ttf",
        "600": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7mx9IgVGPokMmuHL.ttf",
        "700": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7mxEIgVGPokMmuHL.ttf",
        "800": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7mwjIgVGPokMmuHL.ttf",
        "900": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7mwKIgVGPokMmuHL.ttf",
        "100italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZu0ENI0un_HLMEo.ttf",
        "200italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZm0FNI0un_HLMEo.ttf",
        "300italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZrMFNI0un_HLMEo.ttf",
        "italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZu0FNI0un_HLMEo.ttf",
        "500italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZt8FNI0un_HLMEo.ttf",
        "600italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZjMCNI0un_HLMEo.ttf",
        "700italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZgoCNI0un_HLMEo.ttf",
        "800italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZm0CNI0un_HLMEo.ttf",
        "900italic": "https://fonts.gstatic.com/s/jost/v19/92zJtBhPNqw73oHH7BbQp4-B6XlrZkQCNI0un_HLMEo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jost/v19/92zPtBhPNqw79Ij1E865zBUv7myjJTVHNI0.ttf"
    },
    {
      "family": "Joti One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jotione/v27/Z9XVDmdJQAmWm9TwaYTe4u2El6GC.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jotione/v27/Z9XVDmdJQAmWm9TwabTf6Ok.ttf"
    },
    {
      "family": "Jua",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/jua/v17/co3KmW9ljjAjc-DZCsKgsg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jua/v17/co3KmW9ljjATcurd.ttf"
    },
    {
      "family": "Judson",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/judson/v19/FeVRS0Fbvbc14VxRD7N01bV7kg.ttf",
        "italic": "https://fonts.gstatic.com/s/judson/v19/FeVTS0Fbvbc14VxhDblw97BrknZf.ttf",
        "700": "https://fonts.gstatic.com/s/judson/v19/FeVSS0Fbvbc14Vxps5xQ3Z5nm29Gww.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/judson/v19/FeVRS0Fbvbc14VxhDrlw.ttf"
    },
    {
      "family": "Julee",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/julee/v25/TuGfUVB3RpZPQ6ZLodgzydtk.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/julee/v25/TuGfUVB3RpZPQ5ZKq9w.ttf"
    },
    {
      "family": "Julius Sans One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/juliussansone/v19/1Pt2g8TAX_SGgBGUi0tGOYEga5W-xXEW6aGXHw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/juliussansone/v19/1Pt2g8TAX_SGgBGUi0tGOYEga5WOxHsS.ttf"
    },
    {
      "family": "Junge",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/junge/v25/gokgH670Gl1lUqAdvhB7SnKm.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/junge/v25/gokgH670Gl1lUpActBQ.ttf"
    },
    {
      "family": "Jura",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "kayah-li",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v33",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/jura/v33/z7NOdRfiaC4Vd8hhoPzfb5vBTP0D7auhTfmrH_rt.ttf",
        "regular": "https://fonts.gstatic.com/s/jura/v33/z7NOdRfiaC4Vd8hhoPzfb5vBTP1d7auhTfmrH_rt.ttf",
        "500": "https://fonts.gstatic.com/s/jura/v33/z7NOdRfiaC4Vd8hhoPzfb5vBTP1v7auhTfmrH_rt.ttf",
        "600": "https://fonts.gstatic.com/s/jura/v33/z7NOdRfiaC4Vd8hhoPzfb5vBTP2D6quhTfmrH_rt.ttf",
        "700": "https://fonts.gstatic.com/s/jura/v33/z7NOdRfiaC4Vd8hhoPzfb5vBTP266quhTfmrH_rt.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/jura/v33/z7NOdRfiaC4Vd8hhoPzfb5vBTP1d7ZugR_0.ttf"
    },
    {
      "family": "Just Another Hand",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/justanotherhand/v20/845CNN4-AJyIGvIou-6yJKyptyOpOcr_BmmlS5aw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/justanotherhand/v20/845CNN4-AJyIGvIou-6yJKyptyOpOfr-DG0.ttf"
    },
    {
      "family": "Just Me Again Down Here",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/justmeagaindownhere/v24/MwQmbgXtz-Wc6RUEGNMc0QpRrfUh2hSdBBMoAuwHvqDwc_fg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/justmeagaindownhere/v24/MwQmbgXtz-Wc6RUEGNMc0QpRrfUh2hSdBBMoAtwGtKQ.ttf"
    },
    {
      "family": "K2D",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/k2d/v12/J7aRnpF2V0ErE6UpvrIw74NL.ttf",
        "100italic": "https://fonts.gstatic.com/s/k2d/v12/J7afnpF2V0EjdZ1NtLYS6pNLAjk.ttf",
        "200": "https://fonts.gstatic.com/s/k2d/v12/J7aenpF2V0Erv4QJlJw85ppSGw.ttf",
        "200italic": "https://fonts.gstatic.com/s/k2d/v12/J7acnpF2V0EjdZ3hlZY4xJ9CGyAa.ttf",
        "300": "https://fonts.gstatic.com/s/k2d/v12/J7aenpF2V0Er24cJlJw85ppSGw.ttf",
        "300italic": "https://fonts.gstatic.com/s/k2d/v12/J7acnpF2V0EjdZ2FlpY4xJ9CGyAa.ttf",
        "regular": "https://fonts.gstatic.com/s/k2d/v12/J7aTnpF2V0ETd68tnLcg7w.ttf",
        "italic": "https://fonts.gstatic.com/s/k2d/v12/J7aRnpF2V0EjdaUpvrIw74NL.ttf",
        "500": "https://fonts.gstatic.com/s/k2d/v12/J7aenpF2V0Erg4YJlJw85ppSGw.ttf",
        "500italic": "https://fonts.gstatic.com/s/k2d/v12/J7acnpF2V0EjdZ3dl5Y4xJ9CGyAa.ttf",
        "600": "https://fonts.gstatic.com/s/k2d/v12/J7aenpF2V0Err4EJlJw85ppSGw.ttf",
        "600italic": "https://fonts.gstatic.com/s/k2d/v12/J7acnpF2V0EjdZ3xkJY4xJ9CGyAa.ttf",
        "700": "https://fonts.gstatic.com/s/k2d/v12/J7aenpF2V0Ery4AJlJw85ppSGw.ttf",
        "700italic": "https://fonts.gstatic.com/s/k2d/v12/J7acnpF2V0EjdZ2VkZY4xJ9CGyAa.ttf",
        "800": "https://fonts.gstatic.com/s/k2d/v12/J7aenpF2V0Er14MJlJw85ppSGw.ttf",
        "800italic": "https://fonts.gstatic.com/s/k2d/v12/J7acnpF2V0EjdZ2JkpY4xJ9CGyAa.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/k2d/v12/J7aTnpF2V0EjdqUp.ttf"
    },
    {
      "family": "Kablammo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "emoji",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kablammo/v3/bWtm7fHPcgrhC-J3lcXhcQTY5Ixs6Au9YgCjjx0Rf4YDKw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kablammo/v3/bWtm7fHPcgrhC-J3lcXhcQTY5Ixs6Au9YgCTjhcV.ttf"
    },
    {
      "family": "Kadwa",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kadwa/v12/rnCm-x5V0g7iphTHRcc2s2XH.ttf",
        "700": "https://fonts.gstatic.com/s/kadwa/v12/rnCr-x5V0g7ipix7auM-mHnOSOuk.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kadwa/v12/rnCm-x5V0g7ipiTGT8M.ttf"
    },
    {
      "family": "Kaisei Decol",
      "variants": [
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kaiseidecol/v10/bMrwmSqP45sidWf3QmfFW6iyW1EP22OjoA.ttf",
        "500": "https://fonts.gstatic.com/s/kaiseidecol/v10/bMrvmSqP45sidWf3QmfFW6iKr3gr00i_qb57kA.ttf",
        "700": "https://fonts.gstatic.com/s/kaiseidecol/v10/bMrvmSqP45sidWf3QmfFW6iK534r00i_qb57kA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kaiseidecol/v10/bMrwmSqP45sidWf3QmfFW6iCWlsL.ttf"
    },
    {
      "family": "Kaisei HarunoUmi",
      "variants": [
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kaiseiharunoumi/v10/HI_RiZQSLqBQoAHhK_C6N_nzy_jcGsv5sM8u3mk.ttf",
        "500": "https://fonts.gstatic.com/s/kaiseiharunoumi/v10/HI_WiZQSLqBQoAHhK_C6N_nzy_jcIj_QlMcFwmC9FAU.ttf",
        "700": "https://fonts.gstatic.com/s/kaiseiharunoumi/v10/HI_WiZQSLqBQoAHhK_C6N_nzy_jcInfWlMcFwmC9FAU.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kaiseiharunoumi/v10/HI_RiZQSLqBQoAHhK_C6N_nzy_jcKsrztA.ttf"
    },
    {
      "family": "Kaisei Opti",
      "variants": [
        "regular",
        "500",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kaiseiopti/v10/QldKNThJphYb8_g6c2nlIFle7KlmxuHx.ttf",
        "500": "https://fonts.gstatic.com/s/kaiseiopti/v10/QldXNThJphYb8_g6c2nlIGGqxY1u7f34DYwn.ttf",
        "700": "https://fonts.gstatic.com/s/kaiseiopti/v10/QldXNThJphYb8_g6c2nlIGHiw41u7f34DYwn.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kaiseiopti/v10/QldKNThJphYb8_g6c2nlIGlf5q0.ttf"
    },
    {
      "family": "Kaisei Tokumin",
      "variants": [
        "regular",
        "500",
        "700",
        "800"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kaiseitokumin/v10/Gg8sN5wdZg7xCwuMsylww2ZiQkJf1l0pj946.ttf",
        "500": "https://fonts.gstatic.com/s/kaiseitokumin/v10/Gg8vN5wdZg7xCwuMsylww2ZiQnqr_3khpMIzeI6v.ttf",
        "700": "https://fonts.gstatic.com/s/kaiseitokumin/v10/Gg8vN5wdZg7xCwuMsylww2ZiQnrj-XkhpMIzeI6v.ttf",
        "800": "https://fonts.gstatic.com/s/kaiseitokumin/v10/Gg8vN5wdZg7xCwuMsylww2ZiQnr_-nkhpMIzeI6v.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kaiseitokumin/v10/Gg8sN5wdZg7xCwuMsylww2ZiQnJe3Fk.ttf"
    },
    {
      "family": "Kalam",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/kalam/v17/YA9Qr0Wd4kDdMtD6GgLLmCUItqGt.ttf",
        "regular": "https://fonts.gstatic.com/s/kalam/v17/YA9dr0Wd4kDdMuhWMibDszkB.ttf",
        "700": "https://fonts.gstatic.com/s/kalam/v17/YA9Qr0Wd4kDdMtDqHQLLmCUItqGt.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kalam/v17/YA9dr0Wd4kDdMthXOCI.ttf"
    },
    {
      "family": "Kalnia",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math"
      ],
      "version": "v5",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW9il2xRGNcykIZc.ttf",
        "200": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW_ilmxRGNcykIZc.ttf",
        "300": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW88lmxRGNcykIZc.ttf",
        "regular": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW9ilmxRGNcykIZc.ttf",
        "500": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW9QlmxRGNcykIZc.ttf",
        "600": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW-8kWxRGNcykIZc.ttf",
        "700": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW-FkWxRGNcykIZc.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kalnia/v5/11hqGpPCwUbbYwZZP0RBuDY62BQZhjvOytM_sLzi-TFWAW9illxQEtM.ttf"
    },
    {
      "family": "Kalnia Glaze",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYdL63nZKfhpVTvN.ttf",
        "200": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYfL6nnZKfhpVTvN.ttf",
        "300": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYcV6nnZKfhpVTvN.ttf",
        "regular": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYdL6nnZKfhpVTvN.ttf",
        "500": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYd56nnZKfhpVTvN.ttf",
        "600": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYeV7XnZKfhpVTvN.ttf",
        "700": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYes7XnZKfhpVTvN.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kalniaglaze/v4/wlpQgwHCBUNjrGrfu-hwowN1YyC-42Lu26VHf2LtOkAod0wTxm2tFYdL6knYI_w.ttf",
      "colorCapabilities": [
        "COLRv1"
      ]
    },
    {
      "family": "Kameron",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kameron/v17/vm8pdR7vXErQxuznqrUS3z1Uw3nq4Ne3cbcbvZPxCDLR.ttf",
        "500": "https://fonts.gstatic.com/s/kameron/v17/vm8pdR7vXErQxuznqrUS3z1Uw3nq4NeFcbcbvZPxCDLR.ttf",
        "600": "https://fonts.gstatic.com/s/kameron/v17/vm8pdR7vXErQxuznqrUS3z1Uw3nq4NdpdrcbvZPxCDLR.ttf",
        "700": "https://fonts.gstatic.com/s/kameron/v17/vm8pdR7vXErQxuznqrUS3z1Uw3nq4NdQdrcbvZPxCDLR.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kameron/v17/vm8pdR7vXErQxuznqrUS3z1Uw3nq4Ne3cYcat5c.ttf"
    },
    {
      "family": "Kanchenjunga",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "kirat-rai",
        "latin"
      ],
      "version": "v2",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kanchenjunga/v2/RWmPoKKd5fUmrILiWsjCI6TiqYsGBGBzCw.ttf",
        "500": "https://fonts.gstatic.com/s/kanchenjunga/v2/RWmQoKKd5fUmrILiWsjCI6TaXaIiDEtvAlaMKw.ttf",
        "600": "https://fonts.gstatic.com/s/kanchenjunga/v2/RWmQoKKd5fUmrILiWsjCI6TacaUiDEtvAlaMKw.ttf",
        "700": "https://fonts.gstatic.com/s/kanchenjunga/v2/RWmQoKKd5fUmrILiWsjCI6TaFaQiDEtvAlaMKw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kanchenjunga/v2/RWmPoKKd5fUmrILiWsjCI6TSqIEC.ttf"
    },
    {
      "family": "Kanit",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-04-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/kanit/v16/nKKX-Go6G5tXcr72GwWKcaxALFs.ttf",
        "100italic": "https://fonts.gstatic.com/s/kanit/v16/nKKV-Go6G5tXcraQI2GAdY5FPFtrGw.ttf",
        "200": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr5aOiWgX6BJNUJy.ttf",
        "200italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI82hVaRrMFJyAu4.ttf",
        "300": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr4-OSWgX6BJNUJy.ttf",
        "300italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI6miVaRrMFJyAu4.ttf",
        "regular": "https://fonts.gstatic.com/s/kanit/v16/nKKZ-Go6G5tXcoaSEQGodLxA.ttf",
        "italic": "https://fonts.gstatic.com/s/kanit/v16/nKKX-Go6G5tXcraQGwWKcaxALFs.ttf",
        "500": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr5mOCWgX6BJNUJy.ttf",
        "500italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI_GjVaRrMFJyAu4.ttf",
        "600": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr5KPyWgX6BJNUJy.ttf",
        "600italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI92kVaRrMFJyAu4.ttf",
        "700": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr4uPiWgX6BJNUJy.ttf",
        "700italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI7mlVaRrMFJyAu4.ttf",
        "800": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr4yPSWgX6BJNUJy.ttf",
        "800italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI6WmVaRrMFJyAu4.ttf",
        "900": "https://fonts.gstatic.com/s/kanit/v16/nKKU-Go6G5tXcr4WPCWgX6BJNUJy.ttf",
        "900italic": "https://fonts.gstatic.com/s/kanit/v16/nKKS-Go6G5tXcraQI4GnVaRrMFJyAu4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kanit/v16/nKKZ-Go6G5tXcraTGwU.ttf"
    },
    {
      "family": "Kantumruy Pro",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "khmer",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1urUs0M34dR6dW.ttf",
        "200": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg3urEs0M34dR6dW.ttf",
        "300": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg0wrEs0M34dR6dW.ttf",
        "regular": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1urEs0M34dR6dW.ttf",
        "500": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1crEs0M34dR6dW.ttf",
        "600": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg2wq0s0M34dR6dW.ttf",
        "700": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg2Jq0s0M34dR6dW.ttf",
        "100italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim76N2OXo_QrdWlcU.ttf",
        "200italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim7yN3OXo_QrdWlcU.ttf",
        "300italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim7_13OXo_QrdWlcU.ttf",
        "italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim76N3OXo_QrdWlcU.ttf",
        "500italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim75F3OXo_QrdWlcU.ttf",
        "600italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim731wOXo_QrdWlcU.ttf",
        "700italic": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim70RwOXo_QrdWlcU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kantumruypro/v11/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1urHs1OXo.ttf"
    },
    {
      "family": "Kapakana",
      "variants": [
        "300",
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-11",
      "files": {
        "300": "https://fonts.gstatic.com/s/kapakana/v18/sykt-yN0m6InS7OD9BCc9iYVO-6XOlDixNA5tRbXZ4IXAA.ttf",
        "regular": "https://fonts.gstatic.com/s/kapakana/v18/sykt-yN0m6InS7OD9BCc9iYVO-6XOlDimtA5tRbXZ4IXAA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kapakana/v18/sykt-yN0m6InS7OD9BCc9iYVO-6XOlDimtAJtBzT.ttf"
    },
    {
      "family": "Karantina",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "300": "https://fonts.gstatic.com/s/karantina/v12/buExpo24ccnh31GVMABxXCgf-P5Oaiw4cw.ttf",
        "regular": "https://fonts.gstatic.com/s/karantina/v12/buE0po24ccnh31GVMABJ8AA78NVSYw.ttf",
        "700": "https://fonts.gstatic.com/s/karantina/v12/buExpo24ccnh31GVMABxTC8f-P5Oaiw4cw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/karantina/v12/buE0po24ccnh31GVMAB58Qo_.ttf"
    },
    {
      "family": "Karla",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTDeJqqFENLR7fHGw.ttf",
        "300": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTDppqqFENLR7fHGw.ttf",
        "regular": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTD-JqqFENLR7fHGw.ttf",
        "500": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTDypqqFENLR7fHGw.ttf",
        "600": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTDJp2qFENLR7fHGw.ttf",
        "700": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTDH52qFENLR7fHGw.ttf",
        "800": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTDeJ2qFENLR7fHGw.ttf",
        "200italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNnCV0lPZbLXGxGR.ttf",
        "300italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNkcV0lPZbLXGxGR.ttf",
        "italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNlCV0lPZbLXGxGR.ttf",
        "500italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNlwV0lPZbLXGxGR.ttf",
        "600italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNmcUElPZbLXGxGR.ttf",
        "700italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNmlUElPZbLXGxGR.ttf",
        "800italic": "https://fonts.gstatic.com/s/karla/v32/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNnCUElPZbLXGxGR.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/karla/v32/qkBIXvYC6trAT55ZBi1ueQVIjQTD-JqaFUlP.ttf"
    },
    {
      "family": "Karla Tamil Inclined",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "tamil"
      ],
      "version": "v2",
      "lastModified": "2024-10-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/karlatamilinclined/v2/vm8pdQ3vXFXZ1aPd8dNzR82AFh2TibkaVrcbvZPxCDLR.ttf",
        "700": "https://fonts.gstatic.com/s/karlatamilinclined/v2/vm8mdQ3vXFXZ1aPd8dNzR82AFh2TibkaVo-nkrf5Iy7YGkI1.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/karlatamilinclined/v2/vm8pdQ3vXFXZ1aPd8dNzR82AFh2TibkaVocat5c.ttf"
    },
    {
      "family": "Karla Tamil Upright",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "tamil"
      ],
      "version": "v2",
      "lastModified": "2024-10-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/karlatamilupright/v2/IFS4HfVMk95HnY0u6SeQ_cHoozW_3U5XoBJ9hK8kMK4.ttf",
        "700": "https://fonts.gstatic.com/s/karlatamilupright/v2/IFS1HfVMk95HnY0u6SeQ_cHoozW_3U5XmK5SoKcPLKclE4o.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/karlatamilupright/v2/IFS4HfVMk95HnY0u6SeQ_cHoozW_3U5XkBN3gA.ttf"
    },
    {
      "family": "Karma",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/karma/v17/va9F4kzAzMZRGLjDY8Z_uqzGQC_-.ttf",
        "regular": "https://fonts.gstatic.com/s/karma/v17/va9I4kzAzMZRGIBvS-J3kbDP.ttf",
        "500": "https://fonts.gstatic.com/s/karma/v17/va9F4kzAzMZRGLibYsZ_uqzGQC_-.ttf",
        "600": "https://fonts.gstatic.com/s/karma/v17/va9F4kzAzMZRGLi3ZcZ_uqzGQC_-.ttf",
        "700": "https://fonts.gstatic.com/s/karma/v17/va9F4kzAzMZRGLjTZMZ_uqzGQC_-.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/karma/v17/va9I4kzAzMZRGLBuQeY.ttf"
    },
    {
      "family": "Katibeh",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/katibeh/v21/ZGjXol5MQJog4bxDaC1RVDNdGDs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/katibeh/v21/ZGjXol5MQJog4bxDWCxbUA.ttf"
    },
    {
      "family": "Kaushan Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kaushanscript/v18/vm8vdRfvXFLG3OLnsO15WYS5DF7_ytN3M48a.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kaushanscript/v18/vm8vdRfvXFLG3OLnsO15WYS5DG7-wNc.ttf"
    },
    {
      "family": "Kavivanar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil"
      ],
      "version": "v21",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kavivanar/v21/o-0IIpQgyXYSwhxP7_Jb4j5Ba_2c7A.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kavivanar/v21/o-0IIpQgyXYSwhxP7_Jr4zRF.ttf"
    },
    {
      "family": "Kavoon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kavoon/v24/pxiFyp4_scRYhlU4NLr6f1pdEQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kavoon/v24/pxiFyp4_scRYhlUINbD-.ttf"
    },
    {
      "family": "Kay Pho Du",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "kayah-li",
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kayphodu/v2/jizfREFPvGNOx-jhPwHR4OmnLD0Z4zM.ttf",
        "500": "https://fonts.gstatic.com/s/kayphodu/v2/jizcREFPvGNOx-jhPwHR2B2OCDUy_zoyk18.ttf",
        "600": "https://fonts.gstatic.com/s/kayphodu/v2/jizcREFPvGNOx-jhPwHR2DGJCDUy_zoyk18.ttf",
        "700": "https://fonts.gstatic.com/s/kayphodu/v2/jizcREFPvGNOx-jhPwHR2FWICDUy_zoyk18.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kayphodu/v2/jizfREFPvGNOx-jhPwHR0OitKA.ttf"
    },
    {
      "family": "Kdam Thmor Pro",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin",
        "latin-ext"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kdamthmorpro/v6/EJRPQgAzVdcI-Qdvt34jzurnGA7_j89I8ZWb.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kdamthmorpro/v6/EJRPQgAzVdcI-Qdvt34jzurnGD7-hcs.ttf"
    },
    {
      "family": "Keania One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/keaniaone/v25/zOL54pXJk65E8pXardnuycRuv-hHkOs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/keaniaone/v25/zOL54pXJk65E8pXardnu-cVkuw.ttf"
    },
    {
      "family": "Kelly Slab",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kellyslab/v18/-W_7XJX0Rz3cxUnJC5t6TkMBf50kbiM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kellyslab/v18/-W_7XJX0Rz3cxUnJC5t6fkILew.ttf"
    },
    {
      "family": "Kenia",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kenia/v29/jizURE5PuHQH9qCONUGswfGM.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kenia/v29/jizURE5PuHQH9pCPP0U.ttf"
    },
    {
      "family": "Khand",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/khand/v21/TwMN-IINQlQQ0bL5cFE3ZwaH__-C.ttf",
        "regular": "https://fonts.gstatic.com/s/khand/v21/TwMA-IINQlQQ0YpVWHU_TBqO.ttf",
        "500": "https://fonts.gstatic.com/s/khand/v21/TwMN-IINQlQQ0bKhcVE3ZwaH__-C.ttf",
        "600": "https://fonts.gstatic.com/s/khand/v21/TwMN-IINQlQQ0bKNdlE3ZwaH__-C.ttf",
        "700": "https://fonts.gstatic.com/s/khand/v21/TwMN-IINQlQQ0bLpd1E3ZwaH__-C.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/khand/v21/TwMA-IINQlQQ0bpUUnE.ttf"
    },
    {
      "family": "Khmer",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer"
      ],
      "version": "v36",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/khmer/v36/MjQImit_vPPwpF-BpN2EeYmD.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/khmer/v36/MjQImit_vPPwpG-Artk.ttf"
    },
    {
      "family": "Khula",
      "variants": [
        "300",
        "regular",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/khula/v16/OpNPnoEOns3V7G-ljCvUrC59XwXD.ttf",
        "regular": "https://fonts.gstatic.com/s/khula/v16/OpNCnoEOns3V7FcJpA_chzJ0.ttf",
        "600": "https://fonts.gstatic.com/s/khula/v16/OpNPnoEOns3V7G_RiivUrC59XwXD.ttf",
        "700": "https://fonts.gstatic.com/s/khula/v16/OpNPnoEOns3V7G-1iyvUrC59XwXD.ttf",
        "800": "https://fonts.gstatic.com/s/khula/v16/OpNPnoEOns3V7G-piCvUrC59XwXD.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/khula/v16/OpNCnoEOns3V7GcIrgs.ttf"
    },
    {
      "family": "Kings",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kings/v8/8AtnGsK4O5CYXU_Iq6GSPaHS.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kings/v8/8AtnGsK4O5CYXX_JoaU.ttf"
    },
    {
      "family": "Kirang Haerang",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kiranghaerang/v21/E21-_dn_gvvIjhYON1lpIU4-bcqvWPaJq4no.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kiranghaerang/v21/E21-_dn_gvvIjhYON1lpIU4-bfquUvI.ttf"
    },
    {
      "family": "Kite One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kiteone/v22/70lQu7shLnA_E02vyq1b6HnGO4uA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kiteone/v22/70lQu7shLnA_E02vyp1a4n0.ttf"
    },
    {
      "family": "Kiwi Maru",
      "variants": [
        "300",
        "regular",
        "500"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/kiwimaru/v19/R70djykGkuuDep-hRg6gNCi0Vxn9R5ShnA.ttf",
        "regular": "https://fonts.gstatic.com/s/kiwimaru/v19/R70YjykGkuuDep-hRg6YmACQXzLhTg.ttf",
        "500": "https://fonts.gstatic.com/s/kiwimaru/v19/R70djykGkuuDep-hRg6gbCm0Vxn9R5ShnA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kiwimaru/v19/R70YjykGkuuDep-hRg6omQqU.ttf"
    },
    {
      "family": "Klee One",
      "variants": [
        "regular",
        "600"
      ],
      "subsets": [
        "cyrillic",
        "greek-ext",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kleeone/v12/LDIxapCLNRc6A8oT4q4AOeekWPrP.ttf",
        "600": "https://fonts.gstatic.com/s/kleeone/v12/LDI2apCLNRc6A8oT4pbYF8Osc-bGkqIw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kleeone/v12/LDIxapCLNRc6A8oT4p4BM-M.ttf"
    },
    {
      "family": "Knewave",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/knewave/v14/sykz-yx0lLcxQaSItSq9-trEvlQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/knewave/v14/sykz-yx0lLcxQaSIhSu3_g.ttf"
    },
    {
      "family": "KoHo",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/koho/v17/K2FxfZ5fmddNPuE1WJ75JoKhHys.ttf",
        "200italic": "https://fonts.gstatic.com/s/koho/v17/K2FzfZ5fmddNNisssJ_zIqCkDyvqZA.ttf",
        "300": "https://fonts.gstatic.com/s/koho/v17/K2FxfZ5fmddNPoU2WJ75JoKhHys.ttf",
        "300italic": "https://fonts.gstatic.com/s/koho/v17/K2FzfZ5fmddNNiss1JzzIqCkDyvqZA.ttf",
        "regular": "https://fonts.gstatic.com/s/koho/v17/K2F-fZ5fmddNBikefJbSOos.ttf",
        "italic": "https://fonts.gstatic.com/s/koho/v17/K2FwfZ5fmddNNisUeLTXKou4Bg.ttf",
        "500": "https://fonts.gstatic.com/s/koho/v17/K2FxfZ5fmddNPt03WJ75JoKhHys.ttf",
        "500italic": "https://fonts.gstatic.com/s/koho/v17/K2FzfZ5fmddNNissjJ3zIqCkDyvqZA.ttf",
        "600": "https://fonts.gstatic.com/s/koho/v17/K2FxfZ5fmddNPvEwWJ75JoKhHys.ttf",
        "600italic": "https://fonts.gstatic.com/s/koho/v17/K2FzfZ5fmddNNissoJrzIqCkDyvqZA.ttf",
        "700": "https://fonts.gstatic.com/s/koho/v17/K2FxfZ5fmddNPpUxWJ75JoKhHys.ttf",
        "700italic": "https://fonts.gstatic.com/s/koho/v17/K2FzfZ5fmddNNissxJvzIqCkDyvqZA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/koho/v17/K2F-fZ5fmddNNigUeA.ttf"
    },
    {
      "family": "Kodchasan",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/kodchasan/v19/1cX0aUPOAJv9sG4I-DJeR1Cggeqo3eMeoA.ttf",
        "200italic": "https://fonts.gstatic.com/s/kodchasan/v19/1cXqaUPOAJv9sG4I-DJWjUlIgOCs_-YOoIgN.ttf",
        "300": "https://fonts.gstatic.com/s/kodchasan/v19/1cX0aUPOAJv9sG4I-DJeI1Oggeqo3eMeoA.ttf",
        "300italic": "https://fonts.gstatic.com/s/kodchasan/v19/1cXqaUPOAJv9sG4I-DJWjUksg-Cs_-YOoIgN.ttf",
        "regular": "https://fonts.gstatic.com/s/kodchasan/v19/1cXxaUPOAJv9sG4I-DJmj3uEicG01A.ttf",
        "italic": "https://fonts.gstatic.com/s/kodchasan/v19/1cX3aUPOAJv9sG4I-DJWjXGAq8Sk1PoH.ttf",
        "500": "https://fonts.gstatic.com/s/kodchasan/v19/1cX0aUPOAJv9sG4I-DJee1Kggeqo3eMeoA.ttf",
        "500italic": "https://fonts.gstatic.com/s/kodchasan/v19/1cXqaUPOAJv9sG4I-DJWjUl0guCs_-YOoIgN.ttf",
        "600": "https://fonts.gstatic.com/s/kodchasan/v19/1cX0aUPOAJv9sG4I-DJeV1Wggeqo3eMeoA.ttf",
        "600italic": "https://fonts.gstatic.com/s/kodchasan/v19/1cXqaUPOAJv9sG4I-DJWjUlYheCs_-YOoIgN.ttf",
        "700": "https://fonts.gstatic.com/s/kodchasan/v19/1cX0aUPOAJv9sG4I-DJeM1Sggeqo3eMeoA.ttf",
        "700italic": "https://fonts.gstatic.com/s/kodchasan/v19/1cXqaUPOAJv9sG4I-DJWjUk8hOCs_-YOoIgN.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kodchasan/v19/1cXxaUPOAJv9sG4I-DJWjnGA.ttf"
    },
    {
      "family": "Kode Mono",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kodemono/v3/A2BLn5pb0QgtVEPFnlYkkaoBgw4qv9odq5my9DqTaOW2A3k.ttf",
        "500": "https://fonts.gstatic.com/s/kodemono/v3/A2BLn5pb0QgtVEPFnlYkkaoBgw4qv9odq6uy9DqTaOW2A3k.ttf",
        "600": "https://fonts.gstatic.com/s/kodemono/v3/A2BLn5pb0QgtVEPFnlYkkaoBgw4qv9odq0e19DqTaOW2A3k.ttf",
        "700": "https://fonts.gstatic.com/s/kodemono/v3/A2BLn5pb0QgtVEPFnlYkkaoBgw4qv9odq3619DqTaOW2A3k.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kodemono/v3/A2BLn5pb0QgtVEPFnlYkkaoBgw4qv9odq5myxDuZbA.ttf"
    },
    {
      "family": "Koh Santepheap",
      "variants": [
        "100",
        "300",
        "regular",
        "700",
        "900"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/kohsantepheap/v14/gNMfW3p6SJbwyGj2rBZyeOrTjNuFHVyTtjNJUWU.ttf",
        "300": "https://fonts.gstatic.com/s/kohsantepheap/v14/gNMeW3p6SJbwyGj2rBZyeOrTjNtNP3y5mD9ASHz5.ttf",
        "regular": "https://fonts.gstatic.com/s/kohsantepheap/v14/gNMdW3p6SJbwyGj2rBZyeOrTjOPhF1ixsyNJ.ttf",
        "700": "https://fonts.gstatic.com/s/kohsantepheap/v14/gNMeW3p6SJbwyGj2rBZyeOrTjNtdOHy5mD9ASHz5.ttf",
        "900": "https://fonts.gstatic.com/s/kohsantepheap/v14/gNMeW3p6SJbwyGj2rBZyeOrTjNtlOny5mD9ASHz5.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kohsantepheap/v14/gNMdW3p6SJbwyGj2rBZyeOrTjNPgHVw.ttf"
    },
    {
      "family": "Kolker Brush",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kolkerbrush/v7/iJWDBXWRZjfKWdvmzwvvog3-7KJ6x8qNUQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kolkerbrush/v7/iJWDBXWRZjfKWdvmzwvvog3O7ah-.ttf"
    },
    {
      "family": "Konkhmer Sleokchher",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/konkhmersleokchher/v2/_Xmw-GE-rjmabA_M-aPOZOsCrUv825LFI3507E0d-W0.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/konkhmersleokchher/v2/_Xmw-GE-rjmabA_M-aPOZOsCrUv825LFE39-6A.ttf"
    },
    {
      "family": "Kosugi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kosugi/v18/pxiFyp4_v8FCjlI4NLr6f1pdEQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kosugi/v18/pxiFyp4_v8FCjlIINbD-.ttf"
    },
    {
      "family": "Kosugi Maru",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kosugimaru/v16/0nksC9PgP_wGh21A2KeqGiTqivr9iBq_.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kosugimaru/v16/0nksC9PgP_wGh21A2KeqGhTrgP4.ttf"
    },
    {
      "family": "Kotta One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kottaone/v20/S6u_w41LXzPc_jlfNWqPHA3s5dwt7w.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kottaone/v20/S6u_w41LXzPc_jlfNWq_HQfo.ttf"
    },
    {
      "family": "Koulen",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/koulen/v29/AMOQz46as3KIBPeWgnA9kuYMUg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/koulen/v29/AMOQz46as3KIBPemg3o5.ttf"
    },
    {
      "family": "Kranky",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kranky/v29/hESw6XVgJzlPsFnMpheEZo_H_w.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kranky/v29/hESw6XVgJzlPsFn8px2A.ttf"
    },
    {
      "family": "Kreon",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v39",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/kreon/v39/t5t9IRIUKY-TFF_LW5lnMR3v2DnvPNimejUfp2dWNg.ttf",
        "regular": "https://fonts.gstatic.com/s/kreon/v39/t5t9IRIUKY-TFF_LW5lnMR3v2DnvYtimejUfp2dWNg.ttf",
        "500": "https://fonts.gstatic.com/s/kreon/v39/t5t9IRIUKY-TFF_LW5lnMR3v2DnvUNimejUfp2dWNg.ttf",
        "600": "https://fonts.gstatic.com/s/kreon/v39/t5t9IRIUKY-TFF_LW5lnMR3v2DnvvN-mejUfp2dWNg.ttf",
        "700": "https://fonts.gstatic.com/s/kreon/v39/t5t9IRIUKY-TFF_LW5lnMR3v2Dnvhd-mejUfp2dWNg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kreon/v39/t5t9IRIUKY-TFF_LW5lnMR3v2DnvYtiWez8b.ttf"
    },
    {
      "family": "Kristi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kristi/v22/uK_y4ricdeU6zwdRCh0TMv6EXw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kristi/v22/uK_y4ricdeU6zwdhCxcX.ttf"
    },
    {
      "family": "Krona One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kronaone/v14/jAnEgHdjHcjgfIb1ZcUCMY-h3cWkWg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kronaone/v14/jAnEgHdjHcjgfIb1ZcUyMIWl.ttf"
    },
    {
      "family": "Krub",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/krub/v10/sZlEdRyC6CRYZo47KLF4R6gWaf8.ttf",
        "200italic": "https://fonts.gstatic.com/s/krub/v10/sZlGdRyC6CRYbkQiwLByQ4oTef_6gQ.ttf",
        "300": "https://fonts.gstatic.com/s/krub/v10/sZlEdRyC6CRYZuo4KLF4R6gWaf8.ttf",
        "300italic": "https://fonts.gstatic.com/s/krub/v10/sZlGdRyC6CRYbkQipLNyQ4oTef_6gQ.ttf",
        "regular": "https://fonts.gstatic.com/s/krub/v10/sZlLdRyC6CRYXkYQDLlTW6E.ttf",
        "italic": "https://fonts.gstatic.com/s/krub/v10/sZlFdRyC6CRYbkQaCJtWS6EPcA.ttf",
        "500": "https://fonts.gstatic.com/s/krub/v10/sZlEdRyC6CRYZrI5KLF4R6gWaf8.ttf",
        "500italic": "https://fonts.gstatic.com/s/krub/v10/sZlGdRyC6CRYbkQi_LJyQ4oTef_6gQ.ttf",
        "600": "https://fonts.gstatic.com/s/krub/v10/sZlEdRyC6CRYZp4-KLF4R6gWaf8.ttf",
        "600italic": "https://fonts.gstatic.com/s/krub/v10/sZlGdRyC6CRYbkQi0LVyQ4oTef_6gQ.ttf",
        "700": "https://fonts.gstatic.com/s/krub/v10/sZlEdRyC6CRYZvo_KLF4R6gWaf8.ttf",
        "700italic": "https://fonts.gstatic.com/s/krub/v10/sZlGdRyC6CRYbkQitLRyQ4oTef_6gQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/krub/v10/sZlLdRyC6CRYbkcaCA.ttf"
    },
    {
      "family": "Kufam",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3lqk7qQCJHvIwYg.ttf",
        "500": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3pKk7qQCJHvIwYg.ttf",
        "600": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3SK47qQCJHvIwYg.ttf",
        "700": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3ca47qQCJHvIwYg.ttf",
        "800": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3Fq47qQCJHvIwYg.ttf",
        "900": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3P647qQCJHvIwYg.ttf",
        "italic": "https://fonts.gstatic.com/s/kufam/v25/C8c84cY7pG7w_q6APDMZN6kY3hbiXurT6gqNPPcgYp0i.ttf",
        "500italic": "https://fonts.gstatic.com/s/kufam/v25/C8c84cY7pG7w_q6APDMZN6kY3hbiXurh6gqNPPcgYp0i.ttf",
        "600italic": "https://fonts.gstatic.com/s/kufam/v25/C8c84cY7pG7w_q6APDMZN6kY3hbiXuoN7QqNPPcgYp0i.ttf",
        "700italic": "https://fonts.gstatic.com/s/kufam/v25/C8c84cY7pG7w_q6APDMZN6kY3hbiXuo07QqNPPcgYp0i.ttf",
        "800italic": "https://fonts.gstatic.com/s/kufam/v25/C8c84cY7pG7w_q6APDMZN6kY3hbiXupT7QqNPPcgYp0i.ttf",
        "900italic": "https://fonts.gstatic.com/s/kufam/v25/C8c84cY7pG7w_q6APDMZN6kY3hbiXup67QqNPPcgYp0i.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kufam/v25/C8c-4cY7pG7w_oSJDszBXsKCcBH3lqkLqAqN.ttf"
    },
    {
      "family": "Kulim Park",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjJYNwa5aZbUvGjU.ttf",
        "200italic": "https://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUKa9QYZcqCjVVUA.ttf",
        "300": "https://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjPIOwa5aZbUvGjU.ttf",
        "300italic": "https://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUTaxQYZcqCjVVUA.ttf",
        "regular": "https://fonts.gstatic.com/s/kulimpark/v14/fdN79secq3hflz1Uu3IwtF4m5aZxebw.ttf",
        "italic": "https://fonts.gstatic.com/s/kulimpark/v14/fdN59secq3hflz1Uu3IwhFws4YR0abw2Aw.ttf",
        "600": "https://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjIYIwa5aZbUvGjU.ttf",
        "600italic": "https://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUOapQYZcqCjVVUA.ttf",
        "700": "https://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjOIJwa5aZbUvGjU.ttf",
        "700italic": "https://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUXatQYZcqCjVVUA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kulimpark/v14/fdN79secq3hflz1Uu3IwhF8s4Q.ttf"
    },
    {
      "family": "Kumar One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kumarone/v24/bMr1mS-P958wYi6YaGeGNO6WU3oT0g.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kumarone/v24/bMr1mS-P958wYi6YaGe2NeSS.ttf"
    },
    {
      "family": "Kumar One Outline",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kumaroneoutline/v20/Noao6VH62pyLP0fsrZ-v18wlUEcX9zDwRQu8EGKF.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kumaroneoutline/v20/Noao6VH62pyLP0fsrZ-v18wlUEcX9wDxTw8.ttf"
    },
    {
      "family": "Kumbh Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQkZcA8bTuUkqaLg.ttf",
        "200": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQEZYA8bTuUkqaLg.ttf",
        "300": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQz5YA8bTuUkqaLg.ttf",
        "regular": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQkZYA8bTuUkqaLg.ttf",
        "500": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQo5YA8bTuUkqaLg.ttf",
        "600": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQT5EA8bTuUkqaLg.ttf",
        "700": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQdpEA8bTuUkqaLg.ttf",
        "800": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQEZEA8bTuUkqaLg.ttf",
        "900": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQOJEA8bTuUkqaLg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kumbhsans/v26/c4mP1n92AsfhuCq6tVsaoIx1LQICk0boNoq0SjlDfnzKo-bF3mdQkZYw8L7q.ttf"
    },
    {
      "family": "Kurale",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/kurale/v13/4iCs6KV9e9dXjho6eAT3v02QFg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/kurale/v13/4iCs6KV9e9dXjhoKeQ7z.ttf"
    },
    {
      "family": "LXGW Marker Gothic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-traditional",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "symbols2",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-06-12",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lxgwmarkergothic/v1/Gg8oN4AaXyDVTi_NlS1-xCtMQxY3lToBjuw_cZe26Q.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lxgwmarkergothic/v1/Gg8oN4AaXyDVTi_NlS1-xCtMQxY3lToxj-Y7.ttf"
    },
    {
      "family": "LXGW WenKai Mono TC",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "chinese-traditional",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "lisu",
        "vietnamese"
      ],
      "version": "v9",
      "lastModified": "2025-06-09",
      "files": {
        "300": "https://fonts.gstatic.com/s/lxgwwenkaimonotc/v9/pxiVyos4iPVgyWx9WtufHnsIf5nkaB0HssKqhvJljXmo2SA.ttf",
        "regular": "https://fonts.gstatic.com/s/lxgwwenkaimonotc/v9/pxiYyos4iPVgyWx9WtufHnsIf5nkaB0Him6CovpOkXA.ttf",
        "700": "https://fonts.gstatic.com/s/lxgwwenkaimonotc/v9/pxiVyos4iPVgyWx9WtufHnsIf5nkaB0HstKthvJljXmo2SA.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lxgwwenkaimonotc/v9/pxiYyos4iPVgyWx9WtufHnsIf5nkaB0Hum-Ipg.ttf"
    },
    {
      "family": "LXGW WenKai TC",
      "variants": [
        "300",
        "regular",
        "700"
      ],
      "subsets": [
        "chinese-traditional",
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "lisu",
        "vietnamese"
      ],
      "version": "v9",
      "lastModified": "2025-06-09",
      "files": {
        "300": "https://fonts.gstatic.com/s/lxgwwenkaitc/v9/w8gAH20td8wNsI3f40DmtXZb4_MmBfkpTClICyan.ttf",
        "regular": "https://fonts.gstatic.com/s/lxgwwenkaitc/v9/w8gDH20td8wNsI3f40DmtXZb48uKLd0hZzVB.ttf",
        "700": "https://fonts.gstatic.com/s/lxgwwenkaitc/v9/w8gAH20td8wNsI3f40DmtXZb4_M2AvkpTClICyan.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lxgwwenkaitc/v9/w8gDH20td8wNsI3f40DmtXZb4_uLJ9k.ttf"
    },
    {
      "family": "La Belle Aurore",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/labelleaurore/v22/RrQIbot8-mNYKnGNDkWlocovHeIIG-eFNVmULg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/labelleaurore/v22/RrQIbot8-mNYKnGNDkWlocovHeI4Gu2B.ttf"
    },
    {
      "family": "Labrada",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VTSgM4QPdUej17.ttf",
        "200": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9XTSwM4QPdUej17.ttf",
        "300": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9UNSwM4QPdUej17.ttf",
        "regular": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VTSwM4QPdUej17.ttf",
        "500": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VhSwM4QPdUej17.ttf",
        "600": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9WNTAM4QPdUej17.ttf",
        "700": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9W0TAM4QPdUej17.ttf",
        "800": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9XTTAM4QPdUej17.ttf",
        "900": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9X6TAM4QPdUej17.ttf",
        "100italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCOt6SvN2fy17-dE.ttf",
        "200italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCGt7SvN2fy17-dE.ttf",
        "300italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCLV7SvN2fy17-dE.ttf",
        "italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCOt7SvN2fy17-dE.ttf",
        "500italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCNl7SvN2fy17-dE.ttf",
        "600italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCDV8SvN2fy17-dE.ttf",
        "700italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCAx8SvN2fy17-dE.ttf",
        "800italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCGt8SvN2fy17-dE.ttf",
        "900italic": "https://fonts.gstatic.com/s/labrada/v3/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCEJ8SvN2fy17-dE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/labrada/v3/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VTSzM5SvM.ttf"
    },
    {
      "family": "Lacquer",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lacquer/v15/EYqzma1QwqpG4_BBB7-AXhttQ5I.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lacquer/v15/EYqzma1QwqpG4_BBN76KWg.ttf"
    },
    {
      "family": "Laila",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-25",
      "files": {
        "300": "https://fonts.gstatic.com/s/laila/v20/LYjBdG_8nE8jDLzxogNAh14nVcfe.ttf",
        "regular": "https://fonts.gstatic.com/s/laila/v20/LYjMdG_8nE8jDIRdiidIrEIu.ttf",
        "500": "https://fonts.gstatic.com/s/laila/v20/LYjBdG_8nE8jDLypowNAh14nVcfe.ttf",
        "600": "https://fonts.gstatic.com/s/laila/v20/LYjBdG_8nE8jDLyFpANAh14nVcfe.ttf",
        "700": "https://fonts.gstatic.com/s/laila/v20/LYjBdG_8nE8jDLzhpQNAh14nVcfe.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/laila/v20/LYjMdG_8nE8jDLRcgCM.ttf"
    },
    {
      "family": "Lakki Reddy",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "telugu"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lakkireddy/v24/S6u5w49MUSzD9jlCPmvLZQfox9k97-xZ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lakkireddy/v24/S6u5w49MUSzD9jlCPmvLZTfpzd0.ttf"
    },
    {
      "family": "Lalezar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lalezar/v15/zrfl0HLVx-HwTP82UaDyIiL0RCg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lalezar/v15/zrfl0HLVx-HwTP82YaH4Jg.ttf"
    },
    {
      "family": "Lancelot",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lancelot/v27/J7acnppxBGtQEulG4JY4xJ9CGyAa.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lancelot/v27/J7acnppxBGtQEulG4KY5zps.ttf"
    },
    {
      "family": "Langar",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/langar/v29/kJEyBukW7AIlgjGVrTVZ99sqrQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/langar/v29/kJEyBukW7AIlgjGlrD9d.ttf"
    },
    {
      "family": "Lateef",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/lateef/v32/hESz6XVnNCxEvkb0bjygbqTb9nQ-RA.ttf",
        "300": "https://fonts.gstatic.com/s/lateef/v32/hESz6XVnNCxEvkb0Cj-gbqTb9nQ-RA.ttf",
        "regular": "https://fonts.gstatic.com/s/lateef/v32/hESw6XVnNCxEvkbMpheEZo_H_w.ttf",
        "500": "https://fonts.gstatic.com/s/lateef/v32/hESz6XVnNCxEvkb0Uj6gbqTb9nQ-RA.ttf",
        "600": "https://fonts.gstatic.com/s/lateef/v32/hESz6XVnNCxEvkb0fjmgbqTb9nQ-RA.ttf",
        "700": "https://fonts.gstatic.com/s/lateef/v32/hESz6XVnNCxEvkb0GjigbqTb9nQ-RA.ttf",
        "800": "https://fonts.gstatic.com/s/lateef/v32/hESz6XVnNCxEvkb0BjugbqTb9nQ-RA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lateef/v32/hESw6XVnNCxEvkb8px2A.ttf"
    },
    {
      "family": "Lato",
      "variants": [
        "100",
        "100italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "700",
        "700italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/lato/v24/S6u8w4BMUTPHh30wWyWrFCbw7A.ttf",
        "100italic": "https://fonts.gstatic.com/s/lato/v24/S6u-w4BMUTPHjxsIPy-vNiPg7MU0.ttf",
        "300": "https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh7USew-FGC_p9dw.ttf",
        "300italic": "https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI9w2PHA3s5dwt7w.ttf",
        "regular": "https://fonts.gstatic.com/s/lato/v24/S6uyw4BMUTPHvxk6XweuBCY.ttf",
        "italic": "https://fonts.gstatic.com/s/lato/v24/S6u8w4BMUTPHjxswWyWrFCbw7A.ttf",
        "700": "https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh6UVew-FGC_p9dw.ttf",
        "700italic": "https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI5wqPHA3s5dwt7w.ttf",
        "900": "https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh50Xew-FGC_p9dw.ttf",
        "900italic": "https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI3wiPHA3s5dwt7w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lato/v24/S6uyw4BMUTPHjxgwWw.ttf"
    },
    {
      "family": "Lavishly Yours",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lavishlyyours/v6/jizDREVIvGwH5OjiZmX9r5z_WxUY0TY7ikbI.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lavishlyyours/v6/jizDREVIvGwH5OjiZmX9r5z_WyUZ2zI.ttf"
    },
    {
      "family": "League Gothic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/leaguegothic/v12/qFdR35CBi4tvBz81xy7WG7ep-BQAY7Krj7feObpH_-amidQ6Q9hn.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/leaguegothic/v12/qFdR35CBi4tvBz81xy7WG7ep-BQAY7Krj7feObpH_9ang9A.ttf"
    },
    {
      "family": "League Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/leaguescript/v29/CSR54zpSlumSWj9CGVsoBZdeaNNUuOwkC2s.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/leaguescript/v29/CSR54zpSlumSWj9CGVsoBZdeWNJevA.ttf"
    },
    {
      "family": "League Spartan",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvM_oXpBMdcFguczA.ttf",
        "200": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMfoTpBMdcFguczA.ttf",
        "300": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMoITpBMdcFguczA.ttf",
        "regular": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvM_oTpBMdcFguczA.ttf",
        "500": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMzITpBMdcFguczA.ttf",
        "600": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMIIPpBMdcFguczA.ttf",
        "700": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMGYPpBMdcFguczA.ttf",
        "800": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMfoPpBMdcFguczA.ttf",
        "900": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMV4PpBMdcFguczA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/leaguespartan/v14/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvM_oTZBc1Y.ttf"
    },
    {
      "family": "Leckerli One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/leckerlione/v21/V8mCoQH8VCsNttEnxnGQ-1itLZxcBtItFw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/leckerlione/v21/V8mCoQH8VCsNttEnxnGQ-1idLJZY.ttf"
    },
    {
      "family": "Ledger",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ledger/v16/j8_q6-HK1L3if_sxm8DwHTBhHw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ledger/v16/j8_q6-HK1L3if_sBmsr0.ttf"
    },
    {
      "family": "Lekton",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lekton/v20/SZc43FDmLaWmWpBeXxfonUPL6Q.ttf",
        "italic": "https://fonts.gstatic.com/s/lekton/v20/SZc63FDmLaWmWpBuXR3sv0bb6StO.ttf",
        "700": "https://fonts.gstatic.com/s/lekton/v20/SZc73FDmLaWmWpBm4zjMlWjX4DJXgQ.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lekton/v20/SZc43FDmLaWmWpBuXh3s.ttf"
    },
    {
      "family": "Lemon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lemon/v18/HI_EiYEVKqRMq0jBSZXAQ4-d.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lemon/v18/HI_EiYEVKqRMq3jAQ5E.ttf"
    },
    {
      "family": "Lemonada",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/lemonada/v30/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGJOt2mfWc3Z2pTg.ttf",
        "regular": "https://fonts.gstatic.com/s/lemonada/v30/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGeut2mfWc3Z2pTg.ttf",
        "500": "https://fonts.gstatic.com/s/lemonada/v30/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGSOt2mfWc3Z2pTg.ttf",
        "600": "https://fonts.gstatic.com/s/lemonada/v30/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGpOx2mfWc3Z2pTg.ttf",
        "700": "https://fonts.gstatic.com/s/lemonada/v30/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGnex2mfWc3Z2pTg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lemonada/v30/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGeutGmP-Y.ttf"
    },
    {
      "family": "Lexend",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WCzsX_LBte6KuGEo.ttf",
        "200": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WC7sW_LBte6KuGEo.ttf",
        "300": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WC2UW_LBte6KuGEo.ttf",
        "regular": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WCzsW_LBte6KuGEo.ttf",
        "500": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WCwkW_LBte6KuGEo.ttf",
        "600": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WC-UR_LBte6KuGEo.ttf",
        "700": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WC9wR_LBte6KuGEo.ttf",
        "800": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WC7sR_LBte6KuGEo.ttf",
        "900": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WC5IR_LBte6KuGEo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexend/v25/wlptgwvFAVdoq2_F94zlCfv0bz1WCzsWzLFnfw.ttf"
    },
    {
      "family": "Lexend Deca",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U48MxArBPCqLNflg.ttf",
        "200": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4cM1ArBPCqLNflg.ttf",
        "300": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4rs1ArBPCqLNflg.ttf",
        "regular": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U48M1ArBPCqLNflg.ttf",
        "500": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4ws1ArBPCqLNflg.ttf",
        "600": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4LspArBPCqLNflg.ttf",
        "700": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4F8pArBPCqLNflg.ttf",
        "800": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4cMpArBPCqLNflg.ttf",
        "900": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4WcpArBPCqLNflg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexenddeca/v24/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U48M1wrRnG.ttf"
    },
    {
      "family": "Lexend Exa",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v34",
      "lastModified": "2025-06-09",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9r7T6bHHJ8BRq0b.ttf",
        "200": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9p7TqbHHJ8BRq0b.ttf",
        "300": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9qlTqbHHJ8BRq0b.ttf",
        "regular": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9r7TqbHHJ8BRq0b.ttf",
        "500": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9rJTqbHHJ8BRq0b.ttf",
        "600": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9olSabHHJ8BRq0b.ttf",
        "700": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9ocSabHHJ8BRq0b.ttf",
        "800": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9p7SabHHJ8BRq0b.ttf",
        "900": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9pSSabHHJ8BRq0b.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexendexa/v34/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9r7TpbGFps.ttf"
    },
    {
      "family": "Lexend Giga",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC2LmE68oo6eepYQ.ttf",
        "200": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCWLiE68oo6eepYQ.ttf",
        "300": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRChriE68oo6eepYQ.ttf",
        "regular": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC2LiE68oo6eepYQ.ttf",
        "500": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC6riE68oo6eepYQ.ttf",
        "600": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCBr-E68oo6eepYQ.ttf",
        "700": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCP7-E68oo6eepYQ.ttf",
        "800": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCWL-E68oo6eepYQ.ttf",
        "900": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCcb-E68oo6eepYQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexendgiga/v26/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC2Li06sAs.ttf"
    },
    {
      "family": "Lexend Mega",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v26",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDL8fivveyiq9EqQw.ttf",
        "200": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLcfmvveyiq9EqQw.ttf",
        "300": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLr_mvveyiq9EqQw.ttf",
        "regular": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDL8fmvveyiq9EqQw.ttf",
        "500": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLw_mvveyiq9EqQw.ttf",
        "600": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLL_6vveyiq9EqQw.ttf",
        "700": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLFv6vveyiq9EqQw.ttf",
        "800": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLcf6vveyiq9EqQw.ttf",
        "900": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLWP6vveyiq9EqQw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexendmega/v26/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDL8fmfvOam.ttf"
    },
    {
      "family": "Lexend Peta",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v29",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR6SFyW1YuRTsnfw.ttf",
        "200": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRaSByW1YuRTsnfw.ttf",
        "300": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRtyByW1YuRTsnfw.ttf",
        "regular": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR6SByW1YuRTsnfw.ttf",
        "500": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR2yByW1YuRTsnfw.ttf",
        "600": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRNydyW1YuRTsnfw.ttf",
        "700": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRDidyW1YuRTsnfw.ttf",
        "800": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRaSdyW1YuRTsnfw.ttf",
        "900": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRQCdyW1YuRTsnfw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexendpeta/v29/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR6SBCWlwq.ttf"
    },
    {
      "family": "Lexend Tera",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM5zITdpz0fYxcrQ.ttf",
        "200": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMZzMTdpz0fYxcrQ.ttf",
        "300": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMuTMTdpz0fYxcrQ.ttf",
        "regular": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM5zMTdpz0fYxcrQ.ttf",
        "500": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM1TMTdpz0fYxcrQ.ttf",
        "600": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMOTQTdpz0fYxcrQ.ttf",
        "700": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMADQTdpz0fYxcrQ.ttf",
        "800": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMZzQTdpz0fYxcrQ.ttf",
        "900": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMTjQTdpz0fYxcrQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexendtera/v28/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM5zMjd5bw.ttf"
    },
    {
      "family": "Lexend Zetta",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v31",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy9bH0z5jbs8qbts.ttf",
        "200": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy1bG0z5jbs8qbts.ttf",
        "300": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy4jG0z5jbs8qbts.ttf",
        "regular": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy9bG0z5jbs8qbts.ttf",
        "500": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy-TG0z5jbs8qbts.ttf",
        "600": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCywjB0z5jbs8qbts.ttf",
        "700": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCyzHB0z5jbs8qbts.ttf",
        "800": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy1bB0z5jbs8qbts.ttf",
        "900": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy3_B0z5jbs8qbts.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lexendzetta/v31/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy9bG4z9pag.ttf"
    },
    {
      "family": "Libertinus Math",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "math",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/libertinusmath/v1/Gw6iwc3770TVMoHVurPejWtfenRLv_KJt3R-2Q.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/libertinusmath/v1/Gw6iwc3770TVMoHVurPejWtfenR7vviN.ttf"
    },
    {
      "family": "Libertinus Mono",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/libertinusmono/v1/_gPg1RnxrjY_TDm97ApTqwneJJFToBF3YROW_w.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/libertinusmono/v1/_gPg1RnxrjY_TDm97ApTqwneJJFjoRtz.ttf"
    },
    {
      "family": "Libre Barcode 128",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcode128/v29/cIfnMbdUsUoiW3O_hVviCwVjuLtXeJ_A_gMk0izH.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcode128/v29/cIfnMbdUsUoiW3O_hVviCwVjuLtXeK_B9Ac.ttf"
    },
    {
      "family": "Libre Barcode 128 Text",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcode128text/v29/fdNv9tubt3ZEnz1Gu3I4-zppwZ9CWZ16Z0w5cV3Y6M90w4k.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcode128text/v29/fdNv9tubt3ZEnz1Gu3I4-zppwZ9CWZ16Z0w5QVzS7A.ttf"
    },
    {
      "family": "Libre Barcode 39",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcode39/v23/-nFnOHM08vwC6h8Li1eQnP_AHzI2K_d709jy92k.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcode39/v23/-nFnOHM08vwC6h8Li1eQnP_AHzI2G_Zx1w.ttf"
    },
    {
      "family": "Libre Barcode 39 Extended",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v28",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcode39extended/v28/8At7Gt6_O5yNS0-K4Nf5U922qSzhJ3dUdfJpwNUgfNRCOZ1GOBw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcode39extended/v28/8At7Gt6_O5yNS0-K4Nf5U922qSzhJ3dUdfJpwNUgTNVIPQ.ttf"
    },
    {
      "family": "Libre Barcode 39 Extended Text",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v28",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcode39extendedtext/v28/eLG1P_rwIgOiDA7yrs9LoKaYRVLQ1YldrrOnnL7xPO4jNP68fLIiPopNNA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcode39extendedtext/v28/eLG1P_rwIgOiDA7yrs9LoKaYRVLQ1YldrrOnnL7xPO4jNP6Mfbgm.ttf"
    },
    {
      "family": "Libre Barcode 39 Text",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcode39text/v29/sJoa3KhViNKANw_E3LwoDXvs5Un0HQ1vT-031RRL-9rYaw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcode39text/v29/sJoa3KhViNKANw_E3LwoDXvs5Un0HQ1vT-0H1B5P.ttf"
    },
    {
      "family": "Libre Barcode EAN13 Text",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebarcodeean13text/v23/wlpigxXFDU1_oCu9nfZytgIqSG0XRcJm_OQiB96PAGEki52WfA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebarcodeean13text/v23/wlpigxXFDU1_oCu9nfZytgIqSG0XRcJm_OQiB96_AWsg.ttf"
    },
    {
      "family": "Libre Baskerville",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebaskerville/v16/kmKnZrc3Hgbbcjq75U4uslyuy4kn0pNeYRI4CN2V.ttf",
        "italic": "https://fonts.gstatic.com/s/librebaskerville/v16/kmKhZrc3Hgbbcjq75U4uslyuy4kn0qNcaxYaDc2V2ro.ttf",
        "700": "https://fonts.gstatic.com/s/librebaskerville/v16/kmKiZrc3Hgbbcjq75U4uslyuy4kn0qviTjYwI8Gcw6Oi.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebaskerville/v16/kmKnZrc3Hgbbcjq75U4uslyuy4kn0qNfaxY.ttf"
    },
    {
      "family": "Libre Bodoni",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6I1fwWzZcOb3U3s.ttf",
        "500": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6L9fwWzZcOb3U3s.ttf",
        "600": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6FNYwWzZcOb3U3s.ttf",
        "700": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6GpYwWzZcOb3U3s.ttf",
        "italic": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUcKS_TdMTyQ3syLg.ttf",
        "500italic": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUcGy_TdMTyQ3syLg.ttf",
        "600italic": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUc9yjTdMTyQ3syLg.ttf",
        "700italic": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUczijTdMTyQ3syLg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librebodoni/v8/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6I1f8W3TdA.ttf"
    },
    {
      "family": "Libre Caslon Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librecaslondisplay/v17/TuGOUUFxWphYQ6YI6q9Xp61FQzxDRKmzr2lRdRhtCC4d.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librecaslondisplay/v17/TuGOUUFxWphYQ6YI6q9Xp61FQzxDRKmzr1lQfxw.ttf"
    },
    {
      "family": "Libre Caslon Text",
      "variants": [
        "regular",
        "italic",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v5",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/librecaslontext/v5/DdT878IGsGw1aF1JU10PUbTvNNaDMcq_3eNrHgO1.ttf",
        "italic": "https://fonts.gstatic.com/s/librecaslontext/v5/DdT678IGsGw1aF1JU10PUbTvNNaDMfq91-dJGxO1q9o.ttf",
        "700": "https://fonts.gstatic.com/s/librecaslontext/v5/DdT578IGsGw1aF1JU10PUbTvNNaDMfID8sdjNR-8ssPt.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librecaslontext/v5/DdT878IGsGw1aF1JU10PUbTvNNaDMfq-1-c.ttf"
    },
    {
      "family": "Libre Franklin",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhLsSUB9rIb-JH1g.ttf",
        "200": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhrsWUB9rIb-JH1g.ttf",
        "300": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhcMWUB9rIb-JH1g.ttf",
        "regular": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhLsWUB9rIb-JH1g.ttf",
        "500": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhHMWUB9rIb-JH1g.ttf",
        "600": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduh8MKUB9rIb-JH1g.ttf",
        "700": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhycKUB9rIb-JH1g.ttf",
        "800": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhrsKUB9rIb-JH1g.ttf",
        "900": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhh8KUB9rIb-JH1g.ttf",
        "100italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oZ8RdDMTedX1sGE.ttf",
        "200italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05ob8RNDMTedX1sGE.ttf",
        "300italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oYiRNDMTedX1sGE.ttf",
        "italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oZ8RNDMTedX1sGE.ttf",
        "500italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oZORNDMTedX1sGE.ttf",
        "600italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oaiQ9DMTedX1sGE.ttf",
        "700italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oabQ9DMTedX1sGE.ttf",
        "800italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05ob8Q9DMTedX1sGE.ttf",
        "900italic": "https://fonts.gstatic.com/s/librefranklin/v19/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05obVQ9DMTedX1sGE.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/librefranklin/v19/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhLsWkBtDM.ttf"
    },
    {
      "family": "Licorice",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/licorice/v7/t5tjIR8TMomTCAyjNk23hqLgzCHu.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/licorice/v7/t5tjIR8TMomTCAyjNn22jKY.ttf"
    },
    {
      "family": "Life Savers",
      "variants": [
        "regular",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lifesavers/v22/ZXuie1UftKKabUQMgxAal_lrFgpbuNvB.ttf",
        "700": "https://fonts.gstatic.com/s/lifesavers/v22/ZXu_e1UftKKabUQMgxAal8HXOS5Tk8fIpPRW.ttf",
        "800": "https://fonts.gstatic.com/s/lifesavers/v22/ZXu_e1UftKKabUQMgxAal8HLOi5Tk8fIpPRW.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lifesavers/v22/ZXuie1UftKKabUQMgxAal8lqHA4.ttf"
    },
    {
      "family": "Lilita One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lilitaone/v16/i7dPIFZ9Zz-WBtRtedDbUEZ2RFq7AwU.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lilitaone/v16/i7dPIFZ9Zz-WBtRtedDbYEd8QA.ttf"
    },
    {
      "family": "Lily Script One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lilyscriptone/v15/LhW9MV7ZMfIPdMxeBjBvFN8SXLS4gsSjQNsRMg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lilyscriptone/v15/LhW9MV7ZMfIPdMxeBjBvFN8SXLSIg86n.ttf"
    },
    {
      "family": "Limelight",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/limelight/v20/XLYkIZL7aopJVbZJHDuYPeNGrnY2TA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/limelight/v20/XLYkIZL7aopJVbZJHDuoPOlC.ttf"
    },
    {
      "family": "Linden Hill",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lindenhill/v26/-F61fjxoKSg9Yc3hZgO8ygFI7CwC009k.ttf",
        "italic": "https://fonts.gstatic.com/s/lindenhill/v26/-F63fjxoKSg9Yc3hZgO8yjFK5igg1l9kn-s.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lindenhill/v26/-F61fjxoKSg9Yc3hZgO8yjFJ5ig.ttf"
    },
    {
      "family": "Linefont",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v8",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY4UNbu7tmdXux3U.ttf",
        "200": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnYwUMbu7tmdXux3U.ttf",
        "300": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY9sMbu7tmdXux3U.ttf",
        "regular": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY4UMbu7tmdXux3U.ttf",
        "500": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY7cMbu7tmdXux3U.ttf",
        "600": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY1sLbu7tmdXux3U.ttf",
        "700": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY2ILbu7tmdXux3U.ttf",
        "800": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnYwULbu7tmdXux3U.ttf",
        "900": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnYywLbu7tmdXux3U.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/linefont/v8/dg4I_pzpoqcLKUIzVfFMh1TF2rkhli25jn7CKTTWSumsFuSnY4UMXu_nnQ.ttf"
    },
    {
      "family": "Lisu Bosa",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "lisu"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXX2DGRdbY1P1Sbg.ttf",
        "200italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXkuRNzc9vhCblye.ttf",
        "300": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXO2PGRdbY1P1Sbg.ttf",
        "300italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXlKR9zc9vhCblye.ttf",
        "regular": "https://fonts.gstatic.com/s/lisubosa/v2/3XFoErkv240fsdmJRJQvl0viTf3E3Q.ttf",
        "italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFuErkv240fsdmJRJQflUHmb_jU3eRL.ttf",
        "500": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXY2LGRdbY1P1Sbg.ttf",
        "500italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXkSRtzc9vhCblye.ttf",
        "600": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXT2XGRdbY1P1Sbg.ttf",
        "600italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXk-Qdzc9vhCblye.ttf",
        "700": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXK2TGRdbY1P1Sbg.ttf",
        "700italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXlaQNzc9vhCblye.ttf",
        "800": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXN2fGRdbY1P1Sbg.ttf",
        "800italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXlGQ9zc9vhCblye.ttf",
        "900": "https://fonts.gstatic.com/s/lisubosa/v2/3XFtErkv240fsdmJRJQXE2bGRdbY1P1Sbg.ttf",
        "900italic": "https://fonts.gstatic.com/s/lisubosa/v2/3XFzErkv240fsdmJRJQflXliQtzc9vhCblye.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lisubosa/v2/3XFoErkv240fsdmJRJQflkHm.ttf"
    },
    {
      "family": "Liter",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/liter/v4/SLXGc1nX4GQ4d2ImRJqExst1.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/liter/v4/SLXGc1nX4GQ4d1InTp4.ttf"
    },
    {
      "family": "Literata",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v39",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbJG_F_bcTWCWp8g.ttf",
        "300": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbE-_F_bcTWCWp8g.ttf",
        "regular": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbBG_F_bcTWCWp8g.ttf",
        "500": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbCO_F_bcTWCWp8g.ttf",
        "600": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbM-4F_bcTWCWp8g.ttf",
        "700": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbPa4F_bcTWCWp8g.ttf",
        "800": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbJG4F_bcTWCWp8g.ttf",
        "900": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbLi4F_bcTWCWp8g.ttf",
        "200italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8f7XWSUKTt8iVow.ttf",
        "300italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8obXWSUKTt8iVow.ttf",
        "italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8_7XWSUKTt8iVow.ttf",
        "500italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8zbXWSUKTt8iVow.ttf",
        "600italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8IbLWSUKTt8iVow.ttf",
        "700italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8GLLWSUKTt8iVow.ttf",
        "800italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8f7LWSUKTt8iVow.ttf",
        "900italic": "https://fonts.gstatic.com/s/literata/v39/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8VrLWSUKTt8iVow.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/literata/v39/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbBG_J_fWSQ.ttf"
    },
    {
      "family": "Liu Jian Mao Cao",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-simplified",
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/liujianmaocao/v23/845DNN84HJrccNonurqXILGpvCOoferVKGWsUo8.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/liujianmaocao/v23/845DNN84HJrccNonurqXILGpvCOoTevfLA.ttf"
    },
    {
      "family": "Livvic",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/livvic/v14/rnCr-x1S2hzjrlffC-M-mHnOSOuk.ttf",
        "100italic": "https://fonts.gstatic.com/s/livvic/v14/rnCt-x1S2hzjrlfXbdtakn3sTfukQHs.ttf",
        "200": "https://fonts.gstatic.com/s/livvic/v14/rnCq-x1S2hzjrlffp8IeslfCQfK9WQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/livvic/v14/rnCs-x1S2hzjrlfXbdv2s13GY_etWWIJ.ttf",
        "300": "https://fonts.gstatic.com/s/livvic/v14/rnCq-x1S2hzjrlffw8EeslfCQfK9WQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/livvic/v14/rnCs-x1S2hzjrlfXbduSsF3GY_etWWIJ.ttf",
        "regular": "https://fonts.gstatic.com/s/livvic/v14/rnCp-x1S2hzjrlfnb-k6unzeSA.ttf",
        "italic": "https://fonts.gstatic.com/s/livvic/v14/rnCr-x1S2hzjrlfXbeM-mHnOSOuk.ttf",
        "500": "https://fonts.gstatic.com/s/livvic/v14/rnCq-x1S2hzjrlffm8AeslfCQfK9WQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/livvic/v14/rnCs-x1S2hzjrlfXbdvKsV3GY_etWWIJ.ttf",
        "600": "https://fonts.gstatic.com/s/livvic/v14/rnCq-x1S2hzjrlfft8ceslfCQfK9WQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/livvic/v14/rnCs-x1S2hzjrlfXbdvmtl3GY_etWWIJ.ttf",
        "700": "https://fonts.gstatic.com/s/livvic/v14/rnCq-x1S2hzjrlff08YeslfCQfK9WQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/livvic/v14/rnCs-x1S2hzjrlfXbduCt13GY_etWWIJ.ttf",
        "900": "https://fonts.gstatic.com/s/livvic/v14/rnCq-x1S2hzjrlff68QeslfCQfK9WQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/livvic/v14/rnCs-x1S2hzjrlfXbdu6tV3GY_etWWIJ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/livvic/v14/rnCp-x1S2hzjrlfXbuM-.ttf"
    },
    {
      "family": "Lobster",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v31",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lobster/v31/neILzCirqoswsqX9_oWsMqEzSJQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lobster/v31/neILzCirqoswsqX9zoSmNg.ttf"
    },
    {
      "family": "Lobster Two",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lobstertwo/v21/BngMUXZGTXPUvIoyV6yN59fK7KSJ4ACD.ttf",
        "italic": "https://fonts.gstatic.com/s/lobstertwo/v21/BngOUXZGTXPUvIoyV6yN5-fI5qCr5RCDY_k.ttf",
        "700": "https://fonts.gstatic.com/s/lobstertwo/v21/BngRUXZGTXPUvIoyV6yN5-92w4CByxyKeuDp.ttf",
        "700italic": "https://fonts.gstatic.com/s/lobstertwo/v21/BngTUXZGTXPUvIoyV6yN5-fI3hyEwRiof_DpXMY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lobstertwo/v21/BngMUXZGTXPUvIoyV6yN5-fL5qA.ttf"
    },
    {
      "family": "Londrina Outline",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/londrinaoutline/v28/C8c44dM8vmb14dfsZxhetg3pDH-SfuoxrSKMDvI.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/londrinaoutline/v28/C8c44dM8vmb14dfsZxhetg3pDH-STus7qQ.ttf"
    },
    {
      "family": "Londrina Shadow",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/londrinashadow/v27/oPWX_kB4kOQoWNJmjxLV5JuoCUlXRlaSxkrMCQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/londrinashadow/v27/oPWX_kB4kOQoWNJmjxLV5JuoCUlnR1yW.ttf"
    },
    {
      "family": "Londrina Sketch",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/londrinasketch/v26/c4m41npxGMTnomOHtRU68eIJn8qfWWn5Pos6CA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/londrinasketch/v26/c4m41npxGMTnomOHtRU68eIJn8qvWGP9.ttf"
    },
    {
      "family": "Londrina Solid",
      "variants": [
        "100",
        "300",
        "regular",
        "900"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/londrinasolid/v18/flUjRq6sw40kQEJxWNgkLuudGfs9KBYesZHhV64.ttf",
        "300": "https://fonts.gstatic.com/s/londrinasolid/v18/flUiRq6sw40kQEJxWNgkLuudGfv1CjY0n53oTrcL.ttf",
        "regular": "https://fonts.gstatic.com/s/londrinasolid/v18/flUhRq6sw40kQEJxWNgkLuudGcNZIhI8tIHh.ttf",
        "900": "https://fonts.gstatic.com/s/londrinasolid/v18/flUiRq6sw40kQEJxWNgkLuudGfvdDzY0n53oTrcL.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/londrinasolid/v18/flUhRq6sw40kQEJxWNgkLuudGfNYKBY.ttf"
    },
    {
      "family": "Long Cang",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-simplified",
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/longcang/v20/LYjAdGP8kkgoTec8zkRgrXArXN7HWQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/longcang/v20/LYjAdGP8kkgoTec8zkRQrHov.ttf"
    },
    {
      "family": "Lora",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "math",
        "symbols",
        "vietnamese"
      ],
      "version": "v36",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lora/v36/0QI6MX1D_JOuGQbT0gvTJPa787weuyJGmKxemMeZ.ttf",
        "500": "https://fonts.gstatic.com/s/lora/v36/0QI6MX1D_JOuGQbT0gvTJPa787wsuyJGmKxemMeZ.ttf",
        "600": "https://fonts.gstatic.com/s/lora/v36/0QI6MX1D_JOuGQbT0gvTJPa787zAvCJGmKxemMeZ.ttf",
        "700": "https://fonts.gstatic.com/s/lora/v36/0QI6MX1D_JOuGQbT0gvTJPa787z5vCJGmKxemMeZ.ttf",
        "italic": "https://fonts.gstatic.com/s/lora/v36/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-MoFkqh8ndeZzZ0.ttf",
        "500italic": "https://fonts.gstatic.com/s/lora/v36/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-PgFkqh8ndeZzZ0.ttf",
        "600italic": "https://fonts.gstatic.com/s/lora/v36/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-BQCkqh8ndeZzZ0.ttf",
        "700italic": "https://fonts.gstatic.com/s/lora/v36/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-C0Ckqh8ndeZzZ0.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lora/v36/0QI6MX1D_JOuGQbT0gvTJPa787weuxJHkqg.ttf"
    },
    {
      "family": "Love Light",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lovelight/v7/t5tlIR0TNJyZWimpNAXDjKbCyTHuspo.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lovelight/v7/t5tlIR0TNJyZWimpNAXDvKfIzQ.ttf"
    },
    {
      "family": "Love Ya Like A Sister",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/loveyalikeasister/v22/R70EjzUBlOqPeouhFDfR80-0FhOqJubN-Be78nZcsGGycA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/loveyalikeasister/v22/R70EjzUBlOqPeouhFDfR80-0FhOqJubN-BeL83xY.ttf"
    },
    {
      "family": "Loved by the King",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lovedbytheking/v23/Gw6gwdP76VDVJNXerebZxUMeRXUF2PiNlXFu2R64.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lovedbytheking/v23/Gw6gwdP76VDVJNXerebZxUMeRXUF2MiMn3U.ttf"
    },
    {
      "family": "Lovers Quarrel",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/loversquarrel/v24/Yq6N-LSKXTL-5bCy8ksBzpQ_-zAsY7pO6siz.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/loversquarrel/v24/Yq6N-LSKXTL-5bCy8ksBzpQ_-wAtab4.ttf"
    },
    {
      "family": "Luckiest Guy",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/luckiestguy/v24/_gP_1RrxsjcxVyin9l9n_j2RStR3qDpraA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/luckiestguy/v24/_gP_1RrxsjcxVyin9l9n_j2hS95z.ttf"
    },
    {
      "family": "Lugrasimo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lugrasimo/v5/qkBXXvoF_s_eT9c7Y7ae5JRLkAXbMQ.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lugrasimo/v5/qkBXXvoF_s_eT9c7Y7au5Z5P.ttf"
    },
    {
      "family": "Lumanosimo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lumanosimo/v5/K2F0fZBYg_JDSEZHEfO8AoqKAyLzfWo.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lumanosimo/v5/K2F0fZBYg_JDSEZHEfO8MouABw.ttf"
    },
    {
      "family": "Lunasima",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "hebrew",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lunasima/v1/wEO-EBvPh9RSOj7JFAwle94H1VIe.ttf",
        "700": "https://fonts.gstatic.com/s/lunasima/v1/wEO5EBvPh9RSOj7JFDSZVPoP_k4XiKvO.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lunasima/v1/wEO-EBvPh9RSOj7JFDwkcdo.ttf"
    },
    {
      "family": "Lusitana",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lusitana/v13/CSR84z9ShvucWzsMKxhaRuMiSct_.ttf",
        "700": "https://fonts.gstatic.com/s/lusitana/v13/CSR74z9ShvucWzsMKyDmaccqYtd2vfwk.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lusitana/v13/CSR84z9ShvucWzsMKyhbTOc.ttf"
    },
    {
      "family": "Lustria",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/lustria/v13/9oRONYodvDEyjuhOrCg5MtPyAcg.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/lustria/v13/9oRONYodvDEyjuhOnCkzNg.ttf"
    },
    {
      "family": "Luxurious Roman",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v9",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/luxuriousroman/v9/buEupou_ZcP1w0yTKxJJokVSmbpqYgckeo9RMw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/luxuriousroman/v9/buEupou_ZcP1w0yTKxJJokVSmbpaYw0g.ttf"
    },
    {
      "family": "Luxurious Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v8",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/luxuriousscript/v8/ahcCv9e7yydulT32KZ0rBIoD7DzMg0rOby1JtYk.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/luxuriousscript/v8/ahcCv9e7yydulT32KZ0rBIoD7DzMs0vEaw.ttf"
    },
    {
      "family": "M PLUS 1",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5VSe78nZcsGGycA.ttf",
        "200": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW51Sa78nZcsGGycA.ttf",
        "300": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5Cya78nZcsGGycA.ttf",
        "regular": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5VSa78nZcsGGycA.ttf",
        "500": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5Zya78nZcsGGycA.ttf",
        "600": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5iyG78nZcsGGycA.ttf",
        "700": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5siG78nZcsGGycA.ttf",
        "800": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW51SG78nZcsGGycA.ttf",
        "900": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5_CG78nZcsGGycA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mplus1/v14/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5VSaL83xY.ttf"
    },
    {
      "family": "M PLUS 1 Code",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7iN0XHpapwmdZhY.ttf",
        "200": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7gN0HHpapwmdZhY.ttf",
        "300": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7jT0HHpapwmdZhY.ttf",
        "regular": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7iN0HHpapwmdZhY.ttf",
        "500": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7i_0HHpapwmdZhY.ttf",
        "600": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7hT13HpapwmdZhY.ttf",
        "700": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7hq13HpapwmdZhY.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mplus1code/v15/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7iN0EHoYJg.ttf"
    },
    {
      "family": "M PLUS 1p",
      "variants": [
        "100",
        "300",
        "regular",
        "500",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "hebrew",
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v31",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/mplus1p/v31/e3tleuShHdiFyPFzBRrQnDQAUW3aq-5N.ttf",
        "300": "https://fonts.gstatic.com/s/mplus1p/v31/e3tmeuShHdiFyPFzBRrQVBYge0PWovdU4w.ttf",
        "regular": "https://fonts.gstatic.com/s/mplus1p/v31/e3tjeuShHdiFyPFzBRro-D4Ec2jKqw.ttf",
        "500": "https://fonts.gstatic.com/s/mplus1p/v31/e3tmeuShHdiFyPFzBRrQDBcge0PWovdU4w.ttf",
        "700": "https://fonts.gstatic.com/s/mplus1p/v31/e3tmeuShHdiFyPFzBRrQRBEge0PWovdU4w.ttf",
        "800": "https://fonts.gstatic.com/s/mplus1p/v31/e3tmeuShHdiFyPFzBRrQWBIge0PWovdU4w.ttf",
        "900": "https://fonts.gstatic.com/s/mplus1p/v31/e3tmeuShHdiFyPFzBRrQfBMge0PWovdU4w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mplus1p/v31/e3tjeuShHdiFyPFzBRrY-TQA.ttf"
    },
    {
      "family": "M PLUS 2",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v14",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwOa-VxlqHrzNgAw.ttf",
        "200": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwua6VxlqHrzNgAw.ttf",
        "300": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwZ66VxlqHrzNgAw.ttf",
        "regular": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwOa6VxlqHrzNgAw.ttf",
        "500": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwC66VxlqHrzNgAw.ttf",
        "600": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkw56mVxlqHrzNgAw.ttf",
        "700": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkw3qmVxlqHrzNgAw.ttf",
        "800": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwuamVxlqHrzNgAw.ttf",
        "900": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwkKmVxlqHrzNgAw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mplus2/v14/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwOa6lx1CD.ttf"
    },
    {
      "family": "M PLUS Code Latin",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1EbB6i5MqF9TRwg.ttf",
        "200": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1MbA6i5MqF9TRwg.ttf",
        "300": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1BjA6i5MqF9TRwg.ttf",
        "regular": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1EbA6i5MqF9TRwg.ttf",
        "500": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1HTA6i5MqF9TRwg.ttf",
        "600": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1JjH6i5MqF9TRwg.ttf",
        "700": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1KHH6i5MqF9TRwg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mpluscodelatin/v15/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1EbA2i9GrA.ttf"
    },
    {
      "family": "M PLUS Rounded 1c",
      "variants": [
        "100",
        "300",
        "regular",
        "500",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "hebrew",
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-25",
      "files": {
        "100": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGCAYIAV6gnpUpoWwNkYvrugw9RuM3ixLsg6-av1x0.ttf",
        "300": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM0q5psKxeqmzgRK.ttf",
        "regular": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGEAYIAV6gnpUpoWwNkYvrugw9RuPWGzr8C7vav.ttf",
        "500": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM1y55sKxeqmzgRK.ttf",
        "700": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM064ZsKxeqmzgRK.ttf",
        "800": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM0m4psKxeqmzgRK.ttf",
        "900": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM0C45sKxeqmzgRK.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mplusrounded1c/v19/VdGEAYIAV6gnpUpoWwNkYvrugw9RuMWHxLs.ttf"
    },
    {
      "family": "Ma Shan Zheng",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chinese-simplified",
        "latin"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mashanzheng/v13/NaPecZTRCLxvwo41b4gvzkXaRMTsDIRSfr0.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mashanzheng/v13/NaPecZTRCLxvwo41b4gvzkXadMXmCA.ttf"
    },
    {
      "family": "Macondo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/macondo/v26/RrQQboN9-iB1IXmOS2XO0LBBd4Y.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/macondo/v26/RrQQboN9-iB1IXmOe2TE1A.ttf"
    },
    {
      "family": "Macondo Swash Caps",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/macondoswashcaps/v25/6NUL8EaAJgGKZA7lpt941Z9s6ZYgDq6Oekoa_mm5bA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/macondoswashcaps/v25/6NUL8EaAJgGKZA7lpt941Z9s6ZYgDq6-e0Ae.ttf"
    },
    {
      "family": "Mada",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-29",
      "files": {
        "200": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFlOkHkw2-m9x2iC.ttf",
        "300": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFmQkHkw2-m9x2iC.ttf",
        "regular": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFnOkHkw2-m9x2iC.ttf",
        "500": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFn8kHkw2-m9x2iC.ttf",
        "600": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFkQl3kw2-m9x2iC.ttf",
        "700": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFkpl3kw2-m9x2iC.ttf",
        "800": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFlOl3kw2-m9x2iC.ttf",
        "900": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFlnl3kw2-m9x2iC.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mada/v20/7Aulp_0qnzeSVz7u3PJLcUMYOFnOkEkx0e0.ttf"
    },
    {
      "family": "Madimi One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/madimione/v1/2V0YKIEADpA8U6RygDnZZFQoBoHMd2U.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/madimione/v1/2V0YKIEADpA8U6RygDnZVFUiAg.ttf"
    },
    {
      "family": "Magra",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/magra/v14/uK_94ruaZus72k5xIDMfO-ed.ttf",
        "700": "https://fonts.gstatic.com/s/magra/v14/uK_w4ruaZus72nbNDxcXEPuUX1ow.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/magra/v14/uK_94ruaZus72n5wKjc.ttf"
    },
    {
      "family": "Maiden Orange",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v31",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/maidenorange/v31/kJE1BuIX7AUmhi2V4m08kb1XjOZdCZS8FY8.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/maidenorange/v31/kJE1BuIX7AUmhi2V4m08kb1XvOdXDQ.ttf"
    },
    {
      "family": "Maitree",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v10",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklhGNWJGovLdh6OE.ttf",
        "300": "https://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklnWOWJGovLdh6OE.ttf",
        "regular": "https://fonts.gstatic.com/s/maitree/v10/MjQGmil5tffhpBrkrtmmfJmDoL4.ttf",
        "500": "https://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrkli2PWJGovLdh6OE.ttf",
        "600": "https://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklgGIWJGovLdh6OE.ttf",
        "700": "https://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklmWJWJGovLdh6OE.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/maitree/v10/MjQGmil5tffhpBrkntiseA.ttf"
    },
    {
      "family": "Major Mono Display",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/majormonodisplay/v17/RWmVoLyb5fEqtsfBX9PDZIGr2tFubRhLCn2QIndPww.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/majormonodisplay/v17/RWmVoLyb5fEqtsfBX9PDZIGr2tFubRh7C3eU.ttf"
    },
    {
      "family": "Mako",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mako/v19/H4coBX6Mmc_Z0ST09g478Lo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mako/v19/H4coBX6Mmc_Z4SX-8g.ttf"
    },
    {
      "family": "Mali",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/mali/v12/N0bV2SRONuN4QOLlKlRaJdbWgdY.ttf",
        "200italic": "https://fonts.gstatic.com/s/mali/v12/N0bX2SRONuN4SCj8wlVQIfTTkdbJYA.ttf",
        "300": "https://fonts.gstatic.com/s/mali/v12/N0bV2SRONuN4QIbmKlRaJdbWgdY.ttf",
        "300italic": "https://fonts.gstatic.com/s/mali/v12/N0bX2SRONuN4SCj8plZQIfTTkdbJYA.ttf",
        "regular": "https://fonts.gstatic.com/s/mali/v12/N0ba2SRONuN4eCrODlxxOd8.ttf",
        "italic": "https://fonts.gstatic.com/s/mali/v12/N0bU2SRONuN4SCjECn50Kd_PmA.ttf",
        "500": "https://fonts.gstatic.com/s/mali/v12/N0bV2SRONuN4QN7nKlRaJdbWgdY.ttf",
        "500italic": "https://fonts.gstatic.com/s/mali/v12/N0bX2SRONuN4SCj8_ldQIfTTkdbJYA.ttf",
        "600": "https://fonts.gstatic.com/s/mali/v12/N0bV2SRONuN4QPLgKlRaJdbWgdY.ttf",
        "600italic": "https://fonts.gstatic.com/s/mali/v12/N0bX2SRONuN4SCj80lBQIfTTkdbJYA.ttf",
        "700": "https://fonts.gstatic.com/s/mali/v12/N0bV2SRONuN4QJbhKlRaJdbWgdY.ttf",
        "700italic": "https://fonts.gstatic.com/s/mali/v12/N0bX2SRONuN4SCj8tlFQIfTTkdbJYA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mali/v12/N0ba2SRONuN4SCvECg.ttf"
    },
    {
      "family": "Mallanna",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "telugu"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mallanna/v14/hv-Vlzx-KEQb84YaDGwzEzRwVvJ-.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mallanna/v14/hv-Vlzx-KEQb84YaDFwyGTA.ttf"
    },
    {
      "family": "Maname",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "sinhala",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/maname/v2/gNMFW3J8RpCx9my42FkGGI6q_Q.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/maname/v2/gNMFW3J8RpCx9myI2VMC.ttf"
    },
    {
      "family": "Mandali",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "telugu"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mandali/v15/LhWlMVbYOfASNfNUVFk1ZPdcKtA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mandali/v15/LhWlMVbYOfASNfNUZFg_YA.ttf"
    },
    {
      "family": "Manjari",
      "variants": [
        "100",
        "regular",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "malayalam"
      ],
      "version": "v13",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/manjari/v13/k3kSo8UPMOBO2w1UdbroK2vFIaOV8A.ttf",
        "regular": "https://fonts.gstatic.com/s/manjari/v13/k3kQo8UPMOBO2w1UTd7iL0nAMaM.ttf",
        "700": "https://fonts.gstatic.com/s/manjari/v13/k3kVo8UPMOBO2w1UdWLNC0HrLaqM6Q4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/manjari/v13/k3kQo8UPMOBO2w1Ufd_oKw.ttf"
    },
    {
      "family": "Manrope",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk59FO_F87jxeN7B.ttf",
        "300": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk6jFO_F87jxeN7B.ttf",
        "regular": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk79FO_F87jxeN7B.ttf",
        "500": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk7PFO_F87jxeN7B.ttf",
        "600": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk4jE-_F87jxeN7B.ttf",
        "700": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk4aE-_F87jxeN7B.ttf",
        "800": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk59E-_F87jxeN7B.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/manrope/v19/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk79FN_E-bw.ttf"
    },
    {
      "family": "Mansalva",
      "variants": [
        "regular"
      ],
      "subsets": [
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mansalva/v15/aWB4m0aacbtDfvq5NJllI47vdyBg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mansalva/v15/aWB4m0aacbtDfvq5NKlkKYo.ttf"
    },
    {
      "family": "Manuale",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeG6e7wD1TB_JHHY.ttf",
        "regular": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeHke7wD1TB_JHHY.ttf",
        "500": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeHWe7wD1TB_JHHY.ttf",
        "600": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeE6fLwD1TB_JHHY.ttf",
        "700": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeEDfLwD1TB_JHHY.ttf",
        "800": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeFkfLwD1TB_JHHY.ttf",
        "300italic": "https://fonts.gstatic.com/s/manuale/v30/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOApA3zRdIWHYr8M.ttf",
        "italic": "https://fonts.gstatic.com/s/manuale/v30/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOFRA3zRdIWHYr8M.ttf",
        "500italic": "https://fonts.gstatic.com/s/manuale/v30/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOGZA3zRdIWHYr8M.ttf",
        "600italic": "https://fonts.gstatic.com/s/manuale/v30/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOIpH3zRdIWHYr8M.ttf",
        "700italic": "https://fonts.gstatic.com/s/manuale/v30/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOLNH3zRdIWHYr8M.ttf",
        "800italic": "https://fonts.gstatic.com/s/manuale/v30/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsONRH3zRdIWHYr8M.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/manuale/v30/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeHke4wC3zQ.ttf"
    },
    {
      "family": "Manufacturing Consent",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/manufacturingconsent/v1/N0bL2TVONuFkPkuHfiECSLCwuZS-D-IsakikR6QvbfFYLA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/manufacturingconsent/v1/N0bL2TVONuFkPkuHfiECSLCwuZS-D-IsakiURq4r.ttf"
    },
    {
      "family": "Marcellus",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/marcellus/v13/wEO_EBrOk8hQLDvIAF8FUfAL3EsHiA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/marcellus/v13/wEO_EBrOk8hQLDvIAF81UPoP.ttf"
    },
    {
      "family": "Marcellus SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/marcellussc/v13/ke8iOgUHP1dg-Rmi6RWjbLEPgdydGKikhA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/marcellussc/v13/ke8iOgUHP1dg-Rmi6RWjbLE_gNaZ.ttf"
    },
    {
      "family": "Marck Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/marckscript/v21/nwpTtK2oNgBA3Or78gapdwuCzyI-aMPF7Q.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/marckscript/v21/nwpTtK2oNgBA3Or78gapdwuyzig6.ttf"
    },
    {
      "family": "Margarine",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/margarine/v26/qkBXXvoE6trLT9Y7YLye5JRLkAXbMQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/margarine/v26/qkBXXvoE6trLT9Y7YLyu5Z5P.ttf"
    },
    {
      "family": "Marhey",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/marhey/v7/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBZVwO2cXiGevOMw.ttf",
        "regular": "https://fonts.gstatic.com/s/marhey/v7/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBctwO2cXiGevOMw.ttf",
        "500": "https://fonts.gstatic.com/s/marhey/v7/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBflwO2cXiGevOMw.ttf",
        "600": "https://fonts.gstatic.com/s/marhey/v7/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBRV3O2cXiGevOMw.ttf",
        "700": "https://fonts.gstatic.com/s/marhey/v7/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBSx3O2cXiGevOMw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/marhey/v7/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBctwC2YdjA.ttf"
    },
    {
      "family": "Markazi Text",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v27",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/markazitext/v27/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtfSQT4MlBekmJLo.ttf",
        "500": "https://fonts.gstatic.com/s/markazitext/v27/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtcaQT4MlBekmJLo.ttf",
        "600": "https://fonts.gstatic.com/s/markazitext/v27/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtSqXT4MlBekmJLo.ttf",
        "700": "https://fonts.gstatic.com/s/markazitext/v27/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtROXT4MlBekmJLo.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/markazitext/v27/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtfSQf4IvAQ.ttf"
    },
    {
      "family": "Marko One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/markoone/v23/9Btq3DFG0cnVM5lw1haaKpUfrHPzUw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/markoone/v23/9Btq3DFG0cnVM5lw1haqK58b.ttf"
    },
    {
      "family": "Marmelad",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/marmelad/v18/Qw3eZQdSHj_jK2e-8tFLG-YMC0R8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/marmelad/v18/Qw3eZQdSHj_jK2e-8uFKEeI.ttf"
    },
    {
      "family": "Martel",
      "variants": [
        "200",
        "300",
        "regular",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/martel/v11/PN_yRfK9oXHga0XVqekahRbX9vnDzw.ttf",
        "300": "https://fonts.gstatic.com/s/martel/v11/PN_yRfK9oXHga0XVzeoahRbX9vnDzw.ttf",
        "regular": "https://fonts.gstatic.com/s/martel/v11/PN_xRfK9oXHga0XtYcI-jT3L_w.ttf",
        "600": "https://fonts.gstatic.com/s/martel/v11/PN_yRfK9oXHga0XVuewahRbX9vnDzw.ttf",
        "700": "https://fonts.gstatic.com/s/martel/v11/PN_yRfK9oXHga0XV3e0ahRbX9vnDzw.ttf",
        "800": "https://fonts.gstatic.com/s/martel/v11/PN_yRfK9oXHga0XVwe4ahRbX9vnDzw.ttf",
        "900": "https://fonts.gstatic.com/s/martel/v11/PN_yRfK9oXHga0XV5e8ahRbX9vnDzw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/martel/v11/PN_xRfK9oXHga0XdYMg6.ttf"
    },
    {
      "family": "Martel Sans",
      "variants": [
        "200",
        "300",
        "regular",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/martelsans/v13/h0GxssGi7VdzDgKjM-4d8hAX5suHFUknqMxQ.ttf",
        "300": "https://fonts.gstatic.com/s/martelsans/v13/h0GxssGi7VdzDgKjM-4d8hBz5cuHFUknqMxQ.ttf",
        "regular": "https://fonts.gstatic.com/s/martelsans/v13/h0GsssGi7VdzDgKjM-4d8ijfze-PPlUu.ttf",
        "600": "https://fonts.gstatic.com/s/martelsans/v13/h0GxssGi7VdzDgKjM-4d8hAH48uHFUknqMxQ.ttf",
        "700": "https://fonts.gstatic.com/s/martelsans/v13/h0GxssGi7VdzDgKjM-4d8hBj4suHFUknqMxQ.ttf",
        "800": "https://fonts.gstatic.com/s/martelsans/v13/h0GxssGi7VdzDgKjM-4d8hB_4cuHFUknqMxQ.ttf",
        "900": "https://fonts.gstatic.com/s/martelsans/v13/h0GxssGi7VdzDgKjM-4d8hBb4MuHFUknqMxQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/martelsans/v13/h0GsssGi7VdzDgKjM-4d8hjex-s.ttf"
    },
    {
      "family": "Martian Mono",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v5",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1qus6WD75kdpF2.ttf",
        "200": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY3qu86WD75kdpF2.ttf",
        "300": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY00u86WD75kdpF2.ttf",
        "regular": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1qu86WD75kdpF2.ttf",
        "500": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1Yu86WD75kdpF2.ttf",
        "600": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY20vM6WD75kdpF2.ttf",
        "700": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY2NvM6WD75kdpF2.ttf",
        "800": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY3qvM6WD75kdpF2.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/martianmono/v5/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1qu_6XBbo.ttf"
    },
    {
      "family": "Marvel",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/marvel/v17/nwpVtKeoNgBV0qaIkV7ED366zg.ttf",
        "italic": "https://fonts.gstatic.com/s/marvel/v17/nwpXtKeoNgBV0qa4k1TALXuqzhA7.ttf",
        "700": "https://fonts.gstatic.com/s/marvel/v17/nwpWtKeoNgBV0qawLXHgB1WmxwkiYQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/marvel/v17/nwpQtKeoNgBV0qa4k2x8Al-i5QwyYdrc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/marvel/v17/nwpVtKeoNgBV0qa4kFTA.ttf"
    },
    {
      "family": "Matangi",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-06-12",
      "files": {
        "300": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7PICDYwI8Gcw6Oi.ttf",
        "regular": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7OWCDYwI8Gcw6Oi.ttf",
        "500": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7OkCDYwI8Gcw6Oi.ttf",
        "600": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7NIDzYwI8Gcw6Oi.ttf",
        "700": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7NxDzYwI8Gcw6Oi.ttf",
        "800": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7MWDzYwI8Gcw6Oi.ttf",
        "900": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7M_DzYwI8Gcw6Oi.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/matangi/v1/kmKiZqE2FhDIeX2QvjZNI_5FGeJet7OWCAYxKcU.ttf"
    },
    {
      "family": "Mate",
      "variants": [
        "regular",
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mate/v18/m8JdjftRd7WZ2z28WoXSaLU.ttf",
        "italic": "https://fonts.gstatic.com/s/mate/v18/m8JTjftRd7WZ6z-2XqfXeLVdbw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mate/v18/m8JdjftRd7WZ6zy2Xg.ttf"
    },
    {
      "family": "Mate SC",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/matesc/v22/-nF8OGQ1-uoVr2wKyiXZ95OkJwA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/matesc/v22/-nF8OGQ1-uoVr2wK-iTT8w.ttf"
    },
    {
      "family": "Matemasie",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/matemasie/v4/OD5BuMCN3ne3Gmr7dlL3rEq4DL6w2w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/matemasie/v4/OD5BuMCN3ne3Gmr7dlLHrUC8.ttf"
    },
    {
      "family": "Material Icons",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v143",
      "lastModified": "2025-01-08",
      "files": {
        "regular": "https://fonts.gstatic.com/s/materialicons/v143/flUhRq6tzZclQEJ-Vdg-IuiaDsNZIhI8tIHh.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialicons/v143/flUhRq6tzZclQEJ-Vdg-IuiaDvNYKBY.ttf"
    },
    {
      "family": "Material Icons Outlined",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v110",
      "lastModified": "2025-06-17",
      "files": {
        "regular": "https://fonts.gstatic.com/s/materialiconsoutlined/v110/gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhUcdl5GuI2Ze.otf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialiconsoutlined/v110/gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhXcanZM.otf"
    },
    {
      "family": "Material Icons Round",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v109",
      "lastModified": "2025-06-17",
      "files": {
        "regular": "https://fonts.gstatic.com/s/materialiconsround/v109/LDItaoyNOAY6Uewc665JcIzCKsKc_M9flwmMq_fTTvg-.otf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialiconsround/v109/LDItaoyNOAY6Uewc665JcIzCKsKc_M9flzmLofU.otf"
    },
    {
      "family": "Material Icons Sharp",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v110",
      "lastModified": "2025-06-17",
      "files": {
        "regular": "https://fonts.gstatic.com/s/materialiconssharp/v110/oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvmvSImEyc0vd.otf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialiconssharp/v110/oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvlvVKGM.otf"
    },
    {
      "family": "Material Icons Two Tone",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v113",
      "lastModified": "2025-06-17",
      "files": {
        "regular": "https://fonts.gstatic.com/s/materialiconstwotone/v113/hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNCu3NjDrH_77.otf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialiconstwotone/v113/hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNBuwPDI.otf",
      "colorCapabilities": [
        "COLRv0"
      ]
    },
    {
      "family": "Material Symbols",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVXEHuRbn3PT2vOA.ttf",
        "200": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNV3EDuRbn3PT2vOA.ttf",
        "300": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVAkDuRbn3PT2vOA.ttf",
        "regular": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVXEDuRbn3PT2vOA.ttf",
        "500": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVbkDuRbn3PT2vOA.ttf",
        "600": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVgkfuRbn3PT2vOA.ttf",
        "700": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVu0fuRbn3PT2vOA.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialsymbols/v2/d6kSkb-sS9m3-i1LgQNcsFOOuLQXvG559b5GLMxCWRtThFK5gn7xw7XblIl2peTfMb7ONaa2_wzcUHR1Ukiw2RYw2vadH3BFk0G4701x-cU0BaNVXEDeRLPz.ttf"
    },
    {
      "family": "Material Symbols Outlined",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v254",
      "lastModified": "2025-06-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDCvHeembd5zrTgt.ttf",
        "200": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDAvHOembd5zrTgt.ttf",
        "300": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDDxHOembd5zrTgt.ttf",
        "regular": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDCvHOembd5zrTgt.ttf",
        "500": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDCdHOembd5zrTgt.ttf",
        "600": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDBxG-embd5zrTgt.ttf",
        "700": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDBIG-embd5zrTgt.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialsymbolsoutlined/v254/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDCvHNenZ9o.ttf"
    },
    {
      "family": "Material Symbols Rounded",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v255",
      "lastModified": "2025-06-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rIekXxKJKJBjAa8.ttf",
        "200": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rAelXxKJKJBjAa8.ttf",
        "300": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rNmlXxKJKJBjAa8.ttf",
        "regular": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rIelXxKJKJBjAa8.ttf",
        "500": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rLWlXxKJKJBjAa8.ttf",
        "600": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rFmiXxKJKJBjAa8.ttf",
        "700": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rGCiXxKJKJBjAa8.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialsymbolsrounded/v255/syl0-zNym6YjUruM-QrEh7-nyTnjDwKNJ_190FjpZIvDmUSVOK7BDB_Qb9vUSzq3wzLK-P0J-V_Zs-QtQth3-jOcbTCVpeRL2w5rwZu2rIelbxODLA.ttf"
    },
    {
      "family": "Material Symbols Sharp",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v251",
      "lastModified": "2025-06-23",
      "files": {
        "100": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxOLozCOJ1H7-knk.ttf",
        "200": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxMLojCOJ1H7-knk.ttf",
        "300": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxPVojCOJ1H7-knk.ttf",
        "regular": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxOLojCOJ1H7-knk.ttf",
        "500": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxO5ojCOJ1H7-knk.ttf",
        "600": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxNVpTCOJ1H7-knk.ttf",
        "700": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxNspTCOJ1H7-knk.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/materialsymbolssharp/v251/gNNBW2J8Roq16WD5tFNRaeLQk6-SHQ_R00k4c2_whPnoY9ruReaU4bHmz74m0ZkGH-VBYe1x0TV6x4yFH8F-H5OdzEL3sVTgJtfbYxOLogCPLVU.ttf"
    },
    {
      "family": "Maven Pro",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v39",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8SX25nCpozp5GvU.ttf",
        "500": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8Rf25nCpozp5GvU.ttf",
        "600": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8fvx5nCpozp5GvU.ttf",
        "700": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8cLx5nCpozp5GvU.ttf",
        "800": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8aXx5nCpozp5GvU.ttf",
        "900": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8Yzx5nCpozp5GvU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mavenpro/v39/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8SX21nGjpw.ttf"
    },
    {
      "family": "McLaren",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mclaren/v18/2EbnL-ZuAXFqZFXISYYf8z2Yt_c.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mclaren/v18/2EbnL-ZuAXFqZFXIeYcV9w.ttf"
    },
    {
      "family": "Mea Culpa",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/meaculpa/v7/AMOTz4GcuWbEIuza8jsZms0QW3mqyg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/meaculpa/v7/AMOTz4GcuWbEIuza8jspm8cU.ttf"
    },
    {
      "family": "Meddon",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/meddon/v26/kmK8ZqA2EgDNeHTZhBdB3y_Aow.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/meddon/v26/kmK8ZqA2EgDNeHTphR1F.ttf"
    },
    {
      "family": "MedievalSharp",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/medievalsharp/v27/EvOJzAlL3oU5AQl2mP5KdgptAq96MwvXLDk.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/medievalsharp/v27/EvOJzAlL3oU5AQl2mP5KdgptMq5wNw.ttf"
    },
    {
      "family": "Medula One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/medulaone/v19/YA9Wr0qb5kjJM6l2V0yukiEqs7GtlvY.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/medulaone/v19/YA9Wr0qb5kjJM6l2V0yuoiAgtw.ttf"
    },
    {
      "family": "Meera Inimai",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "tamil"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/meerainimai/v13/845fNMM5EIqOW5MPuvO3ILep_2jDVevnLQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/meerainimai/v13/845fNMM5EIqOW5MPuvO3ILeZ_mLH.ttf"
    },
    {
      "family": "Megrim",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/megrim/v17/46kulbz5WjvLqJZlbWXgd0RY1g.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/megrim/v17/46kulbz5WjvLqJZVbG_k.ttf"
    },
    {
      "family": "Meie Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/meiescript/v21/_LOImzDK7erRjhunIspaMjxn5IXg0WDz.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/meiescript/v21/_LOImzDK7erRjhunIspaMgxm7oE.ttf"
    },
    {
      "family": "Menbere",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "ethiopic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v1",
      "lastModified": "2025-06-25",
      "files": {
        "100": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdI_9qn1UnpeWOQ5.ttf",
        "200": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdK_96n1UnpeWOQ5.ttf",
        "300": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdJh96n1UnpeWOQ5.ttf",
        "regular": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdI_96n1UnpeWOQ5.ttf",
        "500": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdIN96n1UnpeWOQ5.ttf",
        "600": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdLh8Kn1UnpeWOQ5.ttf",
        "700": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdLY8Kn1UnpeWOQ5.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/menbere/v1/lJwY-p0zhmBrWvcG80OiXWeXfSDWXdI_95n0WH4.ttf"
    },
    {
      "family": "Meow Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v5",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/meowscript/v5/0FlQVPqanlaJrtr8AnJ0ESch0_0CfDf1.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/meowscript/v5/0FlQVPqanlaJrtr8AnJ0ERcg2fk.ttf"
    },
    {
      "family": "Merienda",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5JHhoSU78QGBV0A.ttf",
        "regular": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5enhoSU78QGBV0A.ttf",
        "500": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5SHhoSU78QGBV0A.ttf",
        "600": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5pH9oSU78QGBV0A.ttf",
        "700": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5nX9oSU78QGBV0A.ttf",
        "800": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5-n9oSU78QGBV0A.ttf",
        "900": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5039oSU78QGBV0A.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/merienda/v21/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5enhYSET4.ttf"
    },
    {
      "family": "Merriweather",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDrgCcqE1f0KvXKYQ.ttf",
        "regular": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDr3icqE1f0KvXKYQ.ttf",
        "500": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDr7CcqE1f0KvXKYQ.ttf",
        "600": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDrACAqE1f0KvXKYQ.ttf",
        "700": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDrOSAqE1f0KvXKYQ.ttf",
        "800": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDrXiAqE1f0KvXKYQ.ttf",
        "900": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDrdyAqE1f0KvXKYQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmScUF3wCPDaYa_F.ttf",
        "italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmTCUF3wCPDaYa_F.ttf",
        "500italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmTwUF3wCPDaYa_F.ttf",
        "600italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmQcV13wCPDaYa_F.ttf",
        "700italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmQlV13wCPDaYa_F.ttf",
        "800italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmRCV13wCPDaYa_F.ttf",
        "900italic": "https://fonts.gstatic.com/s/merriweather/v32/u-4B0qyriQwlOrhSvowK_l5-eTxCVx0ZbwLvKH2Gk9hLmp0v5yA-xXPqCzLvPee1XYk_XSf-FmRrV13wCPDaYa_F.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/merriweather/v32/u-4D0qyriQwlOrhSvowK_l5UcA6zuSYEqOzpPe3HOZJ5eX1WtLaQwmYiScCmDxhtNOKl8yDr3icaEl3w.ttf"
    },
    {
      "family": "Merriweather Sans",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v27",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZ_O4ljuEG7xFHnQ.ttf",
        "regular": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZou4ljuEG7xFHnQ.ttf",
        "500": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZkO4ljuEG7xFHnQ.ttf",
        "600": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZfOkljuEG7xFHnQ.ttf",
        "700": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZRekljuEG7xFHnQ.ttf",
        "800": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZIukljuEG7xFHnQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq2TzesCzRRXnaur.ttf",
        "italic": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq3NzesCzRRXnaur.ttf",
        "500italic": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq3_zesCzRRXnaur.ttf",
        "600italic": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq0TyusCzRRXnaur.ttf",
        "700italic": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq0qyusCzRRXnaur.ttf",
        "800italic": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq1NyusCzRRXnaur.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/merriweathersans/v27/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZou4Vj-sC.ttf"
    },
    {
      "family": "Metal",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v31",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/metal/v31/lW-wwjUJIXTo7i3nnoQAUdN2.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/metal/v31/lW-wwjUJIXTo7h3mlIA.ttf"
    },
    {
      "family": "Metal Mania",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/metalmania/v22/RWmMoKWb4e8kqMfBUdPFJeXCg6UKDXlq.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/metalmania/v22/RWmMoKWb4e8kqMfBUdPFJdXDiaE.ttf"
    },
    {
      "family": "Metamorphous",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/metamorphous/v21/Wnz8HA03aAXcC39ZEX5y1330PCCthTsmaQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/metamorphous/v21/Wnz8HA03aAXcC39ZEX5y133EPSqp.ttf"
    },
    {
      "family": "Metrophobic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/metrophobic/v23/sJoA3LZUhMSAPV_u0qwiAT-J737FPEEL.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/metrophobic/v23/sJoA3LZUhMSAPV_u0qwiAQ-I5Xo.ttf"
    },
    {
      "family": "Michroma",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/michroma/v20/PN_zRfy9qWD8fEagAMg6rzjb_-Da.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/michroma/v20/PN_zRfy9qWD8fEagAPg7pTw.ttf"
    },
    {
      "family": "Micro 5",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/micro5/v2/H4cnBX2MkcfEngTr0gYQ7LO5mqc.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/micro5/v2/H4cnBX2MkcfEngTr4gca6A.ttf"
    },
    {
      "family": "Micro 5 Charted",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/micro5charted/v2/hESp6XxmPDtTtADZhn7oD_yrmxEGRUsJQAlbUA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/micro5charted/v2/hESp6XxmPDtTtADZhn7oD_yrmxE2REEN.ttf"
    },
    {
      "family": "Milonga",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/milonga/v23/SZc53FHnIaK9W5kffz3GkUrS8DI.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/milonga/v23/SZc53FHnIaK9W5kfTzzMlQ.ttf"
    },
    {
      "family": "Miltonian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v31",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/miltonian/v31/zOL-4pbPn6Ne9JqTg9mr6e5As-FeiQ.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/miltonian/v31/zOL-4pbPn6Ne9JqTg9mb6ORE.ttf"
    },
    {
      "family": "Miltonian Tattoo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v33",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/miltoniantattoo/v33/EvOUzBRL0o0kCxF-lcMCQxlpVsA_FwP8MDBku-s.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/miltoniantattoo/v33/EvOUzBRL0o0kCxF-lcMCQxlpVsA_JwL2NA.ttf"
    },
    {
      "family": "Mina",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "bengali",
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mina/v13/-nFzOGc18vARrz9j7i3y65o.ttf",
        "700": "https://fonts.gstatic.com/s/mina/v13/-nF8OGc18vARl4NMyiXZ95OkJwA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mina/v13/-nFzOGc18vARnz5p6g.ttf"
    },
    {
      "family": "Mingzat",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "lepcha"
      ],
      "version": "v10",
      "lastModified": "2025-06-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mingzat/v10/0QIgMX5C-o-oWWyvBttkm_mv670.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mingzat/v10/0QIgMX5C-o-oWWyvNtpunw.ttf"
    },
    {
      "family": "Miniver",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/miniver/v26/eLGcP-PxIg-5H0vC770Cy8r8fWA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/miniver/v26/eLGcP-PxIg-5H0vC37wIzw.ttf"
    },
    {
      "family": "Miriam Libre",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/miriamlibre/v18/DdT0798HsHwubBAqfkcBTL_1a7sPlXcE8PJjH9P3k9vGL-8tY7Q.ttf",
        "500": "https://fonts.gstatic.com/s/miriamlibre/v18/DdT0798HsHwubBAqfkcBTL_1a7sPlXcE8PJjH-H3k9vGL-8tY7Q.ttf",
        "600": "https://fonts.gstatic.com/s/miriamlibre/v18/DdT0798HsHwubBAqfkcBTL_1a7sPlXcE8PJjHw3wk9vGL-8tY7Q.ttf",
        "700": "https://fonts.gstatic.com/s/miriamlibre/v18/DdT0798HsHwubBAqfkcBTL_1a7sPlXcE8PJjHzTwk9vGL-8tY7Q.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/miriamlibre/v18/DdT0798HsHwubBAqfkcBTL_1a7sPlXcE8PJjH9P3o9rMKw.ttf"
    },
    {
      "family": "Mirza",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mirza/v18/co3ImWlikiN5EurdKMewsrvI.ttf",
        "500": "https://fonts.gstatic.com/s/mirza/v18/co3FmWlikiN5EtIpAeO4mafBomDi.ttf",
        "600": "https://fonts.gstatic.com/s/mirza/v18/co3FmWlikiN5EtIFBuO4mafBomDi.ttf",
        "700": "https://fonts.gstatic.com/s/mirza/v18/co3FmWlikiN5EtJhB-O4mafBomDi.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mirza/v18/co3ImWlikiN5EtrcIsM.ttf"
    },
    {
      "family": "Miss Fajardose",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/missfajardose/v22/E21-_dn5gvrawDdPFVl-N0Ajb8qvWPaJq4no.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/missfajardose/v22/E21-_dn5gvrawDdPFVl-N0Ajb_quUvI.ttf"
    },
    {
      "family": "Mitr",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/mitr/v12/pxiEypw5ucZF8fMZFJDUc1NECPY.ttf",
        "300": "https://fonts.gstatic.com/s/mitr/v12/pxiEypw5ucZF8ZcaFJDUc1NECPY.ttf",
        "regular": "https://fonts.gstatic.com/s/mitr/v12/pxiLypw5ucZFyTsyMJj_b1o.ttf",
        "500": "https://fonts.gstatic.com/s/mitr/v12/pxiEypw5ucZF8c8bFJDUc1NECPY.ttf",
        "600": "https://fonts.gstatic.com/s/mitr/v12/pxiEypw5ucZF8eMcFJDUc1NECPY.ttf",
        "700": "https://fonts.gstatic.com/s/mitr/v12/pxiEypw5ucZF8YcdFJDUc1NECPY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mitr/v12/pxiLypw5ucZF-To4NA.ttf"
    },
    {
      "family": "Mochiy Pop One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mochiypopone/v11/QdVPSTA9Jh-gg-5XZP2UmU4O9kwwD3s6ZKAi.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mochiypopone/v11/QdVPSTA9Jh-gg-5XZP2UmU4O9nwxBX8.ttf"
    },
    {
      "family": "Mochiy Pop P One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin"
      ],
      "version": "v11",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mochiypoppone/v11/Ktk2AKuPeY_td1-h9LayHYWCjAqyN4O3WYZB_sU.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mochiypoppone/v11/Ktk2AKuPeY_td1-h9LayHYWCjAqyB4K9XQ.ttf"
    },
    {
      "family": "Modak",
      "variants": [
        "regular"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/modak/v20/EJRYQgs1XtIEsnMH8BVZ76KU.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/modak/v20/EJRYQgs1XtIEskMG-hE.ttf"
    },
    {
      "family": "Modern Antiqua",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/modernantiqua/v25/NGStv5TIAUg6Iq_RLNo_2dp1sI1Ea2u0c3Gi.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/modernantiqua/v25/NGStv5TIAUg6Iq_RLNo_2dp1sL1FYW8.ttf"
    },
    {
      "family": "Moderustic",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "latin",
        "latin-ext"
      ],
      "version": "v2",
      "lastModified": "2025-05-29",
      "files": {
        "300": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjBVsTNe55aRa7UE.ttf",
        "regular": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjALsTNe55aRa7UE.ttf",
        "500": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjA5sTNe55aRa7UE.ttf",
        "600": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjDVtjNe55aRa7UE.ttf",
        "700": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjDstjNe55aRa7UE.ttf",
        "800": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjCLtjNe55aRa7UE.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/moderustic/v2/2-c39J9s3o6eLFNHFdXYaOX1UUnf3GLnYjALsQNf7ZI.ttf"
    },
    {
      "family": "Mogra",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mogra/v21/f0X40eSs8c95TBo4DvLmxtnG.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mogra/v21/f0X40eSs8c95TCo5BPY.ttf"
    },
    {
      "family": "Mohave",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "300": "https://fonts.gstatic.com/s/mohave/v12/7cH0v4ksjJunKqMVAOPIMOeSmiojdif_HvCQopLSvBk.ttf",
        "regular": "https://fonts.gstatic.com/s/mohave/v12/7cH0v4ksjJunKqMVAOPIMOeSmiojdnn_HvCQopLSvBk.ttf",
        "500": "https://fonts.gstatic.com/s/mohave/v12/7cH0v4ksjJunKqMVAOPIMOeSmiojdkv_HvCQopLSvBk.ttf",
        "600": "https://fonts.gstatic.com/s/mohave/v12/7cH0v4ksjJunKqMVAOPIMOeSmiojdqf4HvCQopLSvBk.ttf",
        "700": "https://fonts.gstatic.com/s/mohave/v12/7cH0v4ksjJunKqMVAOPIMOeSmiojdp74HvCQopLSvBk.ttf",
        "300italic": "https://fonts.gstatic.com/s/mohave/v12/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8qLOaprDXrBlSVw.ttf",
        "italic": "https://fonts.gstatic.com/s/mohave/v12/7cH2v4ksjJunKqM_CdE36I75AIQkY7G89rOaprDXrBlSVw.ttf",
        "500italic": "https://fonts.gstatic.com/s/mohave/v12/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8xLOaprDXrBlSVw.ttf",
        "600italic": "https://fonts.gstatic.com/s/mohave/v12/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8KLSaprDXrBlSVw.ttf",
        "700italic": "https://fonts.gstatic.com/s/mohave/v12/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8EbSaprDXrBlSVw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mohave/v12/7cH0v4ksjJunKqMVAOPIMOeSmiojdnn_LvGapg.ttf"
    },
    {
      "family": "Moirai One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/moiraione/v1/2sDbZGFUgJLJmby6xgNGT0WWB7UcfCg.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/moiraione/v1/2sDbZGFUgJLJmby6xgNGf0ScAw.ttf"
    },
    {
      "family": "Molengo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/molengo/v16/I_uuMpWeuBzZNBtQbbRQkiCvs5Y.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/molengo/v16/I_uuMpWeuBzZNBtQXbValg.ttf"
    },
    {
      "family": "Molle",
      "variants": [
        "italic"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "italic": "https://fonts.gstatic.com/s/molle/v24/E21n_dL5hOXFhWEsXzgmVydREus.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/molle/v24/E21n_dL5hOXFhWEsbzksUw.ttf"
    },
    {
      "family": "Mona Sans",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyB9A99d41P6zHtY.ttf",
        "300": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyCjA99d41P6zHtY.ttf",
        "regular": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyD9A99d41P6zHtY.ttf",
        "500": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyDPA99d41P6zHtY.ttf",
        "600": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyAjBN9d41P6zHtY.ttf",
        "700": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyAaBN9d41P6zHtY.ttf",
        "800": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyB9BN9d41P6zHtY.ttf",
        "900": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyBUBN9d41P6zHtY.ttf",
        "200italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QLce6VfYyWtY1rI.ttf",
        "300italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QGke6VfYyWtY1rI.ttf",
        "italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QDce6VfYyWtY1rI.ttf",
        "500italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QAUe6VfYyWtY1rI.ttf",
        "600italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QOkZ6VfYyWtY1rI.ttf",
        "700italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QNAZ6VfYyWtY1rI.ttf",
        "800italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QLcZ6VfYyWtY1rI.ttf",
        "900italic": "https://fonts.gstatic.com/s/monasans/v3/o-0kIpQmx24alC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QJ4Z6VfYyWtY1rI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monasans/v3/o-0mIpQmx24alC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyD9A-9c6Vc.ttf"
    },
    {
      "family": "Monda",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/monda/v18/TK3-WkYFABsmjuBtFuvTIFRAPpWsH3oMoWtGaA-Ijw.ttf",
        "500": "https://fonts.gstatic.com/s/monda/v18/TK3-WkYFABsmjuBtFuvTIFRAPpWsLXoMoWtGaA-Ijw.ttf",
        "600": "https://fonts.gstatic.com/s/monda/v18/TK3-WkYFABsmjuBtFuvTIFRAPpWswX0MoWtGaA-Ijw.ttf",
        "700": "https://fonts.gstatic.com/s/monda/v18/TK3-WkYFABsmjuBtFuvTIFRAPpWs-H0MoWtGaA-Ijw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monda/v18/TK3-WkYFABsmjuBtFuvTIFRAPpWsH3o8oGFC.ttf"
    },
    {
      "family": "Monofett",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/monofett/v23/mFTyWbofw6zc9NtnW43SuRwr0VJ7.ttf"
      },
      "category": "monospace",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monofett/v23/mFTyWbofw6zc9NtnW73Tsxg.ttf"
    },
    {
      "family": "Monomakh",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/monomakh/v1/Wnz4HAk3Yh_SC3FACTYdiArcPRKo.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monomakh/v1/Wnz4HAk3Yh_SC3FACQYcgg4.ttf"
    },
    {
      "family": "Monomaniac One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-06-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/monomaniacone/v14/4iC06K17YctZjx50EU-QlwPmcqRnqYkB5kwI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monomaniacone/v14/4iC06K17YctZjx50EU-QlwPmcpRmo40.ttf"
    },
    {
      "family": "Monoton",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/monoton/v21/5h1aiZUrOngCibe4fkbBQ2S7FU8.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monoton/v21/5h1aiZUrOngCibe4TkfLRw.ttf"
    },
    {
      "family": "Monsieur La Doulaise",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/monsieurladoulaise/v19/_Xmz-GY4rjmCbQfc-aPRaa4pqV340p7EZl5ewkEU4HTy.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/monsieurladoulaise/v19/_Xmz-GY4rjmCbQfc-aPRaa4pqV340p7EZm5fyEU.ttf"
    },
    {
      "family": "Montaga",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/montaga/v13/H4cnBX2Ml8rCkEO_0gYQ7LO5mqc.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montaga/v13/H4cnBX2Ml8rCkEO_4gca6A.ttf"
    },
    {
      "family": "Montagu Slab",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDbE3P9Fs7bOSO7.ttf",
        "200": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkBbEnP9Fs7bOSO7.ttf",
        "300": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkCFEnP9Fs7bOSO7.ttf",
        "regular": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDbEnP9Fs7bOSO7.ttf",
        "500": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDpEnP9Fs7bOSO7.ttf",
        "600": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkAFFXP9Fs7bOSO7.ttf",
        "700": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkA8FXP9Fs7bOSO7.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montaguslab/v16/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDbEkP8HMo.ttf"
    },
    {
      "family": "MonteCarlo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v12",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/montecarlo/v12/buEzpo6-f9X01GadLA0G0CoV_NxLeiw.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montecarlo/v12/buEzpo6-f9X01GadLA0G4Csf-A.ttf"
    },
    {
      "family": "Montez",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/montez/v24/845ZNMk5GoGIX8lm1LDeSd-R_g.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montez/v24/845ZNMk5GoGIX8lW1bra.ttf"
    },
    {
      "family": "Montserrat",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v30",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtr6Uw-Y3tcoqK5.ttf",
        "200": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCvr6Ew-Y3tcoqK5.ttf",
        "300": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCs16Ew-Y3tcoqK5.ttf",
        "regular": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtr6Ew-Y3tcoqK5.ttf",
        "500": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtZ6Ew-Y3tcoqK5.ttf",
        "600": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCu170w-Y3tcoqK5.ttf",
        "700": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCuM70w-Y3tcoqK5.ttf",
        "800": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCvr70w-Y3tcoqK5.ttf",
        "900": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCvC70w-Y3tcoqK5.ttf",
        "100italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq6R8aX9-p7K5ILg.ttf",
        "200italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jqyR9aX9-p7K5ILg.ttf",
        "300italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq_p9aX9-p7K5ILg.ttf",
        "italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq6R9aX9-p7K5ILg.ttf",
        "500italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq5Z9aX9-p7K5ILg.ttf",
        "600italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq3p6aX9-p7K5ILg.ttf",
        "700italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq0N6aX9-p7K5ILg.ttf",
        "800italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jqyR6aX9-p7K5ILg.ttf",
        "900italic": "https://fonts.gstatic.com/s/montserrat/v30/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jqw16aX9-p7K5ILg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montserrat/v30/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtr6Hw_aX8.ttf"
    },
    {
      "family": "Montserrat Alternates",
      "variants": [
        "100",
        "100italic",
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic",
        "800",
        "800italic",
        "900",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/montserratalternates/v17/mFThWacfw6zH4dthXcyms1lPpC8I_b0juU0xiKfVKphL03l4.ttf",
        "100italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTjWacfw6zH4dthXcyms1lPpC8I_b0juU057p-xIJxp1ml4imo.ttf",
        "200": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xJIb1ALZH2mBhkw.ttf",
        "200italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p8dAbxD-GVxk3Nd.ttf",
        "300": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xQIX1ALZH2mBhkw.ttf",
        "300italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p95ArxD-GVxk3Nd.ttf",
        "regular": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTvWacfw6zH4dthXcyms1lPpC8I_b0juU0J7K3RCJ1b0w.ttf",
        "italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFThWacfw6zH4dthXcyms1lPpC8I_b0juU057qfVKphL03l4.ttf",
        "500": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xGIT1ALZH2mBhkw.ttf",
        "500italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p8hA7xD-GVxk3Nd.ttf",
        "600": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xNIP1ALZH2mBhkw.ttf",
        "600italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p8NBLxD-GVxk3Nd.ttf",
        "700": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xUIL1ALZH2mBhkw.ttf",
        "700italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p9pBbxD-GVxk3Nd.ttf",
        "800": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xTIH1ALZH2mBhkw.ttf",
        "800italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p91BrxD-GVxk3Nd.ttf",
        "900": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xaID1ALZH2mBhkw.ttf",
        "900italic": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p9RB7xD-GVxk3Nd.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montserratalternates/v17/mFTvWacfw6zH4dthXcyms1lPpC8I_b0juU057afV.ttf"
    },
    {
      "family": "Montserrat Underline",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "100": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5Wil8ubbffHtmMw.ttf",
        "200": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F52ih8ubbffHtmMw.ttf",
        "300": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5BCh8ubbffHtmMw.ttf",
        "regular": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5Wih8ubbffHtmMw.ttf",
        "500": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5aCh8ubbffHtmMw.ttf",
        "600": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5hC98ubbffHtmMw.ttf",
        "700": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5vS98ubbffHtmMw.ttf",
        "800": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F52i98ubbffHtmMw.ttf",
        "900": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F58y98ubbffHtmMw.ttf",
        "100italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmuU-7zbXn52M1Mi.ttf",
        "200italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmsU-rzbXn52M1Mi.ttf",
        "300italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmvK-rzbXn52M1Mi.ttf",
        "italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmuU-rzbXn52M1Mi.ttf",
        "500italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmum-rzbXn52M1Mi.ttf",
        "600italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmtK_bzbXn52M1Mi.ttf",
        "700italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmtz_bzbXn52M1Mi.ttf",
        "800italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskmsU_bzbXn52M1Mi.ttf",
        "900italic": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTdWaYfw6zH4dthXcyms01NtC8I_7U5uS4r1ozd9EzeaWZskms9_bzbXn52M1Mi.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/montserratunderline/v2/mFTbWaYfw6zH4dthXcyms01NtC8I_7U5uQQi5HMFnSdEx2F5WihMuLzb.ttf"
    },
    {
      "family": "Moo Lah Lah",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/moolahlah/v7/dg4h_p_opKZOA0w1AYcm55wtYQYugjW4.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/moolahlah/v7/dg4h_p_opKZOA0w1AYcm56wsawI.ttf"
    },
    {
      "family": "Mooli",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mooli/v1/-F6_fjJpLyk1bYPBBG7YpzlJ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mooli/v1/-F6_fjJpLyk1bbPADmo.ttf"
    },
    {
      "family": "Moon Dance",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/moondance/v7/WBLgrEbUbFlYW9ekmGawe2XiKMiokE4.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/moondance/v7/WBLgrEbUbFlYW9ekmGawS2ToLA.ttf"
    },
    {
      "family": "Moul",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/moul/v29/nuF2D__FSo_3E-RYiJCy-00.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/moul/v29/nuF2D__FSo_3I-VSjA.ttf"
    },
    {
      "family": "Moulpali",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v32",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/moulpali/v32/H4ckBXKMl9HagUWymyY6wr-wg763.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/moulpali/v32/H4ckBXKMl9HagUWymxY7yLs.ttf"
    },
    {
      "family": "Mountains of Christmas",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mountainsofchristmas/v23/3y9w6a4zcCnn5X0FDyrKi2ZRUBIy8uxoUo7ePNamMPNpJpc.ttf",
        "700": "https://fonts.gstatic.com/s/mountainsofchristmas/v23/3y9z6a4zcCnn5X0FDyrKi2ZRUBIy8uxoUo7eBGqJFPtCOp6IaEA.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mountainsofchristmas/v23/3y9w6a4zcCnn5X0FDyrKi2ZRUBIy8uxoUo7eDNesNA.ttf"
    },
    {
      "family": "Mouse Memoirs",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mousememoirs/v18/t5tmIRoSNJ-PH0WNNgDYxdSb7TnFrpOHYh4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mousememoirs/v18/t5tmIRoSNJ-PH0WNNgDYxdSb3TjPqg.ttf"
    },
    {
      "family": "Mr Bedfort",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mrbedfort/v22/MQpR-WCtNZSWAdTMwBicliq0XZe_Iy8.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mrbedfort/v22/MQpR-WCtNZSWAdTMwBicpiu-WQ.ttf"
    },
    {
      "family": "Mr Dafoe",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mrdafoe/v14/lJwE-pIzkS5NXuMMrGiqg7MCxz_C.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mrdafoe/v14/lJwE-pIzkS5NXuMMrFiribc.ttf"
    },
    {
      "family": "Mr De Haviland",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mrdehaviland/v14/OpNVnooIhJj96FdB73296ksbOj3C4ULVNTlB.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mrdehaviland/v14/OpNVnooIhJj96FdB73296ksbOg3D60Y.ttf"
    },
    {
      "family": "Mrs Saint Delafield",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v13",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mrssaintdelafield/v13/v6-IGZDIOVXH9xtmTZfRagunqBw5WC62cK4tLsubB2w.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mrssaintdelafield/v13/v6-IGZDIOVXH9xtmTZfRagunqBw5WC62QK8nKg.ttf"
    },
    {
      "family": "Mrs Sheppards",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mrssheppards/v24/PN_2Rfm9snC0XUGoEZhb91ig3vjxynMix4Y.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mrssheppards/v24/PN_2Rfm9snC0XUGoEZhb91ig7vn7zg.ttf"
    },
    {
      "family": "Ms Madi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/msmadi/v2/HTxsL2UxNnOji5E1N-DPiI7QAYo.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/msmadi/v2/HTxsL2UxNnOji5E1B-HFjA.ttf"
    },
    {
      "family": "Mukta",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/mukta/v16/iJWHBXyXfDDVXbEOjFma-2HW7ZB_.ttf",
        "300": "https://fonts.gstatic.com/s/mukta/v16/iJWHBXyXfDDVXbFqj1ma-2HW7ZB_.ttf",
        "regular": "https://fonts.gstatic.com/s/mukta/v16/iJWKBXyXfDDVXYnGp32S0H3f.ttf",
        "500": "https://fonts.gstatic.com/s/mukta/v16/iJWHBXyXfDDVXbEyjlma-2HW7ZB_.ttf",
        "600": "https://fonts.gstatic.com/s/mukta/v16/iJWHBXyXfDDVXbEeiVma-2HW7ZB_.ttf",
        "700": "https://fonts.gstatic.com/s/mukta/v16/iJWHBXyXfDDVXbF6iFma-2HW7ZB_.ttf",
        "800": "https://fonts.gstatic.com/s/mukta/v16/iJWHBXyXfDDVXbFmi1ma-2HW7ZB_.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mukta/v16/iJWKBXyXfDDVXbnHrXk.ttf"
    },
    {
      "family": "Mukta Mahee",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/muktamahee/v18/XRXN3IOIi0hcP8iVU67hA9MFcBoHJndqZCsW.ttf",
        "300": "https://fonts.gstatic.com/s/muktamahee/v18/XRXN3IOIi0hcP8iVU67hA9NhcxoHJndqZCsW.ttf",
        "regular": "https://fonts.gstatic.com/s/muktamahee/v18/XRXQ3IOIi0hcP8iVU67hA-vNWz4PDWtj.ttf",
        "500": "https://fonts.gstatic.com/s/muktamahee/v18/XRXN3IOIi0hcP8iVU67hA9M5choHJndqZCsW.ttf",
        "600": "https://fonts.gstatic.com/s/muktamahee/v18/XRXN3IOIi0hcP8iVU67hA9MVdRoHJndqZCsW.ttf",
        "700": "https://fonts.gstatic.com/s/muktamahee/v18/XRXN3IOIi0hcP8iVU67hA9NxdBoHJndqZCsW.ttf",
        "800": "https://fonts.gstatic.com/s/muktamahee/v18/XRXN3IOIi0hcP8iVU67hA9NtdxoHJndqZCsW.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/muktamahee/v18/XRXQ3IOIi0hcP8iVU67hA9vMUTo.ttf"
    },
    {
      "family": "Mukta Malar",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "tamil"
      ],
      "version": "v13",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/muktamalar/v13/MCoKzAXyz8LOE2FpJMxZqIMwBtAB62ruoAZW.ttf",
        "300": "https://fonts.gstatic.com/s/muktamalar/v13/MCoKzAXyz8LOE2FpJMxZqINUBdAB62ruoAZW.ttf",
        "regular": "https://fonts.gstatic.com/s/muktamalar/v13/MCoXzAXyz8LOE2FpJMxZqLv4LfQJwHbn.ttf",
        "500": "https://fonts.gstatic.com/s/muktamalar/v13/MCoKzAXyz8LOE2FpJMxZqIMMBNAB62ruoAZW.ttf",
        "600": "https://fonts.gstatic.com/s/muktamalar/v13/MCoKzAXyz8LOE2FpJMxZqIMgA9AB62ruoAZW.ttf",
        "700": "https://fonts.gstatic.com/s/muktamalar/v13/MCoKzAXyz8LOE2FpJMxZqINEAtAB62ruoAZW.ttf",
        "800": "https://fonts.gstatic.com/s/muktamalar/v13/MCoKzAXyz8LOE2FpJMxZqINYAdAB62ruoAZW.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/muktamalar/v13/MCoXzAXyz8LOE2FpJMxZqIv5J_A.ttf"
    },
    {
      "family": "Mukta Vaani",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext"
      ],
      "version": "v14",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/muktavaani/v14/3JnkSD_-ynaxmxnEfVHPIGXNV8BD-u97MW1a.ttf",
        "300": "https://fonts.gstatic.com/s/muktavaani/v14/3JnkSD_-ynaxmxnEfVHPIGWpVMBD-u97MW1a.ttf",
        "regular": "https://fonts.gstatic.com/s/muktavaani/v14/3Jn5SD_-ynaxmxnEfVHPIF0FfORL0fNy.ttf",
        "500": "https://fonts.gstatic.com/s/muktavaani/v14/3JnkSD_-ynaxmxnEfVHPIGXxVcBD-u97MW1a.ttf",
        "600": "https://fonts.gstatic.com/s/muktavaani/v14/3JnkSD_-ynaxmxnEfVHPIGXdUsBD-u97MW1a.ttf",
        "700": "https://fonts.gstatic.com/s/muktavaani/v14/3JnkSD_-ynaxmxnEfVHPIGW5U8BD-u97MW1a.ttf",
        "800": "https://fonts.gstatic.com/s/muktavaani/v14/3JnkSD_-ynaxmxnEfVHPIGWlUMBD-u97MW1a.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/muktavaani/v14/3Jn5SD_-ynaxmxnEfVHPIG0EduA.ttf"
    },
    {
      "family": "Mulish",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v17",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexRNRwaClGrw-PTY.ttf",
        "300": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexc1RwaClGrw-PTY.ttf",
        "regular": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexZNRwaClGrw-PTY.ttf",
        "500": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexaFRwaClGrw-PTY.ttf",
        "600": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexU1WwaClGrw-PTY.ttf",
        "700": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexXRWwaClGrw-PTY.ttf",
        "800": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexRNWwaClGrw-PTY.ttf",
        "900": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexTpWwaClGrw-PTY.ttf",
        "200italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSqeOvHp47LTZFwA.ttf",
        "300italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSd-OvHp47LTZFwA.ttf",
        "italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSKeOvHp47LTZFwA.ttf",
        "500italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSG-OvHp47LTZFwA.ttf",
        "600italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsS9-SvHp47LTZFwA.ttf",
        "700italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSzuSvHp47LTZFwA.ttf",
        "800italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSqeSvHp47LTZFwA.ttf",
        "900italic": "https://fonts.gstatic.com/s/mulish/v17/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSgOSvHp47LTZFwA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mulish/v17/1Ptyg83HX_SGhgqO0yLcmjzUAuWexZNR8aGvHg.ttf"
    },
    {
      "family": "Murecho",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpr5HWZLCpUOaM6.ttf",
        "200": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMrr5XWZLCpUOaM6.ttf",
        "300": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMo15XWZLCpUOaM6.ttf",
        "regular": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpr5XWZLCpUOaM6.ttf",
        "500": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpZ5XWZLCpUOaM6.ttf",
        "600": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMq14nWZLCpUOaM6.ttf",
        "700": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMqM4nWZLCpUOaM6.ttf",
        "800": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMrr4nWZLCpUOaM6.ttf",
        "900": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMrC4nWZLCpUOaM6.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/murecho/v16/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpr5UWYJi4.ttf"
    },
    {
      "family": "MuseoModerno",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v28",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMlZFuewajeKlCdo.ttf",
        "200": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMtZEuewajeKlCdo.ttf",
        "300": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMghEuewajeKlCdo.ttf",
        "regular": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMlZEuewajeKlCdo.ttf",
        "500": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMmREuewajeKlCdo.ttf",
        "600": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMohDuewajeKlCdo.ttf",
        "700": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMrFDuewajeKlCdo.ttf",
        "800": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMtZDuewajeKlCdo.ttf",
        "900": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMv9DuewajeKlCdo.ttf",
        "100italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HUa4QicCgGdrS3g.ttf",
        "200italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54H0a8QicCgGdrS3g.ttf",
        "300italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HD68QicCgGdrS3g.ttf",
        "italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HUa8QicCgGdrS3g.ttf",
        "500italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HY68QicCgGdrS3g.ttf",
        "600italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54Hj6gQicCgGdrS3g.ttf",
        "700italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HtqgQicCgGdrS3g.ttf",
        "800italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54H0agQicCgGdrS3g.ttf",
        "900italic": "https://fonts.gstatic.com/s/museomoderno/v28/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54H-KgQicCgGdrS3g.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/museomoderno/v28/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMlZEie0QiQ.ttf"
    },
    {
      "family": "My Soul",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v6",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mysoul/v6/3XFqErcuy945_u6KF_Ulk2nnXf0.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mysoul/v6/3XFqErcuy945_u6KJ_Qvlw.ttf"
    },
    {
      "family": "Mynerve",
      "variants": [
        "regular"
      ],
      "subsets": [
        "greek",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mynerve/v7/P5sCzZKPdNjb4jt7xCRuiZ-uydg.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mynerve/v7/P5sCzZKPdNjb4jt79CVkjQ.ttf"
    },
    {
      "family": "Mystery Quest",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/mysteryquest/v20/-nF6OG414u0E6k0wynSGlujRHwElD_9Qz9E.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/mysteryquest/v20/-nF6OG414u0E6k0wynSGlujRLwAvCw.ttf"
    },
    {
      "family": "NTR",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "telugu"
      ],
      "version": "v18",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/ntr/v18/RLpzK5Xy0ZjiGGhs5TA4bg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/ntr/v18/RLpzK5Xy0ZjSGWJo.ttf"
    },
    {
      "family": "Nabla",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "latin",
        "latin-ext",
        "math",
        "vietnamese"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nabla/v16/j8_D6-LI0Lvpe7Makz5UhJt9C3uqg_X_75gyGS4jAxsNIjrRNRBUFFR_198.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nabla/v16/j8_D6-LI0Lvpe7Makz5UhJt9C3uqg_X_75gyGS4jAxsNIjrRBRFeEA.ttf",
      "colorCapabilities": [
        "COLRv1",
        "SVG"
      ]
    },
    {
      "family": "Namdhinggo",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "limbu"
      ],
      "version": "v2",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/namdhinggo/v2/uk-mEGe3rbgg8Xzoy5-TDnWj4yxx7o8.ttf",
        "500": "https://fonts.gstatic.com/s/namdhinggo/v2/uk-lEGe3rbgg8Xzoy5-TNoGKxyRa8oZK9I0.ttf",
        "600": "https://fonts.gstatic.com/s/namdhinggo/v2/uk-lEGe3rbgg8Xzoy5-TNq2NxyRa8oZK9I0.ttf",
        "700": "https://fonts.gstatic.com/s/namdhinggo/v2/uk-lEGe3rbgg8Xzoy5-TNsmMxyRa8oZK9I0.ttf",
        "800": "https://fonts.gstatic.com/s/namdhinggo/v2/uk-lEGe3rbgg8Xzoy5-TNtWPxyRa8oZK9I0.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/namdhinggo/v2/uk-mEGe3rbgg8Xzoy5-TPnSp5w.ttf"
    },
    {
      "family": "Nanum Brush Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nanumbrushscript/v25/wXK2E2wfpokopxzthSqPbcR5_gVaxazyjqBr1lO97Q.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nanumbrushscript/v25/wXK2E2wfpokopxzthSqPbcR5_gVaxazCj6pv.ttf"
    },
    {
      "family": "Nanum Gothic",
      "variants": [
        "regular",
        "700",
        "800"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nanumgothic/v26/PN_3Rfi-oW3hYwmKDpxS7F_z_tLfxno73g.ttf",
        "700": "https://fonts.gstatic.com/s/nanumgothic/v26/PN_oRfi-oW3hYwmKDpxS7F_LQv37zlEn14YEUQ.ttf",
        "800": "https://fonts.gstatic.com/s/nanumgothic/v26/PN_oRfi-oW3hYwmKDpxS7F_LXv77zlEn14YEUQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nanumgothic/v26/PN_3Rfi-oW3hYwmKDpxS7F_D_9jb.ttf"
    },
    {
      "family": "Nanum Gothic Coding",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v26",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nanumgothiccoding/v26/8QIVdjzHisX_8vv59_xMxtPFW4IXROwsy6QxVs1X7tc.ttf",
        "700": "https://fonts.gstatic.com/s/nanumgothiccoding/v26/8QIYdjzHisX_8vv59_xMxtPFW4IXROws8xgecsV88t5V9r4.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nanumgothiccoding/v26/8QIVdjzHisX_8vv59_xMxtPFW4IXROws-6U7Ug.ttf"
    },
    {
      "family": "Nanum Myeongjo",
      "variants": [
        "regular",
        "700",
        "800"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v30",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nanummyeongjo/v30/9Btx3DZF0dXLMZlywRbVRNhxy1LreHQ8juyl.ttf",
        "700": "https://fonts.gstatic.com/s/nanummyeongjo/v30/9Bty3DZF0dXLMZlywRbVRNhxy2pXV1A0pfCs5Kos.ttf",
        "800": "https://fonts.gstatic.com/s/nanummyeongjo/v30/9Bty3DZF0dXLMZlywRbVRNhxy2pLVFA0pfCs5Kos.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nanummyeongjo/v30/9Btx3DZF0dXLMZlywRbVRNhxy2LqcnA.ttf"
    },
    {
      "family": "Nanum Pen Script",
      "variants": [
        "regular"
      ],
      "subsets": [
        "korean",
        "latin"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nanumpenscript/v25/daaDSSYiLGqEal3MvdA_FOL_3FkN2z7-aMFCcTU.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nanumpenscript/v25/daaDSSYiLGqEal3MvdA_FOL_3FkN6z_0bA.ttf"
    },
    {
      "family": "Narnoor",
      "variants": [
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "gunjala-gondi",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v10",
      "lastModified": "2025-06-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/narnoor/v10/cIf9MaFWuVo-UTyPxCmrYGkHgIs.ttf",
        "500": "https://fonts.gstatic.com/s/narnoor/v10/cIf4MaFWuVo-UTyP_N2CRGEsnIJkWL4.ttf",
        "600": "https://fonts.gstatic.com/s/narnoor/v10/cIf4MaFWuVo-UTyP_PGFRGEsnIJkWL4.ttf",
        "700": "https://fonts.gstatic.com/s/narnoor/v10/cIf4MaFWuVo-UTyP_JWERGEsnIJkWL4.ttf",
        "800": "https://fonts.gstatic.com/s/narnoor/v10/cIf4MaFWuVo-UTyP_ImHRGEsnIJkWL4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/narnoor/v10/cIf9MaFWuVo-UTyP9CihZA.ttf"
    },
    {
      "family": "National Park",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v3",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfL_b5XMdoayNUNf.ttf",
        "300": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfIhb5XMdoayNUNf.ttf",
        "regular": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfJ_b5XMdoayNUNf.ttf",
        "500": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfJNb5XMdoayNUNf.ttf",
        "600": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfKhaJXMdoayNUNf.ttf",
        "700": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfKYaJXMdoayNUNf.ttf",
        "800": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfL_aJXMdoayNUNf.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nationalpark/v3/GftQ7vJOtg4NO-gmoY4nmcqP-VY9vs1ixcqgHfJ_b6XNfII.ttf"
    },
    {
      "family": "Neonderthaw",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v7",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/neonderthaw/v7/Iure6Yx5-oWVZI0r-17AeZZJprVA4XQ0.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/neonderthaw/v7/Iure6Yx5-oWVZI0r-17AeaZIrLE.ttf"
    },
    {
      "family": "Nerko One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nerkoone/v16/m8JQjfZSc7OXlB3ZMOjzcJ5BZmqa3A.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nerkoone/v16/m8JQjfZSc7OXlB3ZMOjDcZRF.ttf"
    },
    {
      "family": "Neucha",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin"
      ],
      "version": "v17",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/neucha/v17/q5uGsou0JOdh94bvugNsCxVEgA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/neucha/v17/q5uGsou0JOdh94bfuwlo.ttf"
    },
    {
      "family": "Neuton",
      "variants": [
        "200",
        "300",
        "regular",
        "italic",
        "700",
        "800"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "200": "https://fonts.gstatic.com/s/neuton/v23/UMBQrPtMoH62xUZKAKkfegD5Drog6Q.ttf",
        "300": "https://fonts.gstatic.com/s/neuton/v23/UMBQrPtMoH62xUZKZKofegD5Drog6Q.ttf",
        "regular": "https://fonts.gstatic.com/s/neuton/v23/UMBTrPtMoH62xUZyyII7civlBw.ttf",
        "italic": "https://fonts.gstatic.com/s/neuton/v23/UMBRrPtMoH62xUZCyog_UC71B6M5.ttf",
        "700": "https://fonts.gstatic.com/s/neuton/v23/UMBQrPtMoH62xUZKdK0fegD5Drog6Q.ttf",
        "800": "https://fonts.gstatic.com/s/neuton/v23/UMBQrPtMoH62xUZKaK4fegD5Drog6Q.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/neuton/v23/UMBTrPtMoH62xUZCyYg_.ttf"
    },
    {
      "family": "New Amsterdam",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/newamsterdam/v1/YA9Vr02Y5lucHqUlbEe51kBtl7mGiv_Q7dA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/newamsterdam/v1/YA9Vr02Y5lucHqUlbEe51kBtp7iMjg.ttf"
    },
    {
      "family": "New Rocker",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/newrocker/v16/MwQzbhjp3-HImzcCU_cJkGMViblPtXs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/newrocker/v16/MwQzbhjp3-HImzcCU_cJoGIfjQ.ttf"
    },
    {
      "family": "New Tegomin",
      "variants": [
        "regular"
      ],
      "subsets": [
        "japanese",
        "latin",
        "latin-ext"
      ],
      "version": "v12",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/newtegomin/v12/SLXMc1fV7Gd9USdBAfPlqfN0Q3ptkDMN.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/newtegomin/v12/SLXMc1fV7Gd9USdBAfPlqcN1SX4.ttf"
    },
    {
      "family": "News Cycle",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/newscycle/v25/CSR64z1Qlv-GDxkbKVQ_TOcATNt_pOU.ttf",
        "700": "https://fonts.gstatic.com/s/newscycle/v25/CSR54z1Qlv-GDxkbKVQ_dFsvaNNUuOwkC2s.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/newscycle/v25/CSR64z1Qlv-GDxkbKVQ_fOYKSA.ttf"
    },
    {
      "family": "Newsreader",
      "variants": [
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v25",
      "lastModified": "2025-05-30",
      "files": {
        "200": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438w-I_ADOxEPjCggA.ttf",
        "300": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wJo_ADOxEPjCggA.ttf",
        "regular": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438weI_ADOxEPjCggA.ttf",
        "500": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wSo_ADOxEPjCggA.ttf",
        "600": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wpojADOxEPjCggA.ttf",
        "700": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wn4jADOxEPjCggA.ttf",
        "800": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438w-IjADOxEPjCggA.ttf",
        "200italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMyoT-ZAHDWwgECi.ttf",
        "300italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMx2T-ZAHDWwgECi.ttf",
        "italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMwoT-ZAHDWwgECi.ttf",
        "500italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMwaT-ZAHDWwgECi.ttf",
        "600italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMz2SOZAHDWwgECi.ttf",
        "700italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMzPSOZAHDWwgECi.ttf",
        "800italic": "https://fonts.gstatic.com/s/newsreader/v25/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMyoSOZAHDWwgECi.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/newsreader/v25/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438weI_wDeZA.ttf"
    },
    {
      "family": "Niconne",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/niconne/v15/w8gaH2QvRug1_rTfrQut2F4OuOo.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/niconne/v15/w8gaH2QvRug1_rTfnQqn3A.ttf"
    },
    {
      "family": "Niramit",
      "variants": [
        "200",
        "200italic",
        "300",
        "300italic",
        "regular",
        "italic",
        "500",
        "500italic",
        "600",
        "600italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "thai",
        "vietnamese"
      ],
      "version": "v11",
      "lastModified": "2025-04-23",
      "files": {
        "200": "https://fonts.gstatic.com/s/niramit/v11/I_urMpWdvgLdNxVLVXx7tiiEr5_BdZ8.ttf",
        "200italic": "https://fonts.gstatic.com/s/niramit/v11/I_upMpWdvgLdNxVLXbZiXimOq73EZZ_f6w.ttf",
        "300": "https://fonts.gstatic.com/s/niramit/v11/I_urMpWdvgLdNxVLVRh4tiiEr5_BdZ8.ttf",
        "300italic": "https://fonts.gstatic.com/s/niramit/v11/I_upMpWdvgLdNxVLXbZiOiqOq73EZZ_f6w.ttf",
        "regular": "https://fonts.gstatic.com/s/niramit/v11/I_uuMpWdvgLdNxVLbbRQkiCvs5Y.ttf",
        "italic": "https://fonts.gstatic.com/s/niramit/v11/I_usMpWdvgLdNxVLXbZalgKqo5bYbA.ttf",
        "500": "https://fonts.gstatic.com/s/niramit/v11/I_urMpWdvgLdNxVLVUB5tiiEr5_BdZ8.ttf",
        "500italic": "https://fonts.gstatic.com/s/niramit/v11/I_upMpWdvgLdNxVLXbZiYiuOq73EZZ_f6w.ttf",
        "600": "https://fonts.gstatic.com/s/niramit/v11/I_urMpWdvgLdNxVLVWx-tiiEr5_BdZ8.ttf",
        "600italic": "https://fonts.gstatic.com/s/niramit/v11/I_upMpWdvgLdNxVLXbZiTiyOq73EZZ_f6w.ttf",
        "700": "https://fonts.gstatic.com/s/niramit/v11/I_urMpWdvgLdNxVLVQh_tiiEr5_BdZ8.ttf",
        "700italic": "https://fonts.gstatic.com/s/niramit/v11/I_upMpWdvgLdNxVLXbZiKi2Oq73EZZ_f6w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/niramit/v11/I_uuMpWdvgLdNxVLXbValg.ttf"
    },
    {
      "family": "Nixie One",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nixieone/v16/lW-8wjkKLXjg5y2o2uUoUOFzpS-yLw.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nixieone/v16/lW-8wjkKLXjg5y2o2uUYUet3.ttf"
    },
    {
      "family": "Nobile",
      "variants": [
        "regular",
        "italic",
        "500",
        "500italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nobile/v18/m8JTjflSeaOVl1i2XqfXeLVdbw.ttf",
        "italic": "https://fonts.gstatic.com/s/nobile/v18/m8JRjflSeaOVl1iGXK3TWrBNb3OD.ttf",
        "500": "https://fonts.gstatic.com/s/nobile/v18/m8JQjflSeaOVl1iOqo7zcJ5BZmqa3A.ttf",
        "500italic": "https://fonts.gstatic.com/s/nobile/v18/m8JWjflSeaOVl1iGXJUnc5RFRG-K3Mud.ttf",
        "700": "https://fonts.gstatic.com/s/nobile/v18/m8JQjflSeaOVl1iO4ojzcJ5BZmqa3A.ttf",
        "700italic": "https://fonts.gstatic.com/s/nobile/v18/m8JWjflSeaOVl1iGXJVvdZRFRG-K3Mud.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nobile/v18/m8JTjflSeaOVl1iGX63T.ttf"
    },
    {
      "family": "Nokora",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "khmer",
        "latin"
      ],
      "version": "v33",
      "lastModified": "2025-06-09",
      "files": {
        "100": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMuj1ecbKpdHdrk1k.ttf",
        "200": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMur1fcbKpdHdrk1k.ttf",
        "300": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMumNfcbKpdHdrk1k.ttf",
        "regular": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMuj1fcbKpdHdrk1k.ttf",
        "500": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMug9fcbKpdHdrk1k.ttf",
        "600": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMuuNYcbKpdHdrk1k.ttf",
        "700": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMutpYcbKpdHdrk1k.ttf",
        "800": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMur1YcbKpdHdrk1k.ttf",
        "900": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMupRYcbKpdHdrk1k.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nokora/v33/hYkVPuwgTubzaWxKMBj_emrD9wtMuj1fQbOjcA.ttf"
    },
    {
      "family": "Norican",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/norican/v15/MwQ2bhXp1eSBqjkPGJJRtGs-lbA.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/norican/v15/MwQ2bhXp1eSBqjkPKJNbsA.ttf"
    },
    {
      "family": "Nosifer",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext"
      ],
      "version": "v23",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nosifer/v23/ZGjXol5JTp0g5bxZaC1RVDNdGDs.ttf"
      },
      "category": "display",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nosifer/v23/ZGjXol5JTp0g5bxZWCxbUA.ttf"
    },
    {
      "family": "Notable",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v19",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notable/v19/gNMEW3N_SIqx-WX9-HMoFIez5MI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notable/v19/gNMEW3N_SIqx-WX9yHIiEA.ttf"
    },
    {
      "family": "Nothing You Could Do",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/nothingyoucoulddo/v20/oY1B8fbBpaP5OX3DtrRYf_Q2BPB1SnfZb0OJl1ol2Ymo.ttf"
      },
      "category": "handwriting",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/nothingyoucoulddo/v20/oY1B8fbBpaP5OX3DtrRYf_Q2BPB1SnfZb3OInV4.ttf"
    },
    {
      "family": "Noticia Text",
      "variants": [
        "regular",
        "italic",
        "700",
        "700italic"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v15",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/noticiatext/v15/VuJ2dNDF2Yv9qppOePKYRP1GYTFZt0rNpQ.ttf",
        "italic": "https://fonts.gstatic.com/s/noticiatext/v15/VuJodNDF2Yv9qppOePKYRP12YztdlU_dpSjt.ttf",
        "700": "https://fonts.gstatic.com/s/noticiatext/v15/VuJpdNDF2Yv9qppOePKYRP1-3R59v2HRrDH0eA.ttf",
        "700italic": "https://fonts.gstatic.com/s/noticiatext/v15/VuJrdNDF2Yv9qppOePKYRP12YwPhumvVjjTkeMnz.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/noticiatext/v15/VuJ2dNDF2Yv9qppOePKYRP12YDtd.ttf"
    },
    {
      "family": "Noto Color Emoji",
      "variants": [
        "regular"
      ],
      "subsets": [
        "emoji"
      ],
      "version": "v35",
      "lastModified": "2025-06-17",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notocoloremoji/v35/Yq6P-KqIXTD0t4D9z1ESnKM3-HpFab5s79iz64w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notocoloremoji/v35/Yq6P-KqIXTD0t4D9z1ESnKM3-HpFWb9m6w.ttf",
      "colorCapabilities": [
        "COLRv1",
        "SVG"
      ]
    },
    {
      "family": "Noto Emoji",
      "variants": [
        "300",
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "emoji"
      ],
      "version": "v56",
      "lastModified": "2025-06-02",
      "files": {
        "300": "https://fonts.gstatic.com/s/notoemoji/v56/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob_10jwvS-FGJCMY.ttf",
        "regular": "https://fonts.gstatic.com/s/notoemoji/v56/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob-r0jwvS-FGJCMY.ttf",
        "500": "https://fonts.gstatic.com/s/notoemoji/v56/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob-Z0jwvS-FGJCMY.ttf",
        "600": "https://fonts.gstatic.com/s/notoemoji/v56/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob911TwvS-FGJCMY.ttf",
        "700": "https://fonts.gstatic.com/s/notoemoji/v56/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob9M1TwvS-FGJCMY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notoemoji/v56/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob-r0gwuQeU.ttf"
    },
    {
      "family": "Noto Kufi Arabic",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v24",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5v3obPnLSmf5yD.ttf",
        "200": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh7v34bPnLSmf5yD.ttf",
        "300": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh4x34bPnLSmf5yD.ttf",
        "regular": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5v34bPnLSmf5yD.ttf",
        "500": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5d34bPnLSmf5yD.ttf",
        "600": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh6x2IbPnLSmf5yD.ttf",
        "700": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh6I2IbPnLSmf5yD.ttf",
        "800": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh7v2IbPnLSmf5yD.ttf",
        "900": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh7G2IbPnLSmf5yD.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notokufiarabic/v24/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5v37bOlrA.ttf"
    },
    {
      "family": "Noto Music",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "music"
      ],
      "version": "v20",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notomusic/v20/pe0rMIiSN5pO63htf1sxIteQB9Zra1U.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notomusic/v20/pe0rMIiSN5pO63htf1sxEtaaAw.ttf"
    },
    {
      "family": "Noto Naskh Arabic",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v36",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notonaskharabic/v36/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwvc5krK0z9_Mnuw.ttf",
        "500": "https://fonts.gstatic.com/s/notonaskharabic/v36/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwj85krK0z9_Mnuw.ttf",
        "600": "https://fonts.gstatic.com/s/notonaskharabic/v36/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwY8lkrK0z9_Mnuw.ttf",
        "700": "https://fonts.gstatic.com/s/notonaskharabic/v36/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwWslkrK0z9_Mnuw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notonaskharabic/v36/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwvc5Urac3.ttf"
    },
    {
      "family": "Noto Nastaliq Urdu",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notonastaliqurdu/v22/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qt_-DK2f2-_8mEw.ttf",
        "500": "https://fonts.gstatic.com/s/notonastaliqurdu/v22/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qu3-DK2f2-_8mEw.ttf",
        "600": "https://fonts.gstatic.com/s/notonastaliqurdu/v22/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3QgH5DK2f2-_8mEw.ttf",
        "700": "https://fonts.gstatic.com/s/notonastaliqurdu/v22/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qjj5DK2f2-_8mEw.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notonastaliqurdu/v22/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qt_-PKyV3w.ttf"
    },
    {
      "family": "Noto Rashi Hebrew",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "greek-ext",
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZB-DkRyq6Nf2pfA.ttf",
        "200": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZh-HkRyq6Nf2pfA.ttf",
        "300": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZWeHkRyq6Nf2pfA.ttf",
        "regular": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZB-HkRyq6Nf2pfA.ttf",
        "500": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZNeHkRyq6Nf2pfA.ttf",
        "600": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZ2ebkRyq6Nf2pfA.ttf",
        "700": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZ4ObkRyq6Nf2pfA.ttf",
        "800": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZh-bkRyq6Nf2pfA.ttf",
        "900": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZrubkRyq6Nf2pfA.ttf"
      },
      "category": "serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notorashihebrew/v27/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZB-HURiC-.ttf"
    },
    {
      "family": "Noto Sans",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "devanagari",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v39",
      "lastModified": "2025-03-11",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyD9At9d41P6zHtY.ttf",
        "200": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyB9A99d41P6zHtY.ttf",
        "300": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyCjA99d41P6zHtY.ttf",
        "regular": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyD9A99d41P6zHtY.ttf",
        "500": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyDPA99d41P6zHtY.ttf",
        "600": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyAjBN9d41P6zHtY.ttf",
        "700": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyAaBN9d41P6zHtY.ttf",
        "800": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyB9BN9d41P6zHtY.ttf",
        "900": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyBUBN9d41P6zHtY.ttf",
        "100italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QDcf6VfYyWtY1rI.ttf",
        "200italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QLce6VfYyWtY1rI.ttf",
        "300italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QGke6VfYyWtY1rI.ttf",
        "italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QDce6VfYyWtY1rI.ttf",
        "500italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QAUe6VfYyWtY1rI.ttf",
        "600italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QOkZ6VfYyWtY1rI.ttf",
        "700italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QNAZ6VfYyWtY1rI.ttf",
        "800italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QLcZ6VfYyWtY1rI.ttf",
        "900italic": "https://fonts.gstatic.com/s/notosans/v39/o-0kIpQlx3QUlC5A4PNr4C5OaxRsfNNlKbCePevHtVtX57DGjDU1QJ4Z6VfYyWtY1rI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosans/v39/o-0mIpQlx3QUlC5A4PNB6Ryti20_6n1iPHjcz6L1SoM-jCpoiyD9A-9c6Vc.ttf"
    },
    {
      "family": "Noto Sans Adlam",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "adlam",
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-03-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansadlam/v26/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufnv0TGnBZLwhuvk.ttf",
        "500": "https://fonts.gstatic.com/s/notosansadlam/v26/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufkn0TGnBZLwhuvk.ttf",
        "600": "https://fonts.gstatic.com/s/notosansadlam/v26/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufqXzTGnBZLwhuvk.ttf",
        "700": "https://fonts.gstatic.com/s/notosansadlam/v26/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufpzzTGnBZLwhuvk.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansadlam/v26/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufnv0fGjLYA.ttf"
    },
    {
      "family": "Noto Sans Adlam Unjoined",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "adlam",
        "latin",
        "latin-ext"
      ],
      "version": "v27",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansadlamunjoined/v27/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_Ye35PMEe-E3slUg.ttf",
        "500": "https://fonts.gstatic.com/s/notosansadlamunjoined/v27/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_Yd_5PMEe-E3slUg.ttf",
        "600": "https://fonts.gstatic.com/s/notosansadlamunjoined/v27/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_YTP-PMEe-E3slUg.ttf",
        "700": "https://fonts.gstatic.com/s/notosansadlamunjoined/v27/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_YQr-PMEe-E3slUg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansadlamunjoined/v27/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_Ye35DMAU_A.ttf"
    },
    {
      "family": "Noto Sans Anatolian Hieroglyphs",
      "variants": [
        "regular"
      ],
      "subsets": [
        "anatolian-hieroglyphs",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansanatolianhieroglyphs/v16/ijw9s4roRME5LLRxjsRb8A0gKPSWq4BbDmHHu6j2pEtUJzZWXybIymc5QYo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansanatolianhieroglyphs/v16/ijw9s4roRME5LLRxjsRb8A0gKPSWq4BbDmHHu6j2pEtUJzZWbyfCzg.ttf"
    },
    {
      "family": "Noto Sans Arabic",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "arabic",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v29",
      "lastModified": "2025-03-11",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfyG2vu3CBFQLaig.ttf",
        "200": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfSGyvu3CBFQLaig.ttf",
        "300": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCflmyvu3CBFQLaig.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfyGyvu3CBFQLaig.ttf",
        "500": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCf-myvu3CBFQLaig.ttf",
        "600": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfFmuvu3CBFQLaig.ttf",
        "700": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfL2uvu3CBFQLaig.ttf",
        "800": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfSGuvu3CBFQLaig.ttf",
        "900": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfYWuvu3CBFQLaig.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansarabic/v29/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfyGyfunqF.ttf"
    },
    {
      "family": "Noto Sans Armenian",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "armenian",
        "latin",
        "latin-ext"
      ],
      "version": "v46",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorxbq0iYy6zF3Eg.ttf",
        "200": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLopxb60iYy6zF3Eg.ttf",
        "300": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLoqvb60iYy6zF3Eg.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorxb60iYy6zF3Eg.ttf",
        "500": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorDb60iYy6zF3Eg.ttf",
        "600": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLoovaK0iYy6zF3Eg.ttf",
        "700": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLooWaK0iYy6zF3Eg.ttf",
        "800": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLopxaK0iYy6zF3Eg.ttf",
        "900": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLopYaK0iYy6zF3Eg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansarmenian/v46/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorxb50jaSo.ttf"
    },
    {
      "family": "Noto Sans Avestan",
      "variants": [
        "regular"
      ],
      "subsets": [
        "avestan",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2023-09-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansavestan/v21/bWti7ejKfBziStx7lIzKOLQZKhIJkyu9SASLji8U.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansavestan/v21/bWti7ejKfBziStx7lIzKOLQZKhIJkxu8QgA.ttf"
    },
    {
      "family": "Noto Sans Balinese",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "balinese",
        "latin",
        "latin-ext"
      ],
      "version": "v26",
      "lastModified": "2025-03-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbalinese/v26/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov7fdhE5Vd222PPY.ttf",
        "500": "https://fonts.gstatic.com/s/notosansbalinese/v26/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov4XdhE5Vd222PPY.ttf",
        "600": "https://fonts.gstatic.com/s/notosansbalinese/v26/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov2nahE5Vd222PPY.ttf",
        "700": "https://fonts.gstatic.com/s/notosansbalinese/v26/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov1DahE5Vd222PPY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbalinese/v26/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov7fdtE9fcw.ttf"
    },
    {
      "family": "Noto Sans Bamum",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "bamum",
        "latin",
        "latin-ext"
      ],
      "version": "v34",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbamum/v34/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEddO-_gLykxEkxA.ttf",
        "500": "https://fonts.gstatic.com/s/notosansbamum/v34/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEeVO-_gLykxEkxA.ttf",
        "600": "https://fonts.gstatic.com/s/notosansbamum/v34/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEQlJ-_gLykxEkxA.ttf",
        "700": "https://fonts.gstatic.com/s/notosansbamum/v34/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPETBJ-_gLykxEkxA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbamum/v34/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEddOy_kBzg.ttf"
    },
    {
      "family": "Noto Sans Bassa Vah",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "bassa-vah",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbassavah/v20/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4MaAc6p34gH-GD7.ttf",
        "500": "https://fonts.gstatic.com/s/notosansbassavah/v20/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4MoAc6p34gH-GD7.ttf",
        "600": "https://fonts.gstatic.com/s/notosansbassavah/v20/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4PEBs6p34gH-GD7.ttf",
        "700": "https://fonts.gstatic.com/s/notosansbassavah/v20/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4P9Bs6p34gH-GD7.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbassavah/v20/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4MaAf6o1Yw.ttf"
    },
    {
      "family": "Noto Sans Batak",
      "variants": [
        "regular"
      ],
      "subsets": [
        "batak",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2024-02-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbatak/v20/gok2H6TwAEdtF9N8-mdTCQvT-Zdgo4_PHuk74A.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbatak/v20/gok2H6TwAEdtF9N8-mdTCQvT-ZdQooXL.ttf"
    },
    {
      "family": "Noto Sans Bengali",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "bengali",
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsolKudCk8izI0lc.ttf",
        "200": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsglLudCk8izI0lc.ttf",
        "300": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmstdLudCk8izI0lc.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsolLudCk8izI0lc.ttf",
        "500": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsrtLudCk8izI0lc.ttf",
        "600": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsldMudCk8izI0lc.ttf",
        "700": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6Kmsm5MudCk8izI0lc.ttf",
        "800": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsglMudCk8izI0lc.ttf",
        "900": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsiBMudCk8izI0lc.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbengali/v28/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsolLidGu9g.ttf"
    },
    {
      "family": "Noto Sans Bhaiksuki",
      "variants": [
        "regular"
      ],
      "subsets": [
        "bhaiksuki",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2023-09-27",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbhaiksuki/v17/UcC63EosKniBH4iELXATsSBWdvUHXxhj8rLUdU4wh9U.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbhaiksuki/v17/UcC63EosKniBH4iELXATsSBWdvUHXxhjwrPecQ.ttf"
    },
    {
      "family": "Noto Sans Brahmi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "brahmi",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v19",
      "lastModified": "2024-02-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbrahmi/v19/vEFK2-VODB8RrNDvZSUmQQIIByV18tK1W77HtMo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbrahmi/v19/vEFK2-VODB8RrNDvZSUmQQIIByV1wtO_Xw.ttf"
    },
    {
      "family": "Noto Sans Buginese",
      "variants": [
        "regular"
      ],
      "subsets": [
        "buginese",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2023-05-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbuginese/v18/esDM30ldNv-KYGGJpKGk18phe_7Da6_gtfuEXLmNtw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbuginese/v18/esDM30ldNv-KYGGJpKGk18phe_7Da6_QtPGA.ttf"
    },
    {
      "family": "Noto Sans Buhid",
      "variants": [
        "regular"
      ],
      "subsets": [
        "buhid",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2023-09-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansbuhid/v22/Dxxy8jiXMW75w3OmoDXVWJD7YwzAe6tgnaFoGA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansbuhid/v22/Dxxy8jiXMW75w3OmoDXVWJD7YwzweqFk.ttf"
    },
    {
      "family": "Noto Sans Canadian Aboriginal",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "canadian-aboriginal",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v27",
      "lastModified": "2025-03-11",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigWLj_yAsg0q0uhQ.ttf",
        "200": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzig2Ln_yAsg0q0uhQ.ttf",
        "300": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigBrn_yAsg0q0uhQ.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigWLn_yAsg0q0uhQ.ttf",
        "500": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigarn_yAsg0q0uhQ.ttf",
        "600": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzighr7_yAsg0q0uhQ.ttf",
        "700": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigv77_yAsg0q0uhQ.ttf",
        "800": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzig2L7_yAsg0q0uhQ.ttf",
        "900": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzig8b7_yAsg0q0uhQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscanadianaboriginal/v27/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigWLnPyQEk.ttf"
    },
    {
      "family": "Noto Sans Carian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "carian",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanscarian/v16/LDIpaoiONgYwA9Yc6f0gUILeMIOgs7ob9yGLmfI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscarian/v16/LDIpaoiONgYwA9Yc6f0gUILeMIOgg7sR8w.ttf"
    },
    {
      "family": "Noto Sans Caucasian Albanian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "caucasian-albanian",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2023-10-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanscaucasianalbanian/v18/nKKA-HM_FYFRJvXzVXaANsU0VzsAc46QGOkWytlTs-TXrYDmoVmRSZo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscaucasianalbanian/v18/nKKA-HM_FYFRJvXzVXaANsU0VzsAc46QGOkWytlTs-TXnYHspQ.ttf"
    },
    {
      "family": "Noto Sans Chakma",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chakma",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2022-11-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanschakma/v17/Y4GQYbJ8VTEp4t3MKJSMjg5OIzhi4JjTQhYBeYo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanschakma/v17/Y4GQYbJ8VTEp4t3MKJSMjg5OIzhi0JnZRg.ttf"
    },
    {
      "family": "Noto Sans Cham",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cham",
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-03-11",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcER0cv7GykboaLg.ttf",
        "200": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfckRwcv7GykboaLg.ttf",
        "300": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcTxwcv7GykboaLg.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcERwcv7GykboaLg.ttf",
        "500": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcIxwcv7GykboaLg.ttf",
        "600": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfczxscv7GykboaLg.ttf",
        "700": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfc9hscv7GykboaLg.ttf",
        "800": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfckRscv7GykboaLg.ttf",
        "900": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcuBscv7GykboaLg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscham/v32/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcERwsvru2.ttf"
    },
    {
      "family": "Noto Sans Cherokee",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cherokee",
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWi5ODkm5rAffjl0.ttf",
        "200": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWq5PDkm5rAffjl0.ttf",
        "300": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWnBPDkm5rAffjl0.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWi5PDkm5rAffjl0.ttf",
        "500": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWhxPDkm5rAffjl0.ttf",
        "600": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWvBIDkm5rAffjl0.ttf",
        "700": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWslIDkm5rAffjl0.ttf",
        "800": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWq5IDkm5rAffjl0.ttf",
        "900": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWodIDkm5rAffjl0.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscherokee/v24/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWi5PPkizqA.ttf"
    },
    {
      "family": "Noto Sans Chorasmian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "chorasmian",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v3",
      "lastModified": "2024-01-26",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanschorasmian/v3/MQpL-X6uKMC7ROPLwRnI9ULxK_7NVkf8S5vyoH7w4g9b.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanschorasmian/v3/MQpL-X6uKMC7ROPLwRnI9ULxK_7NVkf8S6vzqno.ttf"
    },
    {
      "family": "Noto Sans Coptic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "coptic",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2023-12-14",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanscoptic/v21/iJWfBWmUZi_OHPqn4wq6kgqumOEd78u_VG0xR4Y.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscoptic/v21/iJWfBWmUZi_OHPqn4wq6kgqumOEd38q1UA.ttf"
    },
    {
      "family": "Noto Sans Cuneiform",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cuneiform",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanscuneiform/v17/bMrrmTWK7YY-MF22aHGGd7H8PhJtvBDWgb9JlRQueeQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscuneiform/v17/bMrrmTWK7YY-MF22aHGGd7H8PhJtvBDWsb5DkQ.ttf"
    },
    {
      "family": "Noto Sans Cypriot",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cypriot",
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2023-11-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanscypriot/v19/8AtzGta9PYqQDjyp79a6f8Cj-3a3cxIsK5MPpahF.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscypriot/v19/8AtzGta9PYqQDjyp79a6f8Cj-3a3cyItIZc.ttf"
    },
    {
      "family": "Noto Sans Cypro Minoan",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cypro-minoan",
        "latin",
        "latin-ext"
      ],
      "version": "v1",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanscyprominoan/v1/2Eb2L_dtDUlkNmPHB_UVtEzp3ZlPGqZ_4nAGq9eSf8_eQSE.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanscyprominoan/v1/2Eb2L_dtDUlkNmPHB_UVtEzp3ZlPGqZ_4nAGm9aYew.ttf"
    },
    {
      "family": "Noto Sans Deseret",
      "variants": [
        "regular"
      ],
      "subsets": [
        "deseret",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansdeseret/v17/MwQsbgPp1eKH6QsAVuFb9AZM6MMr2Vq9ZnJSZtQG.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansdeseret/v17/MwQsbgPp1eKH6QsAVuFb9AZM6MMr2Wq8bHY.ttf"
    },
    {
      "family": "Noto Sans Devanagari",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "devanagari",
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlXQky-AzoFoW4Ow.ttf",
        "200": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlfQly-AzoFoW4Ow.ttf",
        "300": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlSoly-AzoFoW4Ow.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlXQly-AzoFoW4Ow.ttf",
        "500": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlUYly-AzoFoW4Ow.ttf",
        "600": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08Alaoiy-AzoFoW4Ow.ttf",
        "700": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlZMiy-AzoFoW4Ow.ttf",
        "800": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlfQiy-AzoFoW4Ow.ttf",
        "900": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08Ald0iy-AzoFoW4Ow.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansdevanagari/v29/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlXQl--E5pA.ttf"
    },
    {
      "family": "Noto Sans Display",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900",
        "100italic",
        "200italic",
        "300italic",
        "italic",
        "500italic",
        "600italic",
        "700italic",
        "800italic",
        "900italic"
      ],
      "subsets": [
        "cyrillic",
        "cyrillic-ext",
        "greek",
        "greek-ext",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v27",
      "lastModified": "2025-03-11",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_3cLVTGQ2iHrvWM.ttf",
        "200": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp__cKVTGQ2iHrvWM.ttf",
        "300": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_ykKVTGQ2iHrvWM.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_3cKVTGQ2iHrvWM.ttf",
        "500": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_0UKVTGQ2iHrvWM.ttf",
        "600": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_6kNVTGQ2iHrvWM.ttf",
        "700": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_5ANVTGQ2iHrvWM.ttf",
        "800": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp__cNVTGQ2iHrvWM.ttf",
        "900": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_94NVTGQ2iHrvWM.ttf",
        "100italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JvXOa3gPurWM9uQ.ttf",
        "200italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JPXKa3gPurWM9uQ.ttf",
        "300italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9J43Ka3gPurWM9uQ.ttf",
        "italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JvXKa3gPurWM9uQ.ttf",
        "500italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9Jj3Ka3gPurWM9uQ.ttf",
        "600italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JY3Wa3gPurWM9uQ.ttf",
        "700italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JWnWa3gPurWM9uQ.ttf",
        "800italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JPXWa3gPurWM9uQ.ttf",
        "900italic": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JFHWa3gPurWM9uQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansdisplay/v27/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_3cKZTCa3g.ttf"
    },
    {
      "family": "Noto Sans Duployan",
      "variants": [
        "regular",
        "700"
      ],
      "subsets": [
        "duployan",
        "latin",
        "latin-ext"
      ],
      "version": "v18",
      "lastModified": "2024-07-01",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansduployan/v18/gokzH7nwAEdtF9N8-mdTDx_X9JM5wsvrFsIn6WYDvA.ttf",
        "700": "https://fonts.gstatic.com/s/notosansduployan/v18/gokwH7nwAEdtF9N8-mdTDx_X9JM5wsvTqu0D4U0ftZS-Iw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansduployan/v18/gokzH7nwAEdtF9N8-mdTDx_X9JM5wsvbF8gj.ttf"
    },
    {
      "family": "Noto Sans Egyptian Hieroglyphs",
      "variants": [
        "regular"
      ],
      "subsets": [
        "egyptian-hieroglyphs",
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2024-05-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansegyptianhieroglyphs/v29/vEF42-tODB8RrNDvZSUmRhcQHzx1s7y_F9-j3qSzEcbEYindSVK8xRg7iw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansegyptianhieroglyphs/v29/vEF42-tODB8RrNDvZSUmRhcQHzx1s7y_F9-j3qSzEcbEYintSFi4.ttf"
    },
    {
      "family": "Noto Sans Elbasan",
      "variants": [
        "regular"
      ],
      "subsets": [
        "elbasan",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2023-05-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanselbasan/v16/-F6rfiZqLzI2JPCgQBnw400qp1trvHdlre4dFcFh.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanselbasan/v16/-F6rfiZqLzI2JPCgQBnw400qp1trvEdkp-o.ttf"
    },
    {
      "family": "Noto Sans Elymaic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "elymaic",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2023-10-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanselymaic/v17/UqyKK9YTJW5liNMhTMqe9vUFP65ZD4AjWOT0zi2V.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanselymaic/v17/UqyKK9YTJW5liNMhTMqe9vUFP65ZD7AiUuA.ttf"
    },
    {
      "family": "Noto Sans Ethiopic",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "ethiopic",
        "latin",
        "latin-ext"
      ],
      "version": "v49",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T35OKqDjwmfeaY9u.ttf",
        "200": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T37OK6DjwmfeaY9u.ttf",
        "300": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T34QK6DjwmfeaY9u.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T35OK6DjwmfeaY9u.ttf",
        "500": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T358K6DjwmfeaY9u.ttf",
        "600": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T36QLKDjwmfeaY9u.ttf",
        "700": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T36pLKDjwmfeaY9u.ttf",
        "800": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T37OLKDjwmfeaY9u.ttf",
        "900": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T37nLKDjwmfeaY9u.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansethiopic/v49/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T35OK5DiyGM.ttf"
    },
    {
      "family": "Noto Sans Georgian",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic-ext",
        "georgian",
        "greek-ext",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v47",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvnzVj-f5WK0OQV.ttf",
        "200": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdptnzFj-f5WK0OQV.ttf",
        "300": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpu5zFj-f5WK0OQV.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvnzFj-f5WK0OQV.ttf",
        "500": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvVzFj-f5WK0OQV.ttf",
        "600": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdps5y1j-f5WK0OQV.ttf",
        "700": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpsAy1j-f5WK0OQV.ttf",
        "800": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdptny1j-f5WK0OQV.ttf",
        "900": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdptOy1j-f5WK0OQV.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansgeorgian/v47/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvnzGj_dZE.ttf"
    },
    {
      "family": "Noto Sans Glagolitic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic-ext",
        "glagolitic",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v18",
      "lastModified": "2024-01-26",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansglagolitic/v18/1q2ZY4-BBFBst88SU_tOj4J-4yuNF_HI4ERK4Amu7nM1.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansglagolitic/v18/1q2ZY4-BBFBst88SU_tOj4J-4yuNF_HI4HRL6g0.ttf"
    },
    {
      "family": "Noto Sans Gothic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "gothic",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansgothic/v16/TuGKUUVzXI5FBtUq5a8bj6wRbzxTFMX40kFQRx0.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansgothic/v16/TuGKUUVzXI5FBtUq5a8bj6wRbzxTJMTy1g.ttf"
    },
    {
      "family": "Noto Sans Grantha",
      "variants": [
        "regular"
      ],
      "subsets": [
        "grantha",
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2024-06-10",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansgrantha/v19/3y976akwcCjmsU8NDyrKo3IQfQ4o-r8cFeulHc6N.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansgrantha/v19/3y976akwcCjmsU8NDyrKo3IQfQ4o-o8dH-8.ttf"
    },
    {
      "family": "Noto Sans Gujarati",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "gujarati",
        "latin",
        "latin-ext",
        "math",
        "symbols"
      ],
      "version": "v26",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ypFgPM_OdiEH0s.ttf",
        "200": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_wpFwPM_OdiEH0s.ttf",
        "300": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_z3FwPM_OdiEH0s.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ypFwPM_OdiEH0s.ttf",
        "500": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ybFwPM_OdiEH0s.ttf",
        "600": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_x3EAPM_OdiEH0s.ttf",
        "700": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_xOEAPM_OdiEH0s.ttf",
        "800": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_wpEAPM_OdiEH0s.ttf",
        "900": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_wAEAPM_OdiEH0s.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansgujarati/v26/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ypFzPN9uM.ttf"
    },
    {
      "family": "Noto Sans Gunjala Gondi",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "gunjala-gondi",
        "latin",
        "latin-ext"
      ],
      "version": "v20",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansgunjalagondi/v20/bWtX7e7KfBziStx7lIzKPrcSMwcEnCv6DW7n5g0ef3PLtymzNxYL4YDE4J4vCTxEJQ.ttf",
        "500": "https://fonts.gstatic.com/s/notosansgunjalagondi/v20/bWtX7e7KfBziStx7lIzKPrcSMwcEnCv6DW7n5g0ef3PLtymzNxYL04DE4J4vCTxEJQ.ttf",
        "600": "https://fonts.gstatic.com/s/notosansgunjalagondi/v20/bWtX7e7KfBziStx7lIzKPrcSMwcEnCv6DW7n5g0ef3PLtymzNxYLP4fE4J4vCTxEJQ.ttf",
        "700": "https://fonts.gstatic.com/s/notosansgunjalagondi/v20/bWtX7e7KfBziStx7lIzKPrcSMwcEnCv6DW7n5g0ef3PLtymzNxYLBofE4J4vCTxEJQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansgunjalagondi/v20/bWtX7e7KfBziStx7lIzKPrcSMwcEnCv6DW7n5g0ef3PLtymzNxYL4YD04ZQr.ttf"
    },
    {
      "family": "Noto Sans Gurmukhi",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "gurmukhi",
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-03-11",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG1Oe3bxZ_trdp7h.ttf",
        "200": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG3OenbxZ_trdp7h.ttf",
        "300": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG0QenbxZ_trdp7h.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG1OenbxZ_trdp7h.ttf",
        "500": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG18enbxZ_trdp7h.ttf",
        "600": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG2QfXbxZ_trdp7h.ttf",
        "700": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG2pfXbxZ_trdp7h.ttf",
        "800": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG3OfXbxZ_trdp7h.ttf",
        "900": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG3nfXbxZ_trdp7h.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansgurmukhi/v28/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG1Oekbwbf8.ttf"
    },
    {
      "family": "Noto Sans HK",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "chinese-hongkong",
        "cyrillic",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v33",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qHB_-oWTiYjNvVA.ttf",
        "200": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qPB--oWTiYjNvVA.ttf",
        "300": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qC5--oWTiYjNvVA.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qHB--oWTiYjNvVA.ttf",
        "500": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qEJ--oWTiYjNvVA.ttf",
        "600": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qK55-oWTiYjNvVA.ttf",
        "700": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qJd5-oWTiYjNvVA.ttf",
        "800": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qPB5-oWTiYjNvVA.ttf",
        "900": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qNl5-oWTiYjNvVA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanshk/v33/nKKF-GM_FYFRJvXzVXaAPe97P1KHynJFP716qHB-yoSZjQ.ttf"
    },
    {
      "family": "Noto Sans Hanifi Rohingya",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "hanifi-rohingya",
        "latin",
        "latin-ext"
      ],
      "version": "v29",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanshanifirohingya/v29/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIYY4j6vvcudK8rN.ttf",
        "500": "https://fonts.gstatic.com/s/notosanshanifirohingya/v29/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIYq4j6vvcudK8rN.ttf",
        "600": "https://fonts.gstatic.com/s/notosanshanifirohingya/v29/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIbG5T6vvcudK8rN.ttf",
        "700": "https://fonts.gstatic.com/s/notosanshanifirohingya/v29/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIb_5T6vvcudK8rN.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanshanifirohingya/v29/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIYY4g6ut88.ttf"
    },
    {
      "family": "Noto Sans Hanunoo",
      "variants": [
        "regular"
      ],
      "subsets": [
        "hanunoo",
        "latin",
        "latin-ext"
      ],
      "version": "v21",
      "lastModified": "2023-11-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanshanunoo/v21/f0Xs0fCv8dxkDWlZSoXOj6CphMloFsEsEpgL_ix2.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanshanunoo/v21/f0Xs0fCv8dxkDWlZSoXOj6CphMloFvEtGJw.ttf"
    },
    {
      "family": "Noto Sans Hatran",
      "variants": [
        "regular"
      ],
      "subsets": [
        "hatran",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2023-07-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanshatran/v16/A2BBn4Ne0RgnVF3Lnko-0sOBIfL_mM83r1nwzDs.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanshatran/v16/A2BBn4Ne0RgnVF3Lnko-0sOBIfL_qM49qw.ttf"
    },
    {
      "family": "Noto Sans Hebrew",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic-ext",
        "greek-ext",
        "hebrew",
        "latin",
        "latin-ext"
      ],
      "version": "v49",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXd4utoiJltutR2g.ttf",
        "200": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiX94qtoiJltutR2g.ttf",
        "300": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXKYqtoiJltutR2g.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXd4qtoiJltutR2g.ttf",
        "500": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXRYqtoiJltutR2g.ttf",
        "600": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXqY2toiJltutR2g.ttf",
        "700": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXkI2toiJltutR2g.ttf",
        "800": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiX942toiJltutR2g.ttf",
        "900": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiX3o2toiJltutR2g.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanshebrew/v49/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXd4qdoyhh.ttf"
    },
    {
      "family": "Noto Sans Imperial Aramaic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "imperial-aramaic",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2024-07-01",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansimperialaramaic/v17/a8IMNpjwKmHXpgXbMIsbTc_kvks91LlLetBr5itQrtdml3YfPNno.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansimperialaramaic/v17/a8IMNpjwKmHXpgXbMIsbTc_kvks91LlLetBr5itQrudnnXI.ttf"
    },
    {
      "family": "Noto Sans Indic Siyaq Numbers",
      "variants": [
        "regular"
      ],
      "subsets": [
        "indic-siyaq-numbers",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansindicsiyaqnumbers/v16/6xK5dTJFKcWIu4bpRBjRZRpsIYHabOeZ8UZLubTzpXNHKx2WPOpVd5Iu.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansindicsiyaqnumbers/v16/6xK5dTJFKcWIu4bpRBjRZRpsIYHabOeZ8UZLubTzpXNHKy2XNu4.ttf"
    },
    {
      "family": "Noto Sans Inscriptional Pahlavi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "inscriptional-pahlavi",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2024-07-01",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansinscriptionalpahlavi/v17/ll8UK3GaVDuxR-TEqFPIbsR79Xxz9WEKbwsjpz7VklYlC7FCVtqVOAYK0QA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansinscriptionalpahlavi/v17/ll8UK3GaVDuxR-TEqFPIbsR79Xxz9WEKbwsjpz7VklYlC7FCZtufPA.ttf"
    },
    {
      "family": "Noto Sans Inscriptional Parthian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "inscriptional-parthian",
        "latin",
        "latin-ext"
      ],
      "version": "v17",
      "lastModified": "2024-07-01",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansinscriptionalparthian/v17/k3k7o-IMPvpLmixcA63oYi-yStDkgXuXncL7dzfW3P4TAJ2yklBJ2jNkLlLr.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansinscriptionalparthian/v17/k3k7o-IMPvpLmixcA63oYi-yStDkgXuXncL7dzfW3P4TAJ2ykmBI0Dc.ttf"
    },
    {
      "family": "Noto Sans JP",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "japanese",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v54",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFBEi75vY0rw-oME.ttf",
        "200": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFJEj75vY0rw-oME.ttf",
        "300": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFE8j75vY0rw-oME.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFBEj75vY0rw-oME.ttf",
        "500": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFCMj75vY0rw-oME.ttf",
        "600": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFM8k75vY0rw-oME.ttf",
        "700": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFPYk75vY0rw-oME.ttf",
        "800": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFJEk75vY0rw-oME.ttf",
        "900": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFLgk75vY0rw-oME.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansjp/v54/-F6jfjtqLzI2JPCgQBnw7HFyzSD-AsregP8VFBEj35rS1g.ttf"
    },
    {
      "family": "Noto Sans Javanese",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "javanese",
        "latin",
        "latin-ext"
      ],
      "version": "v24",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansjavanese/v24/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxJnkFFliZYWj4O8.ttf",
        "500": "https://fonts.gstatic.com/s/notosansjavanese/v24/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxKvkFFliZYWj4O8.ttf",
        "600": "https://fonts.gstatic.com/s/notosansjavanese/v24/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxEfjFFliZYWj4O8.ttf",
        "700": "https://fonts.gstatic.com/s/notosansjavanese/v24/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxH7jFFliZYWj4O8.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansjavanese/v24/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxJnkJFhoYQ.ttf"
    },
    {
      "family": "Noto Sans KR",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "cyrillic",
        "korean",
        "latin",
        "latin-ext",
        "vietnamese"
      ],
      "version": "v37",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzuozeLTq8H4hfeE.ttf",
        "200": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzmoyeLTq8H4hfeE.ttf",
        "300": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzrQyeLTq8H4hfeE.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzuoyeLTq8H4hfeE.ttf",
        "500": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzztgyeLTq8H4hfeE.ttf",
        "600": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzjQ1eLTq8H4hfeE.ttf",
        "700": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzg01eLTq8H4hfeE.ttf",
        "800": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzmo1eLTq8H4hfeE.ttf",
        "900": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzkM1eLTq8H4hfeE.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskr/v37/PbyxFmXiEBPT4ITbgNA5Cgms3VYcOA-vvnIzzuoySLXg9A.ttf"
    },
    {
      "family": "Noto Sans Kaithi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "kaithi",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2024-07-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanskaithi/v22/buEtppS9f8_vkXadMBJJu0tWjLwjQi0KdoZIKlo.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskaithi/v22/buEtppS9f8_vkXadMBJJu0tWjLwjciwAcg.ttf"
    },
    {
      "family": "Noto Sans Kannada",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "kannada",
        "latin",
        "latin-ext"
      ],
      "version": "v30",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrDvMzSIMLsPKrkY.ttf",
        "200": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrLvNzSIMLsPKrkY.ttf",
        "300": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrGXNzSIMLsPKrkY.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrDvNzSIMLsPKrkY.ttf",
        "500": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrAnNzSIMLsPKrkY.ttf",
        "600": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrOXKzSIMLsPKrkY.ttf",
        "700": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrNzKzSIMLsPKrkY.ttf",
        "800": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrLvKzSIMLsPKrkY.ttf",
        "900": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrJLKzSIMLsPKrkY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskannada/v30/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrDvN_SMGKg.ttf"
    },
    {
      "family": "Noto Sans Kawi",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "kawi",
        "latin",
        "latin-ext"
      ],
      "version": "v4",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanskawi/v4/92zBtBJLNqsg7tCciW0EPHNNh1ZgbtGWiTYDjvnK4AhmCpRyMjXVsQ.ttf",
        "500": "https://fonts.gstatic.com/s/notosanskawi/v4/92zBtBJLNqsg7tCciW0EPHNNh1ZgbtGWiTYDjvnK0ghmCpRyMjXVsQ.ttf",
        "600": "https://fonts.gstatic.com/s/notosanskawi/v4/92zBtBJLNqsg7tCciW0EPHNNh1ZgbtGWiTYDjvnKPg9mCpRyMjXVsQ.ttf",
        "700": "https://fonts.gstatic.com/s/notosanskawi/v4/92zBtBJLNqsg7tCciW0EPHNNh1ZgbtGWiTYDjvnKBw9mCpRyMjXVsQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskawi/v4/92zBtBJLNqsg7tCciW0EPHNNh1ZgbtGWiTYDjvnK4AhWC552.ttf"
    },
    {
      "family": "Noto Sans Kayah Li",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "kayah-li",
        "latin",
        "latin-ext"
      ],
      "version": "v25",
      "lastModified": "2025-05-29",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanskayahli/v25/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WCc3CZH4EXLuKVM.ttf",
        "500": "https://fonts.gstatic.com/s/notosanskayahli/v25/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WBU3CZH4EXLuKVM.ttf",
        "600": "https://fonts.gstatic.com/s/notosanskayahli/v25/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WPkwCZH4EXLuKVM.ttf",
        "700": "https://fonts.gstatic.com/s/notosanskayahli/v25/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WMAwCZH4EXLuKVM.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskayahli/v25/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WCc3OZDyFQ.ttf"
    },
    {
      "family": "Noto Sans Kharoshthi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "kharoshthi",
        "latin",
        "latin-ext"
      ],
      "version": "v16",
      "lastModified": "2023-04-27",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanskharoshthi/v16/Fh4qPiLjKS30-P4-pGMMXCCfvkc5Vd7KE5z4rFyx5mR1.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskharoshthi/v16/Fh4qPiLjKS30-P4-pGMMXCCfvkc5Vd7KE6z5plg.ttf"
    },
    {
      "family": "Noto Sans Khmer",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "khmer",
        "latin",
        "latin-ext"
      ],
      "version": "v28",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYuNAZz4kAbrddiA.ttf",
        "200": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYsNAJz4kAbrddiA.ttf",
        "300": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYvTAJz4kAbrddiA.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYuNAJz4kAbrddiA.ttf",
        "500": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYu_AJz4kAbrddiA.ttf",
        "600": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYtTB5z4kAbrddiA.ttf",
        "700": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYtqB5z4kAbrddiA.ttf",
        "800": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYsNB5z4kAbrddiA.ttf",
        "900": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYskB5z4kAbrddiA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskhmer/v28/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYuNAKz5mgI.ttf"
    },
    {
      "family": "Noto Sans Khojki",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khojki",
        "latin",
        "latin-ext"
      ],
      "version": "v19",
      "lastModified": "2024-02-16",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanskhojki/v19/-nFnOHM29Oofr2wohFbTuPPKVWpmK_d709jy92k.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskhojki/v19/-nFnOHM29Oofr2wohFbTuPPKVWpmG_Zx1w.ttf"
    },
    {
      "family": "Noto Sans Khudawadi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "khudawadi",
        "latin",
        "latin-ext"
      ],
      "version": "v22",
      "lastModified": "2024-08-21",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanskhudawadi/v22/fdNi9t6ZsWBZ2k5ltHN73zZ5hc8HANlHIjRnVVXz9MY.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanskhudawadi/v22/fdNi9t6ZsWBZ2k5ltHN73zZ5hc8HANlHEjVtUQ.ttf"
    },
    {
      "family": "Noto Sans Lao",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "lao",
        "latin",
        "latin-ext"
      ],
      "version": "v32",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4ccfdf5MK3riB2w.ttf",
        "200": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt48cbdf5MK3riB2w.ttf",
        "300": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4L8bdf5MK3riB2w.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4ccbdf5MK3riB2w.ttf",
        "500": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4Q8bdf5MK3riB2w.ttf",
        "600": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4r8Hdf5MK3riB2w.ttf",
        "700": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4lsHdf5MK3riB2w.ttf",
        "800": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt48cHdf5MK3riB2w.ttf",
        "900": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt42MHdf5MK3riB2w.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslao/v32/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4ccbtfpkO.ttf"
    },
    {
      "family": "Noto Sans Lao Looped",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "lao",
        "latin",
        "latin-ext"
      ],
      "version": "v9",
      "lastModified": "2025-06-02",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomPr2M-Zw5V_T71k.ttf",
        "200": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomHr3M-Zw5V_T71k.ttf",
        "300": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomKT3M-Zw5V_T71k.ttf",
        "regular": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomPr3M-Zw5V_T71k.ttf",
        "500": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomMj3M-Zw5V_T71k.ttf",
        "600": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomCTwM-Zw5V_T71k.ttf",
        "700": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomB3wM-Zw5V_T71k.ttf",
        "800": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomHrwM-Zw5V_T71k.ttf",
        "900": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomFPwM-Zw5V_T71k.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslaolooped/v9/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomPr3A-d64Q.ttf"
    },
    {
      "family": "Noto Sans Lepcha",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "lepcha"
      ],
      "version": "v19",
      "lastModified": "2023-09-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslepcha/v19/0QI7MWlB_JWgA166SKhu05TekNS32AJstqBXgd4.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslepcha/v19/0QI7MWlB_JWgA166SKhu05TekNS36ANmsg.ttf"
    },
    {
      "family": "Noto Sans Limbu",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "limbu"
      ],
      "version": "v24",
      "lastModified": "2024-07-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslimbu/v24/3JnlSDv90Gmq2mrzckOBBRRoNJVj0MF3OHRDnA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslimbu/v24/3JnlSDv90Gmq2mrzckOBBRRoNJVT0ctz.ttf"
    },
    {
      "family": "Noto Sans Linear A",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "linear-a"
      ],
      "version": "v18",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslineara/v18/oPWS_l16kP4jCuhpgEGmwJOiA18FZj22zmHQAGQicw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslineara/v18/oPWS_l16kP4jCuhpgEGmwJOiA18FZj2Gz2vU.ttf"
    },
    {
      "family": "Noto Sans Linear B",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "linear-b"
      ],
      "version": "v17",
      "lastModified": "2023-07-24",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslinearb/v17/HhyJU4wt9vSgfHoORYOiXOckKNB737IV3BkFTq4EPw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslinearb/v17/HhyJU4wt9vSgfHoORYOiXOckKNB737Il3RMB.ttf"
    },
    {
      "family": "Noto Sans Lisu",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "lisu"
      ],
      "version": "v26",
      "lastModified": "2025-06-02",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslisu/v26/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHP2Vwt29IlxkVdig.ttf",
        "500": "https://fonts.gstatic.com/s/notosanslisu/v26/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHP61wt29IlxkVdig.ttf",
        "600": "https://fonts.gstatic.com/s/notosanslisu/v26/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHPB1st29IlxkVdig.ttf",
        "700": "https://fonts.gstatic.com/s/notosanslisu/v26/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHPPlst29IlxkVdig.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslisu/v26/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHP2Vwd2tgh.ttf"
    },
    {
      "family": "Noto Sans Lycian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "lycian"
      ],
      "version": "v15",
      "lastModified": "2022-05-10",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslycian/v15/QldVNSNMqAsHtsJ7UmqxBQA9r8wA5_naCJwn00E.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslycian/v15/QldVNSNMqAsHtsJ7UmqxBQA9r8wA1_jQDA.ttf"
    },
    {
      "family": "Noto Sans Lydian",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "lydian"
      ],
      "version": "v18",
      "lastModified": "2023-12-14",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosanslydian/v18/c4m71mVzGN7s8FmIukZJ1v4ZlcPReUPXMoIjEQI.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosanslydian/v18/c4m71mVzGN7s8FmIukZJ1v4ZlcPRSULdNg.ttf"
    },
    {
      "family": "Noto Sans Mahajani",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "mahajani"
      ],
      "version": "v19",
      "lastModified": "2023-09-13",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmahajani/v19/-F6sfiVqLzI2JPCgQBnw60Agp0JrvD5Fh8ARHNh4zg.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmahajani/v19/-F6sfiVqLzI2JPCgQBnw60Agp0JrvD51hsoV.ttf"
    },
    {
      "family": "Noto Sans Malayalam",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "malayalam"
      ],
      "version": "v28",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_RuH9BFzEr6HxEA.ttf",
        "200": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_xuD9BFzEr6HxEA.ttf",
        "300": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_GOD9BFzEr6HxEA.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_RuD9BFzEr6HxEA.ttf",
        "500": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_dOD9BFzEr6HxEA.ttf",
        "600": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_mOf9BFzEr6HxEA.ttf",
        "700": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_oef9BFzEr6HxEA.ttf",
        "800": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_xuf9BFzEr6HxEA.ttf",
        "900": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_7-f9BFzEr6HxEA.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmalayalam/v28/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_RuDNBVbA.ttf"
    },
    {
      "family": "Noto Sans Mandaic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "mandaic"
      ],
      "version": "v17",
      "lastModified": "2024-07-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmandaic/v17/cIfnMbdWt1w_HgCcilqhKQBo_OsMI5_A_gMk0izH.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmandaic/v17/cIfnMbdWt1w_HgCcilqhKQBo_OsMI6_B9Ac.ttf"
    },
    {
      "family": "Noto Sans Manichaean",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "manichaean"
      ],
      "version": "v18",
      "lastModified": "2023-10-25",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmanichaean/v18/taiVGntiC4--qtsfi4Jp9-_GkPZZCcrfekqCNTtFCtdX.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmanichaean/v18/taiVGntiC4--qtsfi4Jp9-_GkPZZCcrfenqDPz8.ttf"
    },
    {
      "family": "Noto Sans Marchen",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "marchen"
      ],
      "version": "v20",
      "lastModified": "2024-07-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmarchen/v20/aFTO7OZ_Y282EP-WyG6QTOX_C8WZMHhPk652ZaHk.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmarchen/v20/aFTO7OZ_Y282EP-WyG6QTOX_C8WZMEhOmao.ttf"
    },
    {
      "family": "Noto Sans Masaram Gondi",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "masaram-gondi"
      ],
      "version": "v17",
      "lastModified": "2022-11-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmasaramgondi/v17/6xK_dThFKcWIu4bpRBjRYRV7KZCbUq6n_1kPnuGe7RI9WSWX.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmasaramgondi/v17/6xK_dThFKcWIu4bpRBjRYRV7KZCbUq6n_1kPntGf5xY.ttf"
    },
    {
      "family": "Noto Sans Math",
      "variants": [
        "regular"
      ],
      "subsets": [
        "cyrillic",
        "latin",
        "math"
      ],
      "version": "v17",
      "lastModified": "2025-04-23",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmath/v17/7Aump_cpkSecTWaHRlH2hyV5UHkG-V048PW0.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmath/v17/7Aump_cpkSecTWaHRlH2hyV5UEkH81k.ttf"
    },
    {
      "family": "Noto Sans Mayan Numerals",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "mayan-numerals"
      ],
      "version": "v16",
      "lastModified": "2025-05-30",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmayannumerals/v16/PlIuFk25O6RzLfvNNVSivR09_KqYMwvvDKYjfIiE68oo6eepYQ.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmayannumerals/v16/PlIuFk25O6RzLfvNNVSivR09_KqYMwvvDKYjfIi06sAs.ttf"
    },
    {
      "family": "Noto Sans Medefaidrin",
      "variants": [
        "regular",
        "500",
        "600",
        "700"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "medefaidrin"
      ],
      "version": "v28",
      "lastModified": "2025-03-11",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmedefaidrin/v28/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmErWlT318e5A3rw.ttf",
        "500": "https://fonts.gstatic.com/s/notosansmedefaidrin/v28/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmHjWlT318e5A3rw.ttf",
        "600": "https://fonts.gstatic.com/s/notosansmedefaidrin/v28/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmJTRlT318e5A3rw.ttf",
        "700": "https://fonts.gstatic.com/s/notosansmedefaidrin/v28/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmK3RlT318e5A3rw.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmedefaidrin/v28/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmErWpTz_9Q.ttf"
    },
    {
      "family": "Noto Sans Meetei Mayek",
      "variants": [
        "100",
        "200",
        "300",
        "regular",
        "500",
        "600",
        "700",
        "800",
        "900"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "meetei-mayek"
      ],
      "version": "v19",
      "lastModified": "2025-05-29",
      "files": {
        "100": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1TJ__TW5PgeFYVa.ttf",
        "200": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1RJ_vTW5PgeFYVa.ttf",
        "300": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1SX_vTW5PgeFYVa.ttf",
        "regular": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1TJ_vTW5PgeFYVa.ttf",
        "500": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1T7_vTW5PgeFYVa.ttf",
        "600": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1QX-fTW5PgeFYVa.ttf",
        "700": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1Qu-fTW5PgeFYVa.ttf",
        "800": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1RJ-fTW5PgeFYVa.ttf",
        "900": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1Rg-fTW5PgeFYVa.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmeeteimayek/v19/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1TJ_sTX7vw.ttf"
    },
    {
      "family": "Noto Sans Mende Kikakui",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "mende-kikakui"
      ],
      "version": "v28",
      "lastModified": "2022-11-09",
      "files": {
        "regular": "https://fonts.gstatic.com/s/notosansmendekikakui/v28/11hRGoLHz17aKjQCWj-JHcLvu2Q5zZrnkbNCLUx_aDJLAHer.ttf"
      },
      "category": "sans-serif",
      "kind": "webfonts#webfont",
      "menu": "https://fonts.gstatic.com/s/notosansmendekikakui/v28/11hRGoLHz17aKjQCWj-JHcLvu2Q5zZrnkbNCLXx-YjY.ttf"
    },
    {
      "family": "Noto Sans Meroitic",
      "variants": [
        "regular"
      ],
      "subsets": [
        "latin",
        "latin-ext",
        "meroitic",
        "meroitic-cursive",
        "meroitic-hieroglyphs"
      ],
      "version": "v18",
      "lastModified": "2023-11-09",
      "files"