<?php

/**
* WPBakery Norebro Countdown shortcode params
*/

vc_map( array(
	'name' => __( 'Countdown', 'norebro-extra' ),
	'description' => __( 'Time countdown module', 'norebro-extra' ),
	'base' => 'norebro_countdown',
	'category' => __( 'Norebro', 'norebro-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'norebro_choose_box',
			'group' => __( 'General', 'norebro-extra' ),
			'heading' => __( 'Countdown layout', 'norebro-extra' ),
			'param_name' => 'layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_031.svg',
					'key' => 'default',
					'title' => __( 'Default', 'norebro-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_032.svg',
					'key' => 'boxed',
					'title' => __( 'Boxed', 'norebro-extra' ),
				)
			)
		),
		array(
			'type' => 'norebro_check',
			'group' => __( 'General', 'norebro-extra' ),
			'heading' => __( 'Use rounded shape', 'norebro-extra' ),
			'param_name' => 'rounded_shape',
			'value' => array(
				'Yes' => '0'
			),
			'dependency' => array(
				'element' => 'layout',
				'value' => 'boxed'
			)
		),
		array(
			'type' => 'norebro_check',
			'group' => __( 'General', 'norebro-extra' ),
			'heading' => __( 'Use classic style', 'norebro-extra' ),
			'param_name' => 'countdown_classic',
			'value' => array(
				__( 'Yes', 'norebro-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'layout',
				'value' => 'default'
			)
		),
		array(
			'type' => 'norebro_datetime',
			'group' => __( 'General', 'norebro-extra' ),
			'heading' => __( 'Expiration date', 'norebro-extra' ),
			'param_name' => 'countdown_date'
		),

		// Typography
		array(
			'type' => 'norebro_divider',
			'group' => __( 'Typography', 'norebro-extra' ),
			'param_name' => 'typo_tab_divider_numbers',
			'value' => __( 'Numbers', 'norebro-extra' ),
		),
		array(
			'type' => 'norebro_typography',
			'group' => __( 'Typography', 'norebro-extra' ),
			'param_name' => 'numbers_typo',
		),
		array(
			'type' => 'norebro_divider',
			'group' => __( 'Typography', 'norebro-extra' ),
			'param_name' => 'typo_tab_divider_titles',
			'value' => __( 'Titles', 'norebro-extra' ),
		),
		array(
			'type' => 'norebro_typography',
			'group' => __( 'Typography', 'norebro-extra' ),
			'param_name' => 'titles_typo'
		),
		
		// Style
		array(
			'type' => 'norebro_colorpicker',
			'group' => __( 'Styles', 'norebro-extra' ),
			'heading' => __( 'Numbers color', 'norebro-extra' ),
			'param_name' => 'numbers_color',
		),
		array(
			'type' => 'norebro_colorpicker',
			'group' => __( 'Styles', 'norebro-extra' ),
			'heading' => __( 'Titles color', 'norebro-extra' ),
			'param_name' => 'titles_color',
		),
		array(
			'type' => 'norebro_colorpicker',
			'group' => __( 'Styles', 'norebro-extra' ),
			'heading' => __( 'Divider dots', 'norebro-extra' ),
			'param_name' => 'divider_dots_color',
			'dependency' => array(
				'element' => 'countdown_classic',
				'value' => '1'
			)
		),
		array(
			'type' => 'norebro_colorpicker',
			'group' => __( 'Styles', 'norebro-extra' ),
			'heading' => __( 'Box color', 'norebro-extra' ),
			'param_name' => 'box_color',
			'dependency' => array(
				'element' => 'layout',
				'value' => 'boxed'
			)
		),
		
		// Custom Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'norebro-extra' ),
			'heading' => __( 'Custom CSS class', 'norebro-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'norebro-extra' ),
		),


		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'norebro-extra' ),
			'heading' => __( 'Appear effect', 'norebro-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'norebro-extra' ) => 'none',
				__( 'Fade up', 'norebro-extra' ) => 'fade-up',
				__( 'Fade down', 'norebro-extra' ) => 'fade-down',
				__( 'Fade right', 'norebro-extra' ) => 'fade-right',
				__( 'Fade left', 'norebro-extra' ) => 'fade-left',
				__( 'Flip up', 'norebro-extra' ) => 'flip-up',
				__( 'Flip down', 'norebro-extra' ) => 'flip-down',
				__( 'Zoom in', 'norebro-extra' ) => 'zoom-in',
				__( 'Zoom out', 'norebro-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'norebro-extra' ),
			'heading' => __( 'Animation duration', 'norebro-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'norebro-extra' ),
		),
	)
) );