<?php

function norebro_ocdi_import_files() {
	return array(
		array(
			'import_file_name' => '<b>Demo 1</b> Designer Personal',
            'preview_url'  => 'https://norebro.clbthemes.com/demo1',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/01/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/01/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/01/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/01/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo1.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 2</b> Personal Simple',
            'preview_url'  => 'https://norebro.clbthemes.com/demo2',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/02/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/02/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/02/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/02/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo2.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 3</b> Personal Portfolio',
			'preview_url'  => 'https://norebro.clbthemes.com/demo3',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/03/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/03/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/03/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/03/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo3.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 4</b> Modern Agency',
            'preview_url'  => 'https://norebro.clbthemes.com/demo4',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/04/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/04/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/04/options.json',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/04/widgets.json',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo4.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 5</b> Digital Agency',
            'preview_url'  => 'https://norebro.clbthemes.com/demo5',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/05/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/05/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/05/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/05/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo5.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 6</b> Simple Potfolio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo6',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/06/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/06/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/06/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/06/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo6.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 7</b> Fullscreen Portfolio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo7',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/07/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/07/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/07/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/07/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo7.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 8</b> Creative Portfolio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo8',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/08/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/08/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/08/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/08/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo8.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 9</b> Fullscreen Portfolio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo9',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/09/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/09/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/09/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/09/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo9.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 10</b> Simple Portfolio',
			'preview_url'  => 'https://norebro.clbthemes.com/demo10',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/10/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/10/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/10/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/10/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo10.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 11</b> Photographer',
            'preview_url'  => 'https://norebro.clbthemes.com/demo11',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/11/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/11/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/11/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/11/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo11.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 12</b> Interior Studio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo12',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/12/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/12/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/12/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/12/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo12.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 13</b> Clean Portfolio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo13',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/13/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/13/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/13/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/13/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo13.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 14</b> Barber Sallon',
			'preview_url'  => 'https://norebro.clbthemes.com/demo14',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/14/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/14/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/14/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/14/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo14.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 15</b> Single Product',
			'preview_url'  => 'https://norebro.clbthemes.com/demo15',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/15/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/15/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/15/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/15/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo15.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 16</b> Startup and App',
            'preview_url'  => 'https://norebro.clbthemes.com/demo16',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/16/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/16/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/16/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/16/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo16.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 17</b> Personal Blog',
            'preview_url'  => 'https://norebro.clbthemes.com/demo17',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/17/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/17/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/17/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/17/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo17.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 18</b> Fashion Blog',
            'preview_url'  => 'https://norebro.clbthemes.com/demo18',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/18/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/18/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/18/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/18/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo18.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 19</b> Food Blog',
            'preview_url'  => 'https://norebro.clbthemes.com/demo19',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/19/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/19/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/19/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/19/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo19.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 20</b> Traditional Shop',
			'preview_url'  => 'https://norebro.clbthemes.com/demo20',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/20/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/20/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/20/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/20/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo20.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 21</b> Creative Agency',
			'preview_url'  => 'https://norebro.clbthemes.com/demo21',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/21/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/21/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/21/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/21/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo21.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 22</b> Restaurant and Caffe',
            'preview_url'  => 'https://norebro.clbthemes.com/demo22',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/22/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/22/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/22/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/22/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo22.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 23</b> Sports and Fitness',
            'preview_url'  => 'https://norebro.clbthemes.com/demo23',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/23/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/23/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/23/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/23/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo23.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 24</b> Coming Soon',
            'preview_url'  => 'https://norebro.clbthemes.com/demo24',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/24/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/24/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/24/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/24/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo24.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 25</b> Mobile App',
            'preview_url'  => 'https://norebro.clbthemes.com/demo25',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/25/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/25/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/25/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/25/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo25.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 26</b> Clothing Shop',
			'preview_url'  => 'https://norebro.clbthemes.com/demo26',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/26/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/26/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/26/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/26/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo26.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 27</b> Minimal Shop',
			'preview_url'  => 'https://norebro.clbthemes.com/demo27',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/27/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/27/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/27/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/27/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo27.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 28</b> Event and Corporate',
            'preview_url'  => 'https://norebro.clbthemes.com/demo28',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/28/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/28/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/28/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/28/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo28.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 29</b> Creative Portfolio',
            'preview_url'  => 'https://norebro.clbthemes.com/demo29',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/29/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/29/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/29/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/29/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo29.jpg',
		),
		array(
			'import_file_name' => '<b>Demo 30</b> Business and Corporate',
            'preview_url'  => 'https://norebro.clbthemes.com/demo30',
			'categories' => array( esc_html__( 'Home', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/30/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/30/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/30/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/30/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/Demo30.jpg',
		),
		array(
			'import_file_name' => '<b>About</b> Agency',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/about-agency/',
			'categories' => array( esc_html__( 'About', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/40/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/40/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/40/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/40/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout1.jpg',
		),
		array(
			'import_file_name' => '<b>About</b> Corporate',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/about-corporate/',
			'categories' => array( esc_html__( 'About', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/41/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/41/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/41/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/41/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout2.jpg',
		),
		array(
			'import_file_name' => '<b>About</b> Creative',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/about-creative/',
			'categories' => array( esc_html__( 'About', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/42/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/42/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/42/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/42/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout3.jpg',
		),
		array(
			'import_file_name' => '<b>About</b> Personal',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/about-personal/',
			'categories' => array( esc_html__( 'About', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/43/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/43/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/43/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/43/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout4.jpg',
		),
		array(
			'import_file_name' => '<b>About</b> Split Sreen',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/about-split-screen/',
			'categories' => array( esc_html__( 'About', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/44/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/44/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/44/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/44/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoAbout5.jpg',
		),
		array(
			'import_file_name' => '<b>Contact</b> Agency',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/contact-agency/',
			'categories' => array( esc_html__( 'Contact', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/50/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/50/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/50/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/50/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact1.jpg',
		),
		array(
			'import_file_name' => '<b>Contact</b> Corporate',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/contact-corporate/',
			'categories' => array( esc_html__( 'Contact', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/51/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/51/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/51/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/51/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact2.jpg',
		),
		array(
			'import_file_name' => '<b>Contact</b> Simple',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/contact-simple/',
			'categories' => array( esc_html__( 'Contact', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/52/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/52/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/52/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/52/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact3.jpg',
		),
		array(
			'import_file_name' => '<b>Contact</b> Split Page',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/contact-split-page/',
			'categories' => array( esc_html__( 'Contact', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/53/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/53/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/53/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/53/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact4.jpg',
		),
		array(
			'import_file_name' => '<b>Contact</b> Split Screen',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/contact-split-screen/',
			'categories' => array( esc_html__( 'Contact', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/54/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/54/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/54/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/54/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact5.jpg',
		),
		array(
			'import_file_name' => '<b>Contact</b> Extended',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/contact-extended/',
			'categories' => array( esc_html__( 'Contact', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/55/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/55/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/55/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/55/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoContact6.jpg',
		),
		array(
			'import_file_name' => '<b>Team</b> Agency',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/team-agency/',
			'categories' => array( esc_html__( 'Team', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/60/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/60/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/60/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/60/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoTeam1.jpg',
		),
		array(
			'import_file_name' => '<b>Team</b> Corporate',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/team-corporate/',
			'categories' => array( esc_html__( 'Team', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/61/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/61/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/61/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/61/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoTeam2.jpg',
		),
		array(
			'import_file_name' => '<b>Team</b> Split Page',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/team-split-page/',
			'categories' => array( esc_html__( 'Team', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/62/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/62/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/62/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/62/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoTeam3.jpg',
		),
		array(
			'import_file_name' => '<b>Services</b> Agency',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/services-agency/',
			'categories' => array( esc_html__( 'Services', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/70/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/70/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/70/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/70/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoService1.jpg',
		),
		array(
			'import_file_name' => '<b>Services</b> Corporate',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/services-corporate/',
			'categories' => array( esc_html__( 'Services', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/71/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/71/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/71/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/71/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoService2.jpg',
		),
		array(
			'import_file_name' => '<b>Services</b> Personal',
			'preview_url'  => 'https://norebro.clbthemes.com/pages/services-personal/',
			'categories' => array( esc_html__( 'Services', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/72/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/72/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/72/options.json',
			'import_sliders_file_url' => 'https://demo.clbthemes.com/v1/demo/72/slider.zip',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoService3.jpg',
		),
		array(
			'import_file_name' => '<b>Forms</b> Contact Form 7',
			'categories' => array( esc_html__( 'Contact Forms', 'norebro' ) ),
			'import_file_url' => 'https://demo.clbthemes.com/v1/demo/80/content.xml',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoForms.jpg',
		),
		array(
			'import_file_name' => '<b>UI Elements</b> Shortcodes',
			'preview_url'  => '',
			'categories' => array( esc_html__( 'Shortcodes', 'norebro' ) ),
			'import_wpbakery_file_url' => 'https://demo.clbthemes.com/v1/demo/90/content.xml',
			'import_widget_file_url' => 'https://demo.clbthemes.com/v1/demo/90/widgets.json',
			'import_options_file_url' => 'https://demo.clbthemes.com/v1/demo/90/options.json',
			'import_preview_image_url' => get_template_directory_uri() . '/demo/assets/img/DemoSC.jpg',
		)
	);
}

add_filter( 'pt-ocdi/import_files', 'norebro_ocdi_import_files' );

function norebro_ocdi_after_import_setup( $selected_import ) {
	global $wpdb;

	$front_page_id = get_page_by_title( str_replace( esc_html( '&' ), 'n', $selected_import['import_file_name'] ) );

	if ( $selected_import['import_file_name'] === 'Classic Blog' ) { // i don't know why
		$front_page_id = get_page_by_title( 'Blog Classic' );
	}

	if ( isset( $front_page_id ) and is_object( $front_page_id ) ) {
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
	}

	// Set menu
	$main_menu = wp_get_nav_menus();
	if ( is_array( $main_menu ) && count( $main_menu ) > 0 ) {
		$main_menu = $main_menu[0];
	}
	if ( is_object( $main_menu ) ) {
		$locations = get_theme_mod('nav_menu_locations');
		$locations['primary'] = $main_menu->term_id;
		set_theme_mod( 'nav_menu_locations', $locations );
	}

	// VC background images fix
	$site_url = get_site_url();
	$wpdb->query( $wpdb->prepare( 'UPDATE ' . $wpdb->postmeta . ' SET meta_value = REPLACE( meta_value, \'{{this_domain}}\', %s )', $site_url ) );
	$wpdb->query( $wpdb->prepare( 'UPDATE ' . $wpdb->posts . ' SET post_content = REPLACE( post_content, \'{{this_domain}}\', %s )', $site_url ) );

	// Update norebro portfolio categories count
	$wpdb->query( $wpdb->prepare( 'UPDATE ' . $wpdb->term_taxonomy . ' SET count = ( 
		SELECT COUNT(*) FROM ' . $wpdb->term_relationships . ' rel 
		LEFT JOIN ' . $wpdb->posts . ' po ON (po.ID = rel.object_id) 
		WHERE rel.term_taxonomy_id = ' . $wpdb->term_taxonomy . '.term_taxonomy_id 
		AND ' . $wpdb->term_taxonomy . '.taxonomy NOT IN (%s) 
		AND po.post_status IN (%s, %s))', 'link_category', 'publish', 'future' ) );
}

add_action( 'pt-ocdi/after_import', 'norebro_ocdi_after_import_setup' );