<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

use Automattic\WooCommerce\Enums\ProductType;

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $post, $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $post_thumbnail_id ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
?>

<div class="vc_row">
	<div class="woo_product-container">
		<div class="vc_col-md-6 product-images">
			<div class="images <?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>">
				<figure class="woocommerce-product-gallery__wrapper">
					<?php
					if ( has_post_thumbnail() && $post_thumbnail_id ) {
						$html  = wc_get_gallery_image_html( $post_thumbnail_id, true );
						$attachment_ids = $product->get_gallery_image_ids();
						$image_class = '';
						$loop = 1;

						foreach ( $attachment_ids as $attachment_id ) {

							$classes = array( 'zoom' );
							$image_class = implode( ' ', $classes );
							$props       = wc_get_product_attachment_props( $attachment_id, $post );

							if ( ! $props['url'] ) {
								continue;
							}
                            $alt_text = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
							$html .= apply_filters(
								'woocommerce_single_product_image_thumbnail_html',
								sprintf(
								        
									'<div class="image-wrap"><img class="gimg" src="%s"  alt="' . $alt_text . '"></div>',
									esc_url( wp_get_attachment_image_url( $attachment_id, 'original' ))
								),
								$attachment_id,
								$post->ID,
								esc_attr( $image_class )
							);

							$loop++;
						}
					} else {
						$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
						$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'norebro' ) );
						$html .= '</div>';
					}

					echo '<div class="slider" data-wc-slider="true">';
					echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

					echo '</div>';
					do_action( 'woocommerce_product_thumbnails' );
				?>
				</figure>
			</div>
		</div>