<?php

if ( !defined( 'FW' ) ) {
    die( 'Forbidden' );
}

$theme_template_directory = get_template_directory_uri();
fw()->theme->get_options( 'customizer-stunning-styles' );

$bp_pages = get_option('bp-pages');
$post_id = get_the_ID();

$options_enable_stunning = array(
    'default' => esc_html__( 'Default', 'olympus' ),
    'yes'     => esc_html__( 'Yes', 'olympus' ),
    'no'      => esc_html__( 'No', 'olympus' ),
);

$edit_youzify_header_url = admin_url('admin.php?page=youzify-panel&tab=groups-directory');

if( isset($bp_pages['groups']) && $bp_pages['groups'] == $post_id ) {
    $options_enable_stunning['youzify'] = esc_html__( 'Youzify header', 'olympus' );
}
if( isset($bp_pages['members']) && $bp_pages['members'] == $post_id ) {
    $options_enable_stunning['youzify'] = esc_html__( 'Youzify header', 'olympus' );
    $edit_youzify_header_url = admin_url('admin.php?page=youzify-panel&tab=members-directory');
}

$options = array(
    'stunning-header' => array(
        'title'    => esc_html__( 'Stunning header', 'olympus' ),
        'type'     => 'box',
        'priority' => 'high',
        'options'  => array(
            'header-stunning-visibility' => array(
                'type'    => 'radio',
                'label'   => esc_html__( 'Show stunning header', 'olympus' ),
                'choices' => $options_enable_stunning,
                'inline'  => true,
            ), // header-stunning-visibility
            'header-stunning-customize'          => array(
                'type'    => 'multi-picker',
                'picker'  => 'header-stunning-visibility',
                'choices' => array(
                    'yes' => array(
                        'header-stunning-customize-content' => array(
                            'type'    => 'multi-picker',
                            'label'   => false,
                            'desc'    => false,
                            'picker'  => array(
                                'customize' => array(
                                    'label'        => esc_html__( 'Customize content', 'olympus' ),
                                    'type'         => 'switch',
                                    'value'        => 'no',
                                    'left-choice'  => array(
                                        'value' => 'no',
                                        'label' => esc_html__( 'No', 'olympus' ),
                                    ),
                                    'right-choice' => array(
                                        'value' => 'yes',
                                        'label' => esc_html__( 'Yes', 'olympus' ),
                                    ),
                                )
                            ),
                            'choices' => array(
                                'yes' => array(
                                    'header-stunning-content-popup' => array(
                                        'type'          => 'popup',
                                        'label'         => esc_html__( 'Custom Content', 'olympus' ),
                                        'desc'          => esc_html__( 'Change custom content for this page', 'olympus' ),
                                        'button'        => esc_html__( 'Change Content', 'olympus' ),
                                        'size'          => 'medium',
                                        'popup-options' => array(
                                            'stunning_title_show'       => array(
                                                'type'         => 'multi-picker',
                                                'label'        => false,
                                                'desc'         => false,
                                                'picker'       => array(
                                                    'show' => array(
                                                        'label'        => esc_html__( 'Show title', 'olympus' ),
                                                        'type'         => 'switch',
                                                        'value'        => 'yes',
                                                        'left-choice'  => array(
                                                            'value' => 'no',
                                                            'label' => esc_html__( 'No', 'olympus' ),
                                                        ),
                                                        'right-choice' => array(
                                                            'value' => 'yes',
                                                            'label' => esc_html__( 'Yes', 'olympus' ),
                                                        ),
                                                    ),
                                                ),
                                                'choices'      => array(
                                                    'yes' => array(
                                                        'title' => array(
                                                            'type'  => 'text',
                                                            'value' => '',
                                                            'label' => esc_html__( 'Custom title text', 'olympus' ),
                                                            'desc'  => esc_html__( 'Show post title, if that empty', 'olympus' ),
                                                        ),
                                                    ),
                                                ),
                                                'show_borders' => false,
                                            ),
                                            'stunning_breadcrumbs_show' => array(
                                                'label'        => esc_html__( 'Show breadcrumbs', 'olympus' ),
                                                'type'         => 'switch',
                                                'value'        => 'yes',
                                                'left-choice'  => array(
                                                    'value' => 'no',
                                                    'label' => esc_html__( 'No', 'olympus' ),
                                                ),
                                                'right-choice' => array(
                                                    'value' => 'yes',
                                                    'label' => esc_html__( 'Yes', 'olympus' ),
                                                ),
                                            ),
                                            'stunning_text'             => array(
                                                'type'  => 'textarea',
                                                'label' => esc_html__( 'Text', 'olympus' ),
                                                'desc'  => esc_html__( 'This text will be displayed under the heading', 'olympus' ),
                                            ),
                                        )
                                    ),
                                ),
                            ),
                        ),
                        'header-stunning-customize-styles'  => array(
                            'type'    => 'multi-picker',
                            'label'   => false,
                            'desc'    => false,
                            'picker'  => array(
                                'customize' => array(
                                    'label'        => esc_html__( 'Customize styles', 'olympus' ),
                                    'type'         => 'switch',
                                    'value'        => 'no',
                                    'left-choice'  => array(
                                        'value' => 'no',
                                        'label' => esc_html__( 'No', 'olympus' ),
                                    ),
                                    'right-choice' => array(
                                        'value' => 'yes',
                                        'label' => esc_html__( 'Yes', 'olympus' ),
                                    ),
                                )
                            ),
                            'choices' => array(
                                'yes' => array(
                                    'header-stunning-styles-popup' => array(
                                        'type'          => 'popup',
                                        'label'         => esc_html__( 'Custom Styles', 'olympus' ),
                                        'desc'          => esc_html__( 'Change custom styles for this page', 'olympus' ),
                                        'button'        => esc_html__( 'Change Styles', 'olympus' ),
                                        'size'          => 'medium',
                                        'popup-options' => array( olympus_get_stunning_styles_option('', false) )
                                    ),
                                ),
                            ),
                        ),
                    ),
                    'youzify' => array(
                        'youzify_header' => array(
                            'type'  => 'text',
                            'value' => '',
                            'attr'  => array( 'class' => 'olympus-unyson-info-metabox' ),
                            'label' => false,
                            'desc' => sprintf('<a target="_blank" href="'.esc_url($edit_youzify_header_url).'">%s</a>', esc_html__( 'Edit Youzify header', 'olympus' ))
                        )
                    )
                ),
            ),
        ),
    ),
);

