<?php
/**
 * User menu dropdown.
 */

if ( ! function_exists( 'olympus_get_settings_url' ) ) {
	/**
	 * Get Settings Url.
	 */
	function olympus_get_settings_url( $slug = false, $user_id = null ) {

		if ( ! bp_is_active( 'settings' ) ) {
			return false;
		}

		// Get User ID.
		$user_id = ! empty( $user_id ) ? $user_id : bp_displayed_user_id();

		// Get User Settings Page Url.
		$url = bp_core_get_user_domain( $user_id );

		if ( $slug ) {
			$url = $url . $slug;
		}

		return $url;
	}
}


if ( ! function_exists( 'olympus_bp_menu' ) ) {

	/**
	 * Outputs the full BuddyPress menu
	 * @return bool
	 */
	function olympus_bp_menu() {
		$user_id = get_current_user_id();

		if ( ! $user_id ) {
			return false;
		}

		// New Array
		$links = array();

		if ( class_exists( 'olympus' ) ) {
			// Profile Settings
			$links['profile'] = array(
				'icon'  => 'olympus-icon-User-Icon',
				'href'  => olympus_get_profile_settings_url( false, $user_id ),
				'title' => esc_html__( 'Profile Settings', 'olympus' )
			);

			if ( bp_is_active( 'settings' ) ) {
				// Account Settings
				$settings_link    = trailingslashit( bp_loggedin_user_domain() . bp_get_settings_slug() );
				$links['account'] = array(
					'icon'  => 'olympus-icon-Settings-Icon',
					'href'  => $settings_link,
					'title' => esc_html__( 'Account Settings', 'olympus' )
				);
			}

			// Widgets Settings
			$links['widgets'] = array(
				'icon'  => 'olympus-icon-Manage-Widgets-Icon',
				'href'  => olympus_get_widgets_settings_url( false, $user_id ),
				'title' => esc_html__( 'Widgets Settings', 'olympus' )
			);

			// Change Photo Link
			$links['change-photo'] = array(
				'icon'  => 'olympus-icon-Camera-Icon',
				'href'  => olympus_get_profile_settings_url( 'change-avatar', $user_id ),
				'title' => esc_html__( 'Change Avatar', 'olympus' )
			);

			// Change Password Link
			$links['change-password'] = array(
				'icon'  => 'olympus-icon-Photo-Icon',
				'href'  => olympus_get_profile_settings_url( 'change-cover-image', $user_id ),
				'title' => esc_html__( 'Change Cover Image', 'olympus' )
			);
		} else {
			if ( bp_is_active( 'xprofile' ) ) {
				$profile_link     = trailingslashit( bp_loggedin_user_domain() . bp_get_profile_slug() );
				$links['profile'] = array(
					'icon'  => 'olympus-icon-User-Icon',
					'href'  => esc_url( $profile_link ),
					'title' => esc_html__( 'Profile', 'olympus' )
				);
			}
			if ( bp_is_active( 'settings' ) ) {
				$settings_link     = trailingslashit( bp_loggedin_user_domain() . bp_get_settings_slug() );
				$links['settings'] = array(
					'icon'  => 'olympus-icon-Settings-Icon',
					'href'  => $settings_link,
					'title' => esc_html__( 'Settings', 'olympus' )
				);
			}
			if ( bp_is_active( 'activity' ) ) {
				$activity_link     = trailingslashit( bp_loggedin_user_domain() . bp_get_activity_slug() );
				$links['activity'] = array(
					'icon'  => 'olympus-icon-Newsfeed-Icon',
					'href'  => $activity_link,
					'title' => esc_html__( 'Activity', 'olympus' )
				);
			}
			if ( bp_is_active( 'groups' ) ) {
				$groups_link     = trailingslashit( bp_loggedin_user_domain() . bp_get_groups_slug() );
				$links['groups'] = array(
					'icon'  => 'olympus-icon-Active-Members-Icon',
					'href'  => $groups_link,
					'title' => esc_html__( 'My Groups', 'olympus' )
				);

			}
			if ( bp_is_active( 'forums' ) ) {
				$user_domain     = bp_loggedin_user_domain();
				$forums_link     = trailingslashit( $user_domain . BP_FORUMS_SLUG );
				$links['forums'] = array(
					'icon'  => 'olympus-icon-Forums-Icon',
					'href'  => $forums_link,
					'title' => esc_html__( 'Forums', 'olympus' )
				);
			}
			if ( bp_is_active( 'media' ) && function_exists('bp_is_profile_media_support_enabled') && bp_is_profile_media_support_enabled() ) {
				$media_link      = trailingslashit( bp_loggedin_user_domain() . bp_get_media_slug() );
				$links['photos'] = array(
					'icon'  => 'olympus-icon-Camera-Icon',
					'href'  => $media_link,
					'title' => esc_html__( 'Photos', 'olympus' )
				);
			}
			if ( bp_is_active( 'media' ) && function_exists( 'bp_is_profile_document_support_enabled' ) && bp_is_profile_document_support_enabled() ) {
				$document_link      = trailingslashit( bp_loggedin_user_domain() . bp_get_document_slug() );
				$links['documents'] = array(
					'icon'  => 'olympus-icon-Project-Icon',
					'href'  => $document_link,
					'title' => esc_html__( 'Documents', 'olympus' )
				);
			}
			if ( bp_is_active( 'media' ) && function_exists( 'bp_is_profile_video_support_enabled' ) && bp_is_profile_video_support_enabled() ) {
				$video_link      = trailingslashit( bp_loggedin_user_domain() . bp_get_video_slug() );
				$links['videos'] = array(
					'icon'  => 'olympus-icon-Play-Icon-Big',
					'href'  => $video_link,
					'title' => esc_html__( 'Videos', 'olympus' )
				);

			}
			if ( bp_is_active( 'invites' ) && function_exists( 'bp_allow_user_to_send_invites' )  && true === bp_allow_user_to_send_invites() ) {
				$invites_link    = trailingslashit( bp_loggedin_user_domain() . bp_get_invites_slug() );
				$links['videos'] = array(
					'icon'  => 'olympus-icon-add-friend3',
					'href'  => $invites_link,
					'title' => esc_html__( 'Invites', 'olympus' )
				);
			}
		}

		// Logout Link
		$links['logout'] = array(
			'icon'  => 'olympus-icon-Logout-Icon',
			'href'  => wp_logout_url(),
			'title' => esc_html__( 'Logout', 'olympus' )
		);

		// Filter.
		$links = apply_filters( 'olympus_get_profile_account_menu', $links, $user_id );
		?>
		<ul class="menu account-settings">
			<?php foreach ( $links as $link ) : ?>
				<li class="menu-item menu-item-has-icon">
					<a href="<?php echo esc_url( $link['href'] ); ?>">
						<i class="<?php echo esc_attr( $link['icon'] ); ?>"></i>

						<?php echo esc_html( $link['title'] ); ?>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
		<?php
	}
}
function olympus_edit_bp_checkbox_acceptance($html){

	$string = '<div class="form-group label-floating fw-ext-sign-form-bp-field-group">'.$html.'</div>';

	return preg_replace('/<div class="bp-xprofile-checkbox-acceptance-field">(.*?)<\/div>/', '<div class="checkbox"><label>$1</label></div>', $string);
}



add_filter( 'bp_get_the_profile_field_checkbox_acceptance', 'olympus_edit_bp_checkbox_acceptance' );