<?php
add_action( 'after_switch_theme', '_action_olympus_tribe_update_options' );
add_action( 'upgrader_process_complete', '_action_olympus_tribe_update_options', 10, 2);

function _action_olympus_tribe_update_options() {
	if ( ! class_exists('Tribe__Settings_Manager' ) ){
		return;
	}

	// Place Default Google Map Api key
	$google_maps_js_api_key     = Tribe__Settings_Manager::get_option( 'google_maps_js_api_key' );
	// Make sure that sceleton pack selected.
	$stylesheet_option     = Tribe__Settings_Manager::get_option( 'stylesheet_mode' );

	if ( Tribe__Events__Main::VERSION < 6 ){
		if ( $stylesheet_option !== 'skeleton' ) {
			Tribe__Settings_Manager::set_option( 'stylesheet_mode', 'skeleton' );
		}
	} else {
		Tribe__Settings_Manager::set_option( 'stylesheet_mode', 'tribe' );
		$olympus = Olympus_Options::get_instance();
		$primary_accent_color = get_option( 'primary-accent-color', '#ff5e3a' );
		$secondary_accent_color = get_option( 'secondary-accent-color', '#38a9ff' );
		$primary_font_color = $olympus->get_option( 'primary_font_color', '#939ba3', $olympus::SOURCE_CUSTOMIZER );
		$accent_font_color  = $olympus->get_option( 'accent_font_color', '#515365', $olympus::SOURCE_CUSTOMIZER );
		$default_style_settings = array (
			'global_elements' =>
				array (
					'font_size' => '0',
					'font_size_base' => '15',
					'accent_color' => $primary_accent_color,
					'font_family' => 'theme',
					'background_color_choice' => 'custom',
					'background_color' => '#ffffff',
					'event_date_time_color' => $primary_font_color,
					'link_color' => $primary_accent_color,
					'event_title_color' => $accent_font_color,
				),
			'tec_events_bar' =>
				array (
					'events_bar_icon_color_choice' => 'accent',
					'events_bar_text_color' => $accent_font_color,
					'events_bar_background_color_choice' => 'global_background',
				),
			'month_view' =>
				array (
					'days_of_week_color' => $accent_font_color,
					'grid_hover_color' => $secondary_accent_color,
					'tooltip_background_color' => 'event',
					'date_marker_color' => $accent_font_color,
					'grid_lines_color' => '#e6ecf5',
				),
		);
		update_option( 'tribe_customizer', $default_style_settings );
	}

    if ( empty($google_maps_js_api_key) ) {
        $olympus = Olympus_Options::get_instance();
        $theme_apikey  = $olympus->get_option( 'gmap-key', '', $olympus::SOURCE_CUSTOMIZER );
        if ( $theme_apikey && !$google_maps_js_api_key ) {
	        Tribe__Settings_Manager::set_option( 'google_maps_js_api_key', $theme_apikey );
        }
    }
}

function _action_olympus_tribe_remove_customizer_css() {
    if ( class_exists( 'Tribe__Customizer' ) ) {
        remove_action( 'wp_print_footer_scripts', array( Tribe__Customizer::instance(), 'print_css_template' ), 15 );
    }
}

function _action_olympus_tribe_customize_register( $wp_customize ) {
    $wp_customize->remove_panel( 'tribe_customizer' );
}

function _filter_olympus_tribe_general_settings_tab_fields( $generalTabFields ) {
    $added = olympus_array_insert_after( 'embedGoogleMapsZoom', $generalTabFields, 'embedGoogleMapsPin', array(
        'type'            => 'text',
        'label'           => esc_html__( 'Map Pin', 'olympus' ),
        'validation_type' => 'textarea',
        'class'           => 'field-image-add',
    ) );
    return $added ? $added : $generalTabFields;
}

//add_filter('parse_request', '_filter_olympus_events_for_non_logged_in_users', 55);

function _filter_olympus_events_for_non_logged_in_users($wp) {

	$olympus = Olympus_Options::get_instance();
	$post_types_for_login = $olympus->get_option( 'show-post-types-not-login', '', $olympus::SOURCE_CUSTOMIZER );

	if( $post_types_for_login === 'yes' ) {
		$post_types_for_login_redirect = olympus_akg( 'yes/page_redirect/0', $post_types_for_login, '' );
		$post_types_redirect_url       = ( $post_types_for_login_redirect != '' ) ? get_page_link( $post_types_for_login_redirect ) : home_url();

		if ( isset( $wp->query_vars['post_type'] ) && $wp->query_vars['post_type'] == TribeEvents::POSTTYPE && ! is_user_logged_in() ) {
			wp_redirect( $post_types_redirect_url );
			exit;
		}
	}
}

if ( Tribe__Events__Main::VERSION < 6 ){
	// Add HTML Wrapper
	add_filter( 'tribe_events_view_before_html_data_wrapper', '_filter_olympus_tribe_events_view_before_html_data_wrapper' );
	add_filter( 'tribe_events_view_after_html_data_wrapper', '_filter_olympus_tribe_events_view_after_html_data_wrapper' );
	// Customize Design by own CSS stylesheet
	add_action( 'wp_enqueue_scripts', '_action_olympus_thecalendar_scripts', 9999 );
	// Add style setting fields
	add_filter( 'tribe_general_settings_tab_fields', '_filter_olympus_tribe_general_settings_tab_fields', 999 );
	// Remove Events calendar section
	add_action( 'customize_register', '_action_olympus_tribe_customize_register', 999 );
	// Remove the Tribe Customier CSS
	add_action( 'wp_footer', '_action_olympus_tribe_remove_customizer_css' );
	// Set global google api key if needed
	add_filter( 'tribe_customizer_get_option', '_filter_olympus_tribe_customizer_get_option', 999, 3 );
} else {
	// Remove filter for proper work of Content Restriction.
	remove_filter( 'wp_redirect', [ tribe( Tribe\Events\Views\V2\Hooks::class ), 'filter_redirect_canonical' ] );
}