(function (wpI18n, wpBlocks, wpElement, wpBlockEditor, wpComponents, serverSideRender) {
    const { registerBlockType } = wp.blocks;
    const { InspectorControls, useBlockProps } = wp.blockEditor;
    const ServerSideRender = serverSideRender;
    const { PanelBody, PanelRow, CheckboxControl, TextControl, TextareaControl, SelectControl, RangeControl } = wp.components;
    const { __ } = wpI18n;

    registerBlockType('olympus/registerform', {
        title: 'Login / Register form',
        apiVersion: 2,
        category: 'olympus-blocks',
        icon: 'admin-users',
        keywords: ['register', 'login', 'form'],
        attributes: {
            forms: {
                type: 'string',
                default: 'login'
            },
            form_type_login: {
                type: 'string',
                default: 'native'
            },
            login_shortcode: {
                type: 'string',
                default: ''
            },
            form_type_register: {
                type: 'string',
                default: 'native'
            },
            register_shortcode: {
                type: 'string',
                default: ''
            },
            redirect: {
                type: 'string',
                default: 'current'
            },
            redirect_to: {
                type: 'string',
                default: ''
            },
            register_redirect: {
                type: 'string',
                default: 'current'
            },
            register_redirect_to: {
                type: 'string',
                default: ''
            },
            login_descr: {
                type: 'string',
                default: ''
            },
            vcard_title: {
                type: 'string',
                default: ''
            },
            vcard_subtitle: {
                type: 'string',
                default: ''
            },
            vcard_profile_btn: {
                type: 'string',
                default: ''
            },
        },
        edit: (props) => {
            const { attributes, setAttributes } = props;
            const blockProps = useBlockProps();
            return (
                <div>
                    <InspectorControls>
                        <PanelBody
                            title={__('Login / Register form', 'olympus')}
                            initialOpen={true}
                        >
                            <PanelRow>
                                <SelectControl
                                    label={__('Display', 'olympus')}
                                    value={attributes.forms}
                                    options={[
                                        { label: __('Both', 'olympus'), value: 'both' },
                                        { label: __('Login', 'olympus'), value: 'login' },
                                        { label: __('Register', 'olympus'), value: 'register' },
                                    ]}
                                    onChange={(newval) => setAttributes({ forms: newval })}
                                />
                            </PanelRow>
                            {(attributes.forms == 'both' || attributes.forms == 'login') && (
                            <div>
                            <PanelRow>
                                <SelectControl
                                    label={__('From login', 'olympus')}
                                    value={attributes.form_type_login}
                                    options={[
                                        { label: __('Olympus form', 'olympus'), value: 'native' },
                                        { label: __('Youzer plugin form', 'olympus'), value: 'youzer' },
                                        { label: __('Custom shortcode', 'olympus'), value: 'custom' },
                                    ]}
                                    onChange={(newval) => setAttributes({ form_type_login: newval })}
                                />
                            </PanelRow>
                            {attributes.form_type_login == 'custom' && (
                                <PanelRow>
                                    <TextControl
                                        label={__('Login form shortcode', 'olympus')}
                                        value={attributes.login_shortcode}
                                        onChange={(newval) => setAttributes({ login_shortcode: newval })}
                                    />
                                </PanelRow>
                            )}
                            </div>
                            )}
                            {(attributes.forms == 'both' || attributes.forms == 'register') && (
                            <div>
                            <PanelRow>
                                <SelectControl
                                    label={__('From register', 'olympus')}
                                    value={attributes.form_type_register}
                                    options={[
                                        { label: __('Olympus form', 'olympus'), value: 'native' },
                                        { label: __('Youzer plugin form', 'olympus'), value: 'youzer' },
                                        { label: __('Custom shortcode', 'olympus'), value: 'custom' },
                                    ]}
                                    onChange={(newval) => setAttributes({ form_type_register: newval })}
                                />
                            </PanelRow>
                            {attributes.form_type_register == 'custom' && (
                                <PanelRow>
                                    <TextControl
                                        label={__('Register form shortcode', 'olympus')}
                                        value={attributes.register_shortcode}
                                        onChange={(newval) => setAttributes({ register_shortcode: newval })}
                                    />
                                </PanelRow>
                            )}
                            </div>
                            )}
                            {(attributes.forms == 'both' || attributes.forms == 'login') && attributes.form_type_login == 'native' && (
                            <div>
                                <PanelRow>
                                    <SelectControl
                                        label={__('Login redirect to', 'olympus')}
                                        value={attributes.redirect}
                                        options={[
                                            { label: __('Current page', 'olympus'), value: 'current' },
                                            { label: __('Home page', 'olympus'), value: 'home' },
                                            { label: __('Profile page', 'olympus'), value: 'profile' },
                                            { label: __('Activity page', 'olympus'), value: 'activity' },
                                            { label: __('Custom page', 'olympus'), value: 'custom' },
                                        ]}
                                        onChange={(newval) => setAttributes({ redirect: newval })}
                                    />
                                </PanelRow>
                                { attributes.redirect == 'custom' && (
                                <PanelRow>
                                    <TextControl
                                        label={__('Login redirect URL', 'olympus')}
                                        value={attributes.redirect_to}
                                        onChange={(newval) => setAttributes({ redirect_to: newval })}
                                    />
                                </PanelRow>
                                )}
                            </div>
                            )}
                            {(attributes.forms == 'both' || attributes.forms == 'register') && attributes.form_type_register == 'native' && (
                            <div>
                                <PanelRow>
                                    <SelectControl
                                        label={__('Register redirect to', 'olympus')}
                                        value={attributes.register_redirect}
                                        options={[
                                            { label: __('Current page', 'olympus'), value: 'current' },
                                            { label: __('Home page', 'olympus'), value: 'home' },
                                            { label: __('Profile page', 'olympus'), value: 'profile' },
                                            { label: __('Activity page', 'olympus'), value: 'activity' },
                                            { label: __('Custom page', 'olympus'), value: 'custom' },
                                        ]}
                                        onChange={(newval) => setAttributes({ register_redirect: newval })}
                                    />
                                </PanelRow>
                                {attributes.register_redirect == 'custom' && (
                                <PanelRow>
                                    <TextControl
                                        label={__('Register redirect URL', 'olympus')}
                                        value={attributes.register_redirect_to}
                                        onChange={(newval) => setAttributes({ register_redirect_to: newval })}
                                    />
                                </PanelRow>
                                )}
                            </div>
                            )}
                            {attributes.form_type_login == 'native' && (attributes.forms == 'both' || attributes.forms == 'login') && (
                            <PanelRow>
                                <TextareaControl
                                    label={__('Login form description', 'olympus')}
                                    value={attributes.login_descr}
                                    help={__('You can use [register-link text="" url=""] shortcode', 'olympus')}
                                    onChange={(newval) => setAttributes({ login_descr: newval })}
                                />
                            </PanelRow>
                            )}
                            <PanelRow>
                                <TextControl
                                    label={__('Welcome Back title', 'olympus')}
                                    value={attributes.vcard_title}
                                    onChange={(newval) => setAttributes({ vcard_title: newval })}
                                />
                            </PanelRow>
                            <PanelRow>
                                <TextControl
                                    label={__('Welcome Back subtitle', 'olympus')}
                                    value={attributes.vcard_subtitle}
                                    onChange={(newval) => setAttributes({ vcard_subtitle: newval })}
                                />
                            </PanelRow>
                            <PanelRow>
                                <TextControl
                                    label={__('Welcome Back button', 'olympus')}
                                    value={attributes.vcard_profile_btn}
                                    onChange={(newval) => setAttributes({ vcard_profile_btn: newval })}
                                />
                            </PanelRow>
                        </PanelBody>
                    </InspectorControls>
                    <div { ...blockProps }>
                        <ServerSideRender
                            block="olympus/registerform"
                            attributes={ attributes }
                        />
                    </div>
                </div>
            );
        },
        save: (props) => {
            return null
        }
    });

})(wp.i18n, wp.blocks, wp.element, wp.blockEditor, wp.components, wp.serverSideRender);