<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 * @package olympus
 */
get_header();
the_post();

$layout     = olympus_sidebar_conf();
$main_class = 'full' !== $layout['position'] ? 'site-main content-main-sidebar' : 'site-main content-main-full';
?>
	<div id="primary" class="container">
		<div class="row primary-content-wrapper">
			<main id="main" class="<?php echo esc_attr( $layout['content-classes'] ) ?>">
				<?php
				$olympus             = Olympus_Options::get_instance();
				$stunning_visibility = $olympus->get_option_final( 'header-stunning-visibility', 'yes' );
				?>

				<?php if ( $stunning_visibility !== 'yes' ) { ?>
					<div class="container">
						<div class="row">
							<h1 class="entry-title mt-3 mb-3"><?php the_title(); ?></h1>
						</div>
					</div>
				<?php } ?>
				<?php
				$form_id      = get_the_ID();
				$form_options = get_post_meta( $form_id, 'fw_options', true );

				if ( ! empty( $form_id ) && ! empty( $form_options ) && isset( $form_options['form'] ) ) {

					$submit_html = '<button type="submit" class="btn btn-primary">' . esc_html__( 'Submit', 'olympus' ) . '</button>';

					ob_start();
					FW_Flash_Messages::_print_frontend();
					$messages = ob_get_clean();

					$form_html = '<div class="crumina-ext-contact-form standart-form-flex">'
					             . $messages
					             . fw()->extensions->get( 'forms' )->render_form( $form_id, $form_options['form'], 'contact-forms', $submit_html )
					             . '</div>';
					echo '' . $form_html;
				}

				?>
			</main><!-- #main -->
			<?php if ( 'full' !== $layout['position'] ) { ?>
				<aside class="<?php echo esc_attr( $layout['sidebar-classes'] ) ?>">
					<?php get_sidebar(); ?>
				</aside>
			<?php } ?>
		</div><!-- #row -->
	</div><!-- #primary -->
<?php
get_footer();
