<?php
/**
 * The template for displaying one of theme headers
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package olympus
 */
$olympus           = Olympus_Options::get_instance();
$customize_content = $olympus->get_option_final( 'header-general-top-customize-content', array() );

if ( olympus_akg( 'customize', $customize_content, 'no' ) === 'yes' ) {
	$menu_cart_icon = olympus_akg( 'yes/header-general-content-popup/menu_cart_icon', $customize_content, 'hide' );
} else {
	$menu_cart_icon = $olympus->get_option( 'menu_cart_icon', 'show', $olympus::SOURCE_CUSTOMIZER );
}
$menu_theme_switcher = $olympus->get_option( 'menu-theme-switcher', 'yes', $olympus::SOURCE_CUSTOMIZER );
$olympus_dark_mode = $olympus->get_option( 'theme-dark-mode', 'yes', $olympus::SOURCE_CUSTOMIZER );
?>

<div class="header--standard" id="header--standard">
    <div class="container">
        <div class="row">
            <div class="col col-12 header--standard-wrap">
                <a href="<?php echo esc_url( home_url() ) ?>" class="logo">
					<?php
					$logo_text        = get_option( 'custom-logo-text', get_bloginfo( 'name' ) );
					$logo_description = get_option( 'custom-logo-description', get_bloginfo( 'description' ) );
					$logo_uppercase = get_option( 'custom-logo-uppercase', '1' );
					?>

					<?php if ( has_custom_logo() ) { ?>
                        <div class="img-wrap">
							<?php
							$logo_id = get_theme_mod( 'custom_logo' );
							$logo    = wp_get_attachment_image_src( $logo_id, 'full' );
							?>
                            <img src="<?php echo esc_url( $logo[0] ); ?>" alt="<?php echo esc_attr( $logo_text ); ?>">
                        </div>
					<?php } ?>

                    <div class="title-block <?php if($logo_uppercase == '1'){echo 'text-uppercase';} ?>">
                        <h6 class="logo-title"><?php olympus_render( $logo_text ); ?></h6>
                        <div class="sub-title"><?php olympus_render( $logo_description ); ?></div>
                    </div>
                </a>

                <nav class="primary-menu">

                    <a href="#" class="open-responsive-menu showhide">
                        <i class="olympus-icon-Menu-Icon"></i>
                        <i class="olympus-icon-Close-Icon"></i>
                    </a>

					<?php
					$menu_args = array(
						'theme_location' => 'primary',
						'menu_id'        => 'primary-menu',
						'menu_class'     => 'primary-menu-menu',
						'container'      => 'ul',
						'fallback_cb'    => 'olympus_menu_fallback'
					);

					if ( class_exists( 'Olympus_Mega_Menu_Custom_Walker' ) ) {
						$menu_args['walker'] = new Olympus_Mega_Menu_Custom_Walker();
					}

					wp_nav_menu( $menu_args );
					?>
					<?php if ( $menu_cart_icon === 'show' ) { ?>
                        <ul class="nav-add shoping-cart more">
							<?php get_template_part( "/templates/header/menu-item", "cart" ); ?>
                        </ul>
					<?php } ?>
	                <?php if ( $menu_theme_switcher === 'yes' && $olympus_dark_mode === 'yes' ) { ?>
					<button class="olympus-theme-toggle" type="button">
						<span class="d-block-light d-none"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-moon"><path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z"></path></svg></span>
						<span class="d-block-dark d-none"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-sun"><circle cx="12" cy="12" r="5"></circle><line x1="12" y1="1" x2="12" y2="3"></line><line x1="12" y1="21" x2="12" y2="23"></line><line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line><line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line><line x1="1" y1="12" x2="3" y2="12"></line><line x1="21" y1="12" x2="23" y2="12"></line><line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line><line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line></svg></span>
					</button>
	                <?php } ?>
                </nav>
            </div>
        </div>
    </div>
</div>