<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Olympus_Button extends \Elementor\Widget_Base {

	public function get_name() {
		return 'olympus_button';
	}

	public function get_title() {
		return esc_html__( 'Button', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-button';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'olympus_button',
			[
				'label' => esc_html__( 'Button', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'label',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Button text', 'elementor-olympus' ),
				'description' => esc_html__( 'This is the text that appears on your button', 'elementor-olympus' ),
				'default'     => 'Text Button'
			]
		);

		$this->add_control(
			'show_modal',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Open modal', 'elementor-olympus' ),
				'description' => esc_html__( 'Display modal window on click. For example login / register form.', 'elementor-olympus' ),
				'default'     => '',
				'separator'   => 'before'
			]
		);
		$this->add_control(
			'link',
			[
				'type'        => \Elementor\Controls_Manager::URL,
				'label'       => esc_html__( 'Link', 'elementor-olympus' ),
				'description' => esc_html__( 'Add your relative URL. Each URL contains link, anchor text and target attributes.', 'elementor-olympus' ),
				'condition'   => [
					'show_modal' => ''
				],
			]
		);
		$this->add_control(
			'modal_content',
			[
				'type'      => \Elementor\Controls_Manager::SELECT,
				'label'     => esc_html__( 'Modal box content', 'elementor-olympus' ),
				'options'   => [
					'reg_form' => esc_html__( 'Login - Register form', 'elementor-olympus' ),
					'custom'   => esc_html__( 'Custom content', 'elementor-olympus' ),
				],
				'condition' => [
					'show_modal' => 'yes'
				],
				'default'   => 'register',
				'separator' => 'before'
			]
		);
		$this->add_control(
			'modal_custom',
			[
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'condition'   => [
					'modal_content' => 'custom'
				],
				'label'       => esc_html__( 'Content for modal box', 'elementor-olympus' ),
				'description' => esc_html__( 'Shortcodes also will work in that field', 'elementor-olympus' )
			]
		);


		$this->add_control(
			'show_icon',
			[
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Show Icon?', 'elementor-olympus' ),
				'default'   => 'no',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'icon',
			[
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label'       => esc_html__( 'Icon', 'elementor-olympus' ),
				'description' => esc_html__( 'Select icon for button', 'elementor-olympus' ),
				'default'     => [
					'value'   => 'fas fa-leaf',
					'library' => 'fa-solid',
				],
				'condition'   => [
					'show_icon' => 'yes'
				],
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'icon_position',
			[
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'label'     => esc_html__( 'Icon position', 'elementor-olympus' ),
				'options'   => [
					'left'  => [
						'title' => esc_html__( 'Left', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-right',
					]
				],
				'default'   => 'left',
				'condition' => [
					'show_icon' => 'yes'
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'        => __( 'Alignment', 'elementor' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'    => [
						'title' => __( 'Left', 'elementor-olympus' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => __( 'Center', 'elementor-olympus' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => __( 'Right', 'elementor-olympus' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => __( 'Justified', 'elementor-olympus' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => '',
			]
		);

		$this->add_control(
			'onclick',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'On Click', 'elementor-olympus' ),
				'description' => esc_html__( 'Content of on click attribute for element.', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'ex_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Button extra class', 'elementor-olympus' ),
				'description' => esc_html__( 'Add class name for a tag.', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'element_id',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Button ID attribute', 'elementor-olympus' ),
				'description' => esc_html__( 'Only latin charters must be used', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'el_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Module additional class', 'elementor-olympus' ),
				'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'view',
			[
				'label'   => __( 'View', 'elementor-olympus' ),
				'type'    => \Elementor\Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Button', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'color',
			[
				'type'        => \Elementor\Controls_Manager::SELECT,
				'label'       => esc_html__( 'Color', 'elementor-olympus' ),
				'description' => esc_html__( 'The color of elements', 'elementor-olympus' ),
				'options'     => es_button_colors(),
				'default'     => 'primary',
			]
		);

		$this->add_control(
			'size',
			[
				'type'      => \Elementor\Controls_Manager::SELECT,
				'label'     => esc_html__( 'Button size', 'elementor-olympus' ),
				'options'   => [
					'sm' => esc_html__( 'Small', 'elementor-olympus' ),
					'md' => esc_html__( 'Medium', 'elementor-olympus' ),
					'lg' => esc_html__( 'Large', 'elementor-olympus' ),
				],
				'default'   => 'md',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'outlined',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Outlined button', 'elementor-olympus' ),
				'description' => esc_html__( 'Button with border and transparent background', 'elementor-olympus' ),
				'default'     => 'no',
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Style', 'elementor-olympus' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'style-typography',
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .btn',
			]
		);

		$this->add_control(
			'style-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Text Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .btn' => 'color: {{SCHEME}};'
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'style-background-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .btn' => 'background-color: {{SCHEME}};'
				],
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			'border',
			[
				'name'      => 'style-border',
				'label'     => esc_html__( 'Border', 'elementor-olympus' ),
				'selector'  => '{{WRAPPER}} .btn',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'style-border-radius',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Border Radius', 'elementor-olympus' ),
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'style-border_border!' => '',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'icon-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Icon', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'icon-font-size',
			[
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Icon Size', 'elementor-olympus' ),
				'size_units' => [ 'px', 'em', '%' ],
				'range'      => [
					'px' => [
						'min' => 1,
						'max' => 200,
					]
				],
				'selectors'  => [
					'{{WRAPPER}} .btn i' => 'font-size: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'icon-padding',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Icon Spacing', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .btn i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'hover-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Hover', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'hover-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Text Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .btn:hover' => 'color: {{SCHEME}};'
				]
			]
		);

		$this->add_control(
			'hover-background-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .btn:hover' => 'background-color: {{SCHEME}};'
				],
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			'border',
			[
				'name'      => 'hover-border',
				'label'     => esc_html__( 'Border', 'elementor-olympus' ),
				'selector'  => '{{WRAPPER}} .btn:hover',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'hover-border-radius',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Border Radius Hover', 'elementor-olympus' ),
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'hover-border_border!' => '',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$button_attr   = [];
		$id            = $this->get_id();
		$settings      = $this->get_settings_for_display();
		$align         = ! empty( $settings['align'] ) ? $settings['align'] : '';
		$label         = ! empty( $settings['label'] ) ? $settings['label'] : '';
		$icon_position = ! empty( $settings['icon_position'] ) ? $settings['icon_position'] : 'right';

		$show_modal    = ! empty( $settings['show_modal'] ) ? $settings['show_modal'] : '';
		$modal_content = ! empty( $settings['modal_content'] ) ? $settings['modal_content'] : '';
		$modal_custom  = ! empty( $settings['modal_custom'] ) ? $settings['modal_custom'] : '';

		if ( 'reg_form' === $modal_content && function_exists( 'olympus_append_login_form_to_html' ) ) {
			add_action( 'wp_footer', 'olympus_append_login_form_to_html' );
		}

		$wrapper_class = [ 'crumina-module', 'crum-button', 'elementor-button-wrapper', 'cta-btn-' . $id ];
		if ( ! empty( $settings['el_class'] ) ) {
			$wrapper_class[] = $settings['el_class'];
		}

		if ( ! empty( $settings['link']['url'] ) ) {
			$button_attr[] = 'href="' . esc_attr( $settings['link']['url'] ) . '"';
			$button_attr[] = 'target="' . ( ! empty( $settings['link']['is_external'] ) ? '_blank' : '_self' ) . '"';
			$button_attr[] = ! empty( $settings['link']['nofollow'] ) ? 'rel="nofollow"' : '';
		} else {
			$button_attr[] = 'href="#!"';
		}
		$el_class      = [
			'btn',
			'btn-' . ( ! empty( $settings['size'] ) ? $settings['size'] : '' ),
			'btn-' . ( ! empty( $settings['color'] ) ? $settings['color'] : 'primary' ),
			! empty( $settings['show_icon'] ) && $settings['show_icon'] == 'yes' ? 'btn--with-icon' : '',
			! empty( $settings['outlined'] ) && $settings['outlined'] == 'yes' ? 'btn--bordered' : '',
			! empty( $settings['show_icon'] ) && $settings['show_icon'] == 'yes' ? 'btn-icon-' . $icon_position : '',
			! empty( $settings['ex_class'] ) ? $settings['ex_class'] : '',
		];

		if ( 'yes' === $show_modal ) {
			$button_attr[] = 'data-popup-target=".js-login-form"';
			$el_class[]      = 'js-open-popup';
		}

		$button_attr[] = 'class="' . esc_attr( implode( ' ', $el_class ) ) . '"';

		if ( ! empty( $settings['onclick'] ) ) {
			$button_attr[] = 'onclick="' . $settings['onclick'] . '"';
		}

		if ( ! empty( $settings['element_id'] ) ) {
			$button_attr[] = 'id="' . esc_attr( $settings['element_id'] ) . '"';
		}
		?>
		<div class="<?php echo implode( " ", $wrapper_class ); ?>"  <?php if ( 'yes' === $show_modal && $modal_content !== 'reg_form' ) { echo ' x-data="olympusModal()"'; } ?>>
			<a <?php echo implode( ' ', $button_attr ); ?>>
				<?php
				if ( ! empty( $settings['show_icon'] ) && $settings['show_icon'] == 'yes' ) {
					$icon = ! empty( $settings['icon']['value'] ) ? $settings['icon']['value'] : '';
					if ( $icon_position == 'left' ) {
						echo '<i class="' . esc_attr( $icon ) . '"></i><span class="text">' . html_entity_decode( wp_kses( $label, array( 'br' => array() ) ) ) . '</span>';
					} else {
						echo '<span class="text">' . html_entity_decode( wp_kses( $label, array( 'br' => array() ) ) ) . '</span><i class="' . esc_attr( $icon ) . '"></i>';
					}
				} else {
					if ( $label ) {
						echo '<span class="text">' . html_entity_decode( wp_kses( $label, array( 'br' => array() ) ) ) . '</span>';
					}
				}
				?>
			</a>
            
            <?php if ( 'yes' === $show_modal && $modal_content !== 'reg_form' ): ?>
            <div class="crumina-module crumina-window-popup" tabindex="-1" role="dialog" aria-hidden="true"
                 x-show="isModalOpen()"
                 x-cloak
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform -translate-y-40"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-300"
                 x-transition:leave-start="opacity-100 transform translate-y-0"
                 x-transition:leave-end="opacity-0 transform -translate-y-40"
            >
                <div class="modal-dialog window-popup registration-login-form-popup" role="document" @click.away="modalClose">
                    <div class="modal-content">
                        <a href="#" class="close icon-close"
                           @click="modalClose"
                        >
                            <i class="olymp-close-icon olympus-icon-Close-Icon"></i>
                        </a>
                        <div class="modal-body">
	                        <?php echo do_shortcode( $modal_custom ); ?>
                        </div>
                    </div>
                </div>
            </div>
		<?php endif; ?>
		</div>
		<?php
	}
}


