<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Elementor_Olympus_Clients_Slider extends \Elementor\Widget_Base {

    public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script( 'olympus-elementor-swiper-init', ES_PLUGIN_URL. '/assets/js/swiper-init.js', [ 'jquery' ], '1', true );
	}

	public function get_name() {
		return 'olympus_clients_slider';
	}

	public function get_title() {
		return esc_html__( 'Clients Slider', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-clients-slider';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
    }
    
    public function get_script_depends() {
		return [ 'olympus-elementor-swiper-init' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'olympus_clients_slider',
			[
				'label' => esc_html__( 'Clients Slider', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'number_of_items',
			[
                'type'        => \Elementor\Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Items per page', 'elementor-olympus' ),
                'description' => esc_html__( 'Number of items displayed on one screen', 'elementor-olympus' ),
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 10,
                        'step' => 1
                    ]
                ],
                'default'     => [
                    'unit' => 'px',
                    'size' => 4
                ]
			]
        );

        $this->add_control(
            'arrows',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Show Arrows', 'elementor-olympus' ),
                'description' => esc_html__( 'Previous/ Next Slider buttons', 'elementor-olympus' ),
                'default'     => 'yes',
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'dots',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Show Dots', 'elementor-olympus' ),
                'description' => esc_html__( 'Pagination dots', 'elementor-olympus' ),
                'default'     => 'no',
                'condition'   => [
                    'arrows!' => 'yes'
                ],
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'autoscroll',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Autoslide', 'elementor-olympus' ),
                'description' => esc_html__( 'Automatic auto scroll slides', 'elementor-olympus' ),
                'default'     => 'no',
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'time',
            [
                'type'        => \Elementor\Controls_Manager::SLIDER,
                'label'       => esc_html__( 'Delay between scroll', 'elementor-olympus' ),
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 30,
                        'step' => 1
                    ]
                ],
                'default'     => [
                    'unit' => 'px',
                    'size' => 5
                ],
                'condition'   => [
                    'autoscroll' => 'yes'
                ],
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'custom_class',
            [
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label'       => esc_html__( 'Custom class', 'elementor-olympus' ),
                'description' => esc_html__( 'Enter extra custom class', 'elementor-olympus' ),
                'separator'   => 'before'
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'items',
			[
				'label' => esc_html__( 'Slider items', 'elementor-olympus' ),
			]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image', 
            [
                'type'  => \Elementor\Controls_Manager::MEDIA,
                'label' => esc_html__( 'Client logo', 'elementor-olympus' )
            ]
        );

        $repeater->add_control(
            'link_name',
            [
                'type'      => \Elementor\Controls_Manager::TEXT,
                'label'     => esc_html__( 'Custom link name', 'elementor-olympus' ),
                'separator' => 'before'
            ]
        );

        $repeater->add_control(
            'link', 
            [
                'type'  => \Elementor\Controls_Manager::URL,
                'label' => esc_html__( 'Custom link', 'elementor-olympus' ),
            ]
        );

        $this->add_control(
			'options',
			[
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'label'       => esc_html__( 'Slider items', 'elementor-olympus' ),
				'fields'      => $repeater->get_controls(),
                'description' => esc_html__( 'Repeat this fields with each item created, Each item corresponding slider element.', 'lementor-olympus' ),
			]
		);
    
        $this->end_controls_section();

        $this->start_controls_section(
            'style-css',
            [
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Main params', 'elementor-olympus' ),
            ]
        );

        $this->add_control(
            'style-padding',
            [
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'label'      => __( 'Padding', 'elementor-olympus' ),
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}}' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'style-margin',
            [
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'label'      => __( 'Margin', 'elementor-olympus' ),
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before'
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'      => 'style-background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}}',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            'border',
            [
                'name'      => 'style-border',
                'label'     => esc_html__( 'Border', 'elementor-olympus' ),
                'selector'  => '{{WRAPPER}}',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'style-border-radius',
            [
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'label'      => __( 'Border Radius', 'elementor-olympus' ),
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}}' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'style-border_border!' => '',
                ],
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $slider_attr = [];
		$show_items_attr = '';
        
        $settings = $this->get_settings_for_display();

        $wrap_class = [ 'clients-slider-module', 'crumina-module', 'crumina-module-slider', 'crumina-clients' ];
        if ( ! empty( $settings['custom_class'] ) ) {
            $wrap_class[] = $settings['custom_class'];
        }

        if ( ! empty( $settings['number_of_items']['size'] ) ) {
	        $show_items_attr = 'data-show-items="' . esc_attr( $settings['number_of_items']['size'] ) . '"';
        }

        if ( ! empty( $settings['autoscroll'] ) && $settings['autoscroll'] == 'yes' ) {
            $time = ! empty( $settings['time']['size'] ) ? $settings['time']['size'] : 0;
            $slider_attr[] = 'data-autoplay="' . esc_attr( intval( $time ) * 1000 ) . '"';
        }
        
        if ( ! empty( $settings['arrows'] ) && $settings['arrows'] == 'yes' ) {
            $pagination_class = 'pagination-bottom-large';
	        $slider_attr[] = 'data-prev-next="1"';
        } elseif ( ! empty( $settings['dots'] ) && $settings['dots'] == 'yes' ) {
            $pagination_class = 'pagination-bottom';
        } else {
            $pagination_class = '';
        } ?>
        <div class="<?php echo implode( ' ', $wrap_class ); ?>">
            <?php if ( ! empty( $settings['options'] ) ) {
                $slides_count = intval(count($settings['options']));
	            if ( $slides_count < $settings['number_of_items']['size'] ) {
		            $show_items_attr = 'data-show-items="' . esc_attr( $slides_count ) . '"';
                }

	            $slider_attr[] = $show_items_attr;
                ?>
                <div class="swiper-container <?php echo esc_attr( $pagination_class ) ?>" <?php echo implode( ' ', $slider_attr ); ?>>
                    <div class="swiper-wrapper">
                        <?php
                            foreach ( $settings['options'] as $option ) {
                            	$img_title = esc_attr( ! empty( $option['link_name'] ) ? $option['link_name'] : '' );
                                if ( ! empty( $option['image']['url'] ) ) {
                                    $has_link = false;
                                    $link_att = [ 'class="client-image"' ];

                                    if ( ! empty( $option['link']['url'] ) ) {
                                        $has_link   = true;
                                        $link_att[] = 'href="' . esc_attr( $option['link']['url'] ) . '"';
                                        $link_att[] = 'target="' . esc_attr( ! empty( $option['link']['is_external'] ) ? '_blank' : '_self' ) . '"';
                                        $link_att[] = 'title="' . $img_title . '"';
                                        $link_att[] = ! empty( $option['link']['nofollow'] ) ? 'rel="nofollow"' : '';
                                    }

	                                $data_image = '<img src="' . esc_url( $option['image']['url'] ) . '" alt="' . $img_title . '" class="gray_hover" loading="lazy">';

                                    ?>
                                    <div class="swiper-slide client-item">
                                        <?php
                                            if ( $has_link ) {
	                                            echo '<a ' . implode( ' ', $link_att ) . '>' . $data_image . '</a>';
                                            } else {
                                                echo $data_image;
                                            }
                                        ?>
                                    </div>
                                <?php }
                            }
                        ?>
                    </div>
                    <?php if ( ! empty( $settings['arrows'] ) && $settings['arrows'] == 'yes' ) { ?>
                        <svg class="btn-next swiper-btn-next">
                            <use xlink:href="#olymp-popup-right-arrow"></use>
                        </svg>
                        <svg class="btn-prev swiper-btn-prev">
                            <use xlink:href="#olymp-popup-left-arrow"></use>
                        </svg>
                    <?php } elseif ( ! empty( $settings['dots'] ) && $settings['dots'] == 'yes' ) { ?>
                        <div class="swiper-pagination"></div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
        <?php
        if(is_admin()){ ?>
        <script>
            jQuery( function ( $ ) {
                CRUMINA.Swiper.init();
            });
        </script>
        <?php 
        }
    }
}