<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Olympus_Counter extends \Elementor\Widget_Base {

	public function get_name() {
		return 'olympus_counter';
	}

	public function get_title() {
		return esc_html__( 'Counter Box', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-counter-box';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

	public function get_script_depends() {
		return [ 'purecounter' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'olympus_counter',
			[
				'label' => esc_html__( 'Counter Box', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'icon_show',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Display Icon', 'elementor-olympus' ),
				'description' => esc_html__( 'Display icon in box counter', 'elementor-olympus' ),
				'default'     => 'no',
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'icon',
			[
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label'       => esc_html__( 'Select Icon', 'elementor-olympus' ),
				'description' => esc_html__( 'Choose an icon to display', 'elementor-olympus' ),
				'default'     => [
					'value'   => 'far fa-gem',
					'library' => 'fa-regular',
				],
				'condition'   => [
					'icon_show' => 'yes'
				],
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'number',
			[
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'label'       => esc_html__( 'Targeted number', 'elementor-olympus' ),
				'description' => esc_html__( 'The targeted number to count up to (From zero).', 'elementor-olympus' ),
				'default'     => 100,
				'separator'   => 'before'
			]
		);
		$this->add_control(
			'duration',
			[
				'label'       => esc_html__( 'Duration', 'elementor-olympus' ),
				'description' => esc_html__( 'Animation duration. (in seconds)', 'elementor-olympus' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => 2
			]
		);
		$this->add_control(
			'units',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Units', 'elementor-olympus' ),
				'description' => esc_html__( 'Type unit near counter numbers ( % , + , etc. )', 'elementor-olympus' ),
				'separator'   => 'before',
				'default'     => 'K{+}'
			]
		);

		$this->add_control(
			'label',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Label', 'elementor-olympus' ),
				'description' => esc_html__( 'The text description of the counter.', 'elementor-olympus' ),
				'default'     => 'Percent number',
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'wrap_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Extra class', 'elementor-olympus' ),
				'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Text', 'elementor-olympus' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'text-typography',
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .counter-title'
			]
		);

		$this->add_control(
			'text-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-seosoght' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .counter-title' => 'color: {{SCHEME}}'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'number-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Number', 'elementor-olympus' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'number-typography',
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .counter-numbers'
			]
		);

		$this->add_control(
			'number-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-seosoght' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .counter-numbers' => 'color: {{SCHEME}}'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'icon-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Icon', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'icon-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color Icon', 'elementor-seosoght' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .element-icon i' => 'color: {{SCHEME}}'
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'icon-font-size',
			[
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Size Icon', 'elementor-olympus' ),
				'size_units' => [ 'px', 'em', '%' ],
				'range'      => [
					'px' => [
						'min' => 1,
						'max' => 200,
					]
				],
				'selectors'  => [
					'{{WRAPPER}} .element-icon i' => 'font-size: {{SIZE}}{{UNIT}};'
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'icon-background-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'elementor-seosoght' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .element-icon' => 'background-color: {{SCHEME}}'
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'icon-padding',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Padding', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .element-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'icon-margin',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Margin', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .element-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_group_control(
			'border',
			[
				'name'      => 'icon-border',
				'label'     => esc_html__( 'Border', 'elementor-olympus' ),
				'selector'  => '{{WRAPPER}} .element-icon',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'icon-border-radius',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Border Radius', 'elementor-olympus' ),
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .element-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'icon-border_border!' => '',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'delimiter-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Delimiter', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'delimiter-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-seosoght' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .counter-line *' => 'background-color: {{SCHEME}}'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Box Style', 'elementor-olympus' )
			]
		);

		$this->add_control(
			'box-align',
			[
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'label'   => esc_html__( 'Text Align', 'elementor-olympus' ),
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Centered', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justify', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-justify',
					]
				],
				'default' => 'center'
			]
		);

		$this->add_control(
			'box-padding',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Padding', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'box-margin',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Margin', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$label     = ! empty( $settings['label'] ) ? esc_html( $settings['label'] ) : '';
		$units     = ! empty( $settings['units'] ) ? esc_attr( $settings['units'] ) : '';
		$number    = ! empty( $settings['number'] ) ? $settings['number'] : '';
		$duration  = ! empty( $settings['duration'] ) ? $settings['duration'] : 2;
		$box_align = ! empty( $settings['box-align'] ) ? es_get_align( $settings['box-align'] ) : '';

		$wrap_class = [ 'crumina-module', 'crumina-counter-item' ];
		if ( ! empty( $settings['wrap_class'] ) ) {
			$wrap_class[] = $settings['wrap_class'];
		}

		if ( ! empty( $settings['icon_show'] ) && $settings['icon_show'] == 'yes' ) {
			$icon = '<div class="element-icon"><i class="' . esc_attr( ! empty( $settings['icon']['value'] ) ? $settings['icon']['value'] : 'fas fa-puzzle-piece' ) . '"></i></div>';
		} else {
			$icon = '';
		} ?>


		<div class="<?php echo esc_attr( implode( ' ', $wrap_class ) ); ?>" <?php echo $box_align; ?>>
			<div class="counter-numbers h2">
				<?php echo $icon; ?>
				<span class="purecounter" data-purecounter-duration="<?php echo esc_attr( $duration ); ?>" data-purecounter-end="<?php echo esc_attr( $number ); ?>" data-purecounter-start="2"><?php echo esc_html( $number ); ?></span>
				<?php if ( $units ) { ?>
					<div class="units"><?php echo strip_tags( preg_replace( '/(\{+)(.+)(\}+)/', '<div>$2</div>', $units ), '<div>' ); ?></div>
				<?php } ?>
			</div>
			<?php if ( $label ) { ?>
				<div class="h5 counter-title"><?php echo esc_html( $label ); ?></div>
			<?php } ?>
		</div>
		<?php
	}
}