<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! defined( 'FW' ) ) {
	return;
}

class Elementor_Olympus_FW_Form extends \Elementor\Widget_Base {

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script( 'fw-form-ajax', ES_PLUGIN_URL. '/assets/js/fw-form-helpers.js', [ 'jquery' ], '1', true );
	}

	public function get_name() {
		return 'olympus_fw_form';
	}

	public function get_title() {
		return esc_html__( 'Contact Form', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-form';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

	public function get_script_depends() {
		return [ 'fw-form-ajax' ];
	}

	protected function register_controls() {

		if ( function_exists( 'olympus_button_colors' ) ) {
			$button_colors = es_button_colors();
		} else {
			$button_colors = array();
		}


		$forms   = get_posts(
			array(
				'post_type'   => 'crum-form',
				'numberposts' => - 1
			)
		);
		$choices = [];
		if ( ! empty( $forms ) ) {
			foreach ( $forms as $form ) {
				$choices[ $form->ID ] = empty( $form->post_title ) ? esc_html__( '(no title)', 'elementor-olympus' ) : $form->post_title;
			}
		}

		$this->start_controls_section(
			'olympus_fw_form_main',
			[
				'label' => esc_html__( 'Form', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'form',
			[
				'type'        => \Elementor\Controls_Manager::SELECT,
				'label'       => esc_html__( 'Select Form', 'elementor-olympus' ),
				'description' => esc_html__( 'You can edit forms in admin interface only.', 'elementor-olympus' ),
				'options'     => $choices
			]
		);

		$this->add_control(
			'redirect_url',
			[
				'type'        => \Elementor\Controls_Manager::URL,
				'label'       => esc_html__( 'Redirect On Submit', 'elementor-olympus' ),
				'description' => esc_html__( 'Users will be redirected after form submit to that URL', 'elementor-olympus' ),
			]
		);
		$this->add_control(
			'el_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Module additional class', 'elementor-olympus' ),
				'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'style-form',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Style', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'submit_color',
			[
				'type'    => \Elementor\Controls_Manager::SELECT,
				'label'   => esc_html__( 'Submit Color', 'elementor-olympus' ),
				'default' => 'primary',
				'options' => $button_colors
			]
		);
		$this->add_control(
			'align',
			[
				'type'        => \Elementor\Controls_Manager::SELECT,
				'label'       => esc_html__( 'Align', 'elementor-olympus' ),
				'description' => esc_html__( 'The alignment of elements', 'elementor-olympus' ),
				'options'     => [
					''        => esc_html__( 'None', 'elementor-olympus' ),
					'left'    => esc_html__( 'Left', 'elementor-olympus' ),
					'center'  => esc_html__( 'Centered', 'elementor-olympus' ),
					'right'   => esc_html__( 'Right', 'elementor-olympus' ),
					'justify' => esc_html__( 'Justify', 'elementor-olympus' ),
				],
				'default'     => '',
				'separator'   => 'before',
				'selectors'   => [ '{{WRAPPER}}' => 'text-align: {{VALUE}}' ]
			]
		);
		$this->add_control(
			'input',
			[
				'type'      => \Elementor\Controls_Manager::HEADING,
				'label'     => __( 'Input', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'input-typography',
				'label'    => esc_html__( 'Font', 'elementor-olympus' ),
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .field-text input, {{WRAPPER}} select, {{WRAPPER}} textarea',
			]
		);


		$this->add_control(
			'input_text_color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Text Color', 'elementor-olympus' ),
				'selectors' => [ '{{WRAPPER}} .field-text input, {{WRAPPER}} select, {{WRAPPER}} textarea' => 'color: {{VALUE}}' ]
			]
		);
		$this->add_control(
			'input_bg_color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'elementor-olympus' ),
				'selectors' => [ '{{WRAPPER}} .field-text input, {{WRAPPER}} select, {{WRAPPER}} textarea' => 'background-color: {{VALUE}}' ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'input_border',
				'label'    => __( 'Border', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} .field-text input, {{WRAPPER}} select, {{WRAPPER}} textarea',
			]
		);
		$this->add_control(
			'button',
			[
				'type'      => \Elementor\Controls_Manager::HEADING,
				'label'     => __( 'Button', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);
		$this->add_control(
			'button-align',
			[
				'type'        => \Elementor\Controls_Manager::SELECT,
				'label'       => esc_html__( 'Align', 'elementor-olympus' ),
				'description' => esc_html__( 'The alignment of elements', 'elementor-olympus' ),
				'options'     => [
					'left'    => esc_html__( 'Left', 'elementor-olympus' ),
					'center'  => esc_html__( 'Centered', 'elementor-olympus' ),
					'right'   => esc_html__( 'Right', 'elementor-olympus' ),
				],
				'default'     => 'left',
				'separator'   => 'before',
				'selectors'   => [ '{{WRAPPER}} .submit-wrap' => 'text-align: {{VALUE}}' ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'button-typography',
				'label'    => esc_html__( 'Font', 'elementor-olympus' ),
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} button, {{WRAPPER}} input[type=submit], {{WRAPPER}} input[type=button]',
			]
		);


		$this->add_control(
			'button_text_color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Text Color', 'elementor-olympus' ),
				'selectors' => [ '{{WRAPPER}} button, {{WRAPPER}} input[type=submit], {{WRAPPER}} input[type=button]' => 'color: {{VALUE}}' ]
			]
		);
		$this->add_control(
			'button_bg_color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'elementor-olympus' ),
				'selectors' => [ '{{WRAPPER}} button, {{WRAPPER}} input[type=submit], {{WRAPPER}} input[type=button]' => 'background-color: {{VALUE}}' ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'button_border',
				'label'    => __( 'Border', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} button, {{WRAPPER}} input[type=submit], {{WRAPPER}} input[type=button]',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$form_id   = $color_form = $color_btn = $button_class = '';
		$form_tags = $submit_atts = $form_attr = array();

		/** @var array $atts */
		//custom class element
		$wrap_class[] = 'crumina-module';
		$wrap_class[] = 'standart-form-flex';
		$wrap_class[] = $settings['el_class'];
		$link         = $settings['redirect_url'];
		$form_id      = $settings['form'];
		$color_btn    = $settings['submit_color'];
		$a_target     = '';
		if ( strlen( $link['url'] ) > 0 ) {
			$a_href   = $link['url'];
			$a_target = $link['is_external'] == 'on' ? '_blank' : '';
		}


		if ( ! empty( $a_href ) ) {
			$form_attr[] = 'data-redirect-page="' . esc_attr( $a_href ) . '"';
			$form_attr[] = 'data-redirect-target="' . esc_attr( $a_target ) . '"';
		}

		if ( isset( $form_id ) && $form_id > 0 ) { ?>
			<div class="<?php echo implode( ' ', $wrap_class ); ?>" <?php echo implode( ' ', $form_attr ); ?>>

				<?php
				$form_options = get_post_meta( $form_id, 'fw_options', true );
				if ( ! empty( $form_options ) ) {
					$form_html = fw()->extensions->get( 'forms' )->render_form( $form_id, $form_options['form'], 'contact-forms', '' );

					preg_match_all( '/<input[^>]+>/i', $form_html, $result );
					$result = array_shift( $result );
					foreach ( $result as $input ) {
						preg_match_all( '/(class|value|type)=("[^"]*")/i', $input, $form_tags[ $input ] );
					}

					foreach ( $form_tags as $tag ) {
						if ( '"submit"' === $tag[2][0] ) {
							$submit_atts = $tag[2];
						}
					}
					if ( isset( $submit_atts[2] ) ) {
						$button_class = $submit_atts[2];
					}

					$button_html = '<div class="col-xs-12 submit-wrap"><button type="submit" class="btn btn-md btn-' . esc_attr( $color_btn . ' ' . $button_class ) . '"><span class="text">' . esc_html( $form_options['submit_button_text'] ) . '</span></button></div></form>';
					$form_html   = str_replace( '</form>', $button_html, $form_html );
					if ( function_exists( 'olympus_html_tag' ) && function_exists( 'olympus_render' ) ) {
						$form_html .= olympus_html_tag( 'div', array( 'class' => 'screen-reader-text form-message-field' ), $form_options['success_message'] );
						olympus_render( $form_html );
					}
				} else {
					esc_html_e( 'Please create new and select contact form.', 'elementor-olympus' );
				}
				?>
			</div>
		<?php } else { ?>
			<?php esc_html_e( 'Please create new and select contact form.', 'elementor-olympus' ); ?>
		<?php }

	}
}