<?php
if ( ! defined( 'ABSPATH'  ) ) {
    exit; // Exit if accessed directly.
}

class Elementor_Olympus_Groups_Slider extends \Elementor\Widget_Base {
    public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script( 'olympus-elementor-swiper-init', ES_PLUGIN_URL. '/assets/js/swiper-init.js', [ 'jquery' ], '1', true );
	}

    public function get_name() {
		return 'olympus_groups_slider';
	}

	public function get_title() {
		return esc_html__( 'Groups Slider', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-clients-slider';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
    }

    public function get_script_depends() {
		return [ 'olympus-elementor-swiper-init' ];
	}

	protected function register_controls() {
        $this->start_controls_section(
			'olympus_groups_slider',
			[
				'label' => esc_html__( 'Groups Slider', 'elementor-olympus' ),
			]
		);

        $this->add_control(
            'group_ids',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Select group ids', 'elementor-olympus' ),
                'default'     => 'no',
            ]
        );

        $groups = groups_get_groups( array(
            'per_page' => -1,
        ));
        $groups_arr = array();
        if(!empty($groups) && isset($groups['groups'])){
            foreach($groups['groups'] as $group){
                $groups_arr[$group->id] = $group->name;
            }
        }

        $this->add_control(
            'group_ids_select',
            [
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label' => esc_html__( 'Groups', 'elementor-olympus' ),
                'multiple' => true,
				'options' => $groups_arr,
                'separator'   => 'before',
                'condition'   => [
                    'group_ids' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'exclude_ids',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Exclude selected ids', 'elementor-olympus' ),
                'default'     => 'no',
                'separator'   => 'before',
                'condition'   => [
                    'group_ids' => 'yes'
                ],
            ]
        );

        $this->add_control(
			'number_of_items',
			[
                'type'        => \Elementor\Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Number of items', 'elementor-olympus' ),
                'description' => esc_html__( 'Number of items displayed on one screen', 'elementor-olympus' ),
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 10,
                        'step' => 1
                    ]
                ],
                'default'     => [
                    'unit' => 'px',
                    'size' => 3
                ],
                'separator'   => 'before'
			]
        );

        $this->add_control(
            'arrows',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Show Arrows', 'elementor-olympus' ),
                'description' => esc_html__( 'Previous/ Next Slider buttons', 'elementor-olympus' ),
                'default'     => 'yes',
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'dots',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Show Dots', 'elementor-olympus' ),
                'description' => esc_html__( 'Pagination dots', 'elementor-olympus' ),
                'default'     => 'no',
                'condition'   => [
                    'arrows!' => 'yes'
                ],
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'autoscroll',
            [
                'type'        => \Elementor\Controls_Manager::SWITCHER,
                'label'       => esc_html__( 'Autoslide', 'elementor-olympus' ),
                'description' => esc_html__( 'Automatic auto scroll slides', 'elementor-olympus' ),
                'default'     => 'no',
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'time',
            [
                'type'        => \Elementor\Controls_Manager::SLIDER,
                'label'       => esc_html__( 'Delay between scroll', 'elementor-olympus' ),
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px' => [
                        'min'  => 1,
                        'max'  => 30,
                        'step' => 1
                    ]
                ],
                'default'     => [
                    'unit' => 'px',
                    'size' => 5
                ],
                'condition'   => [
                    'autoscroll' => 'yes'
                ],
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'custom_class',
            [
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label'       => esc_html__( 'Custom class', 'elementor-olympus' ),
                'description' => esc_html__( 'Enter extra custom class', 'elementor-olympus' ),
                'separator'   => 'before'
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'item-css',
            [
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Item params', 'elementor-olympus' ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'      => 'item-background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .olympus-elem-group-data',
                'separator' => 'before'
            ]
        );

        $this->add_control(
			'item-text-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Text Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .bp-group-home-link' => 'color: {{SCHEME}};'
				]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'style-css',
            [
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'label' => esc_html__( 'Main params', 'elementor-olympus' ),
            ]
        );

        $this->add_control(
            'style-padding',
            [
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'label'      => __( 'Padding', 'elementor-olympus' ),
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}}' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'style-margin',
            [
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'label'      => __( 'Margin', 'elementor-olympus' ),
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before'
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'      => 'style-background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}}',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            'border',
            [
                'name'      => 'style-border',
                'label'     => esc_html__( 'Border', 'elementor-olympus' ),
                'selector'  => '{{WRAPPER}}',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'style-border-radius',
            [
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'label'      => __( 'Border Radius', 'elementor-olympus' ),
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}}' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'style-border_border!' => '',
                ],
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        $wrap_class = [ 'groups-slider-module', 'crumina-module', 'crumina-module-slide', 'crumina-groups' ];
        if ( ! empty( $settings['custom_class'] ) ) {
            $wrap_class[] = $settings['custom_class'];
        }

        $group_per_page = -1;

        if ( ! empty( $settings['number_of_items']['size'] ) ) {
	        $show_items_attr = 'data-show-items="' . esc_attr( $settings['number_of_items']['size'] ) . '"';
        } else {
	        $show_items_attr = 'data-show-items="3"';
        }

        $search_group = array(
            'per_page' => $group_per_page,
        );

        if ( ! empty( $settings['group_ids'] ) && $settings['group_ids'] == 'yes' ) {
            if ( ! empty( $settings['exclude_ids'] ) && $settings['exclude_ids'] == 'yes' ) {
                $search_group['exclude'] = $settings['group_ids_select'];
            } else {
                $search_group['include'] = $settings['group_ids_select'];
            }
        }

        $groups = groups_get_groups($search_group);

        if ( ! empty( $settings['autoscroll'] ) && $settings['autoscroll'] == 'yes' ) {
            $time = ! empty( $settings['time']['size'] ) ? $settings['time']['size'] : 0;
            $slider_attr[] = 'data-autoplay="' . esc_attr( intval( $time ) * 1000 ) . '"';
        }
        
        if ( ! empty( $settings['arrows'] ) && $settings['arrows'] == 'yes' ) {
            $pagination_class = 'pagination-bottom-large';
	        $slider_attr[] = 'data-prev-next="1"';
        } elseif ( ! empty( $settings['dots'] ) && $settings['dots'] == 'yes' ) {
            $pagination_class = 'pagination-bottom';
        } else {
            $pagination_class = '';
        }

        ?>
        <div class="<?php echo implode( ' ', $wrap_class ); ?>">
            <?php
                if ( ! empty( $groups ) && isset($groups['groups']) ) {
                $slider_attr[] = $show_items_attr;
                ?>
                <div class="swiper-container <?php echo esc_attr( $pagination_class ) ?>" <?php echo implode( ' ', $slider_attr ); ?>>
                    <div class="swiper-wrapper">
                        <?php
                            foreach ( (array) $groups['groups'] as $group ) {
                            $image = '<img loading="lazy" src="' . bp_core_fetch_avatar( array( 'item_id' => $group->id, 'object' => 'group', 'width' => 100, 'height' => 100, 'html' => false, 'type' => 'full' ) ) . '" class="olympus-rounded" alt="' . esc_attr( $group->name ) . '">';
                            $cover_path = bp_attachments_get_attachment( 'url', array( 'item_id' => $group->id, 'object_dir' => 'groups') );
                        ?>  
                        <div class="swiper-slide group-item">
                            <div class="olympus-elem-group-data">
                                <div class="olympus-elem-cover">
                                    <img loading="lazy" src="<?php echo esc_url($cover_path); ?>" alt="">
                                </div>

                                <a href="<?php echo esc_url( bp_get_group_permalink( $group ) ); ?>" class="item-avatar">
                                    <div class="olympus-elem-group-avatar">
                                        <?php olympus_render( $image ); ?>
                                    </div>
                                </a>

                                <div class="item">
                                    <div class="item-title">
                                        <a href="<?php echo esc_url( bp_get_group_permalink( $group ) ); ?>" class="bp-group-home-link">
                                            <?php echo $group->name; ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php 
                            }
                        ?>
                    </div>
                    <?php if ( ! empty( $settings['arrows'] ) && $settings['arrows'] == 'yes' ) { ?>
                        <svg class="btn-next swiper-btn-next">
                            <use xlink:href="#olymp-popup-right-arrow"></use>
                        </svg>
                        <svg class="btn-prev swiper-btn-prev">
                            <use xlink:href="#olymp-popup-left-arrow"></use>
                        </svg>
                    <?php } elseif ( ! empty( $settings['dots'] ) && $settings['dots'] == 'yes' ) { ?>
                        <div class="swiper-pagination"></div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
        <?php
        if(is_admin()){ ?>
        <script>
            jQuery( function ( $ ) {
                CRUMINA.Swiper.init();
            });
        </script>
        <?php 
        }
    }
}

