<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Olympus_Pricing_Box extends \Elementor\Widget_Base {

	public function get_name() {
		return 'olympus_pricing_box';
	}

	public function get_title() {
		return esc_html__( 'Pricing Box', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'eicon-image-box';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

	protected function register_controls() {


		$this->start_controls_section(
			'olympus_pricing_box',
			[
				'label' => esc_html__( 'Box', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'title',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Title', 'elementor-olympus' ),
				'default'   => 'Text Title',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'desc',
			[
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'label'       => esc_html__( 'Atributes', 'elementor-olympus' ),
				'description' => wp_kses( __( 'Insert tag &lt;strong&gt; when you want highlight text.<br> Example: &lt;strong&gt;<strong>24/7</strong>&lt;/strong&gt; Support', 'elementor-olympus' ), [ 'br', 'strong' ] ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'icon_check',
			[
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label'       => esc_html__( 'Select Icon Check', 'elementor-seosight' ),
				'default'     => [
					'value'   => 'fas fa-check',
					'library' => 'fa-solid',
				],
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'price',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Price', 'elementor-olympus' ),
				'default'   => '99',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'current_price',
			[
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Current price', 'elementor-olympus' ),
				'default'   => '',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'currency',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Currency', 'elementor-olympus' ),
				'default'   => '$',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'duration',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Per', 'elementor-olympus' ),
				'default'   => '/month',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'show_button',
			[
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Display button', 'elementor-olympus' ),
				'default'   => 'yes',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'button_text',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Button text', 'elementor-olympus' ),
				'default'   => 'Purchase',
				'condition' => [
					'show_button' => 'yes',
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'button_link_name',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Link Name', 'elementor-olympus' ),
				'condition' => [
					'show_button' => 'yes',
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'button_link',
			[
				'type'      => \Elementor\Controls_Manager::URL,
				'label'     => esc_html__( 'Link', 'elementor-olympus' ),
				'condition' => [
					'show_button' => 'yes',
				]
			]
		);

		$this->add_control(
			'custom_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Custom class', 'elementor-olympus' ),
				'description' => esc_html__( 'Enter extra custom class', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();
// STYLE
		$this->start_controls_section(
			'style',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Style', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'primary_color',
			[
				'type'        => \Elementor\Controls_Manager::COLOR,
				'label'       => esc_html__( 'Background Color', 'elementor-olympus' ),
				'description' => esc_html__( 'Primary elements color', 'elementor-olympus' ),
				'scheme'      => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				]
			]
		);

		$this->add_control(
			'title-css',
			[
				'type'      => \Elementor\Controls_Manager::HEADING,
				'label'     => __( 'Title', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#515365',
				'selectors' => [
					'{{WRAPPER}} .pricing-item-title' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title-typography',
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}}  .pricing-item-title',
			]
		);

		$this->add_control(
			'text-css',
			[
				'type'      => \Elementor\Controls_Manager::HEADING,
				'label'     => __( 'Text', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'text-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#515365',
				'selectors' => [
					'{{WRAPPER}}  .pricing-tables-position' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'text-typography',
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}}  .pricing-tables-position',
			]
		);

		$this->add_control(
			'price-css',
			[
				'type'      => \Elementor\Controls_Manager::HEADING,
				'label'     => __( 'Price', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'price-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#515365',
				'selectors' => [
					'{{WRAPPER}} .pricing-item-price' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'price-typography',
				'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pricing-item-price',
			]
		);

		$this->add_control(
			'button-css',
			[
				'type'      => \Elementor\Controls_Manager::HEADING,
				'label'     => __( 'Button', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'button-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Text Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}}  .btn' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'button-background-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'selectors' => [
					'{{WRAPPER}}  .btn' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'icon-css',
			[
				'type'  => \Elementor\Controls_Manager::HEADING,
				'label' => __( 'Icon', 'elementor-olympus' )
			]
		);

		$this->add_control(
			'icon-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}}  .pricing-tables-position i' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'icon-font-size',
			[
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Icon Size', 'elementor-olympus' ),
				'size_units' => [ 'px', 'em', '%' ],
				'range'      => [
					'px' => [
						'min' => 1,
						'max' => 200,
					]
				],
				'selectors'  => [
					'{{WRAPPER}}  .pricing-tables-position i' => 'font-size: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'hover-animation',
			[
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label'     => esc_html__( 'Animation on hover', 'elementor-olympus' ),
				'default'   => 'yes',
				'separator' => 'before'
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
						$box = $this->get_settings_for_display();

                        // Pricing Box
                        $data_price = $data_currency = $data_duration = '';

                        $primary_color = ! empty( $box['primary_color'] ) ? $box['primary_color'] : '#515365';
						$title         = ! empty( $box['title'] ) ? $box['title'] : '';
                        $desc          = ! empty( $box['desc'] ) ? $box['desc'] : '';
                        $check_icon    = ! empty( $box['icon_check'] ) ? $box['icon_check'] : '';

                        $wrap_class = [
                            'crumina-module',
							'crumina-pricing-table'
						];

						if( $box['hover-animation'] == 'yes' ){
							$wrap_class[] = 'animate-hover-top';
						}

						if( $box['current_price'] == 'yes' ){
							$wrap_class[] = 'current-price';
						}

                        if ( ! empty( $box['custom_class'] ) ) {
                            $wrap_class[] = $box['custom_class'];
                        }

                        if ( ! empty( $box['price'] ) ) {
                            $data_price = html_entity_decode( $box['price'] );
                        }

                        if ( ! empty( $box['currency'] ) ) {
                            $data_currency = $box['currency'];
                        }

                        if ( ! empty( $box['duration'] ) ) {
                            $data_duration = $box['duration'];
                        }

                        ?>
                        <div class="<?php echo implode( ' ', $wrap_class ); ?>" style="background-color: <?php echo $primary_color; ?>">
							<?php
								if ( $title ) {
									echo '<div class="h5 pricing-item-title">' . esc_html( $title ) . '</div>';
								}
								echo '<div class="h3 pricing-item-price">' . $data_currency . $data_price . $data_duration . '</div>';
								if ( $desc ) {
									$pros = explode( "\n", $desc );
									if ( count( $pros ) ) {
										echo '<ul class="list--standard pricing-tables-position">';
										foreach ( $pros as $pro ) {
											?>
											<li>
												<i class="<?php echo $check_icon['value']; ?>"></i>
												<?php echo $pro; ?>
											</li>
											<?php
										}
										echo '</ul>';
									}
								}
								if ( ! empty( $box['show_button'] ) && $box['show_button'] == 'yes' ) {
									$button_text = ! empty( $box['button_text'] ) ? $box['button_text'] : '';

									$button_attr = [
										'class="btn btn-primary btn-md w-100"',
										'href="' . esc_attr( $box['button_link']['url'] ) . '"',
										'target="'. ( ! empty( $box['button_link']['is_external'] ) ? '_blank' : '_self' ) . '"',
										'alt="'. ( ! empty( $box['button_link_name'] ) ? $box['button_link_name'] : $button_text ) . '"',
										! empty( $box['button_link']['nofollow'] ) ? 'rel="nofollow"' : ''
									];

									$custom_attr = $box['button_link']['custom_attributes'];
									if($custom_attr != ''){
										$custom_attr_array = explode(',', $custom_attr);
										if(!empty($custom_attr_array)){
											foreach($custom_attr_array as $custom_attr_val){
												$custom_attr_val_arr = explode('|', $custom_attr_val);
												array_push($button_attr, $custom_attr_val_arr[0] . '="' . $custom_attr_val_arr[1] .'"');
											}
										}
									}

									echo '<a ' . implode( ' ', $button_attr ) . '>' . esc_html( $button_text ) . '</a>';
								}
							?>
                        </div>
            <?php
	}
}