<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       www.redefiningtheweb.com
 * @since      1.0.0
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/admin
 * @author     RedefiningTheWeb <developer@redefiningtheweb.com>
 */
class Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $rtwwcfm_plugin_name    The ID of this plugin.
	 */
	private $rtwwcfm_plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $rtwwcfm_version    The current version of this plugin.
	 */
	private $rtwwcfm_version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $rtwwcfm_plugin_name       The name of this plugin.
	 * @param      string    $rtwwcfm_version    The version of this plugin.
	 */
	public function __construct( $rtwwcfm_plugin_name, $rtwwcfm_version ) {

		$this->rtwwcfm_plugin_name = $rtwwcfm_plugin_name;
		$this->rtwwcfm_version = $rtwwcfm_version;
		$this->enable_mltistep = 0;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the rtwwcfm_run() function
		 * defined in Wordpress_Contact_Form_7_Multistep_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wordpress_Contact_Form_7_Multistep_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		$rtwwcfm_screen = get_current_screen();
		if($rtwwcfm_screen->id == 'contact_page_wpcf7-new' || $rtwwcfm_screen->id == 'toplevel_page_wpcf7'){
			wp_enqueue_style( $this->rtwwcfm_plugin_name, plugin_dir_url( __FILE__ ) . 'css/rtwwcfm-wordpress-contact-form-7-multistep-admin.css', array(), $this->rtwwcfm_version, 'all' );
		}
		wp_enqueue_style( 'wp-color-picker' );
		if ( isset($_GET['page'] ) && $_GET['page'] = 'wpcf7' ) {
			wp_enqueue_style( "font-awesom", plugin_dir_url( __FILE__ ) . 'css/fontawesome-all.min.css', array(), $this->rtwwcfm_version, 'all' );
		}

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the rtwwcfm_run() function
		 * defined in Wordpress_Contact_Form_7_Multistep_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wordpress_Contact_Form_7_Multistep_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->rtwwcfm_plugin_name, plugin_dir_url( __FILE__ ) . 'js/rtwwcfm-wordpress-contact-form-7-multistep-admin.js', array( 'jquery' ), $this->rtwwcfm_version, false );
		if (isset($_GET['page']) && $_GET['page'] == 'wpcf7' && isset($_GET['post']) && $_GET['page'] != '') {
			$rtwwcfm_ajax_nonce = wp_create_nonce( "rtwwcfm-ajax-security-string" );
			$rtwwcfm_translation_array 	= array(
										'rtwwcfm_ajaxurl' 	=> esc_url( admin_url( 'admin-ajax.php' ) ),
										'rtwwcfm_nonce' 	=> $rtwwcfm_ajax_nonce,
										'preview_img_url'   => plugins_url(  )
									);
			wp_localize_script( $this->rtwwcfm_plugin_name, 'rtwwcfm_param', $rtwwcfm_translation_array );
		}
		wp_enqueue_script( 'wp-color-picker');
	}
	/**
	 * Add custom tab in contact form 7 setting area.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_add_multistep_tab($rtwwcfm_panels){
		$rtwwcfm_panels['form-panel'] = array('title' => esc_html__('Form', 'rtwwcfm-wordpress-contact-form-7-multistep'), 'callback' =>array($this,'rtwwcfm_customize_wpcf7_form_panel'));
		return $rtwwcfm_panels;
	}
	/**
	 * Render custom contact form 7 form panel.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_customize_wpcf7_form_panel($rtwwcfm_post) 
	{
	    $this->enable_mltistep = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_enable_multstp', true );
	    $rtwwcfm_modal_width = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_modal_width', true );
	    $rtwwcfm_modal_height = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_modal_height', true );
	    $rtwwcfm_mltstp = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_enable_multstp', true );
	    $rtwwcfm_enable_preview = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_enable_preview', true );
	    $rtwwcfm_nxt_btn_txt = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_nxt_btn_txt', true );
	    $rtwwcfm_nxt_prvs_txt = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_nxt_prvs_txt', true );
	    $rtwwcfm_nxt_btn_color = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_nxt_btn_color', true );
	    $rtwwcfm_previous_btn_color = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_previous_btn_color', true );
	    $rtwwcfm_active_btn_color = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_active_btn_color', true );
	    $rtwwcfm_strip_color = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_strip_color', true );
	    $rtwwcfm_stripe_clor = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_stripe_clor', true );
	    $rtwwcfm_tab_font = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_tab_font', true );
	    $rtwwcfm_tab_color = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_tab_color', true );
	    $rtwwcfm_mltstp_type = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_multstp_type', true );

	    $rtwwcfm_preview_modal_height = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_preview_modal_height', true );
	    $rtwwcfm_preview_modal_width = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_preview_modal_width', true );
	    $rtwwcfm_preview_modal_close_efect = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_preview_modal_close_efect', true );
	    $rtwwcfm_preview_modal_title = get_post_meta( $rtwwcfm_post->id(), 'rtwwcfm_preview_modal_title', true );
	    if ($rtwwcfm_mltstp_type == '' || !$rtwwcfm_mltstp_type) {
	    	$rtwwcfm_mltstp_type = 1;
	    }
	    $tag_generator = WPCF7_TagGenerator::get_instance();
	    $tag_generator->print_buttons();
		include(RTWWCFM_DIR.'admin/partials/wordpress-contact-form-7-multistep-custom-form-panel.php');
	}
	/**
	 * Show default form steps and HTML.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_default_form_steps($rtwwcfm_post=''){
		$get_form_meta = get_post_meta( $rtwwcfm_post, 'rtwwcfm_step_name_val', true );
		if ( $get_form_meta ) {
			return $get_form_meta;
		}else{
			return array( 
			 	"Step - 1" => "<label> Your name
    [text* your-name] </label>",

				"Step - 2" => "<label> Your email
    [email* your-email] </label>",

			 	"Step - 3" => "<label> Subject
    [text* your-subject] </label>
<label> Your message (optional)
    [textarea your-message] </label>

[submit \"Submit\"]",
	        );
		}
	}
	/**
	 * Update post_meta from custom setting tab.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_update_post_meta($rwwcfm_post_id, $erwwcfm_post, $erwwcfm_update) 
	{
		if ( isset($_POST['rtwwcfm_step_name']) && !empty($_POST['rtwwcfm_step_name']) && isset($_POST['rtwwcfm_steps_value']) && !empty($_POST['rtwwcfm_steps_value'])) 
		{
			$rtwwcfm_key_val = array_combine($_POST['rtwwcfm_step_name'],$_POST['rtwwcfm_steps_value']);

			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_step_name_val',($rtwwcfm_key_val ));
		}
		if ( isset($_POST['rtwwcfm_stripe_clor']) && ($_POST['rtwwcfm_stripe_clor'])!= '' )
		{
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_stripe_clor',sanitize_text_field($_POST['rtwwcfm_stripe_clor']) );
		}
		if ( isset($_POST['rtwwcfm_tab_font']) && ($_POST['rtwwcfm_tab_font'])!= '' ) 
		{
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_tab_font',sanitize_text_field($_POST['rtwwcfm_tab_font']) );
		}
		if ( isset($_POST['rtwwcfm_tab_color']) && ($_POST['rtwwcfm_tab_color'])!= '' ) 
		{
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_tab_color',sanitize_text_field($_POST['rtwwcfm_tab_color']) );
		}
		if ( isset($_POST['rtwwcfm_multstp_enable']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_enable_multstp',($_POST['rtwwcfm_multstp_enable']) );
		}
		if ( isset($_POST['rtwwcfm_multistep_type']) && $_POST['rtwwcfm_multistep_type'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_multstp_type',sanitize_text_field($_POST['rtwwcfm_multistep_type']) );
		}
		if ( isset($_POST['rtwwcfm_nxt_btn_txt']) && $_POST['rtwwcfm_nxt_btn_txt'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_nxt_btn_txt',sanitize_text_field($_POST['rtwwcfm_nxt_btn_txt']) );
		}
		if ( isset($_POST['rtwwcfm_nxt_prvs_txt']) && $_POST['rtwwcfm_nxt_prvs_txt'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_nxt_prvs_txt',sanitize_text_field($_POST['rtwwcfm_nxt_prvs_txt']) );
		}
		if ( isset($_POST['rtwwcfm_nxt_btn_color']) && $_POST['rtwwcfm_nxt_btn_color'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_nxt_btn_color',sanitize_text_field($_POST['rtwwcfm_nxt_btn_color']) );
		}
		if ( isset($_POST['rtwwcfm_previous_btn_color']) && $_POST['rtwwcfm_previous_btn_color'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_previous_btn_color',sanitize_text_field($_POST['rtwwcfm_previous_btn_color']) );
		}
		if ( isset($_POST['rtwwcfm_active_btn_color']) && $_POST['rtwwcfm_active_btn_color'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_active_btn_color',sanitize_text_field($_POST['rtwwcfm_active_btn_color']) );
		}
		if ( isset($_POST['rtwwcfm_strip_color']) && $_POST['rtwwcfm_strip_color'] != '' ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_strip_color',sanitize_text_field($_POST['rtwwcfm_strip_color']) );
		}
		if ( isset($_POST['rtwwcfm_modal_height']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_modal_height',($_POST['rtwwcfm_modal_height']) );
		}
		if ( isset($_POST['rtwwcfm_modal_width']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_modal_width',($_POST['rtwwcfm_modal_width']) );
		}
		if ( isset($_POST['rtwwcfm_enable_preview']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_enable_preview',($_POST['rtwwcfm_enable_preview']) );
		}
		if ( isset($_POST['rtwwcfm_preview_modal_height']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_preview_modal_height',($_POST['rtwwcfm_preview_modal_height']) );
		}
		if ( isset($_POST['rtwwcfm_preview_modal_width']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_preview_modal_width',($_POST['rtwwcfm_preview_modal_width']) );
		}
		if ( isset($_POST['rtwwcfm_preview_modal_close_efect']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_preview_modal_close_efect',($_POST['rtwwcfm_preview_modal_close_efect']) );
		}
		if ( isset($_POST['rtwwcfm_preview_modal_title']) ) {
			update_post_meta( $rwwcfm_post_id, 'rtwwcfm_preview_modal_title',($_POST['rtwwcfm_preview_modal_title']) );
		}
	}
	/**
	 * For sanitize the data.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_sanitize_array($rtwwcfm_data_array)
	{
		if(isset($rtwwcfm_data_array) && !empty($rtwwcfm_data_array))
		{
			$rtwwcfm_save_data_array = array();
			foreach ($rtwwcfm_data_array as $rtwwcfm_key => $rtwwcfm_value) 
			{
				if(is_array($rtwwcfm_value))
				{
					$rtwwcfm_save_data_array[$rtwwcfm_key] = $this->rtwwcfm_sanitize_array($rtwwcfm_value);
				}
				elseif($rtwwcfm_value == "true" || $rtwwcfm_value == "false" || $rtwwcfm_value == "yes" || $rtwwcfm_value == "no")
				{
					$rtwwcfm_save_data_array[$rtwwcfm_key] = filter_var($rtwwcfm_value, FILTER_VALIDATE_BOOLEAN);
				}
				else
				{
					$rtwwcfm_save_data_array[$rtwwcfm_key] = sanitize_text_field($rtwwcfm_value);
				}
			}
			return $rtwwcfm_save_data_array;
		}
	}
}
