<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       www.redefiningtheweb.com
 * @since      1.0.0
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/includes
 * @author     RedefiningTheWeb <developer@redefiningtheweb.com>
 */
class Rtwwcfm_Wordpress_Contact_Form_7_Multistep_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_load_plugin_textdomain() {

		load_plugin_textdomain(
			'rtwwcfm-wordpress-contact-form-7-multistep',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}
}
