<?php

/**
 * Register all actions and filters for the plugin
 *
 * @link       www.redefiningtheweb.com
 * @since      1.0.0
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/includes
 */

/**
 * Register all actions and filters for the plugin.
 *
 * Maintain a list of all hooks that are registered throughout
 * the plugin, and register them with the WordPress API. Call the
 * run function to execute the list of actions and filters.
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/includes
 * @author     RedefiningTheWeb <developer@redefiningtheweb.com>
 */
class Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Loader {

	/**
	 * The array of actions registered with WordPress.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      array    $rtwwcfm_actions    The actions registered with WordPress to fire when the plugin loads.
	 */
	protected $rtwwcfm_actions;

	/**
	 * The array of filters registered with WordPress.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      array    $rtwwcfm_filters    The filters registered with WordPress to fire when the plugin loads.
	 */
	protected $rtwwcfm_filters;

	/**
	 * Initialize the collections used to maintain the actions and filters.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		$this->rtwwcfm_actions = array();
		$this->rtwwcfm_filters = array();

	}

	/**
	 * Add a new action to the collection to be registered with WordPress.
	 *
	 * @since    1.0.0
	 * @param    string               $rtwwcfm_hook             The name of the WordPress action that is being registered.
	 * @param    object               $rtwwcfm_component        A reference to the instance of the object on which the action is defined.
	 * @param    string               $rtwwcfm_callback         The name of the function definition on the $rtwwcfm_component.
	 * @param    int                  $rtwwcfm_priority         Optional. The priority at which the function should be fired. Default is 10.
	 * @param    int                  $rtwwcfm_accepted_args    Optional. The number of arguments that should be passed to the $rtwwcfm_callback. Default is 1.
	 */
	public function rtwwcfm_add_action( $rtwwcfm_hook, $rtwwcfm_component, $rtwwcfm_callback, $rtwwcfm_priority = 10, $rtwwcfm_accepted_args = 1 ) {
		$this->rtwwcfm_actions = $this->rtwwcfm_add( $this->rtwwcfm_actions, $rtwwcfm_hook, $rtwwcfm_component, $rtwwcfm_callback, $rtwwcfm_priority, $rtwwcfm_accepted_args );
	}

	/**
	 * Add a new filter to the collection to be registered with WordPress.
	 *
	 * @since    1.0.0
	 * @param    string               $rtwwcfm_hook             The name of the WordPress filter that is being registered.
	 * @param    object               $rtwwcfm_component        A reference to the instance of the object on which the filter is defined.
	 * @param    string               $rtwwcfm_callback         The name of the function definition on the $rtwwcfm_component.
	 * @param    int                  $rtwwcfm_priority         Optional. The priority at which the function should be fired. Default is 10.
	 * @param    int                  $rtwwcfm_accepted_args    Optional. The number of arguments that should be passed to the $rtwwcfm_callback. Default is 1
	 */
	public function rtwwcfm_add_filter( $rtwwcfm_hook, $rtwwcfm_component, $rtwwcfm_callback, $rtwwcfm_priority = 10, $rtwwcfm_accepted_args = 1 ) {
		$this->rtwwcfm_filters = $this->rtwwcfm_add( $this->rtwwcfm_filters, $rtwwcfm_hook, $rtwwcfm_component, $rtwwcfm_callback, $rtwwcfm_priority, $rtwwcfm_accepted_args );
	}

	/**
	 * A utility function that is used to register the actions and hooks into a single
	 * collection.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @param    array                $rtwwcfm_hooks            The collection of hooks that is being registered (that is, actions or filters).
	 * @param    string               $rtwwcfm_hook             The name of the WordPress filter that is being registered.
	 * @param    object               $rtwwcfm_component        A reference to the instance of the object on which the filter is defined.
	 * @param    string               $rtwwcfm_callback         The name of the function definition on the $component.
	 * @param    int                  $rtwwcfm_priority         The priority at which the function should be fired.
	 * @param    int                  $rtwwcfm_accepted_args    The number of arguments that should be passed to the $rtwwcfm_callback.
	 * @return   array                                  The collection of actions and filters registered with WordPress.
	 */
	private function rtwwcfm_add( $rtwwcfm_hooks, $rtwwcfm_hook, $rtwwcfm_component, $rtwwcfm_callback, $rtwwcfm_priority, $rtwwcfm_accepted_args ) {

		$rtwwcfm_hooks[] = array(
			'hook'          => $rtwwcfm_hook,
			'component'     => $rtwwcfm_component,
			'callback'      => $rtwwcfm_callback,
			'priority'      => $rtwwcfm_priority,
			'accepted_args' => $rtwwcfm_accepted_args
		);

		return $rtwwcfm_hooks;

	}

	/**
	 * Register the filters and actions with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_run() {

		foreach ( $this->rtwwcfm_filters as $rtwwcfm_hook ) {
			add_filter( $rtwwcfm_hook['hook'], array( $rtwwcfm_hook['component'], $rtwwcfm_hook['callback'] ), $rtwwcfm_hook['priority'], $rtwwcfm_hook['accepted_args'] );
		}

		foreach ( $this->rtwwcfm_actions as $rtwwcfm_hook ) {
			add_action( $rtwwcfm_hook['hook'], array( $rtwwcfm_hook['component'], $rtwwcfm_hook['callback'] ), $rtwwcfm_hook['priority'], $rtwwcfm_hook['accepted_args'] );
		}

	}

}
