<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       www.redefiningtheweb.com
 * @since      1.0.0
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/includes
 * @author     RedefiningTheWeb <developer@redefiningtheweb.com>
 */
class Rtwwcfm_Wordpress_Contact_Form_7_Multistep {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Loader    $rtwwcfm_loader    Maintains and registers all hooks for the plugin.
	 */
	protected $rtwwcfm_loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $rtwwcfm_plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $rtwwcfm_plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $rtwwcfm_version    The current version of the plugin.
	 */
	protected $rtwwcfm_version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'RTWWCFM_WORDPRESS_CONTACT_FORM_7_MULTISTEP_VERSION' ) ) {
			$this->rtwwcfm_version = RTWWCFM_WORDPRESS_CONTACT_FORM_7_MULTISTEP_VERSION;
		} else {
			$this->rtwwcfm_version = '1.0.0';
		}
		$this->rtwwcfm_plugin_name = 'wordpress-contact-form-7-multistep';

		$this->rtwwcfm_load_dependencies();
		$this->rtwwcfm_set_locale();
		$this->rtwwcfm_define_admin_hooks();
		$this->rtwwcfm_define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Loader. Orchestrates the hooks of the plugin.
	 * - Rtwwcfm_Wordpress_Contact_Form_7_Multistep_i18n. Defines internationalization functionality.
	 * - Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Admin. Defines all hooks for the admin area.
	 * - Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function rtwwcfm_load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/rtwwcfm-class-wordpress-contact-form-7-multistep-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/rtwwcfm-class-wordpress-contact-form-7-multistep-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/rtwwcfm-class-wordpress-contact-form-7-multistep-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/rtwwcfm-class-wordpress-contact-form-7-multistep-public.php';

		$this->rtwwcfm_loader = new Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Rtwwcfm_Wordpress_Contact_Form_7_Multistep_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function rtwwcfm_set_locale() {

		$rtwwcfm_plugin_i18n = new Rtwwcfm_Wordpress_Contact_Form_7_Multistep_i18n();

		$this->rtwwcfm_loader->rtwwcfm_add_action( 'plugins_loaded', $rtwwcfm_plugin_i18n, 'rtwwcfm_load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function rtwwcfm_define_admin_hooks() {

		$rtwwcfm_plugin_admin = new Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Admin( $this->rtwwcfm_get_plugin_name(), $this->rtwwcfm_get_version() );

		$this->rtwwcfm_loader->rtwwcfm_add_action( 'admin_enqueue_scripts', $rtwwcfm_plugin_admin, 'rtwwcfm_enqueue_styles' );
		$this->rtwwcfm_loader->rtwwcfm_add_action( 'admin_enqueue_scripts', $rtwwcfm_plugin_admin, 'rtwwcfm_enqueue_scripts' );
		$this->rtwwcfm_loader->rtwwcfm_add_filter('wpcf7_editor_panels' , $rtwwcfm_plugin_admin, 'rtwwcfm_add_multistep_tab', '', 1);
		$this->rtwwcfm_loader->rtwwcfm_add_action('save_post_wpcf7_contact_form', $rtwwcfm_plugin_admin, 'rtwwcfm_update_post_meta', '', 3); 
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function rtwwcfm_define_public_hooks() {

		$rtwwcfm_plugin_public = new Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Public( $this->rtwwcfm_get_plugin_name(), $this->rtwwcfm_get_version() );

		$this->rtwwcfm_loader->rtwwcfm_add_action( 'wp_enqueue_scripts', $rtwwcfm_plugin_public, 'rtwwcfm_enqueue_styles' );
		$this->rtwwcfm_loader->rtwwcfm_add_action( 'wp_enqueue_scripts', $rtwwcfm_plugin_public, 'rtwwcfm_enqueue_scripts' );
		$this->rtwwcfm_loader->rtwwcfm_add_action('get_post_metadata', $rtwwcfm_plugin_public, 'rtwwcfm_render_multistep_form' , '99999999', 5);

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_run() {
		$this->rtwwcfm_loader->rtwwcfm_run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function rtwwcfm_get_plugin_name() {
		return $this->rtwwcfm_plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Wordpress_Contact_Form_7_Multistep_Loader    Orchestrates the hooks of the plugin.
	 */
	public function rtwwcfm_get_loader() {
		return $this->rtwwcfm_loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function rtwwcfm_get_version() {
		return $this->rtwwcfm_version;
	}

}
