(function( $ ) {
    'use strict';

    /**
     * All of the code for your public-facing JavaScript source
     * should reside in this file.
     *
     * Note: It has been assumed you will write jQuery code here, so the
     * $ function reference has been prepared for usage within the scope
     * of this function.
     *
     * This enables you to define handlers, for when the DOM is ready:
     *
     * $(function() {
     *
     * });
     *
     * When the window is loaded:
     *
     * $( window ).load(function() {
     *
     * });
     *
     * ...and/or other possibilities.
     *
     * Ideally, it is not considered best practise to attach more than a
     * single DOM-ready or window-load handler for a particular page.
     * Although scripts in the WordPress core, Plugins and Themes may be
     * practising this, we should strive to set a better example in our own work.
     */


     $(document).ready(function(){

        var textarea_data = '';
        //Multistep js.

        jQuery(".rtwwcfm_prev_btn").on('click',function(e){
            e.preventDefault();
            var rtwwcfm_prev_tab = jQuery(this).data('pre');
            var rtwwcfm_Object = jQuery(this).parent().parent().parent();
            rtwwcfm_get_preview_data(rtwwcfm_Object,"rtwwcfm_prev");
            var rtwwcfm_Obj = jQuery(this).parent().parent().parent().parent().parent();
            var rtwwcfm_positions = '';
            var rtwwcfm_cnt = 0;
            var rtwwcfp_style_type = jQuery(document).find('.rtwwcfm_wrap').data('type');
            jQuery(document).find('.wpcf7-response-output').hide();
            jQuery(document).find('#rtwwcfp_preview_data').html('');
            rtwwcfm_Obj.find('.rtwwcfm-steps'+rtwwcfm_prev_tab).addClass('active');
            rtwwcfm_Obj.find('.rtwwcfm-tab-'+rtwwcfm_prev_tab).show();
            var rtwwcfm_nxt_step = rtwwcfm_prev_tab+1;
            rtwwcfm_Obj.find('.rtwwcfm-steps'+rtwwcfm_nxt_step).removeClass('active');
            rtwwcfm_Obj.find('.rtwwcfm-tab-'+rtwwcfm_nxt_step).hide();
            rtwwcfm_Obj.find('.rtwwcfm_step_by_step-item').each(function(){
                if(jQuery(this).hasClass('active') && rtwwcfm_cnt == 0)
                {
                    rtwwcfm_cnt++;
                    rtwwcfm_positions = jQuery(this).position(); 
                }
            });
            jQuery('.rtwwcfm_step_by_step_move').css("left",  rtwwcfm_positions.left);
            if ( rtwwcfp_style_type == 4 ) 
            {
                rtwwcfm_Obj.find(".rtwwcfm_tab_"+(rtwwcfm_prev_tab)).removeClass('rtwwcfm_active_number');
                rtwwcfm_Obj.find(".rtwwcfm_tab_"+(rtwwcfm_prev_tab)).addClass('rtwwcfm_active_number');
                rtwwcfm_Obj.find(".rtwwcfm_tab_"+(rtwwcfm_prev_tab)).removeClass('rtwwcfm_completed_action'); 
                rtwwcfm_Obj.find("#rtwwcfm_tab_"+(rtwwcfm_prev_tab)).show();
                rtwwcfm_Obj.find(".rtwwcfm_tab_icon_"+(rtwwcfm_prev_tab)).hide();
            }
            if ( rtwwcfp_style_type == 5 ) 
            {
                rtwwcfm_Obj.find(".rtwwcfm-steps"+rtwwcfm_prev_tab).addClass('rtwwcfm_tem5_active');
                rtwwcfm_Obj.find(".rtwwcfm-steps"+(rtwwcfm_prev_tab+1)).removeClass('rtwwcfm_tem5_active');
            }
            if ( rtwwcfp_style_type == 6 ) 
            {
                rtwwcfm_Obj.find(".rtwwcfm_tab_"+(rtwwcfm_prev_tab)).removeClass('rtwwcfm_active_number');
                rtwwcfm_Obj.find(".rtwwcfm_tab_"+(rtwwcfm_prev_tab)).addClass('rtwwcfm_active_number');
                rtwwcfm_Obj.find(".rtwwcfm_tab_"+(rtwwcfm_prev_tab)).removeClass('rtwwcfm_completed_action'); 
                rtwwcfm_Obj.find("#rtwwcfm_tab_"+(rtwwcfm_prev_tab)).show();
                rtwwcfm_Obj.find(".rtwwcfm_tab_icon_"+(rtwwcfm_prev_tab)).hide();
            }
        });
            
        var rtwwcfm_type = $(document).find('.rtwwcfm_main_div').attr('data-type');

        jQuery(".rtwwcfm_next_btn").on('click',function(e){
            e.preventDefault();
            var rtwwcfm_Obj = jQuery(this).parent().parent().parent();
            jQuery(document).find('#rtwwcfp_preview_data').html('');
            var rtwwcfm_Object = jQuery(this).parent().parent().parent().parent().parent();
            var rtwwcfm_curr_div = jQuery(this);
            var rtwwcfm_nxt_div = rtwwcfm_curr_div.data("next");
            var rtwwcfm_prev_div = rtwwcfm_nxt_div.split("-");
            var rtwwcfp_style_type = '';
            var rtwwcfm_count = '';
            var rtwwcfm_positions = '';
            var rtwwcfm_error = false;
            var rtwwcfp_style_type = jQuery(document).find('.rtwwcfm_wrap').data('type');
            if ( rtwwcfm_Obj ) 
            {
                if(jQuery(this).hasClass("rtwwcfm_nxt_button")){
                    jQuery(document).find('.notifyjs-bootstrap-rtwwcfm_text_notify').css("padding", '10px');
                }
                else{
                    jQuery(document).find('.notifyjs-bootstrap-rtwwcfm_text_notify').css("width", '370px');
                }

                rtwwcfm_Obj.find('input.wpcf7-text[type="text"]').each(function(){
                    var rtwwcfm_text_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_text_label = jQuery(this).parent().parent().text();
                    var rtwwcfm_text = jQuery(this).val();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_text+'"></p>');
                    if ( rtwwcfm_text_req == 'true' ) 
                    {
                        if (rtwwcfm_text == '') 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-base.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;         
                        }
                    }                    
                });
                rtwwcfm_Obj.find('input.wpcf7-text.wpcf7-email[type="email"]').each(function(){
                    var rtwwcfm_email_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_email = jQuery(this).val();
                    var rtwwcfm_email_label = jQuery(this).parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_email_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_email+'"></p>' );
                    if ( rtwwcfm_email_req == 'true' ) 
                    {
                        if (rtwwcfm_email == '' || rtwwcfm_IsEmail(rtwwcfm_email) == false) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                    }                    
                });
                rtwwcfm_Obj.find('input.wpcf7-number[type="number"]').each(function(){
                    var rtwwcfm_num_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_num = parseInt(jQuery(this).val());
                    var rtwwcfm_min = parseInt(jQuery(this).attr('min'));
                    var rtwwcfm_max = parseInt(jQuery(this).attr('max'));
                    var rtwwcfm_num_label = jQuery(this).parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_num_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_num+'"></p>');
                    if ( rtwwcfm_num_req == 'true' ) 
                    {
                        if ( rtwwcfm_num == '' ) 
                        {                       
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                        if ( rtwwcfm_max ) 
                        {
                            if ( rtwwcfm_num > rtwwcfm_max ) 
                            {
                                rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                                rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                                rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                                rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                                rtwwcfm_error = true;
                                return false;
                            }
                        }
                        if ( rtwwcfm_min ) 
                        {
                            if ( rtwwcfm_num < rtwwcfm_min ) 
                            {
                                rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                                rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                                rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                                rtwwcfm_error = true;
                                return false;
                            }
                        }
                    }
                });
                rtwwcfm_Obj.find('input.wpcf7-date[type="date"]').each(function(){
                    var rtwwcfm_date_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_date = jQuery(this).val();
                    var rtwwcfm_min_date = jQuery(this).attr('min');
                    var max_datemax_date = jQuery(this).attr('max');
                    var rtwwcfm_date_label = jQuery(this).parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_date_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_date+'"></p>');
                    if ( rtwwcfm_date_req == 'true' ) 
                    {
                        if ( rtwwcfm_date == '' ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                        if ( rtwwcfm_min_date ) 
                        {
                            if ( rtwwcfm_date < rtwwcfm_min_date ) 
                            {
                                rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                                rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                                rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                                rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                                rtwwcfm_error = true;
                                return false;
                            }
                        }
                        if ( max_datemax_date ) 
                        {
                            if ( rtwwcfm_date > max_datemax_date ) 
                            {
                                rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                                rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                                rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                                rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                                rtwwcfm_error = true;
                                return false;
                            }
                        }
                    }
                });
                rtwwcfm_Obj.find('input.wpcf7-text.wpcf7-url[type="url"]').each(function(){
                    var rtwwcfm_url_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_url = jQuery(this).val();
                    var rtwwcfm_url_label = jQuery(this).parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_url_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_url+'"></p>');
                    if ( rtwwcfm_url_req == 'true' ) 
                    {
                        if ( rtwwcfm_url == '' ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                        if ( !rtwwcfm_isValidUrl(rtwwcfm_url) ) 
                        {
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find('.rtwwcfm_next_note').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"left"});
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                    }
                });
                rtwwcfm_Obj.find('input.wpcf7-text.wpcf7-tel[type="tel"]').each(function(){
                    var rtwwcfm_tel_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_phone = jQuery(this).val();
                    var rtwwcfm_tel_label = jQuery(this).parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_tel_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_phone+'"></p>');
                    if ( rtwwcfm_tel_req == 'true' ) 
                    {
                        if ( rtwwcfm_phone == '' ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                        if ( !rtwwcfm_valid_tel_number(rtwwcfm_phone) ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                    }
                });
                rtwwcfm_Obj.find('select.wpcf7-select').each(function(){
                    var rtwwcfm_select_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_select_multipl = jQuery(this).attr('multiple');
                    var rtwwcfm_select = jQuery(this).val();
                    // var rtwwcfm_select_label = jQuery(this).parent().parent().html();
                    // rtwwcfm_select_label = rtwwcfm_select_label.substring(rtwwcfm_select_label.indexOf("<label>") + 1, rtwwcfm_select_label.lastIndexOf("<span"));
                    // rtwwcfm_select_label = rtwwcfm_select_label.replace(/<br>/g, "");
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_select_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_select+'"></p>');
                    if ( rtwwcfm_select_req == 'true' ) 
                    {
                        if ( rtwwcfm_select == '' ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                        if ( rtwwcfm_select_multipl == 'multiple' ) 
                        {
                            if ( rtwwcfm_select.length === 0 ) 
                            {
                                rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                                rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                                rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                                rtwwcfm_error = true;
                                return false;
                            }
                        }
                    }
                });
                rtwwcfm_Obj.find('textarea.wpcf7-textarea').each(function(){
                    var rtwwcfm_textarea_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_textarea = jQuery(this).val();
                    var rtwwcfm_text_label = jQuery(this).parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_textarea+'"></p>');
                    if ( rtwwcfm_textarea_req == 'true' ) 
                    {
                        if( rtwwcfm_textarea == '' )
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                    }
                });

                rtwwcfm_Obj.find('.wpcf7-form-control.wpcf7-quiz').each(function(){
                    var rtwwcfm_textarea_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_Quiz_val = jQuery(this).val();
                    var rtwwcfm_quiz_label = jQuery(this).parent().parent().parent().text();
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_quiz_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_Quiz_val+'"></p>');
                    if ( rtwwcfm_textarea_req == 'true' ) 
                    {
                        if( rtwwcfm_Quiz_val == '' )
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                    }
                });

                rtwwcfm_Obj.find('.wpcf7-form-control.wpcf7-radio').each(function(){
                    var rtwwcfm_radio_label = jQuery(this).parent().parent().html();
                    rtwwcfm_radio_label = rtwwcfm_radio_label.substring(0 , rtwwcfm_radio_label.indexOf("<br>"));
                    var rtwwcfm_ckecked = false;
                    var radio_val = ''
                    jQuery(this).find('input[type="radio"]').each(function(){
                        if ( jQuery(this).prop('checked')==true ) 
                        {
                            var rtwwcfm_radio_val = jQuery(this).val();
                            radio_val = radio_val.concat(rtwwcfm_radio_val + " ");
                           rtwwcfm_ckecked = true;
                        }
                    });
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_radio_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+radio_val+'"></p>' );
                    if ( rtwwcfm_ckecked == false ) 
                    {
                        rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                        rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                        rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                        rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                        rtwwcfm_error = true;
                        return false;
                    }
                });

                rtwwcfm_Obj.find('.wpcf7-form-control.wpcf7-checkbox').each(function(){
                    var textarea_val = ''
                    var rtwwcfm_checkbox_label = "";
                    if ( jQuery(this).hasClass('wpcf7-exclusive-checkbox') ) 
                    {
                        var check_val = ''
                        var rtwwcfm_checkbox_val = '';
                        var rtwwcfm_ckecked = false;
                        var rtwwcfm_checkboxe_label = jQuery(this).parent().parent().html();
                            rtwwcfm_checkboxe_label = rtwwcfm_checkboxe_label.substring(0 , rtwwcfm_checkboxe_label.indexOf("<br>"));
                        jQuery(this).find('input[type="checkbox"]').each(function(){
                            if ( jQuery(this).prop('checked')==true ) 
                            {
                                var check_value = jQuery(this).val();
                                check_val = check_val.concat(check_value + " ");
                            }
                            rtwwcfm_ckecked = true;
                        });
                        //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkboxe_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+check_val+'"></p>' );
                    }
                    else
                    {
                        rtwwcfm_checkbox_label = jQuery(this).parent().parent().html();
                        rtwwcfm_checkbox_label = rtwwcfm_checkbox_label.substring(0 , rtwwcfm_checkbox_label.indexOf("<br>"));
                        jQuery(this).find('input[type="checkbox"]').each(function(){
                            if ( jQuery(this).prop('checked')==true ) 
                            {
                                rtwwcfm_checkbox_val = jQuery(this).val();
                                textarea_val = textarea_val.concat(rtwwcfm_checkbox_val + " ");
                               rtwwcfm_ckecked = true;
                            }
                           
                        });
                        //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkbox_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+textarea_val+'"></p>' );
                    }
                    
                    if ( rtwwcfm_ckecked == false ) 
                    {
                        rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                        rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                        rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                        rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                        rtwwcfm_error = true;
                        return false;
                    }
                });
                rtwwcfm_Obj.find('input.wpcf7-file[type="file"]').each(function(){
                    var rtwwcfm_file_req = jQuery(this).attr('aria-required');
                    var rtwwcfm_accepted_file = jQuery(this).attr('accept');
                    var rtwwcfm_file = jQuery(this).parent().parent().text();
                    var rtwwcfm_file_val = jQuery(this).val();
                    var str_arr = rtwwcfm_file_val.split('\\');
                    rtwwcfm_file_val = str_arr[str_arr.length-1];
                    //textarea_data = textarea_data.concat('<p><strong style="font-size: 17px; color: red; font-weight: bold; font-style: italic; padding: 5px 5px; width: 20%; display: inline-block;">' + rtwwcfm_file + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_file_val+'"></p>');
                    if ( rtwwcfm_file_req == 'true' ) 
                    {
                        if ( rtwwcfm_file == '' ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                        if ( rtwwcfm_accepted_file.split(',').indexOf('.'+jQuery(this).val().split('.').pop().toLowerCase()) == -1 ) 
                        {
                            rtwwcfm_Object.find('.multistep-nav.rtwwcfm_prcoess_stpes_btns').notify(rtwwcfm_ajax_param.rtwwcfm_err_msg,{'autoHideDelay':1500,className:'rtwwcfm_text_notify',position:"bottom"});
                            rtwwcfm_Object.find('.notifyjs-bootstrap-rtwwcfm_text_notify').prepend('<i class="fa fa-info-circle" aria-hidden="true"></i>');
                            rtwwcfm_Object.find("."+rtwwcfm_nxt_div).hide();
                            rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).show();
                            rtwwcfm_error = true;
                            return false;
                        }
                    }
                });

                if ( rtwwcfm_error == false ) 
                {
                    rtwwcfm_Object.find(".rtwwcfm-steps"+(rtwwcfm_prev_div[2])).addClass('active');
                    rtwwcfm_Object.find("."+rtwwcfm_nxt_div).show();
                    if ( rtwwcfp_style_type == 1 ) {
                        rtwwcfm_Object.find(".rtwwcfm-steps"+(rtwwcfm_prev_div[2]-1)).removeClass( 'active');
                    }
                    rtwwcfm_Object.find(".rtwwcfm-tab-"+(rtwwcfm_prev_div[2]-1)).hide();
                    rtwwcfm_Object.find('.rtwwcfm_step_by_step-item').each(function(){
                        if($(this).hasClass('active') && rtwwcfm_count == 0)
                        {
                            rtwwcfm_count++;
                            rtwwcfm_positions = $(this).position();  
                        }
                    });

                    if(rtwwcfp_style_type == 4)
                    {
                        rtwwcfm_Object.find(".rtwwcfm_tab_"+(rtwwcfm_prev_div[2])).addClass('rtwwcfm_active_number');
                        rtwwcfm_Object.find(".rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).removeClass('rtwwcfm_active_number');
                        rtwwcfm_Object.find(".rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).addClass('rtwwcfm_completed_action');
                        rtwwcfm_Object.find("#rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).hide();
                        rtwwcfm_Object.find(".rtwwcfm_tab_icon_"+(rtwwcfm_prev_div[2]-1)).show();
                    }
                    if(rtwwcfp_style_type == 5)
                    {
                        rtwwcfm_Object.find(".rtwwcfm-steps"+(rtwwcfm_prev_div[2])).addClass('rtwwcfm_tem5_active');
                        rtwwcfm_Object.find(".rtwwcfm-steps"+(rtwwcfm_prev_div[2]-1)).removeClass('rtwwcfm_tem5_active');
                        rtwwcfm_Object.find(".rtwwcfm_temp5_"+(rtwwcfm_prev_div[2]-1)).addClass('rtwwcfm_tab_completed_icon');
                        rtwwcfm_Object.find("#rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).hide();
                        rtwwcfm_Object.find(".rtwwcfm_tab_icon_"+(rtwwcfm_prev_div[2]-1)).show();
                    }

                    if(rtwwcfp_style_type == 6)
                    {
                        rtwwcfm_Object.find(".rtwwcfm_tab_"+(rtwwcfm_prev_div[2])).addClass('rtwwcfm_active_number');
                        rtwwcfm_Object.find(".rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).removeClass('rtwwcfm_active_number');
                        rtwwcfm_Object.find(".rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).addClass('rtwwcfm_completed_action');
                        rtwwcfm_Object.find("#rtwwcfm_tab_"+(rtwwcfm_prev_div[2]-1)).hide();
                        rtwwcfm_Object.find(".rtwwcfm_tab_icon_"+(rtwwcfm_prev_div[2]-1)).show();
                        rtwwcfm_Object.find(".rtwwcfm_temp6_"+(rtwwcfm_prev_div[2]-1)).addClass("rtwwcfm_active_border");
                    }

                    $('.rtwwcfm_step_by_step_move').css("left",  rtwwcfm_positions.left);
                }
            }
            rtwwcfm_get_preview_data(rtwwcfm_Obj,"rtwwcfm_next");
        });

        jQuery('.wpcf7-submit').on('click', function() {
            var rtwwcfm_wpcf7Form = document.querySelector('.wpcf7')
            rtwwcfm_wpcf7Form.addEventListener('wpcf7mailsent', function(rtwwcfm_event) {
                jQuery(document).find(".rtwwcfm_prev").hide();
            }, false);
        });


        jQuery('.rtwwcfm_preview').on('click', function(e) 
        {
            e.preventDefault();
            var rtwwcfm_Obj = jQuery(this).parent().parent().parent();
            rtwwcfm_get_preview_data(rtwwcfm_Obj);
            preview();
        });


    function preview(){
        console.log(rtwwcfm_ajax_param);
        jQuery('#rtwwcfp_preview_data').html('');
        jQuery('#rtwwcfp_preview_data').append(textarea_data);
        jQuery('#rtwwcfp_preview_data').dialog({
            resizable  : true,
            title      : rtwwcfm_ajax_param.rtwwcfm_post_metadata.rtwwcfm_preview_modal_title,
            dialogClass: 'rtwwcfm-dialog',
            maxWidth   : 1000,
            closeText  : "Cancel",
            maxHeight  : 1000,
            width      : rtwwcfm_ajax_param.rtwwcfm_post_metadata.rtwwcfm_preview_modal_width,
            height     : rtwwcfm_ajax_param.rtwwcfm_post_metadata.rtwwcfm_preview_modal_height,
            modal      : true,
            hide:{ 
                effect: "fadeOut", 
                duration: 1000 
            },
            classes:{
                //'ui-dialog': 'rtwwcfm-preview-header',
                "ui-dialog-titlebar": "rtwwcfm-preview-header",
                "ui-dialog-buttonpane":"rtwwcfm_preview_footer",
            },
            buttons: [
            {
                text: "OK",
                icon: "ui-icon-heart",
                class: 'rtwcfm_test',
                click: function() {
                        $( this ).dialog( "close" );
                    }
                }
            ]
        });
    }

    function rtwwcfm_get_preview_data(rtwwcfm_Obj,rtwwcfm_btn)
    {
        if ( rtwwcfm_Obj ) 
        {
            rtwwcfm_Obj.find('input.wpcf7-text[type="text"]').each(function(){
                var rtwwcfm_text_label = jQuery(this).parent().parent().text();
                var rtwwcfm_text = jQuery(this).val();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_text+'"></p>','');
                } else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_text+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_text+'"></p>');
                    } 
                }             
            });
            rtwwcfm_Obj.find('input.wpcf7-text.wpcf7-email[type="email"]').each(function(){
                var rtwwcfm_email = jQuery(this).val();
                var rtwwcfm_email_label = jQuery(this).parent().parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_email_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_email+'"></p>','');   
                } else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_email_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_email+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_email_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_email+'"></p>');
                    }     
                }               
            });
            rtwwcfm_Obj.find('input.wpcf7-number[type="number"]').each(function(){
                var rtwwcfm_num = parseInt(jQuery(this).val());
                var rtwwcfm_num_label = jQuery(this).parent().parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_num_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_num+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_num_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_num+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_num_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_num+'"></p>');
                    }
                }
            });
            rtwwcfm_Obj.find('input.wpcf7-date[type="date"]').each(function(){
                var rtwwcfm_date = jQuery(this).val();
                var rtwwcfm_date_label = jQuery(this).parent().parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_date_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_date+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_date_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_date+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_date_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_date+'"></p>');
                    }
                }
            });
            rtwwcfm_Obj.find('input.wpcf7-text.wpcf7-url[type="url"]').each(function(){
                var rtwwcfm_url = jQuery(this).val();
                var rtwwcfm_url_label = jQuery(this).parent().parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_url_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_url+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_url_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_url+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_url_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_url+'"></p>');
                    }
                }
            });
            rtwwcfm_Obj.find('input.wpcf7-text.wpcf7-tel[type="tel"]').each(function(){
                var rtwwcfm_phone = jQuery(this).val();
                var rtwwcfm_tel_label = jQuery(this).parent().parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_tel_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_phone+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_tel_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_phone+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_tel_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_phone+'"></p>');
                    }   
                }
            });
            rtwwcfm_Obj.find('select.wpcf7-select').each(function(){
                var rtwwcfm_select = jQuery(this).val();
                //var rtwwcfm_select_label = jQuery(this).parent().parent().text();
                var rtwwcfm_select_label = jQuery(this).parent().parent().html();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    rtwwcfm_select_label = rtwwcfm_select_label.substring(rtwwcfm_select_label.indexOf("<label>") + 1, rtwwcfm_select_label.lastIndexOf("<span"));
                    rtwwcfm_select_label = rtwwcfm_select_label.replace(/<br>/g, "");
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_select_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_select+'"></p>','');
                }else{
                    rtwwcfm_select_label = rtwwcfm_select_label.substring(rtwwcfm_select_label.indexOf("<label>") + 1, rtwwcfm_select_label.lastIndexOf("<span"));
                    rtwwcfm_select_label = rtwwcfm_select_label.replace(/<br>/g, "");
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_select_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_select+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_select_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_select+'"></p>');
                    }   
                }
            });
            rtwwcfm_Obj.find('textarea.wpcf7-textarea').each(function(){
                var rtwwcfm_textarea = jQuery(this).val();
                var rtwwcfm_text_label = jQuery(this).parent().parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_textarea+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_textarea+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_text_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_textarea+'"></p>');
                    }   
                }
            });
            rtwwcfm_Obj.find('.wpcf7-form-control.wpcf7-checkbox').each(function(){
                var rtwwcfm_ckecked = false;
                if(jQuery(this).hasClass('wpcf7-exclusive-checkbox'))
                {
                    var check_val = ''
                    var rtwwcfm_checkbox_val = '';
                    var rtwwcfm_ckecked = false;
                    var rtwwcfm_checkboxe_label = jQuery(this).parent().parent().html();
                        rtwwcfm_checkboxe_label = rtwwcfm_checkboxe_label.substring(0 , rtwwcfm_checkboxe_label.indexOf("<br>"));
                    jQuery(this).find('input[type="checkbox"]').each(function(){
                        if ( jQuery(this).prop('checked')==true ) 
                        {
                            var check_value = jQuery(this).val();
                            check_val = check_val.concat(check_value + " ");
                        }
                        rtwwcfm_ckecked = true;
                    });
                    if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                        textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkboxe_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+check_val+'"></p>','');
                    }else{
                        if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkboxe_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+check_val+'"></p>') == -1){
                            textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkboxe_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+check_val+'"></p>');
                        }   
                    }
                }
                else
                {
                    var textarea_val = '';
                    var rtwwcfm_checkbox_label = jQuery(this).parent().parent().html();
                    rtwwcfm_checkbox_label = rtwwcfm_checkbox_label.substring(0 , rtwwcfm_checkbox_label.indexOf("<br>"));
                    jQuery(this).find('input[type="checkbox"]').each(function(){
                        if ( jQuery(this).prop('checked')==true ) 
                        {
                            rtwwcfm_checkbox_val = jQuery(this).val();
                            textarea_val = textarea_val.concat(rtwwcfm_checkbox_val + " ");
                            rtwwcfm_ckecked = true;
                        }
                       
                    });
                    if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                        textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkbox_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+textarea_val+'"></p>','');
                    }else{
                        if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkbox_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+textarea_val+'"></p>') == -1){
                            textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_checkbox_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+textarea_val+'"></p>');
                        }   
                    }
                }
            });

            rtwwcfm_Obj.find('.wpcf7-form-control.wpcf7-radio').each(function(){
                var rtwwcfm_radio_label = jQuery(this).parent().parent().html();
                rtwwcfm_radio_label = rtwwcfm_radio_label.substring(0 , rtwwcfm_radio_label.indexOf("<br>"));
                var rtwwcfm_ckecked = false;
                var radio_val = ''
                jQuery(this).find('input[type="radio"]').each(function(){
                    if ( jQuery(this).prop('checked')==true ) 
                    {
                        var rtwwcfm_radio_val = jQuery(this).val();
                        radio_val = radio_val.concat(rtwwcfm_radio_val + " ");
                       rtwwcfm_ckecked = true;
                    }
                });
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_radio_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+radio_val+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_radio_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+radio_val+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_radio_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+radio_val+'"></p>' );
                    }   
                }
            });

            rtwwcfm_Obj.find('input.wpcf7-file[type="file"]').each(function(){
                var rtwwcfm_file = jQuery(this).parent().parent().text();
                var rtwwcfm_file_val = jQuery(this).val();
                var str_arr = rtwwcfm_file_val.split('\\');
                rtwwcfm_file_val = str_arr[str_arr.length-1];
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_file + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_file_val+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_file + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_file_val+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_file + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_file_val+'"></p>');
                    }   
                }
            });
            rtwwcfm_Obj.find('.wpcf7-form-control.wpcf7-quiz').each(function(){
                var rtwwcfm_Quiz_val = jQuery(this).val();
                var rtwwcfm_quiz_label = jQuery(this).parent().text();
                if ( rtwwcfm_btn === "rtwwcfm_prev" ) {
                    textarea_data = textarea_data.replace('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_quiz_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_Quiz_val+'"></p>','');
                }else{
                    if(textarea_data.indexOf('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_quiz_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_Quiz_val+'"></p>') == -1){
                        textarea_data = textarea_data.concat('<p style="display:flex;"><strong style="font-size: 15px; color: red; font-weight: bold; font-style: italic; padding: 0px 5px; width: 20%; display: inline-block;">' + rtwwcfm_quiz_label + '</strong> : <input type="text" style="border-radius: 5px;margin-left: 24px;width: 10;width: 70%;" readonly="true" value="'+rtwwcfm_Quiz_val+'"></p>');
                    }
                }
            });
        }
        return ;
    }


    });


})( jQuery );

function rtwwcfm_IsEmail(rtwwcfm_user_email) 
{
    var rtwwcfm_email_regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    if(!rtwwcfm_email_regex.test(rtwwcfm_user_email)) 
    {
        return false;
    }else{
        return true;
    }
}

function rtwwcfm_isValidUrl(rtwwcfm_url)
{
    var rtwwcfm_url_regex = /^(http|https|ftp):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/i;
    if(rtwwcfm_url_regex.test(rtwwcfm_url)) 
    {
      return true;
    } 
    else 
    {
      return false;
    }   
}
function rtwwcfm_move_selector(rtwwcfm)
{
    var rtwwcfm_positions = '';
    var rtwwcfm_cnt = 0;
    jQuery(document).find('.rtwwcfm_step_by_step-item').each(function(){
        if(jQuery(this).hasClass('active') && rtwwcfm_cnt == 0)
        {
            rtwwcfm_cnt++;
            rtwwcfm_positions = jQuery(this).position(); 
        }
    });
    jQuery('.rtwwcfm_step_by_step_move').css("left",  rtwwcfm_positions.left);
}

function rtwwcfm_valid_tel_number(rtwwcfm_tel)
{
    var rtwwcfm_tel_regex = /^\s*(?:\+?(\d{1,3}))?[-. (]*(\d{3})[-. )]*(\d{3})[-. ]*(\d{4})(?: *x(\d+))?\s*$/;
    var rtwwcfm_regex = new RegExp(rtwwcfm_tel_regex);
    if(rtwwcfm_regex.test( rtwwcfm_tel )) 
    {
      return true;
    } 
    else 
    {
      return false;
    }   
}