<?php
/**
 * The public-specific functionality of the plugin.
 *
 * @link       www.redefiningtheweb.com
 * @since      1.0.0
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/public
 */
/**
 * The public-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-specific stylesheet and JavaScript.
 *
 * @package    Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 * @subpackage Rtwwcfm_Wordpress_Contact_Form_7_Multistep/public
 * @author     RedefiningTheWeb <developer@redefiningtheweb.com>
 */
class Rtwwcfm_Wordpress_Contact_Form_7_Multistep_Public {
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $rtwwcfm_plugin_name    The ID of this plugin.
	 */
	private $rtwwcfm_plugin_name;
	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $rtwwcfm_version    The current version of this plugin.
	 */
	private $rtwwcfm_version;
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $rtwwcfm_plugin_name       The name of this plugin.
	 * @param      string    $rtwwcfm_version    The version of this plugin.
	 */
	public function __construct( $rtwwcfm_plugin_name, $rtwwcfm_version ) {
		$this->rtwwcfm_plugin_name = $rtwwcfm_plugin_name;
		$this->rtwwcfm_version = $rtwwcfm_version;
		$this->rtwwcfm_err_msg = '';
	}
	/**
	 * Register the stylesheets for the public area.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_enqueue_styles() {
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the rtwwcfm_run() function
		 * defined in Wordpress_Contact_Form_7_Multistep_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wordpress_Contact_Form_7_Multistep_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		global $post;
		wp_enqueue_style( $this->rtwwcfm_plugin_name, plugin_dir_url( __FILE__ ) . 'css/rtwwcfm-wordpress-contact-form-7-multistep-public.css', array(), $this->rtwwcfm_version, 'all' );
		wp_enqueue_style( 'font-awesomes', 'https://use.fontawesome.com/releases/v5.5.0/css/all.css', array(), $this->rtwwcfm_version, false);
		wp_dequeue_style("rtwwcfm-template-third");
		wp_enqueue_style (  'wp-jquery-ui-dialog');
		if ( $post->post_type == 'page' && $post->ID == 235 ) {
			wp_dequeue_style($this->rtwwcfm_plugin_name);
			wp_dequeue_style("rtwwcfm-template-third");
			wp_enqueue_style( "rtwwcfm-template-six",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-six.css', array(), $this->rtwwcfm_version, false );
		}else if ( $post->post_type == 'page' &&  $post->ID == 226 ) {
			wp_dequeue_style($this->rtwwcfm_plugin_name);
			wp_dequeue_style("rtwwcfm-template-third");
			wp_enqueue_style( "rtwwcfm-template-fourth",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-fourth.css', array(), $this->rtwwcfm_version, false );
		}else if ( $post->post_type == 'page' &&  $post->ID == 231 ) {
			wp_dequeue_style($this->rtwwcfm_plugin_name);
			wp_dequeue_style("rtwwcfm-template-third");
			wp_enqueue_style( "rtwwcfm-template-five",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-five.css', array(), $this->rtwwcfm_version, false );
		}
	}
	/**
	 * Register the JavaScript for the public area.
	 *
	 * @since    1.0.0
	 */
	public function rtwwcfm_enqueue_scripts() {
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the rtwwcfm_run() function
		 * defined in Wordpress_Contact_Form_7_Multistep_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wordpress_Contact_Form_7_Multistep_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_script( $this->rtwwcfm_plugin_name, plugin_dir_url( __FILE__ ) . 'js/rtwwcfm-wordpress-contact-form-7-multistep-public.js', array( 'jquery','jquery-ui-dialog' ), $this->rtwwcfm_version, false );
		wp_enqueue_script( 'notify-js', plugin_dir_url( __FILE__ ) . 'js/notify.min.js', array( 'jquery' ), $this->rtwwcfm_version, false );
	}
	/**
	 * This function render the multistep form.
	 */
	public function rtwwcfm_render_multistep_form($rtwwcfm_value, $rtwwcfm_post_id, $rtwwcfm_meta_key, $single, $rtwwcfm_meta_type)
	{
		if ( !is_admin() ) 
		{
			if ( $rtwwcfm_meta_key == '_form' ) 
			{
				$rtwwcfm_enbl_mstistp = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_enable_multstp', true );
				if ( $rtwwcfm_enbl_mstistp ) 
				{
					$rtwwcfm_post_metadata = array();
					$rtwwcfm_mltisteps = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_step_name_val', true );
					if ( $rtwwcfm_mltisteps ) 
					{
						$rtwwcfm_mltstp_msg = get_post_meta( $rtwwcfm_post_id, '_messages' );
						if(isset($rtwwcfm_mltstp_msg[0]['validation_error']) && $rtwwcfm_mltstp_msg[0]['validation_error'] != ''){
							$this->rtwwcfm_err_msg = $rtwwcfm_mltstp_msg[0]['validation_error'];
						}
						$count_tab = count($rtwwcfm_mltisteps);
						$rtwwcfm_post_metadata['rtwwcfm_nxt_btn_color'] = get_post_meta( $rtwwcfm_post_id,"rtwwcfm_nxt_btn_color",true);
						$rtwwcfm_post_metadata['rtwwcfm_nxt_btn_txt'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_nxt_btn_txt', true );
						$rtwwcfm_post_metadata['rtwwcfm_previous_btn_txt'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_nxt_prvs_txt', true );
						if ( $rtwwcfm_post_metadata['rtwwcfm_nxt_btn_txt'] == '' ) {
							$rtwwcfm_post_metadata['rtwwcfm_nxt_btn_txt'] = esc_html__('Next', 'rtwwcfm-wordpress-contact-form-7-multistep');
						}
						$rtwwcfm_post_metadata['rtwwcfm_previous_btn_color'] = get_post_meta( $rtwwcfm_post_id,"rtwwcfm_previous_btn_color",true);
						if ( $rtwwcfm_post_metadata['rtwwcfm_previous_btn_txt'] == '' ) {
							$rtwwcfm_post_metadata['rtwwcfm_previous_btn_txt'] = esc_html__('Previous', 'rtwwcfm-wordpress-contact-form-7-multistep');
						}
						$rtwwcfm_post_metadata['rtwwcfm_active_btn_color'] = get_post_meta( $rtwwcfm_post_id,"rtwwcfm_active_btn_color",true);
						$rtwwcfm_post_metadata['rtwwcfm_strip_color'] = get_post_meta( $rtwwcfm_post_id,"rtwwcfm_strip_color",true);
						$rtwwcfm_post_metadata['rtwwcfm_modal_height'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_modal_height', true );
						$rtwwcfm_post_metadata['rtwwcfm_modal_width'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_modal_width', true );

						$rtwwcfm_post_metadata['rtwwcfm_preview_modal_height'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_preview_modal_height', true );
					    $rtwwcfm_post_metadata['rtwwcfm_preview_modal_width'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_preview_modal_width', true );
					    $rtwwcfm_post_metadata['rtwwcfm_preview_modal_close_efect'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_preview_modal_close_efect', true );
					    $rtwwcfm_post_metadata['rtwwcfm_preview_modal_title'] = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_preview_modal_title', true );
						$mltistep_type = get_post_meta( $rtwwcfm_post_id,"rtwwcfm_multstp_type",true);
						if ( !$mltistep_type ) {
							$mltistep_type = 1;
						}
						wp_enqueue_script( "rtwwcfm-template", plugin_dir_url( __FILE__ ) . 'js/rtwwcfm-template.js', array( 'jquery', 'jquery-ui-accordion' ), $this->rtwwcfm_version, true);
						$rtwwcfm_ajax_nonce = wp_create_nonce( "rtwwcfm-ajax-security-string" );
						$rtwwcfm_translation_array 	= array(
													'rtwwcfm_ajaxurl' 	=> esc_url( admin_url( 'admin-ajax.php' ) ),
													'rtwwcfm_nonce' 	=> $rtwwcfm_ajax_nonce,
													'rtwwcfm_post_metadata'   => $rtwwcfm_post_metadata,
													'rtwwcfm_err_msg'   => esc_html__($this->rtwwcfm_err_msg,'rtwwcfm-wordpress-contact-form-7-multistep'),
													'total_steps'       => $count_tab
												);
						wp_localize_script( "rtwwcfm-template", 'rtwwcfm_ajax_param', $rtwwcfm_translation_array );
						if ( $mltistep_type ) 
						{
							if ( $mltistep_type == 1 ) 
							{
								$style_first_div = 'rtwwcfm_wrap rtwwcfm_step_by_step';
								$style_second_div = 'rtwwcfm_step_by_step-nav';
								$style_li = 'rtwwcfm_step_by_step-item';
								$style_nxt_btn = 'rtwwcfm_next_btn';
								$style_prev_btn = 'rtwwcfm_prev_btn';
								$style_btn_div = 'rtwwcfm_next';
								wp_dequeue_style("rtwwcfm-template-six");
								wp_dequeue_style("rtwwcfm-template-five");
								wp_dequeue_style("rtwwcfm-template-fourth");
								wp_dequeue_style("rtwwcfm-template-third");
								wp_dequeue_style("rtwwcfm-template-second");
								wp_enqueue_style( "rtwwcfm-template-first",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-first.css', array(), $this->rtwwcfm_version, false );
							}
							else if ( $mltistep_type == 2 ) 
							{
								$style_nxt_btn = 'rtwwcfm_next_btn';
								$style_prev_btn = 'rtwwcfm_prev_btn';
								$style_btn_div = 'rtwwcfm_next';
								$style_first_div = 'rtwwcfm_wrap rtwwcfm_prcoess_main_wrap';
								$style_second_div = 'rtwwcfm-progress-tracker';
								$style_li = 'rtwwcfm-progress-item';
								wp_dequeue_style("rtwwcfm-template-six");
								wp_dequeue_style("rtwwcfm-template-five");
								wp_dequeue_style("rtwwcfm-template-fourth");
								wp_dequeue_style("rtwwcfm-template-third");
								wp_dequeue_style("rtwwcfm-template-first");
								wp_enqueue_style( "rtwwcfm-template-second",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-second.css', array(), $this->rtwwcfm_version, false );
							}
							else if ( $mltistep_type == 3 ) 
							{
								$style_nxt_btn = 'rtwwcfm_next_btn';
								$style_prev_btn = 'rtwwcfm_prev_btn';
								$style_btn_div = 'rtwwcfm_next';
								$style_first_div  = 'rtwwcfm_wrap rtwwcfm_appointment_main__wrapper';
								$style_second_div = 'rtwwcfm_appointment_tracker';
								$style_li         = 'rtwwcfm_appointment_tracker_item';
								wp_dequeue_style("rtwwcfm-template-fourth");
								wp_dequeue_style("rtwwcfm-template-six");
								wp_dequeue_style("rtwwcfm-template-five");
								wp_dequeue_style("rtwwcfm-template-second");
								wp_dequeue_style("rtwwcfm-template-first");
								wp_enqueue_style( "rtwwcfm-template-third",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-third.css', array(), $this->rtwwcfm_version, false );
								wp_dequeue_style("rtwwcfm-template-fourth");
								wp_dequeue_style("rtwwcfm-template-six");
							}
							else if ( $mltistep_type == 4) 
							{
								$style_nxt_btn = 'rtwwcfm_next_btn';
								$style_prev_btn = 'rtwwcfm_prev_btn';
								$style_btn_div = 'rtwwcfm_next';
								$style_first_div  = 'rtwwcfm_wrap rtwwcfm_appointment_main__wrapper';
								$style_second_div = 'rtwwcfm_appointment_tracker';
								$style_li         = 'rtwwcfm_appointment_tracker_item';
								wp_dequeue_style($this->rtwwcfm_plugin_name);
								wp_dequeue_style("rtwwcfm-template-six");
								wp_dequeue_style("rtwwcfm-template-five");
								wp_dequeue_style("rtwwcfm-template-third");
								wp_dequeue_style("rtwwcfm-template-second");
								wp_dequeue_style("rtwwcfm-template-first");
								wp_enqueue_style( "rtwwcfm-template-fourth",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-fourth.css', array(), $this->rtwwcfm_version, false );
							}
							else if ( $mltistep_type == 5) 
							{
								$style_nxt_btn = 'rtwwcfm_next_btn';
								$style_prev_btn = 'rtwwcfm_prev_btn';
								$style_btn_div = 'rtwwcfm_next';
								$style_first_div  = 'rtwwcfm_wrap rtwwcfm_appointment_main__wrapper';
								$style_second_div = 'rtwwcfm_appointment_tracker';
								$style_li         = 'rtwwcfm_appointment_tracker_item';
								wp_dequeue_style($this->rtwwcfm_plugin_name);
								wp_dequeue_style($this->rtwwcfm_plugin_name);
								wp_dequeue_style("rtwwcfm-template-six");
								wp_dequeue_style("rtwwcfm-template-fourth");
								wp_dequeue_style("rtwwcfm-template-third");
								wp_dequeue_style("rtwwcfm-template-second");
								wp_dequeue_style("rtwwcfm-template-first");
								wp_enqueue_style( "rtwwcfm-template-five",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-five.css', array(), $this->rtwwcfm_version, false );
							}
							else if ( $mltistep_type == 6) 
							{
								$style_nxt_btn = 'rtwwcfm_next_btn';
								$style_prev_btn = 'rtwwcfm_prev_btn';
								$style_btn_div = 'rtwwcfm_next';
								$style_first_div  = 'rtwwcfm_wrap rtwwcfm_appointment_main__wrapper';
								$style_second_div = 'rtwwcfm_appointment_tracker';
								$style_li         = 'rtwwcfm_appointment_tracker_item';
								wp_dequeue_style($this->rtwwcfm_plugin_name);
								wp_dequeue_style($this->rtwwcfm_plugin_name);
								wp_dequeue_style($this->rtwwcfm_plugin_name);
								wp_dequeue_style("rtwwcfm-template-five");
								wp_dequeue_style("rtwwcfm-template-third");
								wp_dequeue_style("rtwwcfm-template-second");
								wp_dequeue_style("rtwwcfm-template-first");
								wp_enqueue_style( "rtwwcfm-template-fourth",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-fourth.css', array(), $this->rtwwcfm_version, false );
								wp_enqueue_style( "rtwwcfm-template-six",  plugin_dir_url( __FILE__ ) . 'partials/rtwwcfm-template-six.css', array(), $this->rtwwcfm_version, false );
							}
							ob_start();
							?>
		                    <div class="rtwwcfm_main_div <?php echo esc_attr($style_first_div); ?>" data-type="<?php echo esc_attr($mltistep_type); ?>">
		                    	<div class="<?php echo esc_attr($style_second_div); ?>">
		                    		<ul class="rtwwcfm_tab_list_wrapper">
		                    			<?php  
		                    				$count = 1;
		                    				foreach ($rtwwcfm_mltisteps as $k => $v) 
		                    				{ ?>
		                    					<li class="rtwwcfm_tab_list <?php if( $count== 1){echo "rtwwcfm_previous  active";} ?> <?php if($mltistep_type == 5 && $count == 1) { echo "rtwwcfm_tem5_active"; } ?> rtwwcfm-steps<?php echo esc_attr($count); ?> <?php  echo esc_attr($style_li); ?>"  data-tab=".rtwwcfm-tab-<?php echo esc_attr($count); ?>">
		                    						<?php if($mltistep_type == 1 || $mltistep_type == 2 || $mltistep_type == 3){ ?>
		                    						<span><?php esc_html_e($k,'rtwwcfm-wordpress-contact-form-7-multistep'); ?></span>
		                    					<?php }
		                    					else if( $mltistep_type == 5){ ?>
		                    							<div class="rtwwcfm_tab_item_inner">
													<div class="rtwwcfm_temp5_<?php echo $count; ?> rtwwcfm_tab_number_wrapper <?php if( $count== 1){echo "rtwwcfm_active_number";} ?>">
														<div class="rtwwcfm_tab_number">
															<?php echo ($count); ?>
														</div>
														<div class="rtwwcfm_tab_icon">
															<i class="fas fa-check"></i>
														</div>
													</div>
													<div class="rtwwcfm_tab_text">
														<?php esc_html_e($k,'rtwwcfm-wordpress-contact-form-7-multistep'); ?>
													</div>
												</div>
		                    					<?php  }
		                    					else{ ?>
	                    						<div class="rtwwcfm_temp6_<?php echo $count; ?> rtwwcfm_tab_item <?php if($mltistep_type == 6){ echo "rtwwcfm_temp6_item"; }?>">
		                    							<div class="rtwwcfm_tab_<?php echo esc_attr($count); ?> <?php if($mltistep_type == 4){ echo "rtwwcfm_tab_number";
														}else if($mltistep_type == 6){ echo "rtwwcfm_tab_number rtwwcfm_temp6_number"; }?> <?php if( $count== 1){echo "rtwwcfm_active_number";} ?>">
		                    								<div class="rtwwcfm_tab_number_text" id="rtwwcfm_tab_<?php echo $count; ?>"><?php echo $count; ?></div>
				                    						<div class="rtwwcfm_tab_icon rtwwcfm_tab_icon_<?php echo $count; ?>" data-step="<?php echo $count; ?>">
									                            <i class="fas fa-check"></i>
									                        </div>
									                    </div>
		                    						<div><?php esc_html_e($k,'rtwwcfm-wordpress-contact-form-7-multistep'); ?></div>
		                    					</div>
		                    				<?php	} ?>
		                    					</li>
		                    		    <?php $count++; }
		                    			?>
		                    		</ul>
		                    		<?php if( $mltistep_type != 4 ){ ?>
		                    		<div class="rtwwcfm_step_by_step_move" style="width: 20%;"></div>
		                    	<?php } ?>
		                    	</div>
		                    	<div class="rtwwcfm_multistep_content_wrapper">
		                    		<?php
		                    			$count = 1;
		                    			foreach ($rtwwcfm_mltisteps as $step_k => $step_v) 
		                    			{ ?>
		                    				<div class="<?php if( $count!= 1){ echo "rtwwcfm_hidden";} ?> rtwwcfm-tab-<?php echo esc_attr($count); ?>" >
		                    					<div class="cf7-content-tab">
				                                    <?php
				                                     echo $step_v ;  // This variable contains HTML
				                                     ?>
				                                </div>
				                                <div class="multistep-nav rtwwcfm_prcoess_stpes_btns">
				                                	<div class="<?php echo esc_attr($style_btn_div); ?> rtwwcfm_prev multistep-nav-left">
				                                        <?php  if( $count!=1 ){ ?>
				                                         <a href="#" class="<?php echo esc_attr($style_prev_btn); ?> rtwwcfm_prev_btn" data-pre="<?php echo ($count-1); ?>"><?php esc_html_e($rtwwcfm_post_metadata['rtwwcfm_previous_btn_txt'],'rtwwcfm-wordpress-contact-form-7-multistep');  ?>
				                                         </a>
				                                        <?php } ?>
				                                    </div>
				                                    <div class="rtwwcfm_next_note multistep-nav-right rtwwcfp_next <?php echo esc_attr($style_btn_div); ?>">
				                                        <?php if( $count_tab != $count ): ?>
				                                        <a href="#" class="<?php if($mltistep_type == 3 && $count != 1) { echo "rtwwcfm_nxt_button"; } ?> rtwcpig_red <?php echo esc_attr($style_nxt_btn); ?>" data-next="rtwwcfm-tab-<?php echo ($count+1); ?>" data-prev="rtwwcfm-tab-<?php echo ($count-1); ?>"><?php esc_html_e($rtwwcfm_post_metadata['rtwwcfm_nxt_btn_txt'],'rtwwcfm-wordpress-contact-form-7-multistep'); ?> </a>
				                                        <?php endif; ?>
				                                        <?php
				                                        $rtwwcfm_enable_preview = get_post_meta( $rtwwcfm_post_id, 'rtwwcfm_enbl_preview', true );
				                                        	if( $count_tab == $count && $rtwwcfm_enable_preview)
				                                        	{ ?>
				                                        		<a href="#" class="rtwwcfm_preview"><?php esc_html_e('Preview','rtwwcfm-wordpress-contact-form-7-multistep'); ?> </a>
				                                        <?php	}
				                                        ?>
				                                    </div>
				                                </div>
		                    				</div>
		                    	  <?php $count++; }
		                    		?>
		                    	</div>
		                    </div>
		                    <div id="rtwwcfp_preview_data" class="rtwwcfm_preview_modal" title="Preview Form Data" style="display:none;"></div>
		                    <?php
		                    $rtwwcfm_value = ob_get_clean();
						}
					}
				}
			}
		}
		return $rtwwcfm_value;
	}
}