<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              www.redefiningtheweb.com
 * @since             1.0.0
 * @package           Rtwwcfm_Wordpress_Contact_Form_7_Multistep
 *
 * @wordpress-plugin
 * Plugin Name:       WordPress Contact Form 7 Multistep
 * Plugin URI:        www.redefiningtheweb.com
 * Description:       This plugin helps you to convert your contact forms into multistep froms.
 * Version:           1.3.1
 * Author:            RedefiningTheWeb
 * Author URI:        www.redefiningtheweb.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       rtwwcfm-wordpress-contact-form-7-multistep
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'RTWWCFM_WORDPRESS_CONTACT_FORM_7_MULTISTEP_VERSION', '1.3.1' );


/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/rtwwcfm-class-wordpress-contact-form-7-multistep.php';


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function rtwwcfm_check_run_allows() 
{
	$rtwwcfm_cf7_status = true;
	if( function_exists('is_multisite') && is_multisite() )
	{
		include_once(ABSPATH. 'wp-admin/includes/plugin.php');
		if( !is_plugin_active('contact-form-7/wp-contact-form-7.php') )
		{
			$rtwwcfm_cf7_status = false;
		}
	}
	else
	{
		if( !in_array('contact-form-7/wp-contact-form-7.php', apply_filters('active_plugins', get_option('active_plugins') ) ) )
		{
			$rtwwcfm_cf7_status = false;
		}
	}
	return $rtwwcfm_cf7_status;
}

if ( rtwwcfm_check_run_allows() ) {
	
	//Plugin Constant
	if ( !defined( 'RTWWCFM_DIR' ) ) {
		define('RTWWCFM_DIR', plugin_dir_path( __FILE__ ) );
	}
	if ( !defined( 'RTWWCFM_URL' ) ) {
		define('RTWWCFM_URL', plugin_dir_url( __FILE__ ) );
	}
	if ( !defined( 'RTWWCFM_HOME' ) ) {
		define('RTWWCFM_HOME', home_url() );
	}


	/**
	* Begins execution of the plugin.
	*
	* Since everything within the plugin is registered via hooks,
	* then kicking off the plugin from this point in the file does
	* not affect the page life cycle.
	*
	* @since 1.0.0
	*/
	function rtwwcfm_run_wordpress_contact_form_7_multistep() 
	{
		$plugin = new Rtwwcfm_Wordpress_Contact_Form_7_Multistep();
		$plugin->rtwwcfm_run();
	}
	rtwwcfm_run_wordpress_contact_form_7_multistep();

}else{

	/**
	* Show plugin error notice.
	*
	* @since 1.0.0
	*/
	function rtwwcfm_error_notice()
	{
		?>
			<div class="error notice is-dismissible">
				<p><?php esc_html_e( 'Contact Form 7 plugin is not activated, Please activate Contact Form 7 plugin first to install WordPress Contact Form 7 Multistep.', 'rtwwcfm-wordpress-contact-form-7-multistep' ); ?>
				</p>
			</div>
			<style type="text/css">
			#message
			{
				display: none;
			}
			</style>
		<?php
	}


	/**
	* Deactivate Plugin if contact form 7 not active
	* @since 1.0.0
	*/
	function rtwwcfm_deactivate_wordpress_contact_form_7_multistep()
	{
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		deactivate_plugins( plugin_basename( __FILE__ ) );
		add_action('admin_notices', 'rtwwcfm_error_notice');
	}
	add_action( 'admin_init', 'rtwwcfm_deactivate_wordpress_contact_form_7_multistep' );

}
