<?php
/**
 * Name field of the comparison table.
 *
 * @package Codeinwp\Sparks\Modules\Comparison_Table\Fields;
 */
namespace Codeinwp\Sparks\Modules\Comparison_Table\Fields;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Field that provides show stock availability in comparison table functionality.
 */
class Stock_Availability extends Abstract_Field {
	/**
	 * Set label
	 */
	public function set_label() {
		$this->label = esc_html__( 'Stock Availability', 'sparks-for-woocommerce' );
	}

	/**
	 * Get field value of the product.
	 *
	 * @param  \WC_Product $product is product instance.
	 * @return void
	 */
	public function render( \WC_Product $product ) {
		if ( $product->is_on_backorder() ) {
			$status = __( 'On backorder', 'sparks-for-woocommerce' );
		} elseif ( $product->is_in_stock() ) {
			$status = __( 'In stock', 'sparks-for-woocommerce' );
		} else {
			$status = __( 'Out of stock', 'sparks-for-woocommerce' );
		}

		echo esc_attr( $status );
	}
}
