<div class="panel-body clearfix margin_top_20px rtl_margin_0px padding_top_15px_res">
	<?php
	$attendance=mj_smgt_attedance_advance_report();
	$class_name=mj_smgt_get_all_class_array();
	$class_name_list = array_map(function ($s) {
		return trim($s->class_name); // Trim each class name
	}, $class_name);
	?>
  <script type="text/javascript">
    jQuery(document).ready(function($) 
    {
        var class_name = <?php echo json_encode($class_name_list); ?>;
        // Function to build dynamic filter based on class_name, payment_status, and late_time_value
        function buildClassFilter(class_name) {
            
            var new_class = '';
            var new_class = class_name + ' ';
            return {
                logic: 'AND',
                criteria: [
                    {
                        data: 'Class Name', // Match the Class Name column in the table
                        condition: '=',
                        value: [new_class]
                    },
                    {
                        data: 'Attendance %', // Match the Payment Status column in the table
                        condition: '>',
                        value: ['50']
                    }
                ]
            };
        }
        // Define filters for each class dynamically based on the class names
        var classFilters = class_name.map(function(class_item) {
            return buildClassFilter(class_item);
        });

        var table = $('#advance_attendance_report').DataTable({
            responsive: true,
            "order": [
                [1, "asc"]
            ],
            "dom": 'QlBfrtip',
            searchBuilder: {
                preDefined: {
                    // Predefined filter criteria for class-wise filters
                    criteria: classFilters, // Apply all the class filters
                    logic: 'OR'
                }
            },
            buttons: [{
                    extend: 'csv',
                    text: '<?php echo esc_attr__("CSV", "school-mgt"); ?>',
                    title: '<?php echo esc_attr__("Attedance Report", "school-mgt"); ?>',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
                {
                    extend: 'print',
                    text: '<?php echo esc_attr__("PRINT", "school-mgt"); ?>',
                    title: '<?php echo esc_attr__("Attedance Report", "school-mgt"); ?>',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                }
            ],
            "aoColumns": [{
                    "bSortable": false
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true,
                    'width': '180px'
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                }
            ],
            language: <?php echo mj_smgt_datatable_multi_language(); ?>
        });

        $('.btn-place').html(table.buttons().container());
        $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
    });
</script>
    <div class="panel-body margin_top_20px rtl_margin_0px padding_top_15px_res">
		<?php
        if(!empty($attendance))
        {
        ?>
			<div class="table-responsive">
				<div class="btn-place"></div>
				<form id="frm-example" name="frm-example" method="post">
					<table id="advance_attendance_report" class="display" cellspacing="0" width="100%">
						<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
							<tr>
								<th><?php  _e( 'Image', 'school-mgt' ) ;?></th>
								<th><?php esc_attr_e('Student Name','school-mgt');?></th>
								<th><?php esc_attr_e('Class Name','school-mgt');?></th>
								<th><?php esc_attr_e('Section Name','school-mgt');?></th>
								<th><?php esc_attr_e('Working Days','school-mgt');?></th>
								<th><?php esc_attr_e('Present','school-mgt');?></th>
								<th><?php esc_attr_e('Attendance %','school-mgt');?></th>
							</tr>
						</thead>
						<tbody>
							<?php
							if(!empty($attendance))
							{
								
								$i=0;
								foreach($attendance as $attendance_data)
								{
									$class_name='N/A';
									$section_name='N/A';
									if (!empty($attendance_data->class_id))
									{
										$class_name=mj_smgt_get_class_name_by_id($attendance_data->class_id);
									}
									if (!empty($attendance_data->section_id))
									{
										$section_name=mj_smgt_get_section_name($attendance_data->section_id);
									}
									?>
                                     <td class="user_image width_50px">
                                        <a href="?page=smgt_student&tab=view_student&action=view_student&student_id=<?php echo MJ_smgt_encrypt_id($attendance_data->user_id);?>&_wpnonce=<?php echo MJ_smgt_get_nonce('view_action');?>" class="" >
                                            <?php
                                                $umetadata=mj_smgt_get_user_image($attendance_data->user_id);
                                                if(empty($umetadata))
                                                {
                                                    echo '<img src='.get_option( 'smgt_student_thumb_new' ).' class="img-circle" />';
                                                }
                                                else
                                                {
                                                    echo '<img src='.$umetadata.' class="img-circle" />';
                                                }
                                            ?>
                                    </a>
									</td>
									<td><?php echo mj_smgt_student_display_name_with_roll($attendance_data->user_id);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Student Name','school-mgt');?>"></i></td>
									<td><?php echo $class_name; ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Class Name','school-mgt');?>"></i></td>
									<td><?php echo $section_name; ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Section Name','school-mgt');?>"></i></td>
									<td><?php echo $attendance_data->total_working_days; ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Total Working Days','school-mgt');?>"></i></td>
									<td><?php echo $attendance_data->total_present; ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Total Present','school-mgt');?>"></i></td>
									<td><?php echo $attendance_data->attendance_percentage; ?> % <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Attendance %','school-mgt');?>"></i></td>
									<?php
									echo '</tr>';
									$i++;
								}
							}
							?>
						</tbody>        
					</table>
				</form>
			</div>
			<?php
        } 
        else
        {
            ?>
            <div class="calendar-event-new"> 
                <img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
            </div>	
            <?php
        }  ?>
    </div>
</div>