<?php
$obj_marks = new Marks_Manage();
$class_id = isset($_REQUEST['class_id']) ? $_REQUEST['class_id'] : '';
$section_id = isset($_REQUEST['class_section']) ? $_REQUEST['class_section'] : '';
$exam_id = isset($_REQUEST['exam_id']) ? $_REQUEST['exam_id'] : '';
?>
<div class="panel-body margin_top_20px rtl_margin_0px padding_top_15px_res">
    <form method="post" id="fee_payment_report">
        <div class="form-body user_form">
            <div class="row">
                <!-- Class Selection -->
                <div class="col-md-3 input">
                    <label class="ml-1 custom-top-label top"><?php esc_html_e('Select Class', 'school-mgt'); ?><span class="require-field">*</span></label>
                    <select name="class_id" id="class_list" class="line_height_30px form-control class_id_exam validate[required]">
                        <option value=""><?php esc_attr_e('Select Class Name', 'school-mgt'); ?></option>
                        <?php foreach (mj_smgt_get_allclass() as $classdata): ?>
                            <option value="<?php echo $classdata['class_id']; ?>" <?php selected($classdata['class_id'], $class_id); ?>><?php echo $classdata['class_name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Section Selection -->
                <div class="col-md-3 input">
                    <label class="ml-1 custom-top-label top"><?php esc_html_e('Select Section', 'school-mgt'); ?></label>
                    <select name="class_section" class="line_height_30px section_id_exam form-control" id="class_section">
                        <option value=""><?php esc_attr_e('All Section', 'school-mgt'); ?></option>
                        <?php
                        if (!empty($class_id)):
                            foreach (mj_smgt_get_class_sections($class_id) as $sectiondata):
                        ?>
                                <option value="<?php echo $sectiondata->id; ?>" <?php selected($section_id, $sectiondata->id); ?>><?php echo $sectiondata->section_name; ?></option>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </select>
                </div>

                <!-- Exam Selection -->
                <div class="col-md-3 input">
                    <label class="ml-1 custom-top-label top"><?php esc_html_e('Select Exam', 'school-mgt'); ?><span class="require-field">*</span></label>
                    <select name="exam_id" class="line_height_30px form-control exam_list validate[required]">
                        <option value=""><?php esc_attr_e('Select Exam Name', 'school-mgt'); ?></option>
                        <?php foreach (mj_smgt_get_all_data("exam") as $exam): ?>
                            <option value="<?php echo $exam->exam_id; ?>" <?php selected($exam->exam_id, $exam_id); ?>><?php echo $exam->exam_name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-3">
                    <input type="submit" name="report_5" value="<?php esc_attr_e('Go', 'school-mgt'); ?>" class="btn btn-info save_btn" />
                </div>

            </div>
        </div>
    </form>
</div>

<?php
 if (isset($_POST['report_5']) && !empty($class_id) && !empty($exam_id)) 
{ 
$subject_list = $obj_marks->mj_smgt_student_subject(intval($class_id), $section_id);
$subjectnameList = array_map(function ($s) {
    return $s->sub_name;
}, $subject_list);

$exlude_id = mj_smgt_approve_student_list();
$args = array(
    'meta_query' => array(array('key' => 'class_name', 'value' => intval($class_id))),
    'role'       => 'student',
    'exclude'    => $exlude_id
);
if (!empty($section_id)) {
    $args['meta_query'][] = array('key' => 'class_section', 'value' => $section_id);
}
$student = get_users($args);
if (!empty($student)):
?>
    <script type="text/javascript">
        var subjects = <?php echo json_encode($subjectnameList); ?>;

        function buildSubjectPercentageAndResultFilter(subject, result = 'F', percentageCondition = '<', percentageValue = 50) {
            return {
                logic: 'AND',
                criteria: [{
                        data: subject + ' %',
                        condition: percentageCondition,
                        value: [String(percentageValue)]
                    },
                    {
                        data: subject + ' R',
                        condition: '=',
                        value: [String(result)]
                    }
                ]
            };
        }
        const failedSubjectFilters = subjects.map(subject =>
            buildSubjectPercentageAndResultFilter(subject)
        );
        jQuery(document).ready(function($) {
            var table = jQuery('#example5').DataTable({
                //stateSave: true,
                "responsive": false,
                "order": [
                    [1, "Desc"]
                ],
                "dom": 'Qlfrtip',
                searchBuilder: {
                    preDefined: {
                        logic: 'AND',
                        criteria: [
                            ...failedSubjectFilters,
                            {
                                condition: '=',
                                data: 'Result', 
                                value: ['Fail'],
                                origData: 'Result'
                            }
                        ]
                    }
                },
                buttons: [
                    {
                        extend: 'csv',
                        text: '<?php echo esc_attr_e("csv","school-mgt"); ?>',
                        title: '<?php echo esc_attr_e("Exam Result Report","school-mgt"); ?>',
                    },
                    {
                        extend: 'print',
                        text: '<?php echo esc_attr_e("Print","school-mgt"); ?>',
                        title: '<?php echo esc_attr_e("Exam Result Report","school-mgt"); ?>',
                    }
                ],
                "aoColumns": [{
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    <?php
                    if (!empty($subject_list)) {
                        foreach ($subject_list as $sub_id) {
                    ?> {
                                "bSortable": true
                            },
                            {
                                "bSortable": true
                            },
                            {
                                "bSortable": true
                            },
                    <?php
                        }
                    }
                    ?> {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    }
                ],
                language: <?php echo mj_smgt_datatable_multi_language(); ?>
            });
            $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
            $('.btn-place').html(table.buttons().container());
        });
    </script>

    <div class="clearfix panel-body margin_top_20px rtl_margin_0px padding_top_15px_res">
    <div class="admission-report my-3">
    <?php foreach ($subjectnameList as $subject) { ?>
        <div class="badge-container d-inline-flex flex-wrap align-items-center mb-2">
            <span class="report-label"><?php printf(esc_html__('%s Subject Less Than', 'school-mgt'), esc_html($subject)); ?></span>
            <span class="status-text"><?php esc_html_e('50% Mark &', 'school-mgt'); ?></span>
            <span class="report-label"><?php esc_html_e('Result', 'school-mgt'); ?></span>
            <span class="status-text"><?php esc_html_e('Fail', 'school-mgt'); ?></span>
        </div>
    <?php } ?>
    <div class="badge-container d-inline-flex flex-wrap align-items-center mb-2">
        <span class="report-label"><?php esc_html_e('Result Is', 'school-mgt'); ?></span>
        <span class="status-text"><?php esc_html_e('Fail', 'school-mgt'); ?></span>
    </div>
</div>

    <div class="table-responsive">
            <table id="example5" class="display responsive nowrap" cellspacing="0" width="100%">
                <thead class="<?php echo MJ_smgt_datatable_heder(); ?>">
                    <tr>
                        <th><?php esc_attr_e('Roll No.', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Student Name', 'school-mgt'); ?></th>
                        <?php foreach ($subject_list as $sub):
                            /* $short_name = substr($sub->sub_name, 0, 3); */
                            $short_name = $sub->sub_name; ?>
                            <th><?php echo $short_name ?></th>
                            <th><?php echo $short_name; ?> %</th>
                            <th><?php echo $short_name; ?> <?php esc_attr_e('R', 'school-mgt'); ?></th>
                        <?php endforeach; ?>
                        <th><?php esc_attr_e('Total', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Result', 'school-mgt'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($student as $user):
                        $total = 0;
                        $pass_status = true;
                    ?>
                        <tr>
                            <td><?php echo $user->roll_id; ?></td>
                            <td><?php echo mj_smgt_get_user_name_byid($user->ID); ?></td>

                            <?php foreach ($subject_list as $sub):
                                $mark_detail = $obj_marks->mj_smgt_subject_makrs_detail_byuser($exam_id, $class_id, $sub->subid, $user->ID);
                                $marks = 0;
                                $max_marks = $obj_marks->mj_smgt_get_max_marks($exam_id); // Same max for all subjects
                                $pass_mark = $obj_marks->mj_smgt_get_pass_marks($exam_id);

                                if ($mark_detail) {
                                    $marks = ($mark_detail->contributions == "yes")
                                        ? array_sum(json_decode($mark_detail->class_marks, true))
                                        : (int) $mark_detail->marks;
                                }

                                $percentage = ($max_marks > 0) ? round(($marks / $max_marks) * 100, 2) : 0;
                                $subject_pass = ($marks >= $pass_mark);
                                $result_text = $subject_pass ? esc_attr__('P', 'school-mgt') : esc_attr__('F', 'school-mgt');
                                $result_color = $subject_pass ? 'green' : 'red';

                                if (!$subject_pass) $pass_status = false;
                                $total += $marks;
                            ?>
                                <td><?php echo $marks; ?></td>
                                <td><?php echo $percentage; ?>%</td>
                                <td><span style="color:<?php echo $result_color; ?>; font-weight:bold;"><?php echo $result_text; ?></span></td>
                            <?php endforeach; ?>

                            <td><?php echo $total; ?></td>
                            <?php
                            $final_result_text = $pass_status ? esc_attr__('Pass', 'school-mgt') : esc_attr__('Fail', 'school-mgt');
                            $final_result_color = $pass_status ? 'green' : 'red';
                            ?>
                            <td><span style="color:<?php echo $final_result_color; ?>; font-weight:bold;"><?php echo $final_result_text; ?></span></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>

            </table>
        </div>
    </div>
<?php
endif;
}
?>