<?php
$active_tab = isset($_GET['tab2']) ? $_GET['tab2'] : 'fees_payment_datatable';
$role = mj_smgt_get_roles(get_current_user_id());
$class_name=mj_smgt_get_all_class_array();
$class_name_list = array_map(function ($s) {
    return trim($s->class_name); // Trim each class name
}, $class_name);
?>
<?php
if ($active_tab == "fees_payment_datatable") {
?>
    <div class="clearfix"> </div>
    <?php
    $result_feereport = mj_smgt_get_payment_report_front_all_advance();
    if (!empty($result_feereport)) {
    ?>
<script type="text/javascript">
    jQuery(document).ready(function($) 
    {
        var class_name = <?php echo json_encode($class_name_list); ?>;
        // Function to build dynamic filter based on class_name, payment_status, and late_time_value
        function buildClassFilter(class_name, payment_status = 'Not Paid ', late_time_value = '1 month(s) late') {
            
            var new_class = '';
            var new_class = class_name + ' ';
            return {
                logic: 'AND',
                criteria: [
                    {
                        data: 'Class Name', // Match the Class Name column in the table
                        condition: '=',
                        value: [new_class]
                    },
                    {
                        data: 'Payment Status', // Match the Payment Status column in the table
                        condition: '=',
                        value: [payment_status]
                    },
                    {
                        data: 'Late Time', // Match the Late Time column in the table
                        condition: 'contains',
                        value: [late_time_value]
                    }
                ]
            };
        }
        // Define filters for each class dynamically based on the class names
        var classFilters = class_name.map(function(class_item) {
            return buildClassFilter(class_item);
        });

        var table = $('.example4').DataTable({
            responsive: true,
            "order": [
                [1, "asc"]
            ],
            "dom": 'QlBfrtip',
            searchBuilder: {
                preDefined: {
                    // Predefined filter criteria for class-wise filters
                    criteria: classFilters, // Apply all the class filters
                    logic: 'OR'
                }
            },
            buttons: [{
                    extend: 'csv',
                    text: '<?php echo esc_attr__("CSV", "school-mgt"); ?>',
                    title: '<?php echo esc_attr__("Fees Payment Report", "school-mgt"); ?>',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                },
                {
                    extend: 'print',
                    text: '<?php echo esc_attr__("PRINT", "school-mgt"); ?>',
                    title: '<?php echo esc_attr__("Fees Payment Report", "school-mgt"); ?>',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7]
                    }
                }
            ],
            "aoColumns": [{
                    "bSortable": false
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true,
                    'width': '180px'
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                },
                {
                    "bSortable": true
                }
            ],
            language: <?php echo mj_smgt_datatable_multi_language(); ?>
        });

        $('.btn-place').html(table.buttons().container());
        $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
    });
</script>


        <div class="table-responsive">
            <div class="btn-place"></div>
            <table class="display example4" cellspacing="0" width="100%">
                <thead class="<?php echo MJ_smgt_datatable_heder() ?>">
                    <tr>
                        <th><?php _e('Image', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Fees Term', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Student Name', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Class Name', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Payment Status', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Total Amount', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Due Amount', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Start To End Year', 'school-mgt'); ?></th>
                        <th class="late-time-col"><?php esc_attr_e('Late Time', 'school-mgt'); ?></th>
                        <th><?php esc_attr_e('Action', 'school-mgt'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 0;
                    foreach ($result_feereport as $retrieved_data) {
                        $color_class = 'smgt_class_color' . ($i % 10);
                    ?>
                        <tr>
                            <td class="user_image width_50px profile_image_prescription padding_left_0">
                                <p class="prescription_tag padding_15px margin_bottom_0px <?php echo $color_class; ?>">
                                    <img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Icons/White_icons/Payment.png" ?>"
                                        alt="" class="massage_image center margin_top_3px">
                                </p>
                            </td>
                            <?php
                            $fees_type = array_map('mj_smgt_get_fees_term_name', explode(',', $retrieved_data->fees_id));
                            ?>
                            <td><?php echo implode(", ", $fees_type); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Fees Term', 'school-mgt'); ?>"></i></td>
                            <td><?php echo mj_smgt_student_display_name_with_roll($retrieved_data->student_id); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Student Name', 'school-mgt'); ?>"></i></td>
                            <td><?php echo $retrieved_data->class_id == "0" ? esc_html__('All Class', 'school-mgt') : smgt_get_class_section_name_wise($retrieved_data->class_id, $retrieved_data->section_id); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Class Name', 'school-mgt'); ?>"></i></td>
                            <td>
                                <?php
                                $payment_status = mj_smgt_get_payment_status($retrieved_data->fees_pay_id);
                                if ($payment_status == 'Not Paid') {
                                    echo "<span class='red_color'>";
                                } elseif ($payment_status == 'Partially Paid') {
                                    echo "<span class='perpal_color'>";
                                } else {
                                    echo "<span class='green_color'>";
                                }
                                echo esc_html__("$payment_status", "school-mgt");
                                echo "</span>";
                                ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip"
                                    title="<?php esc_html_e('Payment Status', 'school-mgt'); ?>"></i>
                            </td>
                            <td><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($retrieved_data->total_amount, 2)); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Total Amount', 'school-mgt'); ?>"></i></td>
                            <td><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($retrieved_data->total_amount - $retrieved_data->fees_paid_amount, 2)); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Due Amount', 'school-mgt'); ?>"></i></td>
                            <td><?php echo $retrieved_data->start_year . '-' . $retrieved_data->end_year; ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Start To End Year', 'school-mgt'); ?>"></i></td>
                            <td>
                                <?php
                                $end_year = isset($retrieved_data->end_year) ? $retrieved_data->end_year : '';
                                $paid_amount = $retrieved_data->fees_paid_amount;
                                $total_amount = $retrieved_data->total_amount;

                                // Default CSS class for the payment status
                                $status_class = 'status-on-time';  // Default class for "On-Time Payment"
                                $status_text = esc_html__('On-Time Payment', 'school-mgt');  // Default text

                                if (!empty($end_year) && $paid_amount < $total_amount) {
                                    $today = date('Y-m-d');
                                    $due_date = strtotime($end_year);
                                    $current_date = strtotime($today);
                                    $diff_in_days = ($current_date - $due_date) / (60 * 60 * 24);

                                    // Calculate the difference in months, quarters, and years
                                    $diff_in_months = floor($diff_in_days / 30);
                                    $diff_in_quarters = floor($diff_in_days / 90);  // Approximation: 90 days per quarter
                                    $diff_in_years = floor($diff_in_days / 365);    // Approximation: 365 days per year

                                    if ($diff_in_years > 0) {
                                        $status_class = 'status-late';  // Set class for late payment
                                        $status_text = "$diff_in_years " . esc_html__('year(s) late', 'school-mgt');
                                    } elseif ($diff_in_quarters > 0) {
                                        $status_class = 'status-late';  // Set class for late payment
                                        $status_text = "$diff_in_quarters " . esc_html__('quarter(s) late', 'school-mgt');
                                    } elseif ($diff_in_months > 0) {
                                        $status_class = 'status-late';  // Set class for late payment
                                        $status_text = "$diff_in_months " . esc_html__('month(s) late', 'school-mgt');
                                    } else {
                                        $status_class = 'status-due-soon';  // Set class for "Due Soon"
                                        $status_text = esc_html__('Due Soon', 'school-mgt');
                                    }
                                }

                                // Output the payment status with dynamic CSS class and text
                                echo "<span class='$status_class'>$status_text</span>";
                                ?>
                                <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Late Time', 'school-mgt'); ?>"></i>
                            </td>


                            <td class="action">
                                <div class="smgt-user-dropdown">
                                    <ul class="" style="margin-bottom: 0px !important;">
                                        <li class="">
                                            <a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
                                                <img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png"; ?>">
                                            </a>
                                            <ul class="dropdown-menu heder-dropdown-menu action_dropdawn">
                                                <li class="float_left_width_100">
                                                    <a href="<?php echo $role == 'administrator' ? '?page=smgt_fees_payment&tab=view_fesspayment' : '?dashboard=user&page=feepayment&tab=view_fesspayment'; ?>&idtest=<?php echo MJ_smgt_encrypt_id($retrieved_data->fees_pay_id); ?>&view_type=view_payment" class="float_left_width_100">
                                                        <i class="fa fa-eye"></i><?php esc_attr_e('View', 'school-mgt'); ?>
                                                    </a>
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    <?php $i++;
                    } ?>
                </tbody>
            </table>
        </div>
    <?php
    } else {
    ?>
        <div class="calendar-event-new">
            <img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
        </div>
<?php
    }
}
?>