<div class="panel-body clearfix margin_top_20px rtl_margin_0px padding_top_15px_res">
    <?php
    $obj_leave = new SmgtLeave;
    $leave_data = mj_smgt_get_leave_data_advance_report();
    $class_name = mj_smgt_get_all_class_array();
    $class_name_list = array_map(function ($s) {
        return trim($s->class_name); // Trim each class name
    }, $class_name);
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            var class_name = <?php echo json_encode($class_name_list); ?>;

            function buildClassFilter(class_name) {

                var new_class = '';
                var new_class = class_name + ' ';
                return {
                    logic: 'AND',
                    criteria: [{
                            data: 'Class Name', // Match the Class Name column in the table
                            condition: '=',
                            value: [new_class]
                        },
                        {
                            data: 'Status', // Match the Payment Status column in the table
                            condition: '=',
                            value: [' Not Approved  ']
                        }
                    ]
                };
            }
            var classFilters = class_name.map(function(class_item) {
                return buildClassFilter(class_item);
            });
            var table = $('#leave_list_advance_report').DataTable({
                responsive: true,
                "order": [
                    [1, "asc"]
                ],
                "dom": 'QlBfrtip',
                searchBuilder: {
                    preDefined: {
                        // Predefined filter criteria for class-wise filters
                        criteria: classFilters, // Apply all the class filters
                        logic: 'OR'
                    }
                },
                buttons: [{
                        extend: 'csv',
                        text: '<?php echo esc_attr__("CSV", "school-mgt"); ?>',
                        title: '<?php echo esc_attr__("Leave Report", "school-mgt"); ?>',
                        exportOptions: {
                            columns: [1, 2, 3, 4, 5, 6, 7,8]
                        }
                    },
                    {
                        extend: 'print',
                        text: '<?php echo esc_attr__("PRINT", "school-mgt"); ?>',
                        title: '<?php echo esc_attr__("Leave Report", "school-mgt"); ?>',
                        exportOptions: {
                            columns: [1, 2, 3, 4, 5, 6, 7,8]
                        }
                    }
                ],
                "aoColumns": [{
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true,
                        'width': '180px'
                    },
                    {
                        "bSortable": true
                    }, ,
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    }
                ],
                language: <?php echo mj_smgt_datatable_multi_language(); ?>
            });

            $('.btn-place').html(table.buttons().container());
            $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
        });
    </script>
    <div class="panel-body margin_top_20px rtl_margin_0px padding_top_15px_res">
        <?php
        if (!empty($leave_data)) {
        ?>
            <div class="table-responsive"><!-- table-responsive -->
                <div class="btn-place"></div>
                <form id="frm-example" name="frm-example" method="post">
                    <table id="leave_list_advance_report" class="display admin_transport_datatable" cellspacing="0" width="100%">
                        <thead class="<?php echo MJ_smgt_datatable_heder() ?>">
                            <tr>
                                <th><?php _e('Image', 'school-mgt'); ?></th>
                                <th><?php _e('Student Name', 'school-mgt'); ?></th>
                                <th><?php _e('Class Name', 'school-mgt'); ?></th>
                                <th><?php _e('Leave Type', 'school-mgt'); ?></th>
                                <th><?php _e('Leave Duration', 'school-mgt'); ?></th>
                                <th><?php _e('Start Date', 'school-mgt'); ?></th>
                                <th><?php _e('End Date', 'school-mgt'); ?></th>
                                <th><?php _e('Status', 'school-mgt'); ?></th>
                                <th><?php _e('Reason', 'school-mgt'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 0;
                            foreach ($leave_data as $retrieved_data) {
                                $leave_id = MJ_smgt_encrypt_id($retrieved_data->id);
                            ?>
                                <tr>
                                    <td class="user_image width_50px">
                                        <a href="?page=smgt_student&tab=view_student&action=view_student&student_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->student_id); ?>&_wpnonce=<?php echo MJ_smgt_get_nonce('view_action'); ?>" class="">
                                            <?php
                                            $umetadata = mj_smgt_get_user_image($retrieved_data->student_id);
                                            if (empty($umetadata)) {
                                                echo '<img src=' . get_option('smgt_student_thumb_new') . ' class="img-circle" />';
                                            } else {
                                                echo '<img src=' . $umetadata . ' class="img-circle" />';
                                            }
                                            ?>
                                        </a>
                                    </td>
                                    <td><?php $sname = mj_smgt_student_display_name_with_roll($retrieved_data->student_id);
                                        if ($sname != '') {
                                            echo $sname;
                                        } else {
                                            echo 'N/A';
                                        } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Student Name', 'school-mgt'); ?>"></i></td>

                                    <td class="name">
                                        <?php
                                        $section_id = 0;
                                        $class_id = get_user_meta($retrieved_data->student_id, 'class_name', true);
                                        //$section_id = get_user_meta($retrieved_data->student_id, 'class_section', true);
                                        $classname = smgt_get_class_section_name_wise($class_id, $section_id);
                                        if (!empty($classname)) {
                                            echo $classname;
                                        } else {
                                            echo "N/A";
                                        }
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Class & Section', 'school-mgt'); ?>"></i>
                                    </td>
                                    <td><?php echo get_the_title($retrieved_data->leave_type); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Leave Type', 'school-mgt'); ?>"></i></td>
                                    <td>
                                        <?php
                                        $duration = hrmgt_leave_duration_label($retrieved_data->leave_duration);
                                        echo esc_html__($duration, 'school-mgt');
                                        ?>
                                        <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Leave Duration', 'school-mgt'); ?>"></i>
                                    </td>
                                    <td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->start_date); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Leave Start Date', 'school-mgt'); ?>"></i></td>
                                    <td><?php if (!empty($retrieved_data->end_date)) {
                                            echo mj_smgt_getdate_in_input_box($retrieved_data->end_date);
                                        } else {
                                            echo "N/A";
                                        } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Leave End Date', 'school-mgt'); ?>"></i></td>
                                    <td>
                                        <?php
                                        $status = $retrieved_data->status;
                                        if ($status == "Approved") {
                                            echo "<span class='green_color'> " . esc_html__($status, 'school-mgt') . " </span>";
                                        } else {
                                            echo "<span class='red_color'> " . esc_html__($status, 'school-mgt') . " </span>";
                                        }
                                        // echo $retrieved_data->status;
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php if (!empty($retrieved_data->status_comment)) {
                                                                                                                            echo $retrieved_data->status_comment;
                                                                                                                        } else {
                                                                                                                            esc_html_e('Status', 'school-mgt');
                                                                                                                        } ?>"></i></td>
                                    <td><?php
                                        $comment = $retrieved_data->reason;
                                        $reason = strlen($comment) > 30 ? substr($comment, 0, 30) . "..." : $comment;
                                        echo $reason;
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php if (!empty($comment)) {
                                                                                                                            echo $comment;
                                                                                                                        } else {
                                                                                                                            esc_html_e('Reason', 'school-mgt');
                                                                                                                        } ?>"></i></td>
                                </tr>
                            <?php
                                $i++;
                            }
                            ?>
                        </tbody>
                    </table>
                </form>

            </div><!--------- Table Responsive ------->
        <?php
        }
        ?>
    </div>
</div>