<div class="panel-body clearfix margin_top_20px rtl_margin_0px padding_top_15px_res">
    <?php
    $obj_leave = new SmgtLeave;
    $perfomance_report_data = get_teacher_perfomance_report();
    $class_name = mj_smgt_get_all_class_array();
    $class_name_list = array_map(function ($s) {
        return trim($s->class_name); // Trim each class name
    }, $class_name);
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
        var class_name = <?php echo json_encode($class_name_list); ?>;
            function buildClassFilter(class_name) {

                var new_class = '';
                var new_class = class_name + ' ';
                return {
                    logic: 'AND',
                    criteria: [{
                            data: 'Class Name', // Match the Class Name column in the table
                            condition: '=',
                            value: [new_class]
                        },
                        {
                            data: 'Average Mark', // Match the Payment Status column in the table
                            condition: '>',
                            value: ['80']
                        }
                    ]
                };
            } 
            var classFilters = class_name.map(function(class_item) {
                return buildClassFilter(class_item);
            }); 
            var table = $('#teacher_advance_report').DataTable({
                responsive: true,
                "order": [
                    [1, "asc"]
                ],
                "dom": 'QlBfrtip',
                searchBuilder: {
                    preDefined: {
                        // Predefined filter criteria for class-wise filters
                        criteria: classFilters, // Apply all the class filters
                        logic: 'OR'
                    }
                },
                buttons: [{
                        extend: 'csv',
                        text: '<?php echo esc_attr__("CSV", "school-mgt"); ?>',
                        title: '<?php echo esc_attr__("Leave Report", "school-mgt"); ?>',
                        exportOptions: {
                            columns: [1, 2, 3, 4, 5, 6, 7, 8]
                        }
                    },
                    {
                        extend: 'print',
                        text: '<?php echo esc_attr__("PRINT", "school-mgt"); ?>',
                        title: '<?php echo esc_attr__("Leave Report", "school-mgt"); ?>',
                        exportOptions: {
                            columns: [1, 2, 3, 4, 5, 6, 7, 8]
                        }
                    }
                ], 
                "aoColumns": [{
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    },
                    {
                        "bSortable": true
                    }, ,
                    {
                        "bSortable": true
                    }
                ],
                language: <?php echo mj_smgt_datatable_multi_language(); ?>
            });

            $('.btn-place').html(table.buttons().container());
            $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
        });
    </script>
    <div class="panel-body margin_top_20px rtl_margin_0px padding_top_15px_res">
        <?php
        if (!empty($perfomance_report_data)) {
        ?>
            <div class="table-responsive"><!-- table-responsive -->
                <div class="btn-place"></div>
                <form id="frm-example" name="frm-example" method="post">
                    <table id="teacher_advance_report" class="display admin_transport_datatable" cellspacing="0" width="100%">
                        <thead class="<?php echo MJ_smgt_datatable_heder() ?>">
                            <tr>
                                <th><?php _e('Image', 'school-mgt'); ?></th>
                                <th><?php _e('Teacher Name', 'school-mgt'); ?></th>
                                <th><?php _e('Class Name', 'school-mgt'); ?></th>
                                <th><?php _e('Subject', 'school-mgt'); ?></th>
                                <th><?php _e('Highest Mark', 'school-mgt'); ?></th>
                                <th><?php _e('Lowest Mark', 'school-mgt'); ?></th>
                                <th><?php _e('Average Mark', 'school-mgt'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($perfomance_report_data as $retrieved_data) 
                            {
                            ?>
                                <tr>
                                    <td class="user_image width_50px">
                                        <a href="?page=smgt_teacher&tab=view_teacher&action=view_teacher&teacher_id=<?php echo MJ_smgt_encrypt_id($retrieved_data['teacher_id']); ?>&_wpnonce=<?php echo MJ_smgt_get_nonce('view_action');?>">
                                            <?php 
                                            $uid = $retrieved_data['teacher_id'];
                                            $umetadata = mj_smgt_get_user_image($uid);
                                            if (empty($umetadata)) {
                                                echo '<img src=' . get_option('smgt_teacher_thumb_new') . ' height="50px" width="50px" class="img-circle" />';
                                            } else {
                                                echo '<img src=' . $umetadata . ' height="50px" width="50px" class="img-circle"/>';
                                            }
                                            ?>
                                        </a>
									</td>
                                    <td><?php
                                        echo $retrieved_data['teacher_name'];
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Teacher Name', 'school-mgt'); ?>"></i></td>

                                    <td><?php
                                        echo $retrieved_data['class_name']; 
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Class Name', 'school-mgt'); ?>"></i></td>
                                    <td><?php echo $retrieved_data['subject_name'];
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Subject', 'school-mgt'); ?>"></i></td>

                                    <td><?php echo $retrieved_data['highest_mark'];
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Highest Mark', 'school-mgt'); ?>"></i></td>
                                    <td><?php echo $retrieved_data['lowest_mark'];
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Lowest Mark', 'school-mgt'); ?>"></i></td>
                                    <td><?php echo $retrieved_data['average_mark'];
                                        ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Average Mark', 'school-mgt'); ?>"></i></td>

                                </tr>
                            <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </form>

            </div><!--------- Table Responsive ------->
        <?php
        }
        ?>
    </div>
</div>