	<script type="text/javascript">
		jQuery(document).ready(function($) {
			"use strict";
			$('#setting_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('#app_verification_form').validationEngine({promptPosition : "bottomLeft",maxErrorsPerField: 1});	
		});
	</script>
	<?php


	$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'general_setting';
	$role = mj_smgt_get_user_role(get_current_user_id());
	$role_array = explode(',', $role);
	if (in_array("administrator", $role_array)) {
		$user_access_add = 1;
		$user_access_edit = 1;
		$user_access_delete = 1;
		$user_access_view = 1;
	} else {
		$user_access = mj_smgt_get_userrole_wise_filter_access_right_array('general_settings');
		$user_access_add = $user_access['add'];
		$user_access_edit = $user_access['edit'];
		$user_access_delete = $user_access['delete'];
		$user_access_view = $user_access['view'];
	}
	if (isset($_POST['save_dashboard_setting'])) {


		$dashboard_card_access = array();

		$dashboard_card_access = [
			"smgt_payment_status_chart" => isset($_REQUEST['payment_status_chart_enable_student']) ? esc_attr($_REQUEST['payment_status_chart_enable_student']) : "no",
			"smgt_user_chart" => isset($_REQUEST['user_chart_enable_student']) ? esc_attr($_REQUEST['user_chart_enable_student']) : "no",
			"smgt_invoice_chart" => isset($_REQUEST['invoice_enable']) ? esc_attr($_REQUEST['invoice_enable']) : "no",
		];

		$dashboard_result = update_option('smgt_dashboard_card_for_student', $dashboard_card_access);

		//-------- Card option update for staffmemeber ---------//
		$dashboard_result_1 = get_option("smgt_dashboard_card_for_support_staff");
		$dashboard_card_access_for_staff = array();

		$dashboard_card_access_for_staff = [
			"smgt_student_status_chart" => isset($_REQUEST['student_status_staff']) ? esc_attr($_REQUEST['student_status_staff']) : "no",
			"smgt_attendance_chart" => isset($_REQUEST['attendance_staff']) ? esc_attr($_REQUEST['attendance_staff']) : "no",
			"smgt_payment_status_chart" => isset($_REQUEST['payment_status_staff']) ? esc_attr($_REQUEST['payment_status_staff']) : "no",
			"smgt_payment_report" => isset($_REQUEST['payment_report_staff']) ? esc_attr($_REQUEST['payment_report_staff']) : "no",
			"smgt_invoice_chart" => isset($_REQUEST['invoice_enable_staff']) ? esc_attr($_REQUEST['invoice_enable_staff']) : "no",
			"smgt_user_chart" => isset($_REQUEST['users_chart_staff']) ? esc_attr($_REQUEST['users_chart_staff']) : "no",
		];

		$dashboard_result_1 = update_option('smgt_dashboard_card_for_support_staff', $dashboard_card_access_for_staff);

		//-------- Card option update for teacher ---------//
		$dashboard_result_2 = get_option("smgt_dashboard_card_for_teacher");
		$dashboard_card_access_teacher = array();

		$dashboard_card_access_teacher = [
			"smgt_student_status_chart" => isset($_REQUEST['student_status_enable_teacher']) ? esc_attr($_REQUEST['student_status_enable_teacher']) : "no",
			"smgt_attendance_chart" => isset($_REQUEST['attendance_chart_enable_teacher']) ? esc_attr($_REQUEST['attendance_chart_enable_teacher']) : "no",
			"smgt_user_chart" => isset($_REQUEST['user_chart_enable_teacher']) ? esc_attr($_REQUEST['user_chart_enable_teacher']) : "no",
		];

		$dashboard_result_2 = update_option('smgt_dashboard_card_for_teacher', $dashboard_card_access_teacher);

		//-------- Card option update for parent ---------//
		$dashboard_result_3 = get_option("smgt_dashboard_card_for_parent");
		$dashboard_card_access_parent = array();

		$dashboard_card_access_parent = [
			"smgt_user_chart" => isset($_REQUEST['user_chart_parent']) ? esc_attr($_REQUEST['user_chart_parent']) : "no",
			"smgt_invoice_chart" => isset($_REQUEST['invoice_enable_parent']) ? esc_attr($_REQUEST['invoice_enable_parent']) : "no",
			"smgt_payment_status_chart" => isset($_REQUEST['payment_status_parent']) ? esc_attr($_REQUEST['payment_status_parent']) : "no",
		];

		$dashboard_result_3 = update_option('smgt_dashboard_card_for_parent', $dashboard_card_access_parent);
		if($school_obj->role == 'supportstaff')
		{
			wp_redirect(home_url().'?dashboard=user&page=general_settings&tab=dashboard_card_settings&message=1');
		}
		else
		{
			wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=dashboard_card_settings&message=1');
		}
	}
	if(isset($_POST['save_mobile_app_settings']))		
	{
		$optionval = mj_smgt_update_option();
		foreach ($optionval as $key => $val) 
		{
			if (isset($_POST[$key])) {
				$result = update_option($key, $_POST[$key]);
			}
		}

		if($school_obj->role == 'supportstaff')
		{
			wp_redirect(home_url().'?dashboard=user&page=general_settings&tab=mobile_app_settings&tab1=icon_setting&message=3');
		}
		else
		{
			wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=mobile_app_settings&tab1=icon_setting&message=3');
		}

	}

	if(isset($_POST['varify_app_key']))		
	{
		$verify_result = mj_smgt_submit_setupform_mobileapp($_POST);
		if($verify_result['cmgt_app_verify'] != '0')
		{
			?>
			<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
				<p><?php esc_html_e($verify_result['message'],'school-mgt');?></p>
				<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
		    </div>
			<?php
		}
		else
		{
			?>
			<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
				<p><?php esc_html_e($verify_result['message'],'school-mgt');?></p>
				<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
		    </div>
			<?php
		}
	}
	if (isset($_POST['save_setting'])) 
	{
		$optionval = mj_smgt_update_option();
		foreach ($optionval as $key => $val) 
		{
			if (isset($_POST[$key])) {
				$result = update_option($key, $_POST[$key]);
			}
		}
		if (isset($_REQUEST['smgt_datepicker_format'])) {
			update_option('smgt_datepicker_format', $_REQUEST['smgt_datepicker_format']);
		}

		if (isset($_REQUEST['smgt_system_color_code'])) {
			update_option('smgt_system_color_code', $_REQUEST['smgt_system_color_code']);
		}

		//	UPDATE GENERAL SETTINGS OPTION
		if (isset($_REQUEST['smgt_paymaster_pack'])) {
			update_option('smgt_paymaster_pack', 'yes');
		} else {
			update_option('smgt_paymaster_pack', 'no');
		}

		if (isset($_REQUEST['smgt_enable_recurring_invoices'])) {
			update_option('smgt_enable_recurring_invoices', 'yes');
		} else {
			update_option('smgt_enable_recurring_invoices', 'no');
		}

		
		if (isset($_REQUEST['smgt_system_payment_reminder_enable'])) {
			update_option('smgt_system_payment_reminder_enable', 'yes');
		} else 
		{
			update_option('smgt_system_payment_reminder_enable', 'no');
		}

		//	UPDATE GENERAL SETTINGS OPTION
		if (isset($_REQUEST['smgt_mail_notification'])) {
			update_option('smgt_mail_notification', 1);
		} else {
			update_option('smgt_mail_notification', 0);
		}
		if (isset($_REQUEST['parent_send_message']))
			update_option('parent_send_message', 1);
		else
			update_option('parent_send_message', 0);

		if (isset($_REQUEST['student_send_message']))
			update_option('student_send_message', 1);
		else
			update_option('student_send_message', 0);
		if (isset($_REQUEST['student_approval']))
			update_option('student_approval', 1);
		else
			update_option('student_approval', 0);
		if (isset($_REQUEST['smgt_enable_sandbox']))
			update_option('smgt_enable_sandbox', 'yes');
		else
			update_option('smgt_enable_sandbox', 'no');
		if (isset($_REQUEST['smgt_enable_virtual_classroom'])) 
		{
			update_option('smgt_enable_virtual_classroom', 'yes');
		} 
		else 
		{
			update_option('smgt_enable_virtual_classroom', 'no');
		}

		if (isset($_REQUEST['smgt_enable_video_popup_show'])) 
		{
			update_option('smgt_enable_video_popup_show', 'yes');
		} 
		else 
		{
			update_option('smgt_enable_video_popup_show', 'no');
		}

		if (isset($_REQUEST['smgt_enable_virtual_classroom_reminder'])) 
		{
			update_option('smgt_enable_virtual_classroom_reminder', 'yes');
		} 
		else 
		{
			update_option('smgt_enable_virtual_classroom_reminder', 'no');
		}

		if (isset($_REQUEST['smgt_enable_sms_virtual_classroom_reminder'])) 
		{
			update_option('smgt_enable_sms_virtual_classroom_reminder', 'yes');
		} 
		else 
		{
			update_option('smgt_enable_sms_virtual_classroom_reminder', 'no');
		}

		if (isset($_REQUEST['smgt_teacher_manage_allsubjects_marks'])) 
		{
			update_option('smgt_teacher_manage_allsubjects_marks', 'yes');
		} 
		else 
		{
			update_option('smgt_teacher_manage_allsubjects_marks', 'no');
		}

		if (isset($_REQUEST['smgt_heder_enable'])) {
			update_option('smgt_heder_enable', 'yes');
		} else {
			update_option('smgt_heder_enable', 'no');
		}

		if (isset($_REQUEST['smgt_admission_fees'])) {
			update_option('smgt_admission_fees', 'yes');
		} else {
			update_option('smgt_admission_fees', 'no');
		}

		if (isset($_REQUEST['smgt_return_option'])) 
		{
			update_option('smgt_return_option', 'yes');
		} 
		else 
		{
			update_option('smgt_return_option', 'no');
		}
		if (isset($_REQUEST['smgt_return_period'])) 
		{
			update_option('smgt_return_period', $_REQUEST['smgt_return_period']);
		} 
		
		if (isset($_REQUEST['smgt_registration_fees'])) {
			update_option('smgt_registration_fees', 'yes');
		} else {
			update_option('smgt_registration_fees', 'no');
		}


		//Principal Singnature
		if (isset($_REQUEST['smgt_principal_signature'])) {
			update_option('smgt_principal_signature', $_REQUEST['smgt_principal_signature']);
		}
		//------------ Wizard Setup Option -----------//
		$wizard = smgt_setup_wizard_steps_updates('step1_general_setting');


		//-------- Card option update for Student ---------//
		$dashboard_result = get_option("smgt_dashboard_card_for_student");

		if($school_obj->role == 'supportstaff')
		{
			wp_redirect(home_url().'?dashboard=user&page=general_settings&message=1');
		}
		else
		{
			wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&message=1');
		}
		
	}
	if (isset($_REQUEST['save_document_setting'])) {
		$document_type = implode(", ", $_REQUEST['document_type']);
		$profile_extension = implode(", ", $_REQUEST['profile_extension']);
		$document_size = $_REQUEST['document_size'];
		$profile_size = $_REQUEST['profile_size'];
		update_option('smgt_upload_document_type', $document_type);
		update_option('smgt_upload_profile_extention', $profile_extension);
		update_option('smgt_upload_document_size', $document_size);
		update_option('smgt_upload_profile_size', $profile_size);
		if($school_obj->role == 'supportstaff')
		{
			wp_redirect(home_url().'?dashboard=user&page=general_settings&tab=document_settings&message=2');
		}
		else
		{
			wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=document_settings&message=2');
		}
	?>
		<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
			<p><?php esc_html_e('Document setting updated successfully.', 'school-mgt'); ?></p>
			<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
		</div>
	<?php
	}
	?>
	<div class="popup-bg">
		<div class="overlay-content max_height_overflow">
			<div class="modal-content">
				<div class="result"></div>
				<div class="view-parent"></div>
				<div class="category_list">
				</div>
			</div>
		</div>
	</div>
	<?php
	if($school_obj->role == 'administrator')
	{
		if (get_option('smgt_enable_video_popup_show') == 'yes') {
			?>
				<a href="#" class="view_video_popup youtube-icon" link="<?php echo "https://www.youtube.com/embed/vCxdYKKX9es?si=DUUdlwfucUoScL-N"; ?>" title="General Settings">
					<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/youtube-icon.png" ?>" alt="YouTube">
				</a>
			<?php
		}
	}
	?>

	<div class="page-inner"><!-- page-inner-->
		<div class="main_list_margin_15px"><!-- main_list_margin_15px -->
			<div class="row"><!-- Row -->
				<?php
				$message = isset($_REQUEST['message']) ? $_REQUEST['message'] : '0';
				switch ($message) 
				{
					case '1':
						$message_string = esc_attr__('Settings Updated Successfully.', 'school-mgt');
						break;
					case '2':
						$message_string = esc_attr__('Document setting updated successfully.', 'school-mgt');
						break;
					case '3':
						$message_string = esc_attr__('Mobile App Setting Updated Successfully.', 'school-mgt');
						break;
					case '4':
						$message_string = esc_attr__('Grpup Exam Result Setting Inserted Successfully.', 'school-mgt');
						break;
					case '5':
						$message_string = esc_attr__('Grpup Exam Result Setting Updated Successfully.', 'school-mgt');
						break;
					case '6':
						$message_string = esc_attr__('Grpup Exam Result Setting Deleted Successfully.', 'school-mgt');
						break;
				}

				if ($message) { 
					if($school_obj->role == 'supportstaff')
					{
						?>
						<div id="message" class="alert_msg alert alert-success mt-1 alert-dismissible " role="alert">
							<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></span>
							</button>
							<?php echo $message_string; ?>
						</div>
						<?php
					}
					else
					{
					?>
						<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
							<p><?php echo $message_string; ?></p>
							<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
						</div>
					<?php
					}
					
				} ?>
				<div class="col-md-12 padding_0"><!-- col-md-12 -->
					<div class="panel-body">
						<ul class="nav nav-tabs panel_tabs flex-nowrap margin_left_1per mb-4" role="tablist">
							<?php
							if($school_obj->role == 'supportstaff')
							{
								?>
								<li class="<?php if ($active_tab == 'general_setting') { ?>active<?php } ?>">
									<a href="?dashboard=user&page=general_settings&tab=general_setting" class="padding_left_0 tab <?php echo $active_tab == 'general_setting' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('General Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'document_settings') { ?>active<?php } ?>">
									<a href="?dashboard=user&page=general_settings&tab=document_settings" class="padding_left_0 tab <?php echo $active_tab == 'document_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Document Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'dashboard_card_settings') { ?>active<?php } ?>">
									<a href="?dashboard=user&page=general_settings&tab=dashboard_card_settings" class="padding_left_0 tab <?php echo $active_tab == 'dashboard_card_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Dashboard Card Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'mobile_app_settings') { ?>active<?php } ?>">
									<a href="?dashboard=user&page=general_settings&tab=mobile_app_settings" class="padding_left_0 tab <?php echo $active_tab == 'mobile_app_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Mobile APP Settings', 'school-mgt'); ?></a>
								</li> 
								<li class="<?php if ($active_tab == 'exam_merge_settings') { ?>active<?php } ?>">
									<a href="?dashboard=user&page=general_settings&tab=exam_merge_settings" class="padding_left_0 tab <?php echo $active_tab == 'exam_merge_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Group Exam Result Settings', 'school-mgt'); ?></a>
								</li>
								<?php
							}
							else
							{
								?>
								<li class="<?php if ($active_tab == 'general_setting') { ?>active<?php } ?>">
									<a href="?page=smgt_gnrl_settings&tab=general_setting" class="padding_left_0 tab <?php echo $active_tab == 'general_setting' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('General Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'document_settings') { ?>active<?php } ?>">
									<a href="?page=smgt_gnrl_settings&tab=document_settings" class="padding_left_0 tab <?php echo $active_tab == 'document_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Document Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'dashboard_card_settings') { ?>active<?php } ?>">
									<a href="?page=smgt_gnrl_settings&tab=dashboard_card_settings" class="padding_left_0 tab <?php echo $active_tab == 'dashboard_card_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Dashboard Card Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'mobile_app_settings') { ?>active<?php } ?>">
									<a href="?&page=smgt_gnrl_settings&tab=mobile_app_settings" class="padding_left_0 tab <?php echo $active_tab == 'mobile_app_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Mobile APP Settings', 'school-mgt'); ?></a>
								</li>
								<li class="<?php if ($active_tab == 'exam_merge_settings') { ?>active<?php } ?>">
									<a href="?&page=smgt_gnrl_settings&tab=exam_merge_settings" class="padding_left_0 tab <?php echo $active_tab == 'exam_merge_settings' ? 'nav-tab-active' : ''; ?>">
										<?php echo esc_attr__('Group Exam Result Settings', 'school-mgt'); ?></a>
								</li>
								<?php
							}
							?>
						</ul>
						<?php
						if ($active_tab == 'exam_merge_settings') 
						{
						   $active_tab1 = isset($_GET['tab1'])?$_GET['tab1']:'exam_merge_settings';
						   ?> 
						   <script>
							$(document).ready(function() 
							{
								$(".check_total_per").click(function(e) {
									var totalMark = 100;
									var contributionTotal = 0;

									$("input[name='weightage[]']").each(function() {
										var value = parseFloat($(this).val()) || 0; // Ensures empty values are treated as 0
										contributionTotal += value;
									});

									if (contributionTotal > totalMark) {
										alert("Error: Total weightage must not exceed 100%.");
										e.preventDefault(); // Prevent form submission
									}
								});
							});
						   // ADD MORE CONSRIBUTIONS
						   function add_more_merge_result() 
							{
								var class_name = $("#class_list").val().trim();;
								var section_name = $("#class_section").val();
								 if (class_name !== "") 
								 { 
									var curr_data = {
										action: 'add_more_merge_result',
										class_name: class_name,
										section_name: section_name,
										dataType: 'json',
									};
									$.post(smgt.ajax, curr_data, function(response) 
									{
										$("#merge_settings_div").append(response);
									});
								} 
								else 
								{
									alert('Please select a class.');
								}
							}
							// REMOVE
							function deleteParentElementExamMergeSettings(n) {
							var alert = confirm(language_translate2.delete_record_alert);
							if (alert == true) {
								n.parentNode.parentNode.parentNode.removeChild(n.parentNode.parentNode);
							}
							}
							</script>
						   <div class="col-xl-12 col-md-12 col-sm-12 margin_top_20px margin_top_15px_rs">
								<div class="guardian_div">
									<?php
									$exam_obj=new smgt_exam();
									if (isset($_POST['save_merge_settings'])) 
									{
										$nonce = $_POST['_wpnonce'];
										if (wp_verify_nonce($nonce, 'save_merge_settings')) 
										{
											if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit_merge') 
				                            {
												if (isset($_GET['_wpnonce_action']) && wp_verify_nonce($_GET['_wpnonce_action'], 'edit_action')) 
												{
													$result=$exam_obj->mj_smgt_save_merge_exam_setting($_POST);
													if($result)
													{
														wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=exam_merge_settings&message=5');
												    }
												}
												else 
												{
													wp_die('Security check failed!');
												}
											}
											else
											{
												$result=$exam_obj->mj_smgt_save_merge_exam_setting($_POST);
												if($result)
												{
													wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=exam_merge_settings&message=4');
												}
										    }
									    }
										else 
										{
											wp_die('Security check failed!');
										}
									}
									if(isset($_REQUEST['action']) && ($_REQUEST['action'] == "delete_merge"))
									{
										if (isset($_GET['_wpnonce_action']) && wp_verify_nonce($_GET['_wpnonce_action'], 'delete_action')) 
										{
											$result=$exam_obj->mj_smgt_delete_exam_setting(MJ_smgt_decrypt_id($_REQUEST['merge_id']));
											if($result)
											{
												wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=exam_merge_settings&message=6');
											}
										} 
										else 
										{
											wp_die('Security check failed!');
										}
									}

									if (isset($_REQUEST['delete_selected_exam_setting'])) 
									{
										if (!empty($_REQUEST['merge_id'])) 
										{
											school_append_audit_log('' . esc_html__('Group Exam Merge Setting Deleted', 'school-mgt') . '', get_current_user_id(), get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
											foreach ($_REQUEST['merge_id'] as $id) 
											{
												$result=$exam_obj->mj_smgt_delete_exam_setting($id);
											}
											wp_redirect(admin_url().'admin.php?page=smgt_gnrl_settings&tab=exam_merge_settings&message=6');
										}
									}
									$edit = 0;
									if(isset($_REQUEST['action']) && ($_REQUEST['action'] == "edit_merge"))
									{
										$edit = 1;
										$merge_id=intval(MJ_smgt_decrypt_id($_REQUEST['merge_id']));
										$result = $exam_obj->mj_smgt_get_single_merge_exam_setting($merge_id);
									}
									?>
									<script type="text/javascript">
										jQuery(document).ready(function($) 
										{
											"use strict";
											$('#class_Section_form').validationEngine({promptPosition: "bottomLeft",maxErrorsPerField: 1});
										});
									</script>
									<form name="class_Section_form" action="" method="post" class="form-horizontal" id="class_Section_form">
									<?php $action = isset($_REQUEST['action'])?$_REQUEST['action']:'insert';?>
									<input type="hidden" name="action" value="<?php echo $action;?>">
									<input type="hidden" name="merge_id" value="<?php echo $merge_id;?>">
										<div class="header">	
											<h3 class="first_hed"><?php esc_html_e('Group Exam Result Settings','school-mgt');?></h3>
										</div>
										<div class="form-body user_form">
											<div class="row">
											<div class="col-md-4">
												<div class="form-group input">
													<div class="col-md-12 form-control">
														<input id="subject_code" class="form-control validate[required,custom[address_description_validation]] text-input" type="text" maxlength="100" value="<?php if($edit){ echo $result->merge_name;}?>" name="merge_name">
														<label for="userinput1" class=""><?php esc_html_e('Group Exam Name', 'school-mgt'); ?><span class="required">*</span></label>
													</div>
												</div>
											</div>
											<div class="col-md-4 input">
												<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Select Class','school-mgt');?><span class="require-field">*</span></label>
												<?php 
												$class_id=0;
												if($edit)
												{  
													$class_id=$result->class_id;
												}
												?>
												<select name="class_id"  id="class_list" class="line_height_30px form-control class_id_exam validate[required] text-input">
													<option value=" "><?php esc_attr_e('Select Class Name','school-mgt');?></option>
													<?php foreach(mj_smgt_get_allclass() as $classdata){ ?>
														<option  value="<?php echo $classdata['class_id'];?>" <?php selected($classdata['class_id'],$class_id)?>><?php echo $classdata['class_name'];?></option>
													<?php }?>
												</select>                   
										    </div>
											<div class="col-md-4 input">
											<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Section Name','school-mgt');?></label>
											<?php if($edit){ $sectionval=$result->section_id; }elseif(isset($_POST['class_section'])){$sectionval=$_POST['class_section'];}else{$sectionval='';}?>
											<select name="class_section" class=" line_height_30px form-control width_100 section_id_exam" id="class_section">
												<option value=""><?php esc_attr_e('All Section','school-mgt');?></option>
												<?php
												if($edit)
												{
													foreach(mj_smgt_get_class_sections($result->class_id) as $sectiondata)
													{  ?>
													<option value="<?php echo $sectiondata->id;?>" <?php selected($sectionval,$sectiondata->id);  ?>><?php echo $sectiondata->section_name;?></option>
												<?php 
												}
												}?>
											</select>                             
										</div>
											<?php
											if($edit && !empty($result->merge_config))
											{
													?>
													<div id="merge_settings_div">
														<?php
														$contributions_data = json_decode($result->merge_config);
														foreach($contributions_data as $key=>$value)
														{
															?>
															<div class="form-body user_form">
																<div class="row">
																	<div class="col-md-4 input">
																	<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Select Exam','school-mgt');?><span class="require-field">*</span></label>
																	<select name="exam_id[]" class="line_height_30px form-control exam_list validate[required] text-input">
																	<option value=""><?php esc_attr_e('Select Exam','school-mgt');?></option>
																		<?php
																		if(isset($value->exam_id))
																		{
																			$exam_data=mj_smgt_get_all_exam_by_class_id_all($class_id);
																			if(!empty($exam_data))
																			{
																				foreach ($exam_data as $retrieved_data)
																				{
																				?>
																					<option value="<?php echo $retrieved_data->exam_id;?>" <?php selected($value->exam_id, $retrieved_data->exam_id);  ?>><?php echo $retrieved_data->exam_name;?></option>
																				<?php 
																				}
																			}
																			?>
																			<?php  
																		}
																		else 
																		{
																			?>
																			<option value=""><?php esc_attr_e('Select Exam','school-mgt');?></option>
																			<?php
																		}
																		?>
																	</select>                
																</div>

																<div class="col-md-4 col-10">
																	<div class="form-group input error_msg_left_margin">
																		<div class="col-md-12 form-control">
																			<input class="form-control onlyletter_number_space_validation text-input" type="number" value="<?php echo $value->weightage?>" name="weightage[]">
																			<label for="userinput1" class=""><?php esc_html_e('Weightage of the exam(%)','school-mgt');?></label>
																		</div>
																	</div>
															    </div>

																	<?php
																	if($key == 0)
																	{
																		?>
																		<div class="col-md-1 col-2 col-sm-3 col-xs-12">
																			<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Add_new_plus_btn.png" ?>" onclick="add_more_merge_result()" alt="" class="rtl_margin_top_15px add_cirtificate" id="add_more_sibling">
																		</div>
																		<?php
																	}
																	else
																	{
																		?>
																		<div class="col-md-1 col-2 col-sm-3 col-xs-12">
																			<input type="image" onclick="deleteParentElementExamMergeSettings(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px remove_cirtificate input_btn_height_width">
																		</div>
																		<?php
																	}
																	?>
																	
																</div>
															</div>
															<?php
														}
														?>
														
													</div> 
													<?php
												}
											else
											{
												?>
												<div id="merge_settings_div" class="">
													<div class="form-body user_form">
														<div class="row">
														<div class="col-md-4 input">
														<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Select Exam','school-mgt');?><span class="require-field">*</span></label>
														<select name="exam_id[]" class="line_height_30px form-control exam_list validate[required] text-input">
														<option value=""><?php esc_attr_e('Select Exam','school-mgt');?></option>
														</select>                
													  </div>
															<div class="col-md-4 col-10">
																<div class="form-group input error_msg_left_margin">
																	<div class="col-md-12 form-control">
																		<input class="form-control onlyletter_number_space_validation text-input" type="number" value="" name="weightage[]">
																		<label for="userinput1" class=""><?php esc_html_e('Weightage of the exam(%)','school-mgt');?></label>
																	</div>
																</div>
															</div>
															<div class="col-md-1 col-2 col-sm-3 col-xs-12">
																<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Add_new_plus_btn.png" ?>" onclick="add_more_merge_result()" alt="" class="rtl_margin_top_15px add_cirtificate" id="add_more_sibling">
															</div>
														</div>

													</div>
												</div> 
												<?php
											}
											?>
												<?php wp_nonce_field( 'save_merge_settings' ); ?>
												<div class="col-sm-3 col-md-3 col-lg-3 col-xs-12">
													<input type="submit" value="<?php if($edit){ esc_attr_e('Save', 'school-mgt');}else{ esc_attr_e('Save', 'school-mgt');} ?>" name="save_merge_settings" class="save_btn check_total_per " />
												</div>
											</div>
										</div>
										
									</form>
								</div>
							</div> 
						    <div class="header mt-4">	
								<h3 class="first_hed"><?php esc_html_e('Group Exam Result List','school-mgt');?></h3>
							</div>
							<?php
								
							   $all_merge_exam_setting_list=$exam_obj->mj_smgt_get_all_merge_exam_setting();
								if(!empty($all_merge_exam_setting_list))
								{
								?>
									<script type="text/javascript">
										jQuery(document).ready(function($)
										{
											"use strict";	
											var table =  jQuery('#exam_merge_list').DataTable({
												"initComplete": function(settings, json) 
												{
													$(".print-button").css({"margin-top": "-55px"});
												},
												responsive: true,
												"dom": 'lifrtp',
												"order": [[ 2, "asc" ]],
												"aoColumns":[                      
															{"bSortable": false},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": false},
															{"bSortable": false}
														],
												language:<?php echo mj_smgt_datatable_multi_language();?>
											});
											$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>"); 
											$('#checkbox-select-all').on('click', function() {
											var rows = table.rows({
												'search': 'applied'
											}).nodes();
											$('input[type="checkbox"]', rows).prop('checked', this.checked);
											});
											$('.select_all').on('click', function(e) {
									if ($(this).is(':checked', true)) {
										$(".smgt_sub_chk").prop('checked', true);
									} else {
										$(".smgt_sub_chk").prop('checked', false);
									}
								});
								$('.smgt_sub_chk').on('change', function() {
									var totalCheckboxes = $('.smgt_sub_chk').length - 1;
									var checkedCheckboxes = $('.smgt_sub_chk:checked').length;
									// If all are checked, check "Select All"; otherwise, uncheck it
									if (totalCheckboxes === checkedCheckboxes) {
										$(".select_all").prop('checked', true);
									}
									if (false == $(this).prop("checked")) {
										$(".select_all").prop('checked', false);
									}
									if ($('.smgt_sub_chk:checked').length == $('.smgt_sub_chk').length) {
										$(".select_all").prop('checked', true);
									}
								});
										});
									</script>
									<div class="panel-body">
										<div class="table-responsive">
											<form id="frm-example" name="frm-example" method="post">
												<table id="exam_merge_list" class="display" cellspacing="0" width="100%">
													<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
														<tr>
														<th class="checkbox_width_10px text-end"><input type="checkbox" class="select_all" id="select_all"></th>
															<th><?php esc_attr_e('Group Exam Result Name','school-mgt');?></th>
															<th><?php esc_attr_e('Class Name','school-mgt');?></th>
															<th><?php esc_attr_e('Group Exam Details','school-mgt');?></th>
															<th><?php esc_attr_e('Created By','school-mgt');?></th>
															<th><?php esc_attr_e('Date','school-mgt');?></th>
															<th><?php esc_attr_e('Status','school-mgt');?></th>
															<th class="text_align_end"><?php esc_attr_e( 'Action', 'school-mgt' ) ;?></th>
														</tr>
													</thead>
													<tbody>
													<?php 
													foreach ($all_merge_exam_setting_list as $retrieved_data)
													{ 	
														?>
														<tr>
														<td class="checkbox_width_10px"><input type="checkbox" class="smgt_sub_chk select-checkbox" name="merge_id[]" value="<?php echo $retrieved_data->id; ?>"></td>
															<td><?php echo $retrieved_data->merge_name;?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Merge Name','school-mgt');?>" ></i></td>
															<td class="name">
																<?php
																$classname = smgt_get_class_section_name_wise($retrieved_data->class_id, $retrieved_data->section_id);
																if (!empty($classname)) {
																	echo $classname;
																} else {
																	echo "N/A";
																}
																?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Class & Section', 'school-mgt'); ?>"></i>
															</td>
															<td><?php echo Mj_smgt_print_weightage_data($retrieved_data->merge_config);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php echo Mj_smgt_print_weightage_data($retrieved_data->merge_config);?>" ></i></td>
															<td><?php echo mj_smgt_get_display_name($retrieved_data->created_by);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Created By','school-mgt');?>" ></i></td>
															<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->created_at);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Created Date','school-mgt');?>" ></i></td>
															<td><?php echo $retrieved_data->status;?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Status','school-mgt');?>" ></i></td>
															<td class="action">
																<div class="smgt-user-dropdown">
																	<ul class="" style="margin-bottom: 0px !important;">
																		<li class="">
																			<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																				<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
																			</a>
																			<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
																				<?php 
																				if($user_access_edit == '1')
																				{ 
																					?>
																					<li class="float_left_width_100 border_bottom_item">
																						<a href="?&page=smgt_gnrl_settings&tab=exam_merge_settings&merge_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->id);?>&action=edit_merge&_wpnonce_action=<?php echo MJ_smgt_get_nonce('edit_action');?>" class="float_left_width_100"><i class="fa fa-edit"></i><?php esc_attr_e('Edit','school-mgt');?></a> 
																					</li>
																					<?php 
																				} 
																				if($user_access_delete =='1')
																				{ 
																					?>
																					<li class="float_left_width_100">
																						<a href="?&page=smgt_gnrl_settings&tab=exam_merge_settings&action=delete_merge&merge_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->id);?>&_wpnonce_action=<?php echo MJ_smgt_get_nonce('delete_action');?>" class="float_left_width_100" style="color: #fd726a !important;"  onclick="return confirm('<?php esc_attr_e('Are you sure you want to delete this record?','school-mgt');?>');"><i class="fa fa-trash"></i> <?php esc_attr_e('Delete','school-mgt');?></a> 
																					</li>
																					<?php 
																				} 
																				?>
																			</ul>
																		</li>
																	</ul>
																</div>	
															</td>
														</tr>
														<?php
														$i++;
													}
													?>
													</tbody>
												</table>
												<div class="print-button pull-left">
													<button class="btn btn-success btn-sms-color button_reload">
														<input type="checkbox" name="" class="smgt_sub_chk select_all" value="" style="margin-top: 0px;">
														<label for="checkbox" class="margin_right_5px"><?php esc_html_e( 'Select All', 'school-mgt' ) ;?></label>
													</button>
													<?php 
													if($user_access_delete =='1')
													{ ?>
														<button id="delete_selected_room" data-toggle="tooltip" title="<?php esc_html_e('Delete Selected','school-mgt');?>" name="delete_selected_exam_setting" class="delete_selected" ><img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/Delete.png" ?>" alt=""></button>
														<?php 
													} ?>
												</div>
											</form>
										</div>
									</div>
									<?php 
								}
								else
								{
									?>
									<div class="calendar-event-new"> 
										<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
									</div>		
									<?php
								}
						}
						if ($active_tab == 'mobile_app_settings') 
						{
						$active_tab1 = isset($_GET['tab1'])?$_GET['tab1']:'license_verification';
						?>
						<ul class="nav nav-tabs panel_tabs margin_left_1per flex-nowrap" style="margin-top: -15px;" role="tablist"><!-- NAV TAB WRAPPER MENU START-->
							
							<li class="<?php if($active_tab1=='license_verification'){?>active<?php }?>">
								<a href="?page=smgt_gnrl_settings&tab=mobile_app_settings&tab1=license_verification" class="padding_left_0 tab <?php echo $active_tab1 == 'license_verification' ? 'nav-tab-active' : ''; ?>">
								<?php echo esc_html__('License Verification', 'school-mgt'); ?></a>
							</li>
							<li class="<?php if($active_tab1=='icon_setting'){?>active<?php }?>">
								<a href="?page=smgt_gnrl_settings&tab=mobile_app_settings&tab1=icon_setting" class="padding_left_0 tab <?php echo $active_tab1 == 'icon_setting' ? 'nav-tab-active' : ''; ?>">
								<?php echo esc_html__('Icon Settings', 'school-mgt'); ?></a>
							</li>
						</ul> 
						
						<div id="" class="gms_main_list"><!--MAIN WRAPPER DIV START-->
							<div class="row "><!--ROW DIV START-->
								<div class="col-md-12 padding_0"><!--COL 12 DIV START-->
									<div class=""><!--PANEL WHITE DIV START-->
										<div class="panel-body margin_left_10"><!--PANEL BODY DIV START-->	
											<?php
												if($active_tab1=='license_verification')
												{
													?>
													<div class="header">	
														<h3 class="first_hed mb-0"><?php esc_html_e('License Verification','school-mgt');?></h3>
													</div>
													<?php
													$domain_name= get_option('smgt_app_domain_name');
													$licence_key = get_option('smgt_app_licence_key');
													$email = get_option('smgt_app_setup_email');
													$check_varification = mj_smgt_check_productkey($domain_name,$licence_key,$email);
													if(!empty($licence_key) && !empty($email) && $check_varification == '0')
													{
														?>
														<div >
															<label style="cursor: default !important;font-size: 17px !important;font-weight: 600 !important;"><?php esc_html_e('Mobile App License Verification Completed successfully','school-mgt');?></label>
															<img src="<?php echo SMS_PLUGIN_URL."/assets/images/check02.gif"?>" alt="" style="height: 60px;" class="calender_logo_image">
														</div>
														<?php
													}
													else
													{
														?>
														<form name="app_verification_form" action="" method="post" class="form-horizontal" id="app_verification_form"><!--VERIFICATION FORM START-->
															<div class="form-body user_form"> <!-- user_form Strat-->   
																
																<input id="server_name" class="form-control validate[required]" type="hidden"value="<?php echo home_url();?>" name="smgt_app_domain_name" readonly>
																<div class="row"><!--Row Div Strat-->
																	<div class="col-md-6 col-lg-6 col-sm-12 col-xl-6">
																		<div class="form-group input">
																			<div class="col-md-12 form-control">
																				<input id="app_licence_key" class="form-control validate[required]" type="text"  value="" name="smgt_app_licence_key">
																				<label class="" for="Description"><?php esc_html_e('App License key','school-mgt');?><span class="require-field">*</span></label>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-6 col-lg-6 col-sm-12 col-xl-6">
																		<div class="form-group input">
																			<div class="col-md-12 form-control">
																				<input id="enter_app_email" class="form-control validate[required,custom[email]]" type="text" value="" name="smgt_app_setup_email">
																				<label class="" for="Description"><?php esc_html_e('Email','school-mgt');?><span class="require-field">*</span></label>
																			</div>
																		</div>
																	</div>
																	
																</div>
															</div>
															<div class="form-body user_form"> <!-- user_form Strat-->   
																<div class="row"><!--Row Div Strat-->
																	<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																		<input type="submit" value="<?php esc_html_e('Save','school-mgt');?>" name="varify_app_key" id="varify_app_key" class="btn save_btn"/>
																	</div>
																</div>
															</div>
														</form>	<!--VERIFICATION FORM END-->
														<?php
													}
												}
												if($active_tab1=='icon_setting')
												{
													?>
													
													<form name="app_verification_form" action="" method="post" class="form-horizontal" id="app_verification_form"><!--VERIFICATION FORM START-->
													<div class="header">	
														<h3 class="first_hed"><?php esc_html_e('Icon Settings','school-mgt');?></h3>
													</div>
														<div class="form-body user_form"> <!-- user_form Strat-->  
															
															<div class="row"><!--Row Div Strat-->
																<div class="col-md-6">
																	<div class="form-group input">
																		<div class="col-md-12 form-control upload-profile-image-patient">
																			<label class="label_margin_left_7px custom-control-label custom-top-label ml-2" for="hmgt_cover_image"><?php esc_html_e('App Logo','school-mgt');?></label>
																			<div class="col-sm-12 display_flex">	
																				<input type="text" id="smgt_app_logo_image_url" name="smgt_school_app_logo" class="image_path_dots form-control"  readonly value="<?php  echo get_option( 'smgt_school_app_logo' ); ?>" />	
																				<input id="app_upload_image_button" type="button" class="button upload_app_logo_button upload_image_btn" value="<?php esc_html_e( 'Upload Cover Image', 'school-mgt' ); ?>" />
																			</div>
																		</div>
																			
																		<div class="clearfix"></div>
																		<div id="upload_smgt_app_logo_preview" class="min_height_100 mt-3 margin_top_5">
																			<img class="other_data_logo other_data_logo_with_back" src="<?php echo get_option( 'smgt_school_app_logo' ); ?>" />
																		</div>
																	</div>
																	
																</div>
															</div>
														</div>
														<div class="form-body user_form"> <!-- user_form Strat-->   
															<div class="row"><!--Row Div Strat-->
																<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
																	<input type="submit" value="<?php esc_html_e('Save','school-mgt');?>" name="save_mobile_app_settings" id="save_mobile_app_settings" class="btn save_btn"/>
																</div>
															</div>
														</div>
													</form>	<!--VERIFICATION FORM END-->
													<?php
												}
												?>
											
										</div><!--PANEL BODY DIV END-->		
									</div><!--PANEL WHITE DIV END-->
								</div><!--COL 12 DIV END-->
							</div><!--ROW DIV END-->
						</div><!--MAIN WRAPPER DIV END-->
						<?php
					    }
						if ($active_tab == 'general_setting') 
						{
						?>

							<form name="student_form" action="" method="post" class="form-horizontal" id="setting_form">
								<div class="header">
									<h3 class="first_hed"><?php esc_html_e(' General Settings', 'school-mgt'); ?></h3>
								</div>
								<div class="form-body user_form">
									<div class="row">
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<input id="smgt_school_name" class="form-control validate[required,custom[city_state_country_validation]]" type="text" maxlength="100" value="<?php echo get_option('smgt_school_name'); ?>" name="smgt_school_name">
													<label class="" for="smgt_school_name"><?php esc_attr_e('School Name', 'school-mgt'); ?><span class="require-field">*</span></label>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<input id="smgt_staring_year" class="form-control validate[minSize[4],maxSize[4],min[0]]" min="1" step="1" type="number" value="<?php echo get_option('smgt_staring_year'); ?>" name="smgt_staring_year">
													<label class="" for="smgt_staring_year"><?php esc_attr_e('Starting Year', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<input id="smgt_school_address" class="form-control validate[required,custom[address_description_validation]]" maxlength="150" type="text" value="<?php echo get_option('smgt_school_address'); ?>" name="smgt_school_address">
													<label class="" for="smgt_school_address"><?php esc_attr_e('School Address', 'school-mgt'); ?><span class="require-field">*</span></label>
												</div>
											</div>
										</div>

										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 error_msg_left_margin">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<input id="smgt_contact_number" class="form-control  validate[required,custom[phone_number],minSize[6],maxSize[15]]" type="text" value="<?php echo get_option('smgt_contact_number'); ?>" name="smgt_contact_number">
													<label class="label_margin_left_7px" for="smgt_contact_number"><?php esc_attr_e('Official Phone Number', 'school-mgt'); ?><span class="require-field">*</span></label>
												</div>
											</div>
										</div>

									  <div class="col-md-6 input">
											<label class="ml-1 custom-top-label top" for="smgt_contry"><?php esc_attr_e('Country', 'school-mgt'); ?></label>
											<?php
											$url = plugins_url('countrylist.xml', __FILE__);
											$xml = simplexml_load_file($url) or die("Error: Cannot create object");
											?>
											<select name="smgt_contry" class="form-control validate[required] max_width_100" id="smgt_contry">
												<option value=""><?php esc_attr_e('Select Country', 'school-mgt'); ?></option>
												<?php
												foreach ($xml as $country) {
												?>
												<option value="<?php echo $country->name; ?>" <?php selected(get_option('smgt_contry'), $country->name);  ?>><?php echo $country->name; ?></option>
												<?php 
											  } ?>
											</select>
										</div>

										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 error_msg_left_margin">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<input id="smgt_email" class="form-control validate[required,custom[email]] text-input" maxlength="100" type="text" value="<?php echo get_option('smgt_email'); ?>" name="smgt_email">
													<label class="" for="smgt_email"><?php esc_attr_e('Email', 'school-mgt'); ?><span class="require-field">*</span></label>
												</div>
											</div>
										</div>

										<div class="col-md-6">
											<div class="form-group input">
												<div class="col-md-12 form-control upload-profile-image-patient res_rtl_height_50px">
													<label class="custom-control-label label_margin_left_15px custom-top-label ml-2 label_position_rtl label_right_position" for="smgt_email"><?php esc_attr_e('System Logo', 'school-mgt'); ?> (<?php esc_attr_e('Size Must Be 150 x 150 px', 'school-mgt'); ?>)<span class="require-field">*</span></label>
													<div class="col-sm-12 display_flex">
														<input type="text" id="smgt_system_logo_url" name="smgt_system_logo" class="image_path_dots form-control validate[required]" value="<?php echo get_option('smgt_system_logo'); ?>" readonly />
														<input id="upload_system_logo_button" type="button" class="button upload_image_btn" style="float: right;" value="<?php esc_attr_e('Upload image', 'school-mgt'); ?>" />
													</div>
												</div>
												<div class="clearfix"></div>
												<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 p-0 margin_top_15px">
													<div id="upload_system_logo_preview" class="gnrl_setting_image_background">
														<img class="image_preview_css" src="<?php echo get_option('smgt_system_logo'); ?>" />
													</div>
												</div>
											</div>
											<p><?php esc_attr_e('Note: logo Size must be 200 X 54 PX And Color Should Be White.', 'school-mgt'); ?></p>
										</div>

										<div class="col-md-6">
											<div class="form-group input">
												<div class="col-md-12 form-control upload-profile-image-patient res_rtl_height_50px">
													<label class="label_margin_left_7px custom-control-label label_position_rtl custom-top-label ml-2" for="smgt_cover_image"><?php esc_attr_e('Other Logo(Invoice, Mail)', 'school-mgt'); ?></label>
													<div class="col-sm-12 display_flex">
														<input type="text" id="smgt_school_background_image" name="smgt_school_logo" class="image_path_dots form-control" value="<?php echo get_option('smgt_school_logo'); ?>" readonly />
														<input id="upload_image_button" type="button" class="button upload_user_cover_button upload_image_btn" style="float: right;" value="<?php esc_attr_e('Upload Cover Image', 'school-mgt'); ?>" />
													</div>
												</div>
												<div class="clearfix"></div>
												<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 p-0 mt-3">
													<div id="upload_school_cover_preview min-h-100-px mt-5-px">
														<img class="other_data_logo" src="<?php echo get_option('smgt_school_logo'); ?>" />
													</div>

												</div>
											</div>
										</div>
										<div class="col-md-6 input">
											<label class="ml-1 custom-top-label top" for="smgt_datepicker_format"><?php esc_attr_e('Date Format', 'school-mgt'); ?>
											</label>
											<?php $date_format_array = mj_smgt_datepicker_dateformat();
											if (get_option('smgt_datepicker_format')) {
												$selected_format = get_option('smgt_datepicker_format');
											} else
												$selected_format = 'Y-m-d';
											?>
											<select id="smgt_datepicker_format" class="form-control max_width_100" name="smgt_datepicker_format">
												<?php
												foreach ($date_format_array as $key => $value) {
													echo '<option value="' . $value . '" ' . selected($selected_format, $value) . '>' . $value . '</option>';
												}
												?>
											</select>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
											<div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0">
												<div class="form-group input">
													<div class="col-md-12 form-control color_picker_div_height">
														<label class="ml-1 custom-top-label top label_position_rtl" for="smgt_datepicker_format"><?php esc_attr_e('System Color', 'school-mgt'); ?></label>
														<input id="smgt_notification_fcm_key" class="form-control text-input color_picker_input" type="color" value="<?php echo get_option('smgt_system_color_code'); ?>" name="smgt_system_color_code">
														&nbsp;<label class="color_picker_label" for="smgt_notification_fcm_key"><?php esc_attr_e('System Color Code : ', 'school-mgt'); ?><?php echo get_option('smgt_system_color_code'); ?></label>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="form-body user_form">
									<div class="row">
										<div class="header">
											<h3 class="first_hed"><?php esc_attr_e('Book Return Settings', 'school-mgt'); ?></h3>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
											<div class="form-group">
												<div class="col-md-12 form-control input_height_48px">
													<div class="row padding_radio">
														<div class="input-group">
															<label class="custom-top-label margin_left_0" for=""><?php esc_html_e("Enable Return Option", "school-mgt"); ?></label>
															<div class="checkbox checkbox_lebal_padding_8px">
																<label class="control-label form-label">
																	<input type="checkbox" class="smgt_return_option" name="smgt_return_option" value="1" <?php echo checked(get_option('smgt_return_option'), 'yes'); ?> />
																	<label><?php esc_html_e('Yes', 'school-mgt'); ?></label>
																</label>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 smgt_return_period_field">
											<div class="form-group input">
												<label class="ml-1 custom-top-label top" for="smgt_return_period"><?php esc_attr_e('Book Return Period', 'school-mgt'); ?><span class="require-field">*</span></label>
												<select id="smgt_return_period" class="form-control validate[required] text-input max_width_100" name="smgt_return_period">
													<option value = ""><?php esc_attr_e('Book Return Period','school-mgt');?></option>
													<?php 
														$period_id = get_option('smgt_return_period');
														$obj_lib= new Smgtlibrary();
														$category_data = $obj_lib->mj_smgt_get_periodlist();
												
														if(!empty($category_data))
														{
															foreach ($category_data as $retrieved_data)
															{
																echo '<option value="'.$retrieved_data->ID.'" '.selected($period_id,$retrieved_data->ID).'>'.$retrieved_data->post_title.' '. esc_attr__('Days','school-mgt').'</option>';
															}
														}
														?>
												</select>
											</div>
										</div>
									</div>
								</div>
								<div class="form-body user_form">
									<div class="row">
										<div class="header">
											<h3 class="first_hed"><?php esc_attr_e('Recurring Invoices Settings', 'school-mgt'); ?></h3>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
											<div class="form-group mb-3">
												<div class="col-md-12 form-control">
													<div class="row padding_radio">
														<div class="">
															<label class="label_margin_left_0px custom-top-label" for="smgt_enable_recurring_invoices"><?php esc_attr_e('Enable Recurring Invoices', 'school-mgt'); ?></label>
															<input type="checkbox" class="margin_right_checkbox_css" name="smgt_enable_recurring_invoices" value="yes" <?php echo checked(get_option('smgt_enable_recurring_invoices'), 'yes'); ?> />
															<lable><?php esc_attr_e('Enable', 'school-mgt'); ?></label>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="form-body user_form">
									<div class="row">
										<div class="header">
											<h3 class="first_hed"><?php esc_attr_e('Fees Payment Reminder Settings', 'school-mgt'); ?></h3>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
											<div class="form-group mb-3">
												<div class="col-md-12 form-control">
													<div class="row padding_radio">
														<div class="">
															<label class="label_margin_left_0px custom-top-label" for="smgt_enable_recurring_invoices"><?php esc_attr_e('Fees Payment Reminder', 'school-mgt'); ?></label>
															<input type="checkbox" class="margin_right_checkbox_css" name="smgt_system_payment_reminder_enable" value="yes" <?php echo checked(get_option('smgt_system_payment_reminder_enable'), 'yes'); ?> />
															<lable><?php esc_attr_e('Enable', 'school-mgt'); ?></label>
														</div>
													</div>
												</div>
											</div>
										</div>

										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input smgt_system_payment_reminder_day">
										<div class="col-md-12 form-control">
											<input id="smgt_system_payment_reminder_day" class="form-control" min="0" type="number" onKeyPress="if(this.value.length==2) return false;" placeholder="<?php esc_html_e('03 Days', 'school-mgt'); ?>" value="<?php echo get_option('smgt_system_payment_reminder_day'); ?>" name="smgt_system_payment_reminder_day">
											<label class="" for="smgt_virtual_classroom_reminder_before_time"><?php esc_html_e('Reminder Before Day', 'school-mgt'); ?></label>
										</div>
									</div>
								</div>
									</div>
								</div>

								<div class="form-body user_form">
									<div class="row">
										<div class="header">
											<h3 class="first_hed"><?php esc_attr_e('Payment Setting', 'school-mgt'); ?></h3>
										</div>

										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<input id="smgt_paypal_email" class="form-control validate[required,custom[email]] text-input" maxlength="100" type="text" value="<?php echo get_option('smgt_paypal_email'); ?>" name="smgt_paypal_email">
													<label class="" for="smgt_paypal_email"><?php esc_attr_e('Paypal Email Id', 'school-mgt'); ?><span class="require-field">*</span></label>
												</div>
											</div>
										</div>

										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
											<div class="form-group mb-3">
												<div class="col-md-12 form-control">
													<div class="row padding_radio">
														<div class="">
															<label class="label_margin_left_0px custom-top-label" for="smgt_enable_sandbox"><?php esc_attr_e('Enable Sandbox', 'school-mgt'); ?></label>
															<input type="checkbox" class="margin_right_checkbox_css" name="smgt_enable_sandbox" value="1" <?php echo checked(get_option('smgt_enable_sandbox'), 'yes'); ?> />
															<lable><?php esc_attr_e('Enable', 'school-mgt'); ?></label>
														</div>
													</div>
												</div>
											</div>
										</div>


										<div class="col-md-6 input">
											<div class="row">
												<div class="col-md-11">
													<label class="ml-1 custom-top-label top" for="smgt_currency_code"><?php esc_attr_e('Select Currency', 'school-mgt'); ?></label>
													<select name="smgt_currency_code" class="form-control text-input max_width_100">
														<option value=""> <?php esc_attr_e('Select Currency', 'school-mgt'); ?></option>
														<?php
														foreach (MJ_smgt_get_currency_list() as $currency) {
															$selected = selected(get_option('smgt_currency_code'), $currency['code'], false);
															echo '<option value="' . esc_attr($currency['code']) . '" ' . $selected . '>';
															echo esc_attr__($currency['name'] . ' (' . $currency['code'] . ' ' . $currency['symbol'] . ')', 'school-mgt');
															echo '</option>';
														}
														?>
													</select>
												</div>
												<div class="col-md-1">
													<span class="font-23-px"><?php echo mj_smgt_get_currency_symbol(); ?></span>
												</div>
											</div>
											<span class="description"><?php esc_attr_e('Selected currency might not supported by paypal. Please check with paypal.', 'school-mgt'); ?></span>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
											<div class="form-group input">
												<div class="col-md-12 form-control">
													<textarea name="smgt_invoice_notice" class="form-control texarea_padding_0"><?php echo get_option('smgt_invoice_notice'); ?></textarea>
													<!-- <input id="smgt_invoice_notice" class="form-control text-input" maxlength="100" type="text" value="<?php echo get_option('smgt_invoice_notice'); ?>"  name="smgt_invoce_notice"> -->
													<label for="smgt_invoice_notice" class="custom-top-label top active"><?php esc_attr_e('Invoice Notice', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
										<?php
										if($school_obj->role == 'administrator')
										{
											if (is_plugin_active('paymaster/paymaster.php')) 
											{ 
												?>
												<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px mb-3">
													<div class="form-group">
														<div class="col-md-12 form-control">
															<div class="row padding_radio">
																<div class="">
																	<label for="smgt_paymaster_pack" class="label_margin_left_0px custom-top-label"><?php esc_attr_e('Use Paymaster Payment Gateways', 'school-mgt'); ?></label>
																	<input type="checkbox" class="margin_right_checkbox_css" value="yes" <?php echo checked(get_option('smgt_paymaster_pack'), 'yes'); ?> name="smgt_paymaster_pack">
																	<lable><?php esc_attr_e('Enable', 'school-mgt'); ?></label>
																</div>
															</div>
														</div>
													</div>
												</div>
												<?php
											}
										}
										?>
									</div>
								</div>

								<div class="form-body user_form">
									<div class="row">
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
											<div class="form-group">
												<div class="col-md-12 form-control input_height_48px">
													<div class="row padding_radio">
														<div class="input-group">
															<label class="custom-top-label margin_left_0" for=""><?php esc_html_e("Admission Fees", "school-mgt"); ?></label>
															<div class="checkbox checkbox_lebal_padding_8px">
																<label class="control-label form-label">
																	<input type="checkbox" class="smgt_admission_fees" name="smgt_admission_fees" value="1" <?php echo checked(get_option('smgt_admission_fees'), 'yes'); ?> />
																	<label><?php esc_html_e('Yes', 'school-mgt'); ?></label>
																</label>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 smgt_admission_amount">
											<div class="form-group input">
												<?php
												global $wpdb;
												$fees_table_name = $wpdb->prefix . 'smgt_fees';

												$fees_data = $wpdb->get_results(
													$wpdb->prepare("SELECT * FROM $fees_table_name")
												);

												?>

												<label class="ml-1 custom-top-label top" for="smgt_admission_amount"><?php esc_attr_e('Admission Fees Amount', 'school-mgt'); ?><span class="require-field">*</span></label>

												<select id="smgt_admission_amount" class="form-control validate[required] text-input max_width_100" name="smgt_admission_amount">

													<option value=""><?php esc_html_e('Select Fees', 'school-mgt'); ?></option>
													<?php

													$options = get_option('smgt_admission_amount');
													foreach ($fees_data as $fees) {
													?>
														<option value="<?php echo esc_attr($fees->fees_id); ?>" <?php if ($options == $fees->fees_id) echo 'selected="selected"'; ?>
															name='smgt_admission_amount'>

															<?php echo  get_the_title($fees->fees_title_id) . '(' . mj_smgt_get_currency_symbol() . ' ' . $fees->fees_amount . ')'; ?>
														</option>
													<?php } ?>
												</select>
											</div>
										</div>
										<!-- <div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 smgt_admission_amount">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="smgt_admission_amount" class="line_height_35px form-control text-input" type="number" minlength="1" maxlength="100" value="<?php echo get_option('smgt_admission_amount'); ?>"  name="smgt_admission_amount">
											<label class="" for="smgt_admission_amount"><?php esc_html_e('Admission Fees Amount', 'school-mgt'); ?></label>
										</div>
									</div>
								</div> -->
									</div>
								</div>
								<div class="form-body user_form">
									<div class="row">
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
											<div class="form-group">
												<div class="col-md-12 form-control input_height_48px">
													<div class="row padding_radio">
														<div class="input-group">
															<label class="custom-top-label margin_left_0" for=""><?php esc_html_e("Registration Fees", "school-mgt"); ?></label>
															<div class="checkbox checkbox_lebal_padding_8px">
																<label class="control-label form-label">
																	<input type="checkbox" class="smgt_registration_fees" name="smgt_registration_fees" value="1" <?php echo checked(get_option('smgt_registration_fees'), 'yes'); ?> />
																	<label><?php esc_html_e('Yes', 'school-mgt'); ?></label>
																</label>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 smgt_registration_amount">
											<div class="form-group input">
												<?php
												global $wpdb;
												$wpdb_tablename = $wpdb->prefix . 'smgt_fees';
												$fees_data = $wpdb->get_results(
													$wpdb->prepare("SELECT * FROM $fees_table_name")
												);
												?>
												<label class="ml-1 custom-top-label top" for="smgt_registration_amount"><?php esc_html_e('Registration Fees Amount', 'school-mgt'); ?><span class="require-field">*</span></label>

												<select name="smgt_registration_amount" id="smgt_registration_amount" class='form-control validate[required] text-input max_width_100'>
													<option value=""><?php esc_html_e('Select Fees', 'school-mgt'); ?></option>
													<?php
													$options = get_option('smgt_registration_amount');
													foreach ($fees_data as $fees) {
													?>
														<option value="<?php echo esc_attr($fees->fees_id); ?>" <?php if ($options == $fees->fees_id) echo 'selected="selected"'; ?>
															name='smgt_registration_amount'>

															<?php echo  get_the_title($fees->fees_title_id) . '(' . mj_smgt_get_currency_symbol() . ' ' . $fees->fees_amount . ')'; ?>
														</option>

													<?php } ?>
												</select>

											</div>
										</div>
									</div>
								</div>
								<span class="description"><a href="<?php if($school_obj->role == 'supportstaff'){ echo "?dashboard=user&page=feepayment"; }else{ echo "?page=smgt_fees_payment&tab=feespaymentlist";} ?>" target="_blank" style="text-decoration: none; color: blue;">
										<?php esc_attr_e('Click here to add or update Fees Amount.', 'school-mgt'); ?>
									</a></span>
					</div>
					<div class="form-body user_form">
						<div class="header">
							<h3 class="first_hed"><?php esc_attr_e('Virtual Classroom Setting(Zoom)', 'school-mgt'); ?></h3>
						</div>
						<div class="row">
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3 rtl_margin_top_15px">
								<div class="form-group">
									<div class="col-md-12 form-control">
										<div class="row padding_radio">
											<div class="">
												<label class="label_margin_left_0px custom-top-label" for="smgt_enable_virtual_classroom"><?php esc_attr_e('Virtual Classroom', 'school-mgt'); ?></label>
												<input type="checkbox" id="virual_class_checkbox" class="margin_right_checkbox_css" name="smgt_enable_virtual_classroom" value="1" <?php echo checked(get_option('smgt_enable_virtual_classroom'), 'yes'); ?> />
												<lable> <?php esc_attr_e('Enable', 'school-mgt'); ?></label>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
							if (get_option('smgt_enable_virtual_classroom') == 'yes') {
						?>
							<style>
								#virtual_class_div {
									display: block;
								}
							</style>
						<?php
							} else {
						?>
							<style>
								#virtual_class_div {
									display: none;
								}
							</style>
						<?php
							}
						?>
						<div id="virtual_class_div" class="">
							<div class="row">
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="smgt_virtual_classroom_client_id" class="form-control text-input virtual_classroom_input" type="text" value="<?php echo get_option('smgt_virtual_classroom_client_id'); ?>" name="smgt_virtual_classroom_client_id">
											<label class="" for="smgt_virtual_classroom_client_id"><?php esc_attr_e('Client Id', 'school-mgt'); ?><span class="required">*</span></label>
										</div>
										<span class="description"><?php esc_attr_e('That will be provided by zoom.', 'school-mgt'); ?></span>
									</div>
								</div>

								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="smgt_virtual_classroom_client_secret_id" class="form-control text-input virtual_classroom_input" type="text" value="<?php echo get_option('smgt_virtual_classroom_client_secret_id'); ?>" name="smgt_virtual_classroom_client_secret_id">
											<label class="" for="smgt_virtual_classroom_client_secret_id"><?php esc_attr_e('Client Secret Id', 'school-mgt'); ?><span class="required">*</span></label>
										</div>
										<span class="description"><?php esc_attr_e('That will be provided by zoom.', 'school-mgt'); ?></span>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="custom-top-label" for="smgt_enable_virtual_classroom_reminder"><?php esc_attr_e('Mail Notification Virtual ClassRoom Reminder', 'school-mgt'); ?></label>
													<input id="virtual_classroom_reminder" class="margin_right_checkbox_css" type="checkbox" name="smgt_enable_virtual_classroom_reminder" value="1" <?php echo checked(get_option('smgt_enable_virtual_classroom_reminder'), 'yes'); ?> />
													<lable> <?php esc_attr_e('Enable', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="custom-top-label" for="smgt_enable_sms_virtual_classroom_reminder"><?php esc_attr_e('SMS Notification Virtual Class Room Reminder', 'school-mgt'); ?></label>
													<input id="virtual_classroom_reminder" class="margin_right_checkbox_css" type="checkbox" name="smgt_enable_sms_virtual_classroom_reminder" value="1" <?php echo checked(get_option('smgt_enable_sms_virtual_classroom_reminder'), 'yes'); ?> />
													<lable> <?php esc_attr_e('Enable', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="" class="form-control text-input" type="text" value="<?php echo site_url() . '/?page=callback'; ?>" name="" disabled>
											<label class="" for="smgt_virtual_classroom_client_id"><?php esc_attr_e('Redirect URL', 'school-mgt'); ?></label>
										</div>
										<span class="description"><?php esc_attr_e('Please copy this Redirect URL and add in your zoom account Redirect URL.', 'school-mgt'); ?></span>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="smgt_virtual_classroom_reminder_before_time" class="form-control" min="0" type="number" onKeyPress="if(this.value.length==2) return false;" placeholder="<?php esc_html_e('01 Minute', 'school-mgt'); ?>" value="<?php echo get_option('smgt_virtual_classroom_reminder_before_time'); ?>" name="smgt_virtual_classroom_reminder_before_time">
											<label class="" for="smgt_virtual_classroom_reminder_before_time"><?php esc_html_e('Reminder Before Time', 'school-mgt'); ?></label>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="form-body user_form">
						<div class="row">
							<div class="header">
								<h3 class="first_hed"><?php esc_attr_e('Message Setting', 'school-mgt'); ?></h3>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
								<div class="form-group mb-3">
									<div class="col-md-12 form-control">
										<div class="row padding_radio">
											<div class="">
												<label for="parent_send_message" class="custom-top-label"><?php esc_attr_e('Parent can send message to class students', 'school-mgt'); ?></label>
												<input type="checkbox" class="margin_right_checkbox_css" value="1" <?php echo checked(get_option('parent_send_message'), 1); ?> name="parent_send_message">
												<lable><?php esc_attr_e('Enable', 'school-mgt') ?></label>
											</div>
										</div>
									</div>
								</div>
							</div>

							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
								<div class="form-group mb-3">
									<div class="col-md-12 form-control">
										<div class="row padding_radio">
											<div class="">
												<label for="student_send_message" class="custom-top-label"><?php esc_attr_e(' Student can send message to each other', 'school-mgt'); ?></label>
												<input type="checkbox" class="margin_right_checkbox_css" value="1" <?php echo checked(get_option('student_send_message'), 1); ?> name="student_send_message">
												<lable><?php esc_attr_e('Enable', 'school-mgt') ?></label>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="form-body user_form">
						<div class="row">
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
								<h3 class="first_hed"><?php esc_html_e('Student Approval setting', 'school-mgt'); ?></h3>
								<div class="form-group mb-3">
									<div class="col-md-12 form-control">
										<div class="row padding_radio">
											<div class="">
												<label for="student_approval" class="label_margin_left_0px custom-top-label"><?php esc_attr_e('Student Approval', 'school-mgt'); ?></label>
												<input type="checkbox" class="margin_right_checkbox_css" value="1" <?php echo checked(get_option('student_approval'), 1); ?> name="student_approval"> <?php esc_attr_e('Enable', 'school-mgt') ?>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 margin_top_15px_rs rtl_margin_top_15px">

								<h3 class="first_hed"><?php esc_html_e('Video Setting', 'school-mgt'); ?></h3>

								<div class="form-group mb-3">

									<div class="col-md-12 form-control">

										<div class="row padding_radio">

											<div class="">

												<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("How to Videos Display?", "school-mgt"); ?></label>

												<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="smgt_enable_video_popup_show" value="yes" <?php echo checked(get_option('smgt_enable_video_popup_show'), 'yes'); ?> />

												<label class="res_margin_top_5px"><?php esc_html_e('Enable', 'school-mgt'); ?></label>

											</div>

										</div>

									</div>

								</div>

							</div>
						</div>
					</div>

					<div class="form-body user_form">
						<div class="row">
							<div class="header">
								<h3 class="first_hed"><?php esc_attr_e('Other setting', 'school-mgt'); ?></h3>
							</div>
							<div class="col-md-6">
								<div class="form-group input rtl_margin_0px">
									<div class="col-md-12 form-control upload-profile-image-patient res_rtl_height_50px">
										<label class="custom-control-label custom-top-label ml-2 label_position_rtl" for="smgt_email"><?php esc_attr_e('Principal Signature', 'school-mgt'); ?></label>
										<div class="col-sm-12 display_flex">
											<input type="text" id="smgt_principal_signature" name="smgt_principal_signature" class="image_path_dots form-control" value="<?php echo get_option('smgt_principal_signature'); ?>" readonly />

											<input id="upload_principal_signature" type="button" class="button upload_image_btn" style="float: right;" value="<?php esc_attr_e('Upload image', 'school-mgt'); ?>" />
										</div>
									</div>
									<div class="clearfix"></div>
									<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
										<div id="upload_user_aprincipal_signature">
											<img class="image_preview_css" src="<?php echo get_option('smgt_principal_signature'); ?>" />
										</div>
									</div>
								</div>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
								<div class="form-group mb-3">
									<div class="col-md-12 form-control" style="min-height: 47px !important;">
										<div class="row padding_radio">
											<div class="">
												<label for="smgt_mail_notification" class="label_margin_left_0px custom-top-label"><?php esc_attr_e('Mail Notification', 'school-mgt'); ?></label>
												<input type="checkbox" class="margin_right_checkbox_css" value="1" <?php echo checked(get_option('smgt_mail_notification'), 1); ?> name="smgt_mail_notification">
												<lable> <?php esc_attr_e('Enable', 'school-mgt'); ?></label>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="form-body user_form"> <!-- user_form Strat-->
						<div class="row"><!--Row Div Strat-->
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3 ">
								<div class="header">
									<h3 class="first_hed"><?php esc_html_e('Footer setting', 'school-mgt'); ?></h3>
								</div>
								<div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 P-0 rtl_padding_0px ">
									<div class="form-group input rtl_margin_0px">
										<div class="col-md-12 form-control">
											<input id="smgt_footer_description" class="form-control text-input" type="text" minlength="6" maxlength="100" value="<?php echo get_option('smgt_footer_description'); ?>" name="smgt_footer_description">
											<label class="" for="smgt_footer_description"><?php esc_html_e('Footer Description', 'school-mgt'); ?></label>
										</div>
									</div>
								</div>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
								<div class="header">
									<h3 class="first_hed"><?php esc_html_e('Datatable Header Settings', 'school-mgt'); ?></h3>
								</div>
								<div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
									<div class="form-group">
										<div class="col-md-12 form-control input_height_48px">
											<div class="row padding_radio">
												<div class="input-group">
													<label class="custom-top-label margin_left_0" for=""><?php esc_html_e("Header", "school-mgt"); ?></label>
													<div class="checkbox checkbox_lebal_padding_8px">
														<label class="control-label form-label">
															<input type="checkbox" name="smgt_heder_enable" value="1" <?php echo checked(get_option('smgt_heder_enable'), 'yes'); ?> />
															<label><?php esc_html_e('Enable', 'school-mgt'); ?></label>
														</label>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
								<div class="header">
									<h3 class="first_hed"><?php esc_html_e('Push Notification setting', 'school-mgt'); ?></h3>
								</div>
								<div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 rtl_padding_0px">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="smgt_notification_fcm_key" class="form-control text-input" type="text" value="<?php echo get_option('smgt_notification_fcm_key'); ?>" name="smgt_notification_fcm_key">
											<label class="" for="smgt_notification_fcm_key"><?php esc_attr_e('Notification FCM Key', 'school-mgt'); ?></label>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php
					if($user_access_edit == "1")
					{
						?>
						<div class="form-body user_form">
							<div class="row">
								<div class="col-sm-6">
									<input id="" class="form-control text-input" type="hidden" value="<?php echo get_option('general_setting_option_update'); ?>" name="general_setting_option_update">
									<input type="submit" value="<?php esc_attr_e('Save', 'school-mgt'); ?>" name="save_setting" class="btn btn-success save_btn" />
								</div>
							</div>
						</div>
						<?php
					}
					?>
					</form>
				<?php
						}
						if ($active_tab == "dashboard_card_settings") {
				?>
					<form name="student_form" action="" method="post" class="form-horizontal" id="setting_form">
						<div class="header">
							<h3 class="first_hed"><?php esc_html_e('Dashboard Card setting For Support-Staff', 'school-mgt'); ?></h3>
						</div>
						<div class="form-body user_form"> <!-- user_form Strat-->
							<div class="row"><!--Row Div Strat-->
								<?php $dashboard_card_for_staff = get_option("smgt_dashboard_card_for_support_staff"); ?>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Users Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="users_chart_staff" value="yes" <?php echo checked($dashboard_card_for_staff['smgt_user_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Student Status Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="student_status_staff" value="yes" <?php echo checked($dashboard_card_for_staff['smgt_student_status_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Attendance Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="attendance_staff" value="yes" <?php echo checked($dashboard_card_for_staff['smgt_attendance_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Payment Status Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="payment_status_staff" value="yes" <?php echo checked($dashboard_card_for_staff['smgt_payment_status_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>


								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Payment Report", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="payment_report_staff" value="yes" <?php echo checked($dashboard_card_for_staff['smgt_payment_report'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Fees Payment Card", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="invoice_enable_staff" value="yes" <?php echo checked($dashboard_card_for_staff['smgt_invoice_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

							</div>
						</div>

						<div class="header">
							<h3 class="first_hed"><?php esc_html_e('Dashboard Card setting For Teacher', 'school-mgt'); ?></h3>
						</div>
						<div class="form-body user_form"> <!-- user_form Strat-->
							<div class="row"><!--Row Div Strat-->
								<?php $dashboard_card_for_teacher = get_option("smgt_dashboard_card_for_teacher"); ?>



								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("User Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="user_chart_enable_teacher" value="yes" <?php echo checked($dashboard_card_for_teacher['smgt_user_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Student Status Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="student_status_enable_teacher" value="yes" <?php echo checked($dashboard_card_for_teacher['smgt_student_status_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>


								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Attendance Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="attendance_chart_enable_teacher" value="yes" <?php echo checked($dashboard_card_for_teacher['smgt_attendance_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="header">
							<h3 class="first_hed"><?php esc_html_e('Dashboard Card setting For Parent', 'school-mgt'); ?></h3>
						</div>
						<div class="form-body user_form"> <!-- user_form Strat-->
							<div class="row"><!--Row Div Strat-->
								<?php $dashboard_card_for_parent = get_option("smgt_dashboard_card_for_parent"); ?>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("User Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="user_chart_parent" value="yes" <?php echo checked($dashboard_card_for_parent['smgt_user_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Payement Status Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="payment_status_parent" value="yes" <?php echo checked($dashboard_card_for_parent['smgt_payment_status_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Fees Payment Card", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="invoice_enable_parent" value="yes" <?php echo checked($dashboard_card_for_parent['smgt_invoice_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="header">
							<h3 class="first_hed"><?php esc_html_e('Dashboard Card setting For Student', 'school-mgt'); ?></h3>
						</div>
						<div class="form-body user_form"> <!-- user_form Strat-->
							<div class="row"><!--Row Div Strat-->
								<?php
								$dashboard_card = get_option("smgt_dashboard_card_for_student");
								?>
								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Users Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="user_chart_enable_student" value="yes" <?php echo checked($dashboard_card['smgt_user_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Payment Status Chart", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="payment_status_chart_enable_student" value="yes" <?php echo checked($dashboard_card['smgt_payment_status_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3  rtl_margin_top_15px">
									<div class="form-group mb-3">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="">
													<label class="label_margin_left_0px custom-top-label" for=""><?php esc_html_e("Fees Payment Card", "school-mgt"); ?></label>
													<input type="checkbox" class="res_margin_top_5px margin_right_checkbox_css" name="invoice_enable" value="yes" <?php echo checked($dashboard_card['smgt_invoice_chart'], "yes"); ?> />
													<label class="res_margin_top_5px"><?php esc_html_e('Show', 'school-mgt'); ?></label>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
						if($user_access_edit == "1")
						{
							?>
							<div class="form-body user_form">
								<div class="row">
									<div class="col-sm-6">
										<input type="submit" value="<?php esc_attr_e('Save', 'school-mgt'); ?>" name="save_dashboard_setting" class="btn btn-success save_btn" />
									</div>
								</div>
							</div>
							<?php
						}
						?>
					</form>
				<?php
						}
						if ($active_tab == "document_settings") {
				?>
					<script type="text/javascript">
						$(document).ready(function() {

							"use strict";
							$('#document_setting_form').validationEngine({
								promptPosition: "bottomLeft",
								maxErrorsPerField: 1
							});
							$('.document_type').multiselect({
								nonSelectedText: '<?php esc_html_e('Select Document Type', 'school-mgt'); ?>',
								includeSelectAllOption: true,
								allSelectedText: '<?php esc_html_e('All Selected', 'school-mgt'); ?>',
								selectAllText: '<?php esc_html_e('Select all', 'school-mgt'); ?>',
								templates: {
									button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
								},
								buttonContainer: '<div class="dropdown" />'
							});
							$('.profile_extention').multiselect({
								nonSelectedText: '<?php esc_html_e('Select Document Type', 'school-mgt'); ?>',
								includeSelectAllOption: true,
								allSelectedText: '<?php esc_html_e('All Selected', 'school-mgt'); ?>',
								selectAllText: '<?php esc_html_e('Select all', 'school-mgt'); ?>',
								templates: {
									button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
								},
								buttonContainer: '<div class="dropdown" />'
							});
							$("body").on("click", ".document_type_validation", function() {
								var checked = $(".multiselect_validation_document .dropdown-menu input:checked").length;

								if (!checked) {
									alert("<?php esc_html_e('Please select atleast one document extention.', 'school-mgt'); ?>");
									return false;
								}

								var checked_profile = $(".multiselect_validation_profile .dropdown-menu input:checked").length;

								if (!checked_profile) {
									alert("<?php esc_html_e('Please select atleast one profile extention.', 'school-mgt'); ?>");
									return false;
								}
							});
						});
					</script>
					<form name="document_setting_form" action="" method="post" class="form-horizontal" id="document_setting_form"><!--VERIFICATION FORM START-->

						<div class="form-body user_form"> <!-- user_form Strat-->

							<div class="row"><!--Row Div Strat-->

								<div class="rtl_margin_top_15px col-sm-6 col-md-6 col-lg-6 col-xl-6 res_margin_bottom_20px multiselect_validation_document smgt_multiple_select mb-3">
									<?php
									$document_option = get_option('smgt_upload_document_type');

									$document_type = explode(", ", $document_option);
									?>
									<select class="form-control document_type" name="document_type[]" multiple="multiple">
										<option value="pdf" <?php echo in_array("pdf", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('pdf', 'school-mgt'); ?></option>
										<option value="doc" <?php echo in_array("doc", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('doc', 'school-mgt'); ?></option>
										<option value="docx" <?php echo in_array("docx", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('docx', 'school-mgt'); ?></option>
										<option value="xls" <?php echo in_array("xls", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('xls', 'school-mgt'); ?></option>
										<option value="xlsx" <?php echo in_array("xlsx", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('xlsx', 'school-mgt'); ?></option>
										<option value="ppt" <?php echo in_array("ppt", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('ppt', 'school-mgt'); ?></option>
										<option value="pptx" <?php echo in_array("pptx", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('pptx', 'school-mgt'); ?></option>
										<option value="gif" <?php echo in_array("gif", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('gif', 'school-mgt'); ?></option>
										<option value="png" <?php echo in_array("png", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('png', 'school-mgt'); ?></option>
										<option value="jpg" <?php echo in_array("jpg", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('jpg', 'school-mgt'); ?></option>
										<option value="jpeg" <?php echo in_array("jpeg", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('jpeg', 'school-mgt'); ?></option>
										<option value="bmp" <?php echo in_array("bmp", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('bmp', 'school-mgt'); ?></option>
										<option value="webp" <?php echo in_array("webp", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('webp', 'school-mgt'); ?></option>
										<option value="svg" <?php echo in_array("svg", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('svg', 'school-mgt'); ?></option>
										<option value="csv" <?php echo in_array("csv", $document_type) ? 'selected' : ''; ?>><?php esc_html_e('csv', 'school-mgt'); ?></option>
									</select>

									<span class="multiselect_label">
										<label class="ml-1 custom-top-label top" for="staff_name"><?php esc_html_e('Document Extension', 'school-mgt'); ?></label>
									</span>

								</div>

								<div class="rtl_margin_top_15px col-sm-6 col-md-6 col-lg-6 col-xl-6 res_margin_bottom_20px multiselect_validation_profile smgt_multiple_select">
									<?php
									$profile_option = get_option('smgt_upload_profile_extention');

									$profile_extention = explode(", ", $profile_option);
									?>
									<select class="form-control profile_extention" name="profile_extension[]" multiple="multiple">
										<option value="gif" <?php echo in_array("gif", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('gif', 'school-mgt'); ?></option>
										<option value="png" <?php echo in_array("png", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('png', 'school-mgt'); ?></option>
										<option value="jpg" <?php echo in_array("jpg", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('jpg', 'school-mgt'); ?></option>
										<option value="jpeg" <?php echo in_array("jpeg", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('jpeg', 'school-mgt'); ?></option>
										<option value="bmp" <?php echo in_array("bmp", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('bmp', 'school-mgt'); ?></option>
										<option value="webp" <?php echo in_array("webp", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('webp', 'school-mgt'); ?></option>
										<option value="svg" <?php echo in_array("svg", $profile_extention) ? 'selected' : ''; ?>><?php esc_html_e('svg', 'school-mgt'); ?></option>
									</select>

									<span class="multiselect_label">
										<label class="ml-1 custom-top-label top" for="staff_name"><?php esc_html_e('Profile Extension For Frontend', 'school-mgt'); ?></label>
									</span>

								</div>

								<div class="col-md-6 col-lg-6 col-sm-12 col-xl-6">

									<div class="form-group input">

										<div class="col-md-12 form-control">

											<input id="document_size" class="form-control validate[required,custom[onlyNumberSp],max[40],min[1]]" type="text" value="<?php echo get_option('smgt_upload_document_size'); ?>" name="document_size">

											<label class="" for="Description"><?php esc_html_e('Document Size(MB)', 'school-mgt'); ?><span class="require-field">*</span></label>

										</div>

									</div>

								</div>

								<div class="col-md-6 col-lg-6 col-sm-12 col-xl-6">

									<div class="form-group input">

										<div class="col-md-12 form-control">

											<input id="profile_size" class="form-control validate[required,custom[onlyNumberSp],max[20],min[1]]" type="text" value="<?php echo get_option('smgt_upload_profile_size'); ?>" name="profile_size">

											<label class="" for="Description"><?php esc_html_e('Profile Image Size(MB)', 'school-mgt'); ?><span class="require-field">*</span></label>

										</div>

									</div>

								</div>

							</div>

						</div>
						<?php
						if($user_access_edit == "1")
						{
							?>
							<div class="form-body user_form"> <!-- user_form Strat-->
								<div class="row"><!--Row Div Strat-->
									<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
										<input type="submit" value="<?php esc_html_e('Submit', 'school-mgt'); ?>" name="save_document_setting" id="save_document_setting" class="btn document_type_validation save_btn" />
									</div>
								</div>
							</div>
							<?php
						}
						?>

					</form> <!--VERIFICATION FORM END-->
				<?php
						}
				?>
				</div><!-- panel-body-->
			</div><!-- col-md-12 -->
		</div><!-- Row -->
	</div><!-- main_list_margin_15px -->
	</div><!-- page-inner-->
	<?php

	?>