<?php
	$obj_lib = new Smgtlibrary();
	if (isset($_GET['book_id']) && is_array($_GET['book_id'])) {
		$book_id = reset($_GET['book_id']); // Get the first book_id from the array
	} else {
		$book_id = $_GET['book_id'] ?? ''; // Use single value if not an array
	}
	// Now safely pass it to your function
	$decoded_id = MJ_smgt_decrypt_id($book_id);

	$book_data=$obj_lib->mj_smgt_get_single_books($decoded_id);
	
?>
<div class="panel-body view_page_main"><!-- START PANEL BODY DIV-->
	<div class="content-body">
		<section id="user_information" class="">
			<div class="view_page_header_bg">
				<div class="row">
					<div class="col-xl-10 col-md-9 col-sm-10">
						<div class="user_profile_header_left float_left_width_100">
							<img class="user_view_profile_image" src="<?php echo SMS_PLUGIN_URL."/assets/images/Library.png"?>">
							<div class="row profile_user_name">
								<div class="float_left view_top1">
									<div class="col-xl-12 col-md-12 col-sm-12 float_left_width_100">
										<label class="view_user_name_label"><?php echo ucfirst($book_data->book_name);?></label>
										<div class="view_user_edit_btn">
											<a class="color_white margin_left_2px" href="?page=smgt_library&tab=addbook&action=edit&book_id=<?php echo $_REQUEST['book_id'];?>&_wpnonce_action=<?php echo MJ_smgt_get_nonce('edit_action');?>">
												<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/edit.png"?>">
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>		
					</div>
					<div class="col-xl-2 col-lg-3 col-md-3 col-sm-2 add_btn_possition_teacher_res">
						<div class="group_thumbs">
							<img src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/Group.png"?>">
						</div>
					</div>
				</div>
			</div>
		</section>

		<section id="body_content_area" class="mt-5">
			<div class="panel-body"><!-- START PANEL BODY DIV-->

				<?php
				if(isset($_REQUEST['issue_message']) && ($_REQUEST['issue_message'] == "issue_success"))
				{ 
					?>
					<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
						<p><?php echo esc_attr__('Book Issued Successfully.','school-mgt');?></p>
						<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
					</div>
					<?php 
				} 
				if(isset($_REQUEST['issue_message']) && ($_REQUEST['issue_message'] == "return_success"))
				{ 
					?>
					<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
						<p><?php echo esc_attr__('Book Returned Successfully.','school-mgt');?></p>
						<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
					</div>
					<?php 
				} 
				?>
				<div class="row">
					<div class="col-xl-12 col-md-12 col-sm-12">
						<div class="col-xl-12 col-md-12 col-sm-12 margin_top_15px_rs">
							<div class="guardian_div">
								<label class="view_page_label_heading"> <?php esc_html_e('Book Information', 'school-mgt'); ?> </label>
								<div class="row">
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('ISBN', 'school-mgt'); ?> </label> <br>
										<label class="view_page_content_labels"><?php if(!empty($book_data->ISBN)){ echo $book_data->ISBN;}else{ echo "N/A";}?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Book Number', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->book_number)){ echo $book_data->book_number;}else{ echo "N/A";}?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Book Category', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->cat_id)){ echo get_the_title($book_data->cat_id);}else{ echo "N/A";}?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Author Name', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->author_name)){ echo $book_data->author_name;}else{ echo "N/A";}?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Publisher', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->publisher)){ echo $book_data->publisher;}else{ echo "N/A";}?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Rack Location', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->rack_location)){ echo get_the_title($book_data->rack_location);}else{ echo "N/A";}?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Book Price', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($book_data->price, 2, '.', '')); ?></label>
									</div>
									<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Remaining Quantity', 'school-mgt'); ?> </label><br>
										<label class="ftext_style_capitalization view_page_content_labels"><?php echo $book_data->quentity . ' ' . esc_html__("Out Of", "school-mgt") . " " . $book_data->total_quentity; ?></label>
									</div>
									<div class="col-xl-12 col-md-12 col-sm-12 margin_top_15px">
										<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Description', 'school-mgt'); ?> </label><br>
										<label class="">
										<?php
										if(!empty($book_data->description))
										{
											echo $book_data->description;
										}
										else
										{
											echo "N/A";
										}
										?>
										</label>
									</div>
								</div>
							</div>
						</div>
						<?php
						if(isset($_POST['save_issue_book']))
						{
							$result=$obj_lib->mj_smgt_add_issue_book($_POST);
							if($result)
							{ 
								/* Book Issue Mail Notification */
								if(isset($_POST['smgt_issue_book_mail_service_enable']))
								{
									foreach($_POST['book_id'] as $b_id)
									{
										$smgt_issue_book_mail_service_enable = $_POST['smgt_issue_book_mail_service_enable'];
										if($smgt_issue_book_mail_service_enable)
										{	
											$search['{{student_name}}']	 	= 	mj_smgt_get_teacher($_POST['student_id']);
											$search['{{book_name}}'] 	    = 	mj_smgt_get_bookname($b_id);
											$search['{{issue_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['issue_date']);							
											$search['{{return_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['return_date']);	
											$search['{{school_name}}'] 		= 	get_option('smgt_school_name');								
											$message = mj_smgt_string_replacement($search,get_option('issue_book_mailcontent'));
											$mail_id=mj_smgt_get_emailid_byuser_id($_POST['student_id']);		
											if(get_option('smgt_mail_notification') == '1')
											{
												wp_mail($mail_id,get_option('issue_book_title'),$message);
											}	
										}
									}	
								}
								wp_redirect ( admin_url().'admin.php?page=smgt_library&tab=view_book&book_id='.$_GET['book_id'].'&issue_message=issue_success');
							}
						}
						if(isset($_POST['return_book']))
						{
							$result=$obj_lib->mj_smgt_submit_return_book($_POST);
							wp_redirect ( admin_url().'admin.php?page=smgt_library&tab=view_book&book_id='.$_GET['book_id'].'&issue_message=return_success');
						}
						?>
						<script type="text/javascript">
						jQuery(document).ready(function($)
						{
							var selection = $(".issue_period").val();
							if (selection == '') {
								return false;
							}
							var curr_data = {
								action: 'mj_smgt_get_book_return_date',
								issue_period: $(".issue_period").val(),
								issue_date: $("#issue_date").val()
							};
							$.post(smgt.ajax, curr_data, function (response) {
								$('#return_date').val(response);
							});
						});
						</script>
						<div class="col-xl-12 col-md-12 col-sm-12 mt-3 margin_top_15px_rs">
							<div class="guardian_div">
								<label class="view_page_label_heading mb-4"> <?php esc_html_e('Issue Book Information', 'school-mgt'); ?> </label>
								<form name="issue_book_form" action="" method="post" class="form-horizontal" id="issue_book_form">
									<?php $action = isset($_REQUEST['action'])?$_REQUEST['action']:'insert';?>
									<input type="hidden" name="action" value="<?php echo $action;?>">
									<input type="hidden" name="issue_id" value="">
									<input type="hidden" name="book_id[]" value="<?php echo $decoded_id;?>">
									<input type="hidden" name="bookcat_id" value="<?php echo $book_data->cat_id;?>">
									<div class="form-body user_form">
										<div class="row">
											<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 input error_msg_left_margin rtl_margin_0px">
												<label class="ml-1 custom-top-label top" for="student_id"><?php esc_attr_e('Select User','school-mgt');?><span class="require-field">*</span></label>
												<select name="student_id" id="student_id" class="form-control change_library_card max_width_100">
													<option value = ""><?php esc_attr_e('Select User','school-mgt');?></option>
													<?php echo mj_smgt_get_student_and_teacher_for_library();?>
												</select>
											</div>
											<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
												<div class="form-group input">
													<div class="col-md-12 form-control">
														<input id="issue_library_card" class="form-control validate[required,custom[address_description_validation]]" type="text" maxlength="50" value="" name="library_card">
														<label class="" for="library_card"><?php esc_attr_e('Library Card No.','school-mgt');?><span class="require-field">*</span></label>
													</div>
												</div>
											</div>
											<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
												<label class="ml-1 custom-top-label top" for="period"><?php esc_attr_e('Period','school-mgt');?><span class="require-field">*</span></label>
												<select name="period_id" id="category_data" class="form-control issue_period validate[required] max_width_100 period_type">
													<option value = ""><?php esc_attr_e('Select Period','school-mgt');?></option>
													<?php 
													if($edit)
													{
														$period_id = $result->period;
													}
													else
													{
														$period_id = get_option('smgt_return_period');
													}
														$category_data = $obj_lib->mj_smgt_get_periodlist();
												
													if(!empty($category_data))
													{
														foreach ($category_data as $retrieved_data)
														{
															echo '<option value="'.$retrieved_data->ID.'" '.selected($period_id,$retrieved_data->ID).'>'.$retrieved_data->post_title.' '. esc_attr__('Days','school-mgt').'</option>';
														}
													}
													?>
												</select>
											</div>
											<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3">
												<button id="addremove_cat" class="rtl_margin_top_15px add_btn sibling_add_remove" model="period_type"><?php esc_attr_e('Add','school-mgt');?></button>
											</div>
											<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
												<div class="form-group input">
													<div class="col-md-12 form-control">
														<input id="issue_date" class="datepicker form-control validate[required] text-input" type="text" name="issue_date" value="<?php echo mj_smgt_getdate_in_input_box(date('Y-m-d'));?>" readonly>
														<label class="" for="issue_date"><?php esc_attr_e('Issue Date','school-mgt');?><span class="require-field">*</span></label>
													</div>
												</div>
											</div>
											<?php wp_nonce_field( 'save_issuebook_admin_nonce' ); ?>
											<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
												<div class="form-group input">
													<div class="col-md-12 form-control">
														<input id="return_date" class="form-control validate[required] date_picker text-input" type="text" name="return_date" value="" readonly>
														<label class="active date_label" for="return_date"><?php esc_attr_e('Return Date','school-mgt');?><span class="require-field">*</span></label>
													</div>
												</div>
											</div>
											<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
												<div class="form-group">
													<div class="col-md-12 form-control rtl_relative_position">
														<div class="row padding_radio">
															<div class="">
																<label class="custom-top-label label_position_rtl" for="enable"><?php esc_attr_e('Send Mail','school-mgt');?></label>
																<input id="chk_sms_sent1" type="checkbox" class="check_box_input_margin" <?php $smgt_issue_book_mail_service_enable = 0;if($smgt_issue_book_mail_service_enable) echo "checked";?> value="1" name="smgt_issue_book_mail_service_enable"> <?php esc_attr_e('Send Mail','school-mgt');?>
															</div>												
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="form-body user_form">
										<div class="row">
											<div class="col-sm-6">      
												<input type="submit" value="<?php esc_attr_e('Issue Book','school-mgt');?>" name="save_issue_book" class="save_btn btn btn-success book_for_alert rtl_margin_0px" />
											</div>    
										</div>
									</div>  
								</form>
							</div>
							<div class="panel-body mt-3">
								<div class="header">	
									<h3 class="first_hed"><?php esc_html_e('Issue Book List','school-mgt');?></h3>
								</div>
								<?php
								$issue_data = $obj_lib->mj_smgt_get_all_issuebooks_book_id($decoded_id);
								if(!empty($issue_data))
								{
									?>
									<script type="text/javascript">
										jQuery(document).ready(function($)
										{
											var table =  jQuery('#user_issue_list').DataTable({
												"initComplete": function(settings, json) {
													$(".print-button").css({"margin-top": "-5%"});
												},
												"dom": 'lifrtp',
												"order": [[ 2, "asc" ]],
												"aoColumns":[	                  
															{"bSortable": false},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},
															{"bSortable": true},	
															{"bSortable": false}
														],
												language:<?php echo mj_smgt_datatable_multi_language();?>
											});
											$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
										});
									</script>
									<div class="table-responsive">
										<form id="frm-example" name="frm-example" method="post">
											<table id="user_issue_list" class="display" cellspacing="0" width="100%">
												<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
													<tr>
														<th><?php esc_attr_e('Image', 'school-mgt');?></th>
														<th><?php esc_attr_e('User Name','school-mgt');?></th>
														<th><?php esc_attr_e('Issue Date','school-mgt');?></th>
														<th><?php esc_attr_e('Due Return Date ','school-mgt');?></th>
														<th><?php esc_attr_e('Accept Return Date ','school-mgt');?></th>
														<th><?php esc_attr_e('Period','school-mgt');?></th>
														<th><?php esc_attr_e('Status','school-mgt');?></th>
														<th><?php esc_attr_e('Fine','school-mgt');?></th>
														<th><?php esc_attr_e('Comment','school-mgt');?></th>
														<th class="text_align_end"><?php esc_attr_e('Action', 'school-mgt');?></th>
													</tr>
												</thead>
												<tbody>
													<?php
													$i=0;
													foreach ($issue_data as $retrieved_data) 
													{
														?>
														<tr>
															<td class="user_image width_50px"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/Library.png" ?>" class="img-circle" /></td>
															<td><?php echo mj_smgt_get_display_name($retrieved_data->student_id);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('User Name','school-mgt');?>" ></i></td>
															<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->issue_date);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Issue Date','school-mgt');?>" ></i> </td>
															<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->end_date);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Due Return Date','school-mgt');?>" ></i></td>
															<td><?php  if(!empty($retrieved_data->actual_return_date)){echo mj_smgt_getdate_in_input_box($retrieved_data->actual_return_date);}else{echo "N/A";}?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Accept Return Date','school-mgt');?>" ></i></td>
															<td><?php echo get_the_title($retrieved_data->period);?> <?php _e('Day','school-mgt') ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Period','school-mgt');?>" ></i></td>
															<td class="" >
																<?php 
																if($retrieved_data->status == "Issue")
																{ 
																	esc_attr_e('Issued','school-mgt');
																}
																elseif($retrieved_data->status == "Submitted")
																{ 
																	esc_attr_e('Returned','school-mgt');
																} ?> 
																
																<i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Status','school-mgt');?>" ></i></td>
															<td class="" ><?php if($retrieved_data->fine == "" || $retrieved_data->fine == 0){ echo 'N/A';}else{echo mj_smgt_get_currency_symbol().$retrieved_data->fine; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Fine','school-mgt');?>" ></i></td>
															<td class="" ><?php if($retrieved_data->comment == ""){ echo 'N/A';}else{echo $retrieved_data->comment; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php if($retrieved_data->comment == ""){ echo 'Comment';}else{echo $retrieved_data->comment; } ?> " ></i></td>
															<td class="action"> 
																<div class="smgt-user-dropdown">
																	<ul class="" style="margin-bottom: 0px !important;">
																		<li class="">
																			<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																				<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
																			</a>
																			<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
																				<?php
																				if($retrieved_data->status == "Issue")
																				{
																					?>
																					<li class="float_left_width_100">
																						<a idtest=<?php echo $retrieved_data->id;?> id="accept_returns_book_popup" class="float_left_width_100"><img src="<?php echo SMS_PLUGIN_URL."/assets/images/accept_book_return.png"?>" style="height:13px;">&nbsp;&nbsp;&nbsp;<?php esc_attr_e('Accept Returns','school-mgt');?> </a>
																					</li>
																					<?php
																				}
																				?>
																				
																			</ul>

																		</li>

																	</ul>

																</div>	

															</td>
														</tr>
														<?php
													}
													?>
												</tbody>
											</table>
										</form>
									</div>
									<?php
								}
								else
								{
									?>
									<div class="calendar-event-new"> 
										<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
									</div>	
									<?php
								}
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>