<?php

if(isset($_POST['date_type']))
{
    $selected_value=$_POST['date_type'];
}
else{
    $selected_value='this_month';
}

function is_selected($value, $selected_value) {
    return $value === $selected_value ? 'selected' : '';
}
?>
<div class="panel-body clearfix margin_top_20px rtl_margin_0px padding_top_15px_res"> <!------  penal body  -------->
    <div class="panel-body clearfix">
        <form method="post" id="student_attendance">  
            <div class="form-body user_form">
                <div class="row">
                    <div class="col-md-6 mb-6 input">
                        <label class="ml-1 custom-top-label top" for="class_id"><?php esc_attr_e('Date Type','school-mgt');?><span class="require-field">*</span></label>			
                        <select class="line_height_30px form-control date_type validate[required]" name="date_type" autocomplete="off">
                          
                                <option value=""><?php esc_attr_e('Select','school-mgt');?></option>
                                <option value="today" <?php echo is_selected('today', $selected_value); ?>><?php esc_attr_e('Today','school-mgt');?></option>
                                <option value="this_week" <?php echo is_selected('this_week', $selected_value); ?>><?php esc_attr_e('This Week','school-mgt');?></option>
                                <option value="last_week" <?php echo is_selected('last_week', $selected_value); ?> ><?php esc_attr_e('Last Week','school-mgt');?></option>
                                <option value="this_month" <?php echo is_selected('this_month', $selected_value); ?> ><?php esc_attr_e('This Month','school-mgt');?></option>
                                <option value="last_month" <?php echo is_selected('last_month', $selected_value); ?>><?php esc_attr_e('Last Month','school-mgt');?></option>
                                <option value="last_3_month" <?php echo is_selected('last_3_month', $selected_value); ?>><?php esc_attr_e('Last 3 Months','school-mgt');?></option>
                                <option value="last_6_month" <?php echo is_selected('last_6_month', $selected_value); ?>><?php esc_attr_e('Last 6 Months','school-mgt');?></option>
                                <option value="last_12_month" <?php echo is_selected('last_12_month', $selected_value); ?>><?php esc_attr_e('Last 12 Months','school-mgt');?></option>
                                <option value="this_year" <?php echo is_selected('this_year', $selected_value); ?>><?php esc_attr_e('This Year','school-mgt');?></option>
                                <option value="last_year" <?php echo is_selected('last_year', $selected_value); ?>><?php esc_attr_e('Last Year','school-mgt');?></option>
                                <option value="period" <?php echo is_selected('period', $selected_value); ?>><?php esc_attr_e('Period','school-mgt');?></option>
                        </select>
                    </div>
                    <div id="date_type_div" class="date_type_div_none col-md-6 mb-2"></div>	
                    <div class="col-md-3 mb-2">
                        <input type="submit" name="migration_report" Value="<?php esc_attr_e('Go','school-mgt');?>"  class="btn btn-info save_btn"/>
                    </div>
                </div>
            </div>
        </form> 
    </div>	

    <?php
    if(isset($_REQUEST['migration_report']))
    {
        $date_type = sanitize_text_field($_POST['date_type']);
        if($date_type=="period")
        {
            $start_date = sanitize_text_field($_REQUEST['start_date']);
            $end_date = sanitize_text_field($_REQUEST['end_date']);
        }
        else
        {
            $result =  mj_smgt_all_date_type_value($date_type);
            $response =  json_decode($result);
            $start_date = $response[0];
            $end_date = $response[1];
        }
    }
    else
    {
        $start_date = date('Y-m-d'); // Today's date
        $end_date = date('Y-m-t');   // Last day of the current month
    }
    global $wpdb;
    $table_smgt_migration_log=$wpdb->prefix.'smgt_migration_log';
    $report_6 = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM $table_smgt_migration_log WHERE created_at BETWEEN %s AND %s",$start_date,$end_date)
    );
    if(!empty($report_6))
    {
        ?>
          <script type="text/javascript">
            jQuery(document).ready(function($){
                var table = jQuery('#tble_audit_log_').DataTable({
                    "initComplete": function(settings, json) {
                        $(".print-button").css({"margin-top": "-55px"});
                    },
                    //stateSave: true,
                    "responsive": true,
                    "order": [[ 2, "Desc" ]],
                    "dom": 'lifrtp',
                    buttons:[
                        {
                            extend: 'csv',
                            text:'<?php echo esc_attr_e("csv","school-mgt"); ?>',
                            title: '<?php echo esc_attr_e("Migration Report","school-mgt"); ?>',
                        },
                        {
                            extend: 'print',
                            text:'<?php echo esc_attr_e("Print","school-mgt"); ?>',
                            title: '<?php echo esc_attr_e("Migration Report","school-mgt"); ?>',
                        },
                    ],
                    "aoColumns":[
                        {"bSortable": false},
                        {"bSortable": true},
                        {"bSortable": true},
                        {"bSortable": true},
                        {"bSortable": true},
                        {"bSortable": true},
                        {"bSortable": true},
                        {"bSortable": false},
                        {"bSortable": false}
                    ],
                    language:<?php echo mj_smgt_datatable_multi_language();?>
                });
                $('.btn-place').html(table.buttons().container()); 
                $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
                $("#delete_selected").on('click', function()
								{	
									if ($('.select-checkbox:checked').length == 0 )
									{
										confirm(language_translate2.one_record_select_alert);
										return false;
									}
									else
									{
											var alert_msg=confirm("<?php esc_html_e('Are you sure you want to delete this record?', 'school-mgt') ?>");
											if(alert_msg == false)
											{
												return false;
											}
											else
											{
												return true;
											}
									}
								});
								$('.select_all').on('click', function(e)
								{
									if($(this).is(':checked',true))  
									{
										$(".smgt_sub_chk").prop('checked', true);  
									}  
									else  
									{  
										$(".smgt_sub_chk").prop('checked',false);  
									} 
								});
								$('.smgt_sub_chk').on('change',function()
								{ 
									if(false == $(this).prop("checked"))
									{ 
										$(".select_all").prop('checked', false); 
									}
									if ($('.smgt_sub_chk:checked').length == $('.smgt_sub_chk').length )
									{
										$(".select_all").prop('checked', true);
									}
								});
								jQuery('#checkbox-select-all').on('click', function(){     
									var rows = table.rows({ 'search': 'applied' }).nodes();
									jQuery('input[type="checkbox"]', rows).prop('checked', this.checked);
								}); 
					});
        </script>
        <?php
        $obj_feespayment= new mj_smgt_feespayment();
        if(isset($_REQUEST['delete_selected_audit_log']))
        {		
            if(!empty($_REQUEST['id']))
            foreach($_REQUEST['id'] as $id)
                    $result = mj_smgt_delete_migration_log($id);
       
            if($result)
            { 
                ?>
                <div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible">
                    <p><?php esc_attr_e('Record Deleted Successfully.','school-mgt'); ?></p>
                    <button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
                </div>
                <?php 
            }
        }

        
        ?>
        <div class="panel-body padding_top_15px_res"> <!------  penal body  -------->
            <div class="btn-place"></div>
            <div class="table-responsive"> <!------  table Responsive  -------->
                <form id="frm-example" name="frm-example" method="post">
                    <table id="tble_audit_log_" class="display" cellspacing="0" width="100%">
                        <thead class="<?php echo MJ_smgt_datatable_heder() ?>">
                            <tr>
                                <th class="padding_0"><input type="checkbox" class=" multiple_select select_all" id="select_all"></th>
                                <th> <?php esc_attr_e( 'Date', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'IP Address', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'Current Class', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'Next Class', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'Exam', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'Passing Marks', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'Pass Student', 'school-mgt' ) ;?></th>
                                <th> <?php esc_attr_e( 'Faild Student', 'school-mgt' ) ;?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            foreach($report_6 as $result)
                            {
                                ?>
                                <tr>
                                    <td class="checkbox_width_10px"><input type="checkbox" class="smgt_sub_chk select-checkbox" name="id[]" value="<?php echo $result->id;?>"></td>
                                    <td class="status"><?php if(!empty($result->date_time)){ echo mj_smgt_getdate_in_input_box($result->date_time); }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php esc_html_e('Date & Time','school-mgt');?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->ip_address)){ echo $result->ip_address; }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo $result->ip_address;?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->current_class)){ echo mj_smgt_get_class_name($result->current_class); }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo mj_smgt_get_class_name($result->current_class);?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->next_class)){ echo mj_smgt_get_class_name($result->next_class); }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo mj_smgt_get_class_name($result->next_class);?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->exam_name) && $result->exam_name !== 0 ){ echo mj_smgt_get_exam_name_id($result->exam_name); }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo mj_smgt_get_exam_name_id($result->exam_name);?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->pass_mark)){ echo $result->pass_mark; }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo $result->pass_mark;?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->pass_students)){ echo MJ_smgt_get_pass_faild_string($result->pass_students); }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo MJ_smgt_get_pass_faild_string($result->pass_students);?>"></i></td>
                                    <td class="income_amount"><?php if(!empty($result->fail_students)){ echo MJ_smgt_get_pass_faild_string($result->fail_students); }else{ echo "N/A"; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="<?php echo MJ_smgt_get_pass_faild_string($result->fail_students);?>"></i></td>
                                </tr>
                                <?php 
                            } 
                            ?>     
                        </tbody>        
                    </table>
                    <div class="print-button pull-left">
                        <button class="btn-sms-color button_reload">
                            <input type="checkbox" name="id[]" class="smgt_sub_chk select_all" value="<?php echo esc_attr($result->id); ?>" style="margin-top: 0px;">
                            <label for="checkbox" class="margin_right_5px"><?php esc_html_e( 'Select All', 'school-mgt' ) ;?></label>
                        </button>
                            <button data-toggle="tooltip" id="delete_selected" title="<?php esc_html_e('Delete Selected','school-mgt');?>" name="delete_selected_audit_log" class="delete_selected" ><img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/Delete.png" ?>" alt=""></button>
                    </div>
                </form>
            </div> <!------  table responsive  -------->
        </div> <!------  penal body  -------->
        <?php
    }
    else
    {
        ?>
        <div class="calendar-event-new"> 
            <img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
        </div>	
        <?php
    }
    ?>
</div> <!------  penal body  -------->