<div class="panel-body clearfix margin_top_20px rtl_margin_0px padding_top_15px_res">
    <?php
   $chart_array[] = [esc_attr__('Teacher', 'school-mgt'), esc_attr__('No. of Students Failed', 'school-mgt')];
   global $wpdb;
   $table_name_mark = $wpdb->prefix . 'marks';
   $teachers = get_users(['role' => 'teacher']);
   $subject_fail_counts = []; // Stores failure count per teacher
   
   if (!empty($teachers)) {
       foreach ($teachers as $teacher) {
           $subject_ids = mj_smgt_get_subject_id_by_teacher($teacher->ID);
   
           if (!empty($subject_ids)) {
               $sub_str = implode(',', $subject_ids);
               $results = $wpdb->get_results(
                   "SELECT * FROM {$table_name_mark} WHERE subject_id IN ({$sub_str})",
                   ARRAY_A
               );
               $fail_count = 0;
               if (!empty($results)) {
                   foreach ($results as $result) {
                       $marks_total = ($result['contributions'] == "yes")
                           ? array_sum(json_decode($result['class_marks'], true) ?? [])
                           : (int) $result['marks'];
                        $exam_obj=new smgt_exam();
                        $exam_data=$exam_obj->mj_smgt_exam_data($result['exam_id']);
                        
                        if (($exam_data) && ($marks_total < $exam_data->passing_mark)) {
                           $fail_count++;
                       }
                   }
               }
   
               if ($fail_count > 0) {
                   $teacher_name = mj_smgt_get_display_name($teacher->ID);
                   $subject_fail_counts[$teacher_name] = $fail_count;
               }
           }
       }
   }
   
   // Populate the chart array
   if (!empty($subject_fail_counts)) {
       foreach ($subject_fail_counts as $teacher_name => $count) {
           $chart_array[] = [$teacher_name, $count];
       }
   }
   
   $color = get_option('smgt_system_color_code');
   $options = [
       'title' => esc_attr__('Teacher Performance Report', 'school-mgt'),
       'titleTextStyle' => [
           'color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false,
           'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'
       ],
       'legend' => [
           'position' => 'right',
           'textStyle' => [
               'color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false,
               'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'
           ]
       ],
       'hAxis' => [
           'title' => esc_attr__('Teacher Name', 'school-mgt'),
           'titleTextStyle' => [
               'color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false,
               'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'
           ],
           'textStyle' => [
               'color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false,
               'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'
           ],
           'maxAlternation' => 2
       ],
       'vAxis' => [
           'title' => esc_attr__('No. of Students', 'school-mgt'),
           'minValue' => 0,
           'format' => '#',
           'titleTextStyle' => [
               'color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false,
               'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'
           ],
           'textStyle' => [
               'color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false,
               'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'
           ]
       ],
       'colors' => [$color]
   ];
   
   if (!empty($subject_fail_counts)) {
       require_once SMS_PLUGIN_DIR . '/lib/chart/GoogleCharts.class.php';
       $GoogleCharts = new GoogleCharts;
       $chart = $GoogleCharts->load('column', 'chart_div')->get($chart_array, $options);
       ?>
   
       <div id="chart_div" class="w-100 h-100 margin_top_20px rtl_margin_0px padding_top_15px_res"></div>
   
       <!-- Javascript -->
       <script type="text/javascript" src="https://www.google.com/jsapi"></script>
       <script type="text/javascript">
           <?php echo $chart; ?>
       </script>
   
       <?php
   } else {
       ?>
       <div class="calendar-event-new">
           <img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>" >
       </div>
       <?php
   }
   ?>
   
</div>