<?php //-------- CHECK BROWSER JAVA SCRIPT ----------//
$custom_field_obj = new Smgt_custome_field;
$obj_leave = new SmgtLeave;
mj_smgt_browser_javascript_check();
$role = mj_smgt_get_user_role(get_current_user_id());
$module = 'student';
$user_custom_field = $custom_field_obj->mj_smgt_getCustomFieldByModule($module);
?>
<?php
if ($role == 'administrator') 
{
	$user_access_add = 1;
	$user_access_edit = 1;
	$user_access_delete = 1;
	$user_access_view = 1;
} else {
	$user_access = mj_smgt_get_userrole_wise_filter_access_right_array('student');
	$user_access_add = $user_access['add'];
	$user_access_edit = $user_access['edit'];
	$user_access_delete = $user_access['delete'];
	$user_access_view = $user_access['view'];
	
	if (isset($_REQUEST['page'])) {
		if ($user_access_view == '0') {
			mj_smgt_access_right_page_not_access_message_admin_side();
			die;
		}
		if (!empty($_REQUEST['action'])) {
			if ('student' == $user_access['page_link'] && ($_REQUEST['action'] == 'edit')) {
				if ($user_access_edit == '0') {
					mj_smgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
			if ('student' == $user_access['page_link'] && ($_REQUEST['action'] == 'delete')) {
				if ($user_access_delete == '0') {
					mj_smgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
			if ('student' == $user_access['page_link'] && ($_REQUEST['action'] == 'insert')) {
				if ($user_access_add == '0') {
					mj_smgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
		}
	}
}
?>
<script>
	//--------- Script Start ---------//
	jQuery(document).ready(function($) {
		"use strict";

		$('.sdate').datepicker({
			dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
			changeMonth: true,
			changeYear: true,
			maxDate: 0,
			beforeShow: function(textbox, instance) {
				instance.dpDiv.css({
					marginTop: (-textbox.offsetHeight) + 'px'
				});
			}
		});
		//-------- End date datepicker ---------//
		$('.edate').datepicker({
			dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
			maxDate: 0,
			changeMonth: true,
			changeYear: true,
			beforeShow: function(textbox, instance) {
				instance.dpDiv.css({
					marginTop: (-textbox.offsetHeight) + 'px'
				});
			}
		});
		//----------- Attendance List script ---------//
		var table = jQuery('#attendance_list').DataTable({
			responsive: true,
			"order": [
				[0, "DESC"]
			],
			dom: 'Bfrtip',
			buttons: [{
					extend: 'print',
					title: 'View Attendance',
				},
				{
					extend: 'pdf',
					title: 'View Attendance',
				},
				'csv'
			],
			"aoColumns": [{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": false
				}
			],
			language: <?php echo mj_smgt_datatable_multi_language(); ?>
		});
		$('#upload_form').validationEngine({
			promptPosition: "bottomLeft",
			maxErrorsPerField: 1
		});
		jQuery('#student_form').validationEngine({
			promptPosition: "bottomLeft",
			maxErrorsPerField: 1
		});
		jQuery('#birth_date').datepicker({
			dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
			maxDate: 0,
			changeMonth: true,
			changeYear: true,
			yearRange: '-65:+25',
			beforeShow: function(textbox, instance) {
				instance.dpDiv.css({
					marginTop: (-textbox.offsetHeight) + 'px'
				});
			},
			onChangeMonthYear: function(year, month, inst) {
				jQuery(this).val(month + "/" + year);
			}
		});
	
		$('#upload_form').validationEngine({
			promptPosition: "bottomLeft",
			maxErrorsPerField: 1
		});
		var table = jQuery('#exam_list').DataTable({
			responsive: true,
			"aoColumns": [{
					"bSortable": true
				},
				{
					"bSortable": false
				}
			],
			language: <?php echo mj_smgt_datatable_multi_language(); ?>
		});
		$(".view_more_details_div").on("click", ".view_more_details", function(event) {
			$('.view_more_details_div').removeClass("d-block");
			$('.view_more_details_div').addClass("d-none");
			$('.view_more_details_less_div').removeClass("d-none");
			$('.view_more_details_less_div').addClass("d-block");
			$('.user_more_details').removeClass("d-none");
			$('.user_more_details').addClass("d-block");
		});
		$(".view_more_details_less_div").on("click", ".view_more_details_less", function(event) {
			$('.view_more_details_div').removeClass("d-none");
			$('.view_more_details_div').addClass("d-block");
			$('.view_more_details_less_div').removeClass("d-block");
			$('.view_more_details_less_div').addClass("d-none");
			$('.user_more_details').removeClass("d-block");
			$('.user_more_details').addClass("d-none");
		});
		//------------ Parent List JS ----------//
		var table = jQuery('#parents_list').DataTable({
			responsive: true,
			"order": [
				[0, "DESC"]
			],
			"aoColumns": [{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": true
				},
				{
					"bSortable": true
				}
			],
			language: <?php echo mj_smgt_datatable_multi_language(); ?>
		});
	});
</script>
<!--------- Script Start --------->
<?php
$custom_field_obj = new Smgt_custome_field;
$obj_mark = new Marks_Manage();
$role	= 'student';
//--------- Save Active User ------------//
if (isset($_POST['active_user'])) {
	$class = get_user_meta(intval($_REQUEST['act_user_id']), 'class_name', true);
	$args = array(
		'meta_query'	=>
		array(
			'relation' => 'AND',
			array('key'	=> 'class_name', 'value' => $class),
			array('key' => 'roll_id', 'value' => sanitize_text_field($_REQUEST['roll_id']))
		),
		'role' => 'student'
	);
	$userbyroll_no	=	get_users($args);
	$is_rollno = count($userbyroll_no);
	if ($is_rollno) {
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=3');
	} else {
		update_user_meta($_POST['act_user_id'], "roll_id", $_POST['roll_id']);
		if (isset($_POST['smgt_student_mail_service_enable']) || isset($_POST['smgt_studnet_sms_service_enable'])) {
			if (isset($_POST['smgt_student_mail_service_enable'])) {
				$active_user_id		= 	intval($_REQUEST['act_user_id']);
				$class_name		=	get_user_meta($active_user_id, 'class_name', true);
				$user_info 	= 	get_userdata(sanitize_text_field($_POST['act_user_id']));
				$to 	= 	$user_info->user_email;
				$subject	= 	get_option('student_activation_title');
				$Seach['{{student_name}}']	 =	 $user_info->display_name;
				$Seach['{{user_name}}']		 =	 $user_info->user_login;
				$Seach['{{class_name}}']	 =	 mj_smgt_get_class_name($class_name);
				$Seach['{{email}}']			 =	 $to;
				$Seach['{{school_name}}']	 =	 get_option('smgt_school_name');
				$MsgContent 	= 	mj_smgt_string_replacement($Seach, get_option('student_activation_mailcontent'));
				mj_smgt_send_mail($to, $subject, $MsgContent);
				//----------- STUDENT ASSIGNED TEACHER MAIL ------------//
				$TeacherIDs = mj_smgt_check_class_exits_in_teacher_class($class_name);
				$TeacherEmail = array();
				$string['{{school_name}}']  = get_option('smgt_school_name');
				$string['{{student_name}}'] =  mj_smgt_get_display_name($_POST['act_user_id']);
				$subject = get_option('student_assign_teacher_mail_subject');
				$MessageContent = get_option('student_assign_teacher_mail_content');
				foreach ($TeacherIDs as $teacher) {
					$TeacherData = get_userdata($teacher);
					$string['{{teacher_name}}'] = mj_smgt_get_display_name($TeacherData->ID);
					$message = mj_smgt_string_replacement($string, $MessageContent);
					mj_smgt_send_mail($TeacherData->user_email, $subject, $message);
				}
			}
			/* Approved SMS Notification */
			if (isset($_POST['smgt_studnet_sms_service_enable'])) {
				$message_content = "Your account with " . get_option('smgt_school_name') . " is approved";
				$type = "Attendance";
				$sms = MJ_smgt_send_sms_notification($_POST['act_user_id'], $type, $message_content);
			}
		}
		$active_user_id	= $_REQUEST['act_user_id'];
		if (get_user_meta($active_user_id, 'hash', true))
			delete_user_meta($active_user_id, 'hash');
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=7');
	}
}
if (isset($_POST['approve_comment'])) {
	$result = $obj_leave->hrmgt_approve_leave($_POST);
	if ($result) 
	{
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=view_student&tab1=leave_list&student_id=' . $_REQUEST["student_id"] . '&message=12&_wpnonce='.MJ_smgt_get_nonce('view_action').'');
	} 
	else 
	{
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=view_student&tab1=leave_list&student_id=' . $_REQUEST["student_id"] . '&message=14&_wpnonce='.MJ_smgt_get_nonce('view_action').'');
	}
}
if (isset($_POST['reject_leave'])) 
{
	$result = $obj_leave->hrmgt_reject_leave($_POST);
	if ($result) {
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=view_student&tab1=leave_list&student_id=' . $_REQUEST["student_id"] . '&message=13&_wpnonce='.MJ_smgt_get_nonce('view_action').'');
	} else {
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=view_student&tab1=leave_list&student_id=' . $_REQUEST["student_id"] . '&message=14&_wpnonce='.MJ_smgt_get_nonce('view_action').'');
	}
}
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete' && $_REQUEST['leave_id']) 
{
	if (isset($_GET['_wpnonce_action']) && wp_verify_nonce($_GET['_wpnonce_action'], 'delete_action')) 
    {
		echo "Hello123";
		$result = $obj_leave->hrmgt_delete_leave(MJ_smgt_decrypt_id($_REQUEST['leave_id']));
		if ($result) { 
			wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=view_student&tab1=leave_list&student_id=' . $_REQUEST["student_id_action"] . '&message=11&_wpnonce='.MJ_smgt_get_nonce('view_action').'');
		}
	} 
	else 
	{
		wp_die('Security check failed!');
	}

}
// Export Student CSV File Code 
if (isset($_REQUEST['exportstudentin_csv'])) 
{
	if ($_POST['class_name'] != "" && $_POST['class_section'] == "") //------- Only Class Select -------//
	{
		$student_list = get_users(array('meta_key' => 'class_name', 'meta_value' => $_POST['class_name'], 'role' => 'student'));
	} elseif ($_POST['class_section'] != "") //--------- Class Section ----------//
	{
		$args = array(
			'role' => 'student',
			'meta_query' => array(
				array(
					'key' => 'class_name',
					'value' => $_POST['class_name'],
				),
				array(
					'key' => 'class_section',
					'value' => $_POST['class_section']
				)
			)
		);
		$student_list = get_users($args);
	} else {
		$student_list = get_users(array('role' => 'student'));
	}
	//----- CSV File Add Custom export csv File ------//
	foreach ($student_list as $retrive_data) {
		$student_array[] = $retrive_data->ID;
		$student_id = implode(',', $student_array);
	}
	$module = 'student';
	$module_record_id = $student_id;
	$custom_field_obj = new Smgt_custome_field;
	$all_custom_field_name = $custom_field_obj->mj_smgt_getCustomFieldByModule($module);
	if (!empty($student_list)) {
		$header = array();
		$header[] = 'Username';
		$header[] = 'Email';
		$header[] = 'Password';
		$header[] = 'Roll No';
		$header[] = 'Class Name';
		$header[] = 'Class Section';
		$header[] = 'First Name';
		$header[] = 'Middle Name';
		$header[] = 'Last Name';
		$header[] = 'Gender';
		$header[] = 'Birth Date';
		$header[] = 'Address';
		$header[] = 'City Name';
		$header[] = 'State Name';
		$header[] = 'Zip Code';
		$header[] = 'Mobile Number';
		$header[] = 'Alternate Mobile Number';
		$header[] = 'user_profile';
		//-----add custom filed label in excel sheet  ----//
		foreach ($all_custom_field_name as $custom_field) {
			$header[] = $custom_field->field_label;
		}
		$filename = 'Reports/export_student.csv';
		$fh = fopen(SMS_PLUGIN_DIR . '/admin/' . $filename, 'w') or die("can't open file");
		fputcsv($fh, $header);
		foreach ($student_list as $retrive_data) {
			$uid = $retrive_data->ID;
			$umetadata = mj_smgt_get_user_image($uid);
			$row = array();
			$user_info = get_userdata($retrive_data->ID);
			$row[] = $user_info->user_login;
			$row[] = $user_info->user_email;
			$row[] = '';
			$row[] =  get_user_meta($retrive_data->ID, 'roll_id', true);
			$class_id =  get_user_meta($retrive_data->ID, 'class_name', true);
			$classname = mj_smgt_get_class_name($class_id);
			$row[] = $classname;
			$class_section_id =  get_user_meta($retrive_data->ID, 'class_section', true);
			$class_sections_name = mj_smgt_get_class_sections_name($class_section_id);
			$row[] = $class_sections_name;
			$row[] =  get_user_meta($retrive_data->ID, 'first_name', true);
			$row[] =  get_user_meta($retrive_data->ID, 'middle_name', true);
			$row[] =  get_user_meta($retrive_data->ID, 'last_name', true);
			$row[] =  get_user_meta($retrive_data->ID, 'gender', true);
			$row[] =  get_user_meta($retrive_data->ID, 'birth_date', true);
			$row[] =  get_user_meta($retrive_data->ID, 'address', true);
			$row[] =  get_user_meta($retrive_data->ID, 'city', true);
			$row[] =  get_user_meta($retrive_data->ID, 'state', true);
			$row[] =  get_user_meta($retrive_data->ID, 'zip_code', true);
			$row[] =  get_user_meta($retrive_data->ID, 'mobile_number', true);
			$row[] =  get_user_meta($retrive_data->ID, 'alternet_mobile_number', true);
			$uid = $retrive_data->ID;
			$umetadata = mj_smgt_get_user_image($uid);
			if (!empty($umetadata)) {
				$row[] =  $umetadata;
			} else {
				$row[] = '';
			}
			//-----add custom filed value in excel sheet  ----//
			foreach ($all_custom_field_name as $custom_field) {
				//$row[] = $custom_field->id;
				$all_custom_field_value = $custom_field_obj->mj_smgt_get_single_field_value_meta_value_by_filed_and_student_id($retrive_data->ID, $custom_field->id);
				if ($custom_field->field_type == "file") {
					$row[] = content_url() . '/uploads/school_assets/' . $all_custom_field_value;
				} else {
					$row[] = $all_custom_field_value;
				}
			}
			fputcsv($fh, $row);
		}
		fclose($fh);
		//download csv file.
		ob_clean();
		$file = SMS_PLUGIN_DIR . '/admin/Reports/export_student.csv'; //file location
		$mime = 'text/plain';
		header('Content-Type:application/force-download');
		header('Pragma: public');       // required
		header('Expires: 0');           // no cache
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($file)) . ' GMT');
		header('Cache-Control: private', false);
		header('Content-Type: ' . $mime);
		header('Content-Disposition: attachment; filename="' . basename($file) . '"');
		header('Content-Transfer-Encoding: binary');
		//header('Content-Length: '.filesize($file_name));      // provide file size
		header('Connection: close');
		readfile($file);
		exit;
	} else {
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&message=10');
	}
}
//--------- Save Student -----------//
if (isset($_POST['save_student'])) {
	
	$nonce = $_POST['_wpnonce'];
	if (wp_verify_nonce($nonce, 'save_teacher_admin_nonce')) {
		$firstname	=	sanitize_text_field($_POST['first_name']);
		$lastname	=	sanitize_text_field($_POST['last_name']);
		$middlename = sanitize_text_field($_POST['middle_name']);
		$userdata 	= 	array(
			'user_login'	=>	sanitize_email($_POST['email']),
			'user_nicename'	=>	NULL,
			'user_email'	=>	sanitize_email($_POST['email']),
			'user_url'		=>	NULL,
			'display_name'	=>	$firstname . " " . $middlename . " " . $lastname,
		);
		//--------- Password & Email Varification --------//
		if ($_POST['password'] != "")
			$userdata['user_pass'] = mj_smgt_password_validation($_POST['password']);
		if (isset($_POST['smgt_user_avatar']) && $_POST['smgt_user_avatar'] != "") {
			$photo	=	$_POST['smgt_user_avatar'];
		} else {
			$photo	=	"";
		}
		if (get_option('smgt_enable_virtual_classroom') == 'yes') {
			$zoom_add_status = 'yes';
		} else {
			$zoom_add_status = 'no';
		}
		if (isset($_POST['phone']) && $_POST['phone'] != "") {
			$phone	=	sanitize_text_field($_POST['phone']);
		} else {
			$phone	= "";
		}
		
		// DOCUMENT UPLOAD FILE CODE START
		$document_content = array();
		if(!empty($_FILES['document_file']['name']))
		{
			$count_array=count($_FILES['document_file']['name']);
			for ($a = 0; $a < $count_array; $a++) 
			{
				if(($_FILES['document_file']['size'][$a] > 0) && (!empty($_POST['document_title'][$a])))
				{
					$document_title = $_POST['document_title'][$a];
					$document_file = MJ_smgt_upload_document_user_multiple($_FILES['document_file'],$a,$_POST['document_title'][$a]);
				}
				elseif(!empty($_POST['user_hidden_docs'][$a]) && !empty($_POST['document_title'][$a]))
				{
					$document_title = $_POST['document_title'][$a];
					$document_file = $_POST['user_hidden_docs'][$a];
				}
				if(!empty($document_file) && !empty($document_title))
				{
					$document_content[] = array('document_title'=>$document_title,'document_file'=>$document_file);
				}
			}
		}
		
		if(!empty($document_content)){ $final_document = json_encode($document_content); }else{ $final_document = '';}
		// DOCUMENT UPLOAD FILE CODE END
	
		$usermetadata	=	array(
			'roll_id'	=>	sanitize_textarea_field($_POST['roll_id']),
			'middle_name'	=>	sanitize_text_field($_POST['middle_name']),
			'gender'	=>	sanitize_text_field($_POST['gender']),
			'birth_date' =>	sanitize_text_field($_POST['birth_date']),
			'address'	=>	sanitize_textarea_field($_POST['address']),
			'city'		=>	sanitize_text_field($_POST['city_name']),
			'state'		=>	sanitize_text_field($_POST['state_name']),
			'zip_code'	=>	sanitize_text_field($_POST['zip_code']),
			'class_name'	=>	sanitize_text_field($_POST['class_name']),
			'class_section'	=>	sanitize_text_field($_POST['class_section']),
			'phone'		=>	sanitize_text_field($phone),
			'mobile_number'	=>	sanitize_text_field($_POST['mobile_number']),
			'user_document' => $final_document,
			'alternet_mobile_number'	=>	sanitize_text_field($_POST['alternet_mobile_number']),
			'smgt_user_avatar'	=>	$photo,
			'zoom_add_status'	=>	$zoom_add_status,
			'created_by' => get_current_user_id()
		);
		$userbyroll_no	=	get_users(
			array(
				'meta_query'	=>
				array(
					'relation' => 'AND',
					array('key'	=> 'class_name', 'value' => sanitize_text_field($_POST['class_name'])),
					array('key' => 'roll_id', 'value' => sanitize_text_field($_POST['roll_id']))
				),
				'role' => 'student'
			)
		);
		$is_rollno = count($userbyroll_no);
		if ($_REQUEST['action'] == 'edit') //--------- Edit Student ----------//
		{
			$student_id=intval(MJ_smgt_decrypt_id($_REQUEST['student_id']));
		if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) 
           {
				$userdata['ID']	=	$student_id;
				$roll_no_cheack = mj_smgt_cheack_student_rollno_exist_or_not(sanitize_text_field($_POST['roll_id']), sanitize_text_field($_POST['class_name']), $student_id);
				if ($roll_no_cheack == 1) {
					$result	=	mj_smgt_update_user($userdata, $usermetadata, $firstname, $middlename, $lastname, $role);
					$student = $userdata['display_name'];
					school_append_audit_log('' . esc_html__('Student Updated', 'school-mgt') . '(' . $student . ')' . '', $student_id, get_current_user_id(), 'edit', $_REQUEST['page']);
					// Custom Field File Update //
					$module = "student";
					$custom_field_update = $custom_field_obj->MJ_smgt_update_custom_field_data_module_vise($module,$result);
					wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=2');
				} else 
				{
					wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=3');
				}
			} 
			else 
			{
				wp_die('Security check failed!');
			}
		} else //---------- Insert Student -----------//
		{
			/* Setup Wizard */
			smgt_setup_wizard_steps_updates('step6_student');
			if (!email_exists($_POST['email'])) {
				if ($is_rollno) {
					wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=3');
				} else {
					$result	= mj_smgt_add_newuser($userdata, $usermetadata, $firstname, $middlename, $lastname, $role);
					$student = $userdata['display_name'];
					school_append_audit_log('' . esc_html__('Student Added', 'school-mgt') . '(' . $student . ')' . '', $result, get_current_user_id(), 'insert', $_REQUEST['page']);
					// Custom Field File Insert //
					$module = "student";
					$insert_custom_data = $custom_field_obj->MJ_smgt_insert_custom_field_data_module_vise($module,$result);
					if ($result) {
						wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=1');
					}
				}
			} else {
				wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=4');
			}
		}
	}
}
// -----------Delete Student Code -------- //
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete') {
   if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) 
    {
		$student_id=intval(MJ_smgt_decrypt_id($_REQUEST['student_id']));
		$childs = get_user_meta(intval($student_id), 'parent_id', true);
		if (!empty($childs)) {
			foreach ($childs as $key => $childvalue) {
				$parents = get_user_meta($childvalue, 'child', true);
				if (!empty($parents)) {
					if (($key = array_search(intval($student_id), $parents)) !== false) {
						unset($parents[$key]);
						update_user_meta($childvalue, 'child', $parents);
					}
				}
			}
		}
		$result = mj_smgt_delete_usedata(intval($student_id));
		if ($result) {
			wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=5');
		}
	} 
	else 
	{
		wp_die('Security check failed!');
	}
}
//------- multiple Student record delete code -------//
if (isset($_REQUEST['delete_selected'])) {
	if (!empty($_REQUEST['id']))
		foreach ($_REQUEST['id'] as $id) {
			$childs = get_user_meta($id, 'parent_id', true);
			if (!empty($childs)) {
				foreach ($childs as $key => $childvalue) {
					$parents = get_user_meta($childvalue, 'child', true);
					if (!empty($parents)) {
						if (($key = array_search($id, $parents)) !== false) {
							unset($parents[$key]);
							update_user_meta($childvalue, 'child', $parents);
						}
					}
				}
			}
			$result = mj_smgt_delete_usedata($id);
		}
	if ($result) {
		wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=5');
	}
}
//---------- Student Print ------------//
if (isset($_REQUEST['print']) && $_REQUEST['print'] == 'pdf') 
{
	$sudent_id = intval(MJ_smgt_decrypt_id($_REQUEST['student']));
	mj_smgt_downlosd_smgt_result_pdf($sudent_id);
}
//------ upload CSV Code  -----------//
if (isset($_REQUEST['upload_csv_file'])) 
{
	$nonce = $_POST['_wpnonce'];
	if (wp_verify_nonce($nonce, 'upload_teacher_admin_nonce')) 
	{
		if (isset($_FILES['csv_file'])) {
			$errors = array();
			$file_name = sanitize_file_name($_FILES['csv_file']['name']);
			$file_size = $_FILES['csv_file']['size'];
			$file_tmp = $_FILES['csv_file']['tmp_name'];
			$file_type = $_FILES['csv_file']['type'];
			$value = explode(".", $_FILES['csv_file']['name']);
			$file_ext = strtolower(array_pop($value));
			$extensions = array("csv");
			$upload_dir = wp_upload_dir();
			if (in_array($file_ext, $extensions) === false) {
				$err = esc_attr__('This file not allowed, please choose a CSV file.', 'school-mgt');
				$errors[] = $err;
				wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=uploadstudent&message=8');
			}
			//------------ Check File Size ------------//
			if ($file_size > 2097152) {
				$errors[] = 'File size limit 2 MB';
				wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=uploadstudent&message=9');
			}
			if (empty($errors) == true) {
				$rows = array_map('str_getcsv', file($file_tmp));
				$header = array_map('trim', array_map('strtolower', array_shift($rows)));
				$arraycheck = array('username', 'email', 'password', 'roll no', 'class name', 'class section', 'first name', 'middle name', 'last name', 'gender', 'birth date', 'address', 'city name', 'state name', 'zip code', 'mobile number', 'alternate mobile number', 'user_profile');
				$fields = array_diff($header, $arraycheck);
				$csv = array();
				$user_created=false;
				foreach ($rows as $row)
				 {
					$csv = array_combine($header, $row);
					$custom_fields = array();
					$username = sanitize_email($csv['username']);
					$email = sanitize_email($csv['email']);
					$user_id = 0;
					if (isset($csv['password'])) {
						$password = $csv['password'];
					} else {
						$password = rand();
					}
					$problematic_row = false;
					$studentExists = true;
					if (username_exists($username)) 
					{ // if user exists, we take his ID by login
						$user_object = get_user_by("login", $username);
						$user_id = $user_object->ID;
						$role_name = mj_smgt_get_user_role($user_id);
						if($role_name != "administrator")
						{
							if (!empty($password))
							wp_set_password($password, $user_id);
						}
						
					} 
					elseif (email_exists($email)) 
					{ // if the email is registered, we take the user from this
						$user_object = get_user_by("email", $email);
						$user_id = $user_object->ID;
						$problematic_row = true;
						$role_name = mj_smgt_get_user_role($user_id);
						if($role_name != "administrator")
						{
							if (!empty($password))
								wp_set_password($password, $user_id);
						}
					} 
					else 
					{
						$studentExists = false;
						if (empty($password)) // if user not exist and password is empty but the column is set, it will be generated
							$password = wp_generate_password();
						$user_id = wp_create_user($username, $password, $email);
						if($user_id)
						{
							$user_created=true;
						}
					}
					if (is_wp_error($user_id)) { // in case the user is generating errors after this checks
						echo '<script>alert("Problems with user: ' . $username . ', we are going to skip");</script>';
						continue;
					}

					if($role_name != "administrator")
					{
						$studentClass = get_user_meta($user_id, "class_name", true);
						wp_update_user(array('ID' => $user_id, 'role' => 'student'));
						$user = new WP_User($user_id);
						$user->add_role('subscriber');
					}
					
					update_user_meta($user_id, "active", true);
					update_user_meta($user_id, "class_name", $_POST['class_name']);
					$userbyroll_no	=	get_users(
						array(
							'meta_query'	=>
							array(
								'relation' => 'AND',
								array('key'	=> 'class_name', 'value' => $_POST['class_name']),
								array('key' => 'roll_id', 'value' => $csv['roll no'])
							),
							'role' => 'student'
						)
					);
					$rollReset = true;
					if ($studentExists) {
						$rollReset = false;
					} else {
						// student not exists
						if (count($userbyroll_no) || $csv['roll no'] == '') {  // roll exists
							$rollReset = true;
						} else { // roll not exists
							$rollReset = false;
						}
					}
					if ($rollReset) {
						$roll = "";
						add_user_meta($user_id, 'hash', rand());
					} else {
						$roll = $csv['roll no'];
					}
					//---------- Student Record Insert ----------//
					$user_id1 = wp_update_user(array('ID' => $user_id, 'display_name' => $csv['first name'] . ' ' . $csv['middle name'] . ' ' . $csv['last name']));
					if (isset($_POST['class_section']))
						update_user_meta($user_id, "class_section", sanitize_text_field($_POST['class_section']));
					if (isset($csv['roll no']))
						update_user_meta($user_id, "roll_id", $roll);
					if (isset($csv['first name']))
						update_user_meta($user_id, "first_name", sanitize_text_field($csv['first name']));
					if (isset($csv['last name']))
						update_user_meta($user_id, "last_name", sanitize_text_field($csv['last name']));
					if (isset($csv['middle name']))
						update_user_meta($user_id, "middle_name", sanitize_text_field($csv['middle name']));
					if (isset($csv['gender']))
						update_user_meta($user_id, "gender", sanitize_text_field($csv['gender']));
					if (isset($csv['birth date']))
						update_user_meta($user_id, "birth_date", sanitize_text_field($csv['birth date']));
					if (isset($csv['address']))
						update_user_meta($user_id, "address", sanitize_textarea_field($csv['address']));
					if (isset($csv['city name']))
						update_user_meta($user_id, "city", sanitize_text_field($csv['city name']));
					if (isset($csv['state name']))
						update_user_meta($user_id, "state", sanitize_text_field($csv['state name']));
					if (isset($csv['zip code']))
						update_user_meta($user_id, "zip_code", sanitize_text_field($csv['zip code']));
					if (isset($csv['mobile number']))
						update_user_meta($user_id, "mobile_number", sanitize_text_field($csv['mobile number']));
					if (!empty($csv['user_profile'])) {
						$upload_dir   = wp_upload_dir();
						$photo = $upload_dir['baseurl'] . '/' . $csv['user_profile'];
						update_user_meta($user_id, "smgt_user_avatar", $photo);
					}
					if (isset($csv['alternate mobile number']))
						update_user_meta($user_id, "alternet_mobile_number", sanitize_text_field($csv['alternate mobile number']));
					if (isset($csv['phone number']))
						update_user_meta($user_id, "phone", sanitize_text_field($csv['phone number']));
					foreach ($fields as $field_name) {
						global $wpdb;
						$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
						$custom_field = mj_smgt_get_single_custom_field_data_by_name($field_name);
						if ($custom_field->field_type == "date") {
							$field_value = date("Y-m-d", strtotime($csv[$field_name]));
						} elseif ($custom_field->field_type == "file") {
							if (!empty($csv[$field_name])) {
								$upload_dir   = wp_upload_dir();
								$field_value = $csv[$field_name];
							} else {
								$field_value = '';
							}
						} else {
							$field_value = $csv[$field_name];
						}
						$custom_meta_data['module'] = 'student';
						$custom_meta_data['module_record_id'] = $user_id;
						$custom_meta_data['custom_fields_id'] = $custom_field->id;
						$custom_meta_data['field_value'] = $field_value;
						$custom_meta_data['created_at'] = date("Y-m-d H:i:s");
						$custom_meta_data['updated_at'] = date("Y-m-d H:i:s");
						$insert_custom_meta_data = $wpdb->insert($wpnc_custom_field_metas, $custom_meta_data);
					}
					if ($user_created) 
					{
						if ($_REQUEST['smgt_import_student_mail'] == '1') 
						{
							if ($user_id) 
							{
								$userdata = get_userdata($user_id);
								$string = array();
								$string['{{user_name}}']   =  $userdata->display_name;
								$string['{{school_name}}'] =  get_option('smgt_school_name');
								$string['{{role}}']        =  'student';
								$string['{{login_link}}']  =  site_url() . '/index.php/school-management-login-page';
								$string['{{username}}']    =  $userdata->user_email;
								$string['{{Password}}']    =  $password;
								$MsgContent                =  get_option('add_user_mail_content');
								$MsgSubject				   =  get_option('add_user_mail_subject');
								$message = mj_smgt_string_replacement($string, $MsgContent);
								$MsgSubject = mj_smgt_string_replacement($string, $MsgSubject);
								$email =  $userdata->user_email;
								mj_smgt_send_mail($email, $MsgSubject, $message);
							}
						}
				    }
				}
				$success = 1;
			} 
			else 
			{
				foreach ($errors as &$error) echo $error;
			}
			if (isset($success)) 
			{
				wp_redirect(admin_url() . 'admin.php?page=smgt_student&tab=studentlist&message=6');
			}
		}
	}
	else 
	{
		wp_die('Security check failed!');
	}
}

	$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'studentlist';
	?>
	<div class="page-inner"><!--------- page inner -------->
		<div class="main_list_margin_15px"><!----- list page padding --------->
			<?php
			//---------- Student Messages ---------//
			$message = isset($_REQUEST['message']) ? $_REQUEST['message'] : '0';
			switch ($message) {
				case '1':
					$message_string = esc_attr__('Student Added Successfully.', 'school-mgt');
					break;
				case '2':
					$message_string = esc_attr__('Student Updated Successfully.', 'school-mgt');
					break;
				case '3':
					$message_string = esc_attr__('Student Roll No. Already Exist.', 'school-mgt');
					break;
				case '4':
					$message_string = esc_attr__("Student's Username Or Email-id Already Exist.", 'school-mgt');
					break;
				case '5':
					$message_string = esc_attr__('Student Deleted Successfully.', 'school-mgt');
					break;
				case '6':
					$message_string = esc_attr__('Student CSV Uploaded Successfully.', 'school-mgt');
					break;
				case '7':
					$message_string = esc_attr__('Student Record Approved Successfully.', 'school-mgt');
					break;
				case '8':
					$message_string = esc_attr__('This file not allowed, please choose a CSV file.', 'school-mgt');
					break;
				case '9':
					$message_string = esc_attr__('File size limit 2 MB.', 'school-mgt');
					break;
				case '10':
					$message_string = esc_attr__('Records not found.', 'school-mgt');
					break;
				case '11':
					$message_string = esc_attr__('Leave Deleted Successfully', 'school-mgt');
					break;
				case '12':
					$message_string = esc_attr__('Leave Approved Successfully', 'school-mgt');
					break;
				case '13':
					$message_string = esc_attr__('Leave Rejected Successfully', 'school-mgt');
					break;
				case '14':
					$message_string = esc_attr__('Oops, Something went wrong.', 'school-mgt');
					break;
			}
			if ($message) { ?>
				<div id="message" class="alert message_disabled_css below-h2 notice is-dismissible alert-dismissible" style="margin: 7px -10px !important">
					<p><?php echo $message_string; ?></p>
					<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span class="screen-reader-text">Dismiss this notice.</span></button>
				</div>
			<?php
			} ?>
			<div class="row"> <!------- Row Div --------->
				<div class="col-md-12 padding_0">
					<div class="smgt_main_listpage">
						<?php
						//---------- Student list tab --------//
						if ($active_tab == 'studentlist') 
						{
							require_once SMS_PLUGIN_DIR . '/admin/includes/student/student_list.php';
						}
						if ($active_tab == 'addstudent') {
							require_once SMS_PLUGIN_DIR . '/admin/includes/student/student.php';
						}
						if ($active_tab == 'uploadstudent') {
							require_once SMS_PLUGIN_DIR . '/admin/includes/student/uploadstudent.php';
						}
						if ($active_tab == 'view_student') {
							require_once SMS_PLUGIN_DIR . '/admin/includes/student/view_student.php';
						}
						if ($active_tab == 'exportstudent') {
							require_once SMS_PLUGIN_DIR . '/admin/includes/student/exportstudent.php';
						}
						if ($active_tab == 'view_exam_receipt') {
							require_once SMS_PLUGIN_DIR . '/admin/includes/student/view_exam_receipt.php';
						}
						?>
					</div>
				</div>
			</div>
		</div><!------- Row Div --------->
	</div><!----- list page padding --------->
	</div> <!--------- page inner -------->
<?php
?>