<script>
    //--------- Script Start ---------//
    jQuery(document).ready(function($) 
    {
        "use strict";
        var table = jQuery('#students_list').DataTable({
            "bProcessing": true,
            "bServerSide": true,
            "sAjaxSource": ajaxurl + '?action=mj_smgt_student_list',
            "bDeferRender": true,
            "initComplete": function(settings, json) 
            {
                jQuery('.table-responsive').show();
                jQuery(".loader").hide();
                jQuery(".print-button").css({
                    "margin-top": "-55px"
                });
                jQuery('#students_list th:first-child').removeClass('sorting_asc');
            },
            "dom": 'lifrtp',
            "ordering": true,
            "aoColumns": [
                { "bSortable": false }, // Checkbox
                { "bSortable": false }, // User image
                { "bSortable": true },  // Name & Email
                { "bSortable": true },  // Name & Email
                { "bSortable": true },  // Name & Email
                { "bSortable": true },  // Name & Email
                { "bSortable": true },  // Name & Email
                { "bSortable": true },  // Name & Email
               { "bSortable": true },  // Name & Email */
            ],
            "language": <?php echo mj_smgt_datatable_multi_language(); ?>
        });


        $('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
        //-------- Select All --------//
        $('.select_all').on('click', function(e) {
            if ($(this).is(':checked', true)) {
                $(".smgt_sub_chk").prop('checked', true);
            } else {
                $(".smgt_sub_chk").prop('checked', false);
            }
        });
        //---------- check box check JS ---------//
        $('.smgt_sub_chk').on('change', function() {
            var totalCheckboxes = $('.smgt_sub_chk').length - 2;
            var checkedCheckboxes = $('.smgt_sub_chk:checked').length;
            console.log(totalCheckboxes, checkedCheckboxes);
            // If all are checked, check "Select All"; otherwise, uncheck it
            if (totalCheckboxes === checkedCheckboxes) {
                $(".select_all").prop('checked', true);
            }
            if (false == $(this).prop("checked")) {
                $(".select_all").prop('checked', false);
            }
        });
        // delete selected on click event 
        $("#delete_selected").on('click', function() {
            if ($('.smgt_sub_chk:checked').length == 0) {
                alert(language_translate2.one_record_select_alert);
                return false;
            } else {
                var alert_msg = confirm(language_translate2.delete_record_alert);
                if (alert_msg == false) {
                    return false;
                } else {
                    return true;
                }
            }
        });
        $("body").on("click", ".print_id_card", function() {
            if ($('.check_for_id:checked').length == 0) {
                alert(language_translate2.one_record_select_alert);
                return false;
            }
        });
    });
</script>
<div class="popup-bg">
    <div class="overlay-content max_height_overflow">
        <div class="modal-content">
            <div class="result"></div>
            <div class="view-parent"></div>
            <div class="student_list">
            </div>
            <div class="category_list">
            </div>
        </div>
    </div>
</div>
<?php
if (get_option('smgt_enable_video_popup_show') == 'yes') {
?>
    <a href="#" class="view_video_popup youtube-icon" link="<?php echo "https://www.youtube.com/embed/Nk-iedcC4Y0?si=OshxLuh2R77dCUWT"; ?>" title="Student ID Card">
        <img src="<?php echo SMS_PLUGIN_URL . "/assets/images/youtube-icon.png" ?>" alt="YouTube">
    </a>
<?php
}
/* $exlude_id = mj_smgt_approve_student_list();
$studentdata = get_users(array('role' => 'student'));
if (!empty($studentdata)) { */
?>
    <div id="show_student_list">
        <div class="loader">
            <img src="<?php echo SMS_PLUGIN_URL . '/assets/images/school_app_loader_gif.gif' ?>" alt="">
        </div> 
        <div class="table-responsive" ><!-------- Table Responsive ----------->
            <form id="frm-example" name="frm-example" method="post"><!-------- Student Form Start ----------->
                <table id="students_list" class="display" cellspacing="0" width="100%">
                    <thead class="<?php echo MJ_smgt_datatable_heder() ?>">
                        <tr>
                            <th class="checkbox_width_10px text-end"><input type="checkbox" class="select_all" id="select_all"></th>
                            <th><?php _e('Photo', 'school-mgt'); ?></th>
                            <th><?php echo esc_attr_e('Student Name & Email', 'school-mgt'); ?></th>
                            <th> <?php echo esc_attr_e('Mobile No.', 'school-mgt'); ?></th>
                            <th> <?php echo esc_attr_e('Class & Section', 'school-mgt'); ?></th>
                            <th> <?php echo esc_attr_e('Roll No.', 'school-mgt'); ?></th>
                            <th> <?php echo esc_attr_e('Gender', 'school-mgt'); ?></th>
                            <th> <?php echo esc_attr_e('Status', 'school-mgt'); ?></th>
                            <th class="text_align_end"><?php _e('Action', 'school-mgt'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
                <!-------- Delete And Select All Button ----------->
                <div class="print-button pull-left">
                    <button class="btn btn-success btn-sms-color button_reload" style="margin-bottom: 5px;">
                        <input type="checkbox" class="smgt_sub_chk check_for_id select_all" value="" id="select_all" style="margin-top: 0px;">
                        <label for="checkbox" class="margin_right_5px"><?php esc_html_e('Select All', 'school-mgt'); ?></label>
                    </button>
                    <?php
                    if ($user_access_delete == '1') {
                    ?>
                        <button data-toggle="tooltip" id="delete_selected" title="<?php esc_html_e('Delete Selected', 'school-mgt'); ?>" name="delete_selected" class="delete_selected"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></button>
                    <?php
                    }
                    ?>
                    <button data-toggle="tooltip" title="<?php esc_html_e('Print ID Card', 'school-mgt'); ?>" name="print_id_card" class="print_id_card padding_0"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/print.png" ?>" alt=""></button>
                    <button data-toggle="tooltip" title="<?php esc_html_e('Export CSV', 'school-mgt'); ?>" type="button" class="view_csv_popup export_import_csv_btn padding_0"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/export_csv.png" ?>" alt=""></button>
                    <button data-toggle="tooltip" title="<?php esc_html_e('Import CSV', 'school-mgt'); ?>" type="button" class="view_import_student_csv_popup export_import_csv_btn padding_0"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/import_csv.png" ?>" alt=""></button>
                </div>
                <!-------- Delete And Select All Button ----------->
            </form><!-------- Student Form Start ----------->
        </div><!-------- Table Responsive ----------->
    </div>
    <?php
/*}  else {
    if ($user_access_add == '1') {
    ?>
        <div class="no_data_list_div row">
            <div class="offset-md-2 col-md-4">
                <a href="<?php echo admin_url() . 'admin.php?page=smgt_student&tab=addstudent'; ?>">
                    <img class="col-md-12 width_100px" src="<?php echo get_option('smgt_no_data_img') ?>">
                </a>
                <div class="col-md-12 dashboard_btn margin_top_20px">
                    <label class="no_data_list_label"><?php esc_html_e('Tap on above icon to add your first Record.', 'school-mgt'); ?> </label>
                </div>
            </div>
            <div class="col-md-4">
                <a data-toggle="tooltip" name="import_csv" type="button" class="view_import_student_csv_popup">
                    <img src="<?php echo SMS_PLUGIN_URL . "/assets/images/thumb_icon/Import_list.png" ?>" alt="">
                </a>
                <div class="col-md-12 dashboard_btn margin_top_20px">
                    <label class="no_data_list_label"><?php esc_html_e('Tap on above icon to import CSV.', 'school-mgt'); ?> </label>
                </div>
            </div>
        </div>
    <?php
    } else {
    ?>
        <div class="calendar-event-new">
            <img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
        </div>
<?php
    }
} */
?>