<?php
// Secure session configuration
if (session_status() === PHP_SESSION_NONE) 
{
    session_set_cookie_params([
        'lifetime' => 0,         // Session expires when the browser is closed
        'path' => '/',
        'domain' => '',          // Set the domain if required
        'secure' => true,        // Send cookies only over HTTPS
        'httponly' => true,      // Prevent JavaScript access to cookies
        'samesite' => 'Strict',  // Mitigate CSRF risks
    ]);
    
    session_start();
}
// Regenerate session ID to enhance security
if (!isset($_SESSION['initialized'])) {
    session_regenerate_id(true);
    $_SESSION['initialized'] = true;
}

// Generate a secure URL with session ID appended as a fallback (optional)
$url_with_sid = session_name() . "=" . session_id();
?>
<div class="page-inner min_height_1631"><!--PAGE INNER DIV START-->

	<div id="" class="gms_main_list"><!--MAIN WRAPPER DIV START-->

		<div class="row"><!--ROW DIV START-->

			<div class="col-md-12"><!--COL 12 DIV START-->

				<div class="float_left_width_100"><!--PANEL WHITE DIV START-->

					<div class="row addon_reponsive" style="">
						<div class="col-md-4">
							<div class="card addon-card" style="">
								<img src="<?php echo SMS_PLUGIN_URL."/assets/images/app_addon.png" ?>" class="card-img-top" alt="...">
								<div class="card-body addon-card-body">
									<h5 class="addon-card-title"><?php esc_html_e('School Master Mobile App for Android','school-mgt');?></h5>
									<a href="https://codecanyon.net/item/school-master-mobile-app-for-android/20806118?<?php echo $url_with_sid;?>" target="_blank" class="btn addon-button btn-primary"><?php echo esc_html__('Get It Now', 'school-mgt');?></a>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="card addon-card" style="">
								<img src="<?php echo SMS_PLUGIN_URL."/assets/images/school_iphone.png" ?>" class="card-img-top" alt="...">
								<div class="card-body addon-card-body">
									<h5 class="addon-card-title"><?php esc_html_e('School Master Mobile App for iphone','school-mgt');?></h5></h5>
									<a href="https://codecanyon.net/item/school-master-mobile-app-for-iphone/20792912?<?php echo $url_with_sid;?>" target="_blank" class="btn addon-button btn-primary"><?php echo esc_html__('Get It Now', 'school-mgt');?></a>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="card addon-card" style="">
								<img src="<?php echo SMS_PLUGIN_URL."/assets/images/paymaster_image.png" ?>" class="card-img-top" alt="...">
								<div class="card-body addon-card-body">
									<h5 class="addon-card-title"><?php esc_html_e('Paymaster - Multipurpose Payment Gateway','school-mgt');?></h5></h5>
									<a href="https://codecanyon.net/item/paymaster-multipurpose-payment-gateway/19693579?<?php echo $url_with_sid;?>" target="_blank" class="btn addon-button btn-primary"><?php echo esc_html__('Get It Now', 'school-mgt');?></a>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="card addon-card" style="">
								<img src="<?php echo SMS_PLUGIN_URL."/assets/images/sms_master.png" ?>" class="card-img-top" alt="...">
								<div class="card-body addon-card-body">
									<h5 class="addon-card-title"><?php esc_html_e('SMSmaster – Multipurpose SMS Gateway for Wordpress','school-mgt');?></h5></h5>
									<a href="https://codecanyon.net/item/smsmaster-multipurpose-sms-gateway-for-wordpress/20605853?<?php echo $url_with_sid;?>" target="_blank" class="btn addon-button btn-primary"><?php echo esc_html__('Get It Now', 'school-mgt');?></a>
								</div>
							</div>
						</div>
						
						<div class="col-md-4">
							<div class="card addon-card" style="">
								<img src="<?php echo SMS_PLUGIN_URL."/assets/images/lms_addon.png" ?>" class="card-img-top" alt="...">
								<div class="card-body addon-card-body">
									<h5 class="addon-card-title"><?php esc_html_e('WPLMS - Learning Management System Intigreted with WP-School','school-mgt');?></h5></h5>
									<a href="https://codecanyon.net/item/wplms-learning-management-system-for-wordpress/15485895?<?php echo $url_with_sid;?>" target="_blank" class="btn addon-button btn-primary"><?php echo esc_html__('Get It Now', 'school-mgt');?></a>
								</div>
							</div>
						</div>
					</div>

				</div><!--PANEL WHITE DIV END-->

			</div><!--COL 12 DIV END-->

		</div><!--ROW DIV END-->

	</div><!--MAIN WRAPPER DIV END-->

</div><!--PAGE INNER DIV END-->