<?php
set_time_limit(300);
class smgt_admission
{
	//----------- ADD NEW ADMISSION ------------------//
	public function mj_smgt_add_admission($data,$father_document_data,$mother_document_data,$role)
	{
		// Ensure the user is logged in
		if (!is_user_logged_in()) {
			wp_die(__('Security check failed! You are not logged in.', 'school-mgt'), 'Error', ['response' => 403]);
		}
		if (!isset($data['security']) || !wp_verify_nonce($data['security'], 'mj_smgt_nonce')) 
		{
			wp_die(__('Security check failed! Invalid security token.', 'school-mgt'), 'Error', ['response' => 403]);
		}
		// Get current user ID and role
		$current_user_id = get_current_user_id();
		$current_role = mj_smgt_get_user_role($current_user_id);
	
		// Prevent unauthorized role changes
		$allowed_roles = ["administrator", "management", "supportstaff", "teacher"];
		if (!in_array($current_role, $allowed_roles)) {
			wp_die(__('Permission denied! You do not have the required access.', 'school-mgt'), 'Error', ['response' => 403]);
		}
	
		// Prevent non-admins from assigning the 'administrator' role
		if ($role === 'administrator' && $current_role !== 'administrator') {
			wp_die(__('You are not allowed to assign the administrator role.', 'school-mgt'), 'Error', ['response' => 403]);
		}
	
		$obj_feespayment = new mj_smgt_feespayment();
		$firstname	=	sanitize_text_field($data['first_name']);
		$middlename	=	sanitize_text_field($data['middle_name']);
		$lastname	=	sanitize_text_field($data['last_name']);
		$userdata 	= 	array(
			'user_login'	=>	sanitize_email($data['email']),			
			'user_nicename'	=>	NULL,
			'user_email'	=>	sanitize_email($data['email']),
			'user_url'		=>	NULL,
			'display_name'	=>	$firstname." ".$middlename." ".$lastname,
		);
		if($data['password'] != "")
		{
			$userdata['user_pass']=mj_smgt_password_validation($data['password']);
		}
		else
		{ 
			$userdata['user_pass']=wp_generate_password();
		}
		if(isset($data['smgt_user_avatar']) && $data['smgt_user_avatar'] != "")
		{
			$photo	=	$data['smgt_user_avatar'];
		}
		else
		{
			$photo	=	"";
		}

		// Add Sibling details //
		$sibling_value=array();			 
		if(!empty($data['siblingsclass']))
		{
			foreach($data['siblingsclass'] as $key=>$value)
			{
				$sibling_value[]=array("siblingsclass" => $value, "siblingssection" => $data['siblingssection'][$key], "siblingsstudent" =>$data['siblingsstudent'][$key]);				  
			}	
		}

        $admission_fees_amount='';
		if(get_option("smgt_admission_fees") == "yes")
		{
			$admission_fees_amount= $data['admission_fees_amount'];
			$admission_fees_id= $data['admission_fees_id'];
		}
		// ADD USER META //
		// Initialize the base metadata
		$usermetadata = array(
			'admission_no' => sanitize_textarea_field($data['admission_no']),
			'admission_date' => MJ_smgt_get_format_for_db($data['admission_date']),
			'admission_fees' => $admission_fees_amount,
			'role' => sanitize_textarea_field($data['role']),
			'status' => sanitize_textarea_field($data['status']),
			'roll_id' => "",
			'middle_name' => sanitize_text_field($data['middle_name']),
			'gender' => sanitize_text_field($data['gender']),
			'birth_date' => sanitize_text_field($data['birth_date']),
			'address' => sanitize_textarea_field($data['address']),
			'city' => sanitize_text_field($data['city_name']),
			'state' => sanitize_text_field($data['state_name']),
			'zip_code' => sanitize_text_field($data['zip_code']),
			'preschool_name' => sanitize_text_field($data['preschool_name']),
			'phone_code' => sanitize_textarea_field($data['phone_code']),
			'mobile_number' => sanitize_text_field($_POST['mobile_number']),
			'alternet_mobile_number' => sanitize_text_field($data['alternet_mobile_number']),
			'sibling_information' => json_encode($sibling_value),
			'parent_status' => sanitize_text_field($data['pstatus']),
			'smgt_user_avatar' => $photo,
			'created_by' => get_current_user_id(),
		);

		// Initialize dynamic metadata arrays
		$father_metadata = array();
		$mother_metadata = array();

		// Add father metadata if father_email is not empty
		if (!empty($data['father_email'])) {
			$father_metadata = array(
				'fathersalutation' => sanitize_text_field($data['fathersalutation']),
				'father_first_name' => sanitize_text_field($data['father_first_name']),
				'father_middle_name' => sanitize_text_field($data['father_middle_name']),
				'father_last_name' => sanitize_text_field($data['father_last_name']),
				'fathe_gender' => sanitize_textarea_field($data['fathe_gender']),
				'father_birth_date' => sanitize_text_field($data['father_birth_date']),
				'father_address' => sanitize_textarea_field($data['father_address']),
				'father_city_name' => sanitize_text_field($data['father_city_name']),
				'father_state_name' => sanitize_text_field($data['father_state_name']),
				'father_zip_code' => sanitize_text_field($data['father_zip_code']),
				'father_email' => sanitize_email($data['father_email']),
				'father_mobile' => sanitize_text_field($data['father_mobile']),
				'father_school' => sanitize_text_field($data['father_school']),
				'father_medium' => sanitize_text_field($data['father_medium']),
				'father_education' => sanitize_text_field($data['father_education']),
				'fathe_income' => sanitize_textarea_field($data['fathe_income']),
				'father_occuption' => sanitize_text_field($data['father_occuption']),
				'father_doc' => json_encode($father_document_data),
			);
		}

		// Add mother metadata if mother_email is not empty
		if (!empty($data['mother_email'])) {
			$mother_metadata = array(
				'mothersalutation' => sanitize_text_field($data['mothersalutation']),
				'mother_first_name' => sanitize_text_field($data['mother_first_name']),
				'mother_middle_name' => sanitize_text_field($data['mother_middle_name']),
				'mother_last_name' => sanitize_text_field($data['mother_last_name']),
				'mother_gender' => sanitize_text_field($data['mother_gender']),
				'mother_birth_date' => sanitize_text_field($data['mother_birth_date']),
				'mother_address' => sanitize_textarea_field($data['mother_address']),
				'mother_city_name' => sanitize_text_field($data['mother_city_name']),
				'mother_state_name' => sanitize_text_field($data['mother_state_name']),
				'mother_zip_code' => sanitize_text_field($data['mother_zip_code']),
				'mother_email' => sanitize_email($data['mother_email']),
				'mother_mobile' => sanitize_text_field($data['mother_mobile']),
				'mother_school' => sanitize_text_field($data['mother_school']),
				'mother_medium' => sanitize_text_field($data['mother_medium']),
				'mother_education' => sanitize_text_field($data['mother_education']),
				'mother_income' => sanitize_text_field($data['mother_income']),
				'mother_occuption' => sanitize_text_field($data['mother_occuption']),
				'mother_doc' => json_encode($mother_document_data),
			);
		}

		// Merge metadata arrays
		$usermetadata = array_merge($usermetadata, $father_metadata, $mother_metadata);

		if ($data['action'] == 'edit')
		{
			school_append_audit_log(''.esc_html__('Addmission Updated','school-mgt').'',$data['user_id'],get_current_user_id(),'edit',sanitize_text_field($_REQUEST['page']));
			$userdata['ID'] = intval($data['user_id']);
			$user_id = wp_update_user( $userdata );
			foreach($usermetadata as $key=>$val)
			{
				$returnans=update_user_meta( $user_id, $key,$val, '' );	
			}
		}
		else
		{
			school_append_audit_log(''.esc_html__('Addmission Added','school-mgt').'',$data['user_id'],get_current_user_id(),'insert',sanitize_text_field($_REQUEST['page']));
			$user_id = wp_insert_user( $userdata );
			$user = new WP_User($user_id);
			$user->set_role($role);
			foreach($usermetadata as $key=>$val)
			{
				$returnans=add_user_meta( $user_id, $key,$val, true );		
			}
			if(get_option("smgt_admission_fees") == "yes")
			{
				$generated=mj_smgt_generate_admission_fees_invoice($admission_fees_amount,$user_id,$admission_fees_id,0,0,'Admission Fees');
			}
		}
		if($user_id)
		{
			//---------- ADMISSION REQUEST MAIL ---------//
			$string = array();
			$string['{{student_name}}'] = mj_smgt_get_display_name($user_id);
			$string['{{user_name}}']    =  $firstname .' '.$lastname;
			$string['{{email}}']        =  $userdata['user_email'];
			$string['{{school_name}}']  =  get_option('smgt_school_name');
			$MsgContent                 =  get_option('admission_mailtemplate_content');
			$MsgSubject				    =  get_option('admissiion_title');
			$message = mj_smgt_string_replacement($string,$MsgContent);
			$MsgSubject = mj_smgt_string_replacement($string,$MsgSubject);

			$email= $userdata['user_email'];
			mj_smgt_send_mail($email,$MsgSubject,$message);  
		}
		$returnval=update_user_meta( $user_id, 'first_name', $firstname );
		$returnval=update_user_meta( $user_id, 'last_name', $lastname );
		$hash = md5( rand(0,1000) );
		$returnval=update_user_meta( $user_id, 'hash', $hash );
		return $user_id;	
	}

	//----------Parents ADD ---------//

	public function mj_smgt_add_parent($student_id,$role_parents)
	{
		$student_data = get_user_meta( $student_id );
		if($student_data['parent_status'][0] == "Both")
		{
			if((!empty($student_data['father_first_name'][0])) || (!empty($student_data['mother_first_name'][0])))
			{
				//------------------ FATHER DATA INSERT ------------------//
				$fatherdata = array(
					'user_login'=> sanitize_email($student_data['father_email'][0]),			
					'user_nicename'=>NULL,
					'user_email'=> sanitize_email($student_data['father_email'][0]),
					'user_url'=>NULL,
					'user_pass'=>wp_generate_password(),
					'display_name'=>sanitize_text_field($student_data['father_first_name'][0])." ".sanitize_text_field($student_data['father_middle_name'][0])." ".sanitize_text_field($student_data['father_last_name'][0]),
				);

				// ADD USER META //
				$fathermetadata	=	array(
					'middle_name'=>sanitize_text_field($student_data['father_middle_name'][0]),
					'gender'=> sanitize_text_field($student_data['fathe_gender'][0]),
					'birth_date'=> sanitize_text_field($student_data['father_birth_date'][0]),
					'address'=> sanitize_text_field($student_data['father_address'][0]),
					'city'=> sanitize_text_field($student_data['father_city_name'][0]),
					'state'=> sanitize_text_field($student_data['father_state_name'][0]),
					'zip_code'=> sanitize_text_field($student_data['father_zip_code'][0]),
					'phone'=> sanitize_text_field($student_data['father_mobile'][0]),
					'mobile_number'=> sanitize_text_field($student_data['father_mobile'][0]),
					'relation'=>"Father"
				);

				$father_id = wp_insert_user( $fatherdata );
				$user = new WP_User($father_id);
				$user->set_role($role_parents);
				foreach($fathermetadata as $key=>$val)
				{		
					$returnans=add_user_meta( $father_id, $key,$val, true );		
				}
				//---------- Mail For ADD Parents ----------//
				if($father_id)
				{	
					$string = array();
					$string['{{user_name}}']   = $student_data['father_first_name'][0]." ".$student_data['father_middle_name'][0]." ".$student_data['father_last_name'][0];
					$string['{{school_name}}'] =  get_option('smgt_school_name');
					$string['{{role}}']        =  $role_parents;
					$string['{{login_link}}']  =  site_url() .'/index.php/school-management-login-page';
					$string['{{username}}']    =  $fatherdata['user_login'];
					$string['{{Password}}']    =  $fatherdata['user_pass'];
					$MsgContent                =  get_option('add_user_mail_content');		
					$MsgSubject				   =  get_option('add_user_mail_subject');
					$message = mj_smgt_string_replacement($string,$MsgContent);
					$MsgSubject = mj_smgt_string_replacement($string,$MsgSubject);
					$email= $fatherdata['user_email'];
					mj_smgt_send_mail($email,$MsgSubject,$message);
				}
				$returnval=update_user_meta( $father_id, 'first_name',$student_data['father_first_name'][0]);
				$returnval=update_user_meta( $father_id, 'last_name',$student_data['father_last_name'][0]);

				//------------ MOTHER DATA INSERT------------------//
				$motherdata = array(
					'user_login'=> sanitize_email($student_data['mother_email'][0]),			
					'user_nicename'=>NULL,
					'user_email'=> sanitize_email($student_data['mother_email'][0]),
					'user_url'=>NULL,
					'user_pass'=>wp_generate_password(),
					'display_name'=> sanitize_text_field($student_data['mother_first_name'][0])." ".sanitize_text_field($student_data['mother_middle_name'][0])." ".sanitize_text_field($student_data['mother_last_name'][0]),
				);

				// ADD USER META //
				$mothermetadata	=	array(
					'middle_name'=> sanitize_text_field($student_data['mother_middle_name'][0]),
					'gender'=> sanitize_text_field($student_data['mother_gender'][0]),
					'birth_date'=>sanitize_text_field($student_data['mother_birth_date'][0]),
					'address'=>sanitize_text_field($student_data['mother_address'][0]),
					'city'=>sanitize_text_field($student_data['mother_city_name'][0]),
					'state'=>sanitize_text_field($student_data['mother_state_name'][0]),
					'zip_code'=>sanitize_text_field($student_data['mother_zip_code'][0]),
					'phone'=>sanitize_text_field($student_data['mother_mobile'][0]),
					'mobile_number'=>sanitize_text_field($student_data['mother_mobile'][0]),
					'relation'=>"Mother"
				);

				$mother_id = wp_insert_user( $motherdata );
				$user1 = new WP_User($mother_id);
				$user1->set_role($role_parents);
				foreach($mothermetadata as $key=>$val)
				{		
					$returnans=add_user_meta( $mother_id, $key,$val, true );		
				}
				//---------- Mail For ADD Parents ----------//
				if($mother_id)
				{	
					$string = array();
					$string['{{user_name}}']   = $student_data['mother_first_name'][0]." ".$student_data['mother_middle_name'][0]." ".$student_data['mother_last_name'][0];
					$string['{{school_name}}'] =  get_option('smgt_school_name');
					$string['{{role}}']        =  $role_parents;
					$string['{{login_link}}']  =  site_url() .'/index.php/school-management-login-page';
					$string['{{username}}']    =  $motherdata['user_login'];
					$string['{{Password}}']    =  $motherdata['user_pass'];
					$MsgContent                =  get_option('add_user_mail_content');		
					$MsgSubject				   =  get_option('add_user_mail_subject');
					$message = mj_smgt_string_replacement($string,$MsgContent);
					$MsgSubject = mj_smgt_string_replacement($string,$MsgSubject);
					$email= $motherdata['user_email'];
					mj_smgt_send_mail($email,$MsgSubject,$message);
				}
				$returnval=update_user_meta( $mother_id, 'first_name',$student_data['mother_first_name'][0]);
				$returnval=update_user_meta( $mother_id, 'last_name',$student_data['mother_last_name'][0]);

				$parant_id = array($father_id,$mother_id);
				$returnval=add_user_meta($student_id,'parent_id', $parant_id );
				$child_id = array($student_id);
				$returnval=add_user_meta($father_id,'child', $child_id );
				$returnval=add_user_meta($mother_id,'child', $child_id );
				return $returnval;
			}
		}
		elseif($student_data['parent_status'][0] == "Father")
		{
			if((!empty($student_data['father_email'][0])) and (!empty($student_data['father_first_name'][0])))
			{
				if(email_exists($student_data['father_email'][0]))
				{
					$user = get_user_by('email',$student_data['father_email'][0]);
					$user_id = $user->ID;
					$parant_id = array($user_id);
					$returnval=add_user_meta($student_id,'parent_id', $parant_id );
					$child_id = array($student_id);
					$returnval=update_user_meta($user_id,'child', $child_id );
				}
				else
				{
					//------------ FATHER DATA INSERT------------------//
					$userdata = array(
						'user_login'=>sanitize_email($student_data['father_email'][0]),			
						'user_nicename'=>NULL,
						'user_email'=>sanitize_email($student_data['father_email'][0]),
						'user_url'=>NULL,
						'user_pass'=>wp_generate_password(),
						'display_name'=>sanitize_text_field($student_data['father_first_name'][0])." ".sanitize_text_field($student_data['father_middle_name'][0])." ".sanitize_text_field($student_data['father_last_name'][0]),
					);

					// ADD USER META //
					$usermetadata	=	array(
						'middle_name'=>sanitize_text_field($student_data['father_middle_name'][0]),
						'gender'=> sanitize_text_field($student_data['fathe_gender'][0]),
						'birth_date'=>sanitize_text_field($student_data['father_birth_date'][0]),
						'address'=>sanitize_text_field($student_data['father_address'][0]),
						'city'=>sanitize_text_field($student_data['father_city_name'][0]),
						'state'=>sanitize_text_field($student_data['father_state_name'][0]),
						'zip_code'=>sanitize_text_field($student_data['father_zip_code'][0]),
						'phone'=>sanitize_text_field($student_data['father_mobile'][0]),
						'mobile_number'=>sanitize_text_field($student_data['father_mobile'][0]),
						'relation'=>"Father"
					);

					$user_id = wp_insert_user( $userdata );
					$user = new WP_User($user_id);
					$user->set_role($role_parents);
					foreach($usermetadata as $key=>$val)
					{		
						$returnans=add_user_meta( $user_id, $key,$val, true );		
					} 

					//---------- Mail For ADD Parents ----------//
					if($user_id)
					{  	
						$string = array();
						$string['{{user_name}}']   = $student_data['father_first_name'][0]." ".$student_data['father_middle_name'][0]." ".$student_data['father_last_name'][0];
						$string['{{school_name}}'] =  get_option('smgt_school_name');
						$string['{{role}}']        =  $role_parents;
						$string['{{login_link}}']  =  site_url() .'/index.php/school-management-login-page';
						$string['{{username}}']    =  $userdata['user_login'];
						$string['{{Password}}']    =  $userdata['user_pass'];
						$MsgContent                =  get_option('add_user_mail_content');		
						$MsgSubject				   =  get_option('add_user_mail_subject');
						$message = mj_smgt_string_replacement($string,$MsgContent);
						$MsgSubject = mj_smgt_string_replacement($string,$MsgSubject);
						$email= $userdata['user_email'];
						mj_smgt_send_mail($email,$MsgSubject,$message);
					}

					$returnval=update_user_meta( $user_id, 'first_name',$student_data['father_first_name'][0]);
					$returnval=update_user_meta( $user_id, 'last_name',$student_data['father_last_name'][0]);
				
					$parant_id = array($user_id);
					$returnval=add_user_meta($student_id,'parent_id', $parant_id );

					$child_id = array($student_id);
					$returnval=add_user_meta($user_id,'child', $child_id );  
				}
				return $returnval;
			}
		}
		elseif($student_data['parent_status'][0] == "Mother")
		{
			if((!empty($student_data['mother_email'][0])) and (!empty($student_data['mother_first_name'][0])))
			{
				if(email_exists($student_data['mother_email'][0]))
				{
					$user = get_user_by('email',$student_data['mother_email'][0]);
					$user_id = $user->ID;
					$parant_id = array($user_id);
					$returnval=add_user_meta($student_id,'parent_id', $parant_id );
					$child_id = array($student_id);
					$returnval=update_user_meta($user_id,'child', $child_id );
				}
				else
				{
					//------------ MOTHER DATA INSERT------------------//
					$userdata = array(
						'user_login'=>sanitize_email($student_data['mother_email'][0]),			
						'user_nicename'=>NULL,
						'user_email'=>sanitize_email($student_data['mother_email'][0]),
						'user_url'=>NULL,
						'user_pass'=>wp_generate_password(),
						'display_name'=>sanitize_text_field($student_data['mother_first_name'][0])." ".sanitize_text_field($student_data['mother_middle_name'][0])." ".sanitize_text_field($student_data['mother_last_name'][0]),
					);

					// ADD USER META //
					$usermetadata	=	array(
						'middle_name'=>sanitize_text_field($student_data['mother_middle_name'][0]),
						'gender'=> sanitize_text_field($student_data['mother_gender'][0]),
						'birth_date'=>$student_data['mother_birth_date'][0],
						'address'=>sanitize_text_field($student_data['mother_address'][0]),
						'city'=>sanitize_text_field($student_data['mother_city_name'][0]),
						'state'=>sanitize_text_field($student_data['mother_state_name'][0]),
						'zip_code'=>sanitize_text_field($student_data['mother_zip_code'][0]),
						'phone'=>sanitize_text_field($student_data['mother_mobile'][0]),
						'mobile_number'=>sanitize_text_field($student_data['mother_mobile'][0]),
						'relation'=>"Mother"
					);

					$user_id = wp_insert_user( $userdata );
					$user = new WP_User($user_id);
					$user->set_role($role_parents);
					foreach($usermetadata as $key=>$val)
					{		
						$returnans=add_user_meta( $user_id, $key,$val, true );		
					}

					//---------- Mail For ADD Parents ----------//
					if($user_id)
					{	
						$string = array();
						$string['{{user_name}}']   = $student_data['mother_first_name'][0]." ".$student_data['mother_middle_name'][0]." ".$student_data['mother_last_name'][0];
						$string['{{school_name}}'] =  get_option('smgt_school_name');
						$string['{{role}}']        =  $role_parents;
						$string['{{login_link}}']  =  site_url() .'/index.php/school-management-login-page';
						$string['{{username}}']    =  $userdata['user_login'];
						$string['{{Password}}']    =  $userdata['user_pass'];
						$MsgContent                =  get_option('add_user_mail_content');		
						$MsgSubject				   =  get_option('add_user_mail_subject');
						$message = mj_smgt_string_replacement($string,$MsgContent);
						$MsgSubject = mj_smgt_string_replacement($string,$MsgSubject);
						$email= $userdata['user_email'];
						mj_smgt_send_mail($email,$MsgSubject,$message);
					}

					$returnval=update_user_meta( $user_id, 'first_name',$student_data['mother_first_name'][0]);
					$returnval=update_user_meta( $user_id, 'last_name',$student_data['mother_last_name'][0]);

					$parant_id = array($user_id);
					$returnval=add_user_meta($student_id,'parent_id', $parant_id );

					$child_id = array($student_id);
					$returnval=add_user_meta($user_id,'child', $child_id );
				}
				return $returnval;
			}
		}
    }
}
?>