<?php
class smgt_exam
{
	public function mj_smgt_get_subject_by_section_id($cid,$sid)
	{
		global $wpdb;
		$class_id = intval($cid);
		$section_id = intval($sid);
		$table_name = $wpdb->prefix . "subject";
		$results = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE class_id=%d and section_id=%d",$class_id,$section_id)
		);
		return $results;
	}
	public function mj_smgt_get_subject_by_class_id($class_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		return $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE  class_id=%s",$class_id));
	}
	public function mj_smgt_insert_sub_wise_time_table($class_id,$exam_id,$subject_id,$exam_date,$start_time,$end_time)
	{
		
		global $wpdb;
		$table_name = $wpdb->prefix . "smgt_exam_time_table";
		$curr_date=date('Y-m-d');
		$curren_user= get_current_user_id();
		$exam_date_new=date('Y-m-d',strtotime($exam_date));

		$start_time_24hrs_formate=MJ_start_time_convert($start_time);
		$end_time_24hrs_formate=MJ_end_time_convert($end_time);
	
		$start_time_new=$start_time_24hrs_formate;
		$end_time_new=$end_time_24hrs_formate;
		$check_insrt_or_update =$this->mj_smgt_check_subject_data($exam_id,$subject_id);

		
		// Sanitize inputs
		$class_id = intval($class_id); // Ensure class_id is an integer
		$exam_id = intval($exam_id); // Ensure exam_id is an integer
		$subject_id = intval($subject_id); // Ensure subject_id is an integer
		$exam_date_new = sanitize_text_field($exam_date_new); // Sanitize date as text
		$start_time_new = sanitize_text_field($start_time_new); // Sanitize start time
		$end_time_new = sanitize_text_field($end_time_new); // Sanitize end time
		$curr_date = current_time('mysql'); // Get the current date safely
		$curren_user = get_current_user_id(); // Get current user ID

		if (empty($check_insrt_or_update)) {
			// Log audit for insert
			school_append_audit_log(esc_html__('Exam Time Table Added', 'school-mgt'), $curren_user, $curren_user, 'insert', $_REQUEST['page']);
			
			// Use prepared statement to insert data securely
			$save_data = $wpdb->insert(
				$table_name,
				array(
					'class_id' => $class_id,
					'exam_id' => $exam_id,
					'subject_id' => $subject_id,
					'exam_date' => $exam_date_new,
					'start_time' => $start_time_new,
					'end_time' => $end_time_new,
					'created_date' => $curr_date,
					'created_by' => $curren_user
				),
				array(
					'%d', // class_id as integer
					'%d', // exam_id as integer
					'%d', // subject_id as integer
					'%s', // exam_date as string
					'%s', // start_time as string
					'%s', // end_time as string
					'%s', // created_date as string
					'%d'  // created_by as integer
				)
			);
		} else {
			// Log audit for update
			school_append_audit_log(esc_html__('Exam Time Table Updated', 'school-mgt'), $curren_user, $curren_user, 'edit', $_REQUEST['page']);
			// Use prepared statement to update data securely
			$save_data = $wpdb->update(
				$table_name,
				array(
					'exam_date' => $exam_date_new,
					'start_time' => $start_time_new,
					'end_time' => $end_time_new,
					'created_date' => $curr_date,
					'created_by' => $curren_user
				),
				array(
					'class_id' => $class_id,
					'exam_id' => $exam_id,
					'subject_id' => $subject_id
				),
				array(
					'%s', // exam_date as string
					'%s', // start_time as string
					'%s', // end_time as string
					'%s', // created_date as string
					'%d'  // created_by as integer
				),
				array(
					'%d', // class_id as integer
					'%d', // exam_id as integer
					'%d'  // subject_id as integer
				)
			);
		}
		return $save_data;
	}
	public function mj_smgt_check_subject_data($exam_id,$subject_id)
	{
		
		global $wpdb;
		$table_name = $wpdb->prefix . "smgt_exam_time_table";
		$results=$wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE exam_id= %d and subject_id= %d",$exam_id,$subject_id));
		
		return $results;
	}
	public function mj_smgt_check_exam_time_table($class_id,$exam_id,$sub_id)
	{
		global $wpdb;
		
		$table_name = $wpdb->prefix . "smgt_exam_time_table";
		$result=$wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE class_id= %d and exam_id= %d and subject_id= %d",$class_id,$exam_id,$sub_id));
		return $result;
	}
	public function mj_smgt_get_exam_time_table_by_exam($exam_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "smgt_exam_time_table";
		$results=$wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE exam_id= %d",$exam_id));
		return $results;
	}
	public function mj_smgt_get_all_exam_by_class_id_created_by($class_id,$user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id IN (".implode(',', $class_id).") OR exam_creater_id=".$user_id));
		return $results;
	}
	public function mj_smgt_get_all_exam_created_by($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE exam_creater_id=%d",$user_id));
		return $results;
	}
	function mj_smgt_get_all_exam_by_class_id_dashboard($class_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		return $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id = %d and section_id='0' ORDER BY exam_id DESC limit 3",$class_id));
	
	}
	function mj_smgt_get_all_exam_by_class_id_and_section_id_array_dashboard($class_id,$section_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		return  $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id= %d and section_id= %d ORDER BY exam_id DESC limit 3",$class_id,$section_id));
		
	}
	public function mj_smgt_get_all_exam_by_class_id_created_by_dashboard($class_id,$user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		// Sanitize the class IDs
		$class_ids = array_map('intval', $class_id);

		// Prepare the SQL query using placeholders
		$query = "
			SELECT * 
			FROM $table_name 
			WHERE class_id IN (%s) 
			AND section_id = %d 
			ORDER BY exam_id DESC 
			LIMIT 3
		";
		// Implode the class IDs into a comma-separated list
		$class_ids_imploded = implode(',', $class_ids);
		$results = $wpdb->get_results($wpdb->prepare($query, $class_ids_imploded, 0));  // section_id is '0'
		return $results;
	}
	function mj_smgt_get_all_exam_by_class_id_array_dashboard($class_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		global $wpdb;
		// Ensure $class_id is an array and properly sanitized
		$class_ids = array_map('intval', $class_id);  // Convert each ID to an integer
		// Prepare the SQL query using placeholders
		$query = "
			SELECT * 
			FROM $table_name 
			WHERE class_id IN (%s) 
			AND section_id = %d 
			ORDER BY exam_id DESC 
			LIMIT 3
		";

		// Implode the class IDs into a comma-separated list
		$class_ids_imploded = implode(',', $class_ids);
		// Prepare the query with the secure values
		$results = $wpdb->get_results($wpdb->prepare($query, $class_ids_imploded, 0));  // section_id is '0'
		return $results;
		
	}
	public function mj_smgt_get_all_exam_created_by_dashboard($user_id)
	{
		global $wpdb;
		$user_id=intval($user_id);
		$table_name = $wpdb->prefix . "exam";
		$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE exam_creater_id= %d ORDER BY exam_id DESC limit 3",$user_id));
		return $results;
	}
	public function mj_smgt_exam_list_for_dashboard()
	{
		global $wpdb;
		$smgt_exam = $wpdb->prefix . 'exam';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $smgt_exam ORDER BY exam_id DESC limit 5"));
		return $result;
	}
	public function mj_smgt_exam_data($exam_id)
	{
		global $wpdb;
		$smgt_exam = $wpdb->prefix . 'exam';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $smgt_exam WHERE exam_id=%d",$exam_id));
		return $result;
	}
	public function mj_smgt_save_merge_exam_setting($data)
	{
		global $wpdb;
		$table_exam_merge_settings = $wpdb->prefix . 'exam_merge_settings';
		$exam_config = []; 
		if (!empty($data['exam_id']) && is_array($data['exam_id'])) 
		{
			foreach ($data['exam_id'] as $index => $exam_id) {
				$weightage = isset($data['weightage'][$index]) ? floatval($data['weightage'][$index]) : 0;
				$exam_config[] = array(
					'exam_id'   => intval($exam_id),
					'weightage' => $weightage
				);
			}
		}
		$json_config = !empty($exam_config) ? json_encode($exam_config, JSON_UNESCAPED_UNICODE) : json_encode(['exams' => []]);
		$merge_exam_data = array(
			'class_id'    => intval($data['class_id']),
			'section_id'  => isset($data['section_id']) ? $data['section_id'] : 0,
			'merge_name'  => sanitize_text_field(wp_unslash($data['merge_name'])),
			'merge_config'=> $json_config,
			'status'      => 'enable',
			'created_by'  => get_current_user_id()
		);
		if($data['action']=='edit_merge')
		{
			// Secure update using prepare statement
		$result = $wpdb->query(
			$wpdb->prepare(
				"UPDATE $table_exam_merge_settings 
				SET class_id = %d, section_id = %d, merge_name = %s, merge_config = %s, status = %s, created_by = %d 
				WHERE id = %d",
				$merge_exam_data['class_id'],
				$merge_exam_data['section_id'],
				$merge_exam_data['merge_name'],
				$merge_exam_data['merge_config'],
				$merge_exam_data['status'],
				$merge_exam_data['created_by'],
				$data['merge_id'] // Assuming 'id' is the primary key
			)
		);
			school_append_audit_log(''.esc_html__('Group Exam Merge Settings Updated','school-mgt').'('.$data['merge_name'].')'.'',get_current_user_id(),get_current_user_id(),'edit',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			// Secure insert using prepare statement
			$result = $wpdb->query(
				$wpdb->prepare(
					"INSERT INTO $table_exam_merge_settings (class_id, section_id, merge_name, merge_config, status, created_by) 
					VALUES (%d, %d, %s, %s, %s, %d)",
					$merge_exam_data['class_id'],
					$merge_exam_data['section_id'],
					$merge_exam_data['merge_name'],
					$merge_exam_data['merge_config'],
					$merge_exam_data['status'],
					$merge_exam_data['created_by']
				)
			);
			school_append_audit_log(
				esc_html__('Group Exam Merge Setting Added', 'school-mgt') . ' (' . esc_html($merge_exam_data['merge_name']) . ')',
				get_current_user_id(),
				get_current_user_id(),
				'insert',
				isset($_REQUEST['page']) ? sanitize_text_field(wp_unslash($_REQUEST['page'])) : ''
			);
	   }
	   return $result;
	}
	public function mj_smgt_get_all_merge_exam_setting()
	{
		global $wpdb;
		$exam_merge_settings = esc_sql($wpdb->prefix . 'exam_merge_settings'); // Escaping table name
		$exam_merge_settings_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM {$exam_merge_settings} WHERE 1 = %d", 1)
		);
		return $exam_merge_settings_data;
	}
	 //------------ DELETE Exam Settings -----------//
	 public function mj_smgt_delete_exam_setting($id)
	 {
		 global $wpdb;
		 $exam_merge_settings = esc_sql($wpdb->prefix . 'exam_merge_settings'); // Escaping table name
		 $result = $wpdb->query($wpdb->prepare("DELETE FROM $exam_merge_settings where id=%d",$id));
		 return $result;
	 }
	 public function mj_smgt_get_single_merge_exam_setting($id)
	{
		global $wpdb;
		$exam_merge_settings = esc_sql($wpdb->prefix . 'exam_merge_settings'); // Escaping table name
		$result= $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM {$exam_merge_settings} WHERE id = %d", $id)
		);
		return $result;
	}
}
?>