<?php 
class Smgt_fees
{	
	
	public function mj_smgt_get_all_feetype()
	{
		$args = array(
			'post_type'      => sanitize_key('smgt_feetype'), // Validate post type
			'posts_per_page' => intval(-1),                  // Ensure it's an integer
			'orderby'        => sanitize_key('post_title'),  // Validate orderby field
			'order'          => sanitize_text_field('ASC'),  // Validate order
		);
		$result = get_posts( $args );		
		return $result;		
	}
	public function mj_smgt_add_feetype($data)
	{
		global $wpdb;
		$result = wp_insert_post( array(
						'post_status' => 'publish',
						'post_type' => 'smgt_feetype',
						'post_title' => sanitize_textarea_field($data['category_name'])) );
		
			return $result;			
	}
	public function mj_smgt_delete_fee_type($cat_id)
	{
		$cat_id = isset($cat_id) ? intval($cat_id) : 0;
		$result = wp_delete_post($cat_id, true);
		return $result;
	}
	public function mj_smgt_is_duplicat_fees($fee_type_id,$class_id)
	{
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_smgt_fees where fees_title_id =%d, AND class_id =%d",$fee_type_id,$class_id));
		if(!empty($result))
			return true;
		else
			return false;
		
	}
	public function mj_smgt_add_fees($data)
	{
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
		//-------usersmeta table data--------------
		$feedata['fees_title_id']=sanitize_text_field($data['fees_title_id']);
		$feedata['class_id']=sanitize_text_field($_POST['class_id']);
		$feedata['section_id']=sanitize_text_field($_POST['class_section']);
		$feedata['fees_amount']=sanitize_text_field($_POST['fees_amount']);
		$feedata['description']=sanitize_textarea_field(stripslashes($_POST['description']));		
		$feedata['created_date']=date("Y-m-d H:i:s");
		$feedata['created_by']=get_current_user_id();
	
	
		if($data['action']=='edit')
		{
			
			$fees_id['fees_id']=intval($data['fees_id']);
			$result=$wpdb->update( $table_smgt_fees, $feedata ,$fees_id);
			$fee_type = get_the_title(intval($feedata['fees_title_id']));
			school_append_audit_log(''.esc_html__('Fees Type Updated','school-mgt').'('.$fee_type.')'.'',get_current_user_id(),get_current_user_id(),'edit',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			
			$result=$wpdb->insert( $table_smgt_fees, $feedata );
			$fee_type = get_the_title($feedata['fees_title_id']);
			school_append_audit_log(''.esc_html__('Fees Type Added','school-mgt').'('.$fee_type.')'.'',get_current_user_id(),get_current_user_id(),'insert',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	public function mj_smgt_get_all_fees()
	{
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
	
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_smgt_fees ORDER BY created_date DESC"));
		return $result;
	}
	public function mj_smgt_get_own_fees($user_id)
	{
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
	
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_smgt_fees where created_by=%d",$user_id));
		return $result;
	}
	public function mj_smgt_get_single_feetype_data($fees_id)
	{
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
	
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_smgt_fees where fees_id =%d",$fees_id));
		return $result;
	}
	public function mj_smgt_get_single_feetype_data_amount($fees_id)
	{
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
		// $event = $wpdb->get_row("SELECT * FROM $table_name where event_id=$id");
		$result = $wpdb->get_row($wpdb->prepare("SELECT fees_amount FROM $table_smgt_fees where fees_id =%d",$fees_id));
		if(!empty($result)){
			return $result->fees_amount;
		}
	}
		
	public function mj_smgt_delete_feetype_data($fees_id)
	{
		
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix. 'smgt_fees';
		$fee_type = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_smgt_fees where fees_id=%d",$fees_id));
		$fee = get_the_title($fee_type->fees_title_id);

		school_append_audit_log(''.esc_html__('Fees Type Deleted','school-mgt').'('.$fee.')'.'',get_current_user_id(),get_current_user_id(),'delete',sanitize_text_field($_REQUEST['page']));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_smgt_fees where fees_id= ".$fees_id));
		return $result;
	}
}
?>