<?php
class Marks_Manage
{
	public $mark_id;
	public $exam_id;
	public $class_id;
	public $subject_id;
	public $marks;
	public $attendance;
	public $student_id;
	public $marks_comment;
	public $created_date;
	public function __construct($marks = null)
	{
		if ($marks) {
			global $wpdb;
			$table_name = $wpdb->prefix . "marks";
			$mark_data = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE mark_id=%d", $marks));
			$this->mark_id = $mark_data->mark_id;
			$this->exam_id = $mark_data->exam_id;
			$this->class_id = $mark_data->class_id;
			$this->subject_id = $mark_data->subject_id;
			$this->marks = $mark_data->marks;
			$this->attendance = $mark_data->attendance;
			$this->student_id = $mark_data->student_id;
			$this->marks_comment = $mark_data->marks_comment;
		}
	}
	public function mj_smgt_marks_exist($mark_id)
	{
		global $wpdb;
		$query = $wpdb->prepare('SELECT mark_id FROM ' . $wpdb->marks . ' WHERE mark_id = %d', $mark_id);
		$marks = $wpdb->get_var($query);
		if (!empty($marks))
			return true;
		else
			return false;
	}
	public function mj_smgt_save_marks($marks_data)
	{
		$table_name = "marks";
		mj_smgt_insert_record($table_name, $marks_data);
	}

	public function mj_smgt_update_marks($marks_data, $mark_id)
	{
		$table_name = "marks";
		return $result = mj_smgt_update_record($table_name, $marks_data, $mark_id);
	}

	public function mj_smgt_subject_makrs_detail_byuser($exam_id, $class_id, $subject_id, $userid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";
		$retrieve_marks = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE exam_id= %d AND class_id = %d  AND subject_id = %d  AND student_id = %d ", $exam_id, $class_id, $subject_id, $userid));
		if (!empty($retrieve_marks))
			return $retrieve_marks;
		else
			return false;
	}

	public function mj_smgt_student_subject($class_id, $section_id = 0)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		$table_name2 = $wpdb->prefix . "teacher_subject";
		$user_id = get_current_user_id();
		$retrieve_subject = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id= %d ", $class_id));
		return $retrieve_subject;
	}
	public function mj_smgt_student_subject_export($class_id, $section_id = 0)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		$table_name2 = $wpdb->prefix . "teacher_subject";
		$user_id = get_current_user_id();
		if($section_id == 0)
		{
			$retrieve_subject = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id= %d", $class_id));
		}
		else
		{
			$retrieve_subject = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id= %d && section_id = %d ", $class_id, $section_id));
		}
		
		return $retrieve_subject;
	}
	public function mj_smgt_student_subject_for_list($class_id, $section_id = 0)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		$table_name2 = $wpdb->prefix . "teacher_subject";
		$user_id = get_current_user_id();
		$section_id = intval($section_id); // Ensure section_id is an integer
		$class_id = intval($class_id); // Ensure class_id is an integer
		if (mj_smgt_get_roles($user_id) == 'teacher') {
			if ($section_id != 0) {
				// Use $wpdb->prepare to secure the query
				$query = $wpdb->prepare(
					"SELECT p1.*, p2.* FROM {$table_name} p1 
					INNER JOIN {$table_name2} p2 ON (p1.subid = p2.subject_id) 
					WHERE p2.teacher_id = %d AND p1.class_id = %d AND p1.section_id = %d",
					$user_id,
					$class_id,
					$section_id
				);
			} else {
				// Use $wpdb->prepare to secure the query
				$query = $wpdb->prepare(
					"SELECT p1.*, p2.* FROM {$table_name} p1 
					INNER JOIN {$table_name2} p2 ON (p1.subid = p2.subject_id) 
					WHERE p2.teacher_id = %d AND p1.class_id = %d",
					$user_id,
					$class_id
				);
			}
			// Execute the query and get the results
			$retrieve_subject = $wpdb->get_results($query);
		} else {

			if ($section_id != 0) {
				// Use $wpdb->prepare to secure the query
				$query = $wpdb->prepare(
					"SELECT * FROM {$table_name} WHERE section_id = %d AND class_id = %d",
					$section_id,
					$class_id
				);
			} else {
				// Use $wpdb->prepare to secure the query
				$query = $wpdb->prepare(
					"SELECT * FROM {$table_name} WHERE class_id = %d",
					$class_id
				);
			}

			// Execute the query and get the results
			$retrieve_subject = $wpdb->get_results($query);
		}

		return $retrieve_subject;
	}

	//add new function for result issue student side //
	public function mj_smgt_student_subject_list($class_id, $section_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		if ($section_id == "") {
			$section_id = 0;
		} else {
			$section_id = $section_id;
		}
		
		$section_id = intval($section_id); // Ensure section_id is an integer
		$class_id = intval($class_id); // Ensure class_id is an integer
		
		// Secure the query using $wpdb->prepare
		$query = $wpdb->prepare(
			"SELECT * FROM {$table_name} WHERE class_id = %d",
			$class_id
		);
		
		// Execute the query and return the results
		$retrieve_subject = $wpdb->get_results($query);
		return $retrieve_subject;
	}

	public function mj_smgt_teachers_subject($class_id, $teacherid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		return $retrieve_subject = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE class_id=%d and teacher_id=%d", $class_id, $teacherid));
	}

	public function mj_smgt_get_marks($exam_id, $class_id, $subject_id, $user_id)
	{
		$exam_id = intval($exam_id);
		$class_id = intval($class_id);
		$subject_id = intval($subject_id);
		$user_id = intval($user_id);
		
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE exam_id = %d AND class_id= %d AND subject_id = %d AND student_id = %d ", $exam_id, $class_id, $subject_id, $user_id));
		
		$marks = 0;
		if(!empty($result))
		{
			if($result->contributions == "yes")
			{
				$marks = json_decode($result->class_marks);
			}
			else
			{
				$marks = $result->marks;
			}
		}
		
		return $marks;
	}

	public function mj_smgt_get_marks_pass_fail($exam_id, $class_id, $user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT marks FROM $table_name WHERE exam_id = %d AND class_id= %d AND student_id = %d", $exam_id, $class_id, $user_id));
	}

	public function mj_smgt_get_max_marks($exam_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT total_mark FROM $table_name WHERE exam_id = %d ", $exam_id));
	}

	public function mj_smgt_get_pass_marks($exam_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT passing_mark FROM $table_name WHERE exam_id = %d", $exam_id));
	}

	public function mj_smgt_get_exam_term($exam_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "exam";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT exam_term FROM $table_name WHERE exam_id = %d ", $exam_id));
	}

	public function mj_smgt_get_marks_comment($exam_id, $class_id, $subject_id, $user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";
		$query = "
			SELECT marks_comment 
			FROM $table_name 
			WHERE exam_id = %d 
			AND class_id = %d 
			AND subject_id = %d 
			AND student_id = %d
		";
		// Use $wpdb->prepare to safely insert the variables into the query
		$retrieve_result = $wpdb->get_var($wpdb->prepare($query, $exam_id, $class_id, $subject_id, $user_id));
		return $retrieve_result;
	}

	public function mj_smgt_get_grade_marks_comment($grade_name)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "grade";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT grade_comment FROM $table_name WHERE grade_name = %s", $grade_name));
	}

	public function mj_smgt_get_attendance($exam_id, $class_id, $subject_id, $user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT attendance FROM $table_name WHERE exam_id = %d AND class_id= %d AND subject_id = %d AND student_id = %d", $exam_id, $class_id, $subject_id, $user_id));
	}

	public function mj_smgt_get_grade_name($grade_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "grade";
		return $retrieve_result = $wpdb->get_var("SELECT grade_name FROM $table_name WHERE grade_id = " . $grade_id);
	}

	public function mj_smgt_get_grade_base_on_grand_total($total_marks)
	{
		global $wpdb;
		$table_grade = $wpdb->prefix . "grade";
		// Fetch grade
		$grade = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT grade_name FROM $table_grade WHERE %d BETWEEN mark_upto AND mark_from",
				$total_marks
			)
		);
		
		return $grade ?: ""; 
	}
	public function mj_smgt_get_grade($exam_id, $class_id, $subject_id, $user_id)
	{
		global $wpdb;
		
		// Sanitize input parameters
		$exam_id = intval($exam_id);
		$class_id = intval($class_id);
		$subject_id = intval($subject_id);
		$user_id = intval($user_id);
		
		$table_marks = $wpdb->prefix . "marks";
		$table_grade = $wpdb->prefix . "grade";
		
		// Fetch student marks
		$result = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT marks, contributions, class_marks FROM $table_marks 
				WHERE exam_id = %d AND class_id = %d AND subject_id = %d AND student_id = %d", 
				$exam_id, $class_id, $subject_id, $user_id
			)
		);
		
		if (!$result) {
			return null; // No result found
		}
		
		// Calculate total marks
		$total_marks = 0;
		if ($result->contributions === "yes") {
			$marks_array = json_decode($result->class_marks, true);
			if (is_array($marks_array)) {
				$total_marks = array_sum($marks_array);
			}
		} else {
			$total_marks = intval($result->marks);
		}
		
		// Fetch grade
		$grade = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT grade_name FROM $table_grade WHERE %d BETWEEN mark_upto AND mark_from",
				$total_marks
			)
		);
		
		return $grade ?: ""; 
	}
	public function mj_smgt_get_grade_omment($exam_id, $class_id, $subject_id, $user_id)
	{
		global $wpdb;
		
		// Sanitize input parameters
		$exam_id = intval($exam_id);
		$class_id = intval($class_id);
		$subject_id = intval($subject_id);
		$user_id = intval($user_id);
		
		$table_marks = $wpdb->prefix . "marks";
		$table_grade = $wpdb->prefix . "grade";
		
		// Fetch student marks
		$result = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT marks, contributions, class_marks FROM $table_marks 
				WHERE exam_id = %d AND class_id = %d AND subject_id = %d AND student_id = %d", 
				$exam_id, $class_id, $subject_id, $user_id
			)
		);
		
		if (!$result) {
			return null; // No result found
		}
		
		// Calculate total marks
		$total_marks = 0;
		if ($result->contributions === "yes") {
			$marks_array = json_decode($result->class_marks, true);
			if (is_array($marks_array)) {
				$total_marks = array_sum($marks_array);
			}
		} else {
			$total_marks = intval($result->marks);
		}
		
		// Fetch grade
		$grade = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT grade_comment FROM $table_grade WHERE %d BETWEEN mark_upto AND mark_from",
				$total_marks
			)
		);
		
		return $grade ?: ""; 
	}

	public function mj_smgt_get_grade_point($exam_id, $class_id, $subject_id, $user_id)
	{
		global $wpdb;
		
		// Sanitize input parameters
		$exam_id = intval($exam_id);
		$class_id = intval($class_id);
		$subject_id = intval($subject_id);
		$user_id = intval($user_id);
		
		$table_marks = $wpdb->prefix . "marks";
		$table_grade = $wpdb->prefix . "grade";
		
		// Fetch student marks
		$result = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT marks, contributions, class_marks FROM $table_marks 
				WHERE exam_id = %d AND class_id = %d AND subject_id = %d AND student_id = %d", 
				$exam_id, $class_id, $subject_id, $user_id
			)
		);
		
		if (!$result) {
			return null; // No result found
		}
		
		// Calculate total marks
		$total_marks = 0;
		if ($result->contributions === "yes") {
			$marks_array = json_decode($result->class_marks, true);
			if (is_array($marks_array)) {
				$total_marks = array_sum($marks_array);
			}
		} else {
			$total_marks = intval($result->marks);
		}
		
		// Fetch grade
		$grade = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT grade_point FROM $table_grade WHERE %d BETWEEN mark_upto AND mark_from",
				$total_marks
			)
		);
		
		return $grade ?: 0;
	}
	public function mj_smgt_get_grade_id($marks)
	{
		global $wpdb;
		$tbl_grade = $wpdb->prefix . "grade";
		$retrieve_result = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT grade_id 
				 FROM $tbl_grade 
				 WHERE %d BETWEEN mark_upto AND mark_from",
				$marks
			)
		);
		return $retrieve_result;
	}
	public function mj_smgt_export_marks($exam_id, $class_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";
		return $retrieve_result = $wpdb->get_var($wpdb->prepare("SELECT marks_comment FROM $table_name WHERE exam_id = %d AND class_id= %d ", $exam_id, $class_id));
	}
	public function mj_smgt_export_get_subject_mark($exam_id, $class_id, $sutdent_id, $subject_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "marks";

		// Sanitize the input values
		$exam_id = intval($exam_id); // Ensure exam_id is an integer
		$class_id = intval($class_id); // Ensure class_id is an integer
		$sutdent_id = intval($sutdent_id); // Ensure student_id is an integer
		$subject_id = intval($subject_id); // Ensure subject_id is an integer
		// Prepare the SQL query with $wpdb->prepare to avoid SQL injection
		$query = $wpdb->prepare(
			"SELECT marks FROM {$table_name} WHERE exam_id = %d AND class_id = %d AND student_id = %d AND subject_id = %d",
			$exam_id, // Pass the exam_id
			$class_id, // Pass the class_id
			$sutdent_id, // Pass the student_id
			$subject_id // Pass the subject_id
		);
		$retrieve_result = $wpdb->get_row($query);

		if (!empty($retrieve_result))
			return $retrieve_result->marks;
		else
			return 0;
	}
}
