<?php 
class Smgtinvoice
{
	
	public function mj_smgt_generate_invoce_number()
	{
		global $wpdb;
		$table_invoice=$wpdb->prefix.'smgt_invoice';
		
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_invoice ORDER BY invoice_id DESC"));
		$year = date("y");
		$month = date("m");
		$date = date("d");
		$concat = $year.$month.$date;
		if(!empty($result))
		{	$res = $result->invoice_id + 1;
			return $concat.$res;
		}
		else 
		{
			
			$res = 1;
			return $concat.$res;
		}
	}
	public function mj_smgt_get_invoice_data($invoice_id)
	{
		global $wpdb;
		$table_invoice=$wpdb->prefix.'smgt_invoice';
	
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_invoice where invoice_id=%d",$invoice_id));
		return $result;
	}
	public function mj_smgt_get_all_invoice_data()
	{
		global $wpdb;
		$table_invoice=$wpdb->prefix.'smgt_invoice';
		
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_invoice"));
		return $result;
		
	}
	public function mj_smgt_delete_invoice($invoice_id)
	{
		global $wpdb;
		$table_invoice=$wpdb->prefix.'smgt_invoice';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_invoice where invoice_id=%d",$invoice_id));
		return $result;
	}
	public function mj_smgt_get_entry_records($data)
	{
			$all_income_entry=$data['income_entry'];
			$all_income_amount=$data['income_amount'];
			
			$entry_data=array();
			$i=0;
			foreach($all_income_entry as $one_entry)
			{
				$entry_data[]= array('entry'=>mj_smgt_strip_tags_and_stripslashes($one_entry),
							'amount'=>$all_income_amount[$i]);
					$i++;
			}
			return json_encode($entry_data);
	}
	public function mj_smgt_get_entry_total_amount($data)
	{
		$all_income_entry=$data['income_entry'];
		$all_income_amount=$data['income_amount'];
		
		$entry_amount=0;
		$i=0;
		foreach($all_income_entry as $one_entry)
		{
			$entry_amount+= $all_income_amount[$i];
			$i++;
		}
		return $entry_amount;
	}
	//---------Income----------------
	public function mj_smgt_add_income($data)
	{
		$entry_value = $this->mj_smgt_get_entry_records($data);
		$total_amount = $this->mj_smgt_get_entry_total_amount($data);
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$incomedata['invoice_type']=$data['invoice_type'];
		if(isset($data['class_id']))
			$incomedata['class_id']=sanitize_text_field($data['class_id']);
		if(isset($data['class_section']))
			$incomedata['section_id']=sanitize_text_field($data['class_section']);
		$incomedata['supplier_name']=sanitize_text_field($data['supplier_name']);
		
		$incomedata['income_create_date']=date('Y-m-d',strtotime($data['invoice_date'])); 
		
		$incomedata['payment_status']=sanitize_text_field($data['payment_status']);
		$incomedata['entry']=$entry_value;
		$incomedata['create_by']=get_current_user_id();
		if (isset($data['tax'])) {
			$tax = implode(",", (array)$_POST['tax']);
			$tax_amount = MJ_smgt_get_tax_amount($total_amount, $data['tax']);
		} else {
			$tax = null;
			$tax_amount = 0;
		}
		$incomedata['tax'] = $tax;
		$incomedata['tax_amount']= $tax_amount;
		
		if($data['action']=='edit')
		{
			
			$income_dataid['income_id']=intval($data['income_id']);
			$result=$wpdb->update( $table_income, $incomedata ,$income_dataid);
			$student = mj_smgt_get_user_name_byid(sanitize_text_field($incomedata['supplier_name']));
			school_append_audit_log(''.esc_html__('Income Updated','school-mgt').'('.$student.')'.'',get_current_user_id(),get_current_user_id(),'edit',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		elseif($data['action']=='edit_payment')
		{
			// DELETE PAYMENT RECORD AND ADD IN INCOME RECORD
			$tablename = "smgt_payment";
			$delete_payment = delete_mj_smgt_payment($tablename, $data['payment_id']);
			$result=$wpdb->insert( $table_income,$incomedata);
			$student = mj_smgt_get_user_name_byid(sanitize_text_field($incomedata['supplier_name']));
			school_append_audit_log(''.esc_html__('Income Added','school-mgt').'('.$student.')'.'',get_current_user_id(),get_current_user_id(),'insert',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			
			$result=$wpdb->insert( $table_income,$incomedata);
			$student = mj_smgt_get_user_name_byid(sanitize_text_field($incomedata['supplier_name']));
			school_append_audit_log(''.esc_html__('Income Added','school-mgt').'('.$student.')'.'',get_current_user_id(),get_current_user_id(),'insert',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	public function mj_smgt_get_all_income_data()
	{
		global $wpdb;
		$invoice_type='income';
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where invoice_type=%s",$invoice_type));
		return $result;
	}
	public function mj_smgt_get_income_data($income_id)
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
	
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_income where income_id=%d",$income_id));
		return $result;
	}
	public function mj_smgt_get_income_own_data($user_id)
	{
		global $wpdb;
		$invoice_type='income';
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where invoice_type=%s and supplier_name=%d",$invoice_type,$user_id));
		return $result;
	}
	public function mj_smgt_get_income_own_data_for_parent()
	{
		global $wpdb;

		// Instantiate School_Management class with the current user ID
		$school_obj = new School_Management(get_current_user_id());
		$invoice_type = 'income';
		$child_list = $school_obj->child_list;

		// If no child is associated, return an empty array
		if (empty($child_list)) {
			return [];
		}

		// Sanitize and prepare child IDs for the query
		$child_ids = implode(',', array_map('intval', $child_list));
		$table_income = $wpdb->prefix . 'smgt_income_expense';

		// Use a secure and correctly formatted query with the IN clause
		$query = "SELECT * FROM $table_income WHERE invoice_type = %s AND supplier_name IN ($child_ids)";
		$result = $wpdb->get_results($wpdb->prepare($query, $invoice_type));

		return $result;
	}

	public function mj_smgt_get_income_data_created_by($user_id)
	{
		global $wpdb;
		$invoice_type='income';
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where invoice_type=%s and create_by=%d",$invoice_type,$user_id));
		return $result;
	}
	public function mj_smgt_delete_income($income_id)
	{
		
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$event = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_income where income_id= %d",$income_id));
		$student = mj_smgt_get_user_name_byid($event->supplier_name);
		school_append_audit_log(''.esc_html__('Income Deleted','school-mgt').'('.$student.')'.'',get_current_user_id(),get_current_user_id(),'delete',sanitize_text_field($_REQUEST['page']));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_income where income_id= %d",$income_id));
		return $result;
	}
	public function mj_smgt_get_onepatient_income_data($patient_id)
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where supplier_name= '".$patient_id."' order by income_create_date desc"));
		if (is_numeric($patient_id)) 
		{
			// Treat as an ID (integer)
			$result = $wpdb->get_results($wpdb->prepare(
				"SELECT * FROM $table_income WHERE supplier_name = %d ORDER BY income_create_date DESC",
				$patient_id
			));
		} else {
			// Treat as a string
			$result = $wpdb->get_results($wpdb->prepare(
				"SELECT * FROM $table_income WHERE supplier_name = %s ORDER BY income_create_date DESC",
				sanitize_text_field($patient_id) // Sanitize the string input
			));
		}
		return $result;
	}
	//----------------- SINGLE RECORD FOR STUDENT -----------------//
	public function mj_smgt_get_onestudent_income_data($income_id)
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
	
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where income_id= %d",$income_id));
		
		return $result;
	}

	//-----------Expense-----------------
	public function mj_smgt_add_expense($data)
	{
		
		$entry_value=$this->mj_smgt_get_entry_records($data);
		
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$incomedata['invoice_type']=sanitize_text_field($data['invoice_type']);
		$incomedata['supplier_name']=sanitize_text_field($data['supplier_name']);
		$incomedata['income_create_date']=date('Y-m-d',strtotime($data['invoice_date']));
		$incomedata['payment_status']=sanitize_text_field($data['payment_status']);
		$incomedata['entry']=$entry_value;
		$incomedata['create_by']=get_current_user_id();
		
		if($data['action']=='edit')
		{
			
			$expense_dataid['income_id']=sanitize_text_field($data['expense_id']);
			$result=$wpdb->update( $table_income, $incomedata ,$expense_dataid);
	
			$suplier = $incomedata['supplier_name'];
			school_append_audit_log(''.esc_html__('Expense Updated','school-mgt').'('.$suplier.')'.'',get_current_user_id(),get_current_user_id(),'edit',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$result=$wpdb->insert( $table_income,$incomedata);
			$suplier = $incomedata['supplier_name'];
			school_append_audit_log(''.esc_html__('Expense Added','school-mgt').'('.$suplier.')'.'',get_current_user_id(),get_current_user_id(),'insert',sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	public function mj_smgt_delete_expense($expense_id)
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$event = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_income where income_id= %d,$expense_id"));
		$student = $event->supplier_name;
		school_append_audit_log(''.esc_html__('Expense Deleted','school-mgt').'('.$student.')'.'',get_current_user_id(),get_current_user_id(),'delete',sanitize_text_field($_REQUEST['page']));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_income where income_id=%d",$expense_id));
		return $result;
	}
	public function mj_smgt_get_all_expense_data()
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where invoice_type=%s",'expense'));
		return $result;
		
	}
	public function mj_smgt_get_all_expense_data_created_by($user_id)
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where invoice_type= %s and create_by=%d",'expense',$user_id));
		return $result;
	}
	public function mj_smgt_get_invoice_created_by($user_id)
	{
		global $wpdb;
		$table_income=$wpdb->prefix.'smgt_payment';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income where created_by=%d",$user_id));
		return $result;
	}
}
?>