<?php 
class Smgt_custome_field
{  /*<---START Lmgt_custome_field  CLASS--->*/
	/*<--- ADD CustomeField FUNCTION --->*/
	function mj_smgt_add_custom_field($custome_data) 
	{
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
		$wpnc_custom_field_dropdown_metas = $wpdb->prefix . 'custom_field_dropdown_metas';		
		
		$custom_field_data['field_label']=stripslashes(sanitize_text_field($custome_data['field_label']));	
		$validation_array_filter=array_filter($custome_data['validation']);	
		 
		 
		$custom_field_data['field_validation']=implode('|',$validation_array_filter);
		
		if($custome_data['field_visibility']=='')
		{
			$custom_field_data['field_visibility']=0;
		}
		else
		{
			$custom_field_data['field_visibility']=sanitize_text_field($custome_data['field_visibility']);
		}	
		
		if($custome_data['action']=='edit')	
		{ 	
			$custom_field_data['updated_by']=get_current_user_id();
			$custom_field_data['updated_at']=date("Y-m-d H:i:s");
			if(isset($custome_data['show_in_table']) && $custome_data['show_in_table'] != "")
		    {
			    $custom_field_data['show_in_table']=$custome_data['show_in_table'];
			}
			$whereid['id']=$custome_data['custom_field_id'];
			
			$update_custom_field=$wpdb->update($wpnc_custom_fields, $custom_field_data, $whereid);
			school_append_audit_log(''.esc_html__('Custom Field Updated','school-mgt').'',get_current_user_id(),get_current_user_id(),'edit',sanitize_text_field($_REQUEST['page']));
			
			// Dropdown Label Code
			if(isset($custome_data['d_label']))
			{
				$d_label = $custome_data['d_label'];
			}
            else
			{
				$d_label =null;
			}
			if(!empty($d_label))
			{
				//delete old value 
				
				$custom_field_id = $custome_data['custom_field_id']; // Assuming this is sanitized before use

				$query = $wpdb->prepare("DELETE FROM $wpnc_custom_field_dropdown_metas WHERE custom_fields_id = %d",$custom_field_id);

				$delete_custom_field_dropdown_data = $wpdb->query($query);
				
				foreach ($d_label as $key => $value)
				{
					$label = $d_label[$key];
										
					$custom_field_dropdown_data['custom_fields_id']=$custome_data['custom_field_id'];
					$custom_field_dropdown_data['option_label']=$label;
					$custom_field_dropdown_data['created_by']=get_current_user_id();
					$custom_field_dropdown_data['created_at']=date("Y-m-d H:i:s");
					$custom_field_dropdown_data['updated_by']=get_current_user_id();
					$custom_field_dropdown_data['updated_at']=date("Y-m-d H:i:s");
					
					$insert_custom_field_dropdown_data=$wpdb->insert($wpnc_custom_field_dropdown_metas, $custom_field_dropdown_data );
					
				}
			}
			
			// Checkbox Label Code
			if(isset($custome_data['c_label']))
			{
				$c_label =$custome_data['c_label'];
			}
            else
			{
				$c_label =null;
			}
			
			if(!empty($c_label))
			{
				//delete old value 
				$custom_field_id = $custome_data['custom_field_id']; // Assuming this is sanitized before use

				$query = $wpdb->prepare("DELETE FROM $wpnc_custom_field_dropdown_metas WHERE custom_fields_id = %d",$custom_field_id);

				$delete_custom_field_checkbox_data = $wpdb->query($query);
				
				foreach ($c_label as $key => $value)
				{
					$label = $c_label[$key];
					
					$custom_field_checkbox_data['custom_fields_id']=$custome_data['custom_field_id'];
					$custom_field_checkbox_data['option_label']=$label;
					$custom_field_checkbox_data['created_by']=get_current_user_id();
					$custom_field_checkbox_data['created_at']=date("Y-m-d H:i:s");
					$custom_field_checkbox_data['updated_by']=get_current_user_id();
					$custom_field_checkbox_data['updated_at']=date("Y-m-d H:i:s");
					
					$insert_custom_field_checkbox_data=$wpdb->insert($wpnc_custom_field_dropdown_metas, $custom_field_checkbox_data );
				}
			}
			
			// Radio Label Code
			if(isset($custome_data['r_label']))
			{
				$r_label = $custome_data['r_label'];
			}
            else
			{
				$r_label =null;
			}
			
			if(!empty($r_label))
			{
				//delete old value 
				$custom_field_id = $custome_data['custom_field_id']; // Assuming this is sanitized before use

				$query = $wpdb->prepare("DELETE FROM $wpnc_custom_field_dropdown_metas WHERE custom_fields_id = %d",$custom_field_id);

				$delete_custom_field_radio_data = $wpdb->query($query);
				
				foreach ($r_label as $key => $value)
				{
					$label = $r_label[$key];
					
					$custom_field_radio_data['custom_fields_id']=$custome_data['custom_field_id'];
					$custom_field_radio_data['option_label']=$label;
					$custom_field_radio_data['created_by']=get_current_user_id();
					$custom_field_radio_data['created_at']=date("Y-m-d H:i:s");
					$custom_field_radio_data['updated_by']=get_current_user_id();
					$custom_field_radio_data['updated_at']=date("Y-m-d H:i:s");
					
					$insert_custom_field_radio_data=$wpdb->insert($wpnc_custom_field_dropdown_metas, $custom_field_radio_data );
				}
			}
			return $custome_data['custom_field_id'];
		}
		else
		{ 
			
			$custom_field_data['form_name']=$custome_data['form_name'];
			$custom_field_data['field_type']=$custome_data['field_type'];
			$custom_field_data['created_by']=get_current_user_id();
			$custom_field_data['created_at']=date("Y-m-d H:i:s");

			if(isset($custome_data['show_in_table']) && $custome_data['show_in_table'] != "")
		    {
			    $custom_field_data['show_in_table']=$custome_data['show_in_table'];
			}
			$insert_custom_field=$wpdb->insert($wpnc_custom_fields, $custom_field_data);
            $custom_field_id = $wpdb->insert_id;
			school_append_audit_log(''.esc_html__('Custom Field Added','school-mgt').'',get_current_user_id(),get_current_user_id(),'insert',sanitize_text_field($_REQUEST['page']));			
			
			// Dropdown Label Code
		
			if(isset($custome_data['d_label']))
			{
				$d_label = $custome_data['d_label'];
			}
            else
			{
				$d_label =null;
			}

			if(!empty($d_label))
			{
				foreach ($d_label as $key => $value)
				{
					$label = $d_label[$key];
										
					$custom_field_dropdown_data['custom_fields_id']=$custom_field_id;
					$custom_field_dropdown_data['option_label']=$label;
					$custom_field_dropdown_data['created_by']=get_current_user_id();
					$custom_field_dropdown_data['created_at']=date("Y-m-d H:i:s");
					$custom_field_dropdown_data['updated_by']=get_current_user_id();
					$custom_field_dropdown_data['updated_at']=date("Y-m-d H:i:s");
					
					$insert_custom_field_dropdown_data=$wpdb->insert($wpnc_custom_field_dropdown_metas, $custom_field_dropdown_data );
				}
			}
			
			// Checkbox Label Code
			
			if(isset($custome_data['c_label']))
			{
				$c_label =$custome_data['c_label'];
			}
            else
			{
				$c_label =null;
			}
			if(!empty($c_label))
			{
				foreach ($c_label as $key => $value)
				{
					$label = $c_label[$key];
					
					$custom_field_checkbox_data['custom_fields_id']=$custom_field_id;
					$custom_field_checkbox_data['option_label']=$label;
					$custom_field_checkbox_data['created_by']=get_current_user_id();
					$custom_field_checkbox_data['created_at']=date("Y-m-d H:i:s");
					$custom_field_checkbox_data['updated_by']=get_current_user_id();
					$custom_field_checkbox_data['updated_at']=date("Y-m-d H:i:s");
					
					$insert_custom_field_checkbox_data=$wpdb->insert($wpnc_custom_field_dropdown_metas, $custom_field_checkbox_data );
				}
			}
			
			// Radio Label Code
			if(isset($custome_data['r_label']))
			{
				$r_label = $custome_data['r_label'];
			}
            else
			{
				$r_label =null;
			}
			
			if(!empty($r_label))
			{
				foreach ($r_label as $key => $value)
				{
					$label = $r_label[$key];
					
					$custom_field_radio_data['custom_fields_id']=$custom_field_id;
					$custom_field_radio_data['option_label']=$label;
					$custom_field_radio_data['created_by']=get_current_user_id();
					$custom_field_radio_data['created_at']=date("Y-m-d H:i:s");
					$custom_field_radio_data['updated_by']=get_current_user_id();
					$custom_field_radio_data['updated_at']=date("Y-m-d H:i:s");
					
					$insert_custom_field_radio_data=$wpdb->insert($wpnc_custom_field_dropdown_metas, $custom_field_radio_data );
				}
			}
		    
			return $custom_field_id;
		}
	}
	//Get All Custom Field Data Function//
	function mj_smgt_get_all_custom_field_data() {
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
	
		$get_custom_field_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_fields WHERE field_visibility != %d ORDER BY created_at DESC",2)
		);
		return $get_custom_field_data;
	}
	
	//Get All Custom Field Data Function//
	function mj_smgt_get_all_custom_field_data_own() {
		$created_by = get_current_user_id(); // Get the current user's ID
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
	
		$get_custom_field_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_fields WHERE created_by = %d AND field_visibility != %d ORDER BY created_at DESC",$created_by, 2)
		);
		return $get_custom_field_data;
	}
	
	//Get Single Custom Field Data Function//
	function mj_smgt_get_single_custom_field_data($cf_id) {
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
		$custom_fields_id = intval($cf_id);
		$single_custom_field_data = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_fields WHERE id = %d",$custom_fields_id)
		);
		return $single_custom_field_data;
	}
	
	//Get Single Custom Field Dropdown Meta Data By Custom Field Id Function//
	function mj_smgt_get_single_custom_field_dropdown_meta_data($cf_id) {
		global $wpdb;
		$wpnc_custom_field_dropdown_metas = $wpdb->prefix . 'custom_field_dropdown_metas';
		$custom_fields_id = intval($cf_id);
		$custom_field_dropdown_meta_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_field_dropdown_metas WHERE custom_fields_id = %d",$custom_fields_id)
		);
		return $custom_field_dropdown_meta_data;
	}
	
	/*<---DELETE Custom Field  FUNCTION--->*/
	public function mj_smgt_delete_custome_field($id)
	{
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
		$custom_field['field_visibility']=2;
		$whereid['id']=intval($id);
		$delete_rules=$wpdb->update($wpnc_custom_fields, $custom_field, $whereid);
		return $delete_rules;
	}
	/*<---DELETE MULTIPLE RECORD  FUNCTION--->*/
	public function mj_smgt_delete_selected_custome_field($record_id)
	{	
	
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
		$custom_field['field_visibility']=2;
		$whereid['id']=intval($record_id);
		$result=$wpdb->update($wpnc_custom_fields, $custom_field, $whereid);
		return $result;
	}
	//Get Custom Field By Module Function//
	function mj_smgt_getCustomFieldByModule($module) {
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
	
		$get_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_fields WHERE form_name = %s AND field_visibility = %d",$module, 1 )
		);
		return $get_data;
	}
	
	//Get Single Custom Field Meta value BY Module and ID Function//
	function mj_smgt_get_single_custom_field_meta_value($module, $m_id, $cf_id) {
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		$custom_field_id = intval($cf_id);
		$module_record_id = intval($m_id);
		$get_data = $wpdb->get_row(
			$wpdb->prepare("SELECT field_value FROM $wpnc_custom_field_metas WHERE module = %s AND module_record_id = %d AND custom_fields_id = %d",$module,$module_record_id,$custom_field_id)
		);
	
		if (!empty($get_data)) {
			return $get_data->field_value;
		} else {
			return '';
		}
	}
	
	//Get Custom Field Dropdown value BY ID Function//
	function mj_smgt_getDropDownValue($cf_id) {
		global $wpdb;
		$wpnc_custom_field_dropdown_metas = $wpdb->prefix . 'custom_field_dropdown_metas';
		$custom_field_id = intval($cf_id);
		$get_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_field_dropdown_metas WHERE custom_fields_id = %d",$custom_field_id)
		);
		return $get_data;
	}
	
	//Check The Label is Checkbox Or Not	
	function mj_smgt_getCheckedCheckbox($cf_id)
	{
		global $wpdb;
		$wpnc_custom_fields = $wpdb->prefix . 'custom_field';
		$custom_field_id = intval($cf_id);
		$get_data = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_fields WHERE id = %d",$custom_field_id)
		);
		
		if(!empty($get_data))
		{
			$f_type = $get_data->field_type;
			if($f_type == 'checkbox')
			{
				return 1;
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}
	}	
	//Add Custom Field Meta Data Function//
	function mj_smgt_add_custom_field_metas($module,$custom,$module_record_id) 
	{		
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		
		if(!empty($custom))
		{
			foreach($custom as $key=>$value)
			{				
				$value = $custom[$key];
				$checkboxreturn =$this->mj_smgt_getCheckedCheckbox($key);
												
				$custom_meta_data['module']=$module;
				$custom_meta_data['module_record_id']=$module_record_id;
				$custom_meta_data['custom_fields_id']=$key;
				
				if (!empty($checkboxreturn)) 
				{
					$custom_meta_data['field_value']=implode(",",$value);
				} 				
				else 
				{
					$custom_meta_data['field_value']=$value;
				}
				
				$custom_meta_data['created_at']=date("Y-m-d H:i:s");
				$custom_meta_data['updated_at']=date("Y-m-d H:i:s");
				
				$insert_custom_meta_data=$wpdb->insert($wpnc_custom_field_metas, $custom_meta_data );	
			}			
		}	
		return $insert_custom_meta_data;
	}
	//Check Custom Field Old or New //	
	function mj_smgt_check_field_old_or_new($module, $m_id, $cf_id) {
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		$module_record_id = intval($m_id);
		$custom_field_id = intval($cf_id);
		$get_data = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_field_metas WHERE module = %s AND module_record_id = %d AND custom_fields_id = %d",$module,$module_record_id,$custom_field_id)
		);
		return $get_data;
	}
	
	//Update Custom Field Meta Data Function//
	function mj_smgt_update_custom_field_metas($module,$custom,$module_record_id) 
	{		
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		
		if(!empty($custom))
		{
			foreach($custom as $key=>$value)
			{
				$value = $custom[$key];
				$checkboxreturn =$this->mj_smgt_getCheckedCheckbox($key);
				
				$check_field_old_or_new=$this->mj_smgt_check_field_old_or_new($module,$module_record_id,$key);
				
				if(!empty($check_field_old_or_new))
				{	
					if (!empty($checkboxreturn)) 
					{
						$field_value=implode(",",$value);
					} 
					else 
					{
						$field_value=$value;
					}
					$updated_at=date("Y-m-d H:i:s");
					
					$update_custom_meta_data =$wpdb->query($wpdb->prepare("UPDATE `$wpnc_custom_field_metas` SET `field_value` = '$field_value',updated_at='$updated_at' WHERE `$wpnc_custom_field_metas`.`module` = %s AND  `$wpnc_custom_field_metas`.`module_record_id` = %d AND `$wpnc_custom_field_metas`.`custom_fields_id` = %d",$module,$module_record_id,$key));
				}
				else
				{
					$custom_meta_data['module']=$module;
					$custom_meta_data['module_record_id']=$module_record_id;
					$custom_meta_data['custom_fields_id']=$key;
					
					if (!empty($checkboxreturn)) 
					{
						$custom_meta_data['field_value']=implode(",",$value);
					} 
					else 
					{
						$custom_meta_data['field_value']=$value;
					}
					$custom_meta_data['created_at']=date("Y-m-d H:i:s");
					$custom_meta_data['updated_at']=date("Y-m-d H:i:s");
					
					$update_custom_meta_data=$wpdb->insert($wpnc_custom_field_metas, $custom_meta_data );	
				}
			}					
		}	
		return $update_custom_meta_data;
	}
	
	//Get Single custom_fields_id Meta value BY  module_record_id Function//
	function mj_smgt_get_single_custom_fields_id_meta_value($m_id) {
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		$module_record_id = intval($m_id);
		$get_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_field_metas WHERE module_record_id = %d",$module_record_id)
		);
		return $get_data;
	}
	
	
	//Get Single Custom field_value value BY custom_fields_id Function//
	function mj_smgt_get_single_field_value_meta_value($cf_id) {
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		$custom_field_id = intval($cf_id);
		$get_data = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $wpnc_custom_field_metas WHERE custom_fields_id = %d",$custom_field_id)
		);
		return $get_data;
	}
	

	function mj_smgt_get_single_field_value_meta_value_by_filed_and_student_id($id, $cf_id) {
		global $wpdb;
		$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
		$custom_field_id = intval($cf_id);
		$student_id = intval($id);
		$get_data = $wpdb->get_row(
			$wpdb->prepare("SELECT field_value FROM $wpnc_custom_field_metas WHERE module_record_id = %d AND custom_fields_id = %d",$student_id,$custom_field_id)
		);
	
		if (!empty($get_data)) {
			return $get_data->field_value;
		} else {
			return '';
		}
	}
	
	// MODULE VISE CUSTOME FIELD FOR PARTICULAR ID
	function MJ_smgt_get_custom_field_by_module($module)
	{
		$compact_custom_field = $this->mj_smgt_getCustomFieldByModule($module);
		$edit = 0;
		if(isset($_REQUEST['action']) && ($_REQUEST['action'] == 'edit'))
		{
			$edit = 1;
		}
		if (!empty($compact_custom_field)) {
		?>
			<div class="header">
				<h3 class="first_hed margin_top_0px_image"><?php esc_html_e('Custom Fields', 'school-mgt'); ?></h3>
			</div>
			<script>
				function mj_smgt_custom_filed_fileCheck(obj) {
					"use strict";
					var fileExtension = $(obj).attr('file_types');
					var fileExtensionArr = fileExtension.split(',');
					var file_size = $(obj).attr('file_size');
					var sizeInkb = obj.files[0].size / 1024;
					if ($.inArray($(obj).val().split('.').pop().toLowerCase(), fileExtensionArr) == -1)
					{
						alert("Only " + fileExtension + " formats are allowed.");
						$(obj).val('');
					}
				}
				jQuery(document).ready(function($) {
					// Custom Date Picker
					$('.custom_datepicker').datepicker({
						dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
						endDate: '+0d',
						autoclose: true,
						changeMonth: true,
						changeYear: true,
						orientation: "bottom" // <-- and add this
					});
					$('.space_validation').on('keypress', function(e) {
						if (e.which === 32)
							return false;
					});
					//custom field datepicker
					$('.after_or_equal').datepicker({
						dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
						minDate: 0,
						changeMonth: true,
						changeYear: true,
						beforeShow: function(textbox, instance) {
							instance.dpDiv.css({
								marginTop: (-textbox.offsetHeight) + 'px'
							});
						}
					});
					$('.date_equals').datepicker({
						dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
						minDate: 0,
						maxDate: 0,
						changeMonth: true,
						changeYear: true,
						beforeShow: function(textbox, instance) {
							instance.dpDiv.css({
								marginTop: (-textbox.offsetHeight) + 'px'
							});
						}
					});
					$('.before_or_equal').datepicker({
						dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
						maxDate: 0,
						changeMonth: true,
						changeYear: true,
						beforeShow: function(textbox, instance) {
							instance.dpDiv.css({
								marginTop: (-textbox.offsetHeight) + 'px'
							});
						}
					});
				});
			</script>
			<div class="form-body user_form">
				<div class="row">
					<?php
					foreach ($compact_custom_field as $custom_field) {
						if ($edit && (isset($_REQUEST['student_id']))) 
						{
							$custom_field_id = $custom_field->id;
							$module_record_id = intval($_REQUEST['student_id']);
							$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
						}
						if ($edit && (isset($_REQUEST['id']))) 
						{
							$custom_field_id = $custom_field->id;
							$module_record_id = intval($_REQUEST['id']);
							$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
							
						}
						if ($edit && (isset($_REQUEST['teacher_id']))) 
						{
							$custom_field_id = $custom_field->id;
							$module_record_id = intval($_REQUEST['teacher_id']);
							$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
						}
						if ($edit && (isset($_REQUEST['supportstaff_id']))) 
						{
							$custom_field_id = $custom_field->id;
							$module_record_id = intval($_REQUEST['supportstaff_id']);
							$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
						}
						if ($edit && (isset($_REQUEST['parent_id']))) 
						{
							$custom_field_id = $custom_field->id;
							$module_record_id = intval($_REQUEST['parent_id']);
							$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
						}
						// Custom Field Validation // 
						$exa = explode('|', $custom_field->field_validation);
						$min = "";
						$max = "";
						$required = "";
						$red = "";
						$limit_value_min = "";
						$limit_value_max = "";
						$numeric = "";
						$alpha = "";
						$space_validation = "";
						$alpha_space = "";
						$alpha_num = "";
						$email = "";
						$url = "";
						$minDate = "";
						$maxDate = "";
						$file_types = "";
						$file_size = "";
						$datepicker_class = "";
						foreach ($exa as $key => $value) {
							if (strpos($value, 'min') !== false) {
								$min = $value;
								$limit_value_min = substr($min, 4);
							} elseif (strpos($value, 'max') !== false) {
								$max = $value;
								$limit_value_max = substr($max, 4);
							} elseif (strpos($value, 'required') !== false) {
								$required = "required";
								$red = "*";
							} elseif (strpos($value, 'numeric') !== false) {
								$numeric = "onlyNumberSp";
							} elseif ($value == 'alpha') {
								$alpha = "onlyLetterSp";
								$space_validation = "space_validation";
							} elseif ($value == 'alpha_space') {
								$alpha_space = "onlyLetterSp";
							} elseif (strpos($value, 'alpha_num') !== false) {
								$alpha_num = "onlyLetterNumber";
							} elseif (strpos($value, 'email') !== false) {
								$email = "email";
							} elseif (strpos($value, 'url') !== false) {
								$url = "url";
							} elseif (strpos($value, 'after_or_equal:today') !== false) {
								$minDate = 1;
								$datepicker_class = 'after_or_equal';
							} elseif (strpos($value, 'date_equals:today') !== false) {
								$minDate = $maxDate = 1;
								$datepicker_class = 'date_equals';
							} elseif (strpos($value, 'before_or_equal:today') !== false) {
								$maxDate = 1;
								$datepicker_class = 'before_or_equal';
							} elseif (strpos($value, 'file_types') !== false) {
								$types = $value;
								$file_types = substr($types, 11);
							} elseif (strpos($value, 'file_upload_size') !== false) {
								$size = $value;
								$file_size = substr($size, 17);
							}
						}
						$option = $this->mj_smgt_getDropDownValue($custom_field->id);
						$data = 'custom.' . $custom_field->id;
						$datas = 'custom.' . $custom_field->id;
						if ($custom_field->field_type == 'text') 
						{
						?>
							<div class="col-md-6">
								<div class="form-group input">
									<div class="col-md-12 form-control">
										<input class="form-control hideattar<?php echo $custom_field->form_name; ?> validate[<?php if (!empty($required)) { echo $required; ?>,<?php } ?><?php if (!empty($limit_value_min)) { ?> minSize[<?php echo $limit_value_min; ?>],<?php }if (!empty($limit_value_max)) { ?> maxSize[<?php echo $limit_value_max; ?>],<?php }if ($numeric != '' || $alpha != '' || $alpha_space != '' || $alpha_num != '' || $email != '' || $url != '') { ?> custom[<?php echo $numeric; echo $alpha; echo $alpha_space; echo $alpha_num; echo $email; echo $url; ?>]<?php } ?>] <?php echo $space_validation; ?>" type="text" name="custom[<?php echo $custom_field->id; ?>]" id="<?php echo $custom_field->id; ?>" label="<?php echo $custom_field->field_label; ?>" <?php if ($edit) { ?> value="<?php echo $custom_field_value; ?>" <?php } ?>>
										<label for="<?php echo $custom_field->id; ?>" class=""><?php esc_html_e($custom_field->field_label, 'school-mgt'); ?><span class="required red"><?php echo $red; ?></span></label>
									</div>
								</div>
							</div>
						<?php
						} 
						elseif ($custom_field->field_type == 'textarea') 
						{
						?>
							<div class="col-md-6 note_text_notice">
								<div class="form-group input">
									<div class="col-md-12 note_border">
										<div class="form-field">
											<textarea rows="3" class="textarea_height_47px form-control hideattar<?php echo $custom_field->form_name; ?> validate[<?php if (!empty($required)) { echo $required; ?>,<?php } ?><?php if (!empty($limit_value_min)) { ?> minSize[<?php echo $limit_value_min; ?>],<?php } if (!empty($limit_value_max)) { ?> maxSize[<?php echo $limit_value_max; ?>],<?php } if ($numeric != '' || $alpha != '' || $alpha_space != '' || $alpha_num != '' || $email != '' || $url != '') { ?> custom[<?php echo $numeric; echo $alpha; echo $alpha_space; echo $alpha_num; echo $email; echo $url; ?>]<?php } ?>] <?php echo $space_validation; ?>" name="custom[<?php echo $custom_field->id; ?>]" id="<?php echo $custom_field->id; ?>" label="<?php echo $custom_field->field_label; ?>"><?php if ($edit) { echo $custom_field_value; } ?></textarea>
											<span class="txt-title-label"></span>
											<label for="photo" class="text-area address"><?php esc_attr_e($custom_field->field_label, 'school-mgt'); ?><span class="required red"><?php echo $red; ?></span></label>
										</div>
									</div>
								</div>
							</div>
						<?php
						} 
						elseif ($custom_field->field_type == 'date') 
						{
						?>
							<div class="col-md-6">
								<div class="form-group input">
									<div class="col-md-12 form-control">
										<input class="form-control date_picker custom_datepicker <?php echo $datepicker_class; ?> hideattar<?php echo $custom_field->form_name; ?> <?php if (!empty($required)) { ?> validate[<?php echo $required; ?>] <?php } ?>" type="text" name="custom[<?php echo $custom_field->id; ?>]" <?php if ($edit) { ?> value="<?php if (!empty($custom_field_value)) { echo mj_smgt_getdate_in_input_box($custom_field_value);} ?>" <?php } else { ?> value="<?php echo mj_smgt_getdate_in_input_box(date('Y-m-d')); ?><?php } ?>" id="<?php echo $custom_field->id; ?>" label="<?php echo $custom_field->field_label; ?>">
										<label for="" class="date_label"><?php esc_html_e($custom_field->field_label, 'school-mgt'); ?><span class="required red"><?php echo $red; ?></span></label>
									</div>
								</div>
							</div>
						<?php
						} 
						elseif ($custom_field->field_type == 'dropdown') 
						{
						?>
							<div class="col-md-6 col-sm-6 input">
								<label for="photo" class="ml-1 custom-top-label top"><?php esc_attr_e($custom_field->field_label, 'school-mgt'); ?><span class="required red"><?php echo $red; ?></span></label>
								<select class="form-control standard_category line_height_30px  hideattar<?php echo $custom_field->form_name; ?> <?php if (!empty($required)) { ?> validate[<?php echo $required; ?>] <?php } ?>" name="custom[<?php echo $custom_field->id; ?>]" id="<?php echo $custom_field->id; ?>" label="<?php echo $custom_field->field_label; ?>">
									<option value=""><?php esc_attr_e('Select', 'school-mgt'); ?></option>
									<?php
									if (!empty($option)) 
									{
										foreach ($option as $options) 
										{
										?>
											<option value="<?php echo $options->option_label; ?>" <?php if ($edit) { echo selected($custom_field_value, $options->option_label);} ?>> <?php echo $options->option_label; ?></option>
										<?php
										}
									}
									?>
								</select>
							</div>
						<?php
						} 
						elseif ($custom_field->field_type == 'checkbox') 
						{
						?>
							<div class="col-md-6 mb-3 smgt_main_custome_field">
								<div class="form-group">
									<div class="col-md-12 form-control">
										<div class="row padding_radio">
											<div class="">
												<label class="custom-top-label margin_left_0"><?php echo $custom_field->field_label; ?><span class="required red"><?php echo $red; ?></span></label>
												<?php
												if (!empty($option)) 
												{
													foreach ($option as $options) 
													{
														if ($edit) 
														{
															$custom_field_value_array = explode(',', $custom_field_value);
														}
														?>
														<label class="me-2">
															<input type="checkbox" value="<?php echo $options->option_label; ?>" <?php if ($edit) { echo checked(in_array($options->option_label, $custom_field_value_array));} ?> class="hideattar<?php echo $custom_field->form_name; ?><?php if (!empty($required)) { ?> validate[<?php echo $required; ?>] <?php } ?>" name="custom[<?php echo $custom_field->id; ?>][]">&nbsp;&nbsp;<span class="span_left_custom" style="margin-bottom: -5px;"><?php echo $options->option_label; ?></span>
														</label>
														<?php
													}
												}
												?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php
						} 
						elseif ($custom_field->field_type == 'radio') 
						{
						?>
							<div class="col-md-6 mb-3 rtl_margin_top_15px">
								<div class="form-group">
									<div class="col-md-12 form-control">
										<div class="row padding_radio">
											<div class="input-group">
												<label class="custom-top-label margin_left_0"><?php esc_html_e($custom_field->field_label, 'school-mgt'); ?><span class="required red"><?php echo $red; ?></span></label>
												<?php
												if (!empty($option)) 
												{
													foreach ($option as $options) 
													{
													?>
														<div class="d-inline-block">
															<label class="radio-inline">
																<input type="radio" value="<?php echo $options->option_label; ?>" <?php if ($edit) { echo checked($options->option_label, $custom_field_value);} ?> name="custom[<?php echo $custom_field->id; ?>]" class="custom-control-input hideattar<?php echo $custom_field->form_name; ?> <?php if (!empty($required)) { ?> validate[<?php echo $required; ?>] <?php } ?>" id="<?php echo $options->option_label; ?>">
																<?php echo $options->option_label; ?>
															</label>&nbsp;&nbsp;
														</div>
													<?php
													}
												}
												?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php
						} 
						elseif ($custom_field->field_type == 'file') 
						{
						?>
							<div class="col-md-6">
								<div class="form-group input">
									<div class="col-md-12 form-control upload-profile-image-patient res_rtl_height_50px">
										<label for="photo" class="custom-control-label custom-top-label ml-2"><?php esc_attr_e($custom_field->field_label, 'school-mgt'); ?><span class="required red"><?php echo $red; ?></span></label>
										<div class="col-sm-12 display_flex">
											<input type="hidden" name="hidden_custom_file[<?php echo $custom_field->id; ?>]" value="<?php if ($edit) { echo $custom_field_value; } ?>">
											<input type="file" onchange="mj_smgt_custom_filed_fileCheck(this);" Class="form-control file hideattar<?php echo $custom_field->form_name; if ($edit) { if (!empty($required)) { if ($custom_field_value == '') { ?> validate[<?php echo $required; ?>] <?php } } } else { if (!empty($required)) { ?> validate[<?php echo $required; ?>] <?php } } ?>" name="custom_file[<?php echo $custom_field->id; ?>]" <?php if ($edit) { ?> value="<?php echo $custom_field_value; ?>" <?php } ?> id="<?php echo $custom_field->id; ?>" file_types="<?php echo $file_types; ?>" file_size="<?php echo $file_size; ?>">
										</div>
										<?php
										if (!empty($custom_field_value)) {
										?>
											<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
												<a target="blank" class="status_read btn btn-default" href="<?php print content_url() . '/uploads/school_assets/' . $custom_field_value; ?>">
												<i class="fa fa-download"></i>&nbsp;&nbsp;<?php esc_attr_e('Download', 'school-mgt'); ?></a>
											</div>
										<?php
										}
										?>
									</div>
								</div>
							</div>
						<?php
						}
					}
					?>
				</div>
			</div>
		<?php
		}
	}

	// INSERT THE CUSTOMFIELED DATA MODULE VISE
	function MJ_smgt_insert_custom_field_data_module_vise($module, $module_id)
	{
		$custom_field_file_array = array();
		if (!empty($_FILES['custom_file']['name'])) {
			$count_array = count($_FILES['custom_file']['name']);
			for ($a = 0; $a < $count_array; $a++) {
				foreach ($_FILES['custom_file'] as $image_key => $image_val) {
					foreach ($image_val as $image_key1 => $image_val2) {
						if ($_FILES['custom_file']['name'][$image_key1] != '') {
							$custom_file_array[$image_key1] = array(
								'name' => $_FILES['custom_file']['name'][$image_key1],
								'type' => $_FILES['custom_file']['type'][$image_key1],
								'tmp_name' => $_FILES['custom_file']['tmp_name'][$image_key1],
								'error' => $_FILES['custom_file']['error'][$image_key1],
								'size' => $_FILES['custom_file']['size'][$image_key1]
							);
						}
					}
				}
			}
			if (!empty($custom_file_array)) {
				foreach ($custom_file_array as $key => $value) {
					global $wpdb;
					$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
					$get_file_name = $custom_file_array[$key]['name'];
					$custom_field_file_value = mj_smgt_load_documets_new($value, $value, $get_file_name);

					//Add File in Custom Field Meta//
					$custom_meta_data['module'] = $module;
					$custom_meta_data['module_record_id'] = $module_id;
					$custom_meta_data['custom_fields_id'] = $key;
					$custom_meta_data['field_value'] = $custom_field_file_value;
					$custom_meta_data['created_at'] = date("Y-m-d H:i:s");
					$custom_meta_data['updated_at'] = date("Y-m-d H:i:s");
					$insert_custom_meta_data = $wpdb->insert($wpnc_custom_field_metas, $custom_meta_data);
				}
			}
		}
		$add_custom_field = $this->mj_smgt_add_custom_field_metas($module, $_POST['custom'], $module_id);
	}


	// UPDATE THE CUSTOMFIELED DATA MODULE VISE
	function MJ_smgt_update_custom_field_data_module_vise($module, $module_id)
	{
		$custom_field_file_array = array();
		if (!empty($_FILES['custom_file']['name'])) {
			$count_array = count($_FILES['custom_file']['name']);
			for ($a = 0; $a < $count_array; $a++) {
				foreach ($_FILES['custom_file'] as $image_key => $image_val) {
					foreach ($image_val as $image_key1 => $image_val2) {
						if ($_FILES['custom_file']['name'][$image_key1] != '') {
							$custom_file_array[$image_key1] = array(
								'name' => $_FILES['custom_file']['name'][$image_key1],
								'type' => $_FILES['custom_file']['type'][$image_key1],
								'tmp_name' => $_FILES['custom_file']['tmp_name'][$image_key1],
								'error' => $_FILES['custom_file']['error'][$image_key1],
								'size' => $_FILES['custom_file']['size'][$image_key1]
							);
						}
					}
				}
			}
			$file_value = $_REQUEST['hidden_custom_file'];
			foreach ($file_value as $filed_key => $filed_val) {

				if ($filed_val != "") {

					if (!empty($custom_file_array)) {
						foreach ($custom_file_array as $key => $value) {
							global $wpdb;
							$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
							$get_file_name = $custom_file_array[$key]['name'];
							$custom_field_file_value = mj_smgt_load_documets_new($value, $value, $get_file_name);
							//Add File in Custom Field Meta//				
							$updated_at = date("Y-m-d H:i:s");
							$update_custom_meta_data = $wpdb->query($wpdb->prepare("UPDATE `$wpnc_custom_field_metas` SET `field_value` = '$custom_field_file_value',updated_at='$updated_at' WHERE `$wpnc_custom_field_metas`.`module` = %s AND  `$wpnc_custom_field_metas`.`module_record_id` = %d AND `$wpnc_custom_field_metas`.`custom_fields_id` = %d", $module, $module_id, $key));
						}
					}
				} else {

					if (!empty($custom_file_array)) {
						foreach ($custom_file_array as $key => $value) {
							global $wpdb;
							$wpnc_custom_field_metas = $wpdb->prefix . 'custom_field_metas';
							$get_file_name = $custom_file_array[$key]['name'];
							$custom_field_file_value = mj_smgt_load_documets_new($value, $value, $get_file_name);

							//Add File in Custom Field Meta//
							$custom_meta_data['module'] = $module;
							$custom_meta_data['module_record_id'] = $module_id;
							$custom_meta_data['custom_fields_id'] = $key;
							$custom_meta_data['field_value'] = $custom_field_file_value;
							$custom_meta_data['created_at'] = date("Y-m-d H:i:s");
							$custom_meta_data['updated_at'] = date("Y-m-d H:i:s");
							$insert_custom_meta_data = $wpdb->insert($wpnc_custom_field_metas, $custom_meta_data);
						}
					}
				}
			}
		}

		$update_custom_field = $this->mj_smgt_update_custom_field_metas($module, $_POST['custom'], $module_id);
	}

	// SHOW INSERTED CUSTOMFIELD DATA IN DETAIL PAGE
	function MJ_smgt_show_inserted_customfield_data_in_datail_page($module)
	{
		$user_custom_field = $this->mj_smgt_getCustomFieldByModule($module);
		if (!empty($user_custom_field)) 
		{
		?>
			<div class="col-xl-12 col-md-12 col-sm-12 margin_top_20px margin_top_15px_rs rtl_padding_0px">
				<div class="guardian_div">
					<label class="view_page_label_heading"> <?php esc_html_e('Other Information', 'school-mgt'); ?> </label>
					<div class="row">
						<?php
						foreach ($user_custom_field as $custom_field) 
						{
							if(isset($_REQUEST['id']))
							{
								$custom_field_id = $custom_field->id;
								$module_record_id = $_REQUEST['id'];
								$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
							}
							if(isset($_REQUEST['student_id']))
							{
								$custom_field_id = $custom_field->id;
								$module_record_id = $_REQUEST['student_id'];
								$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
							}
							if(isset($_REQUEST['teacher_id']))
							{
								$custom_field_id = $custom_field->id;
								$module_record_id = $_REQUEST['teacher_id'];
								$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
							}
							if(isset($_REQUEST['supportstaff_id']))
							{
								$custom_field_id = $custom_field->id;
								$module_record_id = $_REQUEST['supportstaff_id'];
								$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
							}
							if(isset($_REQUEST['parent_id']))
							{
								$custom_field_id = $custom_field->id;
								$module_record_id = $_REQUEST['parent_id'];
								$custom_field_value = $this->mj_smgt_get_single_custom_field_meta_value($module, $module_record_id, $custom_field_id);
							}
							?>
							<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
								<p class="view_page_header_labels"><?php esc_attr_e('' . $custom_field->field_label . '', 'school-mgt'); ?></p>
								<?php
								if ($custom_field->field_type == 'date') {
									?>
									<p class="view_page_header_labels"><?php if (!empty($custom_field_value)) { echo mj_smgt_getdate_in_input_box($custom_field_value); } else { echo 'N/A'; } ?></p>
									<?php
								} 
								elseif ($custom_field->field_type == 'file') 
								{
									if (!empty($custom_field_value)) 
									{
										?>
											<a target="" href="<?php echo content_url() . '/uploads/school_assets/' . $custom_field_value; ?>" download="CustomFieldfile"><button class="btn btn-default view_document" type="button">
											<i class="fa fa-download"></i> <?php esc_attr_e('Download', 'school-mgt'); ?></button></a>
										<?php
									} 
									else 
									{
										echo 'N/A';
									}
								} 
								else 
								{
									?>
									<p class="label_value"><?php if (!empty($custom_field_value)) { echo $custom_field_value;} else { echo 'N/A';} ?></p>
									<?php
								}
								?>
							</div>
						<?php
						}
						?>
					</div>
				</div>
			</div>
		<?php
		}
	}
}
?>