<?php
class smgt_document
{
	//ADD DOCUMENT FUNCTION
	public function mj_smgt_add_document($data, $document_data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'smgt_document';


		if ($data['document_for'] == 'student') {
			$documentdata['class_id'] = sanitize_text_field($data['class_id']);
			$documentdata['section_id'] = sanitize_text_field($data['class_section']);
		} else {
			$documentdata['class_id'] = '';
			$documentdata['section_id'] = '';
		}
		$documentdata['student_id'] = sanitize_text_field($data['selected_users']);
		$documentdata['document_for'] = sanitize_text_field($data['document_for']);
		$documentdata['document_content'] = json_encode($document_data);
		$documentdata['description'] = sanitize_textarea_field($data['description']);
		$documentdata['createdby'] = get_current_user_id();
		$documentdata['created_date'] = date('Y-m-d');

		if ($data['action'] == 'edit') {
			school_append_audit_log('' . esc_html__('Update Document Detail', 'school-mgt') . '', null, get_current_user_id(), 'edit', $_REQUEST['page']);
			$whereid['document_id'] = intval($data['document_id']);
			$result = $wpdb->update($table_name, $documentdata, $whereid);
			return $result;
		} else {
			school_append_audit_log('' . esc_html__('Add New Document Detail', 'school-mgt') . '', null, get_current_user_id(), 'insert', $_REQUEST['page']);
			$result = $wpdb->insert($table_name, $documentdata);
			return $result;
		}
	}
	//GET ALL DOCUMENT FUNCTION
	public function mj_smgt_get_all_documents()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'smgt_document';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY created_date DESC"));
		return $result;
	}
	//GET ALL DOCUMENT FUNCTION
	public function mj_smgt_get_own_documents($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'smgt_document';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name where student_id=%d OR createdby=%d ORDER BY created_date DESC", $user_id, $user_id));
		return $result;
	}
	//GET SINGLE DOCUMENT FUNCTION
	public function mj_smgt_get_single_document($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'smgt_document';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name where document_id=%d", $id));
		return $result;
	}

	// DELETE DOCUMENTS
	public function mj_smgt_delete_document($id)
	{
		school_append_audit_log('' . esc_html__('Delete Document Detail', 'school-mgt') . '', null, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		global $wpdb;
		$table_name = $wpdb->prefix . 'smgt_document';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name where document_id=%d", $id));

		return $result;
	}
}
